/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.QMException;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import java.util.Date;

public class DateRangeVerifyItem
extends AbstractVerifyItem
implements IVerifyItem {
    private String msgString = null;
    private KDDatePicker pkReqDateFrom = null;
    private KDDatePicker pkReqDateTo = null;

    public DateRangeVerifyItem(String msgString, KDDatePicker pkReqDateFrom, KDDatePicker pkReqDateTo) {
        this.msgString = msgString;
        this.pkReqDateFrom = pkReqDateFrom;
        this.pkReqDateTo = pkReqDateTo;
        this.initDataChangeListener(pkReqDateFrom, pkReqDateTo);
    }

    private void initDataChangeListener(final KDDatePicker pkReqDateFrom, final KDDatePicker pkReqDateTo) {
        pkReqDateFrom.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                Date from = (Date)pkReqDateFrom.getValue(Date.class);
                Date to = (Date)pkReqDateTo.getValue(Date.class);
                if (from != null && to != null && from.after(to)) {
                    pkReqDateTo.setValue((Object)from);
                }
            }
        });
        pkReqDateTo.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                Date from = (Date)pkReqDateFrom.getValue(Date.class);
                Date to = (Date)pkReqDateTo.getValue(Date.class);
                if (from != null && to != null && from.after(to)) {
                    pkReqDateFrom.setValue((Object)to);
                }
            }
        });
    }

    @Override
    public boolean verify() throws EASBizException, BOSException {
        Date to;
        if (this.pkReqDateFrom.getValue() == null) {
            return true;
        }
        if (this.pkReqDateTo.getValue() == null) {
            return true;
        }
        Date from = (Date)this.pkReqDateFrom.getValue(Date.class);
        if (from.after(to = (Date)this.pkReqDateTo.getValue(Date.class))) {
            throw new QMException(QMException.BLANK, new Object[]{this.msgString});
        }
        return true;
    }
}

