/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.report.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.cssp.client.F7SupplierSimpleSelector;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.qm.common.client.util.QMClientUtils;
import com.kingdee.eas.qm.common.filter.QueryFilterManagerUtils;
import com.kingdee.eas.qm.common.filter.SingleFilterRptElement;
import com.kingdee.eas.qm.common.util.backup.QMGroupClientUtils;
import com.kingdee.eas.qm.report.client.AbstractQCPurSupplierReportFilterUI;
import com.kingdee.eas.qm.report.client.util.QMReportClientUtil;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import org.apache.log4j.Logger;

public class QCPurSupplierReportFilterUI
extends AbstractQCPurSupplierReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(QCPurSupplierReportFilterUI.class);
    private OrgUnitInfo[] mainOrgs = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initF7();
    }

    private void initF7() {
        CtrlUnitInfo orgInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        try {
            QMReportClientUtil.registMaterialF7((Component)((Object)this), this.prmtMaterial, (OrgUnitInfo)orgInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.registSupplier((OrgUnitInfo)this.prmtPurOrgUnit.getData());
    }

    protected void registerFilterManager() {
        super.registerFilterManager();
        CompositeFilterElement elements = (CompositeFilterElement)this.getFilterManager().getElement();
        elements.add((FilterElement)new SingleFilterRptElement("PurOrgUnit", (Component)this.prmtPurOrgUnit));
        elements.add((FilterElement)new SingleFilterRptElement("Supplier", (Component)this.prmtSupplier));
        elements.add((FilterElement)new SingleFilterRptElement("Material", (Component)this.prmtMaterial));
        SingleFilterElement elementPkReqDateFrom = new SingleFilterElement("ReqDateFrom", (Component)this.pkReqDateFrom);
        elementPkReqDateFrom.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.qm.report.QCPurSupplierReportResource", (String)"ReqDateFrom_Is_Null")));
        SingleFilterElement elementPkReqDateTo = new SingleFilterElement("ReqDateTo", (Component)this.pkReqDateTo);
        elementPkReqDateTo.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.qm.report.QCPurSupplierReportResource", (String)"ReqDateTo_Is_Null")));
        elementPkReqDateFrom.setDefaultValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        elementPkReqDateTo.setDefaultValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        elements.add((FilterElement)elementPkReqDateFrom);
        elements.add((FilterElement)elementPkReqDateTo);
    }

    protected String getViewPermission() {
        return "qm_QCPurSupplierReportView";
    }

    protected void initListener() {
        super.initListener();
        this.prmtQualityOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                QCPurSupplierReportFilterUI.this.qualityOrgChange(eventObj);
            }
        });
        this.prmtPurOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                OrgUnitInfo purOrtUnit = (OrgUnitInfo)eventObj.getNewValue();
                QCPurSupplierReportFilterUI.this.registSupplier(purOrtUnit);
            }
        });
    }

    protected void registSupplier(OrgUnitInfo purOrtUnit) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (purOrtUnit == null) {
            filter.getFilterItems().add(new FilterItemInfo("id", null));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)("select FSupplierID from T_BD_SupplierPurchaseInfo where FPurchaseOrgID='" + purOrtUnit.getId().toString() + "'"), CompareType.INNER));
        }
        ev.setFilter(filter);
        F7SupplierSimpleSelector selector = new F7SupplierSimpleSelector((Object)this, this.prmtSupplier);
        selector.setBaseFilter(filter);
        this.prmtSupplier.setSelector((KDPromptSelector)selector);
        this.prmtSupplier.setEntityViewInfo(ev);
        if (!this.isChangeSolution()) {
            this.prmtSupplier.setData(null);
        }
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.setChangeSolution(true);
        super.loadData(entityViewInfo);
        try {
            IObjectValue info;
            String numbers = this.transformNumberArray(this.prmtPurOrgUnit);
            if (numbers != null) {
                info = QMGroupClientUtils.getObjectValue((String)numbers);
                QueryFilterManagerUtils.setData((Component)this.prmtPurOrgUnit, (Object)info);
            }
            if ((numbers = this.transformNumberArray(this.prmtSupplier)) != null) {
                info = QMGroupClientUtils.getObjectValue((String)numbers);
                QueryFilterManagerUtils.setData((Component)this.prmtSupplier, (Object)info);
            }
            if ((numbers = this.transformNumberArray(this.prmtMaterial)) != null) {
                info = QMGroupClientUtils.getObjectValue((String)numbers);
                QueryFilterManagerUtils.setData((Component)this.prmtMaterial, (Object)info);
            }
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        this.setChangeSolution(false);
    }

    private void qualityOrgChange(DataChangeEvent e) {
        if (e == null) {
            return;
        }
        Object o = e.getNewValue();
        OrgUnitCollection orgUnits = new OrgUnitCollection();
        if (o != null) {
            if (o instanceof OrgUnitInfo) {
                orgUnits.add((OrgUnitInfo)o);
            } else if (o instanceof Object[]) {
                Object[] quInfos = (Object[])o;
                int length = quInfos.length;
                for (int i = 0; i < length; ++i) {
                    orgUnits.add((OrgUnitInfo)quInfos[i]);
                }
            }
        }
        this.prmtPurOrgUnit.setEntityViewInfo(QMClientUtils.getDelegateEntityViewInfo((OrgUnitCollection)orgUnits, (OrgType)OrgType.Purchase, (OrgType)OrgType.Quality, (boolean)false));
        if (!this.isChangeSolution()) {
            this.prmtPurOrgUnit.setData(null);
        }
    }

    public boolean verify() {
        Date from = (Date)this.pkReqDateFrom.getValue();
        Date to = (Date)this.pkReqDateTo.getValue();
        if (from != null && to != null && from.after(to)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.qm.report.QCPurSupplierReportResource", (String)"StartDate_Cannot_After_EndDate"));
            return false;
        }
        return super.verify();
    }
}

