/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.qm.basedata.QCPlanAcceptStandardInfo;
import com.kingdee.eas.qm.report.IQCSampleCodeTableFacade;
import com.kingdee.eas.qm.report.QCSampleCodeTableFacadeFactory;
import com.kingdee.eas.qm.report.client.AbstractQCSampleCodeTableListUI;
import com.kingdee.eas.qm.report.client.QCSampleCodeTableEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Map;

public class QCSampleCodeTableListUI
extends AbstractQCSampleCodeTableListUI {
    public static final String[][] BATCH_AND_CODE = new String[][]{{"8", "A", "A", "A", "A", "A", "A", "B"}, {"15", "A", "A", "A", "A", "A", "B", "C"}, {"25", "A", "A", "B", "B", "B", "C", "D"}, {"50", "A", "B", "B", "C", "C", "D", "E"}, {"90", "B", "B", "C", "C", "C", "E", "F"}, {"150", "B", "B", "C", "D", "D", "F", "G"}, {"280", "B", "C", "D", "E", "E", "G", "H"}, {"500", "B", "C", "D", "E", "F", "H", "J"}, {"1200", "C", "C", "E", "F", "G", "J", "K"}, {"3200", "C", "D", "E", "G", "H", "K", "L"}, {"10000", "C", "D", "F", "G", "J", "L", "M"}, {"35000", "C", "D", "F", "H", "K", "M", "N"}, {"150000", "D", "E", "G", "J", "L", "N", "P"}, {"500000", "D", "E", "G", "J", "M", "P", "Q"}, {"999999999", "D", "E", "H", "K", "N", "Q", "R"}};
    private static final String TABLE_HEAD_BATCH = "batch";
    private static final String TABLE_HEAD_LEVEL1 = "level1";
    private static final String TABLE_HEAD_LEVEL2 = "level2";
    private static final String TABLE_HEAD_LEVEL3 = "level3";
    private static final String TABLE_HEAD_LEVEL4 = "level4";
    private static final String TABLE_HEAD_LEVEL5 = "level5";
    private static final String TABLE_HEAD_LEVEL6 = "level6";
    private static final String TABLE_HEAD_LEVEL7 = "level7";
    private static final int WIDTH_INT = 90;
    private static final int WIDTH_CODE = 42;
    protected static final String PROP_FILE = "com.kingdee.eas.qm.report.QCSampleCodeTableResource";

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return QCSampleCodeTableEditUI.class.getName();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTable();
        this.initTableStyle();
        this.actionAcceptStandardLocal.setEnabled(true);
        this.actionPrint.setEnabled(true);
        this.actionPrintPreview.setEnabled(true);
        String op = this.getLogActionName(EASResource.getString((String)PROP_FILE, (String)"VIEW"));
        IObjectPK pk = LogUtil.beginLog(null, (String)op, (BOSObjectType)new BOSObjectType("CE4FCE63"), null, (String)op);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAcceptStandardLocal.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_seechecklist"));
    }

    private void initTableStyle() throws Exception {
        this.tblMain.getColumn(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getSelectManager().setSelectMode(1);
    }

    private void initTable() throws Exception {
        this.tblMain.getHeadMergeManager().setMergeMode(3);
        this.tblMain.removeHeadRows();
        this.tblMain.addHeadRows(2);
        IColumn curCol = null;
        curCol = this.tblMain.addColumn();
        curCol.setKey(TABLE_HEAD_BATCH);
        curCol.setWidth(90);
        this.tblMain.getHeadRow(0).getCell(TABLE_HEAD_BATCH).setValue((Object)EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_BATCH_NAME"));
        this.tblMain.getHeadRow(1).getCell(TABLE_HEAD_BATCH).setValue((Object)EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_BATCH_NAME"));
        curCol = this.tblMain.addColumn();
        curCol.setKey(TABLE_HEAD_LEVEL1);
        curCol.setWidth(42);
        this.tblMain.getHeadRow(0).getCell(TABLE_HEAD_LEVEL1).setValue((Object)EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_SPECIAL_NAME"));
        this.tblMain.getHeadRow(1).getCell(TABLE_HEAD_LEVEL1).setValue((Object)EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_LEVEL1_NAME"));
        curCol = this.tblMain.addColumn();
        curCol.setKey(TABLE_HEAD_LEVEL2);
        this.tblMain.getHeadRow(0).getCell(TABLE_HEAD_LEVEL2).setValue((Object)EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_SPECIAL_NAME"));
        this.tblMain.getHeadRow(1).getCell(TABLE_HEAD_LEVEL2).setValue((Object)EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_LEVEL2_NAME"));
        curCol.setWidth(42);
        curCol = this.tblMain.addColumn();
        curCol.setKey(TABLE_HEAD_LEVEL3);
        this.tblMain.getHeadRow(0).getCell(TABLE_HEAD_LEVEL3).setValue((Object)EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_SPECIAL_NAME"));
        this.tblMain.getHeadRow(1).getCell(TABLE_HEAD_LEVEL3).setValue((Object)EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_LEVEL3_NAME"));
        curCol.setWidth(42);
        curCol = this.tblMain.addColumn();
        curCol.setKey(TABLE_HEAD_LEVEL4);
        this.tblMain.getHeadRow(0).getCell(TABLE_HEAD_LEVEL4).setValue((Object)EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_SPECIAL_NAME"));
        this.tblMain.getHeadRow(1).getCell(TABLE_HEAD_LEVEL4).setValue((Object)EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_LEVEL4_NAME"));
        curCol.setWidth(42);
        curCol = this.tblMain.addColumn();
        curCol.setKey(TABLE_HEAD_LEVEL5);
        this.tblMain.getHeadRow(0).getCell(TABLE_HEAD_LEVEL5).setValue((Object)EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_NORMAL_NAME"));
        this.tblMain.getHeadRow(1).getCell(TABLE_HEAD_LEVEL5).setValue((Object)EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_LEVEL5_NAME"));
        curCol.setWidth(42);
        curCol = this.tblMain.addColumn();
        curCol.setKey(TABLE_HEAD_LEVEL6);
        this.tblMain.getHeadRow(0).getCell(TABLE_HEAD_LEVEL6).setValue((Object)EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_NORMAL_NAME"));
        this.tblMain.getHeadRow(1).getCell(TABLE_HEAD_LEVEL6).setValue((Object)EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_LEVEL6_NAME"));
        curCol.setWidth(42);
        curCol = this.tblMain.addColumn();
        curCol.setKey(TABLE_HEAD_LEVEL7);
        this.tblMain.getHeadRow(0).getCell(TABLE_HEAD_LEVEL7).setValue((Object)EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_NORMAL_NAME"));
        this.tblMain.getHeadRow(1).getCell(TABLE_HEAD_LEVEL7).setValue((Object)EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_LEVEL7_NAME"));
        curCol.setWidth(42);
        for (int i = 0; i < BATCH_AND_CODE.length; ++i) {
            this.tblMain.addRow();
            for (int k = 0; k < BATCH_AND_CODE[i].length; ++k) {
                this.tblMain.getRow(i).getCell(k + 1).setValue((Object)BATCH_AND_CODE[i][k]);
            }
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            if (e.getRowIndex() < 0 || e.getColIndex() < 2) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)PROP_FILE, (String)"MUST_SELECT_CODECELL"));
                SysUtil.abort();
            }
            this.acceptStandardLocal(e.getRowIndex(), e.getColIndex());
        }
    }

    private void acceptStandardLocal(int rowIndex, int colIndex) throws BOSException {
        ICell cell = this.tblMain.getRow(rowIndex).getCell(colIndex);
        String sampleCode = cell.getValue().toString();
        cell = this.tblMain.getRow(rowIndex).getCell(TABLE_HEAD_BATCH);
        BigDecimal batch = new BigDecimal(cell.getValue().toString());
        cell = this.tblMain.getHeadRow(1).getCell(colIndex);
        int inspectionLevel = this.getCheckLevel(cell.getValue().toString());
        IQCSampleCodeTableFacade sampleCodeTableFacade = QCSampleCodeTableFacadeFactory.getRemoteInstance();
        Map map = sampleCodeTableFacade.getAcceptStandardOfPlan(inspectionLevel, batch, sampleCode);
        this.getUIContext().put("InitDataObject", new QCPlanAcceptStandardInfo());
        this.getUIContext().put("CodeTableMap", map);
        IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), this.getUIContext());
        ui.show();
    }

    @Override
    public void actionAcceptStandardLocal_actionPerformed(ActionEvent e) throws Exception {
        int indexRow = this.tblMain.getSelectManager().getActiveRowIndex();
        int indexCol = this.tblMain.getSelectManager().getActiveColumnIndex();
        if (indexRow < 0 || indexCol < 2) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)PROP_FILE, (String)"MUST_SELECT_CODECELL"));
            SysUtil.abort();
        }
        this.acceptStandardLocal(indexRow, indexCol);
    }

    private int getCheckLevel(String checkLevel) {
        if (EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_LEVEL1_NAME").equals(checkLevel)) {
            return 4;
        }
        if (EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_LEVEL2_NAME").equals(checkLevel)) {
            return 5;
        }
        if (EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_LEVEL3_NAME").equals(checkLevel)) {
            return 6;
        }
        if (EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_LEVEL4_NAME").equals(checkLevel)) {
            return 7;
        }
        if (EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_LEVEL5_NAME").equals(checkLevel)) {
            return 1;
        }
        if (EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_LEVEL6_NAME").equals(checkLevel)) {
            return 2;
        }
        if (EASResource.getString((String)PROP_FILE, (String)"TABLE_HEAD_LEVEL7_NAME").equals(checkLevel)) {
            return 3;
        }
        return -1;
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        String op = this.getLogActionName(this.menuItemPrint.getText());
        IObjectPK pk = LogUtil.beginLog(null, (String)op, (BOSObjectType)new BOSObjectType("CE4FCE63"), null, (String)op);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    private String getLogActionName(String oprName) {
        String op = null;
        int pos = oprName.indexOf(40);
        op = pos >= 0 ? oprName.substring(0, pos) : oprName;
        String msg = EASResource.getString((String)PROP_FILE, (String)"ALIAS");
        MessageFormat mf = new MessageFormat(msg);
        op = mf.format(new String[]{op});
        return op;
    }

    protected void initContextOrg() {
        if (this.getMainBizOrgType() != null) {
            this.getUIContext().put(this.getMainBizOrgType(), SysContext.getSysContext().getCurrentOrgUnit());
            OrgUnitInfo org = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
            if (org != null && org.getId() != null) {
                this.initUIMainOrgContext(org.getId().toString());
            }
        }
    }
}

