/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.sm.pur.b2b.BuyOfferStatusEnum;
import com.kingdee.eas.scm.sm.pur.b2b.QuotationStatusEnum;
import com.kingdee.eas.scm.sm.pur.b2b.client.AbstractBuyOfferManagerConditionUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class BuyOfferManagerConditionUI
extends AbstractBuyOfferManagerConditionUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BuyOfferManagerConditionUI.class);
    private static final String C_ID = "id";
    private static final String C_COMPORG = "comOrg";
    private static final String C_TITLE = "title";
    private static final String C_GMTDATE_FROM = "gmtDateFROM";
    private static final String C_GMTDATE_TO = "gmtDateTo";
    private static final String C_STATUS = "status";
    private static final String C_QUO_STATUS = "quoStatus";
    private static final String C_EXCEPTION = "exception";
    private static final String resClassName = "com.kingdee.eas.scm.sm.report.SMReportResource";
    private SCMRptMultiOrgsF7 f7;

    public BuyOfferManagerConditionUI() throws Exception {
        this.f7 = new SCMRptMultiOrgsF7(this.prmtComOrg, OrgType.Company, EASResource.getString((String)resClassName, (String)"CompanyOrgUnitMutilF7"));
        this.f7.setPermItemName(this.getViewPermission());
        this.f7.setUseCache(true);
        this.f7.setNeedWait4UIOpen(false);
        this.prmtComOrg.setCommitFormat("$number");
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onInit(RptParams initParams) throws Exception {
        this.initFilter();
    }

    public RptParams getCustomCondition() {
        RptParams params = new RptParams();
        params.setString(C_ID, this.txtBuyId.getText());
        params.setString(C_TITLE, this.txtBuyTitle.getText());
        params.setObject(C_GMTDATE_FROM, this.pkGmtDateFrom.getValue());
        params.setObject(C_GMTDATE_TO, this.pkGmtDateTo.getValue());
        params.setObject(C_STATUS, this.comboStatus.getSelectedItem());
        params.setObject(C_QUO_STATUS, this.comboQuoStatus.getSelectedItem());
        params.setObject(C_COMPORG, this.prmtComOrg.getValue());
        return params;
    }

    public void setCustomCondition(RptParams params) {
        this.txtBuyId.setText(params.getString(C_ID));
        this.txtBuyTitle.setText(params.getString(C_TITLE));
        this.pkGmtDateFrom.setValue(params.getObject(C_GMTDATE_FROM));
        this.pkGmtDateTo.setValue(params.getObject(C_GMTDATE_TO));
        this.comboStatus.setSelectedItem(params.getObject(C_STATUS));
        this.comboQuoStatus.setSelectedItem(params.getObject(C_QUO_STATUS));
        this.prmtComOrg.setValue(params.getObject(C_COMPORG));
    }

    public void clear() {
        super.clear();
        this.initFilter();
    }

    public boolean verify() {
        Date dateStart = (Date)this.pkGmtDateFrom.getValue();
        Date dateEnd = (Date)this.pkGmtDateTo.getValue();
        if (dateStart == null || dateEnd == null) {
            MsgBox.showWarning((String)"\u65e5\u671f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (dateStart.compareTo(dateEnd) > 0) {
            MsgBox.showWarning((String)"\u8d77\u59cb\u65f6\u95f4\u4e0d\u53ef\u5927\u4e8e\u7ec8\u6b62\u65f6\u95f4");
            return false;
        }
        return true;
    }

    protected String getViewPermission() {
        String viewPermission = "buyOfferManager_view";
        return viewPermission;
    }

    private void initFilter() {
        Calendar calendar = Calendar.getInstance();
        Date dateEnd = new Date();
        dateEnd.setTime(calendar.getTimeInMillis());
        Date dateStart = new Date();
        calendar.add(2, -1);
        dateStart.setTime(calendar.getTimeInMillis());
        this.pkGmtDateFrom.setValue((Object)dateStart);
        this.pkGmtDateTo.setValue((Object)dateEnd);
        this.txtBuyId.setText(null);
        this.txtBuyTitle.setText(null);
        this.pkGmtDateFrom.setValue((Object)dateStart);
        this.pkGmtDateTo.setValue((Object)dateEnd);
        this.comboStatus.setSelectedItem((Object)BuyOfferStatusEnum.NONE);
        this.comboQuoStatus.setSelectedItem((Object)QuotationStatusEnum.NONE);
    }
}

