/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.framework.openapi.PurCloudClient;
import com.kingdee.eas.scm.sm.pur.b2b.BuyOfferManagerFacadeFactory;
import com.kingdee.eas.scm.sm.pur.b2b.IPurCloudService;
import com.kingdee.eas.scm.sm.pur.b2b.PurCloudServiceFactory;
import com.kingdee.eas.scm.sm.pur.b2b.client.AbstractBuyOfferManagerRptUI;
import com.kingdee.eas.scm.sm.pur.b2b.client.BuyOfferManagerConditionUI;
import com.kingdee.eas.scm.sm.pur.b2b.client.QuotationUI;
import com.kingdee.eas.scm.sm.pur.client.PurOrderListUI;
import com.kingdee.eas.scm.sm.pur.client.PurRequestListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BuyOfferManagerRptUI
extends AbstractBuyOfferManagerRptUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BuyOfferManagerRptUI.class);
    private static final String CL_ID = "buyId";
    private static final String CL_COMID = "companyId";
    private KDTMouseListener tbMainListener = null;
    private RptParams tempFilterParam = new RptParams();
    private String companyId = null;

    public BuyOfferManagerRptUI() throws Exception {
        this.tbMain.checkParsed();
        this.tbMain.getMergeManager().setDataMode(3);
        this.enableExportExcel(this.tbMain);
        this.tbMain.setEnabled(false);
        this.tbMainListener = new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    BuyOfferManagerRptUI.this.actionShowBuyOfferInfo(e);
                }
            }
        };
        this.tbMain.addKDTMouseListener(this.tbMainListener);
        this.tbMain.getColumn("gmtDate").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tbMain.getColumn("quotationExpire").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return BuyOfferManagerFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tbMain;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return new BuyOfferManagerConditionUI();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnShowPurReq.setVisible(true);
        this.btnShowPurReq.setEnabled(true);
        this.btnShowPurOrder.setVisible(true);
        this.btnShowPurOrder.setEnabled(true);
        this.btnShowQuotaion.setVisible(true);
        this.btnShowQuotaion.setEnabled(true);
        this.btnOpenBuyManger.setVisible(true);
        this.btnOpenBuyManger.setEnabled(true);
        this.btnTempSearch.setEnabled(true);
    }

    protected void query() {
        this.tempFilterParam.clear();
        this.initTempFilter();
        this.tbMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tbMain.removeRows();
        this.initUserConfig();
    }

    public void getData(KDTDataRequestEvent e) {
        try {
            RptParams rpt;
            this.tbMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
            RptParams para = new RptParams();
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            if (from == 0) {
                para.setString("tempTable", this.getTempTable());
                para.setString(CL_COMID, SysContext.getSysContext().getCurrentFIUnit().getId().toString());
                para.putAll(this.params.toMap());
                para.putAll(this.tempFilterParam.toMap());
                rpt = BuyOfferManagerFacadeFactory.getRemoteInstance().createTempTable(para);
                this.setTempTable(rpt.getString("tempTable"));
                this.tbMain.setRowCount(rpt.getInt("RowCount"));
                logger.info((Object)("\u8be2\u4ef7\u7ba1\u7406\u62a5\u8868--\u672c\u6b21\u67e5\u8be2\u4f7f\u7528\u7684\u4e34\u65f6\u8868\u540d\u4e3a: " + rpt.getString("tempTable")));
            }
            para.setString("tempTable", this.getTempTable());
            rpt = BuyOfferManagerFacadeFactory.getRemoteInstance().query(para);
            RptRowSet rs = (RptRowSet)rpt.getObject("rowSet");
            KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.tbMain);
            if (rs.getRowCount() > 0) {
                this.tbMain.getSelectManager().select(0, 0);
            }
        }
        catch (Exception ee) {
            this.handleException(ee);
        }
    }

    private void actionShowBuyOfferInfo(KDTMouseEvent e) {
        String[] buyIds = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tbMain, (String)CL_ID);
        ArrayList<String> buyIdList = new ArrayList<String>();
        for (int i = 0; i < buyIds.length; ++i) {
            buyIdList.add(buyIds[i]);
        }
        try {
            HashMap<String, ArrayList<String>> uiContext = new HashMap<String, ArrayList<String>>();
            uiContext.put("BUYOFFERS", buyIdList);
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(QuotationUI.class.getName(), uiContext);
            window.show();
        }
        catch (Exception ee) {
            this.handleException(ee);
        }
    }

    @Override
    public void actionShowQuotaion_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] buyIds = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tbMain, (String)CL_ID);
        ArrayList<String> buyIdList = new ArrayList<String>();
        for (int i = 0; i < buyIds.length; ++i) {
            buyIdList.add(buyIds[i]);
        }
        HashMap<String, ArrayList<String>> uiContext = new HashMap<String, ArrayList<String>>();
        uiContext.put("BUYOFFERS", buyIdList);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(QuotationUI.class.getName(), uiContext);
        window.show();
    }

    @Override
    public void actionShowPurRequest_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] buyIds = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tbMain, (String)CL_ID);
        String buyId = buyIds[0];
        HashMap<String, Integer> uiContext = new HashMap<String, Integer>();
        uiContext.put("BOTPViewStatus", 1);
        uiContext.put("BOTPFilter", (Integer)this.getEntityViewByBuyOfferId("entries.netBuyOfferItemId", buyId, null));
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
        IUIWindow window = uiFactory.create(PurRequestListUI.class.getName(), uiContext, null);
        window.show();
    }

    @Override
    public void actionShowPurOrder_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] orderIds = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tbMain, (String)"easOrderId");
        String[] companyIds = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tbMain, (String)CL_COMID);
        if (orderIds == null) {
            MsgBox.showInfo((String)"\u8be5\u8be2\u4ef7\u5355\u8fd8\u672a\u751f\u6210EAS\u91c7\u8d2d\u8ba2\u5355\uff0c\u65e0\u6cd5\u8054\u67e5\u8ba2\u5355");
            SysUtil.abort();
        }
        if (companyIds == null) {
            MsgBox.showError((String)"\u6ca1\u6709\u627e\u5230\u5f53\u524d\u8d22\u52a1\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u6253\u5f001688\u8be2\u4ef7\u7ba1\u7406\u754c\u9762");
            SysUtil.abort();
        }
        this.companyId = companyIds[0];
        String orderId = orderIds[0];
        logger.error((Object)("\u8054\u67e5\u8ba2\u5355id\uff1a" + orderId));
        HashMap<String, Object> uiContext = new HashMap<String, Object>();
        uiContext.put("BOTPViewStatus", 1);
        uiContext.put("BOTPFilter", this.getEntityViewByBuyOfferId("id", orderId, null));
        uiContext.put("EAS_UI_NOPERMISSION_ABORT", false);
        if (this.getUIContext() != null) {
            uiContext.put("BTPNAVCTX", this.getUIContext());
        }
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
        IUIWindow window = uiFactory.create(PurOrderListUI.class.getName(), uiContext, null);
        window.show();
    }

    @Override
    public void actionOpenWebBuyManager_actionPerformed(ActionEvent e) throws Exception {
        IPurCloudService iPurCloudService;
        Map param;
        this.checkSelected();
        String[] companyIds = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tbMain, (String)CL_COMID);
        this.companyId = null;
        if (companyIds == null) {
            MsgBox.showError((String)"\u6ca1\u6709\u627e\u5230\u5f53\u524d\u8d22\u52a1\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u6253\u5f001688\u8be2\u4ef7\u7ba1\u7406\u754c\u9762");
            SysUtil.abort();
        }
        this.companyId = companyIds[0];
        if (this.companyId == null) {
            MsgBox.showError((String)"\u6ca1\u6709\u627e\u5230\u5f53\u524d\u8d22\u52a1\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u6253\u5f001688\u8be2\u4ef7\u7ba1\u7406\u754c\u9762");
            SysUtil.abort();
        }
        if ((param = (iPurCloudService = PurCloudServiceFactory.getRemoteInstance()).getAutoLoginParam(this.companyId, PurCloudClient.TargetUrlEnum.BUYOFFER_MANAGEMENT.toString(), null)) == null) {
            MsgBox.showError((String)"\u6240\u9009\u8d22\u52a1\u7ec4\u7ec7\u65e0\u6cd5\u6253\u5f00\u8be2\u4ef7\u7ba1\u7406\u754c\u9762");
            SysUtil.abort();
        }
        String url = (String)param.get("url");
        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
    }

    @Override
    public void actionTempSearch_actionPerformed(ActionEvent e) throws Exception {
        Date dateStart = (Date)this.pkGmtDateFrom.getValue();
        Date dateEnd = (Date)this.pkGmtDateTo.getValue();
        if (dateStart == null || dateEnd == null) {
            MsgBox.showWarning((String)"\u8be2\u4ef7\u65e5\u671f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            SysUtil.abort();
        }
        if (dateStart.compareTo(dateEnd) > 0) {
            MsgBox.showWarning((String)"\u8be2\u4ef7\u65e5\u671f\u8d77\u59cb\u65e5\u671f\u4e0d\u53ef\u5927\u4e8e\u7ec8\u6b62\u65e5\u671f");
        }
        this.tempFilterParam.clear();
        this.tempFilterParam.setString("title", this.txtBuyTitle.getText());
        this.tempFilterParam.setObject("gmtDateFROM", this.pkGmtDateFrom.getValue());
        this.tempFilterParam.setObject("gmtDateTo", this.pkGmtDateTo.getValue());
        this.tbMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tbMain.removeRows();
        this.initUserConfig();
    }

    private void checkSelected() {
        if (this.tbMain.getRowCount() == 0 || this.tbMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private EntityViewInfo getEntityViewByBuyOfferId(String key, String value, SelectorItemCollection selector) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(key, (Object)value, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        if (selector != null) {
            viewInfo.setSelector(selector);
        }
        return viewInfo;
    }

    private void initTempFilter() {
        this.txtBuyTitle.setText(this.params.getString("title"));
        this.pkGmtDateFrom.setValue(this.params.getObject("gmtDateFROM"));
        this.pkGmtDateTo.setValue(this.params.getObject("gmtDateTo"));
    }
}

