/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.client;

import com.kingdee.eas.scm.framework.openapi.PurCloudClient;
import com.kingdee.eas.scm.sm.pur.b2b.IPurCloudService;
import com.kingdee.eas.scm.sm.pur.b2b.PurCloudServiceFactory;
import com.kingdee.eas.scm.sm.pur.b2b.client.IStatusChangeListener;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import org.apache.log4j.Logger;
import org.jdesktop.jdic.browser.BrowserEngineManager;
import org.jdesktop.jdic.browser.IWebBrowser;
import org.jdesktop.jdic.browser.WebBrowserEvent;
import org.jdesktop.jdic.browser.WebBrowserListener;
import org.jdesktop.jdic.browser.WebBrowserListenerAdapter;

public class PurCloudBrowser
extends JPanel {
    private static final long serialVersionUID = 4447866023728150850L;
    private static final Logger logger = Logger.getLogger(PurCloudBrowser.class);
    private IWebBrowser webBrowser;
    private PurCloudClient.TargetUrlEnum targetUrl;
    private String companyId;
    private Map<String, Object> params;
    private List<IStatusChangeListener> statusListeners;

    public PurCloudBrowser(PurCloudClient.TargetUrlEnum targetUrl, String companyId, Map<String, Object> params) throws Exception {
        this.targetUrl = targetUrl;
        this.companyId = companyId;
        this.params = params;
        this.statusListeners = new ArrayList<IStatusChangeListener>();
        this.jbInit();
    }

    public void open() throws Exception {
        String webContent = this.getInterface().getAutoLoginWebContent(this.companyId, this.targetUrl.toString(), this.params);
        logger.debug((Object)webContent);
        this.webBrowser.setContent(webContent);
    }

    public void refresh() {
        this.webBrowser.refresh();
    }

    public void back() {
        this.webBrowser.back();
    }

    public void forward() {
        this.webBrowser.forward();
    }

    public void stop() {
        this.webBrowser.stop();
    }

    public boolean isBackEnabled() {
        return this.webBrowser.isBackEnabled();
    }

    public boolean isForwardEnabled() {
        return this.webBrowser.isForwardEnabled();
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(new Dimension(screenSize.width * 9 / 10, screenSize.height * 8 / 10));
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(true);
        BrowserEngineManager bem = BrowserEngineManager.instance();
        if (bem.getActiveEngine() == null) {
            bem.setActiveEngine(BrowserEngineManager.IE);
        }
        this.webBrowser = bem.getActiveEngine().getWebBrowser();
        this.webBrowser.addWebBrowserListener((WebBrowserListener)new WebBrowserListenerAdapter(){

            public void statusTextChange(WebBrowserEvent event) {
                PurCloudBrowser.this.fireStatusChanged(event);
            }

            public void downloadCompleted(WebBrowserEvent event) {
                PurCloudBrowser.this.fireDownloadCompleted(event);
            }
        });
        this.add(this.webBrowser.asComponent(), "Center");
    }

    protected IPurCloudService getInterface() throws Exception {
        return PurCloudServiceFactory.getRemoteInstance();
    }

    public void addStatusListener(IStatusChangeListener listener) {
        if (listener != null) {
            this.statusListeners.add(listener);
        }
    }

    private void fireStatusChanged(WebBrowserEvent event) {
        for (IStatusChangeListener listener : this.statusListeners) {
            listener.statusChanged(event);
        }
    }

    private void fireDownloadCompleted(WebBrowserEvent event) {
        for (IStatusChangeListener listener : this.statusListeners) {
            listener.downloadCompleted(event);
        }
    }
}

