/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.b2b.MaterialPermissionFactory;
import com.kingdee.eas.scm.sm.pur.b2b.model.QuotationInfo;
import com.kingdee.eas.scm.sm.pur.b2b.model.QuotationItem;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurCloudClientHelper {
    private static final Logger logger = Logger.getLogger(PurCloudClientHelper.class);

    private PurCloudClientHelper() {
    }

    public static Map<String, Object> getPostBuyOfferParams(PurRequestEntryCollection entries) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", PurCloudClientHelper.buildRequestData(entries));
        logger.debug(params.get("data"));
        return params;
    }

    public static String buildRequestData(PurRequestEntryCollection entries) throws JSONException, EASBizException, BOSException {
        JSONObject jsonObject = new JSONObject();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        if (userInfo.getPerson() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(userInfo.getPerson().getId().toString());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("officePhone");
            sic.add("cell");
            PersonInfo person = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)pk, sic);
            jsonObject.put("phone", (Object)person.getOfficePhone());
        } else {
            jsonObject.put("phone", (Object)userInfo.getOfficePhone());
        }
        jsonObject.put("contact", (Object)userInfo.getName());
        jsonObject.put("description", (Object)"");
        jsonObject.put("prId", System.currentTimeMillis());
        jsonObject.put("canEditSubject", true);
        jsonObject.put("canEditItemSubject", true);
        jsonObject.put("canEditItemAmount", false);
        PurRequestEntryInfo entry = null;
        JSONArray entryArray = new JSONArray();
        String title = null;
        for (int i = 0; i < entries.size(); ++i) {
            entry = entries.get(i);
            JSONObject entryObject = new JSONObject();
            if (entry.getMaterial() == null) {
                entryObject.put("subject", (Object)entry.getMaterialName());
                if (title == null) {
                    title = entry.getMaterialName();
                }
                entryObject.put("productCode", (Object)"");
            } else {
                entryObject.put("subject", (Object)entry.getMaterial().getName());
                if (title == null) {
                    title = entry.getMaterialName();
                }
                entryObject.put("productCode", (Object)entry.getMaterial().getNumber());
            }
            entryObject.put("desc", (Object)PurCloudClientHelper.buildProductDesc(entry));
            if (entry.getUnit() != null) {
                entryObject.put("unit", (Object)entry.getUnit().getName());
            }
            entryObject.put("purchaseAmount", Math.round(entry.getQty().doubleValue()));
            String prItemId = entry.getId().toString().toString().replace("+", "&");
            entryObject.put("prItemId", (Object)prItemId);
            entryArray.put((Object)entryObject);
        }
        if (title != null) {
            jsonObject.put("subject", title);
        }
        jsonObject.put("items", (Object)entryArray);
        return jsonObject.toString();
    }

    public static Map<String, Object> getPostOrderData(QuotationInfo quoInfo) throws JSONException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", PurCloudClientHelper.buildPostOrderData(quoInfo));
        logger.debug(params.get("data"));
        return params;
    }

    public static String buildPostOrderData(QuotationInfo quoInfo) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("quotationId", quoInfo.getId());
        JSONArray entryArray = new JSONArray();
        for (int i = 0; i < quoInfo.getSupplyNoteItems().size(); ++i) {
            QuotationItem item = quoInfo.getSupplyNoteItems().getItem(i);
            JSONObject entryObject = new JSONObject();
            entryObject.put("productQuoteId", (Object)item.getId());
            entryObject.put("amount", item.getAmount());
            entryArray.put((Object)entryObject);
        }
        jsonObject.put("orderItems", (Object)entryArray);
        return jsonObject.toString();
    }

    public static String buildProductDesc(PurRequestEntryInfo entry) {
        StringBuilder desc = new StringBuilder();
        if (entry.getMaterial() != null && entry.getMaterial().getModel() != null) {
            desc.append("\u89c4\u683c\u578b\u53f7\uff1a" + entry.getMaterial().getModel()).append("\r\n");
        } else if (entry.getNoNumMaterialModel() != null) {
            desc.append("\u89c4\u683c\u578b\u53f7\uff1a" + entry.getNoNumMaterialModel()).append("\r\n");
        }
        if (entry.getAssistProperty() != null) {
            if (entry.getMaterial() != null && entry.getMaterial().getAssistAttr() != null) {
                desc.append(entry.getMaterial().getAssistAttr().getName() + "\uff1a" + entry.getAssistProperty().getName()).append("\r\n");
            } else {
                desc.append("\u8f85\u52a9\u5c5e\u6027\uff1a" + entry.getAssistProperty().getName()).append("\r\n");
            }
        }
        if (entry.getRemark() != null) {
            desc.append("\u5907\u6ce8\u8bf4\u660e\uff1a" + entry.getRemark());
        }
        return desc.toString();
    }

    public static void checkMaterialPermission(Component comp, PurRequestEntryCollection entries) throws BOSException {
        ArrayList<String> materialList = new ArrayList<String>();
        HashMap<String, String> materialMap = new HashMap<String, String>();
        PurRequestEntryInfo entry = null;
        for (int i = 0; i < entries.size(); ++i) {
            entry = entries.get(i);
            if (entry.getMaterial() == null || materialList.contains(entry.getMaterial().getId().toString())) continue;
            materialList.add(entry.getMaterial().getId().toString());
            materialMap.put(entry.getMaterial().getId().toString(), entry.getMaterial().getName());
        }
        List result = MaterialPermissionFactory.getRemoteInstance().checkPermission(materialList);
        if (result.size() > 0) {
            StringBuilder errorMsg = new StringBuilder("\u5982\u4e0b\u7269\u6599\uff1a\n");
            for (int i = 0; i < result.size(); ++i) {
                errorMsg.append((String)materialMap.get(result.get(i))).append("\n");
            }
            errorMsg.append("\u6ca1\u6709\u8fdb\u884c\u7f51\u7edc\u8be2\u4ef7\u6743\u9650\uff01");
            MsgBox.showDetailAndOK((Component)comp, (String)"\u53d1\u5e03\u8be2\u4ef7\u5931\u8d25\uff01", (String)errorMsg.toString(), (int)2);
            SysUtil.abort();
        }
    }

    public static void checkPurReqEntryPostBuyOffer(PurRequestEntryCollection entries) {
        PurRequestEntryInfo entryInfo = null;
        for (int i = 0; i < entries.size(); ++i) {
            entryInfo = entries.get(i);
            if (entryInfo.getString("netBuyOfferItemId") != null && entryInfo.getString("netBuyOfferItemId").trim().length() > 0) {
                MsgBox.showError((String)"\u53d1\u5e03\u8be2\u4ef7\u5931\u8d25\uff01\u90e8\u5206\u7533\u8bf7\u5206\u5f55\u5df2\u8be2\u4ef7");
                SysUtil.abort();
            }
            if (entryInfo.getAssOrderBaseQty().compareTo(new BigDecimal("0")) != 1) continue;
            MsgBox.showError((String)"\u9009\u4e2d\u7684\u5206\u5f55\u5df2\u7ecf\u4e0b\u63a8\u8ba2\u5355\uff0c\u4e0d\u80fd\u53d1\u5e03\u8be2\u4ef7");
        }
    }

    public static void checkSelected(KDTable tblMain) {
        if (tblMain.getRowCount() == 0 || tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }
}

