/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.framework.openapi.PurCloudClient;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.b2b.IPurCloudService;
import com.kingdee.eas.scm.sm.pur.b2b.PurB2BFacadeFactory;
import com.kingdee.eas.scm.sm.pur.b2b.PurCloudServiceFactory;
import com.kingdee.eas.scm.sm.pur.b2b.client.PurCloudClientHelper;
import com.kingdee.eas.scm.sm.pur.b2b.client.QuotationUI;
import com.kingdee.eas.scm.sm.pur.b2b.model.QuotationInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class PurCloudClientHelper4PurOrder {
    public static void actionPostOrder4List(Component comp, KDTable tblMain) throws Exception {
        PurCloudClientHelper.checkSelected(tblMain);
        String[] purOrderEntryIds = SCMClientUtils.getSelectRowFieldValue((KDTable)tblMain, (String)"entries.id");
        String purOrderEntryId = purOrderEntryIds[0];
        PurOrderEntryCollection purOrderEntryInfos = PurOrderEntryFactory.getRemoteInstance().getPurOrderEntryCollection(PurCloudClientHelper4PurOrder.getEntityViewByEntryId(purOrderEntryId, PurCloudClientHelper4PurOrder.getShowQuotationSelector()));
        if (purOrderEntryInfos.isEmpty()) {
            MsgBox.showInfo((String)"\u7cfb\u7edf\u627e\u4e0d\u5230\u9009\u4e2d\u7684\u8ba2\u5355\u5206\u5f55\u4fe1\u606f");
            SysUtil.abort();
        }
        PurOrderEntryInfo orderEntry = purOrderEntryInfos.get(0);
        String companyId = orderEntry.getParent().getCompanyOrgUnit().getId().toString();
        String quoId = orderEntry.getString("netQuotationId");
        if (quoId == null) {
            MsgBox.showInfo((String)"\u4f9b\u5e94\u5546\u4e0d\u662f\u534f\u540c\u4f9b\u5e94\u5546\uff0c\u4e0d\u80fd\u53d1\u5e03\u8ba2\u5355");
            SysUtil.abort();
        }
        if (!orderEntry.getParent().getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED) && !orderEntry.getParent().getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            MsgBox.showInfo((String)"\u53ea\u6709\u63d0\u4ea4\u6216\u5ba1\u6838\u7684EAS\u8ba2\u5355\u624d\u5141\u8bb8\u53d1\u5e03\u8ba2\u5355");
            SysUtil.abort();
        }
        if (orderEntry.getParent().get("netOrderId") != null && orderEntry.getParent().getString("netOrderId").trim().length() > 0) {
            MsgBox.showInfo((String)"\u9009\u4e2dEAS\u8ba2\u5355\u5df2\u53d1\u5e03\u4e86\u8ba2\u5355\uff0c\u4e0d\u80fd\u518d\u53d1\u5e03\u8ba2\u5355");
            SysUtil.abort();
        }
        QuotationInfo quotationInfo = PurB2BFacadeFactory.getRemoteInstance().getQuotationInfoById(quoId, companyId);
        quotationInfo.setId(Long.parseLong(quoId));
        IPurCloudService iPurCloudService = PurCloudServiceFactory.getRemoteInstance();
        Map param = iPurCloudService.getAutoLoginParam(companyId, PurCloudClient.TargetUrlEnum.POST_ORDER.toString(), PurCloudClientHelper.getPostOrderData(quotationInfo));
        String url = (String)param.get("url");
        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
    }

    public static void showQuotation4List(KDTable tblMain) throws EASBizException, BOSException {
        PurCloudClientHelper.checkSelected(tblMain);
        String[] purOrderEntryIds = SCMClientUtils.getSelectRowFieldValue((KDTable)tblMain, (String)"entries.id");
        SelectorItemCollection orderSic = new SelectorItemCollection();
        orderSic.add(new SelectorItemInfo("id"));
        orderSic.add(new SelectorItemInfo("netBuyOfferId"));
        PurOrderEntryCollection purOrderEntryInfos = PurOrderEntryFactory.getRemoteInstance().getPurOrderEntryCollection(PurCloudClientHelper4PurOrder.getEntityViewByEntryIds(purOrderEntryIds, orderSic));
        ArrayList<String> buyOfferIdList = new ArrayList<String>();
        PurOrderEntryInfo entryInfo = null;
        String buyOfferId = null;
        for (int i = 0; i < purOrderEntryInfos.size(); ++i) {
            entryInfo = purOrderEntryInfos.get(i);
            buyOfferId = entryInfo.getString("netBuyOfferId");
            if (buyOfferId == null || buyOfferId.trim().length() <= 0 || buyOfferIdList.contains(buyOfferId)) continue;
            buyOfferIdList.add(buyOfferId);
        }
        if (buyOfferIdList.isEmpty()) {
            MsgBox.showInfo((String)"\u6240\u9009\u5206\u5f55\u672a\u8fdb\u884c\u8fc7\u7f51\u4e0a\u8be2\u4ef7\uff0c\u65e0\u6cd5\u67e5\u770b\u62a5\u4ef7");
            SysUtil.abort();
        }
        HashMap<String, Object> uiContext = new HashMap<String, Object>();
        uiContext.put("BUYOFFERS", buyOfferIdList);
        uiContext.put("viewContent", "material");
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(QuotationUI.class.getName(), uiContext);
        window.show();
    }

    public static void showQuotation4Edit(PurOrderInfo editData) throws EASBizException, BOSException {
        if (editData == null) {
            return;
        }
        if (!PurCloudClientHelper4PurOrder.isBotpBill("510b6503-0105-1000-e000-0107c0a812fd463ED552", editData)) {
            MsgBox.showInfo((String)"\u6765\u6e90\u5355\u636e\u4e0d\u662f\u91c7\u8d2d\u7533\u8bf7\u5355\uff0c\u65e0\u6cd5\u67e5\u770b\u7f51\u7edc\u62a5\u4ef7");
            SysUtil.abort();
        }
        ArrayList<String> purReqEntryIdList = new ArrayList<String>();
        String reqEntryId = null;
        if (editData.getEntries() != null && editData.getEntries().size() > 0) {
            reqEntryId = editData.getEntries().get(0).getSourceBillEntryId();
            purReqEntryIdList.add(reqEntryId);
        }
        if (purReqEntryIdList.size() == 0) {
            MsgBox.showInfo((String)"\u627e\u4e0d\u5230\u6e90\u7533\u8bf7\u5355\uff0c\u65e0\u6cd5\u67e5\u770b\u7f51\u7edc\u62a5\u4ef7");
            SysUtil.abort();
        }
        PurRequestEntryCollection purReqEntryInfos = PurRequestEntryFactory.getRemoteInstance().getPurRequestEntryCollection(PurCloudClientHelper4PurOrder.getEntityViewByEntryIds(purReqEntryIdList.toArray(new String[0]), PurCloudClientHelper4PurOrder.getShowQuotationSelector()));
        ArrayList<String> buyOfferIdList = new ArrayList<String>();
        PurRequestEntryInfo reqEntryInfo = null;
        String buyOfferId = null;
        for (int i = 0; i < purReqEntryInfos.size(); ++i) {
            reqEntryInfo = purReqEntryInfos.get(i);
            buyOfferId = reqEntryInfo.getString("netBuyOfferItemId");
            if (buyOfferId == null || buyOfferId.trim().length() <= 0 || buyOfferIdList.contains(buyOfferId)) continue;
            buyOfferIdList.add(buyOfferId);
        }
        if (buyOfferIdList.isEmpty()) {
            MsgBox.showInfo((String)"\u9009\u4e2d\u7684\u5206\u5f55\u6ca1\u6709\u8be2\u4ef7\uff0c\u65e0\u6cd5\u67e5\u770b\u62a5\u4ef7");
            SysUtil.abort();
        }
        HashMap<String, Object> uiContext = new HashMap<String, Object>();
        uiContext.put("BUYOFFERS", buyOfferIdList);
        uiContext.put("viewContent", "material");
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(QuotationUI.class.getName(), uiContext);
        window.show();
    }

    public static void actionPostOrder4Edit(PurOrderInfo editData, Component comp) throws Exception {
        PurOrderEntryCollection purOrderEntryInfos = editData.getEntries();
        if (purOrderEntryInfos.isEmpty()) {
            MsgBox.showInfo((String)"\u8ba2\u5355\u6ca1\u6709\u5206\u5f55\uff0c\u65e0\u6cd5\u53d1\u5e03\uff01");
            SysUtil.abort();
        }
        PurOrderEntryInfo orderEntry = purOrderEntryInfos.get(0);
        String companyId = editData.getCompanyOrgUnit().getId().toString();
        String quoId = orderEntry.getString("netQuotationId");
        if (quoId == null) {
            MsgBox.showInfo((String)"\u8be5\u8ba2\u5355\u4e0d\u662f\u7f51\u7edc\u8ba2\u5355\uff0c\u65e0\u6cd5\u53d1\u5e03\uff01");
            SysUtil.abort();
        }
        if (!editData.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED) && !editData.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            MsgBox.showInfo((String)"\u53ea\u6709\u63d0\u4ea4\u6216\u5ba1\u6838\u7684\u7f51\u7edc\u8ba2\u5355\u624d\u5141\u8bb8\u53d1\u5e03\uff01");
            SysUtil.abort();
        }
        if (editData.getString("netOrderId") != null && editData.getString("netOrderId").trim().length() > 0) {
            MsgBox.showInfo((String)"\u8be5\u8ba2\u5355\u5df2\u53d1\u5e03\uff0c\u65e0\u6cd5\u518d\u53d1\u5e03\u8ba2\u5355\uff01");
            SysUtil.abort();
        }
        QuotationInfo quotationInfo = PurB2BFacadeFactory.getRemoteInstance().getQuotationInfoById(quoId, companyId);
        quotationInfo.setId(Long.parseLong(quoId));
        IPurCloudService iPurCloudService = PurCloudServiceFactory.getRemoteInstance();
        Map param = iPurCloudService.getAutoLoginParam(companyId, PurCloudClient.TargetUrlEnum.POST_ORDER.toString(), PurCloudClientHelper.getPostOrderData(quotationInfo));
        String url = (String)param.get("url");
        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
    }

    protected static boolean isBotpBill(String billTypeID, PurOrderInfo editData) {
        if (PurCloudClientHelper4PurOrder.isBotpBill(editData)) {
            return editData.getSourceBillType().getId().toString().equals(billTypeID);
        }
        return false;
    }

    protected static boolean isBotpBill(PurOrderInfo editData) {
        if (editData == null) {
            return false;
        }
        BillTypeInfo billType = editData.getSourceBillType();
        return billType != null;
    }

    private static SelectorItemCollection getShowQuotationSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("parent.id");
        sic.add("parent.companyOrgUnit.id");
        sic.add("parent.baseStatus");
        sic.add("parent.netOrderId");
        sic.add("id");
        sic.add(new SelectorItemInfo("netBuyOfferId"));
        sic.add(new SelectorItemInfo("netQuotationId"));
        sic.add(new SelectorItemInfo("netOrderEntryId"));
        return sic;
    }

    private static EntityViewInfo getEntityViewByEntryIds(String[] entryIds, SelectorItemCollection selector) {
        HashSet<String> entryIdSet = new HashSet<String>();
        for (int i = 0; i < entryIds.length; ++i) {
            entryIdSet.add(entryIds[i]);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", entryIdSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(selector);
        return viewInfo;
    }

    private static EntityViewInfo getEntityViewByEntryId(String entryId, SelectorItemCollection selector) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)entryId, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(selector);
        return viewInfo;
    }
}

