/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierCollection;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.basedata.scm.sm.srm.IsUseableEnum;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoCollection;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.framework.openapi.PurCloudClient;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.b2b.IPurB2BFacade;
import com.kingdee.eas.scm.sm.pur.b2b.PurB2BFacadeFactory;
import com.kingdee.eas.scm.sm.pur.b2b.Supplier4AliFacadeFactory;
import com.kingdee.eas.scm.sm.pur.b2b.client.AbstractQuotationUI;
import com.kingdee.eas.scm.sm.pur.b2b.client.SupplierAddNewUI;
import com.kingdee.eas.scm.sm.pur.b2b.client.WebContainerUI;
import com.kingdee.eas.scm.sm.pur.b2b.model.BuyOfferInfo;
import com.kingdee.eas.scm.sm.pur.b2b.model.BuyOfferItem;
import com.kingdee.eas.scm.sm.pur.b2b.model.ContactInfo;
import com.kingdee.eas.scm.sm.pur.b2b.model.ObjectCollection;
import com.kingdee.eas.scm.sm.pur.b2b.model.QuotationInfo;
import com.kingdee.eas.scm.sm.pur.b2b.model.QuotationItem;
import com.kingdee.eas.scm.sm.pur.b2b.model.SupplierMapTypeEnum;
import com.kingdee.eas.scm.sm.pur.client.PurOrderEditUI;
import com.kingdee.eas.scm.sm.pur.client.PurQuoCreateOrderUI;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class QuotationUI
extends AbstractQuotationUI {
    private static final long serialVersionUID = -862927612080586345L;
    private static final Logger logger = CoreUIObject.getLogger(QuotationUI.class);
    private static final String CL_ID = "id";
    private static final String CL_SUPPLIER = "supplier";
    private static final String CL_PRICE = "price";
    private static final String CL_PRODUCTIONEXPIRE = "productionExpire";
    private static final String CL_QUOTATIONDATE = "quotationDate";
    private static final String DCL_PRODUCT = "product";
    private static final String DCL_QTY = "qty";
    private static final String DCL_PRODUCTDESC = "productDesc";
    private static final String DCL_PRICE = "price";
    private static final String DCL_SUM = "sum";
    private static final String DCL_PRITEMID = "prItemId";
    private static final String DCL_INCLUDETAX = "includeTax";
    private static final String DCL_TAXRATE = "taxRate";
    private static final String MTL_PRID = "prItemId";
    private static final String MTL_UNIT = "unit";
    private int pos = 0;
    private String curCompanyId = null;
    private String curBuyOfferId = null;
    private List<String> buyOfferIdList = new ArrayList<String>();
    private Map<Integer, QuotationInfo> quotationCacheMap = new HashMap<Integer, QuotationInfo>();
    private BuyOfferInfo buyOfferInfo;
    private QuotationInfo quotationInfo;
    private List<String> purchaseOrgUnitIdList = new ArrayList<String>();
    public static final String VIEWCONTENT = "viewContent";
    QuotationInfo[] quoInfoList = null;
    private static final BigDecimal BIGDECIMAL_100 = new BigDecimal("100.00");

    public QuotationUI() throws Exception {
        this.lblSupplier.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                QuotationUI.this.lblSupplier.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                QuotationUI.this.lblSupplier.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                QuotationUI.this.showSupplierDetail();
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtQuotationList.checkParsed();
        this.kdtQuotationList.removeRows();
        this.kdtQuotationList.setEditable(false);
        this.kdtQuotationList.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                KDTSelectBlock preSelectBlock = e.getPrevSelectBlock();
                KDTSelectBlock selectBlock = e.getSelectBlock();
                if (selectBlock == null) {
                    return;
                }
                if (preSelectBlock != null && preSelectBlock.getTop() == selectBlock.getTop()) {
                    return;
                }
                QuotationUI.this.quotationInfo = (QuotationInfo)QuotationUI.this.quotationCacheMap.get(selectBlock.getTop());
                QuotationUI.this.renderQuotationDetail();
            }
        });
        this.kdtMaterial.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                KDTSelectBlock preSelectBlock = e.getPrevSelectBlock();
                KDTSelectBlock selectBlock = e.getSelectBlock();
                if (selectBlock == null) {
                    return;
                }
                if (preSelectBlock != null && preSelectBlock.getTop() == selectBlock.getTop()) {
                    return;
                }
                String prItemId = (String)QuotationUI.this.kdtMaterial.getRow(selectBlock.getTop()).getCell("prItemId").getValue();
                QuotationUI.this.rendSupplierQuotation(QuotationUI.this.quoInfoList, prItemId);
            }
        });
        this.btnAddOrder.setEnabled(true);
        this.btnAddAppSupplier.setEnabled(false);
        this.btnAddSupPrice.setEnabled(false);
        this.kdtQuotationItemList.checkParsed();
        this.kdtQuotationItemList.removeRows();
        this.kdtQuotationItemList.setEditable(false);
        this.quotationCacheMap.clear();
        this.buyOfferInfo = null;
        this.buyOfferIdList = (List)this.getUIContext().get("BUYOFFERS");
        if (this.buyOfferIdList.isEmpty()) {
            MsgBox.showInfo((String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u8be2\u4ef7\u5355\uff0c\u65e0\u6cd5\u67e5\u770b\u8be2\u62a5\u4ef7\u4fe1\u606f");
            SysUtil.abort();
        }
        this.curBuyOfferId = this.buyOfferIdList.get(0);
        this.pos = 0;
        this.initCurBuyOfferData();
        this.renderBuyOfferInfo(this.buyOfferInfo);
        this.refreshQuotationList();
        this.renderQuotaionByMaterial(this.buyOfferInfo);
        this.setBtnVisible();
        String viewContent = (String)this.getUIContext().get(VIEWCONTENT);
        if (viewContent != null && viewContent.equals("material")) {
            this.kDTabbedPane1.setSelectedComponent((Component)this.conMaterial);
        }
        if (this.haveOrder()) {
            this.btnAddOrder.setEnabled(false);
        }
    }

    private void initCurBuyOfferData() throws BOSException, EASBizException {
        this.purchaseOrgUnitIdList.clear();
        this.quoInfoList = null;
        PurRequestEntryCollection purReqEntrys = PurRequestEntryFactory.getRemoteInstance().getPurRequestEntryCollection(this.getEntityViewByBuyOffer(this.curBuyOfferId));
        PurRequestEntryInfo entry = null;
        String purchaseId = null;
        int size = purReqEntrys.size();
        for (int i = 0; i < size; ++i) {
            entry = purReqEntrys.get(i);
            this.curCompanyId = entry.getParent().getCompanyOrgUnit().getId().toString();
            purchaseId = entry.getPurchaseOrgUnit().getId().toString();
            if (this.purchaseOrgUnitIdList.contains(purchaseId)) continue;
            this.purchaseOrgUnitIdList.add(entry.getPurchaseOrgUnit().getId().toString());
        }
        IPurB2BFacade purB2bFacade = PurB2BFacadeFactory.getRemoteInstance();
        if (this.curCompanyId == null) {
            MsgBox.showInfo((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8d22\u52a1\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u67e5\u770b\u62a5\u4ef7\uff01");
            return;
        }
        this.buyOfferInfo = purB2bFacade.getBuyOfferByPrId(this.curBuyOfferId, this.curCompanyId);
        if (this.buyOfferInfo.isVisibleAfterEndQuote() && !purB2bFacade.isExpire(this.buyOfferInfo)) {
            MsgBox.showInfo((String)"\u672a\u5230\u62a5\u4ef7\u622a\u6b62\u65e5\u671f\uff0c\u4e0d\u80fd\u67e5\u770b\u62a5\u4ef7\u4fe1\u606f\uff01");
            return;
        }
        try {
            this.quoInfoList = purB2bFacade.getListedByQuotationId(this.buyOfferInfo.getPurchaseNoteId().toString(), this.curCompanyId, this.purchaseOrgUnitIdList);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private EntityViewInfo getEntityViewByBuyOffer(String buyOfferId) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("netBuyOfferItemId", (Object)buyOfferId, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("parent.id");
        sic.add("parent.companyOrgUnit");
        sic.add("parent.baseStatus");
        sic.add(CL_ID);
        sic.add("purchaseOrgUnit");
        sic.add(new SelectorItemInfo("netBuyOfferItemId"));
        sic.add("baseStatus");
        viewInfo.setSelector(sic);
        return viewInfo;
    }

    private void setBtnVisible() {
        this.btnAddOrder.setVisible(true);
        this.btnAddSupplier.setVisible(true);
        this.btnRefresh.setVisible(true);
        if (this.getUIContext().get("VIEW_PURORDER") != null) {
            this.btnAddOrder.setVisible(false);
            this.btnAddSupplier.setVisible(false);
            this.btnRefresh.setVisible(false);
        }
    }

    private void refreshQuotationList() throws BOSException, EASBizException {
        this.renderQuotationList(this.quoInfoList, this.buyOfferInfo);
    }

    private void showSupplierDetail() {
        if (StringUtils.isEmpty((String)this.quotationInfo.getSupplierMemberId())) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"TargetUrl", (Object)PurCloudClient.TargetUrlEnum.SUPPLIER_DETAIL);
        uiContext.put((Object)"CompanyId", (Object)this.curCompanyId);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("memberId", this.quotationInfo.getSupplierMemberId());
        uiContext.put((Object)"Params", params);
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
            IUIWindow window = uiFactory.create(WebContainerUI.class.getName(), (Map)uiContext, null);
            window.show();
        }
        catch (UIException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    private void renderBuyOfferInfo(BuyOfferInfo info) {
        if (info == null) {
            MsgBox.showInfo((String)"\u65e0\u6cd5\u83b7\u53d6\u5230\u7f51\u7edc\u8be2\u4ef7\u5355\u4fe1\u606f,\u8bf7\u91cd\u8bd5\u3002\u5982\u679c\u518d\u6b21\u51fa\u73b0\u6b64\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
            SysUtil.abort();
        }
        this.btnUp.setEnabled(true);
        this.btnDown.setEnabled(true);
        if (this.pos == 0) {
            this.btnUp.setEnabled(false);
        }
        if (this.pos == this.buyOfferIdList.size() - 1) {
            this.btnDown.setEnabled(false);
        }
        this.lblTitle.setText(info.getTitle());
        this.lblGmtCreate.setText("\u8be2\u4ef7\u65e5\u671f\uff1a" + DateTimeUtil.getFmtDate((Date)info.getGmtCreate()));
        this.lblQuotationExpire.setText("\u62a5\u4ef7\u622a\u6b62\uff1a" + DateTimeUtil.getFmtDate((Date)info.getGmtQuotationExpire()));
        ContactInfo contactInfo = info.getContactInfo();
        if (contactInfo != null) {
            this.lblContact.setText("\u8054\u7cfb\u4eba\uff1a" + contactInfo.getSummary());
        } else {
            this.lblContact.setText("\u8054\u7cfb\u4eba\uff1a" + SysContext.getSysContext().getUserName());
        }
        this.lblDescription.setText("\u91c7\u8d2d\u8981\u6c42\uff1a" + info.getDescription());
        if ("end".equalsIgnoreCase(info.getStatus())) {
            this.lblStatus.setText("\u72b6\u6001\uff1a\u91c7\u8d2d\u7ed3\u675f");
            this.btnAddOrder.setEnabled(false);
        } else {
            this.lblStatus.setText("\u72b6\u6001\uff1a\u63a5\u53d7\u62a5\u4ef7\u4e2d");
        }
    }

    private void renderQuotationList(QuotationInfo[] list, BuyOfferInfo buyOfferInfo) {
        QuotationInfo info;
        if (null == list || list.length == 0) {
            this.btnAddOrder.setEnabled(false);
            this.btnAddSupplier.setEnabled(false);
            this.btnAddAppSupplier.setEnabled(false);
            this.btnAddSupPrice.setEnabled(false);
            return;
        }
        this.sortQuotatinListByAmount(list);
        int len = list.length;
        for (int i = 0; i < len; ++i) {
            info = list[i];
            BigDecimal price = new BigDecimal(info.getTotalPrice()).setScale(2, RoundingMode.HALF_UP).divide(BIGDECIMAL_100, RoundingMode.HALF_UP);
            IRow row = this.kdtQuotationList.addRow();
            row.getCell(CL_ID).setValue((Object)(info.getBuyOfferId() + i));
            if (info.getSupplier() != null && info.getSupplier().getCompanyInfo() != null) {
                row.getCell(CL_SUPPLIER).setValue((Object)info.getSupplier().getCompanyInfo().getName());
            }
            row.getCell("price").setValue((Object)price);
            row.getCell(CL_PRODUCTIONEXPIRE).setValue((Object)DateUtil.formatDate2((Date)info.getExpireDate()));
            row.getCell(CL_QUOTATIONDATE).setValue((Object)DateUtil.formatDate2((Date)info.getGmtCreate()));
            this.quotationCacheMap.put(i, info);
        }
        this.kdtQuotationList.getSelectManager().set(0, 0);
        this.quotationInfo = info = list[0];
        this.renderQuotationDetail();
    }

    private void sortQuotatinListByAmount(QuotationInfo[] list) {
        QuotationInfo temp1 = null;
        QuotationInfo temp2 = null;
        for (int i = 0; i < list.length - 1; ++i) {
            for (int j = 0; j < list.length - i - 1; ++j) {
                temp1 = list[j];
                temp2 = list[j + 1];
                if (temp1.getTotalPrice() <= temp2.getTotalPrice()) continue;
                list[j] = temp2;
                list[j + 1] = temp1;
            }
        }
    }

    private void renderQuotationDetail() {
        if (null == this.quotationInfo || null == this.buyOfferInfo) {
            return;
        }
        this.kdtQuotationItemList.removeRows();
        com.kingdee.eas.scm.sm.pur.b2b.model.SupplierInfo supplierInfo = this.quotationInfo.getSupplier();
        if (supplierInfo != null && supplierInfo.getCompanyInfo() != null) {
            this.lblSupplier.setText(supplierInfo.getCompanyInfo().getName());
            if (supplierInfo.getBusinessInfo() == null) {
                this.lblLocation.setText("\u6240\u5728\u5730\u533a\uff1a\u2014\u2014\u2014\u2014\u2014\u2014");
                this.lblMainBiz.setText("\u4e3b\u8425\u884c\u4e1a\uff1a \u2014\u2014\u2014\u2014\u2014\u2014");
            } else {
                this.lblLocation.setText("\u6240\u5728\u5730\u533a\uff1a" + supplierInfo.getBusinessInfo().getBusinessAddress());
                this.lblMainBiz.setText("\u4e3b\u8425\u884c\u4e1a\uff1a" + supplierInfo.getBusinessInfo().getMainIndustries());
            }
            this.lblCompanyAmout.setText("\u6ce8\u518c\u8d44\u672c\uff1a" + supplierInfo.getCompanyInfo().getRegisteredCapital());
        }
        this.lblQuotationDate.setText("\u62a5\u4ef7\u65e5\u671f\uff1a" + DateTimeUtil.getFmtDate((Date)this.quotationInfo.getGmtCreate()));
        this.lblDetailContact.setText("  \u8054\u7cfb\u4eba\uff1a");
        ContactInfo contactInfo = this.quotationInfo.getContactInfo();
        if (contactInfo != null) {
            this.lblDetailContact.setText("  \u8054\u7cfb\u4eba\uff1a" + contactInfo.getSummary());
        }
        this.lblDateTo.setText("\u6709\u6548\u671f\u81f3\uff1a" + DateTimeUtil.getFmtDate((Date)this.quotationInfo.getExpireDate()));
        if (QuotationInfo.InvoiceType.common.equals((Object)this.quotationInfo.getInvoiceType())) {
            this.lblInvoiceType.setText("\u7a0e\u52a1\u53d1\u7968\uff1a\u666e\u901a\u53d1\u7968");
        } else if (QuotationInfo.InvoiceType.vat.equals((Object)this.quotationInfo.getInvoiceType())) {
            this.lblInvoiceType.setText("\u7a0e\u52a1\u53d1\u7968\uff1a\u589e\u503c\u53d1\u7968");
        } else if (QuotationInfo.InvoiceType.no.equals((Object)this.quotationInfo.getInvoiceType())) {
            this.lblInvoiceType.setText("\u7a0e\u52a1\u53d1\u7968\uff1a\u4e0d\u63d0\u4f9b\u53d1\u7968");
        }
        BigDecimal totalPrice = new BigDecimal(this.quotationInfo.getTotalPrice()).setScale(2, RoundingMode.HALF_UP).divide(BIGDECIMAL_100, RoundingMode.HALF_UP);
        BigDecimal freight = new BigDecimal(this.quotationInfo.getFreight()).setScale(2, RoundingMode.HALF_UP).divide(BIGDECIMAL_100, RoundingMode.HALF_UP);
        this.lblFreight.setText("\u9884\u8ba1\u8fd0\u8d39\uff1a" + freight + "(\u5143)");
        this.lblTotalPrice.setText("\u9884\u8ba1\u603b\u4ef7\uff1a" + totalPrice + "(\u5143)");
        this.lblSpecifications.setText("\u8865\u5145\u8bf4\u660e\uff1a" + this.quotationInfo.getSpecifications());
        ObjectCollection<QuotationItem> items = this.quotationInfo.getSupplyNoteItems();
        ObjectCollection<BuyOfferItem> purNoteItems = this.buyOfferInfo.getPurchaseNoteItems();
        if (items != null && items.size() > 1) {
            this.sortQuotationItemsByPrItemId(items.getItemsList());
        }
        if (purNoteItems != null && purNoteItems.size() > 1) {
            this.sortBuyOfferItemsByPrItemId(purNoteItems.getItemsList());
        }
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            QuotationItem item = items.getItem(i);
            BuyOfferItem purNoteItem = purNoteItems.getItem(i);
            BigDecimal price = new BigDecimal(item.getPrice()).setScale(2, RoundingMode.HALF_UP).divide(BIGDECIMAL_100, RoundingMode.HALF_UP);
            BigDecimal sum = new BigDecimal(item.getPrice() * (long)item.getAmount()).setScale(2, RoundingMode.HALF_UP).divide(BIGDECIMAL_100, RoundingMode.HALF_UP);
            IRow row = this.kdtQuotationItemList.addRow();
            row.getCell(DCL_PRODUCT).setValue((Object)item.getSubject());
            row.getCell(DCL_QTY).setValue((Object)(item.getAmount() + "(" + item.getUnit() + ")"));
            row.getCell("price").setValue((Object)price);
            row.getCell(DCL_INCLUDETAX).setValue((Object)item.isIncludeTax());
            row.getCell(DCL_TAXRATE).setValue((Object)item.getTaxRate());
            row.getCell(DCL_SUM).setValue((Object)sum);
            if (purNoteItem != null) {
                row.getCell(DCL_PRODUCTDESC).setValue((Object)purNoteItem.getDesc());
            }
            row.getCell("prItemId").setValue((Object)item.getPrItemId());
        }
        SupplierMapTypeEnum mapType = this.quotationInfo.getSupplierMapType();
        if (SupplierMapTypeEnum.SUPPLIER_NOTMAPPING.equals((Object)mapType)) {
            this.btnAddOrder.setEnabled(false);
            this.btnAddSupplier.setEnabled(true);
            this.btnAddAppSupplier.setEnabled(false);
            this.btnAddSupPrice.setEnabled(false);
        } else {
            this.btnAddOrder.setEnabled(true);
            this.btnAddSupplier.setEnabled(false);
            this.btnAddAppSupplier.setEnabled(true);
            this.btnAddSupPrice.setEnabled(true);
        }
    }

    private void renderQuotaionByMaterial(BuyOfferInfo buyOfferInfo) {
        this.kdtMaterial.checkParsed();
        this.kdtMaterial.removeRows();
        this.kdtMaterial.setEditable(false);
        List<BuyOfferItem> buyOfferItems = buyOfferInfo.getPurchaseNoteItems().getItemsList();
        for (int i = 0; i < buyOfferItems.size(); ++i) {
            BuyOfferItem buyOfferItem = buyOfferItems.get(i);
            IRow row = this.kdtMaterial.addRow();
            row.getCell(DCL_PRODUCT).setValue((Object)buyOfferItem.getSubject());
            row.getCell(DCL_PRODUCTDESC).setValue((Object)buyOfferItem.getDesc());
            row.getCell(MTL_UNIT).setValue((Object)buyOfferItem.getUnit());
            row.getCell("prItemId").setValue((Object)buyOfferItem.getPrItemId());
        }
        String prItemId = null;
        if (!buyOfferItems.isEmpty()) {
            prItemId = buyOfferItems.get(0).getPrItemId();
        }
        this.rendSupplierQuotation(this.quoInfoList, prItemId);
    }

    private void rendSupplierQuotation(QuotationInfo[] quoInfoList, String prItemId) {
        this.kdtSupplierQuo.checkParsed();
        this.kdtSupplierQuo.removeRows();
        this.kdtSupplierQuo.setEditable(false);
        if (quoInfoList == null || prItemId == null) {
            return;
        }
        QuotationInfo temQuoInfo = null;
        List<QuotationItem> quoItemList = null;
        QuotationItem quoItem = null;
        for (int i = 0; i < quoInfoList.length; ++i) {
            temQuoInfo = new QuotationInfo();
            temQuoInfo = quoInfoList[i];
            quoItemList = temQuoInfo.getSupplyNoteItems().getItemsList();
            for (int j = 0; j < quoItemList.size(); ++j) {
                String tempPrItemId = quoItemList.get(j).getPrItemId();
                if (!prItemId.equals(tempPrItemId)) continue;
                quoItem = quoItemList.get(j);
                break;
            }
            if (quoItem == null) continue;
            BigDecimal price = new BigDecimal(quoItem.getPrice()).setScale(2, RoundingMode.HALF_UP).divide(BIGDECIMAL_100, RoundingMode.HALF_UP);
            BigDecimal sum = new BigDecimal(quoItem.getPrice() * (long)quoItem.getAmount()).setScale(2, RoundingMode.HALF_UP).divide(BIGDECIMAL_100, RoundingMode.HALF_UP);
            IRow row = this.kdtSupplierQuo.addRow();
            row.getCell(CL_SUPPLIER).setValue((Object)temQuoInfo.getSupplier().getCompanyInfo().getName());
            row.getCell(DCL_QTY).setValue((Object)quoItem.getAmount());
            row.getCell("price").setValue((Object)price);
            row.getCell(DCL_SUM).setValue((Object)sum);
            row.getCell(DCL_INCLUDETAX).setValue((Object)quoItem.isIncludeTax());
            row.getCell(DCL_TAXRATE).setValue((Object)quoItem.getTaxRate());
            row.getCell(CL_QUOTATIONDATE).setValue((Object)DateUtil.formatDate2((Date)temQuoInfo.getGmtCreate()));
            row.getCell(CL_PRODUCTIONEXPIRE).setValue((Object)DateUtil.formatDate2((Date)temQuoInfo.getExpireDate()));
            quoItem = null;
        }
        this.sortKdtSupplierQuoByPrice();
    }

    private void sortKdtSupplierQuoByPrice() {
        for (int i = 0; i < this.kdtSupplierQuo.getRowCount() - 1; ++i) {
            for (int j = 0; j < this.kdtSupplierQuo.getRowCount() - i - 1; ++j) {
                BigDecimal price2;
                BigDecimal price1 = (BigDecimal)this.kdtSupplierQuo.getRow(j).getCell("price").getValue();
                if (price1.compareTo(price2 = (BigDecimal)this.kdtSupplierQuo.getRow(j + 1).getCell("price").getValue()) <= 0) continue;
                this.kdtSupplierQuo.moveRow(j, j + 1);
            }
        }
    }

    private void parseMapTypeEnum(SupplierMapTypeEnum mapType) {
        String errorInfo = null;
        if (SupplierMapTypeEnum.SUPPLIER_BASEDATANOAUDIT.equals((Object)mapType)) {
            errorInfo = "\u8be5\u4f9b\u5e94\u5546\u57fa\u672c\u4fe1\u606f\u672a\u5ba1\u6838\uff0c\u4e0d\u80fd\u4e0b\u5355 ";
        } else if (SupplierMapTypeEnum.SUPPLIER_NOCOMPANYDATA.equals((Object)mapType)) {
            errorInfo = "\u8be5\u4f9b\u5e94\u5546\u65e0\u8d22\u52a1\u4fe1\u606f\uff0c\u4e0d\u80fd\u4e0b\u5355 ";
        } else if (SupplierMapTypeEnum.SUPPLIER_COMPANYDATANOAUDIT.equals((Object)mapType)) {
            errorInfo = "\u8be5\u4f9b\u5e94\u5546\u8d22\u52a1\u4fe1\u606f\u672a\u542f\u7528\uff0c\u4e0d\u80fd\u4e0b\u5355 ";
        } else if (SupplierMapTypeEnum.SUPPLIER_NOPURCHASEDATA.equals((Object)mapType)) {
            errorInfo = "\u8be5\u4f9b\u5e94\u5546\u65e0\u91c7\u8d2d\u4fe1\u606f\uff0c\u4e0d\u80fd\u4e0b\u5355 ";
        } else if (SupplierMapTypeEnum.SUPPLIER_COMPANYDATANOAUDIT.equals((Object)mapType)) {
            errorInfo = "\u8be5\u4f9b\u5e94\u5546\u91c7\u8d2d\u4fe1\u606f\u672a\u542f\u7528\uff0c\u4e0d\u80fd\u4e0b\u5355 ";
        }
        if (errorInfo != null) {
            MsgBox.showError((String)errorInfo);
            SysUtil.abort();
        }
    }

    private String getbotpNumber(Set orderidSet) throws BOTPException, BOSException {
        BOTMappingInfo bOTMappingInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(CL_ID, (Object)orderidSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        CoreBillBaseCollection col = PurRequestFactory.getRemoteInstance().getCoreBillBaseCollection(viewInfo);
        BOTMappingCollection botMappingCols = BOTMappingFactory.getRemoteInstance().getMappingCollectionForSelect(col, new PurOrderInfo().getBOSType().toString(), DefineSysEnum.BTP);
        if (botMappingCols.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"NOBOTP"));
        }
        if (botMappingCols.size() == 1) {
            bOTMappingInfo = botMappingCols.get(0);
        } else {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"mainOrgId", (Object)((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())));
            uiContext.put((Object)"botMappingCols", (Object)botMappingCols);
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow window = uiFactory.create("com.kingdee.eas.scm.sm.pur.client.PurQuoCreateOrderUI", (Map)uiContext, null);
            CtrlSwingUtilities.centerWindow((Window)((UIModelDialog)window));
            window.show();
            PurQuoCreateOrderUI botpSelectUI = (PurQuoCreateOrderUI)window.getUIObject();
            bOTMappingInfo = botpSelectUI.getBOTMappingInfo();
        }
        return bOTMappingInfo.getName();
    }

    @Override
    public void actionAddOrder_actionPerformed(ActionEvent e) throws Exception {
        if (null == this.quotationInfo) {
            return;
        }
        SupplierMapTypeEnum mapType = this.quotationInfo.getSupplierMapType();
        this.parseMapTypeEnum(mapType);
        PurRequestEntryCollection purEntries = PurRequestEntryFactory.getRemoteInstance().getPurRequestEntryCollection(this.getEntityViewByBuyOffer(this.curBuyOfferId));
        int size = purEntries.size();
        for (int i = 0; i < size; ++i) {
            PurRequestEntryInfo entry = purEntries.get(i);
            if (EntryBaseStatusEnum.AUDITED.equals((Object)entry.getBaseStatus())) continue;
            MsgBox.showError((String)"\u975e\u5ba1\u6838\u72b6\u6001\u7684\u7533\u8bf7\u5355\u5206\u5f55\uff0c\u4e0d\u80fd\u8fdb\u884c\u4e0b\u5355\u64cd\u4f5c");
            SysUtil.abort();
        }
        if (this.haveOrder()) {
            MsgBox.showError((String)"\u8be2\u4ef7\u5355\u5df2\u751f\u6210\u8ba2\u5355\uff0c\u65e0\u6cd5\u518d\u8fdb\u884c\u4e0b\u5355");
            SysUtil.abort();
        }
        HashSet<String> orderidSet = new HashSet<String>();
        int size2 = purEntries.size();
        for (int i = 0; i < size2; ++i) {
            orderidSet.add(purEntries.get(i).getParent().getId().toString());
        }
        String botpnumber = this.getbotpNumber(orderidSet);
        String userid = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String orgid = purEntries.get(0).getPurchaseOrgUnit().getId().toString();
        IPermission perm = PermissionFactory.getRemoteInstance();
        perm.checkFunctionPermission((IObjectPK)new ObjectUuidPK(userid), (IObjectPK)new ObjectUuidPK(orgid), "purorder_addnew");
        ArrayList list = ListUiHelper.getSelectIdForTableSelect((KDTable)this.kdtQuotationItemList, (String)"prItemId");
        Object orderId = null;
        try {
            PurB2BFacadeFactory.getRemoteInstance().addPurOrderByQuotation(this.quotationInfo, botpnumber, list);
        }
        catch (Exception err) {
            err.printStackTrace();
            MsgBox.showError((String)err.getMessage());
            SysUtil.abort();
        }
        if (orderId == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)orderId.toString());
        String orderEditUI = PurOrderEditUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(orderEditUI, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionAddSupplier_actionPerformed(ActionEvent e) throws Exception {
        CtrlUnitInfo curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        String userid = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String orgid = curCtrlUnitInfo.getId().toString();
        CompanyOrgUnitInfo compay = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.curCompanyId));
        IPermission perm = PermissionFactory.getRemoteInstance();
        perm.checkFunctionPermission((IObjectPK)new ObjectUuidPK(userid), (IObjectPK)new ObjectUuidPK(compay.getCU().getId()), "Supplier_AddNew");
        perm.checkFunctionPermission((IObjectPK)new ObjectUuidPK(userid), (IObjectPK)new ObjectUuidPK(compay.getCU().getId()), "Suppliercompanyinfo_AddNew");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"companyOrgUnitId", (Object)this.curCompanyId);
        uiContext.put((Object)"purchaseOrgUnitIdList", this.purchaseOrgUnitIdList);
        uiContext.put((Object)"supplierMemberId", (Object)this.quotationInfo.getSupplierMemberId());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SupplierAddNewUI.class.getName(), (Map)uiContext);
        window.show();
    }

    @Override
    public void actionRefreshData_actionPerformed(ActionEvent e) throws Exception {
        if (this.quotationInfo == null) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("companyOrgUnitId", this.curCompanyId);
        paramMap.put("purchaseOrgUnitIdList", this.purchaseOrgUnitIdList);
        paramMap.put("supplierMemberId", this.quotationInfo.getSupplierMemberId());
        SupplierMapTypeEnum mapType = Supplier4AliFacadeFactory.getRemoteInstance().checkSupplierData(paramMap);
        this.quotationInfo.setSupplierMapType(mapType);
        if (SupplierMapTypeEnum.SUPPLIER_NOTMAPPING.equals((Object)mapType)) {
            this.btnAddOrder.setEnabled(false);
            this.btnAddSupplier.setEnabled(true);
            this.btnAddAppSupplier.setEnabled(false);
            this.btnAddSupPrice.setEnabled(false);
        } else {
            this.btnAddOrder.setEnabled(true);
            this.btnAddSupplier.setEnabled(false);
            this.btnAddAppSupplier.setEnabled(true);
            this.btnAddSupPrice.setEnabled(true);
        }
        if (this.haveOrder()) {
            this.btnAddOrder.setEnabled(false);
            this.btnAddAppSupplier.setEnabled(true);
            this.btnAddSupPrice.setEnabled(true);
        }
    }

    @Override
    public void actionUpBuyOffer_actionPerformed(ActionEvent e) throws Exception {
        if (this.pos == 0) {
            MsgBox.showInfo((String)"\u5df2\u7ecf\u662f\u7b2c\u4e00\u5f20\u8be2\u4ef7\u5355\u4e86\uff01");
            SysUtil.abort();
        }
        --this.pos;
        this.curBuyOfferId = this.buyOfferIdList.get(this.pos);
        this.refreshPage();
    }

    @Override
    public void actionDownBuyOffer_actionPerformed(ActionEvent e) throws Exception {
        if (this.pos == this.buyOfferIdList.size() - 1) {
            MsgBox.showInfo((String)"\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u5f20\u8be2\u4ef7\u5355\u4e86\uff01");
            SysUtil.abort();
        }
        ++this.pos;
        this.curBuyOfferId = this.buyOfferIdList.get(this.pos);
        this.refreshPage();
    }

    @Override
    public void actionAddAppSupplier_actionPerformed(ActionEvent e) throws Exception {
        QuotationItem quoItem;
        if (StringUtils.isEmpty((String)this.curBuyOfferId)) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("netBuyOfferItemId", (Object)this.curBuyOfferId, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(CL_ID);
        sic.add("purchaseOrgUnit.*");
        sic.add("materialName");
        sic.add("materialGroup1.id");
        sic.add("materialGroup1.number");
        sic.add("materialGroup1.name");
        sic.add("material.id");
        sic.add("material.number");
        sic.add("material.name");
        sic.add("unit.id");
        sic.add("unit.number");
        sic.add("unit.name");
        sic.add("noNumMaterialModel");
        sic.add("materialName");
        viewInfo.setSelector(sic);
        PurRequestEntryCollection purReqEntryInfos = PurRequestEntryFactory.getRemoteInstance().getPurRequestEntryCollection(viewInfo);
        SupplierInfo supplierInfo = Supplier4AliFacadeFactory.getRemoteInstance().getEasSupplierByMemberId(this.quotationInfo.getSupplierMemberId());
        ObjectCollection<QuotationItem> quoItems = this.quotationInfo.getSupplyNoteItems();
        HashMap<String, QuotationItem> prItemQuoMap = new HashMap<String, QuotationItem>();
        int size = quoItems.size();
        for (int i = 0; i < size; ++i) {
            quoItem = quoItems.getItem(i);
            prItemQuoMap.put(quoItem.getPrItemId(), quoItem);
        }
        PurRequestEntryInfo purEntryInfo = null;
        ApprovedSupplierCollection appSupCols = new ApprovedSupplierCollection();
        ApprovedSupplierInfo appSupplier = null;
        BigDecimal taxRate = null;
        String userid = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String orgid = purReqEntryInfos.get(0).getPurchaseOrgUnit().getId().toString();
        IPermission perm = PermissionFactory.getRemoteInstance();
        perm.checkFunctionPermission((IObjectPK)new ObjectUuidPK(userid), (IObjectPK)new ObjectUuidPK(orgid), "approveSupplier_addnew");
        for (int i = 0; i < purReqEntryInfos.size(); ++i) {
            purEntryInfo = purReqEntryInfos.get(i);
            appSupplier = new ApprovedSupplierInfo();
            appSupplier.setSupplierMaterialName(purEntryInfo.getMaterialName());
            if (purEntryInfo.getMaterial() == null) continue;
            appSupplier.setSupplierMaterialNumber(purEntryInfo.getMaterial().getNumber());
            appSupplier.setMaterialItem(purEntryInfo.getMaterial());
            appSupplier.setSupplierMaterialRule(purEntryInfo.getNoNumMaterialModel());
            appSupplier.setSupplier(supplierInfo);
            appSupplier.setMaterialGroup1(purEntryInfo.getMaterialGroup1());
            appSupplier.setMateiralRule(purEntryInfo.getNoNumMaterialModel());
            appSupplier.setPurchaseOrg(purEntryInfo.getPurchaseOrgUnit());
            appSupplier.setPurMeasureUnit(purEntryInfo.getUnit());
            quoItem = (QuotationItem)prItemQuoMap.get(purEntryInfo.getId().toString());
            taxRate = new BigDecimal(quoItem.getTaxRate());
            appSupplier.setTaxRate(taxRate);
            appSupplier.setIsUseable(IsUseableEnum.UnUseable);
            appSupplier.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            appSupplier.setCreateTime(new Timestamp(System.currentTimeMillis()));
            appSupCols.add(appSupplier);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"newAppSuppliers", (Object)appSupCols);
        String className = "com.kingdee.eas.basedata.scm.sm.srm.client.ApprovedSupplierEditUI";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(className, (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionAddSupPrice_actionPerformed(ActionEvent e) throws Exception {
        QuotationItem quoItem;
        if (StringUtils.isEmpty((String)this.curBuyOfferId)) {
            return;
        }
        if (this.quotationInfo == null) {
            return;
        }
        ObjectCollection<QuotationItem> quoItems = this.quotationInfo.getSupplyNoteItems();
        HashMap<String, QuotationItem> prItemQuoMap = new HashMap<String, QuotationItem>();
        int size = quoItems.size();
        for (int i = 0; i < size; ++i) {
            quoItem = quoItems.getItem(i);
            prItemQuoMap.put(quoItem.getPrItemId(), quoItem);
        }
        SupplierInfo supplierInfo = Supplier4AliFacadeFactory.getRemoteInstance().getEasSupplierByMemberId(this.quotationInfo.getSupplierMemberId());
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("netBuyOfferItemId", (Object)this.curBuyOfferId, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(CL_ID);
        sic.add("purchaseOrgUnit.*");
        sic.add("materialName");
        sic.add("materialGroup1.id");
        sic.add("materialGroup1.number");
        sic.add("materialGroup1.name");
        sic.add("material.*");
        sic.add("unit.*");
        sic.add("baseUnit.*");
        sic.add("noNumMaterialModel");
        sic.add("materialName");
        sic.add("parent.id");
        sic.add("parent.companyOrgUnit.baseCurrency");
        sic.add("parent.companyOrgUnit.baseCurrency.*");
        sic.add("assistProperty");
        viewInfo.setSelector(sic);
        PurRequestEntryCollection purReqEntryInfos = PurRequestEntryFactory.getRemoteInstance().getPurRequestEntryCollection(viewInfo);
        String userid = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String orgid = purReqEntryInfos.get(0).getPurchaseOrgUnit().getId().toString();
        IPermission perm = PermissionFactory.getRemoteInstance();
        perm.checkFunctionPermission((IObjectPK)new ObjectUuidPK(userid), (IObjectPK)new ObjectUuidPK(orgid), "supplyInfo_addnew");
        PurRequestEntryInfo purEntryInfo = null;
        SupplyInfoCollection supriceCols = new SupplyInfoCollection();
        SupplyInfoInfo supplyInfo = null;
        BigDecimal price = null;
        for (int i = 0; i < purReqEntryInfos.size(); ++i) {
            purEntryInfo = purReqEntryInfos.get(i);
            supplyInfo = new SupplyInfoInfo();
            supplyInfo.setSupplierMaterialName(purEntryInfo.getMaterialName());
            if (purEntryInfo.getMaterial() == null) continue;
            supplyInfo.setSupplierMaterialNumber(purEntryInfo.getMaterial().getNumber());
            supplyInfo.setMaterialItem(purEntryInfo.getMaterial());
            supplyInfo.setSupplierMaterialRule(purEntryInfo.getNoNumMaterialModel());
            supplyInfo.setSupplier(supplierInfo);
            supplyInfo.setMateiralRule(purEntryInfo.getNoNumMaterialModel());
            supplyInfo.setPurchaseOrg(purEntryInfo.getPurchaseOrgUnit());
            supplyInfo.setPurMeasureUnit(purEntryInfo.getUnit());
            supplyInfo.setMeasureUnit(purEntryInfo.getBaseUnit());
            supplyInfo.setCurrency(purEntryInfo.getParent().getCompanyOrgUnit().getBaseCurrency());
            supplyInfo.setAssistProperty(purEntryInfo.getAssistProperty());
            supplyInfo.setEffectualDate(this.quotationInfo.getGmtCreate());
            supplyInfo.setUneffectualDate(this.quotationInfo.getExpireDate());
            supplyInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            supplyInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            quoItem = (QuotationItem)prItemQuoMap.get(purEntryInfo.getId().toString());
            price = new BigDecimal(quoItem.getPrice()).divide(new BigDecimal("100"));
            supplyInfo.setPrice(price);
            supplyInfo.setIsUseable(IsUseableEnum.UnUseable);
            supplyInfo.setIsTaxPrice(quoItem.isIncludeTax());
            supriceCols.add(supplyInfo);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"newSupplierPrices", (Object)supriceCols);
        String className = "com.kingdee.eas.basedata.scm.sm.srm.client.SupplierPriceEditUI";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(className, (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    private void sortBuyOfferItemsByPrItemId(List<BuyOfferItem> buyOfferItems) {
        Comparator<BuyOfferItem> comparator = new Comparator<BuyOfferItem>(){

            @Override
            public int compare(BuyOfferItem o1, BuyOfferItem o2) {
                return o1.getPrItemId().compareTo(o2.getPrItemId());
            }
        };
        Collections.sort(buyOfferItems, comparator);
    }

    private void sortQuotationItemsByPrItemId(List<QuotationItem> quotationItems) {
        Comparator<QuotationItem> comparator = new Comparator<QuotationItem>(){

            @Override
            public int compare(QuotationItem o1, QuotationItem o2) {
                return o1.getPrItemId().compareTo(o2.getPrItemId());
            }
        };
        Collections.sort(quotationItems, comparator);
    }

    private boolean haveOrder() throws BOSException {
        return true;
    }

    private void refreshPage() throws EASBizException, BOSException {
        if (this.quoInfoList == null) {
            this.btnAddOrder.setEnabled(false);
            this.btnAddSupplier.setEnabled(false);
        }
        if (this.haveOrder()) {
            this.btnAddOrder.setEnabled(false);
        }
        this.btnAddOrder.setEnabled(true);
        this.kdtQuotationList.checkParsed();
        this.kdtQuotationList.removeRows();
        this.kdtQuotationList.setEditable(false);
        this.kdtQuotationItemList.checkParsed();
        this.kdtQuotationItemList.removeRows();
        this.kdtQuotationItemList.setEditable(false);
        this.quotationCacheMap.clear();
        this.buyOfferInfo = null;
        this.initCurBuyOfferData();
        this.renderBuyOfferInfo(this.buyOfferInfo);
        this.refreshQuotationList();
        this.renderQuotaionByMaterial(this.buyOfferInfo);
        this.setBtnVisible();
    }
}

