/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.messageCenter.pushletClient;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.scm.sm.pur.b2b.PurCloudConfigInfo;
import com.kingdee.eas.scm.sm.pur.b2b.app.PurCloudConfigHelper;
import java.util.ArrayList;
import java.util.Locale;

public class DCConfig {
    private static Context ctx = null;
    private static String dcName = null;
    private static String solution = null;
    private static String username = null;
    private static String password = null;

    private static void load() throws BOSException {
        PurCloudConfigInfo configInfo = PurCloudConfigHelper.getInfo();
        dcName = configInfo.getDcname();
        solution = configInfo.getSolution();
        username = configInfo.getUsername();
        password = configInfo.getPassword();
    }

    public static void initContext() throws BOSException {
        DCConfig.load();
        ArrayList newList = null;
        try {
            newList = DCManager.getInstance().getDCList();
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        if (newList != null && newList.size() > 0) {
            for (int i = 0; i < newList.size(); ++i) {
                DCInfo info = (DCInfo)newList.get(i);
                if (!DCConfig.getDcName().equals(info.getNumber())) continue;
                UserInfo userInfo = new UserInfo();
                userInfo.setNumber(DCConfig.getUsername());
                ctx = new Context(null, info.getSolutionName(), info.getNumber(), null);
                ctx.setUserName(DCConfig.getUsername());
                ctx.put((Object)"dbType", (Object)DCConfig.getDBType(info.getDBType()));
                ctx.put((Object)"UserInfo", (Object)userInfo);
                ctx.setLocale(new Locale("l2"));
                break;
            }
        }
        if (ctx == null) {
            throw new BOSException("PurCloudConfig.properties \u914d\u7f6e\u7684\u6570\u636e\u4e2d\u5fc3\u9519\u8bef");
        }
    }

    public static String getDcName() {
        return dcName;
    }

    public static String getSolution() {
        return solution;
    }

    public static String getUsername() {
        return username;
    }

    public static String getPassword() {
        return password;
    }

    public static Context getContext() {
        return ctx;
    }

    private static String getDBType(int dbType) {
        switch (dbType) {
            case 0: {
                return "MS SQL Server";
            }
            case 1: {
                return "DB2";
            }
        }
        return "Oracle";
    }
}

