/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.common.perf.client.JobMonitorManager;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.scm.cal.client.AbstractBillBalanceAccountInitUI;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Map;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BillBalanceAccountInitUI
extends AbstractBillBalanceAccountInitUI {
    private static final Logger logger = CoreUIObject.getLogger(BillBalanceAccountInitUI.class);
    private static final int minPeriod = 1;
    private static final int maxPeriod = 12;
    private static final int minYear = 1990;
    private static final int maxYear = 2027;

    public BillBalanceAccountInitUI() throws Exception {
        this.addEventLisener();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.lblImage.setIcon(EASResource.getIcon((String)"imgGuide_pic260"));
        this.kdtDesc.setWrapStyleWord(false);
        this.kdtDesc.setText(EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"AccountInitDesc"));
        this.kdtDesc.setToolTipText(null);
        this.kdtMessage.setText(EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"AccountInitTip"));
        this.kdtMessage.setEnabled(false);
        Calendar now = Calendar.getInstance();
        BillBalanceAccountInitUI.setSpinnerValue(this.spinBeginYear, now.get(1), 1990, 2027);
        BillBalanceAccountInitUI.setSpinnerValue(this.spinEndYear, now.get(1), 1990, 2027);
        BillBalanceAccountInitUI.setSpinnerValue(this.spinBeginPeriod, 1, 1, 12);
        BillBalanceAccountInitUI.setSpinnerValue(this.spinEndPeriod, 12, 1, 12);
    }

    private static void setSpinnerValue(KDSpinner spn, Integer val, Integer min, Integer max) {
        spn.setValue((Object)val);
        SpinnerNumberModel model = (SpinnerNumberModel)spn.getModel();
        model.setMinimum(min);
        model.setMaximum(max);
    }

    private void addEventLisener() {
        this.spinBeginYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Integer yearFrom = (Integer)BillBalanceAccountInitUI.this.spinBeginYear.getValue();
                if (yearFrom == null || yearFrom == 0) {
                    return;
                }
                Integer yearTo = (Integer)BillBalanceAccountInitUI.this.spinEndYear.getValue();
                if (yearTo == null || yearTo.compareTo(yearFrom) < 0) {
                    yearTo = yearFrom;
                    BillBalanceAccountInitUI.this.spinEndYear.setValue((Object)yearTo);
                    BillBalanceAccountInitUI.setSpinnerValue(BillBalanceAccountInitUI.this.spinEndYear, yearTo, yearTo, 2027);
                    Integer periodFrom = (Integer)BillBalanceAccountInitUI.this.spinBeginPeriod.getValue();
                    if (periodFrom == null || periodFrom == 0) {
                        return;
                    }
                    Integer periodTo = (Integer)BillBalanceAccountInitUI.this.spinEndPeriod.getValue();
                    if (periodTo == null || periodTo.compareTo(periodFrom) < 0) {
                        periodTo = periodFrom;
                        BillBalanceAccountInitUI.this.spinEndPeriod.setValue((Object)periodTo);
                        BillBalanceAccountInitUI.setSpinnerValue(BillBalanceAccountInitUI.this.spinEndPeriod, periodTo, periodTo, 12);
                    }
                }
                BillBalanceAccountInitUI.setSpinnerValue(BillBalanceAccountInitUI.this.spinEndYear, yearTo, yearFrom, 2027);
            }
        });
        this.spinBeginPeriod.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Integer periodFrom = (Integer)BillBalanceAccountInitUI.this.spinBeginPeriod.getValue();
                if (periodFrom == null || periodFrom == 0) {
                    return;
                }
                Integer periodTo = (Integer)BillBalanceAccountInitUI.this.spinEndPeriod.getValue();
                Integer yearFrom = (Integer)BillBalanceAccountInitUI.this.spinBeginYear.getValue();
                Integer yearTo = (Integer)BillBalanceAccountInitUI.this.spinEndYear.getValue();
                if (periodTo == null || yearFrom.compareTo(yearTo) == 0 && periodTo.compareTo(periodFrom) < 0) {
                    periodTo = periodFrom;
                    BillBalanceAccountInitUI.this.spinEndPeriod.setValue((Object)periodTo);
                    BillBalanceAccountInitUI.setSpinnerValue(BillBalanceAccountInitUI.this.spinEndPeriod, periodTo, periodTo, 12);
                }
                BillBalanceAccountInitUI.setSpinnerValue(BillBalanceAccountInitUI.this.spinEndPeriod, periodTo, periodFrom, 12);
            }
        });
    }

    private boolean verify() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionInitStart_actionPerformed(ActionEvent e) throws Exception {
        this.changeBtnStatus(false);
        CalculateParams params = new CalculateParams();
        params.setInt("startYear", ((Integer)this.spinBeginYear.getValue()).intValue());
        params.setInt("startPeriod", ((Integer)this.spinBeginPeriod.getValue()).intValue());
        params.setInt("endYear", ((Integer)this.spinEndYear.getValue()).intValue());
        params.setInt("endPeriod", ((Integer)this.spinEndPeriod.getValue()).intValue());
        JobParam jobParam = new JobParam((Object)params);
        JobConfig jobCfg = this.createJobCfg();
        MsgBox.showWarning((String)CalculateClientUtil.getCalResource("ACCOUNT_INIT_RUNNING_MSG"));
        try {
            String jobInstExtId;
            params.setObject("CURRENT_USER", (Object)SysContext.getSysContext().getCurrentUserInfo());
            params.setObject("CURRENT_COMPANY", (Object)SysContext.getSysContext().getCurrentFIUnit());
            params.setObject("CURRENT_CU", (Object)SysContext.getSysContext().getCurrentCtrlUnit());
            params.setObject("languageLocale", (Object)SysContext.getSysContext().getLocale());
            params.setString("title", CalculateClientUtil.getCalResource("AccountInitTitle"));
            Map result = CreateJobFacadeFactory.getRemoteInstance().executeJob(jobParam, jobCfg);
            if (null != result && null != (jobInstExtId = (String)result.get("jobInstExtId"))) {
                JobMonitorManager.getInstance().addMonitorInfo(jobInstExtId, jobCfg.getTitle());
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
        }
        finally {
            this.disposeUIWindow();
        }
    }

    private void changeBtnStatus(boolean status) {
        this.btnAccountInit.setEnabled(status);
        this.btnExit.setEnabled(status);
    }

    private JobConfig createJobCfg() {
        String title = CalculateClientUtil.getCalResource("AccountInitTitle");
        JobConfig jobCfg = new JobConfig();
        jobCfg.setTitle(title);
        jobCfg.setTaskType("SCM_CAL_ACCOUNT_INIT");
        jobCfg.setDescription(title);
        jobCfg.setNeedCheckTaskType(false);
        jobCfg.setMutex("accountInit");
        jobCfg.setNumber("SCM_CAL_ACCOUNT_INIT");
        return jobCfg;
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }
}

