/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalcuateRefactorFacadeFactory;
import com.kingdee.eas.scm.cal.CalculateKindRefactorBillFactory;
import com.kingdee.eas.scm.cal.CalculateKindRefactorBillInfo;
import com.kingdee.eas.scm.cal.CalculateKindRefactorEntryInfo;
import com.kingdee.eas.scm.cal.ICalcuateRefactorFacade;
import com.kingdee.eas.scm.cal.client.AbstractCalculateKindRefactorEditUI;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.HashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CalculateKindRefactorEditUI
extends AbstractCalculateKindRefactorEditUI
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private static final String Resource = "com.kingdee.eas.scm.cal.CalCommonResource";
    private static final String MATERIALNUMBER = "materialNumber";
    private static final String MATERILANAME = "materilaName";
    private static final String MATERILAMODEL = "materilaModel";
    private static final String BASEUNIT = "baseUnit";
    private static final String PERIODBEGINQTY = "periodBeginQty";
    private static final String PERIODBEGINAMOUNT = "periodBeginAmount";
    private static final String PERIODBEGINAVGPRICE = "periodBeginAvgPrice";
    private static final String PERIODBEGINDIFFER = "periodBeginDiffer";
    private static final String ADJAFTACTUALAMOUNT = "adjAftActualAmount";
    private static final String NEWSTANDARDPRICE = "newStandardPrice";
    private static final String REMARK = "remark";
    private static final String[] ALCOLUMNS = new String[]{"materialNumber", "materilaName", "materilaModel", "baseUnit", "periodBeginQty", "periodBeginAmount", "periodBeginAvgPrice", "periodBeginDiffer", "adjAftActualAmount", "newStandardPrice", "remark"};
    private static BigDecimal ZERO = new BigDecimal("0.0");
    private PeriodInfo currentPeriodInfo = null;
    private KDBizPromptBox kDBizPromptBoxMaterial = null;
    private int amtPrecision = 2;
    protected CompanyOrgUnitInfo company = null;
    ICalcuateRefactorFacade refRemote = null;
    private static final String[] TOTALCOL = new String[]{"periodBeginAmount"};
    protected CompanyOrgUnitInfo cou = null;

    public CalculateKindRefactorEditUI() throws Exception {
        SCMClientHelper.registerTotalColumns((String[])TOTALCOL);
    }

    public void onLoad() throws Exception {
        if (this.getOprtState() == null) {
            this.setOprtState("ADDNEW");
        }
        this.kdtEntry.checkParsed();
        super.onLoad();
        this.initTable();
        this.actionUnAudit.setVisible(false);
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    public void verifyInput(ActionEvent e) {
        if (this.editData.getRefactorReason() != null && this.editData.getRefactorReason().trim().length() > 80) {
            MsgBox.showInfo((String)EASResource.getString((String)Resource, (String)"REFACTORCAUSE"));
            SysUtil.abort();
        }
        if (this.editData.getNewAccountType() == this.editData.getSoureAccountType()) {
            MsgBox.showInfo((String)EASResource.getString((String)Resource, (String)"CALCULSAME"));
            SysUtil.abort();
        }
        if (this.currentPeriodInfo != null) {
            if (this.editData.getYear() != this.currentPeriodInfo.getPeriodYear() || this.editData.getPeriod() != this.currentPeriodInfo.getPeriodNumber()) {
                MsgBox.showInfo((String)EASResource.getString((String)Resource, (String)"PERIODNOTCORRECT"));
                SysUtil.abort();
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)Resource, (String)"NOTYEARANDPERIOD"));
            SysUtil.abort();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.company = this.editData.getCompanyOrgUnit();
        try {
            this.SetTableFormat();
            if (this.currentPeriodInfo == null && this.prmtCompanyOrgUnit.getValue() != null) {
                this.currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getValue()));
            }
            if ("ADDNEW".equals(this.getOprtState())) {
                if (this.currentPeriodInfo == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)Resource, (String)"NOTYEARANDPERIOD"));
                } else {
                    this.txtYear.setText(String.valueOf(this.currentPeriodInfo.getPeriodYear()));
                    this.txtPeriod.setText(String.valueOf(this.currentPeriodInfo.getPeriodNumber()));
                }
                this.kdtEntry.getColumn(NEWSTANDARDPRICE).getStyleAttributes().setHided(true);
            }
            this.initBillControl();
            this.initTable();
            this.changeNewAccountTypeItems();
            this.addControlListener();
            this.changeStatus();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void setDefaultMainOrgUnit() {
        if (this.editData.getId() == null && OprtState.ADDNEW.equals(this.getOprtState()) && this.getMainOrgUnit() != null && this.getDefaultMainBizOrg() != null && !this.isCoay) {
            PreChangeEvent pce = new PreChangeEvent((Object)this.getMainOrgUnit());
            pce.setData(this.getMainOrgUnit().getData());
            this.changeMainOrgUnit(pce);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (null == this.prmtCompanyOrgUnit.getValue()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)Resource, (String)"COMPANY_NOTNULL"));
            SysUtil.abort();
        }
        try {
            super.actionSubmit_actionPerformed(e);
            this.changeStatus();
        }
        catch (Exception ee) {
            this.handUIException(ee);
        }
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.basedata.master.material.app", "F7MaterialFINoGroupQuery");
        CacheServiceFactory.getInstance().discardQuery((IMetaDataPK)pk);
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.basedata.master.material.app", "F7MaterialFINoGroupQuery");
        CacheServiceFactory.getInstance().discardQuery((IMetaDataPK)pk);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.initTable();
        this.changeStatus();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.initTable();
        this.changeStatus();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.initTable();
        this.changeStatus();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.initTable();
        this.changeStatus();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.initBillControl();
        this.initTable();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.initBillControl();
        this.initTable();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        this.kdtEntry.getEditManager().stopEditing();
        String[] checkCols = new String[]{MATERIALNUMBER};
        if (e != null && e.getSource() != null && (e.getSource() == this.btnSave || e.getSource() == this.menuItemSave)) {
            int rowCount = this.getDetailTable().getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                if (!InvClientUtils.isRowBlankOnTable((KDTable)this.getDetailTable(), (int)i, (String[])checkCols)) continue;
                this.removeLine(this.getDetailTable(), i);
                --i;
                --rowCount;
            }
            if (rowCount == 0) {
                this.addLine(this.getDetailTable());
            }
            return;
        }
        int entryCount = this.kdtEntry.getRowCount();
        for (int i = 0; i < entryCount; ++i) {
            MaterialInfo material = (MaterialInfo)this.kdtEntry.getCell(i, MATERIALNUMBER).getValue();
            if (InvClientUtils.isRowBlankOnTable((KDTable)this.getDetailTable(), (int)i, (String[])checkCols)) {
                this.removeLine(this.getDetailTable(), i);
                --i;
                --entryCount;
                continue;
            }
            if (material != null) continue;
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)Resource, (String)"MUSTINPUTMATERIEL"));
            this.kdtEntry.getEditManager().editCellAt(i, this.kdtEntry.getColumnIndex(MATERIALNUMBER));
            SysUtil.abort();
        }
        if (this.getDetailTable().getRowCount() == 0) {
            this.addLine(this.getDetailTable());
            if (InvClientUtils.isRowBlankOnTable((KDTable)this.getDetailTable(), (int)0, (String[])checkCols)) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)Resource, (String)"MUSTINPUTMATERIEL"));
                this.kdtEntry.getEditManager().editCellAt(0, this.kdtEntry.getColumnIndex(MATERIALNUMBER));
                SysUtil.abort();
            }
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CalculateKindRefactorBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected IObjectValue createNewData() {
        return this.getCalculateBill();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return this.getRefActorEntryInfo();
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    private CalculateKindRefactorBillInfo getCalculateBill() {
        CalculateKindRefactorBillInfo bill = new CalculateKindRefactorBillInfo();
        try {
            bill.setBaseStatus(BillBaseStatusEnum.ADD);
            bill.setHasEffected(false);
            this.comboSoureAccountType.setSelectedItem((Object)AccountType.STANDARDCOST);
            this.changeNewAccountTypeItems();
            bill.setSoureAccountType(AccountType.STANDARDCOST);
            bill.setNewAccountType((AccountType)this.comboNewAccountType.getSelectedItem());
            this.pkAudiDate.setValue(null);
            this.pkLastModiDate.setValue(null);
            bill.setBizDate(SCMClientUtils.getServerDate2());
            bill.setCreateTime(SCMClientUtils.getServerDate());
            bill.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getDefaultMainBizOrg();
            bill.setCompanyOrgUnit(company);
            if (company != null) {
                this.currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company);
                if (this.currentPeriodInfo != null) {
                    this.txtYear.setText(String.valueOf(this.currentPeriodInfo.getPeriodYear()));
                    this.txtPeriod.setText(String.valueOf(this.currentPeriodInfo.getPeriodNumber()));
                    bill.setYear(this.currentPeriodInfo.getPeriodYear());
                    bill.setPeriod(this.currentPeriodInfo.getPeriodNumber());
                }
            }
            BillTypeInfo aBillTypeInfo = new BillTypeInfo();
            aBillTypeInfo.setId(BOSUuid.read((String)"XlazxwEREADgAAAJwKgSxUY+1VI="));
            bill.setBillType(aBillTypeInfo);
            bill.getEntry().add(new CalculateKindRefactorEntryInfo());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return bill;
    }

    private CalculateKindRefactorEntryInfo getRefActorEntryInfo() {
        CalculateKindRefactorEntryInfo entry = new CalculateKindRefactorEntryInfo();
        entry.setBaseStatus(EntryBaseStatusEnum.ADD);
        entry.setPeriodBeginQty(ZERO);
        entry.setPeriodBeginAmount(ZERO);
        entry.setAdjAftActualAmount(ZERO);
        entry.setAssCoefficient(ZERO);
        entry.setPeriodBeginDiffer(ZERO);
        entry.setPeriodBeginAvgPrice(ZERO);
        entry.setPeriodBeginDiffer(ZERO);
        return entry;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtCompanyOrgUnit;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtCompanyOrgUnit;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected void initNeedMainOrgF7s() {
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.getKDBizPromptBoxMaterial()});
    }

    public KDBizPromptBox getKDBizPromptBoxMaterial() {
        if (this.kDBizPromptBoxMaterial == null) {
            this.kDBizPromptBoxMaterial = this.getBizMaterialF7(this.kdtEntry.getColumn(MATERIALNUMBER), null);
            this.getKDBizPromptBoxMaterial().addChangeListener((ChangeListener)this);
        }
        return this.kDBizPromptBoxMaterial;
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        int length;
        Object o = this.kDBizPromptBoxMaterial.getValue();
        KDTSelectBlock ksb = this.kdtEntry.getSelectManager().get();
        if (ksb == null) {
            return;
        }
        int beginRow = ksb.getBeginRow();
        if (o == null) {
            InvClientUtils.setCellValueNull((KDTable)this.kdtEntry, null, (int)beginRow, (boolean)true);
        }
        if (!(o instanceof MaterialInfo[]) && !(o instanceof Object[])) {
            return;
        }
        MaterialInfo[] materialInfos = null;
        if (o instanceof MaterialInfo[]) {
            materialInfos = (MaterialInfo[])o;
        } else if (o instanceof Object[]) {
            Object[] objects = (Object[])o;
            if (objects.length == 0) {
                return;
            }
            materialInfos = new MaterialInfo[objects.length];
            System.arraycopy(objects, 0, materialInfos, 0, objects.length);
        }
        int n = length = materialInfos == null ? 0 : materialInfos.length;
        if (length > 0) {
            this.getKDBizPromptBoxMaterial().removeChangeListener((ChangeListener)this);
            int curCol = this.kdtEntry.getColumnIndex(MATERIALNUMBER);
            for (int i = 0; i < length; ++i) {
                if (materialInfos[i] == null) {
                    return;
                }
                IRow curRow2 = this.kdtEntry.getRow(beginRow + i);
                curRow2.getCell(curCol).setValue(null);
                InvClientUtils.setCellValueNull((KDTable)this.kdtEntry, null, (int)(beginRow + i), (boolean)true);
                curRow2.getCell(curCol).setValue((Object)materialInfos[i]);
                try {
                    this.tableValueChanged(i + beginRow, curCol);
                }
                catch (Exception e1) {
                    this.handUIException(e1);
                }
                if (i >= length - 1) continue;
                this.insertLine(beginRow + i + 1);
            }
            this.getKDBizPromptBoxMaterial().addChangeListener((ChangeListener)this);
        }
    }

    private void tableValueChanged(int rowIndex, int colIndex) throws EASBizException, BOSException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo;
        KDTable kdTable = this.kdtEntry;
        int selectRow = rowIndex;
        int selectCol = colIndex;
        int maxRow = kdTable.getRowCount();
        int colMaterialNum = kdTable.getColumnIndex(MATERIALNUMBER);
        if (this.currentPeriodInfo == null) {
            this.currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getValue()));
        }
        if (this.currentPeriodInfo == null) {
            MsgBox.showInfo((String)EASResource.getString((String)Resource, (String)"NOTYEARANDPERIOD"));
            SysUtil.abort();
        }
        if ((aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getValue()) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)Resource, (String)"COMPANY_NOTNULL"));
            return;
        }
        CurrencyInfo baseCurrInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(aCompanyOrgUnitInfo.getBaseCurrency().getId()));
        this.amtPrecision = baseCurrInfo.getPrecision();
        Object temp = kdTable.getCell(selectRow, colMaterialNum).getValue();
        if (temp instanceof MaterialInfo) {
            MaterialInfo aMaterialInfo = (MaterialInfo)temp;
            if (aMaterialInfo != null && selectCol == colMaterialNum) {
                for (int i = 0; i < maxRow; ++i) {
                    MaterialInfo otherMaterialInfo;
                    if (i == selectRow || (otherMaterialInfo = (MaterialInfo)kdTable.getRow(i).getCell(colMaterialNum).getValue()) == null || !otherMaterialInfo.getNumber().toString().equals(aMaterialInfo.getNumber().toString())) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)Resource, (String)"SAME_MATERIEL"));
                    kdTable.getRow(selectRow).getCell(colMaterialNum).setValue(null);
                    return;
                }
                kdTable.getRow(selectRow).getCell(MATERILANAME).setValue((Object)aMaterialInfo.getName());
                kdTable.getRow(selectRow).getCell(MATERILAMODEL).setValue((Object)aMaterialInfo.getModel());
                IMeasureUnit munit = MeasureUnitFactory.getRemoteInstance();
                MeasureUnitInfo info = munit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(aMaterialInfo.getBaseUnit().getId()));
                int qtyPrecision = 4;
                if (info != null) {
                    kdTable.getRow(selectRow).getCell(BASEUNIT).setValue((Object)info);
                    IMultiMeasureUnit imm = MultiMeasureUnitFactory.getRemoteInstance();
                    qtyPrecision = imm.getQtyPrecision(aMaterialInfo.getId().toString(), info.getId().toString());
                } else {
                    kdTable.getRow(selectRow).getCell(BASEUNIT).setValue(null);
                }
                int pricePrecision = aMaterialInfo.getPricePrecision();
                BigDecimal ZERO = new BigDecimal(String.valueOf("0.0"));
                if (this.refRemote == null) {
                    this.refRemote = CalcuateRefactorFacadeFactory.getRemoteInstance();
                }
                BigDecimal[] qtyAndAmount = this.refRemote.getPdBegQtyAndAmount(aMaterialInfo.getId().toString(), aCompanyOrgUnitInfo.getId().toString(), null, null, this.currentPeriodInfo);
                kdTable.getRow(selectRow).getCell(PERIODBEGINQTY).setValue((Object)qtyAndAmount[0]);
                kdTable.getRow(selectRow).getCell(PERIODBEGINAMOUNT).setValue((Object)qtyAndAmount[1]);
                BigDecimal periodAvgPrice = qtyAndAmount[0].compareTo(ZERO) == 0 ? ZERO : qtyAndAmount[1].divide(qtyAndAmount[0], pricePrecision, 4);
                kdTable.getRow(selectRow).getCell(PERIODBEGINAVGPRICE).setValue((Object)periodAvgPrice);
                kdTable.getRow(selectRow).getCell(PERIODBEGINDIFFER).setValue((Object)qtyAndAmount[2]);
                kdTable.getRow(selectRow).getCell(ADJAFTACTUALAMOUNT).setValue((Object)qtyAndAmount[1].add(qtyAndAmount[2]));
                kdTable.getRow(selectRow).getCell(NEWSTANDARDPRICE).setValue((Object)periodAvgPrice);
                SCMClientUtils.changeTableColPrecision((int)qtyPrecision, (KDTable)kdTable, (String[])new String[]{PERIODBEGINQTY}, (int)rowIndex);
                SCMClientUtils.changeTableColPrecision((int)pricePrecision, (KDTable)kdTable, (String[])new String[]{PERIODBEGINAVGPRICE, NEWSTANDARDPRICE}, (int)rowIndex);
                SCMClientUtils.changeTableColPrecision((int)this.amtPrecision, (KDTable)kdTable, (String[])new String[]{PERIODBEGINAMOUNT, ADJAFTACTUALAMOUNT, PERIODBEGINDIFFER}, (int)rowIndex);
            }
            if (maxRow > 1) {
                this.kdtEntry.getRow(maxRow - 1).getCell(PERIODBEGINDIFFER).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.amtPrecision));
            }
        } else {
            kdTable.removeRow(selectRow);
            this.addLine(this.kdtEntry);
        }
    }

    private void SetTableFormat() throws EASBizException, BOSException {
        int maxRow = this.kdtEntry.getRowCount();
        if (this.prmtCompanyOrgUnit.getValue() != null) {
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getValue();
            CurrencyInfo baseCurrInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(aCompanyOrgUnitInfo.getBaseCurrency().getId()));
            int amtPrecision = baseCurrInfo.getPrecision();
            String amtFormat = CalculateUtil.fmtTableString(amtPrecision).toString();
            this.kdtEntry.getColumn(PERIODBEGINAMOUNT).getStyleAttributes().setNumberFormat(amtFormat);
            this.kdtEntry.getColumn(ADJAFTACTUALAMOUNT).getStyleAttributes().setNumberFormat(amtFormat);
            this.kdtEntry.getColumn(PERIODBEGINDIFFER).getStyleAttributes().setNumberFormat(amtFormat);
            for (int i = 0; i < maxRow; ++i) {
                MaterialInfo aMaterialInfo = (MaterialInfo)this.kdtEntry.getRow(i).getCell(MATERIALNUMBER).getValue();
                if (aMaterialInfo == null) continue;
                IMeasureUnit munit = MeasureUnitFactory.getRemoteInstance();
                MeasureUnitInfo aMeasureUnitInfo = munit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(aMaterialInfo.getBaseUnit().getId()));
                IMultiMeasureUnit imm = MultiMeasureUnitFactory.getRemoteInstance();
                int qtyPrecision = imm.getQtyPrecision(aMaterialInfo.getId().toString(), aMeasureUnitInfo.getId().toString());
                String c = CalculateUtil.fmtTableString(qtyPrecision).toString();
                this.kdtEntry.getRow(i).getCell(PERIODBEGINQTY).getStyleAttributes().setNumberFormat(c);
                int pricePrecision = aMaterialInfo.getPricePrecision();
                c = CalculateUtil.fmtTableString(pricePrecision).toString();
                SCMClientUtils.changeTableColPrecision((int)pricePrecision, (KDTable)this.kdtEntry, (String[])new String[]{PERIODBEGINAVGPRICE, NEWSTANDARDPRICE}, (int)i);
            }
        }
    }

    private void initBillControl() {
        this.btnCreateFrom.setVisible(false);
        this.txtPeriod.setEnabled(false);
        this.txtYear.setEnabled(false);
        this.btnPrint.setVisible(false);
        this.btnPageSetup.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnTraceDown.setVisible(false);
        this.btnTraceUp.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.menuItemTraceDown.setVisible(false);
        this.menuItemTraceUp.setVisible(false);
        this.menuItemPrint.setVisible(false);
        this.menuItemPrintPreview.setVisible(false);
        this.menuTable1.setVisible(false);
        this.setChkVisiable();
    }

    private void addControlListener() {
        if (this.getOprtState().equals("ADDNEW") || this.getOprtState().equals("EDIT") || this.getOprtState().equals("VIEW") && this.editData.getBaseStatus().getValue() != 4) {
            this.comboSoureAccountType.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        CalculateKindRefactorEditUI.this.comboSoureAccountType_itemStateChanged(e);
                    }
                    catch (Exception exc) {
                        CalculateKindRefactorEditUI.this.handUIException(exc);
                    }
                }
            });
            this.comboNewAccountType.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        CalculateKindRefactorEditUI.this.comboNewAccountType_itemStateChanged(e);
                    }
                    catch (Exception exc) {
                        CalculateKindRefactorEditUI.this.handUIException(exc);
                    }
                }
            });
            this.prmtCompanyOrgUnit.addPreChangeListener(new PreChangeListener(){

                public void preChange(PreChangeEvent e) {
                    CalculateKindRefactorEditUI.this.changeMainOrgUnit(e);
                }
            });
        }
    }

    protected void initTable() throws EASBizException, BOSException {
        this.kdtEntry.getColumn(MATERIALNUMBER).setWidth(100);
        this.kdtEntry.getColumn(MATERILANAME).setWidth(150);
        this.kdtEntry.getColumn(MATERILAMODEL).setWidth(100);
        this.kdtEntry.getColumn(BASEUNIT).setWidth(100);
        this.kdtEntry.getColumn(PERIODBEGINQTY).setWidth(100);
        this.kdtEntry.getColumn(PERIODBEGINAMOUNT).setWidth(100);
        this.kdtEntry.getColumn(PERIODBEGINAVGPRICE).setWidth(100);
        this.kdtEntry.getColumn(PERIODBEGINDIFFER).setWidth(100);
        this.kdtEntry.getColumn(ADJAFTACTUALAMOUNT).setWidth(150);
        this.kdtEntry.getColumn(NEWSTANDARDPRICE).setWidth(100);
        this.kdtEntry.getColumn(REMARK).setWidth(200);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntry.getColumn(MATERIALNUMBER).setRenderer((IBasicRender)avr);
        SCMClientUtils.setNecessColorInTable((KDTable)this.kdtEntry, (String[])new String[]{MATERIALNUMBER});
        this.kdtEntry.getColumn(MATERILANAME).getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn(MATERILAMODEL).getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn(BASEUNIT).getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn(PERIODBEGINAVGPRICE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntry.getColumn(PERIODBEGINAVGPRICE).getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn(PERIODBEGINQTY).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntry.getColumn(PERIODBEGINQTY).getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn(PERIODBEGINAMOUNT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntry.getColumn(PERIODBEGINAMOUNT).getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn(PERIODBEGINAVGPRICE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntry.getColumn(PERIODBEGINDIFFER).getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn(ADJAFTACTUALAMOUNT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntry.getColumn(ADJAFTACTUALAMOUNT).getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn(ADJAFTACTUALAMOUNT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntry.getColumn(ADJAFTACTUALAMOUNT).getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn(NEWSTANDARDPRICE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntry.getColumn(NEWSTANDARDPRICE).getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn(PERIODBEGINDIFFER).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntry.getColumn(PERIODBEGINDIFFER).getStyleAttributes().setLocked(true);
        if (this.editData.getNewAccountType() != null && this.editData.getNewAccountType().getValue() != 2) {
            this.kdtEntry.getColumn(NEWSTANDARDPRICE).getStyleAttributes().setHided(true);
        }
        this.setMaterialF7();
        SCMClientUtils.setEntriesTableStrLength((KDTable)this.kdtEntry, (String[])new String[]{REMARK}, (int)255);
    }

    private void setMaterialF7() throws BOSException {
        AccountType accountType = (AccountType)this.comboSoureAccountType.getSelectedItem();
        if (accountType == null) {
            return;
        }
        boolean isExistAccountType = false;
        if ((this.getOprtState().equals("ADDNEW") || this.getOprtState().equals("EDIT") || this.getOprtState().equals("VIEW")) && this.getKDBizPromptBoxMaterial() != null) {
            this.getKDBizPromptBoxMaterial().setValue(null);
            EntityViewInfo view = this.getKDBizPromptBoxMaterial().getEntityViewInfo();
            if (null != view) {
                FilterItemCollection filters = view.getFilter().getFilterItems();
                for (int i = 0; filters != null && i < filters.size(); ++i) {
                    if (!filters.get(i).getPropertyName().equals("FIInfo.accountType")) continue;
                    filters.get(i).setCompareValue((Object)new Integer(accountType.getValue()));
                    isExistAccountType = true;
                }
                if (!isExistAccountType) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("FIInfo.accountType", (Object)new Integer(accountType.getValue()), CompareType.EQUALS));
                    view.getFilter().mergeFilter(filter, "and");
                }
            } else {
                view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("FIInfo.accountType", (Object)new Integer(accountType.getValue()), CompareType.EQUALS));
                view.getFilter().mergeFilter(filter, "and");
            }
            this.getKDBizPromptBoxMaterial().setEntityViewInfo(view);
        }
    }

    protected void comboNewAccountType_itemStateChanged(ItemEvent e) throws Exception {
        AccountType newType = (AccountType)this.comboNewAccountType.getSelectedItem();
        if (newType == null) {
            return;
        }
        if (newType.getValue() == 2) {
            this.kdtEntry.getColumn(PERIODBEGINDIFFER).getStyleAttributes().setHided(true);
            this.kdtEntry.getColumn(ADJAFTACTUALAMOUNT).getStyleAttributes().setHided(true);
            this.kdtEntry.getColumn(NEWSTANDARDPRICE).getStyleAttributes().setHided(false);
        } else if (newType.getValue() != 2) {
            this.kdtEntry.getColumn(NEWSTANDARDPRICE).getStyleAttributes().setHided(true);
            this.kdtEntry.getColumn(PERIODBEGINDIFFER).getStyleAttributes().setHided(false);
            this.kdtEntry.getColumn(ADJAFTACTUALAMOUNT).getStyleAttributes().setHided(false);
        }
        this.setChkVisiable();
    }

    private void setChkVisiable() {
        AccountType newType = (AccountType)this.comboNewAccountType.getSelectedItem();
        if (newType == null) {
            return;
        }
        if (newType.getValue() == 5) {
            this.chkIsLot.setVisible(true);
            this.chkIsAssistProperty.setVisible(true);
            this.chkIsProjectNum.setVisible(true);
            this.chkIsTrackNum.setVisible(true);
        } else {
            this.chkIsLot.setVisible(false);
            this.chkIsAssistProperty.setVisible(false);
            this.chkIsProjectNum.setVisible(false);
            this.chkIsTrackNum.setVisible(false);
        }
    }

    protected void comboSoureAccountType_itemStateChanged(ItemEvent e) throws Exception {
        this.changeNewAccountTypeItems();
        this.cleanEntry();
        InvClientUtils.setCellValueNull((KDTable)this.kdtEntry, (String[])ALCOLUMNS, (int)0, (boolean)true);
        this.setMaterialF7();
    }

    protected void cleanEntry() {
        for (int i = this.getDetailTable().getRowCount() - 1; i > 0; --i) {
            this.removeLine(this.getDetailTable(), i);
        }
    }

    protected void setMainBizOrgF7(KDBizPromptBox bizOrgUnitBox, OrgType orgType) {
        super.setMainBizOrgF7(bizOrgUnitBox, orgType);
    }

    private void changeStatus() {
        if (this.getOprtState().equals("ADDNEW") || this.getOprtState().equals("EDIT")) {
            this.setStatus(true);
        } else if (this.getOprtState().equals("VIEW")) {
            this.setStatus(false);
            if (this.editData.getBaseStatus().getValue() != 4) {
                this.btnEdit.setEnabled(true);
            } else {
                this.btnEdit.setEnabled(false);
            }
        }
    }

    private void setStatus(boolean status) {
        this.btnSave.setEnabled(status);
        this.btnAddLine.setEnabled(status);
        this.btnRemoveLine.setEnabled(status);
        this.btnInsertLine.setEnabled(status);
        this.comboSoureAccountType.setEnabled(status);
        this.comboNewAccountType.setEnabled(status);
    }

    private void changeNewAccountTypeItems() {
        AccountType sourceType = (AccountType)this.comboSoureAccountType.getSelectedItem();
        AccountType newType = (AccountType)this.comboNewAccountType.getSelectedItem();
        if (sourceType == null) {
            return;
        }
        this.comboNewAccountType.removeAllItems();
        if (sourceType.getValue() == 1) {
            this.comboNewAccountType.addItem((Object)AccountType.STANDARDCOST);
            this.comboNewAccountType.addItem((Object)AccountType.ADD_AVERAGE);
            this.comboNewAccountType.addItem((Object)AccountType.SPECIAL_ACCT);
            this.comboNewAccountType.addItem((Object)AccountType.MOVE_WEIGHTED_AVERAGE);
        } else if (sourceType.getValue() == 2) {
            this.comboNewAccountType.addItem((Object)AccountType.MOVE_ADD_AVERAGE);
            this.comboNewAccountType.addItem((Object)AccountType.ADD_AVERAGE);
            this.comboNewAccountType.addItem((Object)AccountType.SPECIAL_ACCT);
            this.comboNewAccountType.addItem((Object)AccountType.MOVE_WEIGHTED_AVERAGE);
            this.kdtEntry.getColumn(PERIODBEGINDIFFER).getStyleAttributes().setHided(false);
            this.kdtEntry.getColumn(ADJAFTACTUALAMOUNT).getStyleAttributes().setHided(false);
            this.kdtEntry.getColumn(NEWSTANDARDPRICE).getStyleAttributes().setHided(true);
        } else if (sourceType.getValue() == 3) {
            this.comboNewAccountType.addItem((Object)AccountType.SPECIAL_ACCT);
            this.comboNewAccountType.addItem((Object)AccountType.MOVE_WEIGHTED_AVERAGE);
        } else if (sourceType.getValue() == 5) {
            this.comboNewAccountType.addItem((Object)AccountType.ADD_AVERAGE);
            this.comboNewAccountType.addItem((Object)AccountType.MOVE_WEIGHTED_AVERAGE);
        } else if (sourceType.getValue() == 4) {
            this.comboNewAccountType.addItem((Object)AccountType.ADD_AVERAGE);
            this.comboNewAccountType.addItem((Object)AccountType.SPECIAL_ACCT);
            this.comboNewAccountType.addItem((Object)AccountType.MOVE_WEIGHTED_AVERAGE);
        } else if (sourceType.getValue() == 6) {
            this.comboNewAccountType.addItem((Object)AccountType.ADD_AVERAGE);
            this.comboNewAccountType.addItem((Object)AccountType.SPECIAL_ACCT);
        }
        if (newType != null) {
            this.comboNewAccountType.setSelectedItem((Object)newType);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.id"));
        sic.add(new SelectorItemInfo("entry.material.baseUnit.id"));
        sic.add(new SelectorItemInfo("entry.material.pricePrecision"));
        return sic;
    }

    protected HashMap getQueryCondition() throws Exception {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        boolean isTableFocus = SCMClientUtils.isTableFocus((KDTable)this.kdtEntry);
        hm.put("TABLEHASFOCUS", isTableFocus);
        KDTSelectBlock selectBlock = this.kdtEntry.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.kdtEntry.getRow(rowIndex);
            if (row == null) {
                return hm;
            }
            ICell cell = row.getCell(MATERIALNUMBER);
            MaterialInfo material = (MaterialInfo)cell.getValue();
            hm.put("MATERIAL", material);
            cell = row.getCell("lot");
            if (cell != null) {
                String lot = (String)cell.getValue();
                hm.put("BATCH", lot);
            }
        }
        return hm;
    }

    protected String getEntryMaterialFieldName() {
        return MATERIALNUMBER;
    }

    protected String getPermissionItem(String status) {
        if (status.equals("ADDNEW")) {
            return "calculaterefactor_new";
        }
        return null;
    }

    protected void changeMainOrgUnit(PreChangeEvent pce) {
        this.preChange(pce);
    }

    public void preChange(PreChangeEvent e) {
        if ("FINDVIEW".equals(this.getOprtState()) || "VIEW".equals(this.getOprtState())) {
            return;
        }
        if (e.getData() != null && e.getData().equals(e.getOldData())) {
            return;
        }
        e.setResult(this.prmtCompanyOrgUnit(e));
    }

    private int prmtCompanyOrgUnit(PreChangeEvent e) {
        try {
            Object obj = e.getData();
            if (obj == null) {
                this.cou = null;
            }
            if (obj instanceof CompanyOrgUnitInfo) {
                this.cou = (CompanyOrgUnitInfo)e.getData();
            }
            if (this.cou == null || !this.cou.equals(e.getOldData())) {
                this.cleanEntry();
                InvClientUtils.setCellValueNull((KDTable)this.kdtEntry, (String[])ALCOLUMNS, (int)0, (boolean)true);
                if (this.cou != null) {
                    this.currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)this.cou);
                    if (this.currentPeriodInfo != null) {
                        this.txtYear.setText(String.valueOf(this.currentPeriodInfo.getPeriodYear()));
                        this.txtPeriod.setText(String.valueOf(this.currentPeriodInfo.getPeriodNumber()));
                    }
                }
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return 1;
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    protected void setTableToSumField() {
        this.setTableToSumField(this.getDetailTable(), this.getSumColNames());
    }

    protected String[] getSumColNames() {
        return new String[]{PERIODBEGINQTY, PERIODBEGINAMOUNT, PERIODBEGINDIFFER, ADJAFTACTUALAMOUNT};
    }
}

