/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CostAdjuestCreateTypeEnum;
import com.kingdee.eas.scm.cal.CostAdjustBillCollection;
import com.kingdee.eas.scm.cal.CostAdjustBillEntryFactory;
import com.kingdee.eas.scm.cal.CostAdjustBillEntryInfo;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.ICostAdjustBillEntry;
import com.kingdee.eas.scm.cal.IWriteOffGroup;
import com.kingdee.eas.scm.cal.WriteOffGroupFactory;
import com.kingdee.eas.scm.cal.client.AbstractCostAdjustBillListUI;
import com.kingdee.eas.scm.cal.client.CostAdjustFilterUI;
import com.kingdee.eas.scm.cal.client.CostAdjustProcessor;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.client.CCRelationBillListImpl;
import com.kingdee.eas.scm.common.client.ISCMFilter;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMCommonProcessor;
import com.kingdee.eas.scm.common.client.SCMPromptBoxFactory;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class CostAdjustBillListUI
extends AbstractCostAdjustBillListUI {
    private static final long serialVersionUID = 3257923105767676388L;
    public int amtPrecision = 2;
    CostAdjustFilterUI filterUI = null;
    private final String RESOURCE = "com.kingdee.eas.scm.cal.CostAdjustBillImportDataResource";
    private OrgUnitCollection authorizedMainOrgs = null;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.menuItemImportData.setVisible(true);
        this.menuItemExportData.setVisible(true);
        if (this.getUIContext().get("BillMainQuery") != null) {
            this.setQueryPreference(true);
            this.tHelper = null;
            this.initHelper();
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnNextPerson.setVisible(true);
        this.btnMultiapprove.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.menuItemMultiapprove.setVisible(false);
        this.btnCreateTo.setVisible(false);
        this.btnCreateTo.setEnabled(false);
        this.btnTraceUp.setVisible(false);
        this.actionUnAudit.setVisible(true);
        this.menuItemVoucher.setVisible(true);
        this.menuItemDelVoucher.setVisible(true);
        this.menuItemVoucher.setEnabled(true);
        this.menuItemDelVoucher.setEnabled(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnViewWriteOffRecord.setIcon(EASResource.getIcon((String)"imgTbtn_seegather"));
    }

    public String strUITitle() {
        String strTitle = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource.CostAdjustBill");
        return strTitle;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected String getEditUIName() {
        return "com.kingdee.eas.scm.cal.client.CostAdjustBillEditUI";
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CostAdjustBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected void setWldwCell(KDTDataRequestEvent e) {
        int r1 = e.getFirstRow();
        int r2 = e.getLastRow();
        for (int i = r1; i <= r2; ++i) {
            BizEnumValueInfo tempA = (BizEnumValueInfo)this.tblMain.getRow(i).getCell("operationBillType").getValue();
            if (tempA.getInt() == 0) {
                this.tblMain.getRow(i).getCell("wldw").setValue((Object)((String)this.tblMain.getRow(i).getCell("supplier").getValue()));
                continue;
            }
            if (tempA.getInt() != 1) continue;
            this.tblMain.getRow(i).getCell("wldw").setValue((Object)((String)this.tblMain.getRow(i).getCell("customer").getValue()));
        }
        this.tblMain.getColumn("supplier").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("customer").getStyleAttributes().setHided(true);
    }

    public String[] getMergeColumnKeys() {
        String[] strMergeColKeys = new String[]{"id", "number", "bizDate", "baseStatus", "operationBillType", "outwarehouseType", "wldw", "storageOrgUnit", "supplier", "customer", "isVouchered", "voucher", "pcVouchered", "pcVoucherNumber"};
        return strMergeColKeys;
    }

    protected boolean initDefaultFilter() {
        return this.getUIContext().get("BillMainQuery") == null;
    }

    public String getEntriesName() {
        return "entry";
    }

    public String getEntriesPKName() {
        return "entry.id";
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnitInfo() throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            ICell cell;
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            String entryID = this.getEntriesPKName();
            if (entryID != null && (keyValue = (cell = row.getCell(entryID)).getValue()) != null) {
                ICostAdjustBillEntry ipe = CostAdjustBillEntryFactory.getRemoteInstance();
                CostAdjustBillEntryInfo pie = ipe.getCostAdjustBillEntryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)keyValue.toString())));
                return pie.getCompanyOrgUnit();
            }
        }
        return null;
    }

    private List getSelectedIds() {
        this.checkSelected();
        ArrayList<String> ids = new ArrayList<String>();
        KDTSelectBlock sb = null;
        int size = this.tblMain.getSelectManager().size();
        int num = 0;
        IRow row = null;
        for (int i = 0; i < size; ++i) {
            sb = this.tblMain.getSelectManager().get(i);
            num = sb.getBottom();
            for (int j = sb.getTop(); j <= num; ++j) {
                row = this.tblMain.getRow(j);
                ids.add(row.getCell("id").getValue().toString());
            }
        }
        return ids;
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list = this.getSelectedIdValues();
        if (list.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        String[] ids = null;
        Object[] obj = list.toArray();
        int length = obj.length;
        ids = new String[length];
        System.arraycopy(obj, 0, ids, 0, length);
        CompanyOrgUnitInfo companyInfo = this.getCompanyOrgUnitInfo();
        if (companyInfo != null) {
            boolean isJoinOtherBill;
            IWriteOffGroup iw = WriteOffGroupFactory.getRemoteInstance();
            iw.validateWriteOffVoucher(ids, companyInfo.getId().toString(), "410");
            if (CalculateUtil.getApportVoucherType(null, companyInfo.getId().toString()) && (isJoinOtherBill = CostAdjustBillFactory.getRemoteInstance().IsJoinWithOtherBill(ids))) {
                MsgBox.showError((String)InvClientUtils.getResource((String)"DelVoucher_IsJoinedWithOtherBill"));
                SysUtil.abort();
            }
        }
        super.actionDelVoucher_actionPerformed(e);
    }

    private boolean isCanCreateVoucher() throws Exception {
        int dischargeType = 0;
        if (this.getCompanyOrgUnitInfo() != null) {
            dischargeType = CalculateUtil.getDischargeType(null, this.getCompanyOrgUnitInfo().getId().toString());
        }
        if (dischargeType == 0) {
            return true;
        }
        ArrayList selectList = new ArrayList();
        List selectKeyIdFields = null;
        int mode = 0;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        ArrayList blockList = this.tblMain.getSelectManager().getBlocks();
        if (blockList != null && blockList.size() == 1) {
            mode = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getMode();
        }
        if (mode == 8 && selectRows.length >= KDTDataRequestManager.defaultPageRow - 1) {
            selectKeyIdFields = this.getQueryPkList();
        }
        ArrayList ret = ListUiHelper.getSelectedIdValues((KDTable)this.tblMain, (String)"createType", selectList, selectKeyIdFields);
        for (int i = 0; i < ret.size(); ++i) {
            String createType = (String)ret.get(i);
            if (!createType.equals(CostAdjuestCreateTypeEnum.AUTOCREATE.getAlias())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void actionViewWriteOffRecord_actionPerformed(ActionEvent e) throws Exception {
        CoreBillBaseCollection bills = this.getBillList();
        CCRelationBillListImpl billList = new CCRelationBillListImpl((CoreBillListUI)this);
        billList.traceDown(bills, this.getEntriesPKName());
    }

    public String[] getAmountColumns() {
        return new String[]{"amount"};
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        if (this.isSwitchView()) {
            return;
        }
        int amoutPre = 2;
        String[] amount_COLUMNS = new String[]{"entry.amount"};
        int calculateKind = 1;
        try {
            rowSet.beforeFirst();
            Map colMap = null;
            while (rowSet.next()) {
                BizEnumValueInfo bizEnum;
                amoutPre = rowSet.getInt("baseCurrency.precision");
                if (colMap == null) {
                    colMap = SCMClientUtils.getColumnsByRowSet((IRowSet)rowSet);
                }
                SCMClientUtils.iniColumnsPrecision((int)amoutPre, (String[])amount_COLUMNS, (IRowSet)rowSet, (Map)colMap);
                if (colMap != null && colMap.containsKey("calculateKind") && (bizEnum = (BizEnumValueInfo)rowSet.getObject("calculateKind")) != null) {
                    calculateKind = bizEnum.getInt();
                }
                if (calculateKind == 0) {
                    if (colMap == null || !colMap.containsKey("supplier.name")) continue;
                    rowSet.updateObject("wldw", rowSet.getObject("supplier.name"));
                    continue;
                }
                if (calculateKind != true) continue;
                rowSet.updateObject("wldw", rowSet.getObject("wldw"));
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.remove(new SelectorItemInfo("count"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("entry.actualCost"));
        sic.add(new SelectorItemInfo("entry.standardCost"));
        return sic;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new CostAdjustFilterUI();
        }
        return this.filterUI;
    }

    public CommonQueryDialog initCommonQueryDialog() {
        try {
            if (this.authorizedMainOrgs == null) {
                ISCMBillBase iBiz = (ISCMBillBase)this.getBizInterface();
                this.authorizedMainOrgs = iBiz.getAuthOrgsByType(this.getMainBizOrgType(), this.mainQueryPK);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (this.commonQueryDialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQueryDialog = super.initCommonQueryDialog();
            this.commonQueryDialog.setWidth(450);
            this.commonQueryDialog.setHeight(320);
            try {
                SCMPromptBoxFactory scmF7Factory = new SCMPromptBoxFactory(this.getFilterUI(), this.getMainBizOrgType());
                this.commonQueryDialog.setPromptBoxFactory((IPromptBoxFactory)scmF7Factory);
                this.commonQueryDialog.setProcessor((IProcessor)new SCMCommonProcessor());
                ISCMFilter iFilter = (ISCMFilter)this.getFilterUI();
                if (iFilter != null) {
                    if (this.getBOTPViewStatus() == 1) {
                        iFilter.setBOTPFilter((Map)this.getBOTPMap());
                    }
                    iFilter.setIsSupportMultiOrgs(true);
                    iFilter.setContextObject(this.getContextObject());
                    iFilter.setAuthorizedMainOrgs(this.authorizedMainOrgs);
                    this.commonQueryDialog.addUserPanel((KDPanel)this.getFilterUI());
                }
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
            this.commonQueryDialog.setProcessor((IProcessor)new CostAdjustProcessor());
        }
        return this.commonQueryDialog;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.INVENTORYACCOUNTING;
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    protected String[] getQtyColumns() throws Exception {
        return new String[]{"qty,sourceBillSeq"};
    }

    protected String[] getPriceColumns() throws Exception {
        return new String[]{"price"};
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        CostAdjustBillCollection coll = CostAdjustBillFactory.getRemoteInstance().getCostAdjustBillCollection(view);
        HashSet<String> orgSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            orgSet.add(coll.get(i).getStorageOrgUnit().getId().toString());
        }
        String[] orgIDs = new String[orgSet.size()];
        orgSet.toArray(orgIDs);
        if (!InvClientUtils.checkStorageConsignSameCompany((String[])orgIDs)) {
            return;
        }
        int size = orgIDs.length;
        try {
            IPermission iPer = PermissionFactory.getRemoteInstance();
            for (int index = 0; index < size; ++index) {
                iPer.checkFunctionPermission((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)SysContext.getSysContext().getCurrentUserInfo().getId().toString())), (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orgIDs[index].toString())), "costadjust_generalVoucher");
            }
        }
        catch (EASBizException ex) {
            this.handUIException(ex);
            return;
        }
        catch (BOSException ex) {
            this.handUIException(ex);
            return;
        }
        catch (UuidException ex) {
            this.handUIException(ex);
            return;
        }
        if (!this.isCanCreateVoucher()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"CostAdjNotAllow"));
            return;
        }
        CompanyOrgUnitInfo companyInfo = this.getCompanyOrgUnitInfo();
        if (companyInfo != null && CalculateUtil.getApportVoucherType(null, companyInfo.getId().toString())) {
            Object[] obj = idList.toArray();
            String[] ids = new String[obj.length];
            System.arraycopy(obj, 0, ids, 0, obj.length);
            boolean isJoinOtherBill = CostAdjustBillFactory.getRemoteInstance().IsJoinWithOtherBill(ids);
            if (isJoinOtherBill) {
                MsgBox.showError((String)InvClientUtils.getResource((String)"Voucher_IsJoinedWithOtherBill"));
                SysUtil.abort();
            }
        }
        this.getUIContext().put(this.getMainBizOrgType(), companyInfo);
        super.actionVoucher_actionPerformed(e);
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList createType = this.getSelectedFieldValues("note");
        CostAdjuestCreateTypeEnum createTypeEnum = null;
        for (int i = 0; i < createType.size(); ++i) {
            createTypeEnum = this.getEnumByAlias(createType.get(i).toString());
            if (CalculateClientUtil.isCanUnAudit(createTypeEnum)) continue;
            throw new CalculateException(CalculateException.COSTADJUST_UNAUDIT);
        }
        super.actionUnAudit_actionPerformed(e);
    }

    private CostAdjuestCreateTypeEnum getEnumByAlias(String alias) {
        if (alias != null && alias.equals(CostAdjuestCreateTypeEnum.USERINPUT.getAlias())) {
            return CostAdjuestCreateTypeEnum.USERINPUT;
        }
        if (alias != null && alias.equals(CostAdjuestCreateTypeEnum.APPORTION.getAlias())) {
            return CostAdjuestCreateTypeEnum.APPORTION;
        }
        if (alias != null && alias.equals(CostAdjuestCreateTypeEnum.ISSUE_COSTADJUST.getAlias())) {
            return CostAdjuestCreateTypeEnum.ISSUE_COSTADJUST;
        }
        if (alias != null && alias.equals(CostAdjuestCreateTypeEnum.ExcepAdjZero.getAlias())) {
            return CostAdjuestCreateTypeEnum.ExcepAdjZero;
        }
        if (alias != null && alias.equals(CostAdjuestCreateTypeEnum.ExpBalanceAjdust.getAlias())) {
            return CostAdjuestCreateTypeEnum.ExpBalanceAjdust;
        }
        if (alias != null && alias.equals(CostAdjuestCreateTypeEnum.MANUALIMPORT.getAlias())) {
            return CostAdjuestCreateTypeEnum.MANUALIMPORT;
        }
        if (alias != null && alias.equals(CostAdjuestCreateTypeEnum.PeriodBeginExpBalanceAjdust.getAlias())) {
            return CostAdjuestCreateTypeEnum.PeriodBeginExpBalanceAjdust;
        }
        if (alias != null && alias.equals(CostAdjuestCreateTypeEnum.PeriodEndExpBalanceAjdust.getAlias())) {
            return CostAdjuestCreateTypeEnum.PeriodEndExpBalanceAjdust;
        }
        return null;
    }

    protected String[] getQueryShowField() {
        return new String[]{"number", "baseStatus", "bizDate", "operationBillType", "outwarehouseType", "storageOrgUnit", "voucher", "materialNumber", "materialName", "materialType", "batch", "amount", "warehouse", "createType"};
    }

    protected boolean isLazyMode() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    protected String[] getQueryHideField() {
        return new String[]{"wldw", "note"};
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList expParam = this.getExportParam();
        if (expParam == null || expParam.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.invoke(expParam, 1);
    }

    protected ArrayList getExportParam() {
        DatataskParameter dtParmeter = new DatataskParameter();
        dtParmeter.solutionName = "CostAdjust";
        dtParmeter.datataskMode = 1;
        dtParmeter.varList = new ArrayList();
        dtParmeter.alias = EASResource.getString((String)"com.kingdee.eas.scm.cal.CostAdjustBillImportDataResource", (String)"COSTADJUSTBILL_SHEETNAME");
        Hashtable<String, FilterInfo> hashTab = new Hashtable<String, FilterInfo>();
        hashTab.put("filter", this.mainQuery.getFilter());
        dtParmeter.setContextParam(hashTab);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(dtParmeter);
        return paramList;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter dtParmeter = new DatataskParameter();
        dtParmeter.solutionName = solutionName = "CostAdjust";
        dtParmeter.alias = EASResource.getString((String)"com.kingdee.eas.scm.cal.CostAdjustBillImportDataResource", (String)"COSTADJUSTBILL_SHEETNAME");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(dtParmeter);
        return paramList;
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        if (this.getUIContext().get("BillQuery") != null) {
            return super.getQuickFilteringSupport();
        }
        return this.qfsi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void auditBill(ObjectUuidPK pk) throws Exception {
        String billID = this.getSelectedKeyValue();
        try {
            ((ISCMBillBase)this.getBizInterface()).passAudit((IObjectPK)pk, null);
        }
        finally {
            try {
                this.setOprtState("RELEASEALL");
                this.pubFireVOChangeListener(billID);
            }
            catch (Throwable e2) {
                this.handUIException(e2);
            }
        }
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            int rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("storageOrgUnit.id");
            Object keyValue = cell.getValue();
            if (keyValue != null) {
                return new ObjectStringPK(keyValue.toString());
            }
        }
        return super.getOrgPK(action);
    }

    protected boolean isSupportBatchSubmitAction() {
        return true;
    }

    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, CostAdjustBillFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, CostAdjustBillEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, "id", "entry.id", "number", "seq", "storageOrgUnit.id");
        super.initBatchActions();
    }

    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        if (BatchActionEnum.UNAUDIT.equals((Object)bizAction)) {
            this.checkSelected();
            ArrayList createType = this.getSelectedFieldValues("note");
            CostAdjuestCreateTypeEnum createTypeEnum = null;
            for (int i = 0; i < createType.size(); ++i) {
                createTypeEnum = this.getEnumByAlias(createType.get(i).toString());
                if (CalculateClientUtil.isCanUnAudit(createTypeEnum)) continue;
                super.handleException((Exception)((Object)new CalculateException(CalculateException.COSTADJUST_UNAUDIT)));
                return false;
            }
        }
        return super.beforeAction(bizAction, selectionEntries, event);
    }

    protected boolean isPCVoucherVisible() {
        return true;
    }

    protected String getGeneralPCVoucherPermission() {
        return "costadjust_generalPcVoucher";
    }

    protected String getStorageColName() {
        return "storageOrgUnit.id";
    }

    protected void checkOtherForPCVoucher() throws Exception {
        CompanyOrgUnitInfo companyInfo;
        super.checkOtherForPCVoucher();
        if (!this.isCanCreateVoucher()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"CostAdjNotAllow"));
            SysUtil.abort();
        }
        if ((companyInfo = this.getCompanyOrgUnitInfo()) != null && CalculateUtil.getApportVoucherType(null, companyInfo.getId().toString())) {
            List list = this.getSelectedIds();
            Object[] obj = list.toArray();
            String[] ids = new String[obj.length];
            System.arraycopy(obj, 0, ids, 0, obj.length);
            boolean isJoinOtherBill = CostAdjustBillFactory.getRemoteInstance().IsJoinWithOtherBill(ids);
            if (isJoinOtherBill) {
                MsgBox.showError((String)InvClientUtils.getResource((String)"Voucher_IsJoinedWithOtherBill"));
                SysUtil.abort();
            }
        }
    }

    protected IMetaDataPK getTDQueryPK() {
        return MetaDataPK.create((String)"com.kingdee.eas.scm.cal.CostAdjustPrintQuery");
    }

    protected String getTDFileName() {
        return "/FI/CAL/CostAdjustBill";
    }
}

