/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalRptUtilFacadeFactory;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CostComputeReportPriceSourceFactory;
import com.kingdee.eas.scm.cal.ICalRptUtilFacade;
import com.kingdee.eas.scm.cal.client.AbstractCostCumputeReportOptionUI;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CostCumputeReportOptionUI
extends AbstractCostCumputeReportOptionUI {
    private static final Logger logger = CoreUIObject.getLogger(CostCumputeReportOptionUI.class);
    private CompanyOrgUnitInfo mainBizorg = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.mainBizorg = (CompanyOrgUnitInfo)this.getUIContext().get("COMPANY_ID");
        this.prmtCompany.setValue((Object)this.mainBizorg);
        SpinnerNumberModel model = new SpinnerNumberModel(1, 1, 100, 1);
        this.spCount.setModel((SpinnerModel)model);
        this.ckRemain.setSelected(true);
        this.btnOK.setEnabled(true);
        this.btnCancel.setEnabled(true);
        try {
            this.loadAccountPeriod(this.mainBizorg);
            this.ckRemain.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeevent) {
                    CostCumputeReportOptionUI.this.spCount.setEnabled(CostCumputeReportOptionUI.this.ckRemain.isSelected());
                }
            });
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void loadAccountPeriod(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        ICalRptUtilFacade iCalRptUtil;
        Object[] reslut;
        if (companyInfo != null) {
            PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            if (periodInfo == null) {
                this.prmtCompany.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTSTART);
            }
            if (curPeriodInfo == null) {
                this.prmtCompany.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTCURRENT);
            }
        }
        if ((reslut = (iCalRptUtil = CalRptUtilFacadeFactory.getRemoteInstance()).fetchInitFilterData(companyInfo.getId().toString())) != null) {
            CalculateUtil.AccountPeriodInfo actPeriodInfo = (CalculateUtil.AccountPeriodInfo)reslut[1];
            CalculateUtil.appliesPeriodControl(this.spYearFrom, this.spYearTo, this.spPeriodFrom, this.spPeriodTo, actPeriodInfo, true, true);
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        int periodNumFrom = (Integer)this.spYearFrom.getValue() * 100 + (Integer)this.spPeriodFrom.getValue();
        int periodNumTo = (Integer)this.spYearTo.getValue() * 100 + (Integer)this.spPeriodTo.getValue();
        String companyId = this.mainBizorg.getId().toString();
        boolean isRemain = this.ckRemain.isSelected();
        int remainCount = (Integer)this.spCount.getValue();
        params.put("periodNumFrom", periodNumFrom);
        params.put("periodNumTo", periodNumTo);
        params.put("companyId", companyId);
        params.put("isRemain", isRemain);
        params.put("remainCount", remainCount);
        CostComputeReportPriceSourceFactory.getRemoteInstance().deleteComputeReport(params);
        MsgBox.showInfo((String)CalculateClientUtil.getCalResource("deleteSucess"));
        this.destroyWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }
}

