/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.CalRptUtilFacadeFactory;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.ICalRptUtilFacade;
import com.kingdee.eas.scm.cal.VoucheredEnum;
import com.kingdee.eas.scm.cal.client.AbstractCostDiffDetailReportConditionUI;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;

public class CostDiffDetailReportConditionUI
extends AbstractCostDiffDetailReportConditionUI {
    private static final long serialVersionUID = -404204787323719146L;
    private static final String resClassName = "com.kingdee.eas.scm.cal.CalCommonResource";
    private CompanyOrgUnitInfo curCompany = null;
    private boolean isSetCustomCondition = false;
    private F7ContextManager f7Manger = new F7ContextManager((Component)((Object)this), OrgType.Company, 1);

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.ckBxMShortName.isSelected()) {
            this.txtMShortNameFrom.setEnabled(true);
            this.txtMShortNameTo.setEnabled(true);
        } else {
            this.txtMShortNameFrom.setEnabled(false);
            this.txtMShortNameTo.setEnabled(false);
        }
        this.bizMaterialID.setCommitParser(null);
        this.bizMaterialIDTo.setCommitParser(null);
        this.f7Manger.registerBizMaterialF7(this.bizMaterialID, null, null, null, true);
        this.f7Manger.registerBizMaterialF7(this.bizMaterialIDTo, null, null, null, false);
        CalculateClientUtil.addListenerForMultiF7(this.bizMaterialID, this.bizMaterialIDTo);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.bizMaterialID, this.bizMaterialIDTo});
        this.setTransactionF7Filter();
        if (this.bizOrgUnit.getData() != null) {
            this.bizMaterialID.setEnabled(true);
            this.bizMaterialIDTo.setEnabled(true);
        }
        this.bizWarehouseFrom.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQueryForCal");
        this.bizWarehouseTo.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQueryForCal");
        this.bizWarehouseFrom.setEnabledMultiSelection(true);
        CalculateClientUtil.addListenerForMultiF7(this.bizWarehouseFrom, this.bizWarehouseTo);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            SCMClientUtils.setMainBizOrgCompF7forSealUp((KDBizPromptBox)this.bizOrgUnit, (OrgType)this.getMainBizOrgType(), (String)this.getViewPermission());
            this.loadCalculateTypeEnum((JComboBox)this.cmbCalType);
            this.loadStatusEnum((JComboBox)this.cmbStatus);
            this.cmbStatus.setSelectedIndex(2);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void bizOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        if (!this.isSetCustomCondition) {
            this.curCompany = (CompanyOrgUnitInfo)this.bizOrgUnit.getData();
            this.bizMaterialID.setMainBizOrgs(this.getMainBizOrgs(), OrgType.Company);
            this.bizMaterialIDTo.setMainBizOrgs(this.getMainBizOrgs(), OrgType.Company);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("fiinfo.accountType", (Object)2));
            view.setFilter(filter);
            this.bizMaterialID.setEntityViewInfo(view);
            this.bizMaterialIDTo.setEntityViewInfo(view);
            if (this.bizOrgUnit.getData() != null) {
                this.loadAccountPeriod((CompanyOrgUnitInfo)this.bizOrgUnit.getData());
            }
            this.curCompany = (CompanyOrgUnitInfo)this.bizOrgUnit.getData();
            if (this.curCompany != null) {
                this.bizMaterialID.setEnabled(true);
                this.bizMaterialIDTo.setEnabled(true);
                this.f7Manger.changeF7Context(this.curCompany.getId().toString());
            } else {
                this.bizMaterialID.setEnabled(false);
                this.bizMaterialIDTo.setEnabled(false);
            }
            this.bizWarehouseFrom.setValue(null);
            this.bizWarehouseTo.setValue(null);
        }
        CalculateClientUtil.setWareHouseEntity(this.bizOrgUnit, null, this.bizWarehouseFrom, true);
        CalculateClientUtil.setWareHouseEntity(this.bizOrgUnit, null, this.bizWarehouseTo, true);
    }

    private void setWareHouseEntity(Object[] obj, CompanyOrgUnitInfo companyOrg) {
        Object storageUnit = null;
        EntityViewInfo entiryView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        try {
            if (obj != null && obj.length > 0) {
                HashSet<String> oriSet = new HashSet<String>();
                int size = obj.length;
                for (int j = 0; j < size; ++j) {
                    StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)obj[j];
                    oriSet.add(storageOrgUnitInfo.getId().toString());
                }
                entiryView = InvClientUtils.getWarehouseFilter(oriSet, (int)1);
            } else {
                OrgUnitCollection orgCol = InvClientUtils.getStorageUnitInfo((CompanyOrgUnitInfo)companyOrg);
                if (orgCol != null) {
                    HashSet<String> oriSet = new HashSet<String>();
                    int size = orgCol.size();
                    for (int j = 0; j < size; ++j) {
                        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)orgCol.get(j);
                        oriSet.add(storageOrgUnitInfo.getId().toString());
                    }
                    entiryView = InvClientUtils.getWarehouseFilter(oriSet, (int)1);
                } else {
                    filterInfo.getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)"****"));
                    entiryView.setFilter(filterInfo);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.bizWarehouseFrom.setEntityViewInfo(entiryView);
        this.bizWarehouseTo.setEntityViewInfo(entiryView);
    }

    @Override
    protected void cmbStatus_itemStateChanged(ItemEvent e) throws Exception {
        super.cmbStatus_itemStateChanged(e);
    }

    public void onInit(RptParams arg0) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        para.setObject("company", this.bizOrgUnit.getValue());
        para.setObject("materialFrom", this.bizMaterialID.getValue());
        para.setObject("materialTo", this.bizMaterialIDTo.getValue());
        para.setObject("calType", this.cmbCalType.getSelectedItem());
        para.setObject("status", this.cmbStatus.getSelectedItem());
        para.setInt("accPeriodYearFrom", this.spAccPeriodYear.getIntegerVlaue().intValue());
        para.setInt("accPeriodMonthFrom", this.spAccPeriodMonth.getIntegerVlaue().intValue());
        para.setInt("accPeriodYearTo", this.spAccPeriodYearTo.getIntegerVlaue().intValue());
        para.setInt("accPeriodMonthTo", this.spAccPeriodMonthTo.getIntegerVlaue().intValue());
        para.setInt("MaxCount", Integer.parseInt(this.cmbMaxCount.getSelectedItem().toString()));
        para.setObject("warehouseFrom", this.bizWarehouseFrom.getValue());
        para.setObject("warehouseTo", this.bizWarehouseTo.getValue());
        para.setObject("voucher", this.cmbVoucher.getSelectedItem());
        para.setBoolean("ckShowNoCalculate", this.ckShowNoCalculate.isSelected());
        para.setBoolean("noSelectNoneInOut", this.noSelectNoneInOut.isSelected());
        para.setBoolean("noSelectStorageMoveBill", this.noSelectStorageMoveBill.isSelected());
        para.setBoolean("noSelectWarehouseMoveBill", this.noSelectWarehouseMoveBill.isSelected());
        para.setBoolean("ckBxMShortName", this.ckBxMShortName.isSelected());
        String txtMShortNameFrom = this.txtMShortNameFrom.getText().trim().replaceAll("'", "''");
        para.setString("txtMShortNameFrom", txtMShortNameFrom);
        String txtMShortNameTo = this.txtMShortNameTo.getText().trim().replaceAll("'", "''");
        para.setString("txtMShortNameTo", txtMShortNameTo);
        para.setObject("bizType", this.prmtBizType.getValue());
        para.setObject("transactionType", this.prmtTransaction.getValue());
        return para;
    }

    public void setCustomCondition(RptParams params) {
        this.isSetCustomCondition = true;
        this.bizOrgUnit.setValue(params.getObject("company"));
        this.bizMaterialID.setValue(params.getObject("materialFrom"));
        this.bizMaterialIDTo.setValue(params.getObject("materialTo"));
        this.cmbCalType.setSelectedItem(params.getObject("calType"));
        this.cmbStatus.setSelectedItem(params.getObject("status"));
        this.spAccPeriodYear.setValue((Object)new Integer(params.getInt("accPeriodYearFrom")));
        this.spAccPeriodMonth.setValue((Object)new Integer(params.getInt("accPeriodMonthFrom")));
        this.spAccPeriodYearTo.setValue((Object)new Integer(params.getInt("accPeriodYearTo")));
        this.spAccPeriodMonthTo.setValue((Object)new Integer(params.getInt("accPeriodMonthTo")));
        this.cmbMaxCount.setSelectedItem((Object)params.getObject("MaxCount").toString());
        this.bizWarehouseFrom.setValue(params.getObject("warehouseFrom"));
        this.bizWarehouseTo.setValue(params.getObject("warehouseTo"));
        this.cmbVoucher.setSelectedItem(params.getObject("voucher"));
        this.ckShowNoCalculate.setSelected(params.getBoolean("ckShowNoCalculate"));
        this.noSelectNoneInOut.setSelected(params.getBoolean("noSelectNoneInOut"));
        this.noSelectStorageMoveBill.setSelected(params.getBoolean("noSelectStorageMoveBill"));
        this.noSelectWarehouseMoveBill.setSelected(params.getBoolean("noSelectWarehouseMoveBill"));
        if (params.getObject("ckBxMShortName") != null) {
            this.ckBxMShortName.setSelected(params.getBoolean("ckBxMShortName"));
        }
        if (this.ckBxMShortName.isSelected()) {
            if (params.getString("txtMShortNameFrom").trim().length() > 0) {
                String txtMShortNameFrom = params.getString("txtMShortNameFrom").trim().replaceAll("''", "'");
                this.txtMShortNameFrom.setText(txtMShortNameFrom);
            }
            if (params.getString("txtMShortNameTo").trim().length() > 0) {
                String txtMShortNameTo = params.getString("txtMShortNameTo").trim().replaceAll("''", "'");
                this.txtMShortNameTo.setText(txtMShortNameTo);
            }
        }
        this.prmtBizType.setValue(params.getObject("bizType"));
        this.prmtTransaction.setValue(params.getObject("transactionType"));
        this.isSetCustomCondition = false;
    }

    private void loadAccountPeriod(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        ICalRptUtilFacade iCalRptUtil;
        Object[] reslut;
        if (companyInfo != null) {
            PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            if (periodInfo == null) {
                this.bizOrgUnit.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTSTART);
            }
            if (curPeriodInfo == null) {
                this.bizOrgUnit.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTCURRENT);
            }
        }
        if ((reslut = (iCalRptUtil = CalRptUtilFacadeFactory.getRemoteInstance()).fetchInitFilterData(companyInfo.getId().toString())) != null) {
            CalculateUtil.AccountPeriodInfo actPeriodInfo = (CalculateUtil.AccountPeriodInfo)reslut[1];
            CalculateUtil.appliesPeriodControl(this.spAccPeriodYear, this.spAccPeriodYearTo, this.spAccPeriodMonth, this.spAccPeriodMonthTo, actPeriodInfo, true, false);
        }
    }

    private void loadCalculateTypeEnum(JComboBox cb) {
        DefaultComboBoxModel<CalculateTypeEnum> model = new DefaultComboBoxModel<CalculateTypeEnum>();
        Iterator i = CalculateTypeEnum.iterator();
        while (i.hasNext()) {
            CalculateTypeEnum e = (CalculateTypeEnum)i.next();
            model.addElement(e);
        }
        cb.setModel(model);
    }

    private void loadStatusEnum(JComboBox cb) {
        DefaultComboBoxModel<BillBaseStatusEnum> model = new DefaultComboBoxModel<BillBaseStatusEnum>();
        model.addElement(BillBaseStatusEnum.NULL);
        model.addElement(BillBaseStatusEnum.SUBMITED);
        model.addElement(BillBaseStatusEnum.AUDITED);
        cb.setModel(model);
    }

    public boolean verify() {
        int periodTo;
        int yearTo;
        int periodfrom;
        if (this.bizOrgUnit.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"COMPANY_NOTNULL"));
            return false;
        }
        int yearFrom = this.spAccPeriodYear.getIntegerVlaue();
        if (100 * yearFrom + (periodfrom = this.spAccPeriodMonth.getIntegerVlaue().intValue()) > 100 * (yearTo = this.spAccPeriodYearTo.getIntegerVlaue().intValue()) + (periodTo = this.spAccPeriodMonthTo.getIntegerVlaue().intValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"PERIOD_BEGIN_NOTBIG_END"));
            return false;
        }
        return true;
    }

    public void clear() {
        super.clear();
        this.bizOrgUnit.setValue(null);
        this.spAccPeriodYear.setValue((Object)new Integer(0));
        this.spAccPeriodMonth.setValue((Object)new Integer(0));
        this.spAccPeriodYearTo.setValue((Object)new Integer(0));
        this.spAccPeriodMonthTo.setValue((Object)new Integer(0));
        this.bizMaterialID.setValue(null);
        this.bizMaterialIDTo.setValue(null);
        this.cmbMaxCount.setSelectedIndex(0);
        this.bizWarehouseFrom.setValue(null);
        this.bizWarehouseTo.setValue(null);
        this.cmbCalType.setSelectedItem((Object)CalculateTypeEnum.NULL);
        this.cmbVoucher.setSelectedItem((Object)VoucheredEnum.Null);
        this.cmbStatus.setSelectedItem((Object)BillBaseStatusEnum.AUDITED);
        this.ckShowNoCalculate.setSelected(false);
        this.noSelectNoneInOut.setSelected(false);
        this.noSelectStorageMoveBill.setSelected(false);
        this.noSelectWarehouseMoveBill.setSelected(false);
        this.ckBxMShortName.setSelected(false);
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
        this.prmtBizType.setValue(null);
        this.prmtTransaction.setValue(null);
        try {
            this.curCompany = (CompanyOrgUnitInfo)this.getDefaultMainBizOrg();
            if (this.curCompany != null && this.curCompany.isIsBizUnit()) {
                this.bizOrgUnit.setValue((Object)this.curCompany);
            } else {
                this.bizOrgUnit.setValue(null);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        CompanyOrgUnitInfo currentMainOrg = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        try {
            if (currentMainOrg.isIsBizUnit() && SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)this.getMainBizOrgType(), (IObjectPK)new ObjectStringPK(currentMainOrg.getId().toString()), (String)this.getViewPermission())) {
                return currentMainOrg;
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return null;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.bizOrgUnit;
    }

    protected String getViewPermission() {
        return "costdiffdetailreport_view";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    protected void ckBxMShortName_stateChanged(ChangeEvent e) throws Exception {
        if (this.ckBxMShortName.isSelected()) {
            this.txtMShortNameFrom.setEnabled(true);
            this.txtMShortNameTo.setEnabled(true);
        } else {
            this.txtMShortNameFrom.setEnabled(false);
            this.txtMShortNameTo.setEnabled(false);
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
        }
    }

    private void addF7SelectorListener(KDBizPromptBox[] f7s) {
        for (int i = 0; i < f7s.length; ++i) {
            f7s[i].addSelectorListener(new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    if (CostDiffDetailReportConditionUI.this.getMainBizOrgF7() != null) {
                        return;
                    }
                    Object value = CostDiffDetailReportConditionUI.this.getMainBizOrgF7().getValue();
                    if (value == null || value instanceof Object[] && ((Object[])value).length == 0 || value instanceof Object[] && ((Object[])value)[0] == null) {
                        MsgBox.showInfo((String)SCMGroupClientUtils.getMainOrgNullMsg((OrgType)OrgType.Company));
                        CostDiffDetailReportConditionUI.this.getMainBizOrgF7().requestFocus();
                        SysUtil.abort();
                    }
                }
            });
        }
    }

    protected void setNeedMainOrgF7s(KDBizPromptBox[] f7s) {
        this.addF7SelectorListener(f7s);
        this.f7Manger.setPrmtNeedOrgF7s(f7s);
    }

    private void setTransactionF7Filter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.NOTEQUALS));
        view.setFilter(filter);
        this.prmtTransaction.setEntityViewInfo(view);
    }
}

