/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.report.client.BizPromptFilterElement;
import com.kingdee.eas.base.report.client.SpinnerFilterElement;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalRptUtilFacadeFactory;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CostDiffGatherGistEnum;
import com.kingdee.eas.scm.cal.ICalRptUtilFacade;
import com.kingdee.eas.scm.cal.VoucheredEnum;
import com.kingdee.eas.scm.cal.client.AbstractCostDiffGatherReportConditionUI;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.ComboBoxFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiF7FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.sd.sale.report.ISaleGrossProfits;
import com.kingdee.eas.scm.sd.sale.report.SaleGrossProfitsFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class CostDiffGatherReportConditionUI
extends AbstractCostDiffGatherReportConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(CostDiffGatherReportConditionUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.cal.CalCommonResource";
    private static final String objectTypeID = "7ac99937-00fb-1000-e000-0002c0a81345B999CA39";
    private CompanyOrgUnitInfo curCompany = null;
    private boolean isSetCustomCondition = false;
    private F7ContextManager f7Manger = null;
    private int materialGroupMaxLevel = 0;
    private boolean isOnload = false;
    private ItemListener cmbSumTypeListener;

    public CostDiffGatherReportConditionUI() throws Exception {
        this.getGroupMaxLevel();
        this.f7Manger = new F7ContextManager((Component)((Object)this), OrgType.Company, 1);
        this.setFilter();
        this.addListener();
    }

    private void addListener() {
        if (this.cmbSumTypeListener == null) {
            this.cmbSumTypeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        CostDiffGatherReportConditionUI.this.cmbSumTypeListener_itemStateChanged(e);
                    }
                    catch (Exception exc) {
                        CostDiffGatherReportConditionUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.cmbSumType.addItemListener(this.cmbSumTypeListener);
    }

    private void setFilter() throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyOrg = (CompanyOrgUnitInfo)this.getDefaultMainBizOrg();
        this.prmtCompany.setValue((Object)companyOrg);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        BizPromptFilterElement companyFilterElement = new BizPromptFilterElement("company", this.prmtCompany);
        elements.add((FilterElement)companyFilterElement);
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        PeriodInfo currentPeriod = sysctrol.getCacheCurrentPeriod(2, companyOrg.getId().toString());
        SpinnerFilterElement yearFromElement = new SpinnerFilterElement("yearFrom", (Component)this.spAccPeriodYear);
        if (currentPeriod != null) {
            yearFromElement.setDefaultValue((Object)new Integer(currentPeriod.getPeriodYear()));
        }
        elements.add((FilterElement)yearFromElement);
        SpinnerFilterElement yearToElement = new SpinnerFilterElement("yearTo", (Component)this.spAccPeriodYearTo);
        if (currentPeriod != null) {
            yearToElement.setDefaultValue((Object)new Integer(currentPeriod.getPeriodYear()));
        }
        elements.add((FilterElement)yearToElement);
        SpinnerFilterElement periodFromElement = new SpinnerFilterElement("periodFrom", (Component)this.spAccPeriodMonth);
        if (currentPeriod != null) {
            periodFromElement.setDefaultValue((Object)new Integer(currentPeriod.getPeriodNumber()));
        }
        elements.add((FilterElement)periodFromElement);
        SpinnerFilterElement periodTo = new SpinnerFilterElement("periodTo", (Component)this.spAccPeriodMonthTo);
        if (currentPeriod != null) {
            periodTo.setDefaultValue((Object)new Integer(currentPeriod.getPeriodNumber()));
        }
        elements.add((FilterElement)periodTo);
        MultiF7FilterElement materialFromElement = new MultiF7FilterElement("materialFrom", this.prmtMaterialFrom, Boolean.valueOf(false));
        elements.add((FilterElement)materialFromElement);
        SingleFilterElement materialToElement = new SingleFilterElement("materialTo", (Component)this.prmtMaterialTo);
        elements.add((FilterElement)materialToElement);
        elements.add((FilterElement)new SingleFilterElement("txtMShortNameFrom", (Component)this.txtMShortNameFrom));
        elements.add((FilterElement)new SingleFilterElement("txtMShortNameTo", (Component)this.txtMShortNameTo));
        elements.add((FilterElement)new BizPromptFilterElement("warehouse", this.bizWarehouse));
        elements.add((FilterElement)new BizPromptFilterElement("KAClass", this.prmtKAClass));
        elements.add((FilterElement)new ComboBoxFilterElement("sumType", (Component)this.cmbSumType));
        elements.add((FilterElement)new SpinnerFilterElement("materialGroupLevel", (Component)this.kdsMaterialGroupLevel));
        SpinnerModel sm = this.kdsMaterialGroupLevel.getModel();
        SpinnerNumberModel nm = (SpinnerNumberModel)sm;
        nm.setMaximum(new Integer(0));
        nm.setMinimum(new Integer(1));
        nm.setValue(new Integer(1));
        this.kDLabelContainer16.setVisible(false);
        ComboBoxFilterElement voucherFilterElement = new ComboBoxFilterElement("voucher", (Component)this.cmbVoucher);
        voucherFilterElement.setDefaultValue((Object)VoucheredEnum.Null);
        elements.add((FilterElement)voucherFilterElement);
        this.loadStatusEnum((JComboBox)this.cmbStatus);
        elements.add((FilterElement)new ComboBoxFilterElement("cmbStatus", (Component)this.cmbStatus));
        elements.add((FilterElement)new SingleFilterElement("onlyViewSumRow", (Component)this.chkOnlyViewSumRow));
        elements.add((FilterElement)new SingleFilterElement("ckShowNoCalculate", (Component)this.ckShowNoCalculate));
        elements.add((FilterElement)new SingleFilterElement("noInOrOutNoShow", (Component)this.ChkIsShowNoInOrOutData));
        elements.add((FilterElement)new SingleFilterElement("ckBxMShortName", (Component)this.ckBxMShortName));
        elements.add((FilterElement)new SingleFilterElement("noSelectStorageMoveBill", (Component)this.noSelectStorageMoveBill));
        elements.add((FilterElement)new SingleFilterElement("noSelectWarehouseMoveBill", (Component)this.noSelectWarehouseMoveBill));
        elements.add((FilterElement)new SingleFilterElement("ckDiffRate", (Component)this.ckDiffRate));
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)companyFilterElement, "companyOrgUnit.id");
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.isOnload = true;
        this.txtMShortNameFrom.setText("");
        this.txtMShortNameFrom.setEditable(false);
        this.txtMShortNameTo.setText("");
        this.txtMShortNameTo.setEditable(false);
        this.setPrmtMateialFormatAndRegister();
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtMaterialFrom, this.prmtMaterialTo});
        this.bizWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQueryForCal");
        CalculateClientUtil.setWareHouseEntity(this.prmtCompany, null, this.bizWarehouse, true);
    }

    private void setPrmtMateialFormatAndRegister() {
        this.prmtMaterialFrom.setCommitParser(null);
        this.prmtMaterialFrom.setEditFormat("$number$");
        this.prmtMaterialFrom.setDisplayFormat("$number$");
        this.prmtMaterialFrom.setCommitFormat("$number$;$name$;$model$;$helpCode$");
        this.prmtMaterialTo.setCommitParser(null);
        this.prmtMaterialTo.setEditFormat("$number$");
        this.prmtMaterialTo.setDisplayFormat("$number$");
        this.prmtMaterialTo.setCommitFormat("$number$;$name$;$model$;$helpCode$");
        this.f7Manger.registerBizMaterialF7(this.prmtMaterialFrom, null, null, null, true);
        this.f7Manger.registerBizMaterialF7(this.prmtMaterialTo, null, null, null, false);
        CalculateClientUtil.addListenerForMultiF7(this.prmtMaterialFrom, this.prmtMaterialTo);
    }

    protected void cmbSumTypeListener_itemStateChanged(ItemEvent e) throws Exception {
        Object selectedItem = this.cmbSumType.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        CostDiffGatherGistEnum sumType = (CostDiffGatherGistEnum)((Object)selectedItem);
        if (sumType.equals((Object)CostDiffGatherGistEnum.MATERIALTYPE)) {
            this.kDLabelContainer16.setVisible(true);
        } else {
            this.kDLabelContainer16.setVisible(false);
        }
    }

    @Override
    protected void bizOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        if (this.isSetCustomCondition || !this.isOnload) {
            return;
        }
        this.prmtMaterialFrom.setMainBizOrgs(this.getMainBizOrgs(), OrgType.Company);
        this.prmtMaterialTo.setMainBizOrgs(this.getMainBizOrgs(), OrgType.Company);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fiinfo.accountType", (Object)2));
        view.setFilter(filter);
        this.prmtMaterialFrom.setEntityViewInfo(view);
        this.prmtMaterialTo.setEntityViewInfo(view);
        if (this.prmtCompany.getData() != null) {
            OrgUnitInfo[] orgUnitInfos;
            if (this.prmtCompany.getData() instanceof CompanyOrgUnitInfo) {
                this.curCompany = (CompanyOrgUnitInfo)this.prmtCompany.getData();
            } else if (this.prmtCompany.getData() instanceof OrgUnitInfo) {
                OrgUnitInfo orgUnitInfo = (OrgUnitInfo)this.prmtCompany.getData();
                this.curCompany = (CompanyOrgUnitInfo)CompanyOrgUnitFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId().toString()));
            } else if (this.prmtCompany.getData() instanceof OrgUnitInfo[] && (orgUnitInfos = (OrgUnitInfo[])this.prmtCompany.getData()) != null && orgUnitInfos.length > 0) {
                this.curCompany = (CompanyOrgUnitInfo)CompanyOrgUnitFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(orgUnitInfos[0].getId().toString()));
            }
            this.prmtCompany.setValue((Object)this.curCompany);
            this.loadAccountPeriod(this.curCompany);
            this.f7Manger.changeF7Context(this.curCompany.getId().toString());
        }
        if (this.curCompany != null) {
            PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)this.curCompany);
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)this.curCompany);
            if (periodInfo == null) {
                this.prmtCompany.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTSTART);
            }
            if (curPeriodInfo == null) {
                this.prmtCompany.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTCURRENT);
            }
        }
        if (this.curCompany != null) {
            this.prmtMaterialFrom.setEnabled(true);
            this.prmtMaterialTo.setEnabled(true);
        } else {
            this.prmtMaterialFrom.setEnabled(false);
            this.prmtMaterialTo.setEnabled(false);
        }
        if (this.curCompany != null) {
            this.setKAClassF7(this.curCompany);
        }
        this.bizWarehouse.setValue(null);
        this.bizWarehouse.setValue(null);
        CalculateClientUtil.setWareHouseEntity(this.prmtCompany, null, this.bizWarehouse, true);
    }

    @Override
    protected void ckBxMShortName_stateChanged(ChangeEvent e) throws Exception {
        if (this.ckBxMShortName.isSelected()) {
            this.txtMShortNameFrom.setText("");
            this.txtMShortNameTo.setText("");
            this.txtMShortNameFrom.setEditable(true);
            this.txtMShortNameTo.setEditable(true);
        } else {
            this.txtMShortNameFrom.setText("");
            this.txtMShortNameTo.setText("");
            this.txtMShortNameFrom.setEditable(false);
            this.txtMShortNameTo.setEditable(false);
        }
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.isSetCustomCondition = true;
        super.loadData(entityViewInfo);
        this.isSetCustomCondition = false;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        SCMClientUtils.setMainBizOrgCompF7forSealUp((KDBizPromptBox)this.prmtCompany, (OrgType)this.getMainBizOrgType(), (String)this.getViewPermission());
        this.addKAClassListener();
    }

    public boolean verify() {
        int periodTo;
        int yearTo;
        int periodfrom;
        if (this.prmtCompany.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"COMPANY_NOTNULL"));
            return false;
        }
        int yearFrom = this.spAccPeriodYear.getIntegerVlaue();
        if (100 * yearFrom + (periodfrom = this.spAccPeriodMonth.getIntegerVlaue().intValue()) > 100 * (yearTo = this.spAccPeriodYearTo.getIntegerVlaue().intValue()) + (periodTo = this.spAccPeriodMonthTo.getIntegerVlaue().intValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"PERIOD_BEGIN_NOTBIG_END"));
            return false;
        }
        return true;
    }

    protected void setDefaultValue() {
        CompanyOrgUnitInfo currentMainOrg = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        try {
            if (currentMainOrg.isIsBizUnit() && SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)this.getMainBizOrgType(), (IObjectPK)new ObjectStringPK(currentMainOrg.getId().toString()), (String)this.getViewPermission())) {
                this.prmtCompany.setValue((Object)currentMainOrg);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        this.cmbStatus.setSelectedItem((Object)BillBaseStatusEnum.AUDITED);
        this.cmbSumType.setSelectedItem((Object)CostDiffGatherGistEnum.CALCULATETYPE);
        SpinnerModel sm = this.kdsMaterialGroupLevel.getModel();
        SpinnerNumberModel nm = (SpinnerNumberModel)sm;
        nm.setMaximum(new Integer(this.materialGroupMaxLevel));
        nm.setMinimum(new Integer(1));
        nm.setValue(new Integer(1));
        this.chkOnlyViewSumRow.setSelected(true);
        this.ckShowNoCalculate.setSelected(false);
        this.ChkIsShowNoInOrOutData.setSelected(false);
        this.ckBxMShortName.setSelected(false);
        this.noSelectStorageMoveBill.setSelected(false);
        this.ckDiffRate.setSelected(false);
        this.noSelectWarehouseMoveBill.setSelected(false);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompany;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    private void setKAClassF7(CompanyOrgUnitInfo companyOrg) {
        if (companyOrg != null) {
            String companyID = companyOrg.getId().toString();
            if (companyOrg.getAccountTable() == null) {
                return;
            }
            String accountTableID = companyOrg.getAccountTable().getId().toString();
            this.prmtKAClass.setValue(null);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("objectType.id", (Object)objectTypeID, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("accountTableId.id", (Object)accountTableID, CompareType.EQUALS));
            filterInfo.setMaskString("#0 and #1 and #2");
            viewInfo.setFilter(filterInfo);
            this.prmtKAClass.setEntityViewInfo(viewInfo);
        }
    }

    private void loadStatusEnum(JComboBox cb) {
        DefaultComboBoxModel<BillBaseStatusEnum> model = new DefaultComboBoxModel<BillBaseStatusEnum>();
        model.addElement(BillBaseStatusEnum.NULL);
        model.addElement(BillBaseStatusEnum.SUBMITED);
        model.addElement(BillBaseStatusEnum.AUDITED);
        cb.setModel(model);
    }

    protected void addKAClassListener() {
        this.prmtKAClass.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (CostDiffGatherReportConditionUI.this.prmtCompany.getValue() == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)CostDiffGatherReportConditionUI.resClassName, (String)"COMPANY_NOTNULL"));
                    SysUtil.abort();
                }
            }
        });
    }

    private void loadAccountPeriod(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        ICalRptUtilFacade iCalRptUtil;
        Object[] reslut;
        if (companyInfo != null) {
            PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            if (periodInfo == null) {
                this.cmbStatus.setSelectedItem((Object)BillBaseStatusEnum.AUDITED);
                this.cmbSumType.setSelectedItem((Object)CostDiffGatherGistEnum.CALCULATETYPE);
                this.prmtCompany.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTSTART);
            }
            if (curPeriodInfo == null) {
                this.prmtCompany.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTCURRENT);
            }
        }
        if ((reslut = (iCalRptUtil = CalRptUtilFacadeFactory.getRemoteInstance()).fetchInitFilterData(companyInfo.getId().toString())) != null) {
            CalculateUtil.AccountPeriodInfo actPeriodInfo = (CalculateUtil.AccountPeriodInfo)reslut[1];
            CalculateUtil.appliesPeriodControl(this.spAccPeriodYear, this.spAccPeriodYearTo, this.spAccPeriodMonth, this.spAccPeriodMonthTo, actPeriodInfo, true, false);
        }
    }

    private void getGroupMaxLevel() {
        try {
            ISaleGrossProfits reportFacade = SaleGrossProfitsFactory.getRemoteInstance();
            int[] levels = reportFacade.getMaxLevels();
            this.materialGroupMaxLevel = levels[1];
        }
        catch (Exception exp) {
            this.handUIException(exp);
        }
    }

    protected String getViewPermission() {
        return "costdiffgatherreport_view";
    }
}

