/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.client.StockDeailReportDataProvider;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class EvaluateDetailReportDataProvider
extends DefaultNoteDataProvider {
    private Logger logger = Logger.getLogger(StockDeailReportDataProvider.class);
    private HashMap hm = new HashMap();
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private DynamicRowSet drs = this.buildDynamicRowSet();

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        if (dataSource.getAssociateParameter() == null && this.get(dataSource.getId()) == null) {
            DynamicRowSet rowSet = this.drs;
            rowSet.beforeFirst();
            return rowSet;
        }
        return super.getData(dataSource);
    }

    private DynamicRowSet buildDynamicRowSet() {
        DynamicRowSet drs = null;
        try {
            drs = new DynamicRowSet(26);
            drs.setColInfo(1, "company", "company", 12, null);
            drs.setColInfo(2, "accountPeriod", "accountPeriod", 12, null);
            drs.setColInfo(3, "materielNumber", "materielNumber", 12, null);
            drs.setColInfo(4, "materielName", "materielName", 12, null);
            drs.setColInfo(5, "model", "model", 12, null);
            drs.setColInfo(6, "baseUnit", "baseUnit", 12, null);
            drs.setColInfo(7, "year", "year", 12, null);
            drs.setColInfo(8, "period", "period", 12, null);
            drs.setColInfo(9, "storageOrgUnit", "storageOrgUnit", 12, null);
            drs.setColInfo(10, "warehouse", "warehouse", 12, null);
            drs.setColInfo(11, "voucherNumber", "voucherNumber", 12, null);
            drs.setColInfo(12, "bizDate", "bizDate", 12, null);
            drs.setColInfo(13, "billNumber", "billNumber", 12, null);
            drs.setColInfo(14, "supplier", "supplier", 12, null);
            drs.setColInfo(15, "transactionType", "transactionType", 12, null);
            drs.setColInfo(16, "KAClass", "KAClass", 12, null);
            drs.setColInfo(17, "assistantAttr", "assistantAttr", 12, null);
            drs.setColInfo(18, "inQty", "inQty", 12, null);
            drs.setColInfo(19, "inUnitPrice", "inUnitPrice", 12, null);
            drs.setColInfo(20, "inAmount", "inAmount", 12, null);
            drs.setColInfo(21, "outQty", "outQty", 12, null);
            drs.setColInfo(22, "outUnitPrice", "outUnitPrice", 12, null);
            drs.setColInfo(23, "outAmount", "outAmount", 12, null);
            drs.setColInfo(24, "remainQty", "remainQty", 12, null);
            drs.setColInfo(25, "remainUnitPrice", "remainUnitPrice", 12, null);
            drs.setColInfo(26, "remainAmount", "remainAmount", 12, null);
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e1);
        }
        return drs;
    }

    public DynamicRowSet insertDataToDynamicRowSet(RptParams params, RptRowSet currentRowSet) {
        try {
            if (params.getObject("company") == null || params.getString("CurrentMaterialID") == null) {
                return this.drs;
            }
            String PeriodFrom = String.valueOf(params.getInt("accPeriodYearFrom")) + "." + String.valueOf(params.getInt("accPeriodMonthFrom"));
            String PeriodTo = String.valueOf(params.getInt("accPeriodYearTo")) + "." + String.valueOf(params.getInt("accPeriodMonthTo"));
            MaterialInfo aMaterialInfo = null;
            MeasureUnitInfo aMeasureUnitInfo = null;
            try {
                aMaterialInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(params.getString("CurrentMaterialID")), SCMSelectorFactory.getMaterialInfoSelector());
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("number"));
                String unitID = aMaterialInfo.getBaseUnit().getId().toString();
                aMeasureUnitInfo = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(unitID));
            }
            catch (EASBizException e) {
                this.logger.error((Object)e);
            }
            catch (BOSException e) {
                this.logger.error((Object)e);
            }
            currentRowSet.reset();
            while (currentRowSet.next()) {
                this.drs.moveToInsertRow();
                this.drs.updateString("company", ((CompanyOrgUnitInfo)params.getObject("company")).getName());
                this.drs.updateString("accountPeriod", PeriodFrom + " - " + PeriodTo);
                this.drs.updateString("materielNumber", aMaterialInfo.getNumber());
                this.drs.updateString("materielName", aMaterialInfo.getName());
                this.drs.updateString("model", aMaterialInfo.getModel());
                this.drs.updateString("baseUnit", aMeasureUnitInfo.getName());
                this.drs.updateString("year", String.valueOf(currentRowSet.getInt("FYear")));
                if (currentRowSet.getBigDecimal("FPeriod") != null) {
                    this.drs.updateString("period", String.valueOf(currentRowSet.getInt("FPeriod")));
                } else {
                    this.drs.updateString("period", "");
                }
                this.drs.updateString("storageOrgUnit", currentRowSet.getString("FStorageOrgUnit"));
                this.drs.updateString("warehouse", currentRowSet.getString("FWarehouse"));
                this.drs.updateString("voucherNumber", currentRowSet.getString("FVoucherNumber"));
                if (currentRowSet.getObject("FBizDate") != null) {
                    this.drs.updateString("bizDate", currentRowSet.getObject("FBizDate").toString().substring(0, 10));
                } else {
                    this.drs.updateString("bizDate", "");
                }
                this.drs.updateString("billNumber", currentRowSet.getString("FBillNumber"));
                this.drs.updateString("supplier", currentRowSet.getString("FSupplier"));
                this.drs.updateString("transactionType", currentRowSet.getString("FTransactionType_l2"));
                this.drs.updateString("KAClass", currentRowSet.getString("FKAClass"));
                this.drs.updateString("assistantAttr", currentRowSet.getString("FAssistantAttr_l2"));
                this.drs.updateBigDecimal("inQty", currentRowSet.getBigDecimal("FInQty").setScale(2, 4));
                if (currentRowSet.getBigDecimal("FInUnitPrice") != null) {
                    this.drs.updateBigDecimal("inUnitPrice", currentRowSet.getBigDecimal("FInUnitPrice").setScale(2, 4));
                } else {
                    this.drs.updateBigDecimal("inUnitPrice", ZERO.setScale(2, 4));
                }
                this.drs.updateBigDecimal("inAmount", currentRowSet.getBigDecimal("FInAmount").setScale(4, 4));
                this.drs.updateBigDecimal("outQty", currentRowSet.getBigDecimal("FOutQty").setScale(2, 4));
                if (currentRowSet.getBigDecimal("FOutUnitPrice") != null) {
                    this.drs.updateBigDecimal("outUnitPrice", currentRowSet.getBigDecimal("FOutUnitPrice").setScale(2, 4));
                } else {
                    this.drs.updateBigDecimal("outUnitPrice", ZERO.setScale(2, 4));
                }
                this.drs.updateBigDecimal("outAmount", currentRowSet.getBigDecimal("FOutAmount").setScale(4, 4));
                this.drs.updateBigDecimal("remainQty", currentRowSet.getBigDecimal("FRemainQty").setScale(2, 4));
                if (currentRowSet.getBigDecimal("FRemainUnitPrice") != null) {
                    this.drs.updateBigDecimal("remainUnitPrice", currentRowSet.getBigDecimal("FRemainUnitPrice").setScale(2, 4));
                } else {
                    this.drs.updateBigDecimal("remainUnitPrice", ZERO.setScale(2, 4));
                }
                this.drs.updateBigDecimal("remainAmount", currentRowSet.getBigDecimal("FRemainAmount").setScale(4, 4));
                this.drs.insertRow();
            }
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e1);
        }
        return this.drs;
    }

    public Object get(String id) {
        return this.hm.get(id);
    }
}

