/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.MainDataParser;
import com.kingdee.eas.basedata.master.cssp.client.F7SupplierTreeDetailListUI;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.CalRptUtilFacadeFactory;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.ICalRptUtilFacade;
import com.kingdee.eas.scm.cal.SumTypeEnum;
import com.kingdee.eas.scm.cal.SumTypeExEnum;
import com.kingdee.eas.scm.cal.VoucheredEnum;
import com.kingdee.eas.scm.cal.client.AbstractEvaluateGatherReportConditionUI;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class EvaluateGatherReportConditionUI
extends AbstractEvaluateGatherReportConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(EvaluateGatherReportConditionUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.cal.CalCommonResource";
    private F7ContextManager f7Manger = new F7ContextManager((Component)((Object)this), OrgType.Company, 1);
    private boolean isSetCustomCondition = false;
    private CompanyOrgUnitInfo curCompany = null;
    private CtrlUnitInfo curCtrlUnitInfo;
    private CtrlUnitInfo Storage = null;
    private String oldStorageSting = "";
    public static final int WHFILTER_ISSTARTED = 1;
    public static final int WHFILTER_NOSTARTED = 0;
    public static final int WHFILTER_ALL = -1;
    public static final String CTX_CU = "cu";
    private ItemListener cmbSumTypeListener;

    public EvaluateGatherReportConditionUI() throws Exception {
        if (this.cmbSumTypeListener != null) {
            this.cmbSumType.removeItemListener(this.cmbSumTypeListener);
        }
        if (this.cmbSumTypeListener == null) {
            this.cmbSumTypeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        EvaluateGatherReportConditionUI.this.cmbSumTypeListener_itemStateChanged(e);
                    }
                    catch (Exception exc) {
                        EvaluateGatherReportConditionUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.cmbSumType.addItemListener(this.cmbSumTypeListener);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.bizStorageOrgUnit.setEnabledMultiSelection(true);
        this.bizWarehouse.setEnabledMultiSelection(true);
        this.bizMaterialID.setCommitParser(null);
        this.bizMaterialIDTo.setCommitParser(null);
        this.f7Manger.registerBizMaterialF7(this.bizMaterialID, null, null, null, true);
        this.f7Manger.registerBizMaterialF7(this.bizMaterialIDTo, null, null, null, false);
        CalculateClientUtil.addListenerForMultiF7(this.bizMaterialID, this.bizMaterialIDTo);
        this.f7Manger.registerBizSupplierF7(this.bizPromptSupperFrom, null, null, null);
        this.f7Manger.registerBizSupplierF7(this.bizPromptSupperTo, null, null, null);
        this.bizPromptSupperFrom.setEnabledMultiSelection(true);
        ((GeneralKDPromptSelectorAdaptor)this.bizPromptSupperFrom.getSelector()).setIsMultiSelect(true);
        CalculateClientUtil.addListenerForMultiF7(this.bizPromptSupperFrom, this.bizPromptSupperTo);
        EvaluateGatherReportConditionUI.setBizMaterialGroup(this.bizMaterialTypeFrom, null);
        EvaluateGatherReportConditionUI.setBizMaterialGroup(this.bizMaterialTypeTo, null);
        this.bizMaterialTypeFrom.setCommitParser((IParser)new MainDataParser("$number$", this.bizMaterialTypeFrom));
        this.bizMaterialTypeTo.setCommitParser((IParser)new MainDataParser("$number$", this.bizMaterialTypeTo));
        this.bizWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQueryForCal");
        if (this.bizOrgUnit.getData() != null) {
            this.f7Manger.changeF7Context(((CompanyOrgUnitInfo)this.bizOrgUnit.getData()).getId().toString());
        }
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.bizMaterialID, this.bizMaterialIDTo, this.bizStorageOrgUnit, this.bizPromptSupperFrom, this.bizPromptSupperTo});
    }

    protected void setNeedMainOrgF7s(KDBizPromptBox[] f7s) {
        this.addF7SelectorListener(f7s);
        this.f7Manger.setPrmtNeedOrgF7s(f7s);
    }

    private void addF7SelectorListener(KDBizPromptBox[] f7s) {
        for (int i = 0; i < f7s.length; ++i) {
            f7s[i].addSelectorListener(new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    if (EvaluateGatherReportConditionUI.this.getMainBizOrgF7() != null) {
                        return;
                    }
                    Object value = EvaluateGatherReportConditionUI.this.getMainBizOrgF7().getValue();
                    if (value == null || value instanceof Object[] && ((Object[])value).length == 0 || value instanceof Object[] && ((Object[])value)[0] == null) {
                        MsgBox.showInfo((String)SCMGroupClientUtils.getMainOrgNullMsg((OrgType)OrgType.Company));
                        EvaluateGatherReportConditionUI.this.getMainBizOrgF7().requestFocus();
                        SysUtil.abort();
                    }
                }
            });
        }
    }

    protected void cmbSumTypeListener_itemStateChanged(ItemEvent e) throws Exception {
        Object selectedItem = this.cmbSumType.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        String groupstandard = null;
        MaterialGroupStandardInfo mgsInfo = null;
        if (selectedItem instanceof MaterialGroupStandardInfo && (mgsInfo = (MaterialGroupStandardInfo)selectedItem) != null && mgsInfo.getId() != null) {
            groupstandard = mgsInfo.getId().toString();
        }
        EvaluateGatherReportConditionUI.setBizMaterialGroup(this.bizMaterialTypeFrom, groupstandard);
        EvaluateGatherReportConditionUI.setBizMaterialGroup(this.bizMaterialTypeTo, groupstandard);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get(CTX_CU);
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        SCMClientUtils.setMainBizOrgCompF7forSealUp((KDBizPromptBox)this.bizOrgUnit, (OrgType)this.getMainBizOrgType(), (String)this.getViewPermission());
        try {
            this.getDefaultMainBizOrg();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.setBtnEnable();
        try {
            this.loadSumTypeEnum(this.cmbSumType);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        this.loadStatusEnum((JComboBox)this.cmbStatus);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.bizOrgUnit;
    }

    protected String getViewPermission() {
        return "evaluategatherreport_view";
    }

    private void loadSumTypeEnum(KDComboBox cb) throws Exception {
        cb.removeAllItems();
        IMaterialGroupStandard iMaterialGroupStandard = MaterialGroupStandardFactory.getRemoteInstance();
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)this.curCtrlUnitInfo.getId().toString(), (String)this.curCtrlUnitInfo.getLongNumber());
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfoCU);
        MaterialGroupStandardCollection groupStandardColl = iMaterialGroupStandard.getMaterialGroupStandardCollection(viewInfo);
        cb.removeAllItems();
        if (groupStandardColl != null) {
            cb.addItems(groupStandardColl.toArray());
        }
        cb.addItem((Object)SumTypeExEnum.SUPPLIER);
        cb.addItem((Object)SumTypeExEnum.ADMINORGUNIT);
        cb.addItem((Object)SumTypeEnum.CALCULATETYPE);
        cb.addItem((Object)SumTypeEnum.STORAGEORGUNIT);
        cb.addItem((Object)SumTypeEnum.WAREHOUSE);
        int defaultIndex = 0;
        int size = groupStandardColl.size();
        for (int index = 0; index < size; ++index) {
            if (!MaterialGroupStandardTypeEnum.BasicStandard.equals((Object)groupStandardColl.get(index).getStandardType())) continue;
            defaultIndex = index;
            break;
        }
        cb.setSelectedIndex(defaultIndex);
    }

    private void loadStatusEnum(JComboBox cb) {
        DefaultComboBoxModel<BillBaseStatusEnum> model = new DefaultComboBoxModel<BillBaseStatusEnum>();
        model.addElement(BillBaseStatusEnum.NULL);
        model.addElement(BillBaseStatusEnum.SUBMITED);
        model.addElement(BillBaseStatusEnum.AUDITED);
        cb.setModel(model);
    }

    @Override
    protected void bizOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        CompanyOrgUnitInfo companyInfo;
        super.bizOrgUnit_stateChanged(e);
        if (!this.isSetCustomCondition) {
            this.bizMaterialID.setMainBizOrgs(this.getMainBizOrgs(), OrgType.Company);
            this.bizMaterialIDTo.setMainBizOrgs(this.getMainBizOrgs(), OrgType.Company);
            this.bizPromptSupperFrom.setMainBizOrgs(this.getMainBizOrgs(), OrgType.Company);
            this.bizPromptSupperTo.setMainBizOrgs(this.getMainBizOrgs(), OrgType.Company);
            companyInfo = (CompanyOrgUnitInfo)this.bizOrgUnit.getData();
            if (this.bizOrgUnit.getData() != null) {
                this.setF7NullByCompanyChange();
                this.loadAccountPeriod(companyInfo);
            } else if (this.bizOrgUnit.getData() == null) {
                this.bizStorageOrgUnit.setValue(null);
            }
        }
        this.setBtnEnable();
        if (this.bizOrgUnit.getData() != null) {
            companyInfo = (CompanyOrgUnitInfo)this.bizOrgUnit.getData();
            this.getStorageUnitFilter(companyInfo, this.bizStorageOrgUnit);
            this.getSupplierF7(this.bizPromptSupperFrom, companyInfo, (Object)this, true);
            this.getSupplierF7(this.bizPromptSupperTo, companyInfo, (Object)this, false);
            this.f7Manger.changeF7Context(companyInfo.getId().toString());
        }
        CalculateClientUtil.setWareHouseEntity(this.bizOrgUnit, this.bizStorageOrgUnit, this.bizWarehouse, true);
    }

    private void setBtnEnable() {
        this.curCompany = (CompanyOrgUnitInfo)this.bizOrgUnit.getData();
        if (this.curCompany != null) {
            this.bizMaterialID.setEnabled(true);
            this.bizMaterialIDTo.setEnabled(true);
            this.bizStorageOrgUnit.setEnabled(true);
            this.bizWarehouse.setEnabled(true);
            this.bizPromptSupperFrom.setEnabled(true);
            this.bizPromptSupperTo.setEnabled(true);
        } else {
            this.bizMaterialID.setEnabled(false);
            this.bizMaterialIDTo.setEnabled(false);
            this.bizStorageOrgUnit.setEnabled(false);
            this.bizWarehouse.setEnabled(false);
            this.bizPromptSupperFrom.setEnabled(false);
            this.bizPromptSupperTo.setEnabled(false);
        }
    }

    private void loadAccountPeriod(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        ICalRptUtilFacade iCalRptUtil;
        Object[] reslut;
        if (companyInfo != null) {
            PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            if (periodInfo == null) {
                this.bizOrgUnit.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTSTART);
            }
            if (curPeriodInfo == null) {
                this.bizOrgUnit.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTCURRENT);
            }
        }
        if ((reslut = (iCalRptUtil = CalRptUtilFacadeFactory.getRemoteInstance()).fetchInitFilterData(companyInfo.getId().toString())) != null) {
            CalculateUtil.AccountPeriodInfo actPeriodInfo = (CalculateUtil.AccountPeriodInfo)reslut[1];
            CalculateUtil.appliesPeriodControl(this.spAccPeriodYear, this.spAccPeriodYearTo, this.spAccPeriodMonth, this.spAccPeriodMonthTo, actPeriodInfo, true, false);
        }
    }

    @Override
    protected void bizStorageOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        Object[] sous;
        super.bizStorageOrgUnit_stateChanged(e);
        if (!this.oldStorageSting.equals(this.bizStorageOrgUnit.getText())) {
            this.bizWarehouse.setValue(null);
        }
        this.oldStorageSting = this.bizStorageOrgUnit.getText();
        Object sou = this.bizStorageOrgUnit.getData();
        if (sou != null && sou instanceof StorageOrgUnitInfo) {
            this.Storage = ((StorageOrgUnitInfo)sou).getCU();
        } else if (sou != null && sou instanceof Object[] && (sous = (Object[])this.bizStorageOrgUnit.getData()) != null && sous.length > 0) {
            this.Storage = sous[0] instanceof StorageOrgUnitInfo ? ((StorageOrgUnitInfo)sous[0]).getCU() : (sous[0] instanceof FullOrgUnitInfo ? ((FullOrgUnitInfo)sous[0]).getCU() : SysContext.getSysContext().getCurrentCtrlUnit());
        }
        CalculateClientUtil.setWareHouseEntity(this.bizOrgUnit, this.bizStorageOrgUnit, this.bizWarehouse, false);
    }

    public static void setBizMaterialGroup(KDBizPromptBox bizMaterialGroup, String standardId) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        bizMaterialGroup.setDisplayFormat("$number$");
        bizMaterialGroup.setEditFormat("$number$");
        bizMaterialGroup.setCommitFormat("$number$;$helpCode$;$name$;$model$");
        bizMaterialGroup.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialGroupQuery");
        if (standardId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("groupStandard.id", (Object)standardId));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("groupStandard.standardType", (Object)"1"));
        }
        viewInfo.setFilter(filterInfo);
        bizMaterialGroup.setEnabledMultiSelection(false);
        bizMaterialGroup.setEntityViewInfo(viewInfo);
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        para.setObject("company", this.bizOrgUnit.getValue());
        para.setInt("accPeriodYearFrom", this.spAccPeriodYear.getIntegerVlaue().intValue());
        para.setInt("accPeriodMonthFrom", this.spAccPeriodMonth.getIntegerVlaue().intValue());
        para.setInt("accPeriodYearTo", this.spAccPeriodYearTo.getIntegerVlaue().intValue());
        para.setInt("accPeriodMonthTo", this.spAccPeriodMonthTo.getIntegerVlaue().intValue());
        para.setObject("storageOrgUnit", this.bizStorageOrgUnit.getValue());
        para.setObject("warehouse", this.bizWarehouse.getValue());
        para.setObject("supperFrom", this.bizPromptSupperFrom.getValue());
        para.setObject("supperTo", this.bizPromptSupperTo.getValue());
        para.setObject("materialFrom", this.bizMaterialID.getValue());
        para.setObject("materialTo", this.bizMaterialIDTo.getValue());
        para.setObject("voucher", this.cmbVoucher.getSelectedItem());
        para.setObject("status", this.cmbStatus.getSelectedItem());
        para.setObject("sumType", this.cmbSumType.getSelectedItem());
        para.setObject("materialTypeFrom", this.bizMaterialTypeFrom.getValue());
        para.setObject("materialTypeTo", this.bizMaterialTypeTo.getValue());
        para.setBoolean("onlyViewSumRow", this.chkOnlyViewSumRow.isSelected());
        para.setBoolean("filteNoINOut", this.ckNoInOut.isSelected());
        para.setInt("endQtyFilter", this.cbEndQtyFilter.getSelectedIndex());
        return para;
    }

    public void setCustomCondition(RptParams params) {
        this.isSetCustomCondition = true;
        this.bizOrgUnit.setValue(params.getObject("company"));
        this.spAccPeriodYear.setValue((Object)new Integer(params.getInt("accPeriodYearFrom")));
        this.spAccPeriodMonth.setValue((Object)new Integer(params.getInt("accPeriodMonthFrom")));
        this.spAccPeriodYearTo.setValue((Object)new Integer(params.getInt("accPeriodYearTo")));
        this.spAccPeriodMonthTo.setValue((Object)new Integer(params.getInt("accPeriodMonthTo")));
        this.bizStorageOrgUnit.setValue(params.getObject("storageOrgUnit"));
        this.bizWarehouse.setValue(params.getObject("warehouse"));
        this.bizPromptSupperFrom.setValue(params.getObject("supperFrom"));
        this.bizPromptSupperTo.setValue(params.getObject("supperTo"));
        this.bizMaterialID.setValue(params.getObject("materialFrom"));
        this.bizMaterialIDTo.setValue(params.getObject("materialTo"));
        this.cmbVoucher.setSelectedItem(params.getObject("voucher"));
        this.cmbStatus.setSelectedItem(params.getObject("status"));
        this.cmbSumType.setSelectedItem(params.getObject("sumType"));
        this.bizMaterialTypeFrom.setValue(params.getObject("materialTypeFrom"));
        this.bizMaterialTypeTo.setValue(params.getObject("materialTypeTo"));
        this.chkOnlyViewSumRow.setSelected(params.getBoolean("onlyViewSumRow"));
        this.ckNoInOut.setSelected(params.getBoolean("filteNoINOut"));
        this.cbEndQtyFilter.setSelectedIndex(params.getObject("endQtyFilter") == null ? 0 : params.getInt("endQtyFilter"));
        this.isSetCustomCondition = false;
    }

    public boolean verify() {
        int periodTo;
        int yearTo;
        int periodfrom;
        if (this.bizOrgUnit.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"COMPANY_NOTNULL"));
            return false;
        }
        int yearFrom = this.spAccPeriodYear.getIntegerVlaue();
        if (100 * yearFrom + (periodfrom = this.spAccPeriodMonth.getIntegerVlaue().intValue()) > 100 * (yearTo = this.spAccPeriodYearTo.getIntegerVlaue().intValue()) + (periodTo = this.spAccPeriodMonthTo.getIntegerVlaue().intValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"PERIOD_BEGIN_NOTBIG_END"));
            return false;
        }
        return true;
    }

    public void clear() {
        super.clear();
        this.bizOrgUnit.setText(null);
        this.bizStorageOrgUnit.setValue(null);
        this.bizWarehouse.setValue(null);
        this.bizPromptSupperFrom.setValue(null);
        this.bizPromptSupperTo.setValue(null);
        this.bizMaterialID.setValue(null);
        this.bizMaterialIDTo.setValue(null);
        this.cmbVoucher.setSelectedItem((Object)VoucheredEnum.Null);
        this.cmbStatus.setSelectedItem((Object)BillBaseStatusEnum.AUDITED);
        this.bizMaterialTypeFrom.setValue(null);
        this.bizMaterialTypeTo.setValue(null);
        this.chkOnlyViewSumRow.setSelected(false);
        this.ckNoInOut.setSelected(false);
        this.cbEndQtyFilter.setSelectedIndex(0);
        try {
            this.getDefaultMainBizOrg();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void setF7NullByCompanyChange() {
        this.bizStorageOrgUnit.setValue(null);
        this.bizWarehouse.setValue(null);
        this.bizPromptSupperFrom.setValue(null);
        this.bizPromptSupperTo.setValue(null);
        this.bizMaterialID.setValue(null);
        this.bizMaterialIDTo.setValue(null);
    }

    protected final void getDefaultMainBizOrg() throws Exception {
        CompanyOrgUnitInfo currentMainOrg = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        ObjectStringPK userPK = new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        ObjectUuidPK useruuPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        boolean hasPermission = false;
        if (currentMainOrg.isIsBizUnit()) {
            try {
                hasPermission = SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)userPK, (OrgType)this.getMainBizOrgType(), (IObjectPK)new ObjectStringPK(currentMainOrg.getId().toString()), (String)this.getViewPermission());
            }
            catch (Exception e) {
                hasPermission = false;
            }
            if (hasPermission) {
                this.bizOrgUnit.setValue((Object)currentMainOrg);
            } else {
                this.bizOrgUnit.setValue(null);
            }
        } else {
            CompanyOrgUnitInfo seleCompanyOrgUnitInfo = null;
            FullOrgUnitCollection fullOrgUnits = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)useruuPK, (OrgType)OrgType.Company, (String)this.getViewPermission());
            if (fullOrgUnits != null && fullOrgUnits.size() > 0) {
                seleCompanyOrgUnitInfo = this.getDefaultBizUnitOrg(fullOrgUnits);
                if (seleCompanyOrgUnitInfo != null) {
                    this.bizOrgUnit.setValue((Object)seleCompanyOrgUnitInfo);
                } else {
                    this.bizOrgUnit.setValue(null);
                }
            }
        }
    }

    private CompanyOrgUnitInfo getDefaultBizUnitOrg(FullOrgUnitCollection fullOrgUnits) throws Exception {
        if (fullOrgUnits == null) {
            return null;
        }
        CompanyOrgUnitInfo seleCompanyOrgUnitInfo = null;
        if (fullOrgUnits != null && fullOrgUnits.size() > 0) {
            StringBuffer fullOrgID = new StringBuffer();
            for (int i = 0; i < fullOrgUnits.size(); ++i) {
                if (fullOrgUnits.get(i) == null || fullOrgUnits.get(i).getId() == null) continue;
                if (i > 0) {
                    fullOrgID.append(",");
                }
                fullOrgID.append(fullOrgUnits.get(i).getId().toString());
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection siceEtry = viewInfo.getSelector();
            siceEtry.add(new SelectorItemInfo("id"));
            siceEtry.add(new SelectorItemInfo("number"));
            siceEtry.add(new SelectorItemInfo("name"));
            siceEtry.add(new SelectorItemInfo("longNumber"));
            siceEtry.add(new SelectorItemInfo("isCompanyOrgUnit"));
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo itemInfo = new FilterItemInfo("id", (Object)fullOrgID.toString(), CompareType.INCLUDE);
            filterInfo.getFilterItems().add(itemInfo);
            viewInfo.setFilter(filterInfo);
            FullOrgUnitCollection fullOrgUnitCol = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(viewInfo);
            if (fullOrgUnitCol != null && fullOrgUnitCol.size() > 0) {
                StringBuffer companyID = new StringBuffer();
                for (int i = 0; i < fullOrgUnitCol.size(); ++i) {
                    if (fullOrgUnitCol.get(i) != null && fullOrgUnitCol.get(i).getId() != null && fullOrgUnitCol.get(i).isIsCompanyOrgUnit() && i > 0) {
                        companyID.append(",");
                    }
                    companyID.append(fullOrgUnitCol.get(i).getId().toString());
                }
                if (companyID != null && companyID.length() > 0) {
                    EntityViewInfo view = new EntityViewInfo();
                    SelectorItemCollection seleEtry = view.getSelector();
                    seleEtry.add(new SelectorItemInfo("id"));
                    seleEtry.add(new SelectorItemInfo("number"));
                    seleEtry.add(new SelectorItemInfo("name"));
                    seleEtry.add(new SelectorItemInfo("isBizUnit"));
                    FilterInfo filter = new FilterInfo();
                    FilterItemInfo item = new FilterItemInfo("id", (Object)companyID.toString(), CompareType.INCLUDE);
                    filter.getFilterItems().add(item);
                    view.setFilter(filter);
                    CompanyOrgUnitCollection companyOrgUnitCol = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
                    if (companyOrgUnitCol != null && companyOrgUnitCol.size() > 0) {
                        for (int i = 0; i < companyOrgUnitCol.size(); ++i) {
                            if (companyOrgUnitCol.get(i) == null || !companyOrgUnitCol.get(i).isIsBizUnit()) continue;
                            seleCompanyOrgUnitInfo = companyOrgUnitCol.get(i);
                            break;
                        }
                    }
                }
            }
        }
        return seleCompanyOrgUnitInfo;
    }

    private OrgUnitCollection getStorageUnitInfo(CompanyOrgUnitInfo cou) {
        try {
            if (cou == null) {
                return null;
            }
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection orgCol = iUnitRel.getFromUnit(cou.getId().toString(), 1, 4);
            return orgCol;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    private Set getStoragesIDSet(CompanyOrgUnitInfo company) {
        HashSet<String> storageSet = new HashSet<String>();
        OrgUnitCollection storageColl = this.getStorageUnitInfo(company);
        if (storageColl != null) {
            OrgUnitInfo org = null;
            StorageOrgUnitInfo storage = null;
            int size = storageColl.size();
            for (int index = 0; index < size; ++index) {
                org = storageColl.get(index);
                if (!(org instanceof StorageOrgUnitInfo) || !(storage = (StorageOrgUnitInfo)org).isIsBizUnit()) continue;
                storageSet.add(org.getId().toString());
            }
        }
        return storageSet;
    }

    private Set filterAuthorizedOrgs(Object[] orgIDs, OrgType orgType, String permItem) throws EASBizException, BOSException {
        HashSet<Object> authOrgsV = new HashSet<Object>();
        Set authorizedStorageSet = IMRptUtils.getAuthorizedOrg((OrgType)orgType, (String)permItem);
        int size = orgIDs.length;
        for (int i = 0; i < size; ++i) {
            if (!authorizedStorageSet.contains(orgIDs[i])) continue;
            authOrgsV.add(orgIDs[i]);
        }
        return authOrgsV;
    }

    private void getWarehouseFilter(CompanyOrgUnitInfo companyInfo, KDBizPromptBox bizWarehouseF7, int isStarted) throws EASBizException, BOSException {
        if (companyInfo == null) {
            return;
        }
        Set storageSet = this.getStoragesIDSet(companyInfo);
        Set authOrgsV = this.filterAuthorizedOrgs(storageSet.toArray(), OrgType.Storage, this.getViewPermission());
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORG.ID", (Object)authOrgsV, CompareType.INCLUDE));
        if (isStarted != -1) {
            filterInfo.getFilterItems().add(new FilterItemInfo("SOWH.ISSTARTED", (Object)new Integer(isStarted), CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        bizWarehouseF7.setEntityViewInfo(viewInfo);
    }

    private void getStorageUnitFilter(CompanyOrgUnitInfo companyInfo, KDBizPromptBox bizStorageOrgUnit) throws EASBizException, BOSException {
        if (companyInfo == null) {
            return;
        }
        CalculateClientUtil.setStorageOrgF7(companyInfo, bizStorageOrgUnit, null);
    }

    private void getSupplierF7(KDBizPromptBox bizSupplierBox, CompanyOrgUnitInfo cou, Object owner, boolean isMulti) throws Exception {
        if (cou != null) {
            EntityViewInfo companyViewInfo = new EntityViewInfo();
            FilterInfo companyFilterInfo = new FilterInfo();
            companyFilterInfo.getFilterItems().add(new FilterItemInfo("COMPANYORGUNIT.ID", (Object)cou.getId().toString(), CompareType.EQUALS));
            companyViewInfo.setFilter(companyFilterInfo);
            bizSupplierBox.setEditable(true);
            bizSupplierBox.setDisplayFormat("$name$");
            bizSupplierBox.setEditFormat("$number$");
            bizSupplierBox.setCommitFormat("$number$");
            bizSupplierBox.setEntityViewInfo(companyViewInfo);
            GeneralKDPromptSelectorAdaptor selectorLisenter = null;
            String bosType = CSSPGroupInfo.getBosType();
            selectorLisenter = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizSupplierBox, (Component)new F7SupplierTreeDetailListUI(), owner, bosType, "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQuery", "browseGroup.id");
            selectorLisenter.setIsMultiSelect(isMulti);
            bizSupplierBox.setSelector((KDPromptSelector)selectorLisenter);
            bizSupplierBox.addSelectorListener((SelectorListener)selectorLisenter);
        }
    }
}

