/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.cal.EvaluateGatherReportFacadeFactory;
import com.kingdee.eas.scm.cal.client.AbstractEvaluateGatherReportUI;
import com.kingdee.eas.scm.cal.client.EvaluateDetailReportUI;
import com.kingdee.eas.scm.cal.client.EvaluateGatherReportConditionUI;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class EvaluateGatherReportUI
extends AbstractEvaluateGatherReportUI {
    private static final Logger logger = CoreUIObject.getLogger(EvaluateGatherReportUI.class);
    private static final String permItem_print = "evaluatedetailreport_print";
    private String res = "com.kingdee.eas.scm.cal.CalRptResource";
    public static final Color necessaryColor = new Color(252, 251, 223);

    public EvaluateGatherReportUI() throws Exception {
        this.initToolbar();
        this.tbl.setEditable(false);
        this.tbl.getActionMap().remove("Delete");
        this.tbl.checkParsed();
        this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tbl.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.tbl);
        this.tbl.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                EvaluateGatherReportUI.this.tbl_afterDataFill(e, EvaluateGatherReportUI.this.tbl);
            }
        });
        this.tbl.getDataRequestManager().setExportMemoryCallback(false);
    }

    private void initToolbar() {
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnViewUI.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.menuViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
    }

    protected void tbl_afterDataFill(KDTDataRequestEvent e, KDTable tbl) {
        int from = e.getFirstRow();
        int last = e.getLastRow();
        for (int i = from; i <= last; ++i) {
            IRow row = tbl.getRow(i);
            int qtyprecision = Integer.parseInt(row.getCell("fqtyprecision").getValue().toString());
            int priceprecision = Integer.parseInt(row.getCell("fpriceprecision").getValue().toString());
            row.getCell("FBeginQTY").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)qtyprecision));
            row.getCell("FBeginPrice").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)priceprecision));
            row.getCell("FInQTY").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)qtyprecision));
            row.getCell("FInPrice").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)priceprecision));
            row.getCell("FOutQTY").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)qtyprecision));
            row.getCell("FOutPrice").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)priceprecision));
            row.getCell("FRemainQTY").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)qtyprecision));
            row.getCell("FRemainPrice").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)priceprecision));
            String sumType = (String)row.getCell("FSumTypeName").getValue();
            if (!EASResource.getString((String)this.res, (String)"PERIODTOTAL").equals(sumType) && !EASResource.getString((String)this.res, (String)"YEARTOTAL").equals(sumType) && !EASResource.getString((String)this.res, (String)"SUMALL").equals(sumType)) continue;
            row.getStyleAttributes().setBackground(necessaryColor);
        }
    }

    @Override
    protected void tbl_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            ActionEvent evt = new ActionEvent(this.btnViewUI, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            actView.actionPerformed(evt);
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.params.getObject("company");
        if (company != null) {
            IMRptUtils.checkHasAuthorized((String)company.getId().toString(), (OrgType)OrgType.Company, (String)permItem_print);
            super.actionPrint_actionPerformed(e);
        }
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.params.getObject("company");
        if (company != null) {
            IMRptUtils.checkHasAuthorized((String)company.getId().toString(), (OrgType)OrgType.Company, (String)permItem_print);
            super.actionPrintPreview_actionPerformed(e);
        }
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.checkObjectExists()) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.params.setObject("CurrentMaterialID", (Object)this.getSelectedKeyValue());
        RptParams detailParams = (RptParams)this.params.clone();
        detailParams.setString("tempTable", null);
        detailParams.setString("com.kingdee.eas.framework.report.client.CommRptBaseUI#PARAMS_KEY_TEMPTABLENAME", null);
        uiContext.put((Object)"rptParams", (Object)detailParams);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String getSelectedKeyValue() {
        KDTSelectBlock selectBlock = this.tbl.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tbl.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(this.getKeyFieldName());
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if (!((keyValue = cell.getValue()) == null || keyValue.equals("0") || keyValue.equals(" ") || keyValue.equals(""))) {
                return keyValue.toString();
            }
            return null;
        }
        return null;
    }

    private String getKeyFieldName() {
        return "FMaterialID";
    }

    private String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        RealModeIDList idList = new RealModeIDList();
        idList.add(this.getSelectedKeyValue());
        uiContext.put((Object)"IDList", (Object)idList);
    }

    private String getEditUIName() {
        return EvaluateDetailReportUI.class.getName();
    }

    private void checkSelected() {
        if (this.tbl.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private boolean checkObjectExists() throws BOSException, EASBizException, Exception {
        return this.getSelectedKeyValue() != null;
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return EvaluateGatherReportFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tbl;
    }

    protected RptParams getParamsForInit() {
        RptParams initParam = new RptParams();
        return initParam;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        EvaluateGatherReportConditionUI condUI = new EvaluateGatherReportConditionUI();
        condUI.setSize(380, 340);
        return condUI;
    }

    protected void query() {
        this.tbl.removeColumns();
        this.tbl.removeRows();
        this.initUIMainOrgContext(((CompanyOrgUnitInfo)this.params.getObject("company")).getId().toString());
        this.initUserConfig();
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        try {
            RptParams rpt;
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            RptParams para = new RptParams();
            para.setObject("sumType", this.params.getObject("sumType"));
            para.setObject("company", this.params.getObject("company"));
            para.setObject("onlyViewSumRow", this.params.getObject("onlyViewSumRow"));
            if (from == 0) {
                int i;
                boolean flag;
                para.setBoolean("filteNoINOut", this.params.getBoolean("filteNoINOut"));
                para.setInt("endQtyFilter", this.params.getObject("endQtyFilter") == null ? 0 : this.params.getInt("endQtyFilter"));
                para.setString("tempTable", this.getTempTable());
                para.setObject("materialFrom", this.params.getObject("materialFrom"));
                para.setObject("materialTo", this.params.getObject("materialTo"));
                para.setObject("voucher", this.params.getObject("voucher"));
                para.setObject("status", this.params.getObject("status"));
                para.setInt("accPeriodYearFrom", this.params.getInt("accPeriodYearFrom"));
                para.setInt("accPeriodMonthFrom", this.params.getInt("accPeriodMonthFrom"));
                para.setInt("accPeriodYearTo", this.params.getInt("accPeriodYearTo"));
                para.setInt("accPeriodMonthTo", this.params.getInt("accPeriodMonthTo"));
                para.setObject("supperFrom", this.params.getObject("supperFrom"));
                para.setObject("supperTo", this.params.getObject("supperTo"));
                if (this.params.getObject("storageOrgUnit") != null) {
                    Object[] storageArray = (Object[])this.params.getObject("storageOrgUnit");
                    StringBuffer storageOrgNumber = new StringBuffer();
                    flag = true;
                    for (i = 0; i < storageArray.length; ++i) {
                        StorageOrgUnitInfo storageInfo = (StorageOrgUnitInfo)storageArray[i];
                        if (storageInfo == null) {
                            flag = false;
                            continue;
                        }
                        if (i != 0) {
                            storageOrgNumber.append(",");
                        }
                        storageOrgNumber.append("'").append(storageInfo.getNumber()).append("'");
                    }
                    if (storageOrgNumber.length() > 0 && flag) {
                        para.setString("storageOrgUnit", storageOrgNumber.toString());
                    }
                }
                if (this.params.getObject("warehouse") != null) {
                    Object[] warehsArray = (Object[])this.params.getObject("warehouse");
                    StringBuffer warehsNumber = new StringBuffer();
                    flag = true;
                    for (i = 0; i < warehsArray.length; ++i) {
                        WarehouseInfo warehouse = (WarehouseInfo)warehsArray[i];
                        if (warehouse == null) {
                            flag = false;
                            continue;
                        }
                        if (i != 0) {
                            warehsNumber.append(",");
                        }
                        warehsNumber.append("'").append(warehouse.getNumber()).append("'");
                    }
                    if (warehsNumber.length() > 0 && flag) {
                        para.setString("warehouse", warehsNumber.toString());
                    }
                }
                para.setObject("materialTypeFrom", this.params.getObject("materialTypeFrom"));
                para.setObject("materialTypeTo", this.params.getObject("materialTypeTo"));
                rpt = EvaluateGatherReportFacadeFactory.getRemoteInstance().createTempTable(para);
                this.setTempTable(rpt.getString("tempTable"));
                RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tbl);
            }
            para.setString("tempTable", this.getTempTable());
            para.setString("isPrint", "true");
            rpt = EvaluateGatherReportFacadeFactory.getRemoteInstance().query(para, from, len);
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.tbl);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected Map preparePrintVariantMap() {
        return super.preparePrintVariantMap();
    }

    public Object getTablePreferenceSchemaKey() {
        QuerySolutionInfo currentSolutionInfo;
        Object obj = super.getTablePreferenceSchemaKey();
        if (obj == null && (currentSolutionInfo = this.queryDialog.getCommonQueryParam().getCurrentSolutionInfo()) != null) {
            obj = currentSolutionInfo.getId();
        }
        return obj;
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        if (this.getUIContext().get("rptParams") != null) {
            return true;
        }
        if (useDefaultSolution) {
            IQuerySolutionFacade iQuery = null;
            QuerySolutionInfo solution = null;
            try {
                iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
                String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.getQueryMetaDataPK()).getFullName();
                solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
                this.queryDialog.setCurrentSolutionInfo(solution);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (solution == null || EASResource.getString((String)"com.kingdee.eas.framework.report.CommRptResource", (String)"DefaultSolution").equals(solution.getName())) {
                useDefaultSolution = false;
            }
        }
        return super.showQueryDialog(useDefaultSolution);
    }
}

