/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.IWriteOffGroup;
import com.kingdee.eas.scm.cal.WriteOffGroupFactory;
import com.kingdee.eas.scm.cal.client.AbstractExceptionBalanceReportFilterUI;
import com.kingdee.eas.scm.cal.info.WriteOffPeriodInfo;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ExceptionBalanceReportFilterUI
extends AbstractExceptionBalanceReportFilterUI {
    boolean iniUnit = true;
    private static final long serialVersionUID = -3182138781359132270L;
    private static final Logger logger = CoreUIObject.getLogger(ExceptionBalanceReportFilterUI.class);
    private CompanyOrgUnitInfo oldCompanyInfo = null;
    private Map periodMap = new HashMap();
    private F7ContextManager f7Manger = new F7ContextManager((Component)((Object)this), OrgType.Company, 1);
    private final String CAL_COM_RESOURCE = "com.kingdee.eas.scm.cal.CalCommonResource";

    public void onLoad() throws Exception {
        super.onLoad();
        CalculateClientUtil.setCompanyOrgF7ForSealUp(this.prmtFinanceOrgUnit, "exceptionbalancereport_view", true);
        SCMClientUtils.setF7OrgUnitBizUnit((KDBizPromptBox)this.prmtFinanceOrgUnit);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getData();
        if (null != company && !this.periodMap.containsKey(company.getId().toString())) {
            IWriteOffGroup iw = WriteOffGroupFactory.getRemoteInstance();
            Map map = iw.loadFinanceData(company);
            WriteOffPeriodInfo info = (WriteOffPeriodInfo)map.get(company.getId().toString());
            this.periodMap.put(company.getId().toString(), info);
        }
        this.prmtFinanceOrgUnit.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                if (e.getData() != null && e.getData().equals(e.getOldData())) {
                    return;
                }
                e.setResult(ExceptionBalanceReportFilterUI.this.prmtCompanyOrgUnit(e));
            }
        });
        this.spinPeriodYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (((KDSpinner)arg0.getSource()).equals(ExceptionBalanceReportFilterUI.this.spinPeriodYear)) {
                    ExceptionBalanceReportFilterUI.this.setPeriod(ExceptionBalanceReportFilterUI.this.spinPeriodYear);
                }
            }
        });
        this.spinPeriodYearTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (((KDSpinner)arg0.getSource()).equals(ExceptionBalanceReportFilterUI.this.spinPeriodYearTo)) {
                    ExceptionBalanceReportFilterUI.this.setPeriod(ExceptionBalanceReportFilterUI.this.spinPeriodYearTo);
                }
            }
        });
        this.prmtStorage.setEnabledMultiSelection(true);
        this.prmtWarehs.setEnabledMultiSelection(true);
        if ("preEndBalance".equalsIgnoreCase(this.getOprtState())) {
            this.spinPeriodYear.setEnabled(false);
            this.spinPeriodYearTo.setEnabled(false);
            this.spinPeriodMonth.setEnabled(false);
            this.spinPeriodMonthTo.setEnabled(false);
        }
        this.prmtMaterial.setCommitParser(null);
        this.prmtMaterialTo.setCommitParser(null);
        CalculateClientUtil.addListenerForMultiF7(this.prmtMaterial, this.prmtMaterialTo);
        if (company != null) {
            this.f7Manger.changeF7Context(company.getId().toString());
        }
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtMaterial, this.prmtMaterialTo});
    }

    private int prmtCompanyOrgUnit(PreChangeEvent e) {
        try {
            String strTemp;
            Object obj = e.getData();
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = null;
            if (obj instanceof CompanyOrgUnitInfo && !this.periodMap.containsKey((aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)e.getData()).getId().toString())) {
                IWriteOffGroup iw = WriteOffGroupFactory.getRemoteInstance();
                Map map = iw.loadFinanceData(aCompanyOrgUnitInfo);
                WriteOffPeriodInfo info = (WriteOffPeriodInfo)map.get(aCompanyOrgUnitInfo.getId().toString());
                this.periodMap.put(aCompanyOrgUnitInfo.getId().toString(), info);
            }
            if (aCompanyOrgUnitInfo != null && !aCompanyOrgUnitInfo.equals(e.getOldData())) {
                int ret;
                if (!this.isPeriodNotNull(aCompanyOrgUnitInfo)) {
                    return 0;
                }
                if ((this.prmtMaterial.getValue() != null || this.prmtMaterialTo.getValue() != null) && (ret = MsgBox.showConfirm2((String)(strTemp = InvClientUtils.getResource((String)"CLEAR_RELATION_AFTER_ORGCHANGED")))) == 2) {
                    return 0;
                }
                this.loadAccountPeriod(aCompanyOrgUnitInfo);
                this.prmtMaterial.setValue(null);
                this.prmtMaterialTo.setValue(null);
                this.f7Manger.registerBizMaterialF7(this.prmtMaterial, null, null, (OrgUnitInfo)aCompanyOrgUnitInfo, OrgType.Company, true);
                this.f7Manger.registerBizMaterialF7(this.prmtMaterialTo, null, null, (OrgUnitInfo)aCompanyOrgUnitInfo, OrgType.Company, false);
            } else if (aCompanyOrgUnitInfo == null && (this.prmtMaterial.getValue() != null || this.prmtMaterialTo.getValue() != null)) {
                strTemp = InvClientUtils.getResource((String)"CLEAR_RELATION_AFTER_ORGCHANGED");
                int ret = MsgBox.showConfirm2((String)strTemp);
                if (ret == 2) {
                    return 0;
                }
                this.prmtMaterial.setValue(null);
                this.prmtMaterialTo.setValue(null);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return 1;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtFinanceOrgUnit;
    }

    private boolean isPeriodNotNull(CompanyOrgUnitInfo companyOrgUnitInfo) {
        PeriodInfo curPeriodInfo = null;
        try {
            if (this.periodMap.containsKey(companyOrgUnitInfo.getId().toString())) {
                WriteOffPeriodInfo info = (WriteOffPeriodInfo)this.periodMap.get(companyOrgUnitInfo.getId().toString());
                curPeriodInfo = info.getCurPeriodInfo();
            } else {
                curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (curPeriodInfo == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_IS_NULL"));
            this.prmtFinanceOrgUnit.setValue(null);
            this.iniUnit = false;
            return false;
        }
        return true;
    }

    @Override
    public void loadFields() {
        SCMClientUtils.setMainBizOrgF7forSealUp((KDBizPromptBox)this.prmtFinanceOrgUnit, (OrgType)this.getMainBizOrgType(), (String)this.getViewPermission());
        super.loadFields();
    }

    protected String getViewPermission() {
        return "exceptionbalancereport_view";
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void prmtFinanceOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        super.prmtFinanceOrgUnit_stateChanged(e);
        if (this.oldCompanyInfo != null && this.prmtFinanceOrgUnit.getData() != null) {
            if (!this.oldCompanyInfo.getId().toString().equals(((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getData()).getId().toString())) {
                this.loadAccountPeriod((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getData());
            }
        } else {
            this.spinPeriodYear.setValue((Object)new Integer(0));
            this.spinPeriodMonth.setValue((Object)new Integer(0));
            this.spinPeriodYearTo.setValue((Object)new Integer(0));
            this.spinPeriodMonthTo.setValue((Object)new Integer(0));
            if (this.prmtFinanceOrgUnit.getData() != null) {
                this.loadAccountPeriod((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getData());
            }
        }
        this.oldCompanyInfo = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getData();
        this.prmtStorage.setValue(null);
        CalculateClientUtil.setStorageOrgF7(this.oldCompanyInfo, this.prmtStorage, null);
        CalculateClientUtil.setWareHouseEntity(this.prmtFinanceOrgUnit, this.prmtStorage, this.prmtWarehs, true);
    }

    @Override
    protected void prmtStorageOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        Object[] storages = (Object[])this.prmtStorage.getValue();
        this.prmtWarehs.setValue(null);
        if (storages != null) {
            this.prmtWarehs.setEnabled(true);
        } else {
            this.prmtWarehs.setValue(null);
            this.prmtWarehs.setEnabled(false);
        }
        CalculateClientUtil.setWareHouseEntity(this.prmtFinanceOrgUnit, this.prmtStorage, this.prmtWarehs, false);
    }

    public void onInit(RptParams arg0) throws Exception {
        this.onInitFilter();
    }

    private void onInitFilter() {
        try {
            CalculateClientUtil.InitCompanyF7(this.prmtFinanceOrgUnit, "exceptionbalancereport_view");
            if (this.prmtFinanceOrgUnit.getValue() != null) {
                this.oldCompanyInfo = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue();
                this.loadAccountPeriod(this.oldCompanyInfo);
            }
            if (!this.iniUnit) {
                this.prmtFinanceOrgUnit.setData(null);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void setPeriod(KDSpinner periodYear) {
        try {
            if (periodYear.getValue() != null) {
                KDSpinner kdspinner = this.spinPeriodMonth;
                if (periodYear.equals(this.spinPeriodYearTo)) {
                    kdspinner = this.spinPeriodMonthTo;
                }
                int year = (Integer)periodYear.getValue();
                CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getData();
                PeriodInfo curPeriodInfo = null;
                PeriodInfo startPeriodInfo = null;
                int minMonth = 1;
                int maxMonth = 12;
                if (companyInfo != null) {
                    if (this.periodMap.containsKey(companyInfo.getId().toString())) {
                        WriteOffPeriodInfo info = (WriteOffPeriodInfo)this.periodMap.get(companyInfo.getId().toString());
                        curPeriodInfo = info.getCurPeriodInfo();
                        startPeriodInfo = info.getStartPeriodInfo();
                        minMonth = info.getMinMonth();
                        maxMonth = info.getMaxMonth();
                    } else {
                        curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
                        startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
                        minMonth = PeriodUtils.getMinPeriodNumber(null, (int)year, (String)companyInfo.getId().toString());
                        maxMonth = PeriodUtils.getMaxPeriodNumber(null, (int)year, (String)companyInfo.getId().toString());
                    }
                    if (minMonth == 0) {
                        minMonth = 1;
                    }
                    if (maxMonth == 0) {
                        maxMonth = 12;
                    }
                }
                if (startPeriodInfo != null && year == startPeriodInfo.getPeriodYear()) {
                    minMonth = startPeriodInfo.getPeriodNumber();
                }
                this.SetSpinnerMaxMin((JSpinner)kdspinner, minMonth, maxMonth);
                if (curPeriodInfo != null) {
                    kdspinner.setValue((Object)new Integer(curPeriodInfo.getPeriodNumber()));
                }
                if (kdspinner.getIntegerVlaue() < minMonth) {
                    kdspinner.setValue((Object)new Integer(minMonth));
                }
                if (kdspinner.getIntegerVlaue() > maxMonth) {
                    kdspinner.setValue((Object)new Integer(maxMonth));
                }
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private void loadAccountPeriod(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        PeriodInfo periodInfo = null;
        PeriodInfo curPeriodInfo = null;
        int minYear = 0;
        int maxYear = 0;
        if (companyInfo != null) {
            if (!this.periodMap.containsKey(companyInfo.getId().toString())) {
                IWriteOffGroup iw = WriteOffGroupFactory.getRemoteInstance();
                Map map = iw.loadFinanceData(companyInfo);
                WriteOffPeriodInfo info = (WriteOffPeriodInfo)map.get(companyInfo.getId().toString());
                this.periodMap.put(companyInfo.getId().toString(), info);
            }
            if (this.periodMap.containsKey(companyInfo.getId().toString())) {
                WriteOffPeriodInfo info = (WriteOffPeriodInfo)this.periodMap.get(companyInfo.getId().toString());
                periodInfo = info.getStartPeriodInfo();
                curPeriodInfo = info.getCurPeriodInfo();
                minYear = info.getMinYear();
                maxYear = info.getMaxYear();
            } else {
                periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
                curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
                minYear = PeriodUtils.getMaxOrMinPeriodYear(null, (String)companyInfo.getId().toString(), (boolean)false);
                maxYear = PeriodUtils.getMaxOrMinPeriodYear(null, (String)companyInfo.getId().toString(), (boolean)true);
            }
        }
        this.SetSpinnerMaxMin((JSpinner)this.spinPeriodYear, minYear, maxYear);
        this.SetSpinnerMaxMin((JSpinner)this.spinPeriodYearTo, minYear, maxYear);
        if (curPeriodInfo != null) {
            this.spinPeriodYear.setValue((Object)new Integer(curPeriodInfo.getPeriodYear()));
            this.spinPeriodYearTo.setValue((Object)new Integer(curPeriodInfo.getPeriodYear()));
            this.setPeriod(this.spinPeriodYear);
            this.setPeriod(this.spinPeriodYearTo);
        }
        if (periodInfo != null) {
            // empty if block
        }
    }

    public RptParams getCustomCondition() {
        MaterialInfo m;
        RptParams para = new RptParams();
        String CompanyOrgUnitID = "";
        String companyname = "";
        String MaterialFrom = "";
        String MaterialTo = "";
        String MaterialIn = "";
        String MaterialFromId = "";
        String MaterialToId = "";
        if (this.prmtFinanceOrgUnit.getValue() != null) {
            companyname = ((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue()).getName();
            if (((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue()).getId() != null) {
                CompanyOrgUnitID = ((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue()).getId().toString();
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COMPANY_NOTNULL"));
        }
        if (this.prmtMaterial.getValue() != null) {
            m = null;
            if (this.prmtMaterial.getValue() instanceof Object[]) {
                Object[] materials = (Object[])this.prmtMaterial.getValue();
                if (materials.length == 1) {
                    m = (MaterialInfo)materials[0];
                } else {
                    StringBuffer number = new StringBuffer();
                    StringBuffer id = new StringBuffer();
                    number.append("'");
                    for (int i = 0; i < materials.length; ++i) {
                        if (i != 0) {
                            number.append("','");
                            id.append(",");
                        }
                        number.append(((MaterialInfo)materials[i]).getNumber());
                        id.append(((MaterialInfo)materials[i]).getId().toString());
                    }
                    number.append("'");
                    MaterialIn = number.toString();
                    MaterialFromId = id.toString();
                }
            } else if (this.prmtMaterial.getValue() instanceof MaterialInfo) {
                m = (MaterialInfo)this.prmtMaterial.getValue();
            } else {
                MaterialFrom = this.prmtMaterial.getValue().toString();
            }
            if (m != null) {
                MaterialFrom = m.getNumber();
                if (m.getId() != null) {
                    MaterialFromId = m.getId().toString();
                }
            }
        }
        if (this.prmtMaterialTo.getValue() != null) {
            m = null;
            if (this.prmtMaterialTo.getValue() instanceof MaterialInfo[]) {
                m = ((MaterialInfo[])this.prmtMaterialTo.getValue())[0];
            } else if (this.prmtMaterialTo.getValue() instanceof MaterialInfo) {
                m = (MaterialInfo)this.prmtMaterialTo.getValue();
            }
            if (m != null) {
                MaterialTo = m.getNumber();
                if (m.getId() != null) {
                    MaterialToId = m.getId().toString();
                }
            } else {
                MaterialTo = this.prmtMaterialTo.getValue().toString();
            }
        }
        para.setBoolean("isShowAll", !this.kdSelectAllCalcData.isSelected());
        para.setBoolean("ckShowNoCalculate", this.ckShowNoCalculate.isSelected());
        para.setString("COMPANY_ID", CompanyOrgUnitID);
        para.setString("COMPANY_NAME", companyname);
        para.setString("MATERIAL_FROM", MaterialFrom);
        para.setString("MATERIAL_TO", MaterialTo);
        para.setString("MATERIAL_IN", MaterialIn);
        para.setString("MATERIAL_ID_FROM", MaterialFromId);
        para.setString("MATERIAL_ID_TO", MaterialToId);
        para.setInt("YEAR_FROM", this.spinPeriodYear.getIntegerVlaue().intValue());
        para.setInt("PERIOD_FROM", this.spinPeriodMonth.getIntegerVlaue().intValue());
        para.setInt("YEAR_TO", this.spinPeriodYearTo.getIntegerVlaue().intValue());
        para.setInt("PERIOD_TO", this.spinPeriodMonthTo.getIntegerVlaue().intValue());
        para.setInt("costOutMark", this.kdcbOutCostadj.getSelectedIndex());
        para.setInt("calcType", this.cbCalcType.getSelectedIndex());
        para.setInt("sumType", this.cbShowType.getSelectedIndex());
        para.setObject("STORAGEORGUNIT", this.prmtStorage.getValue());
        para.setObject("WAREHOUSE", this.prmtWarehs.getValue());
        para.setInt("cbQty", this.cbQty.getSelectedIndex());
        para.setInt("cbAmount", this.cbAmount.getSelectedIndex());
        para.setInt("cbReturnNum", this.cbReturnNum.getSelectedIndex());
        if ("preEndBalance".equalsIgnoreCase(this.getOprtState())) {
            para.setBoolean("isPreCloseAccount", true);
        }
        return para;
    }

    public void setCustomCondition(RptParams params) {
        try {
            CompanyOrgUnitInfo cinfo = null;
            if (params.getString("COMPANY_ID") != null && params.getString("COMPANY_ID").length() != 0) {
                cinfo = null != this.oldCompanyInfo && params.getString("COMPANY_ID").equals(this.oldCompanyInfo.getId().toString()) ? this.oldCompanyInfo : CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(params.getString("COMPANY_ID")));
                this.prmtFinanceOrgUnit.setValue((Object)cinfo);
            }
            if (params.getString("MATERIAL_ID_FROM") != null && params.getString("MATERIAL_ID_FROM").length() != 0) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)params.getString("MATERIAL_ID_FROM"), CompareType.INCLUDE));
                view.setFilter(filterInfo);
                MaterialCollection minfo = MaterialFactory.getRemoteInstance().getMaterialCollection(view);
                this.prmtMaterial.setValue((Object)minfo.toArray());
            } else if (params.getString("MATERIAL_FROM") != null) {
                this.prmtMaterial.setValue((Object)params.getString("MATERIAL_FROM"));
            }
            if (params.getString("MATERIAL_ID_TO") != null && params.getString("MATERIAL_ID_TO").length() != 0) {
                MaterialInfo mtoinfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(params.getString("MATERIAL_ID_TO")));
                this.prmtMaterialTo.setValue((Object)mtoinfo);
            } else if (params.getString("MATERIAL_TO") != null) {
                this.prmtMaterialTo.setValue((Object)params.getString("MATERIAL_TO"));
            }
            this.ckShowNoCalculate.setSelected(params.getBoolean("ckShowNoCalculate"));
            this.spinPeriodYear.setValue((Object)new Integer(params.getInt("YEAR_FROM")));
            this.spinPeriodMonth.setValue((Object)new Integer(params.getInt("PERIOD_FROM")));
            this.spinPeriodYearTo.setValue((Object)new Integer(params.getInt("YEAR_TO")));
            this.spinPeriodMonthTo.setValue((Object)new Integer(params.getInt("PERIOD_TO")));
            if ("preEndBalance".equalsIgnoreCase(this.getOprtState())) {
                PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cinfo);
                this.spinPeriodYear.setValue((Object)new Integer(curPeriodInfo.getPeriodYear()));
                this.spinPeriodMonth.setValue((Object)new Integer(curPeriodInfo.getPeriodNumber()));
                this.spinPeriodYearTo.setValue((Object)new Integer(curPeriodInfo.getPeriodYear()));
                this.spinPeriodMonthTo.setValue((Object)new Integer(curPeriodInfo.getPeriodNumber()));
            }
            this.kdcbOutCostadj.setSelectedIndex(params.getInt("costOutMark"));
            this.cbCalcType.setSelectedIndex(params.getInt("calcType"));
            this.cbShowType.setSelectedIndex(params.getInt("sumType"));
            this.cbQty.setSelectedIndex(params.getInt("cbQty"));
            this.cbAmount.setSelectedIndex(params.getInt("cbAmount"));
            int returnNumIndex = 0;
            if (params.getObject("cbReturnNum") != null) {
                returnNumIndex = params.getInt("cbReturnNum");
            }
            this.cbReturnNum.setSelectedIndex(returnNumIndex);
            this.prmtStorage.setValue(params.getObject("STORAGEORGUNIT"));
            this.prmtWarehs.setValue(params.getObject("WAREHOUSE"));
            this.kdSelectAllCalcData.setSelected(!params.getBoolean("isShowAll"));
            if ("preEndBalance".equalsIgnoreCase(this.getOprtState())) {
                params.setBoolean("isPreCloseAccount", true);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public void dataChanged(DataChangeEvent e) {
    }

    private void SetSpinnerMaxMin(JSpinner spinner, int min, int max) {
        SpinnerModel model = spinner.getModel();
        if (model instanceof SpinnerNumberModel) {
            if (max > min) {
                ((SpinnerNumberModel)model).setMaximum(new Integer(max));
            }
            ((SpinnerNumberModel)model).setMinimum(new Integer(min));
        }
    }

    public void stateChanged(ChangeEvent e) {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getData();
        KDSpinner aSpinner = (KDSpinner)e.getSource();
        PeriodInfo periodInfo = null;
        try {
            periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
            if (periodInfo != null) {
                int startYear = periodInfo.getPeriodYear();
                int startMonth = periodInfo.getPeriodNumber();
                int minPeriod = PeriodUtils.getMinPeriodNumber(null, (int)Integer.parseInt(aSpinner.getValue().toString()), (String)aCompanyOrgUnitInfo.getId().toString());
                int maxPeriod = PeriodUtils.getMaxPeriodNumber(null, (int)Integer.parseInt(aSpinner.getValue().toString()), (String)aCompanyOrgUnitInfo.getId().toString());
                if (aSpinner.getName().toString().equals("spinPeriodYear")) {
                    if (Integer.parseInt(aSpinner.getValue().toString()) == startYear) {
                        minPeriod = startMonth;
                    }
                    this.SetSpinnerMaxMin((JSpinner)this.spinPeriodMonth, minPeriod, maxPeriod);
                    int curPeriod = Integer.parseInt(this.spinPeriodMonth.getValue().toString());
                    if (curPeriod < minPeriod || curPeriod > maxPeriod) {
                        this.spinPeriodMonth.setValue((Object)new Integer(maxPeriod));
                    }
                } else {
                    if (Integer.parseInt(aSpinner.getValue().toString()) == startYear) {
                        minPeriod = startMonth;
                    }
                    this.SetSpinnerMaxMin((JSpinner)this.spinPeriodMonthTo, minPeriod, maxPeriod);
                    int curPeriod = Integer.parseInt(this.spinPeriodMonth.getValue().toString());
                    if (curPeriod < minPeriod || curPeriod > maxPeriod) {
                        this.spinPeriodMonthTo.setValue((Object)new Integer(maxPeriod));
                    }
                }
            } else {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_IS_NULL"));
            }
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    public void clear() {
        super.clear();
        this.prmtMaterial.setValue(null);
        this.prmtMaterialTo.setValue(null);
        this.prmtFinanceOrgUnit.setValue(null);
        this.spinPeriodYear.setValue((Object)new Integer(0));
        this.spinPeriodMonth.setValue((Object)new Integer(0));
        this.spinPeriodYearTo.setValue((Object)new Integer(0));
        this.spinPeriodMonthTo.setValue((Object)new Integer(0));
        this.ckShowNoCalculate.setSelected(false);
        this.kdSelectAllCalcData.setSelected(true);
        this.cbQty.setSelectedIndex(0);
        this.cbAmount.setSelectedIndex(0);
        this.cbReturnNum.setSelectedIndex(0);
        this.kdcbOutCostadj.setSelectedIndex(0);
        this.cbShowType.setSelectedIndex(0);
        this.cbCalcType.setSelectedIndex(0);
        try {
            this.onInitFilter();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public boolean verify() {
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getData();
        if (cou == null || cou.getId() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COMPANY_NOTNULL"));
            return false;
        }
        try {
            PeriodInfo periodInfo = null;
            if (this.periodMap.containsKey(cou.getId().toString())) {
                WriteOffPeriodInfo info = (WriteOffPeriodInfo)this.periodMap.get(cou.getId().toString());
                periodInfo = info.getStartPeriodInfo();
            } else {
                periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
            }
            if (periodInfo == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_IS_NULL"));
                return false;
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return true;
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        CompanyOrgUnitInfo currentMainOrg = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        try {
            if (currentMainOrg.isIsBizUnit() && SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)this.getMainBizOrgType(), (IObjectPK)new ObjectStringPK(currentMainOrg.getId().toString()), (String)this.getViewPermission())) {
                return currentMainOrg;
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return null;
    }

    private void addF7SelectorListener(KDBizPromptBox[] f7s) {
        for (int i = 0; i < f7s.length; ++i) {
            f7s[i].addSelectorListener(new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    if (ExceptionBalanceReportFilterUI.this.getMainBizOrgF7() != null) {
                        return;
                    }
                    Object value = ExceptionBalanceReportFilterUI.this.getMainBizOrgF7().getValue();
                    if (value == null || value instanceof Object[] && ((Object[])value).length == 0 || value instanceof Object[] && ((Object[])value)[0] == null) {
                        MsgBox.showInfo((String)SCMGroupClientUtils.getMainOrgNullMsg((OrgType)OrgType.Company));
                        ExceptionBalanceReportFilterUI.this.getMainBizOrgF7().requestFocus();
                        SysUtil.abort();
                    }
                }
            });
        }
    }

    @Override
    protected void cbShowType_itemStateChanged(ItemEvent e) throws Exception {
        if (this.cbShowType.getSelectedIndex() == 1) {
            this.ckShowNoCalculate.setSelected(false);
            this.ckShowNoCalculate.setEnabled(false);
        } else {
            this.ckShowNoCalculate.setEnabled(true);
        }
    }

    protected void setNeedMainOrgF7s(KDBizPromptBox[] f7s) {
        this.addF7SelectorListener(f7s);
        this.f7Manger.setPrmtNeedOrgF7s(f7s);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }
}

