/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.CalRptUtilFacadeFactory;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.ICalRptUtilFacade;
import com.kingdee.eas.scm.cal.VoucheredEnum;
import com.kingdee.eas.scm.cal.client.AbstractExceptionBillQueryConditionUI;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ExceptionBillQueryConditionUI
extends AbstractExceptionBillQueryConditionUI {
    private static final long serialVersionUID = 8478889404996837460L;
    private boolean isSetCustomCondition = false;
    private CompanyOrgUnitInfo curCompany = null;
    private OrgUnitCollection curCompanyCol = null;
    private F7ContextManager f7Manger = new F7ContextManager((Component)((Object)this), OrgType.Company, 1);
    private String oldStorageSting = "";

    public ExceptionBillQueryConditionUI() throws Exception {
        this.prmtBillType.setEnabledMultiSelection(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        try {
            this.initBizComponentF7();
            this.prmtCompany.setRequired(true);
            this.prmtCompany.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    try {
                        ExceptionBillQueryConditionUI.this.bizOrgUnit_stateChanged(e);
                    }
                    catch (Exception e1) {
                        ExceptionBillQueryConditionUI.this.handUIException(e1);
                    }
                }
            });
            this.prmtStartWarehouse.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Object object = ExceptionBillQueryConditionUI.this.prmtStartWarehouse.getValue();
                    if (object instanceof Object[]) {
                        Object[] obj = (Object[])object;
                        if (obj.length > 1) {
                            ExceptionBillQueryConditionUI.this.prmtEndWarehouse.setValue(null);
                            ExceptionBillQueryConditionUI.this.prmtEndWarehouse.setEnabled(false);
                        } else {
                            ExceptionBillQueryConditionUI.this.prmtEndWarehouse.setEnabled(true);
                        }
                    } else {
                        ExceptionBillQueryConditionUI.this.prmtEndWarehouse.setEnabled(true);
                    }
                }
            });
            this.loadStatusEnum((JComboBox)this.comboBillstatus);
            this.comboBillstatus.setSelectedIndex(2);
            this.checkUnitActualcost.setSelected(true);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.prmtBizType.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BizTypeInfo bizType = (BizTypeInfo)ExceptionBillQueryConditionUI.this.prmtBizType.getValue();
                if (bizType != null) {
                    EntityViewInfo view = ExceptionBillQueryConditionUI.this.getDefaultBillTypeFilter();
                    view.getFilter().getFilterItems().add(new FilterItemInfo("billBizType.bizType.id", (Object)bizType.getId().toString()));
                    ExceptionBillQueryConditionUI.this.prmtBillType.setEntityViewInfo(view);
                } else {
                    FilterItemCollection filters = ExceptionBillQueryConditionUI.this.prmtBillType.getEntityViewInfo().getFilter().getFilterItems();
                    for (int i = 0; i < filters.size(); ++i) {
                        FilterItemInfo filter = filters.get(i);
                        if (!"billBizType.bizType.id".equals(filter.getPropertyName())) continue;
                        filters.remove(filter);
                        break;
                    }
                }
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private void initBizComponentF7() throws EASBizException, BOSException {
        SCMClientUtils.setMainBizOrgF7forSealUp((KDBizPromptBox)this.prmtCompany, (OrgType)this.getMainBizOrgType(), (String)this.getViewPermission());
        this.prmtCompany.setCommitFormat("$number$");
        this.prmtStartMaterial.setEditFormat("$number$");
        this.prmtStartMaterial.setDisplayFormat("$number$");
        this.prmtStartMaterial.setCommitFormat("$number$");
        this.prmtEndMaterial.setEditFormat("$number$");
        this.prmtEndMaterial.setDisplayFormat("$number$");
        this.prmtEndMaterial.setCommitFormat("$number$");
        this.prmtStartMaterial.setCommitParser(null);
        this.prmtEndMaterial.setCommitParser(null);
        this.f7Manger.registerBizMaterialF7(this.prmtStartMaterial, null, null, (OrgUnitInfo)this.curCompany, false);
        this.f7Manger.registerBizMaterialF7(this.prmtEndMaterial, null, null, (OrgUnitInfo)this.curCompany, false);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtStartMaterial, this.prmtEndMaterial});
        this.f7Manger.registerContextChangeF7(this.prmtStartWarehouse, this.getPropertyOfMainBizOrg());
        this.f7Manger.registerContextChangeF7(this.prmtEndWarehouse, this.getPropertyOfMainBizOrg());
        this.f7Manger.registerContextChangeF7(this.prmtStorage, this.getPropertyOfMainBizOrg());
        this.setBillTypeF7();
        this.setTranSactionTypeF7();
        this.prmtBillType.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ExceptionBillQueryConditionUI.this.setTranSactionTypeF7();
            }
        });
        this.setStorageFilterF7();
        CalculateClientUtil.setWareHouseEntity(this.prmtCompany, null, this.prmtStartWarehouse, true);
        CalculateClientUtil.setWareHouseEntity(this.prmtCompany, null, this.prmtEndWarehouse, true);
        this.prmtStorage.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    if (!ExceptionBillQueryConditionUI.this.oldStorageSting.equals(ExceptionBillQueryConditionUI.this.prmtStorage.getText())) {
                        ExceptionBillQueryConditionUI.this.prmtStartWarehouse.setValue(null);
                        ExceptionBillQueryConditionUI.this.prmtEndWarehouse.setValue(null);
                    }
                    ExceptionBillQueryConditionUI.this.oldStorageSting = ExceptionBillQueryConditionUI.this.prmtStorage.getText();
                    CalculateClientUtil.setWareHouseEntity(ExceptionBillQueryConditionUI.this.prmtCompany, ExceptionBillQueryConditionUI.this.prmtStorage, ExceptionBillQueryConditionUI.this.prmtStartWarehouse, false);
                    CalculateClientUtil.setWareHouseEntity(ExceptionBillQueryConditionUI.this.prmtCompany, ExceptionBillQueryConditionUI.this.prmtStorage, ExceptionBillQueryConditionUI.this.prmtEndWarehouse, false);
                }
                catch (EASBizException e1) {
                    ExceptionBillQueryConditionUI.this.handUIException(e1);
                }
                catch (BOSException e1) {
                    ExceptionBillQueryConditionUI.this.handUIException(e1);
                }
            }
        });
    }

    private void setBillTypeF7() {
        EntityViewInfo ev = this.getDefaultBillTypeFilter();
        this.prmtBillType.setQueryInfo("com.kingdee.eas.basedata.scm.common.app.F7BillTypeForBizTypeQuery");
        this.prmtBillType.setEntityViewInfo(ev);
        this.prmtBillType.setCommitFormat("$number$");
        this.prmtBillType.setDisplayFormat("$number$");
        this.prmtBillType.setEditFormat("$number$");
    }

    private void setTranSactionTypeF7() {
        this.prmtStartTransacionType.setValue(null);
        this.prmtEndTransactionType.setValue(null);
        this.prmtStartTransacionType.setQueryInfo("com.kingdee.eas.basedata.scm.common.app.F7TransactionTypeDefaultQuery");
        this.prmtEndTransactionType.setQueryInfo("com.kingdee.eas.basedata.scm.common.app.F7TransactionTypeDefaultQuery");
        if (this.prmtBillType.getValue() != null) {
            Object obj = this.prmtBillType.getValue();
            HashSet<String> oriSet = new HashSet<String>();
            if (obj instanceof Object[]) {
                Object[] billTypes = (Object[])this.prmtBillType.getValue();
                int size = billTypes.length;
                for (int j = 0; j < size; ++j) {
                    BillTypeInfo billType = (BillTypeInfo)billTypes[j];
                    if (billType == null) continue;
                    oriSet.add(billType.getNumber());
                }
                InvClientUtils.setFilterForTransactionTypeByBillType((KDBizPromptBox)this.prmtStartTransacionType, oriSet);
                InvClientUtils.setFilterForTransactionTypeByBillType((KDBizPromptBox)this.prmtEndTransactionType, oriSet);
            } else if (obj instanceof BillTypeInfo) {
                InvClientUtils.setFilterForTransactionType((KDBizPromptBox)this.prmtStartTransacionType, (String)((BillTypeInfo)this.prmtBillType.getValue()).getNumber());
                InvClientUtils.setFilterForTransactionType((KDBizPromptBox)this.prmtEndTransactionType, (String)((BillTypeInfo)this.prmtBillType.getValue()).getNumber());
            }
        }
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        para.setObject("company", this.prmtCompany.getValue());
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        if (companyInfo != null && companyInfo.getId() != null) {
            para.setString("COMPANY_ID", companyInfo.getId().toString());
        }
        para.setInt("startYear", this.kdspStartYear.getIntegerVlaue().intValue());
        para.setInt("startPeriod", this.kspdStartPeriod.getIntegerVlaue().intValue());
        para.setInt("endYear", this.spdEndYear.getIntegerVlaue().intValue());
        para.setInt("endPeriod", this.spdEndPeriod.getIntegerVlaue().intValue());
        para.setObject("storage", this.prmtStorage.getValue());
        para.setObject("startWarehouse", this.prmtStartWarehouse.getValue());
        para.setObject("endWarehouse", this.prmtEndWarehouse.getValue());
        para.setObject("billType", this.prmtBillType.getValue());
        para.setObject("bizType", this.prmtBizType.getValue());
        para.setObject("startTransacionType", this.prmtStartTransacionType.getValue());
        para.setObject("endTransactionType", this.prmtEndTransactionType.getValue());
        para.setObject("startMaterial", this.prmtStartMaterial.getValue());
        para.setObject("endMaterial", this.prmtEndMaterial.getValue());
        para.setObject("vouchered", this.comboVouchered.getSelectedItem());
        para.setObject("billstatus", this.comboBillstatus.getSelectedItem());
        para.setBoolean("isCalculate", this.checkIsCalculate.isSelected());
        para.setInt("isPresent", this.isPresent.getSelectedIndex());
        para.setBoolean("checkUnitActualcost", this.checkUnitActualcost.isSelected());
        para.setObject("calculateType", this.comboCalculateType.getSelectedItem());
        para.setInt("combQty", this.cbQty.getSelectedIndex());
        para.setInt("combAmt", this.cbAmount.getSelectedIndex());
        para.setObject("storeType", this.prmtStoreType.getValue());
        return para;
    }

    public void setCustomCondition(RptParams params) {
        if (params == null) {
            return;
        }
        this.isSetCustomCondition = true;
        this.prmtStoreType.setValue(params.getObject("storeType"));
        this.prmtCompany.setValue(params.getObject("company"));
        this.kdspStartYear.setValue((Object)new Integer(params.getInt("startYear")));
        this.kspdStartPeriod.setValue((Object)new Integer(params.getInt("startPeriod")));
        this.spdEndYear.setValue((Object)new Integer(params.getInt("endYear")));
        this.spdEndPeriod.setValue((Object)new Integer(params.getInt("endPeriod")));
        this.prmtStorage.setValue(params.getObject("storage"));
        this.prmtStartWarehouse.setValue(params.getObject("startWarehouse"));
        this.prmtEndWarehouse.setValue(params.getObject("endWarehouse"));
        this.prmtBillType.setValue(params.getObject("billType"));
        this.prmtBizType.setValue(params.getObject("bizType"));
        this.prmtStartTransacionType.setValue(params.getObject("startTransacionType"));
        this.prmtEndTransactionType.setValue(params.getObject("endTransactionType"));
        this.prmtStartMaterial.setValue(params.getObject("startMaterial"));
        this.prmtEndMaterial.setValue(params.getObject("endMaterial"));
        this.comboVouchered.setSelectedItem(params.getObject("vouchered"));
        this.comboBillstatus.setSelectedItem(params.getObject("billstatus"));
        this.checkIsCalculate.setSelected(params.getBoolean("isCalculate"));
        this.checkUnitActualcost.setSelected(params.getBoolean("checkUnitActualcost"));
        this.comboCalculateType.setSelectedItem(params.getObject("calculateType"));
        int qtyIndex = 0;
        int amtIndex = 0;
        int present = 0;
        if (params.getObject("combQty") != null) {
            qtyIndex = (Integer)params.getObject("combQty");
        }
        if (params.getObject("combAmt") != null) {
            amtIndex = (Integer)params.getObject("combAmt");
        }
        if (params.getObject("isPresent") != null) {
            present = (Integer)params.getObject("isPresent");
        }
        this.cbQty.setSelectedIndex(qtyIndex);
        this.cbAmount.setSelectedIndex(amtIndex);
        this.isPresent.setSelectedIndex(present);
        this.isSetCustomCondition = false;
    }

    protected String getViewPermission() {
        return "exceptionBillQuery_view";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    private String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompany;
    }

    private void loadStatusEnum(JComboBox cb) {
        DefaultComboBoxModel<BillBaseStatusEnum> model = new DefaultComboBoxModel<BillBaseStatusEnum>();
        model.addElement(BillBaseStatusEnum.NULL);
        model.addElement(BillBaseStatusEnum.TEMPORARILYSAVED);
        model.addElement(BillBaseStatusEnum.SUBMITED);
        model.addElement(BillBaseStatusEnum.AUDITED);
        cb.setModel(model);
    }

    protected void bizOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        this.curCompany = (CompanyOrgUnitInfo)this.prmtCompany.getData();
        if (!this.isSetCustomCondition) {
            if (this.curCompany != null) {
                this.curCompanyCol = new OrgUnitCollection();
                this.curCompanyCol.add((OrgUnitInfo)this.curCompany);
                this.prmtStartMaterial.setMainBizOrgs(this.curCompanyCol, OrgType.Company);
                this.prmtEndMaterial.setMainBizOrgs(this.curCompanyCol, OrgType.Company);
            }
            this.prmtStorage.setValue(null);
            this.setStorageFilterF7();
            this.prmtStartWarehouse.setValue(null);
            this.prmtEndWarehouse.setValue(null);
        }
        if (this.curCompany != null) {
            this.loadAccountPeriod((CompanyOrgUnitInfo)this.prmtCompany.getData());
            this.getStorageUnitFilter(this.curCompany, this.prmtStorage);
            CalculateClientUtil.setWareHouseEntity(this.prmtCompany, null, this.prmtStartWarehouse, true);
            CalculateClientUtil.setWareHouseEntity(this.prmtCompany, null, this.prmtEndWarehouse, true);
            this.f7Manger.changeF7Context(this.curCompany.getId().toString());
            this.prmtStartMaterial.setEnabled(true);
            this.prmtEndMaterial.setEnabled(true);
        } else {
            this.prmtStartMaterial.setEnabled(false);
            this.prmtEndMaterial.setEnabled(false);
        }
    }

    private void getStorageUnitFilter(CompanyOrgUnitInfo companyInfo, KDBizPromptBox bizStorageOrgUnit) throws EASBizException, BOSException {
        if (companyInfo == null) {
            return;
        }
        CalculateClientUtil.setStorageOrgF7(companyInfo, bizStorageOrgUnit, null);
    }

    private void loadAccountPeriod(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        ICalRptUtilFacade iCalRptUtil;
        Object[] reslut;
        if (companyInfo != null) {
            PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            if (periodInfo == null) {
                this.prmtCompany.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTSTART);
            }
            if (curPeriodInfo == null) {
                this.prmtCompany.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTCURRENT);
            }
        }
        if ((reslut = (iCalRptUtil = CalRptUtilFacadeFactory.getRemoteInstance()).fetchInitFilterData(companyInfo.getId().toString())) != null) {
            CalculateUtil.AccountPeriodInfo actPeriodInfo = (CalculateUtil.AccountPeriodInfo)reslut[1];
            CalculateUtil.appliesPeriodControl(this.kdspStartYear, this.spdEndYear, this.kspdStartPeriod, this.spdEndPeriod, actPeriodInfo, true, false);
        }
    }

    public boolean verify() {
        int periodTo;
        int yearTo;
        int periodfrom;
        if (this.prmtCompany.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COMPANY_NOTNULL"));
            return false;
        }
        int yearFrom = this.kdspStartYear.getIntegerVlaue();
        if (100 * yearFrom + (periodfrom = this.kspdStartPeriod.getIntegerVlaue().intValue()) > 100 * (yearTo = this.spdEndYear.getIntegerVlaue().intValue()) + (periodTo = this.spdEndPeriod.getIntegerVlaue().intValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_BEGIN_NOTBIG_END"));
            return false;
        }
        return true;
    }

    public void clear() {
        super.clear();
        this.prmtStoreType.setValue(null);
        this.prmtStorage.setValue(null);
        this.prmtStartWarehouse.setValue(null);
        this.prmtEndWarehouse.setValue(null);
        this.prmtBillType.setValue(null);
        this.prmtStartTransacionType.setValue(null);
        this.prmtEndTransactionType.setValue(null);
        this.prmtStartMaterial.setValue(null);
        this.prmtEndMaterial.setValue(null);
        this.prmtStartTransacionType.setValue(null);
        this.prmtEndTransactionType.setValue(null);
        this.prmtCompany.setValue(null);
        this.prmtBizType.setValue(null);
        this.comboVouchered.setSelectedItem((Object)VoucheredEnum.Null);
        this.comboBillstatus.setSelectedItem((Object)BillBaseStatusEnum.AUDITED);
        this.comboCalculateType.setSelectedItem((Object)CalculateTypeEnum.NULL);
        this.cbQty.setSelectedIndex(0);
        this.cbAmount.setSelectedIndex(0);
        this.checkIsCalculate.setSelected(false);
        this.checkUnitActualcost.setSelected(true);
        try {
            this.curCompany = (CompanyOrgUnitInfo)this.getDefaultMainBizOrg();
            if (this.curCompany != null && this.curCompany.isIsBizUnit()) {
                this.prmtCompany.setValue((Object)this.curCompany);
            }
            this.isSetCustomCondition = false;
            this.bizOrgUnit_stateChanged(null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.isPresent.setSelectedIndex(0);
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        CompanyOrgUnitInfo currentMainOrg = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        try {
            if (currentMainOrg.isIsBizUnit() && SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)this.getMainBizOrgType(), (IObjectPK)new ObjectStringPK(currentMainOrg.getId().toString()), (String)this.getViewPermission())) {
                return currentMainOrg;
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return null;
    }

    private void setStorageFilterF7() {
        if (this.prmtCompany.getValue() != null) {
            OrgUnitCollection orgCollection = SCMClientUtils.getStorageUnitInfo((CompanyOrgUnitInfo)((CompanyOrgUnitInfo)this.prmtCompany.getValue()));
            try {
                this.prmtStorage.setEntityViewInfo(this.getOrgEntityViewInfo(orgCollection));
                this.prmtStorage.setCommitFormat("$number$");
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private EntityViewInfo getOrgEntityViewInfo(OrgUnitCollection collcetion) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < collcetion.size(); ++i) {
            if (collcetion.get(i).getId() == null) continue;
            stringBuffer.append(collcetion.get(i).getId().toString());
            stringBuffer.append(",");
        }
        String storageOrgUnitIDs = stringBuffer.toString();
        if (storageOrgUnitIDs.length() > 0) {
            storageOrgUnitIDs = storageOrgUnitIDs.substring(0, storageOrgUnitIDs.length() - 1);
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)storageOrgUnitIDs, CompareType.INCLUDE));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)"NOTEXISTID", CompareType.INCLUDE));
        }
        evi.setFilter(fi);
        return evi;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
    }

    private void addF7SelectorListener(KDBizPromptBox[] f7s) {
        for (int i = 0; i < f7s.length; ++i) {
            f7s[i].addSelectorListener(new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    if (ExceptionBillQueryConditionUI.this.getMainBizOrgF7() != null) {
                        return;
                    }
                    Object value = ExceptionBillQueryConditionUI.this.getMainBizOrgF7().getValue();
                    if (value == null || value instanceof Object[] && ((Object[])value).length == 0 || value instanceof Object[] && ((Object[])value)[0] == null) {
                        MsgBox.showInfo((String)SCMGroupClientUtils.getMainOrgNullMsg((OrgType)ExceptionBillQueryConditionUI.this.getMainBizOrgType()));
                        ExceptionBillQueryConditionUI.this.getMainBizOrgF7().requestFocus();
                        SysUtil.abort();
                    }
                }
            });
        }
    }

    protected void setNeedMainOrgF7s(KDBizPromptBox[] f7s) {
        this.addF7SelectorListener(f7s);
        this.f7Manger.setPrmtNeedOrgF7s(f7s);
    }

    private EntityViewInfo getDefaultBillTypeFilter() {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("102");
        hashSet.add("103");
        hashSet.add("104");
        hashSet.add("105");
        hashSet.add("106");
        hashSet.add("107");
        hashSet.add("108");
        hashSet.add("109");
        filter.getFilterItems().add(new FilterItemInfo("number", hashSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        return ev;
    }
}

