/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.ComponentProperty;
import com.kingdee.bos.appframework.databinding.DataComponentMap;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.DlgShowListener;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.report.CommRptBaseFactory;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CalculateFacadeFactory;
import com.kingdee.eas.scm.cal.CalculateReportFacadeFactory;
import com.kingdee.eas.scm.cal.CostUpdateMutexFacadeFactory;
import com.kingdee.eas.scm.cal.ExceptionBalanceReportFacadeFactory;
import com.kingdee.eas.scm.cal.ICostUpdateMutexFacade;
import com.kingdee.eas.scm.cal.InpWarehsSumCalculateCollection;
import com.kingdee.eas.scm.cal.InpWarehsSumCalculateInfo;
import com.kingdee.eas.scm.cal.client.AbstractInpWarehsSumReportUI;
import com.kingdee.eas.scm.cal.client.InpWarehsSumImportDateUI;
import com.kingdee.eas.scm.cal.client.InpWarehsSumReportFilterUI;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.client.SCMClientHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.helper.FormattedEditorFactory;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.AdvMsgBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.eas.util.client.MsgBoxStatisticsUtil;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class InpWarehsSumReportUI
extends AbstractInpWarehsSumReportUI {
    private static final long serialVersionUID = 8820154301833341027L;
    private CalculateParams calparams = new CalculateParams();
    private int amtPrecision = 2;
    private CompanyOrgUnitInfo mainBizorg = null;
    private String ACTUALBASEUNITCOST = "actualBaseUnitCost";
    private String BASEUNITQTY = "baseQty";
    private String ACTUALCOST = "actualCost";
    private static final String[] TOTALCOL = new String[]{"actualCost"};
    private static final String RESOURCE = "com.kingdee.eas.scm.cal.CalRptResource";

    public InpWarehsSumReportUI() throws Exception {
        this.tblMain.getSelectManager().setSelectMode(4);
        SCMClientHelper.registerTotalColumns((String[])TOTALCOL);
    }

    public void setTotalDataFill(int qtyPrecision) {
        int count = this.tblMain.getRowCount();
        IRow row = null;
        BigDecimal amountTotal = CalculateUtil.ZERO;
        BigDecimal qtyTotal = CalculateUtil.ZERO;
        for (int i = 0; i < count - 1; ++i) {
            row = this.tblMain.getRow(i);
            BigDecimal amount = (BigDecimal)row.getCell(this.ACTUALCOST).getValue();
            BigDecimal qty = (BigDecimal)row.getCell(this.BASEUNITQTY).getValue();
            if (null != amount) {
                amountTotal = amountTotal.add(amount);
            }
            if (null == qty) continue;
            qtyTotal = qtyTotal.add(qty);
        }
        IRow totalRow = this.tblMain.getRow(count - 1);
        if (null != totalRow) {
            totalRow.getCell(this.tblMain.getColumnIndex(this.ACTUALCOST)).setValue((Object)amountTotal);
            totalRow.getCell(this.tblMain.getColumnIndex(this.BASEUNITQTY)).setValue((Object)qtyTotal);
            totalRow.getCell(this.tblMain.getColumnIndex(this.BASEUNITQTY)).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)qtyPrecision));
            totalRow.getCell(this.tblMain.getColumnIndex(this.ACTUALCOST)).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.amtPrecision));
            totalRow.getCell(this.tblMain.getColumnIndex(this.ACTUALBASEUNITCOST)).setValue((Object)BigDecimal.ZERO);
        }
    }

    protected void init() throws Exception {
        super.init();
    }

    private void tbl_editStopped(KDTable tbl, int curCol) {
        int count = tbl.getRowCount();
        IRow row = null;
        int size = 0;
        BigDecimal amountTotal = CalculateUtil.ZERO;
        if ((curCol == tbl.getColumnIndex(this.ACTUALCOST) || curCol == tbl.getColumnIndex(this.ACTUALBASEUNITCOST)) && count >= 1) {
            for (int i = 0; i < count - 1; ++i) {
                row = tbl.getRow(i);
                BigDecimal amount = (BigDecimal)row.getCell(this.ACTUALCOST).getValue();
                if (null == row.getCell("material.number").getValue() || null == amount) continue;
                amountTotal = amountTotal.add(amount);
                size = i;
            }
            IRow totalRow = tbl.getRow(size + 1);
            totalRow.getCell(tbl.getColumnIndex(this.ACTUALCOST)).setValue((Object)amountTotal);
        }
    }

    private void calAmount(KDTable tbl, int curCol) {
        int count = tbl.getRowCount();
        IRow row = null;
        BigDecimal price = CalculateUtil.ZERO;
        BigDecimal amount = CalculateUtil.ZERO;
        BigDecimal qty = CalculateUtil.ZERO;
        if (curCol == tbl.getColumnIndex(this.ACTUALBASEUNITCOST)) {
            for (int i = 0; i < count - 1; ++i) {
                row = tbl.getRow(i);
                price = (BigDecimal)row.getCell(this.ACTUALBASEUNITCOST).getValue();
                amount = (BigDecimal)row.getCell(curCol).getValue();
                qty = (BigDecimal)row.getCell(this.BASEUNITQTY).getValue();
                int currencyPrecision = 2;
                currencyPrecision = new Integer(row.getCell("localCurrencyPrecision").getValue().toString());
                amount = price.multiply(qty).setScale(currencyPrecision, 4);
                row.getCell(tbl.getColumnIndex(this.ACTUALCOST)).setValue((Object)amount);
                row.getCell(tbl.getColumnIndex(this.ACTUALBASEUNITCOST)).setValue((Object)price);
            }
        } else if (curCol == tbl.getColumnIndex(this.ACTUALCOST)) {
            for (int i = 0; i < count - 1; ++i) {
                row = tbl.getRow(i);
                price = (BigDecimal)row.getCell(this.ACTUALBASEUNITCOST).getValue();
                amount = (BigDecimal)row.getCell(curCol).getValue();
                qty = (BigDecimal)row.getCell(this.BASEUNITQTY).getValue();
                int pricePrecision = 2;
                pricePrecision = new Integer(row.getCell("pricePrecision").getValue().toString());
                if (CalculateUtil.ZERO.compareTo(qty) != 0 && CalculateUtil.ZERO.compareTo(price = amount.divide(qty, pricePrecision, 4)) > 0) {
                    price = price.abs();
                    amount = amount.abs();
                    if (CalculateUtil.ZERO.compareTo(qty) > 0) {
                        amount = amount.abs().multiply(CalculateUtil.ONE_MINUS);
                    }
                    this.handUIException((Throwable)((Object)new CalculateException(CalculateException.MATERIAL_RECENT_UNIT_COST_LESS_ZERO2, new String[]{"", "", ""})));
                }
                row.getCell(tbl.getColumnIndex(this.ACTUALCOST)).setValue((Object)amount);
                row.getCell(tbl.getColumnIndex(this.ACTUALBASEUNITCOST)).setValue((Object)price);
            }
        }
        this.tbl_editStopped(this.tblMain, curCol);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtbillType.setEnabled(false);
        this.tblMain.getSelectManager().setSelectMode(4);
        this.tblMain.setAfterAction(new BeforeActionListener(){

            public void beforeAction(BeforeActionEvent e) {
                if (e.getType() == 5) {
                    int curCol = InpWarehsSumReportUI.this.tblMain.getSelectManager().getActiveColumnIndex();
                    InpWarehsSumReportUI.this.calAmount(InpWarehsSumReportUI.this.tblMain, curCol);
                }
            }
        });
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    this.tblMain_editStopped(e);
                }
                catch (Exception exc) {
                    InpWarehsSumReportUI.this.handUIException(exc);
                }
            }

            private void tblMain_editStopped(KDTEditEvent e) {
                int qtyCol;
                IRow curRow2 = InpWarehsSumReportUI.this.tblMain.getRow(e.getRowIndex());
                BigDecimal qty = (BigDecimal)curRow2.getCell(qtyCol = InpWarehsSumReportUI.this.tblMain.getColumnIndex(InpWarehsSumReportUI.this.BASEUNITQTY)).getValue();
                if (qty == null) {
                    qty = CalculateUtil.ZERO;
                }
                int curCol = e.getColIndex();
                BigDecimal price = CalculateUtil.ZERO;
                BigDecimal amount = CalculateUtil.ZERO;
                if (curCol == InpWarehsSumReportUI.this.tblMain.getColumnIndex(InpWarehsSumReportUI.this.ACTUALBASEUNITCOST)) {
                    int currencyPrecision = 2;
                    try {
                        currencyPrecision = new Integer(curRow2.getCell("localCurrencyPrecision").getValue().toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    price = (BigDecimal)curRow2.getCell(curCol).getValue();
                    if (price == null) {
                        price = CalculateUtil.ZERO;
                    }
                    amount = price.multiply(qty).setScale(currencyPrecision, 4);
                    curRow2.getCell(InpWarehsSumReportUI.this.tblMain.getColumnIndex(InpWarehsSumReportUI.this.ACTUALCOST)).setValue((Object)amount);
                    curRow2.getCell(InpWarehsSumReportUI.this.tblMain.getColumnIndex(InpWarehsSumReportUI.this.ACTUALBASEUNITCOST)).setValue((Object)price);
                } else if (curCol == InpWarehsSumReportUI.this.tblMain.getColumnIndex(InpWarehsSumReportUI.this.ACTUALCOST)) {
                    if (curRow2.getCell(curCol).getValue() instanceof BigDecimal) {
                        amount = (BigDecimal)curRow2.getCell(curCol).getValue();
                    } else {
                        amount = null == curRow2.getCell(curCol).getValue() ? CalculateUtil.ZERO : new BigDecimal(curRow2.getCell(curCol).getValue().toString());
                        amount = amount.setScale(InpWarehsSumReportUI.this.amtPrecision, 4);
                    }
                    if (amount == null) {
                        amount = CalculateUtil.ZERO;
                    }
                    int pricePrecision = 2;
                    try {
                        pricePrecision = new Integer(curRow2.getCell("pricePrecision").getValue().toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (CalculateUtil.ZERO.compareTo(qty) != 0 && CalculateUtil.ZERO.compareTo(price = amount.divide(qty, pricePrecision, 4)) > 0) {
                        price = price.abs();
                        amount = amount.abs();
                        if (CalculateUtil.ZERO.compareTo(qty) > 0) {
                            amount = amount.abs().multiply(CalculateUtil.ONE_MINUS);
                        }
                        InpWarehsSumReportUI.this.handUIException((Throwable)((Object)new CalculateException(CalculateException.MATERIAL_RECENT_UNIT_COST_LESS_ZERO2, new String[]{"", "", ""})));
                    }
                    curRow2.getCell(InpWarehsSumReportUI.this.tblMain.getColumnIndex(InpWarehsSumReportUI.this.ACTUALCOST)).setValue((Object)amount);
                    curRow2.getCell(InpWarehsSumReportUI.this.tblMain.getColumnIndex(InpWarehsSumReportUI.this.ACTUALBASEUNITCOST)).setValue((Object)price);
                }
                InpWarehsSumReportUI.this.tbl_editStopped(InpWarehsSumReportUI.this.tblMain, e.getColIndex());
            }
        });
        this.tblMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                this.tbl_afterDataFill(e);
            }

            public void tbl_afterDataFill(KDTDataRequestEvent e) {
                int from = e.getFirstRow();
                int last = e.getLastRow();
                int qtyPrecision = 1;
                for (int i = from; i <= last; ++i) {
                    Object scaleObj2;
                    Object scaleObj = InpWarehsSumReportUI.this.tblMain.getRow(i).getCell("qtyPrecision").getValue();
                    if (scaleObj != null && !StringUtils.isEmpty((String)scaleObj.toString())) {
                        int scale = Integer.parseInt(scaleObj.toString());
                        qtyPrecision = scale > qtyPrecision ? scale : qtyPrecision;
                        InpWarehsSumReportUI.this.tblMain.getRow(i).getCell(InpWarehsSumReportUI.this.BASEUNITQTY).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)scale));
                    }
                    if ((scaleObj2 = InpWarehsSumReportUI.this.tblMain.getRow(i).getCell("pricePrecision").getValue()) == null || StringUtils.isEmpty((String)scaleObj2.toString())) continue;
                    int scale = Integer.parseInt(scaleObj2.toString());
                    InpWarehsSumReportUI.this.tblMain.getRow(i).getCell(InpWarehsSumReportUI.this.ACTUALBASEUNITCOST).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)FormattedEditorFactory.getBigDecimalFormattedTextField((int)scale, (boolean)false)));
                    InpWarehsSumReportUI.this.tblMain.getRow(i).getCell(InpWarehsSumReportUI.this.ACTUALBASEUNITCOST).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)scale));
                    InpWarehsSumReportUI.this.tblMain.getRow(i).getCell(InpWarehsSumReportUI.this.ACTUALCOST).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)FormattedEditorFactory.getBigDecimalFormattedTextField((int)InpWarehsSumReportUI.this.amtPrecision, (boolean)true)));
                    InpWarehsSumReportUI.this.tblMain.getRow(i).getCell(InpWarehsSumReportUI.this.ACTUALCOST).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)InpWarehsSumReportUI.this.amtPrecision));
                }
                InpWarehsSumReportUI.this.setTotalDataFill(qtyPrecision);
            }
        });
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.tblMain.getDataRequestManager().setPageRowCount(30);
        this.bntCalculate.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        this.bntImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.kDMenuItem2.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        this.kDMenuItem1.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.enableExportExcel(this.tblMain);
    }

    private void initTable() throws EASBizException, BOSException {
        PeriodInfo queryPerinfo = (PeriodInfo)this.params.getObject("PERIOD_OBJ");
        ObjectUuidPK companyPk = new ObjectUuidPK(this.params.getString("COMPANY_ID"));
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (IObjectPK)companyPk);
        if (queryPerinfo.getNumber() < currentPeriodInfo.getNumber()) {
            this.actionCalculate.setEnabled(false);
            this.actionImport.setEnabled(false);
        } else {
            this.actionCalculate.setEnabled(true);
            this.actionImport.setEnabled(true);
        }
        int count = this.tblMain.getRowCount();
        if (count == -1) {
            count = this.tblMain.getBody().size();
        }
        if (count >= 1) {
            IRow totalRow = this.tblMain.getRow(count - 1);
            if (totalRow.getCell("recordID").getValue() == null) {
                totalRow.getStyleAttributes().setBackground(SCMClientHelper.KDTABLE_TOTAL_BG_COLOR);
                totalRow.getStyleAttributes().setLocked(true);
            }
            if (currentPeriodInfo != null && (queryPerinfo.getPeriodYear() < currentPeriodInfo.getPeriodYear() || queryPerinfo.getPeriodYear() == currentPeriodInfo.getPeriodYear() && queryPerinfo.getPeriodNumber() < currentPeriodInfo.getPeriodNumber())) {
                for (int i = 0; i < count; ++i) {
                    totalRow = this.tblMain.getRow(i);
                    totalRow.getStyleAttributes().setLocked(true);
                }
                this.bntCalculate.setEnabled(false);
            } else {
                this.bntCalculate.setEnabled(true);
            }
        }
    }

    @Override
    public void storeFields() {
        InpWarehsSumCalculateCollection detailListcoll = new InpWarehsSumCalculateCollection();
        this.tblMain.setUserObject((Object)detailListcoll);
        DataComponentMap componentMap = new DataComponentMap();
        com.kingdee.bos.appframework.databinding.Field field = new com.kingdee.bos.appframework.databinding.Field();
        field.setName("entry");
        field.setFieldClazz(InpWarehsSumCalculateInfo.class);
        ComponentProperty compProperty = new ComponentProperty();
        compProperty.setComponent((Component)this.tblMain);
        compProperty.setPropertyName("userObject");
        componentMap.register(field, compProperty);
        for (int i = 11; i < this.tblMain.getColumnCount(); ++i) {
            com.kingdee.bos.appframework.databinding.Field field2 = new com.kingdee.bos.appframework.databinding.Field();
            field2.setName("entry." + this.tblMain.getColumnKey(i));
            field2.setFieldClazz(String.class);
            if (i >= 16 && i <= 18) {
                field2.setFieldClazz(BigDecimal.class);
            }
            if (i >= 19 && i <= 21) {
                field2.setFieldClazz(Integer.class);
            }
            ComponentProperty compProperty2 = new ComponentProperty();
            compProperty2.setComponent((Component)this.tblMain);
            compProperty2.setPropertyName(this.tblMain.getColumnKey(i) + ".text");
            componentMap.register(field2, compProperty2);
        }
        PropertyChangeSupport support = null;
        com.kingdee.bos.appframework.databinding.Field detailField = null;
        String total2 = EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource.TOTALTITLE");
        if (this.tblMain.getRowCount() > 1) {
            String lastRowValue0 = (String)this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell(0).getValue();
            String lastRowValue7 = (String)this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell(7).getValue();
            if (this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell("recordID").getValue() == null) {
                this.tblMain.setRowCount(this.tblMain.getRowCount() - 1);
                BindingUtility.storeTableToData((KDTable)this.tblMain, detailField, (DataComponentMap)componentMap, support);
                this.tblMain.setRowCount(this.tblMain.getRowCount() + 1);
            }
        }
        this.calparams.setObject("ENTRYCOLL", (Object)detailListcoll);
    }

    private void validata() throws CalculateException {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            BigDecimal unitActual;
            if (this.tblMain.getRow(i).getCell(this.ACTUALBASEUNITCOST) == null || (unitActual = (BigDecimal)this.tblMain.getRow(i).getCell(this.ACTUALBASEUNITCOST).getValue()) == null || CalculateUtil.ZERO.compareTo(unitActual) <= 0) continue;
            throw new CalculateException(CalculateException.MATERIAL_RECENT_UNIT_COST_LESS_ZERO2, new String[]{"", "", ""});
        }
    }

    private void initReportData(CompanyOrgUnitInfo cou) {
        for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
            this.tblMain.getColumn(i).getStyleAttributes().setLocked(true);
        }
        this.tblMain.getColumn(this.ACTUALBASEUNITCOST).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(this.ACTUALCOST).getStyleAttributes().setLocked(false);
        if (cou == null) {
            return;
        }
        try {
            this.amtPrecision = CalculateUtil.getLocalCurrencyPrecision(null, cou);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        String[] filedsAmount = new String[]{this.ACTUALCOST};
        SCMClientUtils.changeTableColPrecision((int)this.amtPrecision, (KDTable)this.tblMain, (String[])filedsAmount, (boolean)true);
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return ExceptionBalanceReportFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected RptParams getParamsForInit() {
        RptParams initParam = new RptParams();
        return initParam;
    }

    public RptParams getQueryParams() {
        return this.params;
    }

    public String getQueryTempTable() {
        return this.getTempTable();
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return new InpWarehsSumReportFilterUI();
    }

    protected void query() {
        this.tblMain.removeRows();
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        try {
            this.mainBizorg = new CompanyOrgUnitInfo();
            this.mainBizorg.setId(BOSUuid.read((String)this.params.getString("COMPANY_ID")));
            this.initUIMainOrgContext(this.mainBizorg.getId().toString());
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            String tempTableName = this.getTempTable();
            String detailTempTableName = this.params.getString("DETAILTEMPTABLE");
            String finalTempTableName = this.params.getString("FINALTABLE");
            if (!"file".equals(this.params.getObject("file"))) {
                if (from == 0) {
                    RptParams rpt2 = CalculateReportFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).createTempTable(this.params);
                    tempTableName = rpt2.getString("TEMPTABLE");
                    detailTempTableName = rpt2.getString("DETAILTEMPTABLE");
                    finalTempTableName = rpt2.getString("FINALTABLE");
                    String billDetailRecordSQL = rpt2.getString("billDetailRecordSQL");
                    this.params.setString("billDetailRecordSQL", billDetailRecordSQL);
                    this.tblMain.setRowCount(rpt2.getInt("TOTAL_COUNT"));
                    this.params.setInt("TOTAL_COUNT", rpt2.getInt("TOTAL_COUNT"));
                }
            } else if (from == 0) {
                CalculateReportFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).updateImportPrice(this.params);
                this.tblMain.setRowCount(this.params.getInt("TOTAL_COUNT"));
            }
            this.params.setString("TEMPTABLE", tempTableName);
            this.params.setString("DETAILTEMPTABLE", detailTempTableName);
            this.params.setString("FINALTABLE", finalTempTableName);
            this.setTempTable(tempTableName);
            RptParams rpt = CalculateReportFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).query(this.params, from, len);
            if (rpt != null) {
                RptRowSet rs;
                this.txtCompanyName.setText(rpt.getString("COMPANY_NAME"));
                StringBuffer temp = new StringBuffer();
                if (rpt.getString("MATERIAL_FROM") != null && rpt.getString("MATERIAL_FROM").length() != 0) {
                    temp.append(rpt.getString("MATERIAL_FROM"));
                    if (rpt.getString("MATERIAL_TO") != null && rpt.getString("MATERIAL_TO").length() != 0) {
                        temp.append(" -- ");
                        temp.append(rpt.getString("MATERIAL_TO"));
                    }
                }
                this.txtMaterial.setText(temp.toString());
                if (rpt.getObject("PERIOD_OBJ") != null) {
                    PeriodInfo periodInfo = (PeriodInfo)rpt.getObject("PERIOD_OBJ");
                    this.txtPeriod.setText(periodInfo.getPeriodYear() + "." + periodInfo.getPeriodNumber());
                }
                if (rpt.getObject("BILLTYPE_INFO") != null) {
                    this.prmtbillType.setValue(rpt.getObject("BILLTYPE_INFO"));
                }
                if ((rs = (RptRowSet)rpt.getObject("rowset")).getRowCount() > 0) {
                    KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.tblMain);
                    this.initReportData(this.mainBizorg);
                }
                for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
                    this.tblMain.getColumn(i).getStyleAttributes().setLocked(true);
                }
                this.tblMain.getColumn(this.ACTUALBASEUNITCOST).getStyleAttributes().setLocked(false);
                this.tblMain.getColumn(this.ACTUALCOST).getStyleAttributes().setLocked(false);
                if (!rpt.getBoolean("ckBxMShortName")) {
                    this.tblMain.getColumn("material.shortName").getStyleAttributes().setHided(true);
                } else {
                    this.tblMain.getColumn("material.shortName").getStyleAttributes().setHided(false);
                }
                if (2 == rpt.getInt("SUMCONDITION")) {
                    this.tblMain.getColumn("storageOrgUnit").setWidth(150);
                    this.tblMain.getColumn("storageOrgUnit.name").setWidth(150);
                    this.tblMain.getColumn("warehouse.name").setWidth(150);
                    this.tblMain.getColumn("DeptNumber").setWidth(0);
                    this.tblMain.getColumn("DeptName").setWidth(0);
                    this.tblMain.getColumn("CostCenterNumber").setWidth(0);
                    this.tblMain.getColumn("CostCenterName").setWidth(0);
                } else if (1 == rpt.getInt("SUMCONDITION")) {
                    this.tblMain.getColumn("storageOrgUnit").setWidth(150);
                    this.tblMain.getColumn("storageOrgUnit.name").setWidth(150);
                    this.tblMain.getColumn("warehouse.name").setWidth(0);
                    this.tblMain.getColumn("DeptNumber").setWidth(0);
                    this.tblMain.getColumn("DeptName").setWidth(0);
                    this.tblMain.getColumn("CostCenterNumber").setWidth(0);
                    this.tblMain.getColumn("CostCenterName").setWidth(0);
                } else if (3 == rpt.getInt("SUMCONDITION")) {
                    this.tblMain.getColumn("DeptNumber").setWidth(150);
                    this.tblMain.getColumn("DeptName").setWidth(150);
                    this.tblMain.getColumn("storageOrgUnit").setWidth(0);
                    this.tblMain.getColumn("storageOrgUnit.name").setWidth(0);
                    this.tblMain.getColumn("warehouse.name").setWidth(0);
                    this.tblMain.getColumn("CostCenterNumber").setWidth(0);
                    this.tblMain.getColumn("CostCenterName").setWidth(0);
                } else if (4 == rpt.getInt("SUMCONDITION")) {
                    this.tblMain.getColumn("CostCenterNumber").setWidth(150);
                    this.tblMain.getColumn("CostCenterName").setWidth(150);
                    this.tblMain.getColumn("storageOrgUnit").setWidth(0);
                    this.tblMain.getColumn("storageOrgUnit.name").setWidth(0);
                    this.tblMain.getColumn("warehouse.name").setWidth(0);
                    this.tblMain.getColumn("DeptNumber").setWidth(0);
                    this.tblMain.getColumn("DeptName").setWidth(0);
                } else {
                    this.tblMain.getColumn("storageOrgUnit").setWidth(0);
                    this.tblMain.getColumn("storageOrgUnit.name").setWidth(0);
                    this.tblMain.getColumn("warehouse.name").setWidth(0);
                    this.tblMain.getColumn("DeptNumber").setWidth(0);
                    this.tblMain.getColumn("DeptName").setWidth(0);
                    this.tblMain.getColumn("CostCenterNumber").setWidth(0);
                    this.tblMain.getColumn("CostCenterName").setWidth(0);
                }
                if (rpt.getObject("EXCEPTION") != null) {
                    this.setMessageText(((CalculateException)((Object)rpt.getObject("EXCEPTION"))).getMessage());
                    this.setIsShowTextOnly(false);
                    this.showMessage();
                }
            }
            this.initTable();
        }
        catch (Exception ex) {
            this.tblMain.setRowCount(0);
            this.handleException(ex);
        }
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        String res = RESOURCE;
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)res, (String)"FICU")).append(":&[Company]").append("&|");
        sb.append(EASResource.getString((String)res, (String)"PERIOD")).append(":&[PERIOD]").append("&|");
        sb.append(" &|");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Company", this.txtCompanyName.getText());
        map.put("PERIOD", this.txtPeriod.getText());
        return map;
    }

    @Override
    public void actionCalculate_actionPerformed(ActionEvent e) throws Exception {
        String info = EASResource.getString((String)RESOURCE, (String)"PURIN_INFO");
        if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(this.params.getString("BILLTYPE_ID"))) {
            MsgBoxStatisticsUtil.send(null, (String)info, (int)5);
            Method method = AdvMsgBox.class.getDeclaredMethod("setDefaultFocus", Component.class);
            method.setAccessible(true);
            Field declaredField = AdvMsgBox.class.getDeclaredField("btnCancel");
            declaredField.setAccessible(true);
            AdvMsgBox msgBox = AdvMsgBox.createAdvMsgBox(null, (String)EASResource.getString((String)"promotInfoBox"), (String)info, null, (int)3, (int)2);
            DlgShowListener listener = new DlgShowListener((Component)msgBox);
            msgBox.addWindowListener((WindowListener)listener);
            method.invoke((Object)msgBox, declaredField.get(msgBox));
            msgBox.show();
            if (msgBox.getResult() == 2) {
                SysUtil.abort();
            }
        }
        super.actionCalculate_actionPerformed(e);
        String companyId = this.params.getString("COMPANY_ID");
        this.calparams = CalculateParams.parseFrom((Map)this.params.toMap());
        this.calparams.setString("COMPANY_ID", companyId);
        this.calparams.setInt("SUMCONDITION", this.params.getInt("SUMCONDITION"));
        this.calparams.setString("TEMPTABLE", this.params.getString("TEMPTABLE"));
        this.calparams.setString("DETAILTEMPTABLE", this.params.getString("DETAILTEMPTABLE"));
        this.calparams.setString("CALTYPE", String.valueOf(this.params.getInt("SUMCONDITION")));
        this.calparams.remove("rowset");
        this.validata();
        this.storeFields();
        ICostUpdateMutexFacade iCostUpdateMutex = CostUpdateMutexFacadeFactory.getRemoteInstance();
        iCostUpdateMutex.checkCostUpdateMutex(companyId, "inwarehsSumCal");
        iCostUpdateMutex.addOperateMutex(companyId, "inwarehsSumCal");
        CalculateParams result = CalculateFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).updateInpWarehsCost(this.calparams);
        if (result.getString("ErrorMsgList") != null && result.getString("ErrorMsgList").length() > 0) {
            MsgBox.showWarning((String)result.getString("ErrorMsgList"));
        }
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"ShutAccountComplete"));
        boolean oldbln = this.isShowTextOnly();
        this.setIsShowTextOnly(false);
        this.showMessage();
        if (oldbln) {
            this.setIsShowTextOnly(oldbln);
        }
        this.params.setObject("PRICE_ENUM", null);
        this.params.setObject("file", null);
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        if (SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof KDFrame) {
            try {
                UIContext uiContext = new UIContext((Object)this);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InpWarehsSumImportDateUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
                ((InpWarehsSumImportDateUI)uiWindow.getUIObject()).setInpWarehsSumParentUI(this);
                uiWindow.show();
            }
            catch (UIException e1) {
                this.handUIException(e1);
            }
        }
        if (this.params.getBoolean("import")) {
            this.query();
        }
    }

    private RptRowSet parse(RptRowSet rs) {
        int calType = this.params.getInt("SUMCONDITION");
        String total1 = 0 != calType ? EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource.TOTALTITLE") : null;
        String total2 = 0 == calType ? EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource.TOTALTITLE") : null;
        Object[] objArray = new Object[]{total1, null, null, null, null, null, null, total2, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
        if (3 == calType) {
            objArray[3] = total1;
            objArray[7] = null;
        }
        if (4 == calType) {
            objArray[5] = total1;
            objArray[7] = null;
        }
        rs.addRow(objArray);
        return rs;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.params.setObject("PRICE_ENUM", null);
        this.query();
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        if (this.params != null) {
            this.params.setObject("file", null);
        }
        return super.showQueryDialog(useDefaultSolution);
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = new RequestContext();
            this.prepareHandlerParam(request);
            request.setClassName(this.getUIHandlerClassName());
            handler.setRequestContext((Serializable)request);
        }
        return handler;
    }

    private void prepareHandlerParam(RequestContext request) {
        request.put("_COMPANYID", this.params == null ? null : this.params.getString("COMPANY_ID"));
    }

    protected void disposeUIWindow() {
        if (this.params != null && this.params.getString("DETAILTEMPTABLE") != null) {
            try {
                CommRptBaseFactory.getRemoteInstance().dropPoolTempTable(this.params.getString("DETAILTEMPTABLE"));
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        super.disposeUIWindow();
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.tblMain.getEditHelper().copy(2);
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.tblMain.getEditHelper().paste(2);
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }
}

