/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.ICreateJobFacade;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.common.perf.client.JobMonitorManager;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUI;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUISelectorAdaptor;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalRptUtilFacadeFactory;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.ICalRptUtilFacade;
import com.kingdee.eas.scm.cal.client.AbstractInvBalanceRefrehUI;
import com.kingdee.eas.scm.cal.client.CloseAccountClientUI;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.constants.QueryInfoConstants;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class InvBalanceRefrehUI
extends AbstractInvBalanceRefrehUI
implements ChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(InvBalanceRefrehUI.class);
    private static final String RESOURCE = "com.kingdee.eas.scm.cal.ReCalBalanceResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public static void show(CloseAccountClientUI ui) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InvBalanceRefrehUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionStart_actionPerformed(ActionEvent e) throws Exception {
        this.beforecheck();
        Locale locale = SysContext.getSysContext().getLocale();
        HashMap params = this.buidParam();
        Object[] jobParams = new Object[]{this.prmtCompany.getValue(), params, locale, SysContext.getSysContext().getCurrentUserInfo(), this.prmtCompany.getValue(), ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getCU()};
        String reCalBalanceInfo = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"ReCalBalanceInfo"), ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getNumber(), ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getName(), this.kDSpFromYear.getValue().toString(), this.kDSpFromPeriod.getValue(), this.kDSpToYear.getValue().toString(), this.kDSpToPeriod.getValue());
        JobConfig jobCfg = this.creteJobCfg((CompanyOrgUnitInfo)this.prmtCompany.getValue(), reCalBalanceInfo, "SCM_RECAL_INVBAL", "closeaccount", "SCM_RECAL_INVBAL");
        JobParam jobParam = new JobParam((Object)jobParams);
        jobParam.setLocale(locale);
        ICreateJobFacade iCreateJobFacade = CreateJobFacadeFactory.getRemoteInstance();
        Map result = iCreateJobFacade.executeJob(jobParam, jobCfg);
        if (result != null && result.get("jobInstExtId") != null) {
            JobMonitorManager.getInstance().addMonitorInfo((String)result.get("jobInstExtId"), jobCfg.getTitle());
        }
        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"ReCalTaskInfo"));
    }

    private HashMap buidParam() {
        Object[] materials;
        Object[] warehouses;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("companyInfo", this.prmtCompany.getValue());
        Object[] storages = (Object[])this.prmtStorage.getValue();
        if (storages != null && storages.length > 0) {
            HashSet<String> storageIDSet = new HashSet<String>();
            HashSet<String> storageNumberSet = new HashSet<String>();
            int size = storages.length;
            for (int i = 0; i < size; ++i) {
                StorageOrgUnitInfo sto = (StorageOrgUnitInfo)storages[i];
                if (sto == null) continue;
                storageIDSet.add(sto.getId().toString());
                storageNumberSet.add(sto.getNumber());
            }
            if (storageIDSet.size() > 0) {
                params.put("storageIDSet", storageIDSet);
                params.put("storageNumberSet", storageNumberSet);
            }
        }
        if ((warehouses = (Object[])this.prmtWarehouse.getValue()) != null && warehouses.length > 0) {
            HashSet<String> warehouseIDSet = new HashSet<String>();
            HashSet<String> warehouseNumberSet = new HashSet<String>();
            int size = warehouses.length;
            for (int i = 0; i < size; ++i) {
                WarehouseInfo whinfo = (WarehouseInfo)warehouses[i];
                if (whinfo == null) continue;
                warehouseIDSet.add(whinfo.getId().toString());
                warehouseNumberSet.add(whinfo.getNumber());
            }
            if (warehouseIDSet.size() > 0) {
                params.put("warehouseIDSet", warehouseIDSet);
                params.put("warehouseNumberSet", warehouseNumberSet);
            }
        }
        if ((materials = (Object[])this.prmtMaterials.getValue()) != null && materials.length > 0) {
            HashSet<String> materialIDSet = new HashSet<String>();
            HashSet<String> materialNumberSet = new HashSet<String>();
            int size = materials.length;
            for (int i = 0; i < size; ++i) {
                MaterialInfo mat = (MaterialInfo)materials[i];
                if (mat == null) continue;
                materialIDSet.add(mat.getId().toString());
                materialNumberSet.add(mat.getNumber());
            }
            if (materialIDSet.size() > 0) {
                params.put("materialIDSet", materialIDSet);
                params.put("materialNumberSet", materialNumberSet);
            }
        }
        params.put("yearFrom", (Integer)this.kDSpFromYear.getValue());
        params.put("periodFrom", (Integer)this.kDSpFromPeriod.getValue());
        params.put("yearTo", (Integer)this.kDSpToYear.getValue());
        params.put("periodTo", (Integer)this.kDSpToPeriod.getValue());
        return params;
    }

    private void beforecheck() {
        if (this.prmtCompany.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"companyNull"));
            return;
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtCompany.addChangeListener((ChangeListener)this);
        this.prmtStorage.addChangeListener((ChangeListener)this);
        this.prmtStorage.setEnabledMultiSelection(true);
        this.prmtWarehouse.setEnabledMultiSelection(true);
        this.prmtMaterials.setEnabledMultiSelection(true);
        SCMClientUtils.setMainBizOrgCompF7forSealUp((KDBizPromptBox)this.prmtCompany, (OrgType)OrgType.Company, null);
        SCMClientUtils.setF7OrgUnitBizUnit((KDBizPromptBox)this.prmtCompany);
        this.setMaterialF7(this.prmtMaterials);
        this.prmtWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQueryForCal");
        SCMClientUtils.setSotrageOrgF7((KDBizPromptBox)this.prmtStorage);
        CalculateClientUtil.setF7FilterUIProperties(this.prmtCompany, true);
        CalculateClientUtil.setF7FilterUIProperties(this.prmtStorage, false);
        CalculateClientUtil.setF7FilterUIProperties(this.prmtWarehouse, false);
        this.prmtStorage.setLabelVisible(false);
        this.prmtWarehouse.setLabelVisible(false);
        CalculateClientUtil.InitCompanyF7(this.prmtCompany, "closeaccount");
        this.kDBtRefresh.setEnabled(true);
    }

    private void clearStorageOrg(boolean b) {
        this.prmtStorage.setValue(null);
        this.prmtStorage.setEnabled(b);
    }

    private void clearWareHouse(boolean b) {
        this.prmtWarehouse.setValue(null);
        this.prmtWarehouse.setEnabled(b);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (((KDBizPromptBox)e.getSource()).equals(this.prmtCompany)) {
            if (this.prmtCompany.getValue() != null) {
                try {
                    CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
                    this.loadAccountPeriod(companyInfo);
                    this.prmtMaterials.setCurrentMainBizOrgUnit((OrgUnitInfo)companyInfo, OrgType.Company);
                }
                catch (Exception ex) {
                    this.handUIException(ex);
                }
                this.clearStorageOrg(true);
                CalculateClientUtil.setStorageOrgF7((CompanyOrgUnitInfo)this.prmtCompany.getValue(), this.prmtStorage, null);
                this.clearWareHouse(false);
            } else {
                this.clearWareHouse(false);
                this.clearStorageOrg(false);
            }
        } else if (((KDBizPromptBox)e.getSource()).equals(this.prmtStorage)) {
            if (this.prmtStorage.getValue() != null) {
                try {
                    Object[] obj = null;
                    obj = (Object[])this.prmtStorage.getValue();
                    HashSet<String> oriSet = new HashSet<String>();
                    if (obj[0] != null) {
                        int size = obj.length;
                        for (int j = 0; j < size; ++j) {
                            StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)obj[j];
                            oriSet.add(storageOrgUnitInfo.getId().toString());
                        }
                    }
                    this.prmtWarehouse.setEnabled(true);
                    this.prmtWarehouse.setValue(null);
                    this.prmtWarehouse.setEntityViewInfo(InvClientUtils.getWarehouseFilter(oriSet, (int)1));
                }
                catch (Exception e1) {
                    this.handUIException(e1);
                }
            } else {
                this.clearWareHouse(false);
            }
        }
    }

    private void setMaterialF7(KDBizPromptBox kDBizPromptBoxMaterial) {
        F7MaterialMultiUISelectorAdaptor selectorLisenterMaterial = null;
        try {
            selectorLisenterMaterial = new F7MaterialMultiUISelectorAdaptor((KDPromptBox)kDBizPromptBoxMaterial, (Component)new F7MaterialMultiUI(), (Object)this, "C79FC042", QueryInfoConstants.getMaterialQueryInfo((OrgType)OrgType.Company), "materialGroup.id", QueryInfoConstants.getMaterialNoGroupQueryInfo((OrgType)OrgType.Company), false);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        kDBizPromptBoxMaterial.setDisplayFormat("$number$");
        kDBizPromptBoxMaterial.setEditFormat("$number$");
        kDBizPromptBoxMaterial.setCommitFormat("$number$;$helpCode$");
        selectorLisenterMaterial.setIsMultiSelect(true);
        selectorLisenterMaterial.setQueryProperty("helpCode", "or");
        kDBizPromptBoxMaterial.setSelector((KDPromptSelector)selectorLisenterMaterial);
        kDBizPromptBoxMaterial.addSelectorListener((SelectorListener)selectorLisenterMaterial);
    }

    private void loadAccountPeriod(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        if (companyInfo != null) {
            PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            if (periodInfo == null) {
                this.prmtCompany.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTSTART);
            }
            if (curPeriodInfo == null) {
                this.prmtCompany.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTCURRENT);
            }
            ICalRptUtilFacade iCalRptUtil = CalRptUtilFacadeFactory.getRemoteInstance();
            Object[] reslut = iCalRptUtil.fetchInitFilterData(companyInfo.getId().toString());
            if (reslut != null) {
                CalculateUtil.AccountPeriodInfo actPeriodInfo = (CalculateUtil.AccountPeriodInfo)reslut[1];
                CalculateUtil.appliesPeriodControl(this.kDSpFromYear, this.kDSpToYear, this.kDSpFromPeriod, this.kDSpToPeriod, actPeriodInfo, true, true);
            }
        }
    }

    private JobConfig creteJobCfg(CompanyOrgUnitInfo company, String title, String taskType, String Mutex, String number) throws EASBizException, BOSException {
        JobConfig jobCfg = new JobConfig();
        jobCfg.setTitle(title);
        jobCfg.setTaskType(company.getNumber() + taskType);
        jobCfg.setDescription(title);
        jobCfg.setNeedCheckTaskType(true);
        jobCfg.setMutex(Mutex);
        jobCfg.setNumber(number);
        return jobCfg;
    }

    @Override
    public void actionUpdate_actionPerformed(ActionEvent e) throws Exception {
        this.beforecheck();
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        int isContinue = MsgBox.showConfirm2((String)MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"updateConfirm"), companyInfo.getNumber(), companyInfo.getName(), curPeriodInfo.getPeriodYear() + "", curPeriodInfo.getPeriodNumber()));
        if (2 == isContinue) {
            return;
        }
        Locale locale = SysContext.getSysContext().getLocale();
        HashMap params = this.buidParam();
        params.put("companyInfo", companyInfo);
        params.put("curPeriodInfo", curPeriodInfo);
        Object[] jobParams = new Object[]{companyInfo, params, locale, SysContext.getSysContext().getCurrentUserInfo(), companyInfo, companyInfo.getCU()};
        String updateBalanceInfo = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"UpdateBalanceInfo"), companyInfo.getNumber(), companyInfo.getName());
        JobConfig jobCfg = this.creteJobCfg(companyInfo, updateBalanceInfo, "SCM_UPDATE_INVBAL", "closeaccount", "SCM_UPDATE_INVBAL");
        JobParam jobParam = new JobParam((Object)jobParams);
        jobParam.setLocale(locale);
        ICreateJobFacade iCreateJobFacade = CreateJobFacadeFactory.getRemoteInstance();
        Map result = iCreateJobFacade.executeJob(jobParam, jobCfg);
        if (result != null && result.get("jobInstExtId") != null) {
            JobMonitorManager.getInstance().addMonitorInfo((String)result.get("jobInstExtId"), jobCfg.getTitle());
        }
        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"UpdateTaskInfo"));
    }
}

