/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.InvCkAccountDetailFacadeFactory;
import com.kingdee.eas.scm.cal.client.AbstractInvCkAccountDetailUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class InvCkAccountDetailUI
extends AbstractInvCkAccountDetailUI {
    private static final long serialVersionUID = 1L;
    private int amtPrecision = 2;
    private final int IN = 0;
    private final int OUT = 1;
    private final int BILL = 0;
    private final int VOUCHER = 1;
    private int currRow = -1;
    private int currCol = -1;
    private static final String RESOURCE = "com.kingdee.eas.scm.cal.CALAutoGenerateResource";
    public static Map BILLTYPE_TO_EDITUI_MAP = new HashMap(10);

    public InvCkAccountDetailUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        this.tblMain.getActionMap().remove("Delete");
        this.tblMain.getDataRequestManager().addDataRequestListener(new KDTDataRequestListener(){

            public void tableDataRequest(KDTDataRequestEvent e) {
                InvCkAccountDetailUI.this.reportDataRequest(e);
            }
        });
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                InvCkAccountDetailUI.this.tbl_afterDataFill(e);
            }
        });
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.tblMain.getDataRequestManager().setPageRowCount(1000);
        this.setMergeColumn();
        this.initFootManager();
        this.enableExportExcel(this.tblMain);
        this.tblMain.getDataRequestManager().setExportMemoryCallback(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setAmountFieldFormat();
        this.actionRefresh.setVisible(false);
        this.btnRefresh.setVisible(false);
        this.menuItemRefresh.setVisible(false);
    }

    protected void init() throws Exception {
        super.init();
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.params.getObject("bizCompnayOrg");
        if (companyOrgUnitInfo.getBaseCurrency() != null) {
            CurrencyInfo baseCurrInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getBaseCurrency().getId()));
            this.amtPrecision = baseCurrInfo.getPrecision();
        }
        this.initUIMainOrgContext(companyOrgUnitInfo.getId().toString());
    }

    public void onShow() throws Exception {
        super.onShow();
        this.menuItemBill.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.params.getObject("bizCompnayOrg");
        int year = this.params.getInt("Year");
        int period = this.params.getInt("Period");
        String actNumber = this.params.getString("ActNumber");
        String actName = this.params.getString("ActName");
        int direction = this.params.getInt("Direction");
        this.txtCompany.setText(companyOrgUnitInfo.getNumber());
        this.txtCompName.setText(companyOrgUnitInfo.getName());
        this.txtAccount.setText(actNumber);
        this.txtAcctName.setText(actName);
        this.txtPeriod.setText(year + "." + period);
        if (direction == 0) {
            this.txtDirection.setText(EASResource.getString((String)RESOURCE, (String)"267_CurPeriodIn"));
        } else if (direction == 1) {
            this.txtDirection.setText(EASResource.getString((String)RESOURCE, (String)"268_CurPeriodOut"));
        }
    }

    private void initFootManager() {
        IRow footRow = null;
        KDTFootManager footRowManager = this.tblMain.getFootManager();
        if (footRowManager == null) {
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            footRowManager = new KDTFootManager(this.tblMain);
            footRowManager.addFootView();
            this.tblMain.setFootManager(footRowManager);
            footRow = footRowManager.addFootRow(0);
            footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            this.tblMain.getIndexColumn().setWidthAdjustMode((short)1);
            this.tblMain.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, total);
        }
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"BillTypeName", "BillVoucherNumber", "VoucherNumber", "VoucherAmount", "DiffAmount", "Reason"};
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                InvCkAccountDetailUI.this.currRow = e.getRowIndex();
                InvCkAccountDetailUI.this.currCol = e.getColIndex();
                if (e.getClickCount() == 2) {
                    InvCkAccountDetailUI.this.tbl_tableClicked(e);
                }
            }
        });
    }

    protected void tbl_tableClicked(KDTMouseEvent e) {
        ActionEvent evt = new ActionEvent(this.btnBillView, 0, "Double Clicked");
        ItemAction actView = this.getActionFromActionEvent(evt);
        actView.actionPerformed(evt);
    }

    public void tbl_afterDataFill(KDTDataRequestEvent e) {
        int from = e.getFirstRow();
        int last = e.getLastRow();
        IRow row = null;
        BigDecimal diffAmount = null;
        for (int i = from; i <= last; ++i) {
            row = this.tblMain.getRow(i);
            if (row == null) {
                return;
            }
            diffAmount = (BigDecimal)row.getCell("DiffAmount").getValue();
            if (diffAmount == null || BigDecimal.ZERO.compareTo(diffAmount) == 0) continue;
            row.getStyleAttributes().setBackground(new Color(255, 255, 153));
        }
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected void reportDataRequest(KDTDataRequestEvent e) {
        int from = e.getFirstRow();
        int len = e.getLastRow() - from + 1;
        RptParams result = null;
        RptParams rptParam = new RptParams();
        try {
            if (from == 0 && this.getTempTable() == null) {
                result = this.getRemoteInstance().createTempTable(this.params);
                this.setTempTable(result.getString("reportDataTable"));
                this.tblMain.setRowCount(result.getInt("recordCount"));
                this.appendFootRow(result);
            }
            rptParam.clear();
            rptParam.setString("reportDataTable", this.getTempTable());
            rptParam.setBoolean("isShowException", this.params.getBoolean("isShowException"));
            result = this.getRemoteInstance().query(rptParam, from, len);
            RptRowSet rs = (RptRowSet)result.getObject("rowset");
            KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.tblMain);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void setAmountFieldFormat() {
        String fmtStr = SCMClientUtils.getFormatPattern((int)this.amtPrecision);
        this.tblMain.getColumn("BillAmount").getStyleAttributes().setNumberFormat(fmtStr);
        this.tblMain.getColumn("VoucherAmount").getStyleAttributes().setNumberFormat(fmtStr);
        this.tblMain.getColumn("DiffAmount").getStyleAttributes().setNumberFormat(fmtStr);
    }

    private int getSelectType(int colIndex) {
        int result = -1;
        if (this.currCol == -1) {
            return -1;
        }
        if (this.tblMain.getColumnIndex("BillNumber") == colIndex || this.tblMain.getColumnIndex("BillTypeName") == colIndex || this.tblMain.getColumnIndex("BillVoucherNumber") == colIndex || this.tblMain.getColumnIndex("BillAmount") == colIndex) {
            result = 0;
        } else if (this.tblMain.getColumnIndex("VoucherNumber") == colIndex || this.tblMain.getColumnIndex("VoucherAmount") == colIndex) {
            result = 1;
        }
        return result;
    }

    private String getEditUIName(String billTypeID) {
        String editUIName = "";
        editUIName = "VOUCHER".equalsIgnoreCase(billTypeID) ? "com.kingdee.eas.fi.gl.client.VoucherEditUI" : (String)BILLTYPE_TO_EDITUI_MAP.get(billTypeID);
        return editUIName;
    }

    @Override
    public void actionBillView_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        int type = this.getSelectType(this.currCol);
        if (type == -1) {
            return;
        }
        String id = null;
        String billType = null;
        if (type == 0) {
            id = (String)this.tblMain.getRow(this.currRow).getCell("BillID").getValue();
            billType = (String)this.tblMain.getRow(this.currRow).getCell("BillTypeID").getValue();
        } else {
            id = (String)this.tblMain.getRow(this.currRow).getCell("VoucherID").getValue();
            billType = "VOUCHER";
        }
        if (id == null) {
            return;
        }
        uiContext.put((Object)"ID", (Object)id);
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.params.getObject("bizCompnayOrg");
        uiContext.put((Object)"companyId", (Object)companyOrgUnitInfo.getId().toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getEditUIName(billType), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionShowModel_actionPerformed(ActionEvent e) throws Exception {
        boolean isShowException = this.params.getBoolean("isShowException");
        if (isShowException) {
            this.btnShowModel.setText(EASResource.getString((String)RESOURCE, (String)"269_ShowException"));
            this.params.setBoolean("isShowException", false);
        } else {
            this.btnShowModel.setText(EASResource.getString((String)RESOURCE, (String)"270_ShowAll"));
            this.params.setBoolean("isShowException", true);
        }
        this.query();
    }

    protected RptParams getParamsForInit() {
        RptParams initParam = new RptParams();
        return initParam;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return null;
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return InvCkAccountDetailFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.getDetailTable();
    }

    protected void query() {
        this.tblMain.repaint();
        this.tblMain.removeRows();
    }

    protected void appendFootRow(RptParams rptParam) {
        IRow footRow = null;
        KDTFootManager footRowManager = this.tblMain.getFootManager();
        if (footRowManager == null) {
            return;
        }
        footRow = footRowManager.getFootRow(0);
        String fmtStr = SCMClientUtils.getFormatPattern((int)this.amtPrecision);
        this.AddFootCell(footRow, "BillAmount", rptParam.getBigDecimal("totalBillAmount"), fmtStr);
        this.AddFootCell(footRow, "VoucherAmount", rptParam.getBigDecimal("totalVoucherAmount"), fmtStr);
        this.AddFootCell(footRow, "DiffAmount", rptParam.getBigDecimal("totalDiffAmount"), fmtStr);
        footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
    }

    private void AddFootCell(IRow footRow, String fieldName, BigDecimal value, String fmtStr) {
        ICell cell = footRow.getCell(fieldName);
        cell.getStyleAttributes().setNumberFormat(fmtStr);
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
        cell.getStyleAttributes().setFontColor(Color.BLACK);
        cell.setValue((Object)value);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.params.getObject("bizCompnayOrg");
        int year = this.params.getInt("Year");
        int period = this.params.getInt("Period");
        String actNumber = this.params.getString("ActNumber");
        String actName = this.params.getString("ActName");
        int direction = this.params.getInt("Direction");
        map.put("CompanyNumber", companyOrgUnitInfo.getName());
        map.put("ActNumber", actNumber);
        map.put("Period", year + "." + period);
        map.put("CompanyName", companyOrgUnitInfo.getNumber());
        map.put("ActName", actName);
        if (direction == 0) {
            map.put("Direction", EASResource.getString((String)RESOURCE, (String)"267_CurPeriodIn"));
        } else if (direction == 1) {
            map.put("Direction", EASResource.getString((String)RESOURCE, (String)"268_CurPeriodOut"));
        }
        return map;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        header.addRow(EASResource.getString((String)RESOURCE, (String)"271_InvCkAccountDetailUI"), sa);
        header.addRow(EASResource.getString((String)RESOURCE, (String)"272_InvCkAccountDetailUI"), sa);
    }

    static {
        BILLTYPE_TO_EDITUI_MAP.put("50957179-0105-1000-e000-015fc0a812fd463ED552", "com.kingdee.eas.scm.im.inv.client.PurInWarehsBillEditUI");
        BILLTYPE_TO_EDITUI_MAP.put("50957179-0105-1000-e000-0167c0a812fd463ED552", "com.kingdee.eas.scm.im.inv.client.ManufactureRecBillEditUI");
        BILLTYPE_TO_EDITUI_MAP.put("50957179-0105-1000-e000-0172c0a812fd463ED552", "com.kingdee.eas.scm.im.inv.client.MoveInWarehsBillEditUI");
        BILLTYPE_TO_EDITUI_MAP.put("50957179-0105-1000-e000-017bc0a812fd463ED552", "com.kingdee.eas.scm.im.inv.client.OtherInWarehsBillEditUI");
        BILLTYPE_TO_EDITUI_MAP.put("50957179-0105-1000-e000-015bc0a812fd463ED552", "com.kingdee.eas.scm.im.inv.client.SaleIssueBillEditUI");
        BILLTYPE_TO_EDITUI_MAP.put("50957179-0105-1000-e000-0163c0a812fd463ED552", "com.kingdee.eas.scm.im.inv.client.MaterialReqBillEditUI");
        BILLTYPE_TO_EDITUI_MAP.put("50957179-0105-1000-e000-016ec0a812fd463ED552", "com.kingdee.eas.scm.im.inv.client.MoveIssueBillEditUI");
        BILLTYPE_TO_EDITUI_MAP.put("50957179-0105-1000-e000-0177c0a812fd463ED552", "com.kingdee.eas.scm.im.inv.client.OtherIssueBillEditUI");
        BILLTYPE_TO_EDITUI_MAP.put("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552", "com.kingdee.eas.scm.cal.client.CostAdjustBillEditUI");
        BILLTYPE_TO_EDITUI_MAP.put("3a3b5446-0106-1000-e000-01c3c0a812e6463ED552", "com.kingdee.eas.scm.cal.client.StandardCostAdjBillEditUI");
    }
}

