/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.scm.cal.client.AbstractLotAccountContrastFilterUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.filter.ColConnFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class LotAccountContrastFilterUI
extends AbstractLotAccountContrastFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(LotAccountContrastFilterUI.class);
    private static final String PERMISSION_ITEM = "accountContrast_view";
    private static final String RESOURCE_PATH = "com.kingdee.eas.scm.cal.LotAccountContrastResource";

    public LotAccountContrastFilterUI() throws Exception {
        this.getElementsInfo();
    }

    public Object[] getUnVisibleBillStatus() {
        return null;
    }

    public Object[] getAdditiveBillStatus() {
        return null;
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        ColConnFilterElement mainOrgElement = new ColConnFilterElement("companyOrgUnit.id", (Component)this.prmtCompanyOrgUnit);
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new SingleFilterElement("billType.number", (Component)this.prmtBillType));
        elements.add((FilterElement)new SingleFilterElement("bizType.number", (Component)this.prmtBizType));
        elements.add((FilterElement)new SingleFilterElement("transactionType.number", (Component)this.prmtTransactionType));
        elements.add((FilterElement)new SingleFilterElement("updateType.number", (Component)this.prmtUpdateType));
        elements.add((FilterElement)new SingleFilterElement("status", (Component)this.combStatus, (Object)BillBaseStatusEnum.NULL));
        elements.add((FilterElement)new SingleFilterElement("isPriority", (Component)this.combIsPriority));
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "companyOrgUnit.id");
        this.prmtBillType.getQueryAgent().setEnabledMultiSelection(true);
        this.prmtTransactionType.getQueryAgent().setEnabledMultiSelection(true);
        this.prmtUpdateType.getQueryAgent().setEnabledMultiSelection(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtTransactionType.setEnabled(false);
        this.prmtUpdateType.setEnabled(false);
        this.prmtBillType.setDisplayFormat("$name$");
        this.prmtBillType.setCommitFormat("$name$");
        this.prmtBillType.setEditFormat("$name$");
        this.prmtTransactionType.setDisplayFormat("$name$");
        this.prmtTransactionType.setCommitFormat("$name$");
        this.prmtTransactionType.setEditFormat("$name$");
        this.prmtUpdateType.setDisplayFormat("$name$");
        this.prmtUpdateType.setCommitFormat("$name$");
        this.prmtUpdateType.setEditFormat("$name$");
        this.initFilterInfo();
        this.initListeners();
        if (this.getMainBizOrgF7().getText() != null) {
            this.mainOrgChanged();
        }
        this.combStatus.removeAllItems();
        this.combStatus.addItem((Object)BillBaseStatusEnum.NULL);
        this.combStatus.addItem((Object)UseStatusEnum.SAVED);
        this.combStatus.addItem((Object)UseStatusEnum.ACTIVE);
        this.combStatus.addItem((Object)UseStatusEnum.INACTIVE);
    }

    private void initFilterInfo() throws Exception {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectUuidPK pk = new ObjectUuidPK(userInfo.getId().toString());
        FullOrgUnitCollection coll = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)pk, OrgType.Company, null, PERMISSION_ITEM);
        HashSet<String> entryIdSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            FullOrgUnitInfo company = coll.get(i);
            entryIdSet.add(company.getId().toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", entryIdSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        this.prmtCompanyOrgUnit.setEntityViewInfo(viewInfo);
        EntityViewInfo view = this.getBillTypeEntityView();
        this.prmtBillType.setEntityViewInfo(view);
    }

    private void initListeners() {
        this.prmtBillType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getNewValue() != null && eventObj.getOldValue() != null && eventObj.getNewValue().toString().equals(eventObj.getOldValue().toString())) {
                    return;
                }
                LotAccountContrastFilterUI.this.prmtBizType.setValue(null);
                if (eventObj.getNewValue() != null) {
                    LotAccountContrastFilterUI.this.setBizTypeF7();
                    LotAccountContrastFilterUI.this.setTranscationFilter();
                }
            }
        });
        this.prmtBizType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getNewValue() != null && eventObj.getOldValue() != null && eventObj.getNewValue().toString().equals(eventObj.getOldValue().toString())) {
                    return;
                }
                LotAccountContrastFilterUI.this.prmtTransactionType.setValue(null);
                if (eventObj.getNewValue() != null) {
                    LotAccountContrastFilterUI.this.setTranscationFilter();
                }
            }
        });
        this.prmtTransactionType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                LotAccountContrastFilterUI.this.prmtUpdateType.setValue(null);
                if (eventObj.getNewValue() != null) {
                    Object[] array = (Object[])eventObj.getNewValue();
                    HashSet<TransactionTypeInfo> typeSet = new HashSet<TransactionTypeInfo>();
                    for (Object o : array) {
                        TransactionTypeInfo transactionType = (TransactionTypeInfo)o;
                        typeSet.add(transactionType);
                    }
                    LotAccountContrastFilterUI.this.filterUpdateType(typeSet);
                } else {
                    LotAccountContrastFilterUI.this.prmtUpdateType.setEnabled(false);
                }
            }
        });
    }

    private void setBizTypeF7() {
        Object[] array = (Object[])this.prmtBillType.getValue();
        HashSet<String> idSet = new HashSet<String>();
        for (Object o : array) {
            BillTypeInfo billType = (BillTypeInfo)o;
            idSet.add(billType.getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf("1"), CompareType.EQUALS));
        if (idSet != null) {
            filter.getFilterItems().add(new FilterItemInfo("billType.id", idSet, CompareType.INCLUDE));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        this.prmtBizType.setEntityViewInfo(view);
        this.prmtBizType.setEnabled(true);
    }

    private void setTranscationFilter() {
        Object[] array = (Object[])this.prmtBillType.getValue();
        HashSet<String> idSet = new HashSet<String>();
        for (Object o : array) {
            BillTypeInfo billType = (BillTypeInfo)o;
            idSet.add(billType.getId().toString());
        }
        BizTypeInfo bizTypeInfo = (BizTypeInfo)this.prmtBizType.getValue();
        String bizTypeId = bizTypeInfo == null ? null : bizTypeInfo.getId().toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billType.id", idSet, CompareType.INCLUDE));
        if (bizTypeId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)bizTypeId, CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        this.prmtTransactionType.setEntityViewInfo(viewInfo);
        this.prmtTransactionType.setEnabled(true);
    }

    public boolean verify() {
        if (this.prmtCompanyOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"COMPANY_NOT_NULL"));
            SysUtil.abort();
        }
        return super.verify();
    }

    private void filterUpdateType(Set<TransactionTypeInfo> typeSet) {
        HashSet<String> idSet = new HashSet<String>();
        for (TransactionTypeInfo type : typeSet) {
            TransactionInvUpdateTypeCollection coll = type.getTransactionInvUpdateType();
            if (coll == null || coll.size() <= 0) continue;
            for (int i = 0; i < coll.size(); ++i) {
                TransactionInvUpdateTypeInfo transactionInvUpdateType = coll.get(i);
                InvUpdateTypeInfo updateType = transactionInvUpdateType.getInvUpdateType();
                idSet.add(updateType.getId().toString());
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        viewInfo.setFilter(filterInfo);
        this.prmtUpdateType.setEntityViewInfo(viewInfo);
        this.prmtUpdateType.setEnabled(true);
    }

    private EntityViewInfo getBillTypeEntityView() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> billTypeNum = new HashSet<String>();
        billTypeNum.add("102");
        billTypeNum.add("103");
        billTypeNum.add("104");
        billTypeNum.add("105");
        billTypeNum.add("106");
        billTypeNum.add("107");
        billTypeNum.add("108");
        billTypeNum.add("109");
        filter.getFilterItems().add(new FilterItemInfo("number", billTypeNum, CompareType.INCLUDE));
        view.setFilter(filter);
        return view;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected String getPropertyOfMainBizOrg() {
        return "companyOrgUnit.id";
    }

    protected String getViewPermission() {
        return PERMISSION_ITEM;
    }
}

