/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.cal.LotAccountContrastFactory;
import com.kingdee.eas.scm.cal.LotAccountContrastInfo;
import com.kingdee.eas.scm.cal.client.AbstractLotAccountContrastListUI;
import com.kingdee.eas.scm.cal.client.LotAccountContrastEditUI;
import com.kingdee.eas.scm.cal.client.LotAccountContrastFilterUI;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class LotAccountContrastListUI
extends AbstractLotAccountContrastListUI {
    private static final Logger logger = CoreUIObject.getLogger(LotAccountContrastListUI.class);
    private static final String RESOURCE_PATH = "com.kingdee.eas.scm.cal.LotAccountContrastResource";
    protected LotAccountContrastFilterUI conditionPanel = null;
    protected CommonQueryDialog dialog = null;

    protected String getEditUIName() {
        return LotAccountContrastEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LotAccountContrastFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IObjectPK pk = this.logUIOperation("Log_Active");
        ArrayList pks = this.getSelectedIdValues();
        HashSet ids = new HashSet();
        ids.addAll(pks);
        int batchCount = ids.size();
        Map resultMap = LotAccountContrastFactory.getRemoteInstance().batchOperation(ids, BatchActionEnum.ENABLE);
        this.showBatchResult(resultMap, BatchActionEnum.ENABLE, batchCount);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IObjectPK pk = this.logUIOperation("Log_UnActive");
        ArrayList pks = this.getSelectedIdValues();
        HashSet ids = new HashSet();
        ids.addAll(pks);
        int batchCount = ids.size();
        Map resultMap = LotAccountContrastFactory.getRemoteInstance().batchOperation(ids, BatchActionEnum.DISABLE);
        this.showBatchResult(resultMap, BatchActionEnum.DISABLE, batchCount);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    private void showBatchResult(Map resultMap, BatchActionEnum action, int batchCount) throws Exception {
        String errorMsg = (String)resultMap.get("ERROR_MSG");
        int errorCount = (Integer)resultMap.get("ERROR_COUNT");
        String actionName = "";
        if (BatchActionEnum.DELETE.equals((Object)action)) {
            actionName = EASResource.getString((String)RESOURCE_PATH, (String)"Delete");
        } else if (BatchActionEnum.ENABLE.equals((Object)action)) {
            actionName = EASResource.getString((String)RESOURCE_PATH, (String)"Active");
        } else if (BatchActionEnum.DISABLE.equals((Object)action)) {
            actionName = EASResource.getString((String)RESOURCE_PATH, (String)"InActive");
        }
        if (errorCount == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"BatchSuccess", (Object[])new Object[]{actionName}));
            this.actionRefresh_actionPerformed(null);
        } else if (errorCount > 0 && errorCount < batchCount) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"BatchPartSuccess", (Object[])new Object[]{actionName, batchCount - errorCount, errorCount}), (String)errorMsg.toString(), (int)8188);
            this.actionRefresh_actionPerformed(null);
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"BatchFailure", (Object[])new Object[]{actionName}), (String)errorMsg.toString(), (int)8188);
        }
    }

    private boolean checkStatus(UseStatusEnum status) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.tblMain.getSelectManager().size(); ++i) {
            KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
            for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                String useStatus = this.tblMain.getRow(j).getCell("status").getValue().toString();
                Object numberObj = this.tblMain.getRow(j).getCell("number").getValue();
                String number = "";
                if (numberObj != null) {
                    number = numberObj.toString();
                }
                if (!status.toString().equals(useStatus)) continue;
                buf.append(EASResource.getString((String)RESOURCE_PATH, (String)"LotAccountContrast"));
                buf.append(number);
                if (status.equals((Object)UseStatusEnum.ACTIVE)) {
                    buf.append(EASResource.getString((String)RESOURCE_PATH, (String)"BILL_IS_ACTIVE"));
                } else if (status.equals((Object)UseStatusEnum.INACTIVE)) {
                    buf.append(EASResource.getString((String)RESOURCE_PATH, (String)"BILL_IS_INACTIVE"));
                }
                buf.append("\n");
            }
        }
        if (buf.length() > 0) {
            String msg = buf.toString();
            MsgBox.showInfo((Component)((Object)this), (String)msg.substring(0, msg.lastIndexOf("\n")));
            return false;
        }
        return true;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IObjectPK pk = this.logUIOperation("accountContrast_delete");
        ArrayList pks = this.getSelectedIdValues();
        HashSet ids = new HashSet();
        ids.addAll(pks);
        int batchCount = ids.size();
        Map resultMap = LotAccountContrastFactory.getRemoteInstance().batchOperation(ids, BatchActionEnum.DELETE);
        this.showBatchResult(resultMap, BatchActionEnum.DELETE, batchCount);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        LotAccountContrastInfo bill;
        this.checkSelected();
        String strId = this.getSelectedKeyValue();
        if (strId != null && strId.length() > 0 && UseStatusEnum.ACTIVE.equals((Object)(bill = LotAccountContrastFactory.getRemoteInstance().getLotAccountContrastInfo((IObjectPK)new ObjectUuidPK(strId))).getStatus())) {
            String msg = EASResource.getString((String)RESOURCE_PATH, (String)"ActiveData_Cannt_Modify");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    private void setStatus(UseStatusEnum status) throws Exception {
        this.checkSelected();
        ArrayList pks = this.getSelectedIdValues();
        int size = LotAccountContrastFactory.getRemoteInstance().setStatus(pks, status);
        String msg = "";
        if (UseStatusEnum.ACTIVE.equals((Object)status)) {
            if (size != pks.size()) {
                int errorlength = pks.size() - size;
                msg = EASResource.getString((String)RESOURCE_PATH, (String)"Enable_Error_Prompt", (Object[])new Object[]{pks.size(), errorlength});
                String errorDetail = EASResource.getString((String)RESOURCE_PATH, (String)"Enable_Prompt_Detail");
                this.refresh(null);
                MsgBox.showInfo((String)(msg + "\n" + errorDetail));
                this.setMessageText(msg);
                this.showMessage();
                return;
            }
            msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Startup_OK");
        } else if (UseStatusEnum.INACTIVE.equals((Object)status)) {
            msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Forbid _OK");
        }
        this.refresh(null);
        MsgBox.showInfo((Component)((Object)this), (String)msg);
        this.setMessageText(msg);
        this.showMessage();
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog == null) {
            this.dialog = super.initCommonQueryDialog();
            this.dialog.setShowFilter(false);
            this.dialog.setShowSorter(false);
            try {
                this.conditionPanel = new LotAccountContrastFilterUI();
                this.conditionPanel.setIsSupportMultiOrgs(true);
            }
            catch (Exception e) {
                this.handleException(e);
            }
            this.dialog.addUserPanel((KDPanel)this.conditionPanel);
        }
        return this.dialog;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectUuidPK pk = new ObjectUuidPK(userInfo.getId().toString());
        FilterInfo filterInfo = null;
        try {
            FullOrgUnitCollection coll = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)pk, OrgType.Company, null, "accountContrast_view");
            HashSet<String> entryIdSet = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                FullOrgUnitInfo company = coll.get(i);
                entryIdSet.add(company.getId().toString());
            }
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", entryIdSet, CompareType.INCLUDE));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return filterInfo;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        this.ExportData();
    }

    private void ExportData() throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        Object tmp = para.get(0);
        DatataskCaller task = new DatataskCaller();
        task.setMainOrgContext(this.getMainOrgContext());
        task.setParentComponent((Component)((Object)this));
        task.invoke(para, 1);
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "LotAccountContrast";
        param.datataskMode = 1;
        param.alias = ResourceUtils.getMessage((String)RESOURCE_PATH, (String)"LotAccountContrast");
        param.varList = new ArrayList();
        Hashtable<String, FilterInfo> hashtable = new Hashtable<String, FilterInfo>();
        try {
            hashtable.put("filter", this.mainQuery.getFilter());
        }
        catch (Exception exception) {
            // empty catch block
        }
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter dtParmeter = new DatataskParameter();
        dtParmeter.solutionName = solutionName = "LotAccountContrast";
        dtParmeter.alias = EASResource.getString((String)RESOURCE_PATH, (String)"LotAccountContrast");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(dtParmeter);
        return paramList;
    }

    private IObjectPK logUIOperation(String key) {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        StringBuffer instanceDetail = new StringBuffer();
        String number = null;
        if (selectRows != null && selectRows.length > 0) {
            IRow row = null;
            for (int i = 0; i < selectRows.length; ++i) {
                row = this.tblMain.getRow(i);
                number = (String)row.getCell("number").getValue();
                instanceDetail.append("\u3010" + number + "\u3011");
            }
        }
        String operName = EASResource.getString((String)RESOURCE_PATH, (String)key);
        String logItemName = EASResource.getString((String)RESOURCE_PATH, (String)key);
        IObjectPK pk = LogUtil.beginLogWithDescription(null, (String)operName, (BOSObjectType)new LotAccountContrastInfo().getBOSType(), null, (String)instanceDetail.toString(), (String)logItemName);
        return pk;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"billType.name", "transactionType.name"};
        return locateNames;
    }
}

