/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.ICreateJobFacade;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.common.perf.client.JobMonitorManager;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUI;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUISelectorAdaptor;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.cal.CalRptUtilFacadeFactory;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.ICalRptUtilFacade;
import com.kingdee.eas.scm.cal.MoveLocationUpdateFacadeFactory;
import com.kingdee.eas.scm.cal.client.AbstractMoveLocationBillUpdateUI;
import com.kingdee.eas.scm.cal.client.CostCalCulateWizard;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.constants.QueryInfoConstants;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class MoveLocationBillUpdateUI
extends AbstractMoveLocationBillUpdateUI
implements ChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(MoveLocationBillUpdateUI.class);
    private static final String RESOURCE = "com.kingdee.eas.scm.cal.UpdateBillResource";
    Locale locale = null;

    @Override
    public void actionStart_actionPerformed(ActionEvent e) throws Exception {
        if (!this.beforeCheck()) {
            return;
        }
        HashMap param = this.buildParam();
        if (this.isManual.isSelected()) {
            HashMap result = MoveLocationUpdateFacadeFactory.getRemoteInstance().updateBill(param);
            String msg = result.get("resultMsg").toString().length() > 0 ? result.get("resultMsg").toString() : EASResource.getString((String)RESOURCE, (String)"Null");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"succeed"), (String)(EASResource.getString((String)RESOURCE, (String)"updateResut") + msg), (int)1);
        } else {
            Object[] jobParams = new Object[]{this.prmtCompany.getValue(), param, this.locale, SysContext.getSysContext().getCurrentUserInfo(), this.prmtCompany.getValue(), ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getCU()};
            String updateInfo = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"updateTaskTitle"), ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getNumber(), ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getName(), this.kDSpFromYear.getValue().toString(), this.kDSpFromPeriod.getValue(), this.kDSpToYear.getValue().toString(), this.kDSpToPeriod.getValue());
            JobConfig jobCfg = this.creteJobCfg((CompanyOrgUnitInfo)this.prmtCompany.getValue(), updateInfo);
            JobParam jobParam = new JobParam((Object)jobParams);
            jobParam.setLocale(this.locale);
            ICreateJobFacade iCreateJobFacade = CreateJobFacadeFactory.getRemoteInstance();
            Map result = iCreateJobFacade.executeJob(jobParam, jobCfg);
            if (result != null && result.get("jobInstExtId") != null) {
                JobMonitorManager.getInstance().addMonitorInfo((String)result.get("jobInstExtId"), jobCfg.getTitle());
            }
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"UpdateTaskInfo"));
        }
    }

    private boolean beforeCheck() {
        if (this.prmtCompany.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"companyNull"));
            return false;
        }
        if (this.isManual.isSelected() && this.prmtMaterials.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"materialNull"));
            return false;
        }
        if (this.isManual.isSelected() && (this.txtPrice.getBigDecimalValue() == null || this.txtPrice.getBigDecimalValue().compareTo(BigDecimal.ZERO) == 0)) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"priceNull"));
            return false;
        }
        return true;
    }

    public static void show(CostCalCulateWizard ui) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MoveLocationBillUpdateUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        SCMClientUtils.setMainBizOrgCompF7forSealUp((KDBizPromptBox)this.prmtCompany, (OrgType)OrgType.Company, (String)"costcompute");
        SCMClientUtils.setF7OrgUnitBizUnit((KDBizPromptBox)this.prmtCompany);
        this.setMaterialF7(this.prmtMaterials);
        this.prmtWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQueryForCal");
        SCMClientUtils.setSotrageOrgF7((KDBizPromptBox)this.prmtStorage);
        CalculateClientUtil.setF7FilterUIProperties(this.prmtCompany, true);
        CalculateClientUtil.setF7FilterUIProperties(this.prmtStorage, false);
        CalculateClientUtil.setF7FilterUIProperties(this.prmtWarehouse, false);
        this.prmtStorage.setLabelVisible(false);
        this.prmtWarehouse.setLabelVisible(false);
        this.prmtMaterials.setEnabled(false);
        this.kDBtnUpdate.setEnabled(true);
        this.prmtStorage.setEnabled(false);
        this.prmtWarehouse.setEnabled(false);
        this.locale = SysContext.getSysContext().getLocale();
        this.prmtProject.setEnabled(false);
        this.prmtTrackNum.setEnabled(false);
        this.prmtAssistProperty.setEnabled(false);
        this.txtPrice.setEnabled(false);
        this.txtLot.setEnabled(false);
        this.prmtCompany.addChangeListener((ChangeListener)this);
        this.prmtStorage.addChangeListener((ChangeListener)this);
        this.isManual.addChangeListener((ChangeListener)this);
        this.prmtMaterials.addChangeListener((ChangeListener)this);
    }

    private void setMaterialF7(KDBizPromptBox kDBizPromptBoxMaterial) {
        F7MaterialMultiUISelectorAdaptor selectorLisenterMaterial = null;
        try {
            selectorLisenterMaterial = new F7MaterialMultiUISelectorAdaptor((KDPromptBox)kDBizPromptBoxMaterial, (Component)new F7MaterialMultiUI(), (Object)this, "C79FC042", QueryInfoConstants.getMaterialQueryInfo((OrgType)OrgType.Company), "materialGroup.id", QueryInfoConstants.getMaterialNoGroupQueryInfo((OrgType)OrgType.Company), false);
            kDBizPromptBoxMaterial.setDisplayFormat("$number$");
            kDBizPromptBoxMaterial.setEditFormat("$number$");
            kDBizPromptBoxMaterial.setCommitFormat("$number$;$helpCode$");
            selectorLisenterMaterial.setIsMultiSelect(false);
            selectorLisenterMaterial.setQueryProperty("helpCode", "or");
            kDBizPromptBoxMaterial.setSelector((KDPromptSelector)selectorLisenterMaterial);
            kDBizPromptBoxMaterial.addSelectorListener((SelectorListener)selectorLisenterMaterial);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof KDBizPromptBox && ((KDBizPromptBox)e.getSource()).equals(this.prmtCompany)) {
            if (this.prmtCompany.getValue() != null) {
                CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
                try {
                    this.loadAccountPeriod(companyInfo);
                    this.prmtMaterials.setCurrentMainBizOrgUnit((OrgUnitInfo)companyInfo, OrgType.Company);
                    this.prmtMaterials.setEnabled(true);
                }
                catch (Exception ex) {
                    this.handUIException(ex);
                }
                this.clearStorageOrg(true);
                CalculateClientUtil.setStorageOrgF7(companyInfo, this.prmtStorage, null);
                this.clearWareHouse(false);
            } else {
                this.clearWareHouse(false);
                this.clearStorageOrg(false);
                this.prmtMaterials.setEnabled(false);
            }
        } else if (e.getSource() instanceof KDBizPromptBox && ((KDBizPromptBox)e.getSource()).equals(this.prmtStorage)) {
            if (this.prmtStorage.getValue() != null) {
                try {
                    StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)this.prmtStorage.getValue();
                    HashSet<String> oriSet = new HashSet<String>();
                    oriSet.add(storageOrgUnitInfo.getId().toString());
                    this.prmtWarehouse.setEnabled(true);
                    this.prmtWarehouse.setValue(null);
                    this.prmtWarehouse.setEntityViewInfo(InvClientUtils.getWarehouseFilter(oriSet, (int)1));
                    this.prmtProject.setEnabled(true);
                    this.prmtTrackNum.setEnabled(true);
                    UIHelper.registerProjectF7((KDBizPromptBox)this.prmtStorage, null, (KDBizPromptBox)this.prmtProject, null);
                    UIHelper.registerTrackNumberF7((KDBizPromptBox)this.prmtStorage, null, (KDBizPromptBox)this.prmtProject, (KDBizPromptBox)this.prmtTrackNum, null, (boolean)false);
                }
                catch (Exception e1) {
                    this.handUIException(e1);
                }
            } else {
                this.clearWareHouse(false);
                this.prmtProject.setEnabled(false);
                this.prmtTrackNum.setEnabled(false);
            }
        } else if (e.getSource() instanceof KDCheckBox && ((KDCheckBox)e.getSource()).equals(this.isManual)) {
            if (this.isManual.isSelected()) {
                this.setLableVisble(true);
            } else {
                this.setLableVisble(false);
            }
        } else if (e.getSource() instanceof KDBizPromptBox && ((KDBizPromptBox)e.getSource()).equals(this.prmtMaterials)) {
            MaterialInfo materialInfo = (MaterialInfo)this.prmtMaterials.getValue();
            if (materialInfo != null) {
                this.txtPrice.setEnabled(true);
                this.txtPrice.setPrecision(materialInfo.getPricePrecision());
                this.txtLot.setEnabled(true);
                AsstAttrTypeInfo asst = materialInfo.getAssistAttr();
                if (asst != null) {
                    this.prmtAssistProperty.setEnabled(true);
                    SCMClientUtils.setAsstAttrInputF7((KDBizPromptBox)this.prmtAssistProperty, (MaterialInfo)materialInfo, (IUIObject)this);
                } else {
                    this.prmtAssistProperty.setEnabled(false);
                }
            } else {
                this.prmtAssistProperty.setEnabled(false);
                this.txtPrice.setEnabled(false);
                this.txtLot.setEnabled(false);
            }
        }
    }

    private void setLableVisble(boolean isVisble) {
        this.kDLabelStorage.setVisible(isVisble);
        this.kDLabelWarehouse.setVisible(isVisble);
        this.kDLabelMaterial.setVisible(isVisble);
        this.kDLabelLot.setVisible(isVisble);
        this.kDLabelTrackNum.setVisible(isVisble);
        this.kDLabelPrice.setVisible(isVisble);
        this.kDLabelProject.setVisible(isVisble);
        this.kDLabelAssistProperty.setVisible(isVisble);
        this.kDBtnUpdate.setText(isVisble ? ResourceBase.getString((String)RESOURCE, (String)"manualUpdate", (Locale)this.locale) : ResourceBase.getString((String)RESOURCE, (String)"startUpdate", (Locale)this.locale));
    }

    private void clearStorageOrg(boolean isEnabled) {
        this.prmtStorage.setValue(null);
        this.prmtStorage.setEnabled(isEnabled);
    }

    private void clearWareHouse(boolean isEnabled) {
        this.prmtWarehouse.setValue(null);
        this.prmtWarehouse.setEnabled(isEnabled);
    }

    private void loadAccountPeriod(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        if (companyInfo != null) {
            PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            if (periodInfo == null) {
                this.prmtCompany.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTSTART);
            }
            if (curPeriodInfo == null) {
                this.prmtCompany.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTCURRENT);
            }
            ICalRptUtilFacade iCalRptUtil = CalRptUtilFacadeFactory.getRemoteInstance();
            Object[] reslut = iCalRptUtil.fetchInitFilterData(companyInfo.getId().toString());
            if (reslut != null) {
                CalculateUtil.AccountPeriodInfo actPeriodInfo = (CalculateUtil.AccountPeriodInfo)reslut[1];
                CalculateUtil.appliesPeriodControl(this.kDSpFromYear, this.kDSpToYear, this.kDSpFromPeriod, this.kDSpToPeriod, actPeriodInfo, true, true);
            }
        }
    }

    private HashMap buildParam() {
        MaterialInfo materialInfo;
        WarehouseInfo warehouse;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("companyInfo", this.prmtCompany.getValue());
        StorageOrgUnitInfo storage = (StorageOrgUnitInfo)this.prmtStorage.getValue();
        if (storage != null) {
            params.put("storageId", storage.getId());
            params.put("storageNum", storage.getNumber());
        }
        if ((warehouse = (WarehouseInfo)this.prmtWarehouse.getValue()) != null) {
            params.put("warehouseId", warehouse.getId());
            params.put("warehouseNum", warehouse.getNumber());
        }
        if ((materialInfo = (MaterialInfo)this.prmtMaterials.getValue()) != null) {
            params.put("materialId", materialInfo.getId());
            params.put("materialNum", materialInfo.getNumber());
        }
        params.put("yearFrom", (Integer)this.kDSpFromYear.getValue());
        params.put("periodFrom", (Integer)this.kDSpFromPeriod.getValue());
        params.put("yearTo", (Integer)this.kDSpToYear.getValue());
        params.put("periodTo", (Integer)this.kDSpToPeriod.getValue());
        params.put("isManual", this.isManual.isSelected());
        params.put("lot", this.txtLot.getText());
        params.put("assistProperty", this.prmtAssistProperty.getValue());
        params.put("project", this.prmtProject.getValue());
        params.put("trackNum", this.prmtTrackNum.getValue());
        params.put("price", this.txtPrice.getValue());
        return params;
    }

    private JobConfig creteJobCfg(CompanyOrgUnitInfo company, String title) throws EASBizException, BOSException {
        JobConfig jobCfg = new JobConfig();
        jobCfg.setTitle(title);
        jobCfg.setTaskType(company.getNumber() + "SCM_UPDATE_MOVELOCATIONBILL");
        jobCfg.setDescription(title);
        jobCfg.setNeedCheckTaskType(true);
        jobCfg.setMutex("update_moveLocationBill");
        jobCfg.setNumber("SCM_UPDATE_MOVELOCATIONBILL");
        return jobCfg;
    }
}

