/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.IWriteOffGroup;
import com.kingdee.eas.scm.cal.WriteOffGroupFactory;
import com.kingdee.eas.scm.cal.client.AbstractPreExceptionBalanceReportFilterUI;
import com.kingdee.eas.scm.cal.info.WriteOffPeriodInfo;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class PreExceptionBalanceReportFilterUI
extends AbstractPreExceptionBalanceReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PreExceptionBalanceReportFilterUI.class);
    private CompanyOrgUnitInfo oldCompanyInfo = null;
    private Map periodMap = new HashMap();
    private F7ContextManager f7Manger = null;
    private PeriodInfo curPeriodInfo = null;
    private String comPeriodInfo = "";

    public void onLoad() throws Exception {
        super.onLoad();
        this.comPeriodInfo = this.lbPeriodInfo.getText();
        if (this.ckBxMShortName.isSelected()) {
            this.txtMShortNameFrom.setEnabled(true);
            this.txtMShortNameTo.setEnabled(true);
        } else {
            this.txtMShortNameFrom.setEnabled(false);
            this.txtMShortNameTo.setEnabled(false);
        }
        CalculateClientUtil.setCompanyOrgF7(this.prmtFinanceOrgUnit, "exceptionbalancereport_view", true);
        SCMClientUtils.setF7OrgUnitBizUnit((KDBizPromptBox)this.prmtFinanceOrgUnit);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getData();
        this.setPeriodInfo(company);
        this.prmtFinanceOrgUnit.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                if (e.getData() != null && e.getData().equals(e.getOldData())) {
                    return;
                }
                e.setResult(PreExceptionBalanceReportFilterUI.this.prmtCompanyOrgUnit(e));
            }
        });
        this.prmtStorage.setEnabledMultiSelection(true);
        this.prmtWarehs.setEnabledMultiSelection(true);
        this.prmtWarehs.setEnabled(false);
    }

    public void onInit(RptParams arg0) throws Exception {
        this.onInitFilter();
    }

    private void onInitFilter() {
        try {
            CalculateClientUtil.InitCompanyF7(this.prmtFinanceOrgUnit, "exceptionbalancereport_view");
            if (this.prmtFinanceOrgUnit.getValue() != null) {
                this.oldCompanyInfo = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue();
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtFinanceOrgUnit;
    }

    private void setPeriodInfo(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (company != null) {
            this.curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company);
            this.lbPeriodInfo.setText(this.comPeriodInfo + this.curPeriodInfo.getPeriodYear() + "." + this.curPeriodInfo.getPeriodNumber());
        } else {
            this.prmtStorage.setEnabled(false);
            this.prmtWarehs.setEnabled(false);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void prmtFinanceOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        super.prmtFinanceOrgUnit_stateChanged(e);
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue();
        CalculateClientUtil.setStorageOrgF7(companyInfo, this.prmtStorage, null);
    }

    @Override
    protected void prmtStorageOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        Object[] storages = (Object[])this.prmtStorage.getValue();
        HashSet<String> storageIds = new HashSet<String>();
        if (storages != null) {
            for (int i = 0; i < storages.length; ++i) {
                if (storages[i] == null) {
                    this.prmtWarehs.setEnabled(false);
                    break;
                }
                storageIds.add(((StorageOrgUnitInfo)storages[i]).getId().toString());
                this.prmtWarehs.setEnabled(true);
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("storageOrg.id", storageIds, CompareType.INCLUDE));
                ev.setFilter(filter);
                this.prmtWarehs.setEntityViewInfo(ev);
            }
        } else {
            this.prmtWarehs.setValue(null);
            this.prmtWarehs.setEnabled(false);
        }
    }

    @Override
    protected void ckBxMShortName_stateChanged(ChangeEvent e) throws Exception {
        if (this.ckBxMShortName.isSelected()) {
            this.txtMShortNameFrom.setEnabled(true);
            this.txtMShortNameTo.setEnabled(true);
        } else {
            this.txtMShortNameFrom.setEnabled(false);
            this.txtMShortNameTo.setEnabled(false);
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
        }
    }

    public RptParams getCustomCondition() {
        MaterialInfo m;
        RptParams para = new RptParams();
        String CompanyOrgUnitID = "";
        String companyname = "";
        String MaterialFrom = "";
        String MaterialTo = "";
        String MaterialFromId = "";
        String MaterialToId = "";
        if (this.prmtFinanceOrgUnit.getValue() != null) {
            companyname = ((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue()).getName();
            if (((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue()).getId() != null) {
                CompanyOrgUnitID = ((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue()).getId().toString();
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COMPANY_NOTNULL"));
        }
        if (this.prmtMaterial.getValue() != null) {
            m = null;
            if (this.prmtMaterial.getValue() instanceof MaterialInfo[]) {
                m = ((MaterialInfo[])this.prmtMaterial.getValue())[0];
            } else if (this.prmtMaterial.getValue() instanceof MaterialInfo) {
                m = (MaterialInfo)this.prmtMaterial.getValue();
            }
            if (m != null) {
                MaterialFrom = m.getNumber();
                if (m.getId() != null) {
                    MaterialFromId = m.getId().toString();
                }
            } else {
                MaterialFrom = this.prmtMaterial.getValue().toString();
            }
        }
        if (this.prmtMaterialTo.getValue() != null) {
            m = null;
            if (this.prmtMaterialTo.getValue() instanceof MaterialInfo[]) {
                m = ((MaterialInfo[])this.prmtMaterialTo.getValue())[0];
            } else if (this.prmtMaterialTo.getValue() instanceof MaterialInfo) {
                m = (MaterialInfo)this.prmtMaterialTo.getValue();
            }
            if (m != null) {
                MaterialTo = m.getNumber();
                if (m.getId() != null) {
                    MaterialToId = m.getId().toString();
                }
            } else {
                MaterialTo = this.prmtMaterialTo.getValue().toString();
            }
        }
        para.setBoolean("ckShowNoCalculate", this.ckShowNoCalculate.isSelected());
        para.setString("COMPANY_ID", CompanyOrgUnitID);
        para.setString("COMPANY_NAME", companyname);
        para.setString("MATERIAL_FROM", MaterialFrom);
        para.setString("MATERIAL_TO", MaterialTo);
        para.setString("MATERIAL_ID_FROM", MaterialFromId);
        para.setString("MATERIAL_ID_TO", MaterialToId);
        para.setObject("STORAGEORGUNIT", this.prmtStorage.getValue());
        para.setObject("WAREHOUSE", this.prmtWarehs.getValue());
        para.setInt("YEAR_FROM", this.curPeriodInfo.getPeriodYear());
        para.setInt("PERIOD_FROM", this.curPeriodInfo.getPeriodNumber());
        para.setInt("YEAR_TO", this.curPeriodInfo.getPeriodYear());
        para.setInt("PERIOD_TO", this.curPeriodInfo.getPeriodNumber());
        para.setBoolean("ckBxMShortName", this.ckBxMShortName.isSelected());
        String txtMShortNameFrom = this.txtMShortNameFrom.getText().trim().replaceAll("'", "''");
        para.setString("txtMShortNameFrom", txtMShortNameFrom);
        String txtMShortNameTo = this.txtMShortNameTo.getText().trim().replaceAll("'", "''");
        para.setString("txtMShortNameTo", txtMShortNameTo);
        para.setBoolean("moveAvrOnly", this.ckbxMoveAvr.isSelected());
        para.setInt("costOutMark", this.kdcbOutCostadj.getSelectedIndex());
        para.setBoolean("isPreCloseAccount", true);
        return para;
    }

    public void setCustomCondition(RptParams params) {
        this.clear();
        try {
            if (params.getString("COMPANY_ID") != null && params.getString("COMPANY_ID").length() != 0) {
                CompanyOrgUnitInfo cinfo = null;
                cinfo = null != this.oldCompanyInfo && params.getString("COMPANY_ID").equals(this.oldCompanyInfo.getId().toString()) ? this.oldCompanyInfo : CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(params.getString("COMPANY_ID")));
                this.prmtFinanceOrgUnit.setValue((Object)cinfo);
            }
            if (params.getString("MATERIAL_ID_FROM") != null && params.getString("MATERIAL_ID_FROM").length() != 0) {
                MaterialInfo minfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(params.getString("MATERIAL_ID_FROM")));
                this.prmtMaterial.setValue((Object)minfo);
            } else if (params.getString("MATERIAL_FROM") != null) {
                this.prmtMaterial.setValue((Object)params.getString("MATERIAL_FROM"));
            }
            if (params.getString("MATERIAL_ID_TO") != null && params.getString("MATERIAL_ID_TO").length() != 0) {
                MaterialInfo mtoinfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(params.getString("MATERIAL_ID_TO")));
                this.prmtMaterialTo.setValue((Object)mtoinfo);
            } else if (params.getString("MATERIAL_TO") != null) {
                this.prmtMaterialTo.setValue((Object)params.getString("MATERIAL_TO"));
            }
            this.prmtStorage.setValue(params.getObject("STORAGEORGUNIT"));
            this.prmtWarehs.setValue(params.getObject("WAREHOUSE"));
            this.ckShowNoCalculate.setSelected(params.getBoolean("ckShowNoCalculate"));
            if (params.getObject("ckBxMShortName") != null) {
                this.ckBxMShortName.setSelected(params.getBoolean("ckBxMShortName"));
            }
            if (this.ckBxMShortName.isSelected()) {
                if (params.getString("txtMShortNameFrom").trim().length() > 0) {
                    String txtMShortNameFrom = params.getString("txtMShortNameFrom").trim().replaceAll("''", "'");
                    this.txtMShortNameFrom.setText(txtMShortNameFrom);
                }
                if (params.getString("txtMShortNameTo").trim().length() > 0) {
                    String txtMShortNameTo = params.getString("txtMShortNameTo").trim().replaceAll("''", "'");
                    this.txtMShortNameTo.setText(txtMShortNameTo);
                }
            }
            this.ckbxMoveAvr.setSelected(params.getBoolean("moveAvrOnly"));
            this.kdcbOutCostadj.setSelectedIndex(params.getInt("costOutMark"));
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public void clear() {
        super.clear();
        this.prmtMaterial.setValue(null);
        this.prmtMaterialTo.setValue(null);
        this.prmtFinanceOrgUnit.setValue(null);
        this.ckShowNoCalculate.setSelected(false);
        this.ckBxMShortName.setSelected(false);
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
        this.onInitFilter();
    }

    private int prmtCompanyOrgUnit(PreChangeEvent e) {
        try {
            String strTemp;
            Object obj = e.getData();
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = null;
            if (obj instanceof CompanyOrgUnitInfo && !this.periodMap.containsKey((aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)e.getData()).getId().toString())) {
                IWriteOffGroup iw = WriteOffGroupFactory.getRemoteInstance();
                Map map = iw.loadFinanceData(aCompanyOrgUnitInfo);
                WriteOffPeriodInfo info = (WriteOffPeriodInfo)map.get(aCompanyOrgUnitInfo.getId().toString());
                this.periodMap.put(aCompanyOrgUnitInfo.getId().toString(), info);
            }
            if (aCompanyOrgUnitInfo != null && !aCompanyOrgUnitInfo.equals(e.getOldData())) {
                int ret;
                if (!this.isPeriodNotNull(aCompanyOrgUnitInfo)) {
                    return 0;
                }
                if ((this.prmtMaterial.getValue() != null || this.prmtMaterialTo.getValue() != null) && (ret = MsgBox.showConfirm2((String)(strTemp = InvClientUtils.getResource((String)"CLEAR_RELATION_AFTER_ORGCHANGED")))) == 2) {
                    return 0;
                }
                this.setPeriodInfo(aCompanyOrgUnitInfo);
                this.prmtMaterial.setValue(null);
                this.prmtMaterialTo.setValue(null);
            } else if (aCompanyOrgUnitInfo == null && (this.prmtMaterial.getValue() != null || this.prmtMaterialTo.getValue() != null)) {
                strTemp = InvClientUtils.getResource((String)"CLEAR_RELATION_AFTER_ORGCHANGED");
                int ret = MsgBox.showConfirm2((String)strTemp);
                if (ret == 2) {
                    return 0;
                }
                this.prmtMaterial.setValue(null);
                this.prmtMaterialTo.setValue(null);
            }
            this.prmtStorage.setEnabled(true);
            this.prmtWarehs.setEnabled(false);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return 1;
    }

    private boolean isPeriodNotNull(CompanyOrgUnitInfo companyOrgUnitInfo) {
        PeriodInfo curPeriodInfo = null;
        try {
            if (this.periodMap.containsKey(companyOrgUnitInfo.getId().toString())) {
                WriteOffPeriodInfo info = (WriteOffPeriodInfo)this.periodMap.get(companyOrgUnitInfo.getId().toString());
                curPeriodInfo = info.getCurPeriodInfo();
            } else {
                curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (curPeriodInfo == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_IS_NULL"));
            return false;
        }
        return true;
    }
}

