/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.cal.CostComputeOrderCollection;
import com.kingdee.eas.scm.cal.CostComputeOrderFactory;
import com.kingdee.eas.scm.cal.CostComputeOrderInfo;
import com.kingdee.eas.scm.cal.ICostComputeOrder;
import com.kingdee.eas.scm.cal.client.AbstractSetCalStorageOrWarehouseOrderUI;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class SetCalStorageOrWarehouseOrderUI
extends AbstractSetCalStorageOrWarehouseOrderUI
implements KDTDataRequestListener {
    private static final Logger logger = CoreUIObject.getLogger(SetCalStorageOrWarehouseOrderUI.class);
    private static final String res = "com.kingdee.eas.scm.cal.CalRptResource";

    public SetCalStorageOrWarehouseOrderUI() throws Exception {
        this.tbl.getActionMap().remove("Delete");
        this.tbl.checkParsed();
        this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tbl.getDataRequestManager().setDataRequestMode(0);
        this.tbl.getSelectManager().setSelectMode(2);
        this.enableExportExcel(this.tbl);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        int start = e.getFirstRow();
        int length = e.getLastRow() - start + 1;
        try {
            CalculateParams params = (CalculateParams)this.getUIContext().get("filterInfo");
            if (params != null) {
                ICostComputeOrder iOrder = CostComputeOrderFactory.getRemoteInstance();
                if (this.tbl == e.getSource()) {
                    CalculateParams orderParam = iOrder.getOrder(params, start, length);
                    if (0 == start) {
                        RptTableHeader header = (RptTableHeader)orderParam.getObject("header");
                        KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tbl);
                    }
                    RptRowSet rs1 = (RptRowSet)orderParam.getObject("rowset");
                    rs1.reset();
                    KDTableUtil.insertRows((RptRowSet)rs1, (int)start, (KDTable)this.tbl, (KDTableInsertHandler)new KDTableInsertHandler(){

                        public void setTableRowData(IRow row, Object[] rowData) {
                            SetCalStorageOrWarehouseOrderUI.this.filRowData(row, rowData);
                        }
                    });
                }
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void filRowData(IRow row, Object[] rowData) {
        if (rowData == null) {
            return;
        }
        int length = rowData.length;
        int n = length;
        for (int i = 0; i < n; ++i) {
            Number data;
            Object obj;
            if (i == 0) {
                obj = rowData[i];
                if (obj instanceof BigDecimal) {
                    data = (BigDecimal)rowData[i];
                    if (CalculateUtil.ONE.compareTo((BigDecimal)data) == 0) {
                        row.getCell(0).setValue((Object)true);
                        continue;
                    }
                    row.getCell(0).setValue((Object)false);
                    continue;
                }
                if (!(obj instanceof Integer)) continue;
                data = (Integer)rowData[i];
                if ((Integer)data == 0) {
                    row.getCell(0).setValue((Object)true);
                    continue;
                }
                row.getCell(0).setValue((Object)false);
                continue;
            }
            if (i == 3) {
                obj = rowData[i];
                if (obj instanceof BigDecimal) {
                    data = (BigDecimal)rowData[i];
                    if (CalculateUtil.ZERO.compareTo((BigDecimal)data) == 0) {
                        row.getCell(i).setValue((Object)new BigDecimal(row.getRowIndex() + 1));
                    } else {
                        row.getCell(i).setValue(rowData[i]);
                    }
                } else if (obj instanceof Integer) {
                    data = (Integer)rowData[i];
                    if ((Integer)data == 0) {
                        row.getCell(i).setValue((Object)new Integer(row.getRowIndex() + 1));
                    } else {
                        row.getCell(i).setValue(rowData[i]);
                    }
                }
                row.getCell(i).getStyleAttributes().setLocked(true);
                continue;
            }
            row.getCell(i).setValue(rowData[i]);
            row.getCell(i).getStyleAttributes().setLocked(true);
        }
    }

    protected void btn_selected_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void btn_moveUp_actionPerformed(ActionEvent e) throws Exception {
        int selectRowNo = this.getSelectRow();
        if (selectRowNo > 0) {
            IRow upRow = this.tbl.getRow(selectRowNo);
            IRow donwRow = this.tbl.getRow(selectRowNo - 1);
            Object upRowValueBak = upRow.getCell("Order").getValue();
            upRow.getCell("Order").setValue(donwRow.getCell("Order").getValue());
            donwRow.getCell("Order").setValue(upRowValueBak);
            this.tbl.moveRow(selectRowNo, selectRowNo - 1);
            this.tbl.getSelectManager().select(selectRowNo - 1, 3);
        }
    }

    private int getSelectRow() {
        KDTSelectBlock selectBlock = this.tbl.getSelectManager().get();
        if (selectBlock != null) {
            return selectBlock.getBeginRow();
        }
        return -1;
    }

    @Override
    protected void btn_moveDown_actionPerformed(ActionEvent e) throws Exception {
        int count;
        int selectRowNo = this.getSelectRow();
        if (selectRowNo >= 0 && selectRowNo <= (count = this.tbl.getRowCount()) - 1) {
            IRow upRow = this.tbl.getRow(selectRowNo);
            IRow donwRow = this.tbl.getRow(selectRowNo + 1);
            if (donwRow == null) {
                return;
            }
            Object upRowValueBak = upRow.getCell("Order").getValue();
            upRow.getCell("Order").setValue(donwRow.getCell("Order").getValue());
            donwRow.getCell("Order").setValue(upRowValueBak);
            this.tbl.moveRow(selectRowNo, selectRowNo + 1);
            this.tbl.getSelectManager().select(selectRowNo + 1, 3);
        }
    }

    @Override
    protected void btn_Save_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.tbl.getRowCount();
        CalculateParams params = (CalculateParams)this.getUIContext().get("filterInfo");
        if (rowCount > 0) {
            ICostComputeOrder iOrder = CostComputeOrderFactory.getRemoteInstance();
            CostComputeOrderInfo info = null;
            CostComputeOrderCollection collection = new CostComputeOrderCollection();
            int j = 1;
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.tbl.getRow(i);
                if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
                info = new CostComputeOrderInfo();
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
                info.setString("FCompanyOrgUnitID", params.getString("COMPANY_ID"));
                if ("1".equals(this.getCaltype())) {
                    if (row.getCell(4).getValue() != null) {
                        info.setString("STORAGEORGUNITID", (String)row.getCell(4).getValue());
                    }
                } else if ("2".equals(this.getCaltype()) && row.getCell(4).getValue() != null) {
                    info.setString("WAREHOUSEID", (String)row.getCell(4).getValue());
                }
                info.setInt("Forder", j);
                collection.add(info);
                ++j;
            }
            if (collection.size() > 0) {
                CalculateParams newParm = new CalculateParams();
                newParm.setString("COMPANY_ID", params.getString("COMPANY_ID"));
                newParm.setObject("ret", (Object)collection);
                iOrder.saveOrder(newParm);
            }
        }
    }

    @Override
    protected void btn_reset_actionPerformed(ActionEvent e) throws Exception {
        CalculateParams params = (CalculateParams)this.getUIContext().get("filterInfo");
        CalculateParams newParm = new CalculateParams();
        newParm.setString("COMPANY_ID", params.getString("COMPANY_ID"));
        CostComputeOrderFactory.getRemoteInstance().resetOrder(newParm);
        this.tbl.removeColumns();
        this.tbl.removeRows();
    }

    private String getCaltype() {
        CalculateParams params = (CalculateParams)this.getUIContext().get("filterInfo");
        return params.getString("CALTYPE");
    }

    @Override
    protected void btn_close_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }
}

