/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class StockDeailReportDataProvider
extends DefaultNoteDataProvider {
    private Logger logger = Logger.getLogger(StockDeailReportDataProvider.class);
    private HashMap hm = new HashMap();
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private DynamicRowSet drs = this.buildDynamicRowSet();

    public static void main(String[] args) throws BOSException {
    }

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        if (dataSource.getAssociateParameter() == null && this.get(dataSource.getId()) == null) {
            DynamicRowSet rowSet = this.drs;
            rowSet.beforeFirst();
            return rowSet;
        }
        return super.getData(dataSource);
    }

    private DynamicRowSet buildDynamicRowSet() {
        DynamicRowSet drs = null;
        try {
            drs = new DynamicRowSet(35);
            drs.setColInfo(1, "company", "company", 12, null);
            drs.setColInfo(2, "accountPeriod", "accountPeriod", 12, null);
            drs.setColInfo(3, "materielNumber", "materielNumber", 12, null);
            drs.setColInfo(4, "materielName", "materielName", 12, null);
            drs.setColInfo(5, "model", "model", 12, null);
            drs.setColInfo(6, "baseUnit", "baseUnit", 12, null);
            drs.setColInfo(7, "year", "year", 12, null);
            drs.setColInfo(8, "period", "period", 12, null);
            drs.setColInfo(9, "voucherNumber", "voucherNumber", 12, null);
            drs.setColInfo(10, "voucherSummary", "voucherSummary", 12, null);
            drs.setColInfo(11, "bizDate", "bizDate", 12, null);
            drs.setColInfo(12, "billNumber", "billNumber", 12, null);
            drs.setColInfo(13, "transactionType", "transactionType", 12, null);
            drs.setColInfo(14, "bizTypeName", "bizTypeName", 12, null);
            drs.setColInfo(15, "projectNumber", "projectNumber", 12, null);
            drs.setColInfo(16, "trackNumber", "trackNumber", 12, null);
            drs.setColInfo(17, "assistantAttr", "assistantAttr", 12, null);
            drs.setColInfo(18, "inQty", "inQty", 12, null);
            drs.setColInfo(19, "inUnitPrice", "inUnitPrice", 12, null);
            drs.setColInfo(20, "inAmount", "inAmount", 12, null);
            drs.setColInfo(21, "outQty", "outQty", 12, null);
            drs.setColInfo(22, "outUnitPrice", "outUnitPrice", 12, null);
            drs.setColInfo(23, "outAmount", "outAmount", 12, null);
            drs.setColInfo(24, "remainQty", "remainQty", 12, null);
            drs.setColInfo(25, "remainUnitPrice", "remainUnitPrice", 12, null);
            drs.setColInfo(26, "remainAmount", "remainAmount", 12, null);
            drs.setColInfo(27, "remark", "remark", 12, null);
            drs.setColInfo(28, "storageOrgUnitNumber", "storageOrgUnitNumber", 12, null);
            drs.setColInfo(29, "storageOrgUnitName", "storageOrgUnitName", 12, null);
            drs.setColInfo(30, "warehouseNumber", "warehouseNumber", 12, null);
            drs.setColInfo(31, "warehouseName", "warehouseName", 12, null);
            drs.setColInfo(32, "storeTypeName", "storeTypeName", 12, null);
            drs.setColInfo(33, "lot", "lot", 12, null);
            drs.setColInfo(34, "projectName", "projectName", 12, null);
            drs.setColInfo(35, "trackName", "trackName", 12, null);
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e1);
        }
        return drs;
    }

    public DynamicRowSet insertDataToDynamicRowSet(RptParams params, RptRowSet currentRowSet) {
        try {
            String PeriodFrom = String.valueOf(params.getInt("accPeriodYearFrom")) + "." + String.valueOf(params.getInt("accPeriodMonthFrom"));
            String PeriodTo = String.valueOf(params.getInt("accPeriodYearTo")) + "." + String.valueOf(params.getInt("accPeriodMonthTo"));
            MaterialInfo aMaterialInfo = null;
            MeasureUnitInfo aMeasureUnitInfo = null;
            try {
                aMaterialInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(params.getString("CurrentMaterialID")), SCMSelectorFactory.getMaterialInfoSelector());
                String unitID = aMaterialInfo.getBaseUnit().getId().toString();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("number"));
                aMeasureUnitInfo = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(unitID), sic);
            }
            catch (EASBizException e) {
                this.logger.error((Object)e);
            }
            catch (BOSException e) {
                this.logger.error((Object)e);
            }
            currentRowSet.reset();
            while (currentRowSet.next()) {
                this.drs.moveToInsertRow();
                this.drs.updateString("company", ((CompanyOrgUnitInfo)params.getObject("company")).getName());
                this.drs.updateString("accountPeriod", PeriodFrom + " - " + PeriodTo);
                this.drs.updateString("materielNumber", aMaterialInfo.getNumber());
                this.drs.updateString("materielName", aMaterialInfo.getName());
                this.drs.updateString("model", aMaterialInfo.getModel());
                this.drs.updateString("baseUnit", aMeasureUnitInfo.getName());
                this.drs.updateString("year", String.valueOf(currentRowSet.getInt("FYear")));
                if (currentRowSet.getBigDecimal("FPeriod") != null) {
                    this.drs.updateString("period", String.valueOf(currentRowSet.getInt("FPeriod")));
                } else {
                    this.drs.updateString("period", "");
                }
                this.drs.updateString("voucherNumber", currentRowSet.getString("FVoucherNumber"));
                this.drs.updateString("voucherSummary", currentRowSet.getString("FVoucherSummary"));
                if (currentRowSet.getObject("FBizDate") != null) {
                    this.drs.updateString("bizDate", currentRowSet.getObject("FBizDate").toString().substring(0, 10));
                } else {
                    this.drs.updateString("bizDate", "");
                }
                this.drs.updateString("billNumber", currentRowSet.getString("FBillNumber"));
                this.drs.updateString("transactionType", currentRowSet.getString("FTransactionTypeName"));
                this.drs.updateString("bizTypeName", currentRowSet.getString("Fbiztypename"));
                this.drs.updateString("projectNumber", currentRowSet.getString("FprojectNumber"));
                this.drs.updateString("trackNumber", currentRowSet.getString("FtrackNumber"));
                this.drs.updateString("assistantAttr", currentRowSet.getString("FAssistantAttrName"));
                this.drs.updateBigDecimal("inQty", currentRowSet.getBigDecimal("FInQty"));
                if (currentRowSet.getBigDecimal("FInUnitPrice") != null) {
                    this.drs.updateBigDecimal("inUnitPrice", currentRowSet.getBigDecimal("FInUnitPrice"));
                } else {
                    this.drs.updateBigDecimal("inUnitPrice", ZERO);
                }
                this.drs.updateBigDecimal("inAmount", currentRowSet.getBigDecimal("FInAmount").setScale(4, 4));
                this.drs.updateBigDecimal("outQty", currentRowSet.getBigDecimal("FOutQty"));
                if (currentRowSet.getBigDecimal("FOutUnitPrice") != null) {
                    this.drs.updateBigDecimal("outUnitPrice", currentRowSet.getBigDecimal("FOutUnitPrice"));
                } else {
                    this.drs.updateBigDecimal("outUnitPrice", ZERO);
                }
                this.drs.updateBigDecimal("outAmount", currentRowSet.getBigDecimal("FOutAmount").setScale(4, 4));
                this.drs.updateBigDecimal("remainQty", currentRowSet.getBigDecimal("FRemainQty"));
                if (currentRowSet.getBigDecimal("FRemainUnitPrice") != null) {
                    this.drs.updateBigDecimal("remainUnitPrice", currentRowSet.getBigDecimal("FRemainUnitPrice"));
                } else {
                    this.drs.updateBigDecimal("remainUnitPrice", ZERO);
                }
                this.drs.updateBigDecimal("remainAmount", currentRowSet.getBigDecimal("FRemainAmount").setScale(4, 4));
                if (currentRowSet.getString("FRemark") != null) {
                    this.drs.updateString("remark", currentRowSet.getString("FRemark"));
                } else {
                    this.drs.updateString("remark", "");
                }
                this.drs.updateString("storageOrgUnitNumber", currentRowSet.getString("fstorageOrgUnitNumber"));
                this.drs.updateString("storageOrgUnitName", currentRowSet.getString("fstorageOrgUnitName"));
                this.drs.updateString("warehouseNumber", currentRowSet.getString("fwarehouseNumber"));
                this.drs.updateString("warehouseName", currentRowSet.getString("fwarehouseName"));
                this.drs.updateString("storeTypeName", currentRowSet.getString("fstoreTypeName"));
                if (currentRowSet.getString("flot") != null) {
                    this.drs.updateString("lot", currentRowSet.getString("flot"));
                } else {
                    this.drs.updateString("lot", "");
                }
                if (currentRowSet.getString("fprojectName") != null) {
                    this.drs.updateString("projectName", currentRowSet.getString("fprojectName"));
                } else {
                    this.drs.updateString("projectName", "");
                }
                if (currentRowSet.getString("ftrackName") != null) {
                    this.drs.updateString("trackName", currentRowSet.getString("ftrackName"));
                } else {
                    this.drs.updateString("trackName", "");
                }
                this.drs.insertRow();
            }
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e1);
        }
        return this.drs;
    }

    public Object get(String id) {
        return this.hm.get(id);
    }
}

