/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.client.OtherBillEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.StandardCostAdjBillFactory;
import com.kingdee.eas.scm.cal.StockDetailReportFacadeFactory;
import com.kingdee.eas.scm.cal.client.AbstractStockDetailReportUI;
import com.kingdee.eas.scm.cal.client.CostAdjustBillEditUI;
import com.kingdee.eas.scm.cal.client.StandardCostAdjBillEditUI;
import com.kingdee.eas.scm.cal.client.StockDeailReportDataProvider;
import com.kingdee.eas.scm.cal.client.StockDetailReportConditionUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.ReportQueryConditionHelper;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.MoveIssueBillFactory;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.OtherIssueBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.client.ManufactureRecBillEditUI;
import com.kingdee.eas.scm.im.inv.client.MaterialReqBillEditUI;
import com.kingdee.eas.scm.im.inv.client.MoveInWarehsBillEditUI;
import com.kingdee.eas.scm.im.inv.client.MoveIssueBillEditUI;
import com.kingdee.eas.scm.im.inv.client.OtherInWarehsBillEditUI;
import com.kingdee.eas.scm.im.inv.client.OtherIssueBillEditUI;
import com.kingdee.eas.scm.im.inv.client.PurInWarehsBillEditUI;
import com.kingdee.eas.scm.im.inv.client.SaleIssueBillEditUI;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class StockDetailReportUI
extends AbstractStockDetailReportUI {
    private static final Logger logger = CoreUIObject.getLogger(StockDetailReportUI.class);
    private static String AUTO_GENERATE_RESOURCE = "com.kingdee.eas.scm.cal.CalRptResource";
    private static final String permItem_print = "stockdetailreport_print";
    private Object[] pkCollection;
    public static final Color necessaryColor = new Color(252, 251, 223);
    private int currentPKIndex = -1;
    private int lastRowNumber = 0;
    private RptRowSet currentRowSet = null;
    BigDecimal remaindQty = new BigDecimal(0);
    BigDecimal remaindAmt = new BigDecimal(0);

    public StockDetailReportUI() throws Exception {
        this.initToolbar();
        this.tbl.setEditable(false);
        this.tbl.getActionMap().remove("Delete");
        this.tbl.checkParsed();
        this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tbl.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.tbl);
        this.tbl.getDataRequestManager().setExportMemoryCallback(false);
    }

    private void initToolbar() {
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnFirst.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.btnPre.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.btnNext.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.btnLast.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
        this.btnViewUI.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.menuItemFirst.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.menuItemPre.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.menuItemNext.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.menuItemLast.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
        this.menuViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.currentPKIndex = -1;
        super.actionQuery_actionPerformed(e);
        if (!this.params.getBoolean("ckBxMShortName")) {
            this.kDLabelContainer8.setVisible(false);
        } else {
            this.kDLabelContainer8.setVisible(true);
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.params.getObject("company");
        if (company != null) {
            IMRptUtils.checkHasAuthorized((String)company.getId().toString(), (OrgType)OrgType.Company, (String)permItem_print);
            this.invokePrintFunction(true, e);
        }
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.params.getObject("company");
        if (company != null) {
            IMRptUtils.checkHasAuthorized((String)company.getId().toString(), (OrgType)OrgType.Company, (String)permItem_print);
            this.invokePrintFunction(false, e);
        }
    }

    private void getPrintData() throws Exception {
        this.changeMaterialID(8);
        if (this.currentPKIndex == -1) {
            this.getMaterialPKList(this.params);
        }
        this.getMaterialID();
        try {
            int len = 0;
            RptParams para = new RptParams();
            para.setInt("spinAmountPrecission", this.params.getInt("spinAmountPrecission"));
            para.setInt("spinPricePrecission", this.params.getInt("spinPricePrecission"));
            para.setInt("spinQtyPrecission", this.params.getInt("spinQtyPrecission"));
            para.setString("CurrentMaterialID", this.params.getString("CurrentMaterialID"));
            para.setObject("company", this.params.getObject("company"));
            if (this.params.getString("FStorageOrgUnit") != null) {
                para.setString("FStorageOrgUnit", this.params.getString("FStorageOrgUnit"));
            }
            if (this.params.getString("FWarehouse") != null) {
                para.setString("FWarehouse", this.params.getString("FWarehouse"));
            }
            para.setString("txtMShortNameFrom", this.params.getString("txtMShortNameFrom"));
            para.setString("txtMShortNameTo", this.params.getString("txtMShortNameTo"));
            para.setString("tempTable", this.getTempTable());
            para.setObject("materialFrom", this.params.getObject("materialFrom"));
            para.setObject("materialTo", this.params.getObject("materialTo"));
            para.setObject("calType", this.params.getObject("calType"));
            para.setObject("status", this.params.getObject("status"));
            para.setInt("accPeriodYearFrom", this.params.getInt("accPeriodYearFrom"));
            para.setInt("accPeriodMonthFrom", this.params.getInt("accPeriodMonthFrom"));
            para.setInt("accPeriodYearTo", this.params.getInt("accPeriodYearTo"));
            para.setInt("accPeriodMonthTo", this.params.getInt("accPeriodMonthTo"));
            if (this.getUIContext().get("RPTFilter") != null) {
                if (this.params.getObject("warehouse") != null) {
                    Object[] warehsArray = (Object[])this.params.getObject("warehouse");
                    StringBuffer warehsNumber = new StringBuffer();
                    for (int i = 0; i < warehsArray.length; ++i) {
                        WarehouseInfo warehouse = (WarehouseInfo)warehsArray[i];
                        if (i != 0) {
                            warehsNumber.append(",");
                        }
                        warehsNumber.append("'").append(warehouse.getNumber()).append("'");
                    }
                    if (warehsNumber.length() > 0) {
                        para.setString("warehouse", warehsNumber.toString());
                    }
                }
                para.setBoolean("IsJoinQuery", true);
            } else {
                para.setObject("warehouseFrom", this.params.getObject("warehouseFrom"));
                para.setObject("warehouseTo", this.params.getObject("warehouseTo"));
                para.setBoolean("IsJoinQuery", false);
            }
            para.setObject("voucher", this.params.getObject("voucher"));
            para.setBoolean("ckShowNoCalculate", this.params.getBoolean("ckShowNoCalculate"));
            para.setBoolean("noSelectNoneInOut", this.params.getBoolean("noSelectNoneInOut"));
            para.setBoolean("ckBxMShortName", this.params.getBoolean("ckBxMShortName"));
            para.setBoolean("noSelectStorageMoveBill", this.params.getBoolean("noSelectStorageMoveBill"));
            para.setBoolean("noSelectWarehouseMoveBill", this.params.getBoolean("noSelectWarehouseMoveBill"));
            RptParams rpt = StockDetailReportFacadeFactory.getRemoteInstance().createTempTable(para);
            this.setTempTable(rpt.getString("tempTable"));
            len = rpt.getInt("verticalCount");
            if (len > 0) {
                para.setString("tempTable", this.getTempTable());
                para.setString("isPrint", "true");
                RptParams rptRs = StockDetailReportFacadeFactory.getRemoteInstance().query(para, 0, len);
                this.currentRowSet = (RptRowSet)rptRs.getObject("printRs");
                this.calPrintEndData(this.currentRowSet);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void calPrintEndData(RptRowSet currentRowSet) throws EASBizException, BOSException {
        Map beforeRowMap = new HashMap();
        BigDecimal beforeEndAmount = BigDecimal.ZERO;
        BigDecimal beforeEndQty = BigDecimal.ZERO;
        BigDecimal curEndAmount = BigDecimal.ZERO;
        BigDecimal curEndQty = BigDecimal.ZERO;
        BigDecimal curInQty = BigDecimal.ZERO;
        BigDecimal curInAmount = BigDecimal.ZERO;
        BigDecimal curOutQty = BigDecimal.ZERO;
        BigDecimal curOutAmount = BigDecimal.ZERO;
        BigDecimal curEndPrice = BigDecimal.ZERO;
        String periodbegin = this.getResource("BEGINBALANCE");
        String periodTotal = this.getResource("PERIODTOTAL");
        String yearTotal = this.getResource("YEARTOTAL");
        String transactionTypeName = null;
        int prcPrecision = this.params.getInt("spinPricePrecission");
        while (currentRowSet.next()) {
            transactionTypeName = currentRowSet.getString("FTRANSACTIONTYPENAME");
            if (periodbegin.equals(transactionTypeName)) {
                beforeRowMap = currentRowSet.toRowMap();
                continue;
            }
            if (periodTotal.equals(transactionTypeName) || yearTotal.equals(transactionTypeName) || beforeRowMap == null || beforeRowMap.size() <= 0) continue;
            beforeEndQty = beforeRowMap.get("FREMAINQTY") == null ? BigDecimal.ZERO : (BigDecimal)beforeRowMap.get("FREMAINQTY");
            beforeEndAmount = beforeRowMap.get("FREMAINAMOUNT") == null ? BigDecimal.ZERO : (BigDecimal)beforeRowMap.get("FREMAINAMOUNT");
            curInQty = currentRowSet.getBigDecimal("FINQTY") == null ? BigDecimal.ZERO : currentRowSet.getBigDecimal("FINQTY");
            curOutQty = currentRowSet.getBigDecimal("FOUTQTY") == null ? BigDecimal.ZERO : currentRowSet.getBigDecimal("FOUTQTY");
            curInAmount = currentRowSet.getBigDecimal("FINAMOUNT") == null ? BigDecimal.ZERO : currentRowSet.getBigDecimal("FINAMOUNT");
            curOutAmount = currentRowSet.getBigDecimal("FOUTAMOUNT") == null ? BigDecimal.ZERO : currentRowSet.getBigDecimal("FOUTAMOUNT");
            curEndQty = beforeEndQty.subtract(curOutQty).add(curInQty);
            curEndAmount = beforeEndAmount.subtract(curOutAmount).add(curInAmount);
            curEndPrice = CalculateUtils.calActualPrice((BigDecimal)curEndAmount, (BigDecimal)curEndQty, (int)prcPrecision);
            currentRowSet.setValue("FREMAINQTY", (Object)curEndQty);
            currentRowSet.setValue("FREMAINAMOUNT", (Object)curEndAmount);
            currentRowSet.setValue("FREMAINUNITPRICE", (Object)curEndPrice);
            beforeRowMap = currentRowSet.toRowMap();
        }
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.changeMaterialID(6);
        this.query();
    }

    @Override
    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.changeMaterialID(9);
        this.query();
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.changeMaterialID(8);
        this.query();
    }

    @Override
    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.changeMaterialID(7);
        this.query();
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.checkObjectExists()) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    protected void tbl_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            ActionEvent evt = new ActionEvent(this.btnViewUI, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            actView.actionPerformed(evt);
        }
    }

    protected KDTable getTableForPrintSetting() {
        return this.tbl;
    }

    protected RptParams getParamsForInit() {
        RptParams initParam = new RptParams();
        return initParam;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        StockDetailReportConditionUI condUI = new StockDetailReportConditionUI();
        condUI.setSize(420, 510);
        return condUI;
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return StockDetailReportFacadeFactory.getRemoteInstance();
    }

    protected void query() {
        try {
            String PeriodFrom = String.valueOf(this.params.getInt("accPeriodYearFrom")) + "." + String.valueOf(this.params.getInt("accPeriodMonthFrom"));
            String PeriodTo = String.valueOf(this.params.getInt("accPeriodYearTo")) + "." + String.valueOf(this.params.getInt("accPeriodMonthTo"));
            this.txtPeriod.setText(PeriodFrom + " - " + PeriodTo);
            if (this.currentPKIndex == -1) {
                this.getMaterialPKList(this.params);
            } else if (this.currentPKIndex == -2) {
                this.pkCollection = new String[]{this.params.getString("CurrentMaterialID")};
            }
            this.getMaterialID();
            this.setChangeRecordButton();
            if (this.params.getObject("company") != null) {
                this.bizCompany.setValue((Object)((CompanyOrgUnitInfo)this.params.getObject("company")));
                this.companyName.setText(((CompanyOrgUnitInfo)this.params.getObject("company")).getName());
            } else {
                this.bizCompany.setValue(null);
                this.companyName.setText("");
            }
            if (this.params.getString("CurrentMaterialID") != null) {
                MaterialInfo aMaterialInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(this.params.getString("CurrentMaterialID")));
                this.bizMaterialName.setValue((Object)aMaterialInfo);
                this.materialName.setText(aMaterialInfo.getName());
                if (aMaterialInfo.getShortName() != null) {
                    this.txtMShortNameR.setText(aMaterialInfo.getShortName().toString());
                } else {
                    this.txtMShortNameR.setText("");
                }
                if (aMaterialInfo.getModel() != null) {
                    this.txtModel.setText(aMaterialInfo.getModel().toString());
                } else {
                    this.txtModel.setText("");
                }
                String unitID = aMaterialInfo.getBaseUnit().getId().toString();
                MeasureUnitInfo aMeasureUnitInfo = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(unitID));
                this.txtUnit.setText(aMeasureUnitInfo.toString());
            } else {
                this.bizMaterialName.setValue(null);
                this.txtMShortNameR.setText("");
                this.materialName.setText("");
            }
            if (this.params.getObject("calType") != null) {
                this.txtCalculateType.setText(((CalculateTypeEnum)this.params.getObject("calType")).getAlias());
            } else {
                this.txtCalculateType.setText("");
            }
            if (this.params.getObject("status") != null) {
                this.txtStatus.setText(((BillBaseStatusEnum)this.params.getObject("status")).getAlias());
            } else {
                this.txtStatus.setText("");
            }
            this.tbl.removeColumns();
            this.tbl.removeRows();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.initUIMainOrgContext(((CompanyOrgUnitInfo)this.params.getObject("company")).getId().toString());
        this.initUserConfig();
    }

    public void getData(KDTDataRequestEvent e) {
        try {
            IRow row;
            RptParams rpt;
            RptParams para = new RptParams();
            para.setInt("spinAmountPrecission", this.params.getInt("spinAmountPrecission"));
            para.setInt("spinPricePrecission", this.params.getInt("spinPricePrecission"));
            para.setInt("spinQtyPrecission", this.params.getInt("spinQtyPrecission"));
            this.tbl.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            if (this.lastRowNumber < from) {
                from = this.lastRowNumber;
                len = e.getLastRow() - from + 1;
            }
            this.lastRowNumber = e.getLastRow() + 1;
            if (this.params.getString("CurrentMaterialID") == null) {
                this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
                return;
            }
            para.setString("CurrentMaterialID", this.params.getString("CurrentMaterialID"));
            para.setObject("company", this.params.getObject("company"));
            if (this.params.getString("FStorageOrgUnit") != null) {
                para.setString("FStorageOrgUnit", this.params.getString("FStorageOrgUnit"));
            }
            if (this.params.getString("FWarehouse") != null) {
                para.setString("FWarehouse", this.params.getString("FWarehouse"));
            }
            if (from == 0) {
                para.setString("txtMShortNameFrom", this.params.getString("txtMShortNameFrom"));
                para.setString("txtMShortNameTo", this.params.getString("txtMShortNameTo"));
                para.setString("tempTable", this.getTempTable());
                para.setObject("materialFrom", this.params.getObject("materialFrom"));
                para.setObject("materialTo", this.params.getObject("materialTo"));
                para.setObject("calType", this.params.getObject("calType"));
                para.setObject("status", this.params.getObject("status"));
                para.setInt("accPeriodYearFrom", this.params.getInt("accPeriodYearFrom"));
                para.setInt("accPeriodMonthFrom", this.params.getInt("accPeriodMonthFrom"));
                para.setInt("accPeriodYearTo", this.params.getInt("accPeriodYearTo"));
                para.setInt("accPeriodMonthTo", this.params.getInt("accPeriodMonthTo"));
                if (this.getUIContext().get("RPTFilter") != null) {
                    if (this.params.getObject("warehouse") != null) {
                        Object[] warehsArray = (Object[])this.params.getObject("warehouse");
                        StringBuffer warehsNumber = new StringBuffer();
                        for (int i = 0; i < warehsArray.length; ++i) {
                            WarehouseInfo warehouse = (WarehouseInfo)warehsArray[i];
                            if (i != 0) {
                                warehsNumber.append(",");
                            }
                            warehsNumber.append("'").append(warehouse.getNumber()).append("'");
                        }
                        if (warehsNumber.length() > 0) {
                            para.setString("warehouse", warehsNumber.toString());
                        }
                    }
                    para.setBoolean("IsJoinQuery", true);
                } else {
                    para.setObject("warehouseFrom", this.params.getObject("warehouseFrom"));
                    para.setObject("warehouseTo", this.params.getObject("warehouseTo"));
                    para.setBoolean("IsJoinQuery", false);
                }
                if (this.params.getObject("storeType") != null) {
                    Object[] storeTypeArray = (Object[])this.params.getObject("storeType");
                    StringBuffer storeTypeNumber = new StringBuffer();
                    boolean flag = true;
                    for (int i = 0; i < storeTypeArray.length; ++i) {
                        StoreTypeInfo storeType = (StoreTypeInfo)storeTypeArray[i];
                        if (storeType == null) {
                            flag = false;
                            continue;
                        }
                        if (i != 0) {
                            storeTypeNumber.append(",");
                        }
                        storeTypeNumber.append("").append(storeType.getNumber()).append("");
                    }
                    if (storeTypeNumber.length() > 0 && flag) {
                        para.setString("storeType", storeTypeNumber.toString());
                    }
                }
                para.setObject("voucher", this.params.getObject("voucher"));
                para.setObject("prmtKAClass", this.params.getObject("prmtKAClass"));
                para.setBoolean("ckShowNoCalculate", this.params.getBoolean("ckShowNoCalculate"));
                para.setBoolean("noSelectNoneInOut", this.params.getBoolean("noSelectNoneInOut"));
                para.setBoolean("ckBxMShortName", this.params.getBoolean("ckBxMShortName"));
                para.setBoolean("noSelectStorageMoveBill", this.params.getBoolean("noSelectStorageMoveBill"));
                para.setBoolean("noSelectWarehouseMoveBill", this.params.getBoolean("noSelectWarehouseMoveBill"));
                para.setObject("bizType", this.params.getObject("bizType"));
                para.setObject("transactionType", this.params.getObject("transactionType"));
                rpt = StockDetailReportFacadeFactory.getRemoteInstance().createTempTable(para);
                this.setTempTable(rpt.getString("tempTable"));
                RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tbl);
                this.tbl.setRowCount(rpt.getInt("verticalCount"));
            }
            para.setString("tempTable", this.getTempTable());
            para.setString("isPrint", "false");
            rpt = StockDetailReportFacadeFactory.getRemoteInstance().query(para, from, len);
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            this.currentRowSet = (RptRowSet)rpt.getObject("printRs");
            KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.tbl);
            String sumType = null;
            int size = e.getLastRow();
            for (int i = from; i <= size && (row = this.tbl.getRow(i)) != null; ++i) {
                sumType = row.getCell("FIndex").getValue().toString();
                if ("0".equals(sumType)) continue;
                row.getStyleAttributes().setBackground(necessaryColor);
            }
            this.initUserConfig();
            this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void afterDataFill(int from, int last) throws EASBizException, BOSException {
        BigDecimal zero;
        String fieldName = null;
        int index_ix = 0;
        int beqty_ix = 0;
        int beprice_ix = 0;
        int beamt_ix = 0;
        int inqty_ix = 0;
        int inamt_ix = 0;
        int outqty_ix = 0;
        int outamt_ix = 0;
        int columnCount = this.tbl.getColumnCount();
        for (int c = 0; c < columnCount; ++c) {
            fieldName = this.tbl.getColumnKey(c).toLowerCase();
            if (fieldName.equals("ftransactiontype")) {
                index_ix = c;
            }
            if (fieldName.equals("fremainqty")) {
                beqty_ix = c;
            }
            if (fieldName.equals("fremainunitprice")) {
                beprice_ix = c;
            }
            if (fieldName.equals("fremainamount")) {
                beamt_ix = c;
            }
            if (fieldName.equals("finqty")) {
                inqty_ix = c;
            }
            if (fieldName.equals("finamount")) {
                inamt_ix = c;
            }
            if (fieldName.equals("foutqty")) {
                outqty_ix = c;
            }
            if (!fieldName.equals("foutamount")) continue;
            outamt_ix = c;
        }
        String beginOrgUnit = this.getResource("BEGINBALANCE");
        String endOrgUnit = this.getResource("PERIODTOTAL");
        String endOrgUnit2 = this.getResource("YEARTOTAL");
        Object upObj = null;
        IRow row = null;
        IRow uprow = null;
        String scale = null;
        String up = null;
        BigDecimal beginQty = zero = new BigDecimal(0);
        BigDecimal beginAmt = zero;
        BigDecimal upQty = zero;
        BigDecimal upAmt = zero;
        BigDecimal inQty = zero;
        BigDecimal inAmt = zero;
        BigDecimal outQty = zero;
        BigDecimal outAmt = zero;
        BigDecimal endQty = zero;
        BigDecimal endAmt = zero;
        for (int i = from; i <= last; ++i) {
            row = this.tbl.getRow(i);
            if (row == null) {
                return;
            }
            if (row.getCell(index_ix) == null || row.getCell(beqty_ix) == null || row.getCell(beprice_ix) == null || row.getCell(beamt_ix) == null || row.getCell(inqty_ix) == null || row.getCell(inamt_ix) == null || row.getCell(outqty_ix) == null || row.getCell(outamt_ix) == null) {
                return;
            }
            Object scaleObj = row.getCell(index_ix).getValue();
            if (scaleObj == null) continue;
            scale = scaleObj.toString();
            if (beginOrgUnit != null && beginOrgUnit.equals(scale)) {
                if (i == last) {
                    this.remaindQty = row.getCell(beqty_ix).getValue() == null ? zero : (BigDecimal)row.getCell(beqty_ix).getValue();
                    this.remaindAmt = row.getCell(beamt_ix).getValue() == null ? zero : (BigDecimal)row.getCell(beamt_ix).getValue();
                } else {
                    beginQty = row.getCell(beqty_ix).getValue() == null ? zero : (BigDecimal)row.getCell(beqty_ix).getValue();
                    BigDecimal bigDecimal = beginAmt = row.getCell(beamt_ix).getValue() == null ? zero : (BigDecimal)row.getCell(beamt_ix).getValue();
                }
            }
            if (beginOrgUnit == null || endOrgUnit == null || beginOrgUnit.equals(scale) || endOrgUnit.equals(scale) || endOrgUnit2.equals(scale)) continue;
            uprow = this.tbl.getRow(i - 1);
            if (uprow != null && uprow.getCell(index_ix) != null) {
                upObj = uprow.getCell(index_ix).getValue();
            }
            if (upObj != null) {
                up = upObj.toString();
                if (beginOrgUnit.equals(up)) {
                    if (beginQty.compareTo(new BigDecimal("0.00")) > 0) {
                        upQty = beginQty;
                        upAmt = beginAmt;
                    } else if (this.remaindQty.compareTo(new BigDecimal("0.00")) > 0) {
                        upQty = this.remaindQty;
                        upAmt = this.remaindAmt;
                        this.remaindQty = new BigDecimal("0.00");
                        this.remaindAmt = new BigDecimal("0.00");
                    }
                } else {
                    upQty = uprow.getCell(beqty_ix).getValue() == null ? zero : (BigDecimal)uprow.getCell(beqty_ix).getValue();
                    upAmt = uprow.getCell(beamt_ix).getValue() == null ? zero : (BigDecimal)uprow.getCell(beamt_ix).getValue();
                }
            }
            inQty = row.getCell(inqty_ix).getValue() == null ? zero : (BigDecimal)row.getCell(inqty_ix).getValue();
            inAmt = row.getCell(inamt_ix).getValue() == null ? zero : (BigDecimal)row.getCell(inamt_ix).getValue();
            outQty = row.getCell(outqty_ix).getValue() == null ? zero : (BigDecimal)row.getCell(outqty_ix).getValue();
            outAmt = row.getCell(outamt_ix).getValue() == null ? zero : (BigDecimal)row.getCell(outamt_ix).getValue();
            endQty = upQty.add(inQty).subtract(outQty);
            endAmt = upAmt.add(inAmt).subtract(outAmt);
            int prcPrecision = 2;
            if (this.params.getString("CurrentMaterialID") != null) {
                MaterialInfo aMaterialInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(this.params.getString("CurrentMaterialID")));
                prcPrecision = aMaterialInfo.getPricePrecision();
            }
            row.getCell(beqty_ix).setValue((Object)endQty);
            row.getCell(beamt_ix).setValue((Object)endAmt);
            row.getCell(beprice_ix).setValue((Object)CalculateUtils.calActualPrice((BigDecimal)endAmt, (BigDecimal)endQty, (int)prcPrecision));
        }
    }

    private String getResource(String key) {
        return EASResource.getString((String)AUTO_GENERATE_RESOURCE, (String)key);
    }

    private void getMaterialPKList(RptParams params) throws EASBizException, BOSException {
        this.pkCollection = StockDetailReportFacadeFactory.getRemoteInstance().getMaterialPKArray(params);
    }

    private Object getCurrentPKInCollection() {
        if (this.pkCollection == null) {
            this.currentPKIndex = -1;
            return null;
        }
        if (this.pkCollection.length <= 0) {
            this.currentPKIndex = -1;
            return null;
        }
        if (this.pkCollection.length >= 1 && this.currentPKIndex >= this.pkCollection.length) {
            this.currentPKIndex = this.pkCollection.length - 1;
        } else if (this.currentPKIndex <= 0) {
            this.currentPKIndex = 0;
        }
        return this.pkCollection[this.currentPKIndex];
    }

    private void changeMaterialID(int changeAction) throws BOSException, EASBizException {
        switch (changeAction) {
            case 6: {
                this.currentPKIndex = 0;
                break;
            }
            case 7: {
                --this.currentPKIndex;
                break;
            }
            case 8: {
                ++this.currentPKIndex;
                break;
            }
            case 9: {
                if (this.pkCollection == null) {
                    return;
                }
                if (this.pkCollection.length == 0) {
                    return;
                }
                this.currentPKIndex = this.pkCollection.length - 1;
            }
        }
    }

    private void getMaterialID() {
        String matID = null;
        Object pk = null;
        try {
            if (this.currentPKIndex != -2) {
                if (this.currentPKIndex == -1) {
                    this.changeMaterialID(6);
                }
                if ((pk = this.getCurrentPKInCollection()) != null) {
                    matID = pk.toString();
                }
                this.params.setString("CurrentMaterialID", matID);
            }
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    private void setChangeRecordButton() {
        if (this.pkCollection == null) {
            this.btnFirst.setEnabled(false);
            this.btnPre.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
            this.menuItemFirst.setEnabled(false);
            this.menuItemPre.setEnabled(false);
            this.menuItemNext.setEnabled(false);
            this.menuItemLast.setEnabled(false);
        } else if (this.pkCollection.length <= 1) {
            this.btnFirst.setEnabled(false);
            this.btnPre.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
            this.menuItemFirst.setEnabled(false);
            this.menuItemPre.setEnabled(false);
            this.menuItemNext.setEnabled(false);
            this.menuItemLast.setEnabled(false);
        } else if (this.currentPKIndex <= 0) {
            this.btnFirst.setEnabled(false);
            this.btnPre.setEnabled(false);
            this.btnNext.setEnabled(true);
            this.btnLast.setEnabled(true);
            this.menuItemFirst.setEnabled(false);
            this.menuItemPre.setEnabled(false);
            this.menuItemNext.setEnabled(true);
            this.menuItemLast.setEnabled(true);
        } else if (this.currentPKIndex >= this.pkCollection.length - 1) {
            this.btnFirst.setEnabled(true);
            this.btnPre.setEnabled(true);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
            this.menuItemFirst.setEnabled(true);
            this.menuItemPre.setEnabled(true);
            this.menuItemNext.setEnabled(false);
            this.menuItemLast.setEnabled(false);
        } else {
            this.btnFirst.setEnabled(true);
            this.btnPre.setEnabled(true);
            this.btnNext.setEnabled(true);
            this.btnLast.setEnabled(true);
            this.menuItemFirst.setEnabled(true);
            this.menuItemPre.setEnabled(true);
            this.menuItemNext.setEnabled(true);
            this.menuItemLast.setEnabled(true);
        }
    }

    protected String getSelectedKeyValue() {
        KDTSelectBlock selectBlock = this.tbl.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tbl.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(this.getKeyFieldName());
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if (!((keyValue = cell.getValue()) == null || keyValue.equals("0") || keyValue.equals(" ") || keyValue.equals(""))) {
                return keyValue.toString();
            }
            return null;
        }
        return null;
    }

    protected String getCellValue(String cellField) {
        KDTSelectBlock selectBlock = this.tbl.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tbl.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(cellField);
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    private String getKeyFieldName() {
        return "FID";
    }

    private String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        RealModeIDList idList = new RealModeIDList();
        idList.add(this.getSelectedKeyValue());
        uiContext.put((Object)"IDList", (Object)idList);
    }

    private String getEditUIName() {
        int sortType = new Integer(this.getCellValue("FBillType"));
        switch (sortType) {
            case 0: {
                return PurInWarehsBillEditUI.class.getName();
            }
            case 1: {
                return PurInWarehsBillEditUI.class.getName();
            }
            case 2: {
                return ManufactureRecBillEditUI.class.getName();
            }
            case 3: {
                return MoveInWarehsBillEditUI.class.getName();
            }
            case 4: {
                return OtherInWarehsBillEditUI.class.getName();
            }
            case 5: {
                return SaleIssueBillEditUI.class.getName();
            }
            case 6: {
                return MaterialReqBillEditUI.class.getName();
            }
            case 7: {
                return MoveIssueBillEditUI.class.getName();
            }
            case 8: {
                return OtherIssueBillEditUI.class.getName();
            }
            case 9: {
                return CostAdjustBillEditUI.class.getName();
            }
            case 10: {
                return StandardCostAdjBillEditUI.class.getName();
            }
            case 11: {
                return OtherBillEditUI.class.getName();
            }
        }
        return PurInWarehsBillEditUI.class.getName();
    }

    private ICoreBase getBizInterface() throws Exception {
        int sortType = new Integer(this.getCellValue("FBillType"));
        switch (sortType) {
            case 0: {
                return PurInWarehsBillFactory.getRemoteInstance();
            }
            case 1: {
                return PurInWarehsBillFactory.getRemoteInstance();
            }
            case 2: {
                return ManufactureRecBillFactory.getRemoteInstance();
            }
            case 3: {
                return MoveInWarehsBillFactory.getRemoteInstance();
            }
            case 4: {
                return OtherInWarehsBillFactory.getRemoteInstance();
            }
            case 5: {
                return SaleIssueBillFactory.getRemoteInstance();
            }
            case 6: {
                return MaterialReqBillFactory.getRemoteInstance();
            }
            case 7: {
                return MoveIssueBillFactory.getRemoteInstance();
            }
            case 8: {
                return OtherIssueBillFactory.getRemoteInstance();
            }
            case 9: {
                return CostAdjustBillFactory.getRemoteInstance();
            }
            case 10: {
                return StandardCostAdjBillFactory.getRemoteInstance();
            }
            case 11: {
                return OtherBillFactory.getRemoteInstance();
            }
        }
        return PurInWarehsBillFactory.getRemoteInstance();
    }

    private void checkSelected() {
        if (this.tbl.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private boolean checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return false;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        return true;
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("RPTFilter") != null) {
            this.params = (RptParams)this.getUIContext().get("RPTFilter");
            this.btnFirst.setVisible(false);
            this.btnPre.setVisible(false);
            this.btnNext.setVisible(false);
            this.btnLast.setVisible(false);
            this.btnQuery.setVisible(false);
            this.menuItemFirst.setVisible(false);
            this.menuItemPre.setVisible(false);
            this.menuItemNext.setVisible(false);
            this.menuItemLast.setVisible(false);
            this.menuItemQuery.setVisible(false);
            this.currentPKIndex = -2;
            super.initWorkButton();
            this.init();
            super.onLoad();
            this.txtMShortNameR.setEnabled(false);
            if (!this.params.getBoolean("ckBxMShortName")) {
                this.kDLabelContainer8.setVisible(false);
            } else {
                this.kDLabelContainer8.setVisible(true);
            }
        } else {
            super.onLoad();
            this.txtMShortNameR.setEnabled(false);
            if (!this.params.getBoolean("ckBxMShortName")) {
                this.kDLabelContainer8.setVisible(false);
            } else {
                this.kDLabelContainer8.setVisible(true);
            }
        }
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        String res = "com.kingdee.eas.scm.cal.CalRptResource";
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)res, (String)"FICU")).append("&[Company]").append("&|");
        sb.append(EASResource.getString((String)res, (String)"YEARPERIOD")).append("&[Period]").append("&|");
        sb.append(EASResource.getString((String)res, (String)"MATERIELCODE")).append("&[MATERIELCODE]").append("&|");
        sb.append(EASResource.getString((String)res, (String)"MATERIELNAME")).append("&[MATERIELNAME]").append("&|");
        sb.append(EASResource.getString((String)res, (String)"MODEL")).append("&[MODEL]").append("&|");
        sb.append(EASResource.getString((String)res, (String)"BASEUNIT")).append("&[BASEUNIT]").append("&|\r\n");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        if (this.params.getString("CurrentMaterialID") == null) {
            return null;
        }
        MaterialInfo aMaterialInfo = null;
        MeasureUnitInfo aMeasureUnitInfo = null;
        String PeriodFrom = String.valueOf(this.params.getInt("accPeriodYearFrom")) + "." + String.valueOf(this.params.getInt("accPeriodMonthFrom"));
        String PeriodTo = String.valueOf(this.params.getInt("accPeriodYearTo")) + "." + String.valueOf(this.params.getInt("accPeriodMonthTo"));
        try {
            aMaterialInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(this.params.getString("CurrentMaterialID")), SCMSelectorFactory.getMaterialInfoSelector());
            String unitID = aMaterialInfo.getBaseUnit().getId().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            aMeasureUnitInfo = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(unitID), sic);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Company", ":" + ((CompanyOrgUnitInfo)this.params.getObject("company")).getName());
        map.put("Period", ":" + PeriodFrom + " - " + PeriodTo);
        map.put("MATERIELCODE", ":" + aMaterialInfo.getNumber());
        map.put("MATERIELNAME", ":" + aMaterialInfo.getName());
        map.put("MODEL", ":" + aMaterialInfo.getModel());
        map.put("BASEUNIT", ":" + aMeasureUnitInfo.getName());
        return map;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected void invokePrintFunction(boolean isPrint, ActionEvent e) throws Exception {
        StockDeailReportDataProvider data = new StockDeailReportDataProvider();
        if (isPrint) {
            if (this.pkCollection == null || this.pkCollection.length == 0) {
                MsgBox.showError((String)EASResource.getString((String)(AUTO_GENERATE_RESOURCE + ".DATA_BLANK")));
                SysUtil.abort();
                data.insertDataToDynamicRowSet(this.params, this.currentRowSet);
            } else {
                int tempPKIndex = this.currentPKIndex;
                this.currentPKIndex = -1;
                for (int i = 0; i < this.pkCollection.length; ++i) {
                    this.getPrintData();
                    data.insertDataToDynamicRowSet(this.params, this.currentRowSet);
                }
                this.currentPKIndex = tempPKIndex - 1;
            }
        } else if (this.pkCollection != null && this.pkCollection.length != 0) {
            --this.currentPKIndex;
            this.getPrintData();
            data.insertDataToDynamicRowSet(this.params, this.currentRowSet);
        } else {
            MsgBox.showError((String)EASResource.getString((String)(AUTO_GENERATE_RESOURCE + ".DATA_BLANK")));
            SysUtil.abort();
        }
        if (this.getTDFileName() == null) {
            return;
        }
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPrint) {
            appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    public Object getTablePreferenceSchemaKey() {
        QuerySolutionInfo currentSolutionInfo;
        Object obj = super.getTablePreferenceSchemaKey();
        if (obj == null && (currentSolutionInfo = this.queryDialog.getCommonQueryParam().getCurrentSolutionInfo()) != null) {
            obj = currentSolutionInfo.getId();
        }
        return obj;
    }

    protected String getTDFileName() {
        return "/FI/CAL/StockDetailReport";
    }

    protected String getUIFullName() {
        return "com.kingdee.eas.scm.cal.client.StockDetailReportUI";
    }

    public boolean isAsynchronism() {
        return true;
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        try {
            CommRptBaseConditionUI pc;
            ArrayList<String> visibleName = new ArrayList<String>();
            visibleName.add("qty");
            visibleName.add("price");
            visibleName.add("amount");
            if (this.userPanel == null) {
                this.userPanel = this.getCustomerQueryPanel();
                ReportQueryConditionHelper.initQueryDialog((CustomerQueryPanel)((CommRptBaseConditionUI)this.userPanel), (CommonQueryDialog)this.queryDialog, (Map)this.getUIContext(), (IMetaDataPK)this.getQueryMetaDataPK(), (String)((Object)((Object)this)).getClass().getName(), (RptParams)this.params, (RptParams)this.getUIContextInitParams(), visibleName, (boolean)true);
            }
            CustomerParams cp = ReportQueryConditionHelper.getDefaultCustomerParams((boolean)useDefaultSolution, (CustomerQueryPanel)this.userPanel, (CoreUI)this, (IMetaDataPK)this.getQueryMetaDataPK());
            boolean ok = false;
            if ((this.params == null && cp == null || !useDefaultSolution) && this.queryDialog.show()) {
                CommRptBaseConditionUI rbqp = (CommRptBaseConditionUI)this.queryDialog.getUserPanel(0);
                pc = (CommRptBaseConditionUI)this.queryDialog.getUserPanel(1);
                this.params = rbqp.getCustomCondition();
                if (pc != null) {
                    this.params.putAll(pc.getCustomCondition().toMap());
                }
                ok = true;
            }
            if (cp != null) {
                CommRptBaseConditionUI rptConditionUI = this.getQueryDialogUserPanel();
                rptConditionUI.initUIContentLayout();
                rptConditionUI.onInit(this.getUIContextInitParams());
                rptConditionUI.onLoad();
                rptConditionUI.loadFields();
                rptConditionUI.setCustomerParams(cp);
                rptConditionUI.loadData(null);
                this.params = rptConditionUI.getCustomCondition();
                pc = (CommRptBaseConditionUI)this.queryDialog.getCommonQueryParam().getPanels().get(1);
                if (pc != null) {
                    pc.clear();
                    this.params.putAll(pc.getCustomCondition().toMap());
                }
            }
            if (this.params != null && (ok || useDefaultSolution)) {
                this.queryWithWrap();
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }
}

