/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.CalRptUtilFacadeFactory;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.ICalRptUtilFacade;
import com.kingdee.eas.scm.cal.SumTypeEnum;
import com.kingdee.eas.scm.cal.VoucheredEnum;
import com.kingdee.eas.scm.cal.client.AbstractStockGatherReportConditionUI;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.sd.sale.report.ISaleGrossProfits;
import com.kingdee.eas.scm.sd.sale.report.SaleGrossProfitsFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class StockGatherReportConditionUI
extends AbstractStockGatherReportConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(StockGatherReportConditionUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.cal.CalCommonResource";
    private static final String objectTypeID = "7ac99937-00fb-1000-e000-0002c0a81345B999CA39";
    private CompanyOrgUnitInfo curCompany = null;
    private OrgUnitInfo[] mainOrgs = null;
    private int idxDefaultMainOrg = -1;
    private boolean isSetCustomCondition = false;
    private int materialGroupMaxLevel = 0;
    private ItemListener cmbSumTypeListener;
    private F7ContextManager f7Manger = null;

    public StockGatherReportConditionUI() throws Exception {
        this.getGroupMaxLevel();
        if (this.cmbSumTypeListener != null) {
            this.cmbSumType.removeItemListener(this.cmbSumTypeListener);
        }
        if (this.cmbSumTypeListener == null) {
            this.cmbSumTypeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        StockGatherReportConditionUI.this.cmbSumTypeListener_itemStateChanged(e);
                    }
                    catch (Exception exc) {
                        StockGatherReportConditionUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.cmbSumType.addItemListener(this.cmbSumTypeListener);
        SpinnerModel sm = this.kdsMaterialGroupLevel.getModel();
        SpinnerNumberModel nm = (SpinnerNumberModel)sm;
        nm.setMaximum(new Integer(this.materialGroupMaxLevel));
        nm.setMinimum(new Integer(1));
        nm.setValue(new Integer(1));
        this.kDLabelContainer3.setVisible(false);
        this.f7Manger = new F7ContextManager((Component)((Object)this), OrgType.Company, 1);
    }

    protected void cmbSumTypeListener_itemStateChanged(ItemEvent e) throws Exception {
        Object selectedItem = this.cmbSumType.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        SumTypeEnum sumType = (SumTypeEnum)((Object)selectedItem);
        if (sumType.equals((Object)SumTypeEnum.MATERIALGROUPLEVEL)) {
            this.kDLabelContainer3.setVisible(true);
        } else {
            this.kDLabelContainer3.setVisible(false);
        }
    }

    private void getGroupMaxLevel() {
        try {
            ISaleGrossProfits reportFacade = SaleGrossProfitsFactory.getRemoteInstance();
            int[] levels = reportFacade.getMaxLevels();
            this.materialGroupMaxLevel = levels[1];
        }
        catch (Exception exp) {
            this.handUIException(exp);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtKAClass.setEnabledMultiSelection(true);
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameFrom.setEditable(false);
        this.txtMShortNameTo.setText(null);
        this.txtMShortNameTo.setEditable(false);
        this.bizWarehouse.setEnabledMultiSelection(true);
        this.bizMaterialID.setCommitParser(null);
        this.bizMaterialIDTo.setCommitParser(null);
        this.f7Manger.registerBizMaterialF7(this.bizMaterialID, null, null, null, true);
        this.f7Manger.registerBizMaterialF7(this.bizMaterialIDTo, null, null, null, false);
        CalculateClientUtil.addListenerForMultiF7(this.bizMaterialID, this.bizMaterialIDTo);
        this.bizWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQueryForCal");
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.bizMaterialID, this.bizMaterialIDTo});
        this.registerStoreTypeFilter(this.bizStoreType);
        this.bizStoreType.setEnabledMultiSelection(true);
    }

    private void registerStoreTypeFilter(KDBizPromptBox box) throws Exception {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isForwardAmt", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
        ev.setFilter(filter);
        box.setEntityViewInfo(ev);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        SCMClientUtils.setMainBizOrgCompF7forSealUp((KDBizPromptBox)this.bizOrgUnit, (OrgType)this.getMainBizOrgType(), (String)this.getViewPermission());
        this.addKAClassListener();
        this.loadSumTypeEnum((JComboBox)this.cmbSumType);
        this.loadStatusEnum((JComboBox)this.cmbStatus);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void bizOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        if (!this.isSetCustomCondition) {
            if (this.bizOrgUnit.getData() != null) {
                this.loadAccountPeriod((CompanyOrgUnitInfo)this.bizOrgUnit.getData());
            }
            this.curCompany = (CompanyOrgUnitInfo)this.bizOrgUnit.getData();
            if (this.curCompany != null) {
                this.bizMaterialID.setEnabled(true);
                this.bizMaterialIDTo.setEnabled(true);
            } else {
                this.bizMaterialID.setEnabled(false);
                this.bizMaterialIDTo.setEnabled(false);
            }
            this.bizWarehouse.setValue(null);
        }
        if (this.curCompany != null) {
            this.setKAClassF7(this.curCompany);
            this.f7Manger.changeF7Context(this.curCompany.getId().toString());
        }
        CalculateClientUtil.setWareHouseEntity(this.bizOrgUnit, null, this.bizWarehouse, true);
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        para.setObject("company", this.bizOrgUnit.getValue());
        para.setObject("materialFrom", this.bizMaterialID.getValue());
        para.setObject("materialTo", this.bizMaterialIDTo.getValue());
        para.setObject("sumType", this.cmbSumType.getSelectedItem());
        para.setBoolean("onlyViewSumRow", this.chkOnlyViewSumRow.isSelected());
        para.setInt("accPeriodYearFrom", this.spAccPeriodYear.getIntegerVlaue().intValue());
        para.setInt("accPeriodMonthFrom", this.spAccPeriodMonth.getIntegerVlaue().intValue());
        para.setInt("accPeriodYearTo", this.spAccPeriodYearTo.getIntegerVlaue().intValue());
        para.setInt("accPeriodMonthTo", this.spAccPeriodMonthTo.getIntegerVlaue().intValue());
        para.setObject("warehouse", this.bizWarehouse.getValue());
        para.setObject("voucher", this.cmbVoucher.getSelectedItem());
        para.setBoolean("noSelectStorageMoveBill", this.noSelectStorageMoveBill.isSelected());
        para.setBoolean("noSelectWarehouseMoveBill", this.noSelectWarehouseMoveBill.isSelected());
        para.setBoolean("ckShowNoCalculate", this.ckShowNoCalculate.isSelected());
        para.setObject("status", this.cmbStatus.getSelectedItem());
        para.setObject("prmtKAClass", this.prmtKAClass.getValue());
        para.setInt("materialGroupLevel", this.kdsMaterialGroupLevel.getIntegerVlaue().intValue());
        para.setBoolean("ckBxMShortName", this.ckBxMShortName.isSelected());
        para.setObject("txtMShortNameFrom", (Object)this.txtMShortNameFrom.getText().trim().replaceAll("'", "''"));
        para.setObject("txtMShortNameTo", (Object)this.txtMShortNameTo.getText().trim().replaceAll("'", "''"));
        para.setBoolean("NoInOrOutNoShow", this.ChkIsShowNoInOrOutData.isSelected());
        para.setInt("ShowBalanceCondition", this.cmbShowCondition.getSelectedIndex());
        para.setObject("storeType", this.bizStoreType.getValue());
        return para;
    }

    public void setCustomCondition(RptParams params) {
        this.isSetCustomCondition = true;
        int balanceCondition = 0;
        this.bizOrgUnit.setValue(params.getObject("company"));
        this.bizMaterialID.setValue(params.getObject("materialFrom"));
        this.bizMaterialIDTo.setValue(params.getObject("materialTo"));
        this.cmbSumType.setSelectedItem(params.getObject("sumType"));
        this.chkOnlyViewSumRow.setSelected(params.getBoolean("onlyViewSumRow"));
        this.spAccPeriodYear.setValue((Object)new Integer(params.getInt("accPeriodYearFrom")));
        this.spAccPeriodMonth.setValue((Object)new Integer(params.getInt("accPeriodMonthFrom")));
        this.spAccPeriodYearTo.setValue((Object)new Integer(params.getInt("accPeriodYearTo")));
        this.spAccPeriodMonthTo.setValue((Object)new Integer(params.getInt("accPeriodMonthTo")));
        this.bizWarehouse.setValue(params.getObject("warehouse"));
        this.cmbVoucher.setSelectedItem(params.getObject("voucher"));
        this.noSelectStorageMoveBill.setSelected(params.getBoolean("noSelectStorageMoveBill"));
        this.noSelectWarehouseMoveBill.setSelected(params.getBoolean("noSelectWarehouseMoveBill"));
        this.ckShowNoCalculate.setSelected(params.getBoolean("ckShowNoCalculate"));
        this.cmbStatus.setSelectedItem(params.getObject("status"));
        this.prmtKAClass.setValue(params.getObject("prmtKAClass"));
        if (params.getObject("materialGroupLevel") != null) {
            this.kdsMaterialGroupLevel.setValue((Object)new Integer(params.getInt("materialGroupLevel")));
        }
        if (params.getObject("ckBxMShortName") != null) {
            this.ckBxMShortName.setSelected(params.getBoolean("ckBxMShortName"));
            if (this.ckBxMShortName.isSelected()) {
                this.txtMShortNameFrom.setEditable(true);
                this.txtMShortNameFrom.setText(params.getString("txtMShortNameFrom").trim().replaceAll("''", "'"));
                this.txtMShortNameTo.setEditable(true);
                this.txtMShortNameTo.setText(params.getString("txtMShortNameTo").trim().replaceAll("''", "'"));
            }
        } else {
            this.ckBxMShortName.setSelected(false);
            this.txtMShortNameFrom.setEditable(false);
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setEditable(false);
            this.txtMShortNameTo.setText(null);
        }
        this.ChkIsShowNoInOrOutData.setSelected(params.getBoolean("NoInOrOutNoShow"));
        if (params.containsKey("ShowBalanceCondition")) {
            balanceCondition = params.getInt("ShowBalanceCondition");
        }
        this.cmbShowCondition.setSelectedIndex(balanceCondition);
        this.isSetCustomCondition = false;
        this.bizStoreType.setValue(params.getObject("storeType"));
    }

    private void loadAccountPeriod(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        ICalRptUtilFacade iCalRptUtil;
        Object[] reslut;
        if (companyInfo != null) {
            PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            if (periodInfo == null) {
                this.bizOrgUnit.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTSTART);
            }
            if (curPeriodInfo == null) {
                this.bizOrgUnit.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTCURRENT);
            }
        }
        if ((reslut = (iCalRptUtil = CalRptUtilFacadeFactory.getRemoteInstance()).fetchInitFilterData(companyInfo.getId().toString())) != null) {
            CalculateUtil.AccountPeriodInfo actPeriodInfo = (CalculateUtil.AccountPeriodInfo)reslut[1];
            CalculateUtil.appliesPeriodControl(this.spAccPeriodYear, this.spAccPeriodYearTo, this.spAccPeriodMonth, this.spAccPeriodMonthTo, actPeriodInfo, true, false);
        }
    }

    private void setKAClassF7(CompanyOrgUnitInfo companyOrg) {
        if (companyOrg != null) {
            String companyID = companyOrg.getId().toString();
            if (companyOrg.getAccountTable() == null) {
                return;
            }
            String accountTableID = companyOrg.getAccountTable().getId().toString();
            this.prmtKAClass.setValue(null);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("objectType.id", (Object)objectTypeID, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("accountTableId.id", (Object)accountTableID, CompareType.EQUALS));
            filterInfo.setMaskString("#0 and #1 and #2");
            viewInfo.setFilter(filterInfo);
            this.prmtKAClass.setEntityViewInfo(viewInfo);
        }
    }

    private void loadSumTypeEnum(JComboBox cb) {
        DefaultComboBoxModel<SumTypeEnum> model = new DefaultComboBoxModel<SumTypeEnum>();
        Iterator i = SumTypeEnum.iterator();
        while (i.hasNext()) {
            SumTypeEnum e = (SumTypeEnum)((Object)i.next());
            model.addElement(e);
        }
        cb.setModel(model);
    }

    private void loadStatusEnum(JComboBox cb) {
        DefaultComboBoxModel<BillBaseStatusEnum> model = new DefaultComboBoxModel<BillBaseStatusEnum>();
        model.addElement(BillBaseStatusEnum.NULL);
        model.addElement(BillBaseStatusEnum.SUBMITED);
        model.addElement(BillBaseStatusEnum.AUDITED);
        cb.setModel(model);
    }

    public boolean verify() {
        int periodTo;
        int yearTo;
        int periodfrom;
        if (this.bizOrgUnit.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"COMPANY_NOTNULL"));
            return false;
        }
        int yearFrom = this.spAccPeriodYear.getIntegerVlaue();
        if (100 * yearFrom + (periodfrom = this.spAccPeriodMonth.getIntegerVlaue().intValue()) > 100 * (yearTo = this.spAccPeriodYearTo.getIntegerVlaue().intValue()) + (periodTo = this.spAccPeriodMonthTo.getIntegerVlaue().intValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"PERIOD_BEGIN_NOTBIG_END"));
            return false;
        }
        return true;
    }

    public void clear() {
        super.clear();
        this.bizMaterialID.setValue(null);
        this.bizMaterialIDTo.setValue(null);
        this.bizOrgUnit.setValue(null);
        this.spAccPeriodYear.setValue((Object)new Integer(0));
        this.spAccPeriodMonth.setValue((Object)new Integer(0));
        this.spAccPeriodYearTo.setValue((Object)new Integer(0));
        this.spAccPeriodMonthTo.setValue((Object)new Integer(0));
        this.cmbSumType.setSelectedItem((Object)SumTypeEnum.CALCULATETYPE);
        this.cmbStatus.setSelectedItem((Object)BillBaseStatusEnum.AUDITED);
        this.chkOnlyViewSumRow.setSelected(false);
        this.bizWarehouse.setValue(null);
        this.cmbVoucher.setSelectedItem((Object)VoucheredEnum.Null);
        this.noSelectStorageMoveBill.setSelected(false);
        this.noSelectWarehouseMoveBill.setSelected(false);
        this.ckShowNoCalculate.setSelected(false);
        this.prmtKAClass.setValue(null);
        this.ckBxMShortName.setSelected(false);
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
        this.kdsMaterialGroupLevel.setValue((Object)new Integer(1));
        this.ChkIsShowNoInOrOutData.setSelected(false);
        this.cmbShowCondition.setSelectedIndex(-1);
        try {
            this.curCompany = (CompanyOrgUnitInfo)this.getDefaultMainBizOrg();
            if (this.curCompany != null && this.curCompany.isIsBizUnit()) {
                this.bizOrgUnit.setData((Object)this.curCompany);
            } else {
                this.bizOrgUnit.setData(null);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.bizStoreType.setValue(null);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.bizOrgUnit;
    }

    protected String getViewPermission() {
        return "stockgatherreport_view";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected void addKAClassListener() {
        this.prmtKAClass.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (StockGatherReportConditionUI.this.bizOrgUnit.getValue() == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)StockGatherReportConditionUI.resClassName, (String)"COMPANY_NOTNULL"));
                    SysUtil.abort();
                }
            }
        });
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        CompanyOrgUnitInfo currentMainOrg = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        try {
            if (currentMainOrg.isIsBizUnit() && SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)this.getMainBizOrgType(), (IObjectPK)new ObjectStringPK(currentMainOrg.getId().toString()), (String)this.getViewPermission())) {
                return currentMainOrg;
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return null;
    }

    @Override
    protected void ckBxMShortName_stateChanged(ChangeEvent e) throws Exception {
        if (this.ckBxMShortName.isSelected()) {
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
            this.txtMShortNameFrom.setEditable(true);
            this.txtMShortNameTo.setEditable(true);
        } else {
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
            this.txtMShortNameFrom.setEditable(false);
            this.txtMShortNameTo.setEditable(false);
        }
    }

    private void addF7SelectorListener(KDBizPromptBox[] f7s) {
        for (int i = 0; i < f7s.length; ++i) {
            f7s[i].addSelectorListener(new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    if (StockGatherReportConditionUI.this.getMainBizOrgF7() != null) {
                        return;
                    }
                    Object value = StockGatherReportConditionUI.this.getMainBizOrgF7().getValue();
                    if (value == null || value instanceof Object[] && ((Object[])value).length == 0 || value instanceof Object[] && ((Object[])value)[0] == null) {
                        MsgBox.showInfo((String)SCMGroupClientUtils.getMainOrgNullMsg((OrgType)OrgType.Company));
                        StockGatherReportConditionUI.this.getMainBizOrgF7().requestFocus();
                        SysUtil.abort();
                    }
                }
            });
        }
    }

    protected void setNeedMainOrgF7s(KDBizPromptBox[] f7s) {
        this.addF7SelectorListener(f7s);
        this.f7Manger.setPrmtNeedOrgF7s(f7s);
    }
}

