/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.cal.StockGatherReportFacadeFactory;
import com.kingdee.eas.scm.cal.SumTypeEnum;
import com.kingdee.eas.scm.cal.client.AbstractStockGatherReportUI;
import com.kingdee.eas.scm.cal.client.StockDetailReportUI;
import com.kingdee.eas.scm.cal.client.StockGatherReportConditionUI;
import com.kingdee.eas.scm.common.util.ReportQueryConditionHelper;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class StockGatherReportUI
extends AbstractStockGatherReportUI {
    private static final Logger logger = CoreUIObject.getLogger(StockGatherReportUI.class);
    private static final String permItem_print = "stockgatherreport_print";
    public static final Color necessaryColor = new Color(252, 251, 223);

    public StockGatherReportUI() throws Exception {
        this.tbl.setEditable(false);
        this.tbl.getActionMap().remove("Delete");
        this.btnViewUI.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.menuViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.tbl.checkParsed();
        this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tbl.getDataRequestManager().setDataRequestMode(1);
        this.tbl.getDataRequestManager().setPageRowCount(1000);
        this.enableExportExcel(this.tbl);
        this.tbl.getDataRequestManager().setExportMemoryCallback(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected void tbl_afterDataFill(KDTDataRequestEvent e, KDTable tbl) {
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void tbl_tableClicked(KDTMouseEvent e) throws Exception {
        super.tbl_tableClicked(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.params.getObject("company");
        if (company != null) {
            IMRptUtils.checkHasAuthorized((String)company.getId().toString(), (OrgType)OrgType.Company, (String)permItem_print);
            super.actionPrint_actionPerformed(e);
        }
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.params.getObject("company");
        if (company != null) {
            IMRptUtils.checkHasAuthorized((String)company.getId().toString(), (OrgType)OrgType.Company, (String)permItem_print);
            super.actionPrintPreview_actionPerformed(e);
        }
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
    }

    @Override
    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    @Override
    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
    }

    private void checkSelected() {
        if (this.tbl.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private boolean checkObjectExists() throws BOSException, EASBizException, Exception {
        return this.getSelectedKeyValue() != null;
    }

    private String getKeyFieldName() {
        return "FMaterialID";
    }

    protected String getSelectedKeyValue() {
        KDTSelectBlock selectBlock = this.tbl.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tbl.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(this.getKeyFieldName());
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if (!((keyValue = cell.getValue()) == null || keyValue.equals("0") || keyValue.equals(" ") || keyValue.equals(""))) {
                return keyValue.toString();
            }
            return null;
        }
        return null;
    }

    protected Object getSelectedRowDate(String fieldName) {
        KDTSelectBlock selectBlock = this.tbl.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tbl.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(fieldName);
            if (cell == null) {
                return null;
            }
            Object keyValue = cell.getValue();
            if (keyValue != null && !StringUtils.isEmpty((String)keyValue.toString())) {
                return keyValue;
            }
            return null;
        }
        return null;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        RealModeIDList idList = new RealModeIDList();
        idList.add(this.getSelectedKeyValue());
        uiContext.put((Object)"IDList", (Object)idList);
    }

    private String getEditUIName() {
        return StockDetailReportUI.class.getName();
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkViewPermission();
        this.checkSelected();
        if (!this.checkObjectExists()) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.params.setObject("CurrentMaterialID", (Object)this.getSelectedKeyValue());
        RptParams detailParams = (RptParams)this.params.clone();
        detailParams.setString("tempTable", null);
        detailParams.setString("com.kingdee.eas.framework.report.client.CommRptBaseUI#PARAMS_KEY_TEMPTABLENAME", null);
        Object yearObj = this.getSelectedRowDate("FYear");
        Object periodObj = this.getSelectedRowDate("FPeriod");
        int currentYear = 0;
        int currentPeriod = 0;
        if (yearObj instanceof BigDecimal) {
            currentYear = ((BigDecimal)yearObj).intValue();
            currentPeriod = ((BigDecimal)periodObj).intValue();
        } else if (yearObj instanceof Integer) {
            currentYear = (Integer)yearObj;
            currentPeriod = (Integer)periodObj;
        }
        detailParams.setInt("accPeriodMonthFrom", currentPeriod);
        detailParams.setInt("accPeriodMonthTo", currentPeriod);
        detailParams.setInt("accPeriodYearFrom", currentYear);
        detailParams.setInt("accPeriodYearTo", currentYear);
        if (this.params.getObject("sumType") != null) {
            String sumTypeId;
            String SumTypeFieldName = ((SumTypeEnum)((Object)this.params.getObject("sumType"))).getValue().toString();
            Object sumType = this.getSelectedRowDate("FSumTypeID");
            if (sumType != null && !StringUtils.isEmpty((String)(sumTypeId = this.getSelectedRowDate("FSumTypeID").toString()))) {
                if (SumTypeFieldName.equals("FStorageOrgUnit")) {
                    detailParams.setString("FStorageOrgUnit", sumTypeId);
                }
                if (SumTypeFieldName.equals("FWarehouse")) {
                    detailParams.setString("FWarehouse", sumTypeId);
                }
                detailParams.setString("FKAClassfication", sumTypeId);
            }
        }
        detailParams.setInt("spinAmountPrecission", this.params.getInt("spinAmountPrecission"));
        detailParams.setInt("spinPricePrecission", this.params.getInt("spinPricePrecission"));
        detailParams.setInt("spinQtyPrecission", this.params.getInt("spinQtyPrecission"));
        uiContext.put((Object)"RPTFilter", (Object)detailParams);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void checkViewPermission() throws Exception {
        Object companyOrg;
        if (this.params != null && this.params.getObject("company") != null && (companyOrg = this.params.getObject("company")) != null) {
            ObjectUuidPK orgPk = new ObjectUuidPK(((CompanyOrgUnitInfo)companyOrg).getId());
            PermissionHelper.checkFunctionPermission(null, (IObjectPK)orgPk, (String)"stockdetailreport_view");
        }
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return StockGatherReportFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tbl;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        StockGatherReportConditionUI condUI = new StockGatherReportConditionUI();
        condUI.setSize(420, 470);
        return condUI;
    }

    protected void query() {
        this.tbl.removeColumns();
        this.tbl.removeRows();
        this.initUIMainOrgContext(((CompanyOrgUnitInfo)this.params.getObject("company")).getId().toString());
        this.initUserConfig();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void getData(KDTDataRequestEvent e) {
        try {
            IRow row;
            int i;
            this.tbl.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            RptParams para = new RptParams();
            para.setObject("sumType", this.params.getObject("sumType"));
            if (this.params.getObject("materialGroupLevel") != null) {
                para.setInt("materialGroupLevel", this.params.getInt("materialGroupLevel"));
            }
            para.setBoolean("onlyViewSumRow", this.params.getBoolean("onlyViewSumRow"));
            IMRptUtils.setParams4Precision((RptParams)para, (RptParams)this.params);
            para.setObject("company", this.params.getObject("company"));
            if (from == 0) {
                boolean flag;
                para.setString("tempTable", this.getTempTable());
                para.setObject("materialFrom", this.params.getObject("materialFrom"));
                para.setObject("materialTo", this.params.getObject("materialTo"));
                para.setObject("status", this.params.getObject("status"));
                para.setBoolean("onlyViewSumRow", this.params.getBoolean("onlyViewSumRow"));
                para.setInt("accPeriodYearFrom", this.params.getInt("accPeriodYearFrom"));
                para.setInt("accPeriodMonthFrom", this.params.getInt("accPeriodMonthFrom"));
                para.setInt("accPeriodYearTo", this.params.getInt("accPeriodYearTo"));
                para.setInt("accPeriodMonthTo", this.params.getInt("accPeriodMonthTo"));
                if (this.params.getObject("warehouse") != null) {
                    Object[] warehsArray = (Object[])this.params.getObject("warehouse");
                    StringBuffer warehsNumber = new StringBuffer();
                    flag = true;
                    for (i = 0; i < warehsArray.length; ++i) {
                        WarehouseInfo warehouse = (WarehouseInfo)warehsArray[i];
                        if (warehouse == null) {
                            flag = false;
                            continue;
                        }
                        if (i != 0) {
                            warehsNumber.append(",");
                        }
                        warehsNumber.append("").append(warehouse.getNumber()).append("");
                    }
                    if (warehsNumber.length() > 0 && flag) {
                        para.setString("warehouse", warehsNumber.toString());
                    }
                }
                if (this.params.getObject("storeType") != null) {
                    Object[] storeTypeArray = (Object[])this.params.getObject("storeType");
                    StringBuffer storeTypeNumber = new StringBuffer();
                    flag = true;
                    for (i = 0; i < storeTypeArray.length; ++i) {
                        StoreTypeInfo storeType = (StoreTypeInfo)storeTypeArray[i];
                        if (storeType == null) {
                            flag = false;
                            continue;
                        }
                        if (i != 0) {
                            storeTypeNumber.append(",");
                        }
                        storeTypeNumber.append("").append(storeType.getNumber()).append("");
                    }
                    if (storeTypeNumber.length() > 0 && flag) {
                        para.setString("storeType", storeTypeNumber.toString());
                    }
                }
                para.setObject("voucher", this.params.getObject("voucher"));
                para.setBoolean("ckShowNoCalculate", this.params.getBoolean("ckShowNoCalculate"));
                para.setObject("prmtKAClass", this.params.getObject("prmtKAClass"));
                para.setBoolean("ckBxMShortName", this.params.getBoolean("ckBxMShortName"));
                para.setObject("txtMShortNameFrom", this.params.getObject("txtMShortNameFrom"));
                para.setObject("txtMShortNameTo", this.params.getObject("txtMShortNameTo"));
                para.setBoolean("NoInOrOutNoShow", this.params.getBoolean("NoInOrOutNoShow"));
                int balanceCondition = 0;
                if (this.params.containsKey("ShowBalanceCondition")) {
                    balanceCondition = this.params.getInt("ShowBalanceCondition");
                }
                para.setInt("ShowBalanceCondition", balanceCondition);
                para.setBoolean("noSelectStorageMoveBill", this.params.getBoolean("noSelectStorageMoveBill"));
                para.setBoolean("noSelectWarehouseMoveBill", this.params.getBoolean("noSelectWarehouseMoveBill"));
                RptParams rpt = StockGatherReportFacadeFactory.getRemoteInstance().createTempTable(para);
                this.setTempTable(rpt.getString("tempTable"));
                logger.info((Object)("\u5b58\u8d27\u6536\u53d1\u5b58\u62a5\u8868--\u672c\u6b21\u67e5\u8be2\u4f7f\u7528\u7684\u4e34\u65f6\u8868\u540d\u4e3a: " + rpt.getString("tempTable")));
                RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tbl);
            }
            para.setString("tempTable", this.getTempTable());
            RptParams rpt = StockGatherReportFacadeFactory.getRemoteInstance().query(para, from, len);
            if (from == 0) {
                this.tbl.setRowCount(rpt.getInt("totalCount"));
            }
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.tbl);
            String sumType = null;
            int size = e.getLastRow();
            for (i = from; i <= size && (row = this.tbl.getRow(i)) != null; ++i) {
                sumType = row.getCell("FIndex").getValue().toString();
                if ("0".equals(sumType)) continue;
                row.getStyleAttributes().setBackground(necessaryColor);
            }
            this.initUserConfig();
            this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
    }

    protected Map preparePrintVariantMap() {
        return super.preparePrintVariantMap();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public Object getTablePreferenceSchemaKey() {
        QuerySolutionInfo currentSolutionInfo;
        Object obj = super.getTablePreferenceSchemaKey();
        if (obj == null && (currentSolutionInfo = this.queryDialog.getCommonQueryParam().getCurrentSolutionInfo()) != null) {
            obj = currentSolutionInfo.getId();
        }
        return obj;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName(this.getUIHandlerClassName());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    protected String getUIFullName() {
        return "com.kingdee.eas.scm.cal.client.StockGatherReportUI";
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        try {
            CommRptBaseConditionUI pc;
            ArrayList<String> visibleName = new ArrayList<String>();
            visibleName.add("qty");
            visibleName.add("price");
            visibleName.add("amount");
            if (this.userPanel == null) {
                this.userPanel = this.getCustomerQueryPanel();
                ReportQueryConditionHelper.initQueryDialog((CustomerQueryPanel)((CommRptBaseConditionUI)this.userPanel), (CommonQueryDialog)this.queryDialog, (Map)this.getUIContext(), (IMetaDataPK)this.getQueryMetaDataPK(), (String)((Object)((Object)this)).getClass().getName(), (RptParams)this.params, (RptParams)this.getUIContextInitParams(), visibleName, (boolean)true);
            }
            CustomerParams cp = ReportQueryConditionHelper.getDefaultCustomerParams((boolean)useDefaultSolution, (CustomerQueryPanel)this.userPanel, (CoreUI)this, (IMetaDataPK)this.getQueryMetaDataPK());
            boolean ok = false;
            if ((this.params == null && cp == null || !useDefaultSolution) && this.queryDialog.show()) {
                CommRptBaseConditionUI rbqp = (CommRptBaseConditionUI)this.queryDialog.getUserPanel(0);
                pc = (CommRptBaseConditionUI)this.queryDialog.getUserPanel(1);
                this.params = rbqp.getCustomCondition();
                if (pc != null) {
                    this.params.putAll(pc.getCustomCondition().toMap());
                }
                ok = true;
            }
            if (cp != null) {
                CommRptBaseConditionUI rptConditionUI = this.getQueryDialogUserPanel();
                rptConditionUI.initUIContentLayout();
                rptConditionUI.onInit(this.getUIContextInitParams());
                rptConditionUI.onLoad();
                rptConditionUI.loadFields();
                rptConditionUI.setCustomerParams(cp);
                rptConditionUI.loadData(null);
                this.params = rptConditionUI.getCustomCondition();
                pc = (CommRptBaseConditionUI)this.queryDialog.getCommonQueryParam().getPanels().get(1);
                if (pc != null) {
                    pc.clear();
                    this.params.putAll(pc.getCustomCondition().toMap());
                }
            }
            if (this.params != null && (ok || useDefaultSolution)) {
                this.queryWithWrap();
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }

    public boolean isAsynchronism() {
        return true;
    }
}

