/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.ICreateJobFacade;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.common.perf.client.JobMonitorManager;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.scm.cal.CostCalculateFacadeFactory;
import com.kingdee.eas.scm.cal.MaterialCalTypeEnum;
import com.kingdee.eas.scm.cal.client.AbstractStockPriceCalculateUI;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class StockPriceCalculateUI
extends AbstractStockPriceCalculateUI
implements ChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(StockPriceCalculateUI.class);
    private PeriodInfo curPeriodInfo = null;
    private String calType = null;
    private String caltitle = this.lblCalKind.getText();
    private String periodTitle = this.labPeriod.getText();

    public StockPriceCalculateUI() throws Exception {
        this.pmtCompanyOrg.setQueryInfo("com.kingdee.eas.scm.common.app.CompanyOrgUnitQuery");
        SCMClientUtils.setMainBizOrgF7forSealUp((KDBizPromptBox)this.pmtCompanyOrg, (OrgType)OrgType.Company, (String)"stocopriceview");
        SCMClientUtils.setF7OrgUnitBizUnit((KDBizPromptBox)this.pmtCompanyOrg);
        this.pmtWareHouseBeg.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQueryForCal");
        SCMClientUtils.setSotrageOrgF7((KDBizPromptBox)this.pmtStorageOrgBeg);
        CalculateClientUtil.setF7FilterUIProperties(this.pmtCompanyOrg, true);
        CalculateClientUtil.setF7FilterUIProperties(this.pmtStorageOrgBeg, false);
        CalculateClientUtil.setF7FilterUIProperties(this.pmtWareHouseBeg, false);
        this.pmtCompanyOrg.addChangeListener((ChangeListener)this);
        this.pmtStorageOrgBeg.addChangeListener((ChangeListener)this);
        this.pmtStorageOrgBeg.addChangeListener((ChangeListener)this);
        this.pmtStorageOrgBeg.setEnabledMultiSelection(true);
        this.pmtWareHouseBeg.setEnabledMultiSelection(true);
        this.pmtStorageOrgBeg.setLabelVisible(false);
        this.pmtWareHouseBeg.setLabelVisible(false);
        CalculateClientUtil.InitCompanyF7(this.pmtCompanyOrg, "costcompute");
        if (this.pmtCompanyOrg.getValue() != null) {
            CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.pmtCompanyOrg.getValue();
            CalculateClientUtil.setStorageOrgF7(companyInfo, this.pmtStorageOrgBeg, null);
        } else {
            this.clearWareHouse(false);
            this.clearStorageOrg(false);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.pmtCompanyOrg.getValue() != null) {
            CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.pmtCompanyOrg.getValue();
            CalculateClientUtil.getMaterialF7ForFilterIsRawMaterial(companyInfo, this, this.prmtMaterialFrom, null, null);
            CalculateClientUtil.getMaterialF7ForFilterIsRawMaterial(companyInfo, this, this.prmtMaterialTo, null, null);
            HashSet<Integer> cType = new HashSet<Integer>();
            cType.add(2);
            cType.add(1);
            FilterItemInfo filterItem = new FilterItemInfo("FIInfo.ACCOUNTTYPE", cType, CompareType.NOTINCLUDE);
            this.prmtMaterialFrom.getEntityViewInfo().getFilter().getFilterItems().add(filterItem);
            this.prmtMaterialTo.getEntityViewInfo().getFilter().getFilterItems().add(filterItem);
            IParamControl iParamControl = ParamControlFactory.getRemoteInstance();
            this.calType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()), "SCM_CAL_002");
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        block23: {
            if (((KDBizPromptBox)e.getSource()).equals(this.pmtCompanyOrg)) {
                if (this.pmtCompanyOrg.getValue() != null) {
                    try {
                        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.pmtCompanyOrg.getValue();
                        CalculateClientUtil.getMaterialF7ForFilterIsRawMaterial(companyInfo, this, this.prmtMaterialFrom, null, null);
                        CalculateClientUtil.getMaterialF7ForFilterIsRawMaterial(companyInfo, this, this.prmtMaterialTo, null, null);
                        HashMap<String, CompanyOrgUnitInfo> con = new HashMap<String, CompanyOrgUnitInfo>();
                        con.put("COMPANY_ID", (CompanyOrgUnitInfo)this.pmtCompanyOrg.getValue());
                        con.put("perPeriod", null);
                        con.put("SCM_CAL_002", null);
                        Map rs = CostCalculateFacadeFactory.getRemoteInstance().fetchData(con);
                        this.curPeriodInfo = (PeriodInfo)rs.get("perPeriod");
                        if (this.curPeriodInfo == null) {
                            MsgBox.showInfo((String)CalculateClientUtil.getCalResource("PERIOD_IS_NULL"));
                            SysUtil.abort();
                        } else {
                            this.labPeriod.setText(this.periodTitle + this.curPeriodInfo.getPeriodYear() + "." + this.curPeriodInfo.getPeriodNumber());
                        }
                        this.calType = (String)rs.get("SCM_CAL_002");
                    }
                    catch (BOSException e1) {
                        this.handUIExceptionAndAbort((Exception)((Object)e1));
                    }
                    catch (EASBizException e1) {
                        this.handUIExceptionAndAbort((Exception)((Object)e1));
                    }
                    catch (Exception e1) {
                        this.handUIExceptionAndAbort(e1);
                    }
                    if ("0".equals(this.calType)) {
                        this.clearStorageOrg(false);
                        this.lblCalKind.setText(this.caltitle + MaterialCalTypeEnum.CAL_TYPE_PARTITION_FINANCE.toString());
                    } else {
                        this.clearStorageOrg(true);
                        CalculateClientUtil.setStorageOrgF7((CompanyOrgUnitInfo)this.pmtCompanyOrg.getValue(), this.pmtStorageOrgBeg, null);
                    }
                    if ("1".equals(this.calType)) {
                        this.lblCalKind.setText(this.caltitle + MaterialCalTypeEnum.CAL_TYPE_PARTITION_STORAGE.toString());
                    }
                    if ("2".equals(this.calType)) {
                        this.lblCalKind.setText(this.caltitle + MaterialCalTypeEnum.CAL_TYPE_PARTITION_WAREHOUSE.toString());
                    }
                    this.clearWareHouse(false);
                } else {
                    this.clearWareHouse(false);
                    this.clearStorageOrg(false);
                    this.lblCalKind.setText(this.caltitle);
                }
            } else if (((KDBizPromptBox)e.getSource()).equals(this.pmtStorageOrgBeg)) {
                if (this.pmtStorageOrgBeg.getValue() != null) {
                    try {
                        if ("1".equals(this.calType)) {
                            this.pmtWareHouseBeg.setEnabled(false);
                            break block23;
                        }
                        Object[] obj = null;
                        obj = (Object[])this.pmtStorageOrgBeg.getValue();
                        HashSet<String> oriSet = new HashSet<String>();
                        if (obj[0] != null) {
                            int size = obj.length;
                            for (int j = 0; j < size; ++j) {
                                StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)obj[j];
                                oriSet.add(storageOrgUnitInfo.getId().toString());
                            }
                        }
                        this.pmtWareHouseBeg.setEnabled(true);
                        this.pmtWareHouseBeg.setValue(null);
                        this.pmtWareHouseBeg.setEntityViewInfo(InvClientUtils.getWarehouseFilter(oriSet, (int)1));
                    }
                    catch (EASBizException e1) {
                        this.handUIException(e1);
                    }
                    catch (BOSException e1) {
                        this.handUIException(e1);
                    }
                } else {
                    this.clearWareHouse(false);
                }
            }
        }
    }

    @Override
    public void actionCalculate_actionPerformed(ActionEvent e) throws Exception {
        Map result;
        int j;
        int size;
        Object[] obj;
        if (this.pmtCompanyOrg.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResource("COMPANY_NOTNULL"));
            SysUtil.abort();
        }
        if (this.prmtMaterialFrom.getValue() == null || this.prmtMaterialTo.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResource("MATERIAL_NOTNULL"));
            SysUtil.abort();
        }
        CalculateParams bizParams = new CalculateParams();
        bizParams.setBoolean("IsCloseAccount", false);
        bizParams.setObject("COMPANY_OBJ", (Object)((CompanyOrgUnitInfo)this.pmtCompanyOrg.getValue()));
        bizParams.setString("MATERIAL_FROM", ((MaterialInfo)this.prmtMaterialFrom.getValue()).getNumber());
        bizParams.setString("MATERIAL_TO", ((MaterialInfo)this.prmtMaterialTo.getValue()).getNumber());
        if (this.pmtStorageOrgBeg.getValue() != null) {
            obj = null;
            obj = (Object[])this.pmtStorageOrgBeg.getValue();
            if (obj[0] != null) {
                String[] storageOrgNumbers = new String[obj.length];
                StringBuffer orgIds = new StringBuffer();
                size = obj.length;
                for (j = 0; j < size; ++j) {
                    StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)obj[j];
                    storageOrgNumbers[j] = storageOrgUnitInfo.getNumber();
                    if (j > 0) {
                        orgIds.append(",");
                    }
                    orgIds.append("'").append(storageOrgUnitInfo.getId().toString()).append("'");
                }
                bizParams.setObject("STORAGEORGUNIT_NUMBER", (Object)storageOrgNumbers);
                bizParams.setObject("STORAGEORGUNITID", (Object)orgIds.toString());
            }
        }
        if (this.pmtWareHouseBeg.getValue() != null) {
            obj = null;
            obj = (Object[])this.pmtWareHouseBeg.getValue();
            if (obj[0] != null) {
                String[] warehouseNumbers = new String[obj.length];
                StringBuffer wareHsIds = new StringBuffer();
                size = obj.length;
                for (j = 0; j < size; ++j) {
                    WarehouseInfo wareHouseInfo = (WarehouseInfo)obj[j];
                    warehouseNumbers[j] = wareHouseInfo.getNumber();
                    if (j > 0) {
                        wareHsIds.append(",");
                    }
                    wareHsIds.append("'").append(wareHouseInfo.getId()).append("'");
                }
                bizParams.setObject("WAREHOUSE_NUMBER", (Object)warehouseNumbers);
                bizParams.setObject("WAREHOUSEID", (Object)wareHsIds.toString());
            }
        }
        JobParam jobParam = new JobParam((Object)bizParams);
        jobParam.setLocale(SysContext.getSysContext().getLocale());
        ICreateJobFacade iCreateJobFacade = CreateJobFacadeFactory.getRemoteInstance();
        JobConfig job = this.creteJobCfg((CompanyOrgUnitInfo)this.pmtCompanyOrg.getValue());
        if (iCreateJobFacade.checkDuplicateTask(job.getTaskType())) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResource("STOCKPRICECALCULATEING"));
            SysUtil.abort();
        }
        if ((result = iCreateJobFacade.executeJob(jobParam, job)) != null && result.get("jobInstExtId") != null) {
            JobMonitorManager.getInstance().addMonitorInfo((String)result.get("jobInstExtId"), job.getTitle());
            MsgBox.showWarning((Component)((Object)this), (String)this.getResource("NOTREPEATUPDATE"));
            this.disposeUIWindow();
        }
    }

    private JobConfig creteJobCfg(CompanyOrgUnitInfo companyOrg) throws EASBizException, BOSException {
        String title = "\u3010" + companyOrg.getName() + "(" + companyOrg.getNumber() + ")\u3011-" + this.getResource("STOCKPRICE_CALCULATE");
        JobConfig jobCfg = new JobConfig();
        jobCfg.setTitle(title);
        jobCfg.setTaskType(companyOrg.getNumber());
        jobCfg.setDescription(title);
        jobCfg.setNeedCheckTaskType(false);
        jobCfg.setNumber("StockPriceCalculate");
        return jobCfg;
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    private void clearWareHouse(boolean bln) {
        this.pmtWareHouseBeg.setValue(null);
        this.pmtWareHouseBeg.setEnabled(bln);
    }

    private void clearStorageOrg(boolean bln) {
        this.pmtStorageOrgBeg.setValue(null);
        this.pmtStorageOrgBeg.setEnabled(bln);
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.cal.StockPriceResource", (String)key);
    }
}

