/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.CalRptUtilFacadeFactory;
import com.kingdee.eas.scm.cal.CostCalculateFacadeFactory;
import com.kingdee.eas.scm.cal.ICalRptUtilFacade;
import com.kingdee.eas.scm.cal.client.AbstractStockPriceConditionUI;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.ColConnFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiF7FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class StockPriceConditionUI
extends AbstractStockPriceConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(StockPriceConditionUI.class);
    private Boolean isLoad = false;
    private String calType = null;

    public StockPriceConditionUI() throws Exception {
        this.getElementsInfo();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        SCMClientUtils.setMainBizOrgF7forSealUp((KDBizPromptBox)this.prmtCompanyOrg, (OrgType)OrgType.Company, (String)"stocopriceview");
        SCMClientUtils.setF7OrgUnitBizUnit((KDBizPromptBox)this.prmtCompanyOrg);
        SCMClientUtils.setSotrageOrgF7((KDBizPromptBox)this.prmtStorageOrg);
        this.prmtStorageOrg.setEnabledMultiSelection(true);
        this.prmtWarehouse.setEnabledMultiSelection(true);
        this.prmtCompanyOrg.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                StockPriceConditionUI.this.companyOrgChanged(eventObj);
            }
        });
        this.prmtStorageOrg.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                StockPriceConditionUI.this.storageOrgChanged(eventObj);
            }
        });
    }

    private void companyOrgChanged(DataChangeEvent eventObj) {
        OrgUnitInfo mianOrg = (OrgUnitInfo)eventObj.getNewValue();
        if (mianOrg != null) {
            try {
                CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
                companyInfo.setId(BOSUuid.read((String)mianOrg.getId().toString()));
                CalculateClientUtil.getMaterialF7ForFilterIsRawMaterial(companyInfo, (Object)this, this.prmtMaterial, null, null);
                CalculateClientUtil.getMaterialF7ForFilterIsRawMaterial(companyInfo, (Object)this, this.prmtMaterialTo, null, null);
                HashSet<Integer> cType = new HashSet<Integer>();
                cType.add(2);
                cType.add(1);
                FilterItemInfo filterItem = new FilterItemInfo("FIInfo.ACCOUNTTYPE", cType, CompareType.NOTINCLUDE);
                this.prmtMaterial.getEntityViewInfo().getFilter().getFilterItems().add(filterItem);
                this.prmtMaterialTo.getEntityViewInfo().getFilter().getFilterItems().add(filterItem);
                HashMap<String, CompanyOrgUnitInfo> con = new HashMap<String, CompanyOrgUnitInfo>();
                con.put("COMPANY_ID", companyInfo);
                con.put("perPeriod", null);
                con.put("SCM_CAL_002", null);
                Map rs = CostCalculateFacadeFactory.getRemoteInstance().fetchData(con);
                this.calType = (String)rs.get("SCM_CAL_002");
                ICalRptUtilFacade iCalRptUtil = CalRptUtilFacadeFactory.getRemoteInstance();
                Object[] reslut = iCalRptUtil.fetchInitFilterData(companyInfo.getId().toString());
                if (reslut != null) {
                    CalculateUtil.AccountPeriodInfo actPeriodInfo = (CalculateUtil.AccountPeriodInfo)reslut[1];
                    CalculateUtil.appliesPeriodControl(this.spAccPeriodYear, this.spAccPeriodYearTo, this.spAccPeriodMonth, this.spAccPeriodMonthTo, actPeriodInfo, false, true);
                }
                if ("0".equals(this.calType)) {
                    this.clearStorageOrg(false);
                } else {
                    this.clearStorageOrg(true);
                    CalculateClientUtil.setStorageOrgF7(companyInfo, this.prmtStorageOrg, null);
                }
                this.clearWareHouse(false);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else {
            this.clearWareHouse(false);
            this.clearStorageOrg(false);
        }
    }

    private void storageOrgChanged(DataChangeEvent eventObj) {
        Object[] obj = (Object[])eventObj.getNewValue();
        if (obj != null && obj.length > 0) {
            if ("1".equals(this.calType)) {
                this.prmtWarehouse.setEnabled(false);
            } else {
                HashSet<String> oriSet = new HashSet<String>();
                if (obj[0] != null) {
                    int size = obj.length;
                    for (int j = 0; j < size; ++j) {
                        OrgUnitInfo storageOrgUnitInfo = (OrgUnitInfo)obj[j];
                        oriSet.add(storageOrgUnitInfo.getId().toString());
                    }
                }
                if (!this.isLoad.booleanValue()) {
                    this.prmtWarehouse.setValue(null);
                }
                try {
                    this.prmtWarehouse.setEnabled(true);
                    this.prmtWarehouse.setEntityViewInfo(InvClientUtils.getWarehouseFilter(oriSet, (int)1));
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
        } else {
            this.clearWareHouse(false);
        }
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.isLoad = true;
        super.loadData(entityViewInfo);
        this.isLoad = false;
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new RangeFilterElement("material.number", (Component)this.prmtMaterial, (Component)this.prmtMaterialTo));
        elements.add((FilterElement)new MultiF7FilterElement("storageOrgUnit.id", this.prmtStorageOrg));
        elements.add((FilterElement)new MultiF7FilterElement("warehouse.id", this.prmtWarehouse, Boolean.FALSE));
        elements.add((FilterElement)new RangeFilterElement("year", (Component)this.spAccPeriodYear, (Component)this.spAccPeriodYearTo));
        elements.add((FilterElement)new RangeFilterElement("period", (Component)this.spAccPeriodMonth, (Component)this.spAccPeriodMonthTo));
        ColConnFilterElement mainOrgElement = new ColConnFilterElement("companyOrgUnit.id", (Component)this.prmtCompanyOrg);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.scm.cal.StockPriceResource", (String)"COMPANY_NOTNULL")));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "companyOrgUnit.id");
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = super.getFilterInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        FilterItemInfo filterItem = null;
        String key = null;
        for (int i = 0; i < filterItems.size(); ++i) {
            filterItem = filterItems.get(i);
            key = filterItem.getPropertyName();
            if ("year".equals(key) || "period".equals(key)) continue;
            filterInfo.getFilterItems().add(filterItem);
        }
        int year = this.spAccPeriodYear.getIntegerVlaue();
        int yearTo = this.spAccPeriodYearTo.getIntegerVlaue();
        int period = this.spAccPeriodMonth.getIntegerVlaue();
        int periodTo = this.spAccPeriodMonthTo.getIntegerVlaue();
        String whereSql = "where ((year = " + year + " and period >= " + period + ") and (year = " + yearTo + " and period <= " + periodTo + "))";
        whereSql = whereSql + " or (year > " + year + " and year < " + yearTo + ")";
        try {
            EntityViewInfo view = new EntityViewInfo(whereSql);
            filterInfo.mergeFilter(view.getFilter(), "and");
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    private void clearStorageOrg(boolean isEnable) {
        this.prmtStorageOrg.setValue(null);
        this.prmtStorageOrg.setEnabled(isEnable);
    }

    private void clearWareHouse(boolean isEnable) {
        this.prmtWarehouse.setValue(null);
        this.prmtWarehouse.setEnabled(isEnable);
    }

    public void clear() {
        super.clear();
        try {
            CalculateClientUtil.InitCompanyF7(this.prmtCompanyOrg, "stocopriceview");
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }
}

