/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ap.OtherBillType;
import com.kingdee.eas.fi.ar.IncomeConfimBillTypeEnum;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.IManualWriteOffFacade;
import com.kingdee.eas.scm.cal.IWriteOffGroup;
import com.kingdee.eas.scm.cal.ManualWriteOffFacadeFactory;
import com.kingdee.eas.scm.cal.WriteOffGroupFactory;
import com.kingdee.eas.scm.cal.client.AbstractWriteOffReportUI;
import com.kingdee.eas.scm.cal.client.ManualWriteOffUI;
import com.kingdee.eas.scm.cal.client.WriteOffReportFilterUI;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.client.BillOptionsHelper;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonFacadeFactory;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.util.numeric.PrecisionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class WriteOffReportUI
extends AbstractWriteOffReportUI {
    private static final long serialVersionUID = 1L;
    private CommonQueryDialog commonQuerydialog = null;
    private CompanyOrgUnitInfo mainBizorg = null;
    private boolean flag = true;
    private static final String RESOURCE_PATH = "com.kingdee.eas.scm.cal.ManualWriteOffResource";
    protected String writeOffType;
    private WriteOffReportFilterUI instance = null;
    private String userId = null;
    protected boolean isShowSumRowTag = false;
    protected boolean isDevolve;
    protected int dischargeType;
    protected static final String VOUCHERTYPE = "2652E01E";
    private static final String res = "com.kingdee.eas.scm.cal.ManualWriteOffResource";

    public WriteOffReportUI() throws Exception {
        this.actionVoucher.setDaemonRun(true);
    }

    public void onLoad() throws Exception {
        this.isShowSumRowTag = BillOptionsHelper.takeConfigType((IUIObject)this, (String)"IS_SHOW_SUMROW", (boolean)true);
        this.isShowSumRow.setSelected(this.isShowSumRowTag);
        this.isDevolve = CalculateUtil.isSubContractBill(this.getUIContext());
        super.onLoad();
        Collection billIDS = (Collection)this.getUIContext().get("billId");
        if (billIDS != null && billIDS.size() > 0) {
            this.btnQuery.setVisible(false);
            Iterator iters = billIDS.iterator();
            StringBuffer ids = new StringBuffer();
            while (iters.hasNext()) {
                ids.append("'");
                ids.append(iters.next());
                ids.append("',");
            }
            ids.deleteCharAt(ids.length() - 1);
            LinkedHashSet idSet = new LinkedHashSet();
            idSet.addAll(billIDS);
            FilterInfo filter = new FilterInfo();
            FilterItemInfo idItem = new FilterItemInfo("id", idSet, CompareType.INCLUDE);
            filter.getFilterItems().add(idItem);
            this.mainQuery.setFilter(filter);
            this.refreshList();
        }
        this.tblMain.getGroupManager().setGroup(true);
        int size = 5;
        for (int i = 0; i < size; ++i) {
            this.tblMain.getColumn(i).setGroup(true);
            this.tblMain.getColumn(i).setMergeable(true);
        }
        this.setTableAmountPrecision(SysContext.getSysContext().getCurrentFIUnit());
        this.getMainTable().getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                WriteOffReportUI.this.tbl_afterDataFill(e);
            }
        });
        this.tblMain.refresh();
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        this.userId = user.getId().toString();
        if (this.isDevolve) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"ReportUITitle"));
        }
        this.btnLocate.setVisible(false);
        this.menuItemLocate.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.menuItemTraceUp.setVisible(false);
        this.menuWorkFlow.setVisible(false);
        CompanyOrgUnitInfo cou = this.getMainBizOrgInfo();
        if (cou == null) {
            cou = (CompanyOrgUnitInfo)this.getMainOrgInfo();
        }
        if (cou != null) {
            this.dischargeType = CalculateUtil.getDischargeType(null, this.getMainOrgInfo().getId().toString());
        }
        if (this.dischargeType == 2 || this.dischargeType == 1) {
            this.btnDelDischgeVoucher.setVisible(true);
            this.btnDelDischgeVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_deletecredence"));
        } else {
            this.btnDelDischgeVoucher.setVisible(false);
        }
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getBOTPSelectors();
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("currency"));
        return sic;
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    public void setTableAmountPrecision(CompanyOrgUnitInfo cou) {
        int amtPrecision = 2;
        try {
            amtPrecision = CalculateUtil.getLocalCurrencyPrecision(null, cou);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        InvClientUtils.fmtTableAmt((KDTable)this.tblMain, (String)"entry.currWrittenOffAmount", (int)amtPrecision);
        InvClientUtils.fmtTableAmt((KDTable)this.tblMain, (String)"entry.writtenOffAmount", (int)amtPrecision);
        InvClientUtils.fmtTableAmt((KDTable)this.tblMain, (String)"entry.unWriteOffAmount", (int)amtPrecision);
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                String billTypeNumber;
                int qtyPrecision = rowSet.getInt("multimeasureunit.qtyPrecision");
                BigDecimal unWirteOffQty = rowSet.getBigDecimal("entry.unWirteOffQty");
                BigDecimal wirttenOffQty = rowSet.getBigDecimal("entry.wirttenOffQty");
                BigDecimal currWrittenOffQty = rowSet.getBigDecimal("entry.currWrittenOffQty");
                if (unWirteOffQty != null) {
                    rowSet.updateObject("entry.unWirteOffQty", (Object)unWirteOffQty.setScale(qtyPrecision, 4));
                }
                if (wirttenOffQty != null) {
                    rowSet.updateObject("entry.wirttenOffQty", (Object)wirttenOffQty.setScale(qtyPrecision, 4));
                }
                if (currWrittenOffQty != null) {
                    rowSet.updateObject("entry.currWrittenOffQty", (Object)currWrittenOffQty.setScale(qtyPrecision, 4));
                }
                if ("410".equalsIgnoreCase(billTypeNumber = rowSet.getString("entry.billTypeNumber"))) {
                    rowSet.updateObject("transactiontype.name", (Object)CalculateKindEnum.INPUT_WAREHOUSE.toString());
                }
                if ("230".equalsIgnoreCase(billTypeNumber)) {
                    rowSet.updateObject("transactiontype.name", (Object)OtherBillType.InvoiceBill.toString());
                } else if ("330".equalsIgnoreCase(billTypeNumber)) {
                    rowSet.updateObject("transactiontype.name", (Object)OtherBillTypeEnum.InvoiceBill.toString());
                } else if ("SR330".equalsIgnoreCase(billTypeNumber)) {
                    rowSet.updateObject("transactiontype.name", (Object)IncomeConfimBillTypeEnum.SALE_INCOME);
                }
                if (this.isDevolve) {
                    rowSet.updateObject("mappingConditionEntry.name", (Object)rowSet.getString("createType"));
                }
                Date date = rowSet.getDate("writeOffDate");
                Calendar calendar = Calendar.getInstance();
                date = new Date(date.getTime() - (date.getTime() + (long)calendar.get(15)) % 86400000L);
                rowSet.updateObject("writeOffDate", (Object)date);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        FilterItemCollection items;
        super.beforeExcutQuery(ev);
        Map btpContext = (Map)this.getUIContext().get("BTPNAVCTX");
        if (this.getUIContext().get("BOTPFilter") != null || btpContext != null && btpContext.get("BOTPFilter") != null) {
            return;
        }
        if (btpContext != null) {
            if (Boolean.TRUE.equals(btpContext.get("isApQurery"))) {
                return;
            }
            if (Boolean.TRUE.equals(btpContext.get("isSaleWriteOff"))) {
                this.writeOffType = "SALE_WRITEOFF";
            }
        }
        if (ev == null) {
            ev = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        if (FilterUtility.hasFilterItem((FilterInfo)ev.getFilter())) {
            filter = ev.getFilter();
        }
        if ((items = filter.getFilterItems()) == null) {
            items = new FilterItemCollection();
        }
        String maskString = "";
        if (this.isDevolve) {
            items.add(new FilterItemInfo("createType", (Object)new Integer(6), CompareType.GREATER_EQUALS));
            items.add(new FilterItemInfo("createType", (Object)new Integer(11), CompareType.LESS_EQUALS));
            maskString = " and #" + (items.size() - 2) + " and #" + (items.size() - 1);
        } else if (this.writeOffType.equals("SALE_WRITEOFF")) {
            items.add(new FilterItemInfo("createType", (Object)new Integer(12), CompareType.GREATER_EQUALS));
            items.add(new FilterItemInfo("createType", (Object)new Integer(13), CompareType.LESS_EQUALS));
            maskString = " and #" + (items.size() - 2) + " and #" + (items.size() - 1);
        } else if (this.writeOffType.equals("PUR_WRITEOFF")) {
            items.add(new FilterItemInfo("createType", (Object)new Integer(0), CompareType.GREATER_EQUALS));
            items.add(new FilterItemInfo("createType", (Object)new Integer(1), CompareType.LESS_EQUALS));
            maskString = " and #" + (items.size() - 2) + " and #" + (items.size() - 1);
        } else if (this.writeOffType.equals("INCOME_WRITEOFF")) {
            items.add(new FilterItemInfo("createType", (Object)new Integer(14), CompareType.GREATER_EQUALS));
            items.add(new FilterItemInfo("createType", (Object)new Integer(15), CompareType.LESS_EQUALS));
            maskString = " and #" + (items.size() - 2) + " and #" + (items.size() - 1);
        }
        try {
            boolean hasPermission;
            String permItemName = null;
            if (this.writeOffType.equals("SALE_WRITEOFF")) {
                permItemName = "SaleWriteOffReportView";
            } else if (this.isDevolve) {
                permItemName = "DevolveWriteOffReportView";
            } else if (this.writeOffType.equals("PUR_WRITEOFF")) {
                permItemName = "StockWriteOffReportView";
            } else if (this.writeOffType.equals("INCOME_WRITEOFF")) {
                permItemName = "IncomeWriteOffReportView";
            }
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
            CompanyOrgUnitInfo cou = this.getMainBizOrgInfo();
            if (cou == null) {
                cou = (CompanyOrgUnitInfo)this.getMainOrgInfo();
            }
            if (!(hasPermission = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)userPK, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cou.getId().toString())), permItemName))) {
                items.add(new FilterItemInfo("id", (Object)"111111111111111111111111111=", CompareType.EQUALS));
                maskString = maskString + " and #" + (items.size() - 1);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (filter.getMaskString() != null) {
            filter.setMaskString("(" + filter.getMaskString() + ") " + maskString);
        }
        ev.setFilter(filter);
    }

    protected boolean isOrderByIDForBill() {
        return false;
    }

    protected boolean initDefaultFilter() {
        return this.getUIContext().get("isFromWriteOff") == null;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return false;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQuerydialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQuerydialog = super.initCommonQueryDialog();
            this.commonQuerydialog.setWidth(490);
            this.commonQuerydialog.setHeight(500);
            this.commonQuerydialog.setShowSorter(true);
            this.commonQuerydialog.setShowFilter(true);
            try {
                this.instance = new WriteOffReportFilterUI(this);
                this.commonQuerydialog.addUserPanel((KDPanel)this.instance);
                if (this.writeOffType != null) {
                    if (!this.writeOffType.equals("PUR_WRITEOFF")) {
                        this.instance.kDLabelContainer1.setVisible(true);
                        this.instance.kDLabelContainer2.setVisible(true);
                        this.instance.ckBxMShortName.setVisible(true);
                    } else {
                        this.instance.kDLabelContainer1.setVisible(false);
                        this.instance.kDLabelContainer2.setVisible(false);
                        this.instance.ckBxMShortName.setVisible(false);
                    }
                }
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        if (this.isDevolve) {
            String title = EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"ConditionUI_ReportUITitle");
            this.commonQuerydialog.setTitle(title);
        }
        return this.commonQuerydialog;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        String UIName = null;
        try {
            IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
            if (this.getSelectedKeyValue() != null) {
                String key = BOSUuid.read((String)this.getSelectedKeyValue()).getType().toString();
                UIName = iBTPManager.getEntityObjectInfoExtendPro(key, "editUI");
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (BTPException e) {
            this.handUIException(e);
        }
        return UIName;
    }

    protected ICoreBase getBizInterface() throws Exception {
        String key;
        IBTPManager iBTPManager;
        String listUIName;
        if (this.getSelectedKeyValue() != null && (listUIName = (iBTPManager = BTPManagerFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext())).getEntityObjectInfoExtendPro(key = BOSUuid.read((String)this.getSelectedKeyValue()).getType().toString(), "listUI")) != null && listUIName.trim().length() > 0) {
            Class<?> c = Class.forName(listUIName);
            ListUI billListUI = (ListUI)c.newInstance();
            Method[] ms = c.getDeclaredMethods();
            for (int i = 0; i < ms.length; ++i) {
                String methodName = ms[i].getName();
                if (!"getBizInterface".equals(methodName)) continue;
                ms[i].setAccessible(true);
                Object r = ms[i].invoke((Object)billListUI, new Object[0]);
                return (ICoreBase)r;
            }
        }
        return WriteOffGroupFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnWriteOff.setIcon(EASResource.getIcon((String)"imgTbtn_cancelverification"));
        this.btnInverseWriteOff.setIcon(EASResource.getIcon((String)"imgTbtn_fcancelverification"));
    }

    private void showSuccess(String key) {
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)key));
        boolean oldbln = this.isShowTextOnly();
        this.setIsShowTextOnly(false);
        this.showMessage();
        if (oldbln) {
            this.setIsShowTextOnly(oldbln);
        }
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        this.flag = true;
        super.actionTraceDown_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.flag = false;
        try {
            super.actionView_actionPerformed(e);
        }
        finally {
            this.flag = true;
        }
    }

    @Override
    public void actionInverseWriteOff_actionPerformed(ActionEvent e) throws Exception {
        this.flag = true;
        ArrayList list = this.getSelectedIdValues();
        if (list.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        int rowNum = this.tblMain.getSelectManager().get().getTop();
        ICell cell = this.tblMain.getRow(rowNum).getCell("companyOrgUnitID");
        String companyOrgUnit = cell.getValue().toString();
        if (!this.isAuthoriedForOrg(companyOrgUnit)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"isInverseWriteOff"));
            return;
        }
        if (this.writeOffType.equals("PUR_WRITEOFF")) {
            String isDisCharged = this.tblMain.getRow(rowNum).getCell("isDisCharged").getValue().toString();
            String isVouchered = this.tblMain.getRow(rowNum).getCell("isVouchered").getValue().toString();
            if (Boolean.TRUE.equals(Boolean.valueOf(isDisCharged)) || Boolean.TRUE.equals(Boolean.valueOf(isVouchered))) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"isDisCharged_isVouchered"));
                return;
            }
        }
        List idList = WriteOffCommonFacadeFactory.getRemoteInstance().getPurInIdsByWOffRecord(null, (List)list);
        String[] ids = null;
        Object[] obj = list.toArray();
        int length = obj.length;
        ids = new String[length];
        System.arraycopy(obj, 0, ids, 0, length);
        IManualWriteOffFacade mof = ManualWriteOffFacadeFactory.getRemoteInstance();
        mof.inverseWriteOff(ids, "");
        if (idList != null && idList.size() > 0) {
            WriteOffCommonFacadeFactory.getRemoteInstance().synUnWriteOffQty(idList);
        }
        this.actionRefresh_actionPerformed(e);
        this.showSuccess("inverseWriteOffSuccess");
    }

    @Override
    public void actionWriteOff_actionPerformed(ActionEvent e) throws Exception {
        Object id = null;
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", id);
        uiContext.put((Object)"HISTORY_QUERY", (Object)"HISTORY_QUERY");
        uiContext.put((Object)"PREFERRED_SIZE", (Object)new Dimension(this.getWidth(), this.getHeight()));
        String uiClassName = this.getEditName();
        if (this.isDevolve) {
            uiContext.put((Object)"UIClassParam", (Object)"isSubContract");
        } else {
            uiClassName = "com.kingdee.eas.scm.framework.writeoff.client.WriteOffCommonUI";
            if (this.writeOffType.equals("SALE_WRITEOFF")) {
                uiContext.put((Object)"UIClassParam", (Object)"com.kingdee.eas.scm.cal.config.Ar2SiWriteOffConfig");
            } else if (this.writeOffType.equals("PUR_WRITEOFF")) {
                uiContext.put((Object)"UIClassParam", (Object)"com.kingdee.eas.scm.cal.config.Ap2PiWriteOffConfig");
            } else if (this.writeOffType.equals("INCOME_WRITEOFF")) {
                uiContext.put((Object)"UIClassParam", (Object)"com.kingdee.eas.scm.cal.config.IncomeWriteOffConfig");
            }
        }
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClassName, (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(uiClassName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private boolean isAuthoriedForOrg(String companyOrgUnit) throws EASBizException, BOSException {
        boolean isAuthoried = false;
        if (null != companyOrgUnit) {
            FullOrgUnitCollection result = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectUuidPK(this.userId), (OrgType)OrgType.Company, (String)this.getInversePermission());
            for (int i = 0; null != result && i < result.size(); ++i) {
                if (!result.get(i).getId().toString().equals(companyOrgUnit)) continue;
                isAuthoried = true;
                break;
            }
        }
        return isAuthoried;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        ItemAction action = this.getActionFromActionEvent(e);
        if (!action.equals(this.actionAddNew)) {
            uiContext.put((Object)"IDList", null);
        }
        if (action.equals(this.actionEdit)) {
            uiContext.put((Object)"ObjectUpdateLockId", (Object)this.getObjectUpdateLockId());
        }
        if (this.isDevolve) {
            uiContext.put((Object)"UIClassParam", (Object)"isSubContract");
        }
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.flag = true;
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        boolean bool = this.judgeVoucherState((IItemAction)this.actionDelVoucher, idList);
        if (bool) {
            String msg = EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource.recordNoVoucher");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return;
        }
        String message = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete");
        if (this.confirmRemoveDialog(message)) {
            if (UtilRequest.isPrepare((String)"ActionDelVoucher", (CoreUIObject)this)) {
                this.prepareDelVoucher(null).callHandler();
            }
            this.delTrans(idList);
        }
    }

    private void delTrans(ArrayList idList) throws Exception {
        ObjectUuidPK currentOrgId = new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        String param = ParamManager.getParamValue(null, (IObjectPK)currentOrgId, (String)"G002");
        if ("1".equals(param)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CannotDelVoucher"));
            return;
        }
        Set srcObjId = new HashSet();
        HashSet setList = new HashSet();
        IWriteOffGroup iwrite = WriteOffGroupFactory.getRemoteInstance();
        srcObjId = iwrite.getVoucheredIdSet(idList);
        setList.addAll(idList);
        if (srcObjId != null && srcObjId.size() > 0) {
            for (String id : srcObjId) {
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
                if (iwrite.deleteVoucher((IObjectPK)pk)) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoVoucher"));
                return;
            }
        } else if (setList != null && setList.size() > 0) {
            String[] billIdlist = new String[setList.size()];
            billIdlist = setList.toArray(billIdlist);
            iwrite.updateEqualWriteOff(billIdlist);
        }
        this.refreshList();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_DelVoucherSuccess"));
    }

    private boolean judgeVoucherState(IItemAction action, List idList) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            if (idList == null) {
                idList = this.getSelectedIdValues();
            }
            return this.gainBillSet(idList, action);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.flag = true;
        ArrayList list = this.getSelectedIdValues();
        if (list.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        int rowNum = this.tblMain.getSelectManager().get().getTop();
        ICell cell = this.tblMain.getRow(rowNum).getCell("companyOrgUnitID");
        String companyOrgUnitID = cell.getValue().toString().trim();
        if (this.writeOffType.equals("PUR_WRITEOFF")) {
            this.dischargeType = CalculateUtil.getDischargeType(null, companyOrgUnitID);
            if (this.dischargeType == 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"WriteOffNotAllow"));
                return;
            }
        }
        String[] ids = null;
        Object[] obj = list.toArray();
        int length = obj.length;
        ids = new String[length];
        System.arraycopy(obj, 0, ids, 0, length);
        int ret = WriteOffGroupFactory.getRemoteInstance().initData(ids);
        if (ret == -1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"PartIsVouchered"));
            return;
        }
        if (ret == 1) {
            this.refreshList();
            return;
        }
        if (ret == 0) {
            IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
            HashSet billIdSet = new HashSet(list);
            Map result = iMutex.batchRequestBizObjIDForUpdate(new ArrayList(billIdSet));
            ArrayList<String> requestIdList = new ArrayList<String>();
            try {
                String billId = null;
                boolean isLocked = false;
                Iterator it = billIdSet.iterator();
                while (it.hasNext()) {
                    billId = it.next().toString();
                    if (result.get(billId) != null && ((Boolean)result.get(billId)).booleanValue()) {
                        requestIdList.add(billId);
                        continue;
                    }
                    isLocked = true;
                }
                if (isLocked) {
                    throw new SCMBillException(SCMBillException.BILL_LOCKED);
                }
                super.actionVoucher_actionPerformed(e);
            }
            catch (Exception ex) {
                this.handUIExceptionAndAbort(ex);
            }
            finally {
                iMutex.batchReleaseObjIDForUpdate(requestIdList);
            }
        }
    }

    protected String getDeleteVoucherPermission() {
        return this.isDevolve ? "DevolveDeleteVoucher" : "StockDeleteVoucher";
    }

    @Override
    public void actionDelDischargeVoucher_actionPerformed(ActionEvent e) throws Exception {
        int length;
        this.flag = true;
        ArrayList list = this.getSelectedIdValues();
        if (list.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        boolean hasDischar = false;
        int size = this.tblMain.getSelectManager().size();
        block0: for (int i = 0; i < size; ++i) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(i);
            length = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= length; ++j) {
                IRow iRow = this.tblMain.getRow(j);
                if (iRow == null || !"true".equals(iRow.getCell("isDisCharged").getValue().toString())) continue;
                hasDischar = true;
                continue block0;
            }
        }
        if (!hasDischar) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"hasNotDisVoucher"));
            return;
        }
        int answer = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"confirmDelDisVoucher"));
        if (answer != 0) {
            return;
        }
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        if (!CalculateUtil.isAuthoriedForOrg(this.getMainOrgInfo().getId().toString(), user.getId().toString(), this.getDeleteVoucherPermission())) {
            String sSQL = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"DeleteVoucher"), this.getMainOrgInfo().getName());
            MsgBox.showWarning((Component)((Object)this), (String)sSQL);
            return;
        }
        Object[] obj = list.toArray();
        length = obj.length;
        String[] ids = new String[length];
        System.arraycopy(obj, 0, ids, 0, length);
        WriteOffGroupFactory.getRemoteInstance().deleteDischargeVoucher(ids);
        this.refreshList();
    }

    protected String getInversePermission() {
        return "StockInverseWriteOff";
    }

    protected String getEditName() {
        return ManualWriteOffUI.class.getName();
    }

    protected String getKeyFieldName() {
        return this.flag ? "id" : "entry.billID";
    }

    protected CompanyOrgUnitInfo getMainBizOrgInfo() {
        return this.mainBizorg;
    }

    protected void setMainBizOrgInfo(CompanyOrgUnitInfo cou) {
        this.mainBizorg = cou;
        this.initUIMainOrgContext(cou.getId().toString());
    }

    public RequestContext prepareActionCreateTo(IItemAction itemAction) throws Exception {
        return super.prepareActionCreateTo(itemAction);
    }

    public RequestContext prepareActionTraceDown(IItemAction itemAction) throws Exception {
        return super.prepareActionTraceDown(itemAction);
    }

    public RequestContext prepareActionTraceUp(IItemAction itemAction) throws Exception {
        return super.prepareActionTraceUp(itemAction);
    }

    public RequestContext prepareActionVoucher(IItemAction itemAction) throws Exception {
        super.prepareActionVoucher(itemAction);
        RequestContext request = new RequestContext();
        request.setClassName("com.kingdee.eas.scm.cal.app.WriteOffReportUIHandler");
        ArrayList list = this.getSelectedIdValues();
        if (list.isEmpty()) {
            return request;
        }
        String[] ids = null;
        Object[] obj = list.toArray();
        int length = obj.length;
        ids = new String[length];
        System.arraycopy(obj, 0, ids, 0, length);
        request.put("_SelectIDS", (Object)ids);
        return request;
    }

    @Override
    public IUIActionPostman prepareInit() {
        this.isDevolve = CalculateUtil.isSubContractBill(this.getUIContext());
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            CompanyOrgUnitInfo cou = SysContext.getSysContext().getCurrentFIUnit();
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            request.setUserPK((IObjectPK)new ObjectUuidPK(user.getId()));
            request.put("_SCMMAINORGTYPE", (Object)OrgType.Company);
            request.put("_SCMPERMISSIONITEM", (Object)this.getInversePermission());
            request.put("INV_MAIN_COU", (Object)cou);
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    public RequestContext prepareActionEdit(IItemAction itemAction) throws Exception {
        return super.prepareActionEdit(itemAction);
    }

    public RequestContext prepareActionOnLoad(IItemAction itemAction) throws Exception {
        super.prepareActionOnLoad(itemAction);
        RequestContext request = new RequestContext();
        request.setClassName("com.kingdee.eas.scm.cal.app.WriteOffReportUIHandler");
        if (this.commonQuerydialog != null) {
            request.put("_FILTERINFO", (Object)this.commonQuerydialog.getCommonFilter());
        }
        if (this.getMainBizOrgInfo() != null) {
            request.put("_COMPANYID", (Object)this.getMainBizOrgInfo().getId().toString());
        }
        return request;
    }

    public RequestContext prepareActionRefresh(IItemAction itemAction) throws Exception {
        return super.prepareActionRefresh(itemAction);
    }

    public RequestContext prepareActionQuery(IItemAction itemAction) throws Exception {
        super.prepareActionQuery(itemAction);
        RequestContext request = new RequestContext();
        request.setClassName("com.kingdee.eas.scm.cal.app.WriteOffReportUIHandler");
        if (this.commonQuerydialog != null) {
            request.put("_FILTERINFO", (Object)this.commonQuerydialog.getCommonFilter());
        }
        if (this.getMainBizOrgInfo() != null) {
            request.put("_COMPANYID", (Object)this.getMainBizOrgInfo().getId().toString());
        }
        return request;
    }

    public RequestContext prepareActionView(IItemAction itemAction) throws Exception {
        return super.prepareActionView(itemAction);
    }

    @Override
    public boolean isPrepareActionInverseWriteOff() {
        return true;
    }

    @Override
    public boolean isPrepareActionWriteOff() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public boolean isPrepareActionOnLoad() {
        return true;
    }

    public IUIActionPostman prepareQuery(RequestRowSetEvent e) {
        IUIActionPostman clientHanlder = super.prepareQuery(e);
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName("com.kingdee.eas.scm.cal.app.WriteOffReportUIHandler");
            CompanyOrgUnitInfo cou = SysContext.getSysContext().getCurrentFIUnit();
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            request.setUserPK((IObjectPK)new ObjectUuidPK(user.getId()));
            request.put("_SCMMAINORGTYPE", (Object)OrgType.Company);
            request.put("_SCMPERMISSIONITEM", (Object)this.getInversePermission());
            request.put("INV_MAIN_COU", (Object)cou);
            if (this.getMainBizOrgInfo() != null) {
                request.put("_COMPANYID", (Object)this.getMainBizOrgInfo().getId().toString());
            } else if (cou != null) {
                request.put("_COMPANYID", (Object)cou.getId().toString());
            }
            request.setSelectNodeId(this.getSelectedKeyValue());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    public RequestContext prepareActionInverseWriteOff(IItemAction itemAction) throws Exception {
        return super.prepareActionInverseWriteOff(itemAction);
    }

    @Override
    public RequestContext prepareActionWriteOff(IItemAction itemAction) throws Exception {
        super.prepareActionWriteOff(itemAction);
        RequestContext request = new RequestContext();
        request.setClassName("com.kingdee.eas.scm.cal.app.WriteOffReportUIHandler");
        if (this.getMainBizOrgInfo() != null) {
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            request.setUserPK((IObjectPK)new ObjectUuidPK(user.getId()));
            request.put("_SCMPERMISSIONITEM", (Object)this.getInversePermission());
            request.put("_COMPANYID", (Object)this.getMainBizOrgInfo().getId().toString());
            request.put("_SCMMAINORGTYPE", (Object)OrgType.Company);
        }
        return request;
    }

    public boolean isPrepareActionVoucher() {
        return true;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.checkViewPermission();
        super.actionQuery_actionPerformed(e);
        if ((this.writeOffType.equals("SALE_WRITEOFF") || this.writeOffType.equals("INCOME_WRITEOFF")) && this.instance != null) {
            if (this.instance.ckBxMShortName.isSelected()) {
                this.tblMain.getColumn("material.shortName").getStyleAttributes().setHided(false);
            } else {
                this.tblMain.getColumn("material.shortName").getStyleAttributes().setHided(true);
            }
        }
    }

    protected boolean isFootVisible() {
        return this.isShowSumRowTag;
    }

    public List getFieldSumList() {
        if (this.isShowSumRowTag) {
            return super.getFieldSumList();
        }
        return new ArrayList();
    }

    @Override
    public void actionIsShowSumRow_actionPerformed(ActionEvent e) throws Exception {
        if (this.isShowSumRow.isSelected()) {
            this.isShowSumRowTag = true;
        } else {
            this.isShowSumRowTag = false;
            if (this.tblMain.getFootManager() != null) {
                this.tblMain.getFootManager().getFoot().removeRow(0);
                this.tblMain.setFootManager(null);
            }
        }
        BillOptionsHelper.putConfigTypeByUI((IUIObject)this, (String)"IS_SHOW_SUMROW", (boolean)this.isShowSumRowTag);
        this.execQuery();
    }

    public void tbl_afterDataFill(KDTDataRequestEvent e) {
        int from = e.getFirstRow();
        int last = e.getLastRow();
        BigDecimal currWrittenOffQty = null;
        for (int i = from; i <= last; ++i) {
            Object scaleObj;
            IRow row = this.getMainTable().getRow(i);
            if (row == null || (scaleObj = row.getCell("entry.currWrittenOffQty").getValue()) == null || !(scaleObj instanceof BigDecimal)) continue;
            currWrittenOffQty = (BigDecimal)scaleObj;
            row.getCell("entry.currWrittenOffQty").getStyleAttributes().setNumberFormat(PrecisionUtil.fmtTableString((int)currWrittenOffQty.scale()).toString());
        }
    }

    protected boolean isPCVoucherVisible() {
        return true;
    }

    protected void checkPermission(String permItemName) throws Exception {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        CompanyOrgUnitInfo cou = this.getMainBizOrgInfo();
        if (cou == null) {
            cou = (CompanyOrgUnitInfo)this.getMainOrgInfo();
        }
        PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)userPK, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cou.getId().toString())), permItemName);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.checkViewPermission();
        super.actionRefresh_actionPerformed(e);
    }

    public void checkViewPermission() throws Exception {
        if ("PUR_WRITEOFF".equals(this.writeOffType)) {
            this.checkPermission("StockWriteOffReportView");
        } else if ("SALE_WRITEOFF".equals(this.writeOffType)) {
            this.checkPermission("SaleWriteOffReportView");
        } else if ("INCOME_WRITEOFF".equals(this.writeOffType)) {
            this.checkPermission("IncomeWriteOffReportView");
        }
    }

    public void actionDelPCVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        boolean bool = this.judgeVoucherState((IItemAction)this.actionDelPCVoucher, idList);
        if (bool) {
            String msg = EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource.recordNoVoucher");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return;
        }
        super.actionDelPCVoucher_actionPerformed(e);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }
}

