/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.config;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.scm.cal.client.WriteOffSaleIssueQueryUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.framework.writeoff.IWriteOffCommonHandler;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;

public class SaleIssueBillWriteOffHandler
implements IWriteOffCommonHandler {
    public String[] getAmountFields() {
        return new String[]{"entry.receiptAmount", "receiptAmount", "entry.amount", "entry.tax", "entry.taxAmount", "totalAmount", "totalTaxAmount", "entry.discountAmount", "entry.nonTaxAmount"};
    }

    public String[] getLocalAmountFields() {
        return new String[]{"entry.localAmount", "totalLocalAmount", "entry.localTax", "entry.localTaxAmount", "thisWriteOffAmount", "entry.standardCost", "entry.actualCost", "entry.writtenOffAmount", "entry.unWriteOffAmount", "totalStandardCost", "totalActualCost", "totalLocalTaxAmount", "entry.localNonTaxAmount"};
    }

    public String getBOSType() {
        return "CC3E933B";
    }

    public String getBillIdField() {
        return "id";
    }

    public String[][] getDisplayFields() {
        return new String[][]{{"false", "selected", EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"selected")}, {"false", "number", null}, {"false", "bizDate", null}, {"false", "storageOrgUnit.name", EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"storageOrgUnitName")}, {"false", "customer.name", EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"customer")}, {"false", "material.number", null}, {"false", "material.name", null}, {"false", "material.shortName", EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"shortName")}, {"true", "entry.qty", null}, {"false", "baseUnit.name", EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"baseUnit")}, {"true", "entry.baseQty", null}, {"true", "entry.actualCost", null}, {"true", "entry.unWriteOffBaseQty", null}, {"true", "entry.unWriteOffAmount", null}, {"true", "thisWriteOffBaseQty", EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"curWriteOffBaseQty")}, {"true", "thisWriteOffAmount", EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"curWriteOffAmount")}, {"false", "BillType.name", null}, {"false", "entry.saleOrderNumber", null}, {"false", "entry.saleOrderEntrySeq", null}};
    }

    public String getEditUIClassName() {
        return "com.kingdee.eas.scm.im.inv.client.SaleIssueBillEditUI";
    }

    public String getEntryIdField() {
        return "entry.id";
    }

    public String[] getHiddenFields() {
        return new String[]{"currency.precision", "currency2.precision", "id", "entry.id", "lastUpdateTime", "baseMultiUnit.qtyPrecision", "entry.unWriteOffBaseQty", "entry.unWriteOffAmount", "bill"};
    }

    public String[] getMergeFields() {
        return new String[]{"number"};
    }

    public String[] getModifyFields() {
        return new String[]{"selected", "thisWriteOffBaseQty"};
    }

    public CustomerQueryPanel getQueryUI(String companyId, Map uiContext) throws Exception {
        WriteOffSaleIssueQueryUI queryUI = new WriteOffSaleIssueQueryUI(companyId);
        queryUI.setSize(400, 300);
        return queryUI;
    }

    public String[] getSumFields() {
        return new String[]{"thisWriteOffBaseQty", "thisWriteOffAmount"};
    }

    public void handleTableEditStopped(KDTEditEvent e) throws Exception {
        KDTable tbl = (KDTable)e.getSource();
        if ("thisWriteOffBaseQty".equalsIgnoreCase(tbl.getColumnKey(e.getColIndex()))) {
            int selectRow = e.getRowIndex();
            int selectCol = e.getColIndex();
            int colCurWriteOffBaseQty = tbl.getColumnIndex("thisWriteOffBaseQty");
            int colUnWriteOffBaseQty = tbl.getColumnIndex("entry.unWriteOffBaseQty");
            int colCurWriteOffAmount = tbl.getColumnIndex("thisWriteOffAmount");
            int colUnWriteOffAmount = tbl.getColumnIndex("entry.unWriteOffAmount");
            if (selectCol == colCurWriteOffBaseQty) {
                IRow curRow = tbl.getRow(selectRow);
                BigDecimal unWriteOffBaseQty = (BigDecimal)curRow.getCell(colUnWriteOffBaseQty).getValue();
                BigDecimal curWriteOffBaseQty = curRow.getCell(colCurWriteOffBaseQty).getValue() == null ? SysConstant.BIGZERO : (BigDecimal)curRow.getCell(colCurWriteOffBaseQty).getValue();
                BigDecimal unWriteOffAmount = (BigDecimal)curRow.getCell(colUnWriteOffAmount).getValue();
                if (unWriteOffBaseQty.signum() != curWriteOffBaseQty.signum()) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"orientationAlert"));
                    curRow.getCell(colCurWriteOffBaseQty).setValue((Object)unWriteOffBaseQty);
                    curRow.getCell(colCurWriteOffAmount).setValue((Object)unWriteOffAmount);
                } else if (unWriteOffBaseQty.abs().compareTo(curWriteOffBaseQty.abs()) < 0) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"writeOffBaseQtyAlert"));
                    curRow.getCell(colCurWriteOffBaseQty).setValue((Object)unWriteOffBaseQty);
                    curRow.getCell(colCurWriteOffAmount).setValue((Object)unWriteOffAmount);
                } else if (unWriteOffBaseQty.abs().compareTo(curWriteOffBaseQty.abs()) > 0) {
                    BigDecimal writeOffAmount = unWriteOffAmount.divide(unWriteOffBaseQty, 10, 4).multiply(curWriteOffBaseQty).setScale((int)Integer.valueOf(curRow.getCell("currency2.precision").getValue().toString()), 4);
                    curRow.getCell(colCurWriteOffAmount).setValue((Object)writeOffAmount);
                }
                if (unWriteOffBaseQty.compareTo(curWriteOffBaseQty) == 0) {
                    curRow.getCell(colCurWriteOffAmount).setValue((Object)unWriteOffAmount);
                }
            }
        }
    }

    public void handleTableRowData(IRow row, Object[] rowData, boolean isHeadView) {
        int i;
        int baseQtyPrecision = 2;
        row.getCell("selected").setValue((Object)Boolean.FALSE);
        if (row.getCell("baseMultiUnit.qtyPrecision").getValue() != null) {
            baseQtyPrecision = Integer.valueOf(row.getCell("baseMultiUnit.qtyPrecision").getValue().toString());
        }
        KDFormattedTextField text = new KDFormattedTextField();
        text.setDataType(1);
        text.setPrecision(baseQtyPrecision);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)text);
        row.getCell("thisWriteOffBaseQty").setEditor((ICellEditor)editor);
        row.getCell("thisWriteOffBaseQty").getStyleAttributes().setNumberFormat(PrecisionFormatUtils.getFormatString((int)baseQtyPrecision));
        row.getCell("thisWriteOffBaseQty").setValue(row.getCell("entry.unWriteOffBaseQty").getValue());
        row.getCell("thisWriteOffAmount").setValue(row.getCell("entry.unWriteOffAmount").getValue());
        String[] fields = this.getAmountFields();
        String formatString = PrecisionFormatUtils.getFormatString((int)Integer.valueOf(row.getCell("currency.precision").getValue().toString()));
        int len = fields.length;
        for (i = 0; i < len; ++i) {
            if (row.getCell(fields[i]) == null) continue;
            row.getCell(fields[i]).getStyleAttributes().setNumberFormat(formatString);
        }
        fields = this.getLocalAmountFields();
        formatString = PrecisionFormatUtils.getFormatString((int)Integer.valueOf(row.getCell("currency2.precision").getValue().toString()));
        len = fields.length;
        for (i = 0; i < len; ++i) {
            if (row.getCell(fields[i]) == null) continue;
            row.getCell(fields[i]).getStyleAttributes().setNumberFormat(formatString);
        }
        row.getCell("entry.qty").setEditor((ICellEditor)editor);
        row.getCell("entry.qty").getStyleAttributes().setNumberFormat(PrecisionFormatUtils.getFormatString((int)baseQtyPrecision));
        row.getCell("entry.baseQty").setEditor((ICellEditor)editor);
        row.getCell("entry.baseQty").getStyleAttributes().setNumberFormat(PrecisionFormatUtils.getFormatString((int)baseQtyPrecision));
        row.getCell("entry.unWriteOffBaseQty").setEditor((ICellEditor)editor);
        row.getCell("entry.unWriteOffBaseQty").getStyleAttributes().setNumberFormat(PrecisionFormatUtils.getFormatString((int)baseQtyPrecision));
        if (row.getCell("baseStatus").getValue() != null) {
            BigDecimal baseStatus = (BigDecimal)row.getCell("baseStatus").getValue();
            row.getCell("baseStatus").setValue((Object)BillBaseStatusEnum.getEnum((int)baseStatus.intValue()));
        }
        if (row.getCell("entry.baseStatus").getValue() != null) {
            BigDecimal baseStatus = (BigDecimal)row.getCell("entry.baseStatus").getValue();
            row.getCell("entry.baseStatus").setValue((Object)BillBaseStatusEnum.getEnum((int)baseStatus.intValue()));
        }
        if (row.getCell("entry.discountType").getValue() != null) {
            BigDecimal discountType = (BigDecimal)row.getCell("entry.discountType").getValue();
            row.getCell("entry.discountType").setValue((Object)DiscountModeEnum.getEnum((int)discountType.intValue()));
        }
        if (row.getCell("convertMode").getValue() != null) {
            BigDecimal convertMode = (BigDecimal)row.getCell("convertMode").getValue();
            row.getCell("convertMode").setValue((Object)ConvertModeEnum.getEnum((int)convertMode.intValue()));
        }
    }

    public String[] getUserDefineFields() {
        return new String[]{"selected", "thisWriteOffBaseQty", "thisWriteOffAmount"};
    }

    public List getWriteOffList(KDTable table) {
        ArrayList<WriteOffCommonInfo> list = new ArrayList<WriteOffCommonInfo>();
        WriteOffCommonInfo info = null;
        int rowCount = table.getRowCount3();
        for (int i = 0; i < rowCount; ++i) {
            if (!Boolean.TRUE.equals(table.getCell(i, "selected").getValue())) continue;
            info = new WriteOffCommonInfo();
            info.setBaseQty((BigDecimal)table.getCell(i, "thisWriteOffBaseQty").getValue());
            info.setLocalAmount((BigDecimal)table.getCell(i, "thisWriteOffAmount").getValue());
            info.setBillId((String)table.getCell(i, "id").getValue());
            info.setEntryId((String)table.getCell(i, "entry.id").getValue());
            info.setLastUpdateTime((Date)table.getCell(i, "lastUpdateTime").getValue());
            info.setBillNumber((String)table.getCell(i, "number").getValue());
            list.add(info);
        }
        return list;
    }
}

