/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.invdep.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.cal.invdep.DepChargeException;
import com.kingdee.eas.scm.cal.invdep.DepChargeFacadeFactory;
import com.kingdee.eas.scm.cal.invdep.DepChargeFactory;
import com.kingdee.eas.scm.cal.invdep.MaterialCategoryInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class DepChargeField {
    private static final Logger logger = CoreUIObject.getLogger(DepChargeField.class);
    protected KDTable defaultTable = new KDTable();
    MultiMeasureUnitCollection multiMeasureCol = null;
    MeasureUnitCollection measureCol = null;
    protected CompanyOrgUnitInfo currentCompany;
    int currencyPrecision = 2;
    BigDecimal One = new BigDecimal("1.00");
    BigDecimal Hundred = new BigDecimal("100.00");
    protected static final String FIELD_invDepRatio = "invDepRatio";
    protected static final String FIELD_UnNetRealizable = "UnNetRealizable";
    protected static final String FIELD_NetRealizable = "netRealizable";
    protected static final String FIELD_MaterialNum = "materialNum";
    protected static final String FIELD_MaterialName = "materialName";
    protected static final String FIELD_MaterialModel = "materialModel";
    protected static final String FIELD_MeasureUnit = "measureUnit";
    public static final String FIELD_SEQ = "seq";
    protected static final String FIELD_InvPrice = "invPrice";
    protected static final String FIELD_DepToCharge = "depToCharge";
    protected static final String FIELD_DepCharged = "depCharged";
    protected static final String FIELD_CurDepCharge = "curDepCharge";
    protected static final String FIELD_InvQty = "invQty";
    protected static final String FIELD_InvAmount = "invAmount";
    protected static final String FIELD_QtyReverse = "entrys.qtyReverse";
    protected static final String FIELD_AmtReverse = "entrys.amtReverse";
    private String[] chargeEditCols = new String[]{"invDepRatio", "UnNetRealizable", "netRealizable", "depCharged"};
    private String[] materialCols = new String[]{"materialNum"};
    private String[] submitCheckCols = new String[]{"materialNum", "netRealizable", "depCharged", "curDepCharge"};
    private String[] amtCols = new String[]{"invAmount", "netRealizable", "depToCharge", "depCharged", "curDepCharge", "entrys.amtReverse"};
    private String[] priceCols = new String[]{"invPrice", "UnNetRealizable"};
    private String[] qtyCols = new String[]{"invQty", "entrys.qtyReverse"};

    public DepChargeField(KDTable kdtEntrys, CompanyOrgUnitInfo currentCompany) {
        this.defaultTable = kdtEntrys;
        this.currentCompany = currentCompany;
    }

    public void refreshCompany(CompanyOrgUnitInfo currentCompany) {
        this.currentCompany = currentCompany;
    }

    public void setChargeEditColsLock(KDTable kdtEntrys, boolean flag) {
        this.setTableColumnLock(kdtEntrys, this.chargeEditCols, flag);
    }

    public void setMaterialColsLock(KDTable kdtEntrys, boolean flag) {
        this.setTableColumnLock(kdtEntrys, this.materialCols, flag);
    }

    public void setChargeEditColsLock(boolean flag) {
        this.setTableColumnLock(this.defaultTable, this.chargeEditCols, flag);
    }

    public void setMaterialColsLock(boolean flag) {
        this.setTableColumnLock(this.defaultTable, this.materialCols, flag);
    }

    public void setTableColumnLock(KDTable kdtEntries, String[] colNames, boolean isLock) {
        if (kdtEntries == null) {
            throw new IllegalArgumentException("KDTable cann't be null!");
        }
        int n = colNames.length;
        for (int i = 0; i < n; ++i) {
            if (colNames[i] == null || kdtEntries.getColumn(colNames[i]) == null) continue;
            kdtEntries.getColumn(colNames[i]).getStyleAttributes().setLocked(isLock);
        }
    }

    public void setTableColumnRequired(KDTable kdtEntries, String[] colNames) {
        if (kdtEntries == null) {
            throw new IllegalArgumentException("KDTable cann't be null!");
        }
        Color requiredColor = kdtEntries.getRequiredColor();
        int n = colNames.length;
        for (int i = 0; i < n; ++i) {
            if (colNames[i] == null || kdtEntries.getColumn(colNames[i]) == null) continue;
            kdtEntries.getColumn(colNames[i]).getStyleAttributes().setBackground(requiredColor);
        }
    }

    public void setTableColumnRequired() {
        this.setTableColumnRequired(this.defaultTable, this.submitCheckCols);
    }

    public void submitEntryCheck() throws DepChargeException {
        this.submitEntryCheck(this.defaultTable, this.submitCheckCols);
    }

    public void submitEntryCheck(KDTable kdtEntries, String[] submitCheck) throws DepChargeException {
        if (kdtEntries == null) {
            throw new IllegalArgumentException("KDTable cann't be null!");
        }
        Object headValue = "";
        boolean flag = false;
        int rowNum = kdtEntries.getRowCount();
        block0: for (int rowIndex = 0; rowIndex < rowNum; ++rowIndex) {
            int n = submitCheck.length;
            for (int i = 0; i < n; ++i) {
                if (submitCheck[i] == null || kdtEntries.getRow(rowIndex).getCell(submitCheck[i]) == null || kdtEntries.getRow(rowIndex).getCell(submitCheck[i]).getValue() != null) continue;
                headValue = kdtEntries.getHeadRow(0).getCell(submitCheck[i]).getValue();
                flag = true;
                continue block0;
            }
        }
        if (flag) {
            throw new DepChargeException(DepChargeException.BLANK, new Object[]{headValue + EASResource.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"222_DepChargeField")});
        }
    }

    public void setEntryMeasureUnit(IObjectPK companyPK, int rowIdx, MaterialInfo[] materialInfos) {
        HashSet<String> measureUnitIdSet = new HashSet<String>();
        HashSet<String> materialIdSet = new HashSet<String>();
        int length = materialInfos.length;
        for (int i = 0; i < length; ++i) {
            if (materialInfos[i].getBaseUnit() != null) {
                measureUnitIdSet.add(materialInfos[i].getBaseUnit().getId().toString());
            }
            materialIdSet.add(materialInfos[i].getId().toString());
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", materialIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", measureUnitIdSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        EntityViewInfo msevi = new EntityViewInfo();
        FilterInfo msfilter = new FilterInfo();
        msfilter.getFilterItems().add(new FilterItemInfo("id", measureUnitIdSet, CompareType.INCLUDE));
        msevi.setFilter(msfilter);
        try {
            this.measureCol = MeasureUnitFactory.getRemoteInstance().getMeasureUnitCollection(msevi);
            this.multiMeasureCol = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitCollection(evi);
        }
        catch (BOSException e) {
            logger.info((Object)e.getMessage());
        }
        ArrayList<BOSUuid> materialIds = new ArrayList<BOSUuid>();
        int mLength = materialInfos.length;
        for (int mIndex = 0; mIndex < mLength; ++mIndex) {
            materialIds.add(materialInfos[mIndex].getId());
        }
        HashMap resultMap = null;
        try {
            resultMap = DepChargeFacadeFactory.getRemoteInstance().getMaterialQtyAmt(companyPK, materialIds);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
        }
        int j = rowIdx;
        int r = 0;
        int rowlength = rowIdx + materialInfos.length;
        while (j < rowlength) {
            if (this.defaultTable.getRow(j) == null) {
                this.defaultTable.addRow();
            }
            if (this.defaultTable.getRow(j) != null) {
                IRow row = this.defaultTable.getRow(j);
                this.setCellValue(row.getCell(FIELD_MaterialNum), materialInfos[r]);
                this.setCellValue(row.getCell(FIELD_MaterialName), materialInfos[r].getName());
                this.setCellValue(row.getCell(FIELD_MaterialModel), materialInfos[r].getModel());
                this.setRowByPrecision(row, FIELD_InvPrice, materialInfos[r].getPricePrecision());
                this.setRowByPrecision(row, FIELD_UnNetRealizable, materialInfos[r].getPricePrecision());
                MultiMeasureUnitInfo mu = this.getCoinMultiBaseUnit(this.multiMeasureCol, materialInfos[r], materialInfos[r].getBaseUnit());
                this.setCellValue(row.getCell(FIELD_MeasureUnit), this.getCoinBaseUnit(this.measureCol, materialInfos[r].getBaseUnit()));
                this.setRowByPrecision(row, FIELD_InvQty, mu.getQtyPrecision());
                this.setRowByPrecision(row, FIELD_QtyReverse, mu.getQtyPrecision());
                this.setMaterialQtyCost(row, companyPK, materialInfos[r], resultMap, mu.getQtyPrecision(), materialInfos[r].getPricePrecision());
            }
            ++j;
            ++r;
        }
        try {
            this.setLastDepChargedRow(rowIdx, materialInfos);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
        }
    }

    public void removeMaterialCostZero() {
        for (int rowIdx = 0; rowIdx < this.defaultTable.getRowCount(); ++rowIdx) {
            IRow row = this.defaultTable.getRow(rowIdx);
            if (row.getCell(FIELD_InvAmount) != null && row.getCell(FIELD_InvQty) != null && row.getCell(FIELD_InvAmount).getValue() instanceof BigDecimal && row.getCell(FIELD_InvQty).getValue() instanceof BigDecimal) {
                BigDecimal amt = (BigDecimal)row.getCell(FIELD_InvAmount).getValue();
                BigDecimal qty = (BigDecimal)row.getCell(FIELD_InvQty).getValue();
                if (SysConstant.BIGZERO.compareTo(amt) != 0 || SysConstant.BIGZERO.compareTo(qty) != 0) continue;
                this.defaultTable.removeRow(rowIdx);
                --rowIdx;
                continue;
            }
            if (row.getCell(FIELD_InvAmount).getValue() != null || row.getCell(FIELD_InvQty).getValue() != null) continue;
            this.defaultTable.removeRow(rowIdx);
            --rowIdx;
        }
    }

    private void setMaterialQtyCost(IRow row, IObjectPK companyPK, MaterialInfo materialInfo, HashMap resultMap, int qtyPrecison, int pricePrecison) {
        if (resultMap == null) {
            return;
        }
        Object obj = resultMap.get(companyPK.toString() + materialInfo.getId());
        if (obj != null && obj.getClass().isArray()) {
            BigDecimal[] qtyCostArray = (BigDecimal[])obj;
            this.setCellValue(row.getCell(FIELD_InvQty), this.setBigDecimal(qtyCostArray[0], qtyPrecison));
            this.setCellValue(row.getCell(FIELD_InvAmount), this.setBigDecimal(qtyCostArray[1], this.currencyPrecision));
            this.setCellValue(row.getCell(FIELD_InvPrice), this.divide(qtyCostArray[1], qtyCostArray[0], pricePrecison));
            this.setCellValue(row.getCell(FIELD_invDepRatio), SysConstant.BIGZERO);
        } else {
            this.setCellValue(row.getCell(FIELD_InvQty), SysConstant.BIGZERO);
            this.setCellValue(row.getCell(FIELD_InvAmount), SysConstant.BIGZERO);
            this.setCellValue(row.getCell(FIELD_InvPrice), SysConstant.BIGZERO);
            this.setCellValue(row.getCell(FIELD_invDepRatio), SysConstant.BIGZERO);
        }
    }

    private void setCellValue(ICell cell, Object obj) {
        if (cell != null) {
            cell.setValue(obj);
        }
    }

    private BigDecimal setBigDecimal(BigDecimal source, int precison) {
        if (source != null) {
            source = source.setScale(precison, 4);
        }
        return source;
    }

    private MultiMeasureUnitInfo getCoinMultiBaseUnit(MultiMeasureUnitCollection msCol, MaterialInfo materialInfo, MeasureUnitInfo source) {
        int size = msCol.size();
        for (int i = 0; i < size; ++i) {
            if (msCol.get(i).getMaterial() == null || msCol.get(i).getMeasureUnit() == null || source == null || !msCol.get(i).getMaterial().getId().equals((Object)materialInfo.getId()) || !msCol.get(i).getMeasureUnit().getId().equals((Object)source.getId())) continue;
            return msCol.get(i);
        }
        return new MultiMeasureUnitInfo();
    }

    private MeasureUnitInfo getCoinBaseUnit(MeasureUnitCollection msCol, MeasureUnitInfo source) {
        int size = msCol.size();
        for (int i = 0; i < size; ++i) {
            if (!source.getId().equals((Object)msCol.get(i).getId())) continue;
            return msCol.get(i);
        }
        return new MeasureUnitInfo();
    }

    public void setEntryRatio(MaterialCategoryInfo mcInfo, int rowIdx, int length) {
        if (mcInfo == null) {
            return;
        }
        for (int rowCounter = rowIdx; rowCounter < length; ++rowCounter) {
            this.defaultTable.getRow(rowCounter).getCell(FIELD_invDepRatio).setValue((Object)mcInfo.getInvDepRatio());
        }
    }

    public void computeEntryRatioAmt(int rowIdx, int length) {
        for (int rowCounter = rowIdx; rowCounter < length; ++rowCounter) {
            this.caculateInvRatio(this.defaultTable.getRow(rowCounter), null);
        }
    }

    public void computeDepChargeEntry(KDTEditEvent e) {
        this.chainCompute(e);
    }

    private void chainCompute(KDTEditEvent e) {
        if (e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        IRow row = this.defaultTable.getRow(e.getRowIndex());
        if (row.getCell(FIELD_invDepRatio).getColumnIndex() == e.getColIndex()) {
            this.caculateInvRatio(row, e.getOldValue());
        }
        if (row.getCell(FIELD_UnNetRealizable).getColumnIndex() == e.getColIndex()) {
            this.caculateUnNetRealizable(row, e);
        }
        if (row.getCell(FIELD_NetRealizable).getColumnIndex() == e.getColIndex()) {
            this.caculateNetRealizable(row, e);
        }
        if (row.getCell(FIELD_DepCharged).getColumnIndex() == e.getColIndex()) {
            this.caculateDepCharged(row, e);
        }
    }

    private void caculateInvRatio(IRow row, Object oldObj) {
        row.getCell(FIELD_UnNetRealizable).setValue((Object)this.multiply(row.getCell(FIELD_InvPrice), this.substract(this.One, this.divide(row.getCell(FIELD_invDepRatio), this.Hundred, 4))));
        if (!this.checkUnNetRealizable(row)) {
            row.getCell(FIELD_invDepRatio).setValue(oldObj);
            row.getCell(FIELD_UnNetRealizable).setValue((Object)this.multiply(row.getCell(FIELD_InvPrice), this.substract(this.One, this.divide(row.getCell(FIELD_invDepRatio), this.Hundred, 4))));
            return;
        }
        row.getCell(FIELD_NetRealizable).setValue((Object)this.multiply(this.substract(this.One, this.divide(row.getCell(FIELD_invDepRatio), this.Hundred, 4)), row.getCell(FIELD_InvAmount)));
        this.setSubCell(row.getCell(FIELD_DepToCharge), row.getCell(FIELD_InvAmount), row.getCell(FIELD_NetRealizable));
        this.setDepChargedRowValue(row);
        this.setSubCell(row.getCell(FIELD_CurDepCharge), row.getCell(FIELD_DepToCharge), row.getCell(FIELD_DepCharged));
    }

    private void caculateUnNetRealizable(IRow row, KDTEditEvent e) {
        if (!this.checkUnNetRealizable(row)) {
            row.getCell(FIELD_UnNetRealizable).setValue(e.getOldValue());
            return;
        }
        row.getCell(FIELD_invDepRatio).setValue((Object)this.multiply(this.divide(this.substract(row.getCell(FIELD_InvPrice), row.getCell(FIELD_UnNetRealizable)), row.getCell(FIELD_InvPrice), 6), this.Hundred));
        row.getCell(FIELD_NetRealizable).setValue((Object)this.multiply(row.getCell(FIELD_UnNetRealizable), row.getCell(FIELD_InvQty)));
        this.setSubCell(row.getCell(FIELD_DepToCharge), row.getCell(FIELD_InvAmount), row.getCell(FIELD_NetRealizable));
        this.setDepChargedRowValue(row);
        this.setSubCell(row.getCell(FIELD_CurDepCharge), row.getCell(FIELD_DepToCharge), row.getCell(FIELD_DepCharged));
    }

    private void caculateNetRealizable(IRow row, KDTEditEvent e) {
        row.getCell(FIELD_invDepRatio).setValue((Object)this.multiply(this.divide(this.substract(row.getCell(FIELD_InvAmount), row.getCell(FIELD_NetRealizable)), row.getCell(FIELD_InvAmount), 6), this.Hundred));
        row.getCell(FIELD_UnNetRealizable).setValue((Object)this.divide(row.getCell(FIELD_NetRealizable), row.getCell(FIELD_InvQty), 0));
        if (!this.checkUnNetRealizable(row)) {
            row.getCell(FIELD_NetRealizable).setValue(e.getOldValue());
            row.getCell(FIELD_invDepRatio).setValue((Object)this.multiply(this.divide(this.substract(row.getCell(FIELD_InvAmount), row.getCell(FIELD_NetRealizable)), row.getCell(FIELD_InvAmount), 6), this.Hundred));
            row.getCell(FIELD_UnNetRealizable).setValue((Object)this.divide(row.getCell(FIELD_NetRealizable), row.getCell(FIELD_InvQty), 0));
            return;
        }
        this.setSubCell(row.getCell(FIELD_DepToCharge), row.getCell(FIELD_InvAmount), row.getCell(FIELD_NetRealizable));
        this.setDepChargedRowValue(row);
        this.setSubCell(row.getCell(FIELD_CurDepCharge), row.getCell(FIELD_DepToCharge), row.getCell(FIELD_DepCharged));
    }

    private void caculateDepCharged(IRow row, KDTEditEvent e) {
        this.setSubCell(row.getCell(FIELD_CurDepCharge), row.getCell(FIELD_DepToCharge), row.getCell(FIELD_DepCharged));
    }

    private void setDepChargedRowValue(IRow row) {
        if (row.getCell(FIELD_DepCharged).getValue() == null && row.getCell(FIELD_MaterialNum) instanceof MaterialInfo) {
            MaterialInfo materialInfo = (MaterialInfo)row.getCell(FIELD_MaterialNum).getValue();
            try {
                this.setLastDepChargedRow(row.getRowIndex(), new MaterialInfo[]{materialInfo});
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
    }

    private boolean checkUnNetRealizable(IRow row) {
        if (row.getCell(FIELD_UnNetRealizable) != null && row.getCell(FIELD_UnNetRealizable).getValue() instanceof BigDecimal) {
            BigDecimal unNet = (BigDecimal)row.getCell(FIELD_UnNetRealizable).getValue();
            if (unNet.compareTo(SysConstant.BIGZERO) < 0) {
                MsgBox.showInfo(null, (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"223_DepChargeField"));
                return false;
            }
            BigDecimal invPrice = (BigDecimal)row.getCell(FIELD_InvPrice).getValue();
            if (invPrice != null && unNet.compareTo(invPrice) > 0) {
                MsgBox.showInfo(null, (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"224_DepChargeField"));
                return false;
            }
        }
        return true;
    }

    private void setSubCell(ICell result, ICell main, ICell sub) {
        if (result != null && main != null && sub != null) {
            result.setValue((Object)this.substract(main.getValue(), sub.getValue()));
        }
    }

    private BigDecimal substract(Object main, Object subtrahend) {
        main = this.transObjectToValue(main);
        subtrahend = this.transObjectToValue(subtrahend);
        if (main instanceof BigDecimal && subtrahend instanceof BigDecimal) {
            BigDecimal mainBD = (BigDecimal)main;
            BigDecimal subtrahendBD = (BigDecimal)subtrahend;
            mainBD = mainBD.subtract(subtrahendBD);
            return mainBD;
        }
        return SysConstant.BIGZERO;
    }

    private BigDecimal divide(Object main, Object divisor, int precision) {
        main = this.transObjectToValue(main);
        divisor = this.transObjectToValue(divisor);
        if (main instanceof BigDecimal && divisor instanceof BigDecimal) {
            BigDecimal mainBD = (BigDecimal)main;
            BigDecimal divisorBD = (BigDecimal)divisor;
            if (SysConstant.BIGZERO.compareTo(divisorBD) == 0) {
                return this.One;
            }
            if (precision == 0) {
                precision = Math.max(mainBD.scale(), divisorBD.scale()) + 2;
            }
            mainBD = mainBD.divide(divisorBD, precision, 4);
            return mainBD;
        }
        return this.One;
    }

    private BigDecimal multiply(Object main, Object multiplicand) {
        main = this.transObjectToValue(main);
        multiplicand = this.transObjectToValue(multiplicand);
        if (main instanceof BigDecimal && multiplicand instanceof BigDecimal) {
            BigDecimal mainBD = (BigDecimal)main;
            BigDecimal multiplicandBD = (BigDecimal)multiplicand;
            mainBD = mainBD.multiply(multiplicandBD);
            return mainBD;
        }
        return this.One;
    }

    private Object transObjectToValue(Object main) {
        if (main instanceof ICell) {
            main = ((ICell)main).getValue();
        }
        if (main instanceof String) {
            main = new BigDecimal((String)main);
        }
        return main;
    }

    public void initDepChargeAmtColumn(int precison) {
        int length = this.amtCols.length;
        for (int i = 0; i < length; ++i) {
            this.setCellByTextField(this.amtCols[i], precison, null, null);
        }
        this.currencyPrecision = precison;
    }

    public void initDepChargePriceColumn(int precision) {
        int length = this.priceCols.length;
        for (int i = 0; i < length; ++i) {
            this.setCellByTextField(this.priceCols[i], precision, null, SysConstant.BIGZERO);
        }
    }

    public void initDepChargeQytColumn(int measureUnitPrecison) {
        this.setCellByTextField(FIELD_InvQty, measureUnitPrecison, null, null);
    }

    public void formatDepChargeAmtColumn() {
        int num = this.defaultTable.getRowCount();
        MaterialInfo[] materialInfos = new MaterialInfo[num];
        MeasureUnitInfo[] measureBaseUnitInfos = new MeasureUnitInfo[num];
        for (int i = 0; i < num; ++i) {
            materialInfos[i] = (MaterialInfo)this.defaultTable.getRow(i).getCell(FIELD_MaterialNum).getValue();
            if (materialInfos[i] == null) {
                return;
            }
            measureBaseUnitInfos[i] = materialInfos[i].getBaseUnit();
        }
        SCMClientUtils.changeTableRowColPrecisionByMaterial((MaterialInfo[])materialInfos, (KDTable)this.defaultTable, (String[])this.priceCols);
        try {
            SCMClientUtils.changeTableRowColPrecisionByMaterial((MaterialInfo[])materialInfos, (MeasureUnitInfo[])measureBaseUnitInfos, (KDTable)this.defaultTable, (String[])this.qtyCols);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        SCMClientUtils.changeTableColPrecision((int)this.currencyPrecision, (KDTable)this.defaultTable, (String[])this.amtCols);
    }

    public void formatDepChargePriceColumn() {
    }

    public void formatDepChargeQytColumn() {
    }

    public void initDepChargeRatioColumn() {
        this.setCellByTextField(FIELD_invDepRatio, 4, new BigDecimal("100.0000"), SysConstant.BIGZERO);
    }

    public void initDepChargeMeasureUnitColumn() {
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.defaultTable.getColumn(FIELD_MeasureUnit).setRenderer((IBasicRender)avr);
    }

    public void setCellByTextField(KDTable tblMain, String property, int precision, BigDecimal maxValue, BigDecimal minValue) {
        if (tblMain.getColumn(property) == null) {
            return;
        }
        String colPrecision = PrecisionUtil.getFormatString((int)precision);
        KDFormattedTextField formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setPrecision(precision);
        formattedTextField.setRoundingMode(4);
        formattedTextField.setMaximumValue((Comparable)maxValue);
        formattedTextField.setMinimumValue((Comparable)minValue);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
        tblMain.getColumn(property).getStyleAttributes().setNumberFormat(colPrecision);
    }

    public void setCellByTextField(String columName, int precision, BigDecimal maxValue, BigDecimal minValue) {
        this.setCellByTextField(this.defaultTable, columName, precision, maxValue, minValue);
    }

    public void setRowByPrecision(IRow row, String columnName, int precision) {
        if (row == null || row.getCell(columnName) == null) {
            return;
        }
        String colPrecision = PrecisionUtil.getFormatString((int)precision);
        KDFormattedTextField formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setPrecision(precision);
        formattedTextField.setRoundingMode(4);
        row.getCell(columnName).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
        row.getCell(columnName).getStyleAttributes().setNumberFormat(colPrecision);
        if (row.getCell(columnName).getValue() instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)row.getCell(columnName).getValue();
            bd = bd.setScale(precision, 4);
            row.getCell(columnName).setValue((Object)bd);
        }
    }

    public void setUnNetRealizableRow(int rowIdx, MaterialInfo[] materialInfos) throws EASBizException, BOSException {
        HashMap<String, Object> materialPriceMap = new HashMap<String, Object>();
        BigDecimal[] priceArray = new BigDecimal[materialInfos.length];
        int rowLength = materialInfos.length;
        for (int rowCounter = rowIdx; rowCounter < rowLength; ++rowCounter) {
            BigDecimal invPrice;
            Object obj = this.defaultTable.getRow(rowCounter).getCell(FIELD_InvPrice).getValue();
            if (!(obj instanceof BigDecimal)) continue;
            priceArray[rowCounter] = invPrice = (BigDecimal)obj;
        }
        materialPriceMap.put("currentCompany", this.currentCompany);
        materialPriceMap.put("materialInfos", materialInfos);
        materialPriceMap.put("priceArray", priceArray);
        BigDecimal[] valueArray = DepChargeFactory.getRemoteInstance().getCurLastUnNetRealizable(materialPriceMap);
        int materialSize = materialInfos.length;
        for (int rowSeq = 0; rowSeq < materialSize; ++rowSeq) {
            if (valueArray[rowSeq] == null) continue;
            this.defaultTable.getRow(rowIdx + rowSeq).getCell(FIELD_UnNetRealizable).setValue((Object)valueArray[rowSeq]);
        }
    }

    public void setLastDepChargedRow(int rowIdx, MaterialInfo[] materialInfos) throws EASBizException, BOSException {
        HashMap<String, Object> materialMap = new HashMap<String, Object>();
        materialMap.put("currentCompany", this.currentCompany);
        materialMap.put("materialInfos", materialInfos);
        BigDecimal[] valueArray = DepChargeFactory.getRemoteInstance().getLastDepCharged(materialMap);
        for (int rowSeq = 0; rowSeq < materialInfos.length; ++rowSeq) {
            if (valueArray[rowSeq] == null) continue;
            this.defaultTable.getRow(rowIdx + rowSeq).getCell(FIELD_DepCharged).setValue((Object)valueArray[rowSeq]);
        }
    }

    public void caculateNetRealizableByMaterial(int rowIdx, MaterialInfo[] materialInfos) {
        IRow row = null;
        int rowLength = materialInfos.length;
        for (int i = 0; i < rowLength; ++i) {
            row = this.defaultTable.getRow(i + rowIdx);
            row.getCell(FIELD_NetRealizable).setValue((Object)SysConstant.BIGZERO);
            row.getCell(FIELD_invDepRatio).setValue((Object)this.Hundred);
            if (row.getCell(FIELD_InvAmount).getValue() != null && row.getCell(FIELD_InvAmount).getValue() instanceof BigDecimal && SysConstant.BIGZERO.compareTo((BigDecimal)row.getCell(FIELD_InvAmount).getValue()) == 0) {
                row.getCell(FIELD_invDepRatio).setValue((Object)SysConstant.BIGZERO);
            }
            row.getCell(FIELD_UnNetRealizable).setValue((Object)SysConstant.BIGZERO);
            this.setSubCell(row.getCell(FIELD_DepToCharge), row.getCell(FIELD_InvAmount), row.getCell(FIELD_NetRealizable));
            this.setDepChargedRowValue(row);
            this.setSubCell(row.getCell(FIELD_CurDepCharge), row.getCell(FIELD_DepToCharge), row.getCell(FIELD_DepCharged));
        }
    }

    public void clearRow(int rowIdx) {
        IRow row = this.defaultTable.getRow(rowIdx);
        row.getCell(FIELD_invDepRatio).setValue(null);
        row.getCell(FIELD_UnNetRealizable).setValue(null);
        row.getCell(FIELD_NetRealizable).setValue(null);
        row.getCell(FIELD_MaterialName).setValue(null);
        row.getCell(FIELD_MaterialModel).setValue(null);
        row.getCell(FIELD_MeasureUnit).setValue(null);
        row.getCell(FIELD_InvPrice).setValue(null);
        row.getCell(FIELD_DepToCharge).setValue(null);
        row.getCell(FIELD_DepCharged).setValue(null);
        row.getCell(FIELD_CurDepCharge).setValue(null);
        row.getCell(FIELD_InvQty).setValue(null);
        row.getCell(FIELD_InvAmount).setValue(null);
        row.getCell(FIELD_QtyReverse).setValue(null);
        row.getCell(FIELD_AmtReverse).setValue(null);
    }
}

