/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.newutil;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.app.alter.AlterObject;
import com.kingdee.eas.scm.cal.app.calculate.CheckBizHappenedSql;
import com.kingdee.eas.scm.cal.newutil.DBUtil;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;

public class CalculateKindAlterUtil {
    public static boolean isAlterCalculateType(Context ctx, AlterObject param) throws BOSException, EASBizException {
        String[] checkSql = CalculateKindAlterUtil.getCheckSql(ctx, param);
        return DBUtil.takeValue(ctx, checkSql);
    }

    public static boolean isExistInitBill(Context ctx, AlterObject param) throws BOSException {
        String checkSql = CalculateKindAlterUtil.getIsExistInitBillSql(param);
        return DBUtil.takeValue(ctx, checkSql.toString()) != null;
    }

    public static boolean existStandAndCostAdjRefcator(Context ctx, AlterObject param) throws BOSException {
        String checkSql = CalculateKindAlterUtil.getcheckExistStandardcostAdjBill(param);
        return DBUtil.takeValue(ctx, checkSql.toString()) != null;
    }

    private static String getcheckExistStandardcostAdjBill(AlterObject param) {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append("SELECT 1 FROM T_CL_StandardCostAdjBill T1 INNER JOIN T_CL_StandardCostAdjEntry T2");
        buffer.append("\n ON T1.FID = T2.FPARENTID");
        buffer.append("\n WHERE T1.FBASESTATUS =4");
        buffer.append("\n AND T1.FCompanyOrgUnitID='" + param.getcompanyID() + "'");
        buffer.append("\n AND (T1.FYear > ").append(param.getYear());
        buffer.append("\n OR (T1.FYear=" + param.getYear());
        buffer.append(" AND T1.FPERIOD >=" + param.getPeriod());
        buffer.append("))");
        buffer.append("\n AND T2.FMATERIALID IN(" + CalculateKindAlterUtil.getMaterialsCon(param.getMateriaIDS()));
        buffer.append(")");
        buffer.append("\n UNION ALL");
        buffer.append("\n SELECT 1 FROM T_CL_CostAdjustBill T1 INNER JOIN T_CL_CostAdjustBillEntry T2");
        buffer.append("\n ON T1.FID = T2.FPARENTID");
        buffer.append("\n WHERE T1.FBASESTATUS =4");
        buffer.append("\n AND T2.FCompanyOrgUnitID='" + param.getcompanyID() + "'");
        buffer.append("\n AND (T1.FYear > ").append(param.getYear());
        buffer.append("\n OR (T1.FYear=" + param.getYear());
        buffer.append(" AND T1.FPERIOD >=" + param.getPeriod());
        buffer.append("))");
        buffer.append("\n AND T2.FMATERIALID IN(" + CalculateKindAlterUtil.getMaterialsCon(param.getMateriaIDS()));
        buffer.append(")");
        return buffer.toString();
    }

    public static boolean isExistCostAdjust(Context ctx, AlterObject param) throws BOSException {
        String checkSql = CalculateKindAlterUtil.getcheckExistcostAdjBill(param);
        return DBUtil.takeValue(ctx, checkSql.toString()) != null;
    }

    private static String getcheckExistcostAdjBill(AlterObject param) {
        StringBuffer buffer = new StringBuffer(512);
        buffer.append("\n SELECT 1 FROM T_CL_CostAdjustBill T1 INNER JOIN T_CL_CostAdjustBillEntry T2");
        buffer.append("\n ON T1.FID = T2.FPARENTID");
        buffer.append("\n WHERE T1.FBASESTATUS =4");
        buffer.append("\n AND T2.FCompanyOrgUnitID='" + param.getcompanyID() + "'");
        buffer.append("\n AND (T1.FYear > ").append(param.getYear());
        buffer.append("\n OR (T1.FYear=" + param.getYear());
        buffer.append(" AND T1.FPERIOD >=" + param.getPeriod());
        buffer.append("))");
        buffer.append("\n AND T2.FMATERIALID IN(" + CalculateKindAlterUtil.getMaterialsCon(param.getMateriaIDS()));
        buffer.append(")");
        return buffer.toString();
    }

    public static void updateStandardCost(Context ctx, AlterObject param) throws BOSException {
        Object[] materialIDs = param.getMateriaIDS();
        BigDecimal[] standardCost = param.getNewStandardCost();
        BigDecimal zero = new BigDecimal("0.0");
        ArrayList<String> sqlList = new ArrayList<String>();
        String companyid = param.getcompanyID();
        if (!ArrayUtil.isEmpty((Object[])materialIDs)) {
            int n = materialIDs.length;
            for (int i = 0; i < n; ++i) {
                BigDecimal stCost = null == standardCost[i] ? zero : standardCost[i];
                sqlList.add(CalculateKindAlterUtil.getUpdateStandardCost(companyid, (String)materialIDs[i], stCost));
            }
        }
        if (sqlList.size() > 0) {
            DBUtil.execute(ctx, sqlList.toArray(new String[0]));
        }
    }

    public static void updateAccountType(Context ctx, AlterObject param) throws BOSException {
        String sql = CalculateKindAlterUtil.getUpdateMaterialAccountType(param);
        DBUtil.execute((Context)ctx, (String)sql);
    }

    private static String[] getCheckSql(Context ctx, AlterObject param) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)param.getcompanyID()));
        PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company);
        CheckBizHappenedSql bizSql = new CheckBizHappenedSql();
        bizSql.setCompanyOrgUnitId(param.getcompanyID());
        bizSql.setCalcualte(true);
        bizSql.setExtendWhereCondition(true);
        bizSql.setExtendJoinTable(true);
        bizSql.setFilterIsCalculate(true);
        bizSql.setStartDate(curPeriodInfo.getBeginDate());
        bizSql.setAccountType(param.getSourceAccountType());
        StringBuffer extendSql = new StringBuffer(300);
        extendSql.append(" INNER JOIN T_CL_CalculateKindRefactEntry as CalculateKindRefactEntry ");
        extendSql.append("\n ON (CalculateKindRefactEntry.FMATERIALID = ENTRY.FMATERIALID)");
        extendSql.append("\n INNER JOIN T_CL_CalculateKindRefactorBill as CalculateKindRefactorBill ");
        extendSql.append("\n ON (CalculateKindRefactorBill.FID = CalculateKindRefactEntry.FPARENTID)");
        bizSql.setExtendJoinTable(extendSql.toString());
        StringBuffer extendWhereCon = new StringBuffer(64);
        extendWhereCon.append(" CalculateKindRefactorBill.fid ='").append(param.getBill().getId().toString()).append("'");
        bizSql.setExtendWhereCondition(extendWhereCon.toString());
        String[] checks = new String[]{bizSql.getInBillSql(), bizSql.getOutBillSql()};
        return checks;
    }

    public static void delteRecentCost(Context ctx, AlterObject param) throws BOSException {
        String clearSql = CalculateKindAlterUtil.getDeleteRecentCostSql(param);
        DBUtil.execute((Context)ctx, (String)clearSql);
    }

    public static void deleteCalBanalce(Context ctx, AlterObject param) throws CalculateException, SQLException, BOSException {
        String sql = CalculateKindAlterUtil.getDeleteCalInvBalanceSql(param);
        DBUtil.execute((Context)ctx, (String)sql);
    }

    private static String getDeleteRecentCostSql(AlterObject param) {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("DELETE FROM T_CL_RECENTCOST ");
        buffer.append("\n WHERE FCompanyOrgUnitID='" + param.getcompanyID() + "'");
        buffer.append("\n AND FMaterialID in(" + CalculateKindAlterUtil.getMaterialsCon(param.getMateriaIDS()));
        buffer.append(")");
        return buffer.toString();
    }

    public static void inertRecentCost(Context ctx, AlterObject param) throws BOSException {
        String sql = CalculateKindAlterUtil.getInsertRecentCostSql(param);
        DBUtil.execute((Context)ctx, (String)sql);
    }

    private static String getInsertRecentCostSql(AlterObject param) {
        StringBuffer buffer = new StringBuffer(1024);
        int calculKind = param.getCalculateKind();
        buffer.append("INSERT INTO T_CL_RECENTCOST(FID,FCOMPANYORGUNITID,");
        if (calculKind == 1) {
            buffer.append("FSTORAGEORGUNITID,");
        } else if (calculKind == 2) {
            buffer.append("FSTORAGEORGUNITID,");
            buffer.append("FWAREHOUSEID,");
        }
        buffer.append("FMATERIALID,FRECENTQTY,FRECENTCOST,FPRICE)");
        buffer.append("\n SELECT NEWBOSID('88888888') AS FID,T1.FCOMPANYORGUNITID,");
        if (calculKind == 1) {
            buffer.append("T1.FSTORAGEORGUNITID,");
        } else if (calculKind == 2) {
            buffer.append("T1.FSTORAGEORGUNITID,");
            buffer.append("T1.FWAREHOUSEID,");
        }
        buffer.append("T1.FMATERIALID,");
        buffer.append("\n SUM(T1.FPERIODBEGINQTY) AS QTY ,SUM(T1.FPERIODBEGINBALANCE) AS AMOUNT,");
        buffer.append("\n CASE  WHEN DECIMAL(SUM(T1.FPERIODBEGINQTY),17,4)=0 THEN 0 ");
        buffer.append("\n ELSE ABS(DECIMAL(SUM(T1.FPERIODBEGINBALANCE),17,4)/DECIMAL(SUM(T1.FPERIODBEGINQTY),17,4))");
        buffer.append("\n END  AS FPRICE");
        buffer.append("\n FROM T_IM_INVENTORYBALANCE T1 INNER JOIN T_BD_MATERIALCOMPANYINFO T2 ");
        buffer.append("\n ON T1.FMATERIALID = T2.FMATERIALID AND T1.FCOMPANYORGUNITID = T2.FCOMPANYID");
        buffer.append("\n WHERE T1.FYEAR = ");
        buffer.append(param.getYear());
        buffer.append("\n AND T1.FPERIOD = ");
        buffer.append(param.getPeriod());
        buffer.append("\n AND T1.FMATERIALID IN (");
        buffer.append(CalculateKindAlterUtil.getMaterialsCon(param.getMateriaIDS()));
        buffer.append(")");
        buffer.append("\n GROUP BY T1.FCOMPANYORGUNITID,");
        if (calculKind == 1) {
            buffer.append("T1.FSTORAGEORGUNITID,");
        } else if (calculKind == 2) {
            buffer.append("T1.FSTORAGEORGUNITID,");
            buffer.append("T1.FWAREHOUSEID,");
        }
        buffer.append("T1.FMATERIALID");
        return buffer.toString();
    }

    private static String getUpdateStandardCost(String companyID, String materialID, BigDecimal newPrice) {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("UPDATE T_BD_MaterialCompanyInfo SET FStandardCost =DECIMAL(" + newPrice + ",21,8)");
        buffer.append("\n WHERE FCompanyID='" + companyID + "'");
        buffer.append("\n AND FMaterialID='" + materialID + "'");
        return buffer.toString();
    }

    private static String getUpdateMaterialAccountType(AlterObject param) {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("UPDATE T_BD_MATERIALCOMPANYINFO SET FAccountType=" + param.getNewAccountType());
        buffer.append("\n WHERE FCompanyID='" + param.getcompanyID() + "'");
        buffer.append("\n AND FMaterialID IN (");
        buffer.append(CalculateKindAlterUtil.getMaterialsCon(param.getMateriaIDS()));
        buffer.append(")");
        return buffer.toString();
    }

    private static String getDeleteCalInvBalanceSql(AlterObject param) throws CalculateException, SQLException {
        StringBuffer sql = new StringBuffer(256);
        sql.append(" delete from ").append("T_CL_InventoryBalance");
        sql.append("\n Where ");
        sql.append("\n FYear = ").append(param.getYear());
        sql.append("\n and FPeriod =").append(param.getPeriod());
        sql.append("\n AND FCompanyOrgUnitID='" + param.getcompanyID() + "'");
        sql.append("\n and fmaterialid IN (");
        sql.append(CalculateKindAlterUtil.getMaterialsCon(param.getMateriaIDS()));
        sql.append(" )");
        return sql.toString();
    }

    private static String getMaterialsCon(String[] materids) {
        return ArrayUtil.getStringFromArr((Object[])materids, (String)",", (boolean)true);
    }

    private static String getIsExistInitBillSql(AlterObject param) {
        StringBuffer buffer = new StringBuffer(512);
        buffer.append("SELECT 1 FROM  T_IM_InventoryInitBill T1 INNER JOIN T_IM_INVENTORYINITENTRY T2 ");
        buffer.append("\n ON T1.FID = T2.FPARENTID");
        buffer.append("\n AND T1.FCompanyOrgUnitID ='" + param.getcompanyID() + "'");
        buffer.append("\n AND (T1.FYear > ").append(param.getYear());
        buffer.append("\n OR (T1.FYear=" + param.getYear());
        buffer.append(" AND T1.FPERIOD >=" + param.getPeriod());
        buffer.append("))");
        buffer.append("\n AND T1.FBASESTATUS =4");
        buffer.append("\n WHERE T2.FMATERIALID IN (");
        buffer.append(CalculateKindAlterUtil.getMaterialsCon(param.getMateriaIDS()));
        buffer.append(" )");
        buffer.append("\n AND T2.FDiffAmount != 0");
        return buffer.toString();
    }
}

