/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.newutil;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fi.gl.GLException;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.newutil.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.scm.util.uicontrol.SCMGroupClientUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class CalculateUtil
implements Serializable {
    public static final String T_SM_PURINVOICEBILL = "t_sm_purinvoicebill";
    public static final String T_SM_PURINVOICEENTRY = "t_sm_purinvoiceentry";
    public static final String T_SD_SALEINVOICEBILL = "t_sd_saleinvoicebill";
    public static final String T_SD_SALEINVOICEENTRY = "t_sd_saleinvoiceentry";
    public static final String T_IM_PURINWAREHSBILL = "t_im_purinwarehsbill";
    public static final String T_IM_PURINWAREHSENTRY = "t_im_purinwarehsentry";
    public static final String T_IM_SALEISSUEBILL = "t_im_saleissuebill";
    public static final String T_IM_SALEISSUEENTRY = "t_im_saleissueentry";
    public static final String T_IM_MOVEISSUEBILL = "t_im_moveissuebill";
    public static final String T_IM_MOVEISSUEBILLENTRY = "t_im_moveissuebillentry";
    public static final String T_IM_MOVEINWAREHSBILL = "t_im_moveinwarehsbill";
    public static final String T_IM_MOVEINWAREHSBILLENTRY = "t_im_moveinwarehsbillentry";
    public static final String T_IM_MATERIALREQBILL = "t_im_materialreqbill";
    public static final String T_IM_MATERIALREQBILLENTRY = "t_im_materialreqbillentry";
    public static final String T_IM_MANUFACTURERECBILL = "t_im_manufacturerecbill";
    public static final String T_IM_MANUFACTURERECBILLENTRY = "t_im_manufacturerecbillentry";
    public static final String T_IM_OTHERISSUEBILL = "t_im_otherissuebill";
    public static final String T_IM_OTHERISSUEBILLENTRY = "t_im_otherissuebillentry";
    public static final String T_IM_OTHERINWAREHSBILL = "t_im_otherinwarehsbill";
    public static final String T_IM_OTHERINWAREHSBILLENTRY = "t_im_otherinwarehsbillentry";
    public static final String T_CL_COSTADJUSTBILL = "t_cl_costadjustbill";
    public static final String T_CL_COSTADJUSTBILLENTRY = "t_cl_costadjustbillentry";
    public static final String T_AP_OTHERBILL = "t_ap_otherbill";
    public static final String T_AP_OTHERBILLENTRY = "t_ap_otherbillentry";
    public static final String T_AR_OTHERBILL = "t_ar_otherbill";
    public static final String T_AR_OTHERBILLENTRY = "t_ar_otherbillentry";
    public static final String T_CL_INVENTORYBALANCE = "T_CL_InventoryBalance";
    public static final String T_IM_INVENTORYBALANCE = "T_IM_InventoryBalance";
    private static final long serialVersionUID = -1365076793432468729L;

    public static int getLocalCurrencyPrecision2(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer(50);
        sql.append(" select currency.fPrecision from ");
        sql.append(" t_org_company company inner join t_bd_currency currency");
        sql.append(" on company.fbaseCurrencyid=currency.fid");
        sql.append(" where company.fid='").append(companyOrgUnitInfo.getId()).append("'");
        Object obj = DBUtil.takeValue(ctx, sql.toString());
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).intValue();
        }
        return 2;
    }

    public static int getLocalCurrencyPrecision(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo) throws EASBizException, BOSException {
        CurrencyInfo currency = null;
        if (null == companyOrgUnitInfo) {
            return 2;
        }
        currency = companyOrgUnitInfo.getBaseCurrency() != null ? companyOrgUnitInfo.getBaseCurrency() : CalculateUtil.getCurrencyByCou(ctx, companyOrgUnitInfo.getId().toString());
        return CalculateUtil.getCurrencyPrecision(ctx, currency);
    }

    public static int getLocalCurrencyPrecision(Context ctx, String compnayId) throws EASBizException, BOSException {
        CurrencyInfo currency = null;
        if (compnayId != null) {
            currency = CalculateUtil.getCurrencyByCou(ctx, compnayId);
        }
        return CalculateUtil.getCurrencyPrecision(ctx, currency);
    }

    private static CurrencyInfo getCurrencyByCou(Context ctx, String companyId) throws BOSException, EASBizException {
        ICompanyOrgUnit corgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("baseCurrency");
        CompanyOrgUnitInfo info = corgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selectors);
        return info.getBaseCurrency();
    }

    private static int getCurrencyPrecision(Context ctx, CurrencyInfo currency) throws BOSException, EASBizException {
        if (currency != null) {
            ICurrency ic = ctx != null ? CurrencyFactory.getLocalInstance((Context)ctx) : CurrencyFactory.getRemoteInstance();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("Precision"));
            currency = ic.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId().toString()), sic);
            return currency.getPrecision();
        }
        return 2;
    }

    public static CurrencyInfo getCurrencyInfo(Context ctx, String currencyID) throws BOSException, EASBizException {
        if (!StringUtil.isEmpty((String)currencyID)) {
            ICurrency ic = ctx != null ? CurrencyFactory.getLocalInstance((Context)ctx) : CurrencyFactory.getRemoteInstance();
            CurrencyInfo currency = ic.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID));
            return currency;
        }
        return null;
    }

    public static boolean isOnlyUseAddAverage(Context ctx, String orgUnitID) throws BOSException {
        StringBuffer sql = new StringBuffer(150);
        sql.append("select top 1 fid from t_bd_materialcompanyinfo ");
        sql.append(" where fcompanyid='").append(orgUnitID).append("'");
        sql.append(" and (");
        sql.append(" (");
        sql.append(" faccounttype=").append(3);
        sql.append(" and (");
        sql.append("    fstatus=").append(1);
        sql.append(" or fstatus=").append(2);
        sql.append(" )");
        sql.append(" )");
        sql.append(" or ");
        sql.append(" (");
        sql.append(" faccounttype=").append(4);
        sql.append(" and (");
        sql.append("    fstatus=").append(1);
        sql.append(" or fstatus=").append(2);
        sql.append(" )");
        sql.append(" )");
        sql.append(" or ");
        sql.append(" (");
        sql.append(" faccounttype=").append(5);
        sql.append(" and (");
        sql.append("    fstatus=").append(1);
        sql.append(" or fstatus=").append(2);
        sql.append(" )");
        sql.append(" )");
        sql.append(" )");
        return DBUtil.takeValue(ctx, sql.toString()) == null;
    }

    public static StringBuffer fmtTableString(int scale) throws BOSException, EASBizException {
        StringBuffer strassetAmtFormat = new StringBuffer(20);
        if (scale > 0) {
            strassetAmtFormat.append("%r{#,##0.");
            for (int i = 0; i < scale; ++i) {
                strassetAmtFormat.append("0");
            }
            strassetAmtFormat.append("}f");
        } else {
            strassetAmtFormat.append("%r{#,###}f");
        }
        return strassetAmtFormat;
    }

    public static CompanyOrgUnitInfo takeFinanceOrgFromEntry(SCMBillBaseInfo bill) throws EASBizException, BOSException {
        InvBillBaseEntryInfo inv;
        CompanyOrgUnitInfo cou = null;
        if (bill instanceof InvBillBaseInfo && bill.get("Entry") != null && (inv = (InvBillBaseEntryInfo)((IObjectCollection)bill.get("Entry")).getObject(0)) != null) {
            cou = inv.getCompanyOrgUnit();
        }
        if (null == cou) {
            throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
        }
        return cou;
    }

    public static String takeSysServerParamValue(Context ctx, CompanyOrgUnitInfo aCompanyOrgUnitInfo, String param_2) throws EASBizException, BOSException {
        HashMap hm = ParamManager.getParamHashMap((Context)ctx, (String[])new String[]{param_2}, (String)aCompanyOrgUnitInfo.getId().toString());
        String calType = (String)hm.get(param_2);
        if (StringUtil.isEmpty((String)calType)) {
            throw new CalculateException(CalculateException.MATERIAL_CAL_KIND_NOT_EXIST);
        }
        return calType;
    }

    public static HashMap takeSysParamValue(Context ctx, CompanyOrgUnitInfo aCompanyOrgUnitInfo, String[] params) throws EASBizException, BOSException {
        HashMap hm = ParamManager.getParamHashMap((Context)ctx, (String[])params, (String)aCompanyOrgUnitInfo.getId().toString());
        return hm;
    }

    public static int takePeriodValueByDate(Context ctx, Date date, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        if (date == null) {
            throw new CalculateException(CalculateException.BIZ_DATE_IS_NULL, new String[]{""});
        }
        try {
            PeriodInfo aPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)date, (CompanyOrgUnitInfo)companyInfo, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT);
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            int i = c.get(1) * 100 + c.get(2) + 1;
            if (aPeriodInfo != null && aPeriodInfo.isIsAdjustPeriod()) {
                aPeriodInfo = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)aPeriodInfo);
            }
            if (aPeriodInfo != null) {
                i = aPeriodInfo.getPeriodYear() * 100 + aPeriodInfo.getPeriodNumber();
            }
            return i;
        }
        catch (Exception e) {
            throw new CalculateException(CalculateException.ACCT_PERIOD_NOT_EXIST, new String[]{""});
        }
    }

    public static int takePeriodValueByPeriod(PeriodInfo aPeriodInfo) {
        int period = 0;
        if (aPeriodInfo != null) {
            period = aPeriodInfo.getPeriodYear() * 100 + aPeriodInfo.getPeriodNumber();
        } else {
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            period = c.get(1) * 100 + c.get(2) + 1;
        }
        return period;
    }

    public static String takeFormateDesc(String name, String number) {
        if (StringUtil.isEmpty((String)number)) {
            return CalculateUtil.takeFormateDesc(name);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(name);
        sb.append("(");
        sb.append(number);
        sb.append(")");
        sb.append("]");
        return sb.toString();
    }

    public static String takeFormateDesc(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(name);
        sb.append("]");
        return sb.toString();
    }

    public static String transCreateTable(Context ctx, String sql) {
        String dbType = (String)ctx.get((Object)"dbType");
        if (!StringUtil.isEmpty((String)dbType) && dbType.toLowerCase().indexOf("db2") > -1) {
            sql = sql.toLowerCase();
            sql = sql.replaceAll("numeric\\(28,16\\)", "numeric(21,8)");
            sql = sql.replaceAll("numeric\\(19,4\\)", "numeric(17,4)");
        }
        return sql;
    }

    private static StringBuffer to_decimal(String string, String len, String scale) {
        StringBuffer str = new StringBuffer(32);
        str.append("TO_DECIMAL(").append(string).append(", " + len + ", " + scale + ")");
        return str;
    }

    public static StringBuffer to_decimal_sum(String string) {
        return CalculateUtil.to_decimal(string, "17", "4");
    }

    public static StringBuffer to_decimal_amt(String string) {
        return CalculateUtil.to_decimal(string, "17", "4");
    }

    public static StringBuffer to_decimal_qty(String string) {
        return CalculateUtil.to_decimal(string, "21", "8");
    }

    public static StringBuffer to_decimal_divide(String string) {
        return CalculateUtil.to_decimal(string, "21", "8");
    }

    public static HashMap getUserDefineField(Context ctx) {
        PurInWarehsEntryInfo entry = new PurInWarehsEntryInfo();
        IMetaDataLoader imeataLoader = null == ctx ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk = imeataLoader.getEntityObjectPK(entry.getBOSType());
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk);
        PropertyCollection coll = entityObjectInfo.getEntityProperties();
        HashMap<String, String> map = new HashMap<String, String>();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)coll)) {
            return map;
        }
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            OwnPropertyInfo ownprop;
            DataType dt;
            PropertyInfo info = coll.get(i);
            if (!(info instanceof OwnPropertyInfo) || !info.isUserDefined() || !DataType.DECIMAL.equals((Object)(dt = (ownprop = (OwnPropertyInfo)info).getDataType()))) continue;
            map.put(info.getMappingField().getName(), info.getAlias());
        }
        return map;
    }

    public static String getEntryTableNameFormBillTableName(String name) {
        if (T_SM_PURINVOICEBILL.equalsIgnoreCase(name)) {
            return T_SM_PURINVOICEENTRY;
        }
        if (T_SD_SALEINVOICEBILL.equalsIgnoreCase(name)) {
            return T_SD_SALEINVOICEENTRY;
        }
        if (T_IM_PURINWAREHSBILL.equalsIgnoreCase(name)) {
            return T_IM_PURINWAREHSENTRY;
        }
        if (T_IM_SALEISSUEBILL.equalsIgnoreCase(name)) {
            return T_IM_SALEISSUEENTRY;
        }
        if (T_IM_MOVEISSUEBILL.equalsIgnoreCase(name)) {
            return T_IM_MOVEISSUEBILLENTRY;
        }
        if (T_IM_MOVEINWAREHSBILL.equalsIgnoreCase(name)) {
            return T_IM_MOVEINWAREHSBILLENTRY;
        }
        if (T_IM_MATERIALREQBILL.equalsIgnoreCase(name)) {
            return T_IM_MATERIALREQBILLENTRY;
        }
        if (T_IM_MANUFACTURERECBILL.equalsIgnoreCase(name)) {
            return T_IM_MANUFACTURERECBILLENTRY;
        }
        if (T_IM_OTHERISSUEBILL.equalsIgnoreCase(name)) {
            return T_IM_OTHERISSUEBILLENTRY;
        }
        if (T_IM_OTHERINWAREHSBILL.equalsIgnoreCase(name)) {
            return T_IM_OTHERINWAREHSBILLENTRY;
        }
        if (T_CL_COSTADJUSTBILL.equalsIgnoreCase(name)) {
            return T_CL_COSTADJUSTBILLENTRY;
        }
        if (T_AP_OTHERBILL.equalsIgnoreCase(name)) {
            return T_AP_OTHERBILLENTRY;
        }
        if (T_AR_OTHERBILL.equalsIgnoreCase(name)) {
            return T_AR_OTHERBILLENTRY;
        }
        return null;
    }

    public static boolean isAuthorizedOrg(Context ctx, BOSUuid userPK, OrgType orgType, String permItem, OrgUnitInfo cou) throws EASBizException, BOSException {
        FullOrgUnitCollection coll = null;
        Object[] storageOrgs = null;
        try {
            IPermission ipermi = ctx != null ? PermissionFactory.getLocalInstance((Context)ctx) : PermissionFactory.getRemoteInstance();
            ObjectUuidPK treePK = null == orgType ? null : new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
            coll = ipermi.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userPK), orgType, (IObjectPK)treePK, permItem);
            storageOrgs = coll.toArray();
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex0) {
            throw ex0;
        }
        if (cou != null && storageOrgs != null) {
            int n = storageOrgs.length;
            for (int i = 0; i < n; ++i) {
                OrgUnitInfo orgUnit = (OrgUnitInfo)storageOrgs[i];
                if (orgUnit == null || !cou.getId().equals((Object)orgUnit.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public static StringBuffer getCreateTableSQl(String tempTableName, String[][] fields) {
        StringBuffer sql = new StringBuffer(64);
        sql.append("CREATE TABLE ");
        sql.append(tempTableName);
        sql.append("(");
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append(fields[i][0]);
            sql.append(" ");
            sql.append(fields[i][1]);
        }
        sql.append(")");
        return sql;
    }

    public static String getFormatPattern(int scale) {
        String pattern = null;
        String temp = "000000000000000000";
        String end = temp.substring(0, scale);
        pattern = scale == 0 ? "#,##0" : "#,##0." + end;
        pattern = pattern + ";-" + pattern + ";";
        return pattern;
    }

    public static AccountPeriodInfo getAccountPeriodInfo(Context ctx, String comId, String prdTypeId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        ISystemStatusCtrol ctrl = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        SystemStatusCtrolCollection col = ctrl.getSystemStatusCtrolCollection(view);
        AccountPeriodInfo pi = new AccountPeriodInfo();
        if (col.size() == 1) {
            SystemStatusCtrolInfo sci = col.get(0);
            pi.startPeriod = sci.getStartPeriod();
            pi.curPeriod = sci.getCurrentPeriod();
            if (pi.startPeriod != null) {
                String sql = "select p.FPeriodYear periodYear, MIN(p.FPeriodNumber) minPeriodNum, MAX(p.FPeriodNumber) maxPeriodNum from T_BD_Period p where p.FTypeID = ? group by p.FPeriodYear order by p.FPeriodYear";
                Connection conn = null;
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    conn = CalculateUtil.getConnection(ctx);
                    ps = conn.prepareStatement(sql);
                    ps.setString(1, prdTypeId);
                    rs = ps.executeQuery();
                    pi.periods = new Vector();
                    while (rs.next()) {
                        pi.periods.add(new int[]{rs.getInt(1), rs.getInt(2), rs.getInt(3)});
                    }
                }
                catch (SQLException ex) {
                    try {
                        throw new SQLDataException(ex);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, ps, (Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
            }
        }
        if (pi.startPeriod == null) {
            throw new CalculateException(CalculateException.PERIOD_ERROR);
        }
        if (pi.curPeriod == null) {
            throw new CalculateException(CalculateException.CURRENCY_PERIOD_ERROR);
        }
        if (pi.periods.size() == 0) {
            throw new GLException(GLException.NOPERIODLIST);
        }
        return pi;
    }

    public static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public static CompanyOrgUnitInfo getCurrentCompany(Context ctx, String comId, SelectorItemCollection sic, boolean mustBeEntity) throws BOSException, EASBizException {
        if (null == sic) {
            sic = CalculateUtil.getCompanySic();
        }
        ICompanyOrgUnit comCtrl = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitInfo com = null;
        try {
            ObjectUuidPK comPK = new ObjectUuidPK(BOSUuid.read((String)comId));
            com = (CompanyOrgUnitInfo)comCtrl.getValue((IObjectPK)comPK, sic);
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOCOMPANY, (Throwable)ex);
        }
        if (mustBeEntity && !com.isIsBizUnit()) {
            throw new GLException(GLException.COMMUSTBEENTITY);
        }
        return com;
    }

    public static SelectorItemCollection getCompanySic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("baseCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.precision"));
        sic.add(new SelectorItemInfo("reportCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("accountPeriodType.number"));
        sic.add(new SelectorItemInfo("accountPeriodType.name"));
        sic.add(new SelectorItemInfo("isGrouping"));
        sic.add(new SelectorItemInfo("isGroup"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        sic.add(new SelectorItemInfo("isBizUnit"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("reportConvertMode"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        sic.add(new SelectorItemInfo("mainOrg.id"));
        sic.add(new SelectorItemInfo("mainOrg.name"));
        sic.add(new SelectorItemInfo("mainOrg.number"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.id"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.name"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.number"));
        sic.add(new SelectorItemInfo("accountScheme.id"));
        sic.add(new SelectorItemInfo("accountScheme.name"));
        sic.add(new SelectorItemInfo("accountScheme.number"));
        return sic;
    }

    public static String getcalcHMSString(int timeSecond) {
        int timeInSecond;
        String resHour = CalculateUtil.getCalResource("COST_HOUR");
        String resMinute = CalculateUtil.getCalResource("COST_MINUTE");
        String resSecond = CalculateUtil.getCalResource("COST_SECOND");
        int es = timeSecond / 1000;
        int hour = es / 3600;
        int timeInminute = es - hour * 3600;
        int minute = timeInminute / 60;
        int second = timeInSecond = timeInminute - minute * 60;
        return hour + " " + resHour + " " + minute + " " + resMinute + " " + second + " " + resSecond;
    }

    public static String genRandomNum(int pwd_len) {
        int maxNum = 36;
        int count = 0;
        char[] str = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        StringBuffer pwd = new StringBuffer("");
        SecureRandom r = new SecureRandom();
        while (count < pwd_len) {
            int i = Math.abs(r.nextInt(36));
            if (i < 0 || i >= str.length) continue;
            pwd.append(str[i]);
            ++count;
        }
        return pwd.toString();
    }

    public static StringBuffer to_decimal_amtForOracle(String string) {
        return CalculateUtil.to_decimal(string, "19", "4");
    }

    public static String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    public static void setPurInBillNoFilterF7(KDBizPromptBox purinBillNo, boolean isFilterBillStatus, BillBaseStatusEnum baseStatus) {
        EntityViewInfo viewInfo = InvClientUtils.getBizStorageFilter();
        FilterInfo filter = new FilterInfo();
        if (isFilterBillStatus && baseStatus != null) {
            filter.getFilterItems().add(new FilterItemInfo("BASESTATUS", (Object)baseStatus.getValue(), CompareType.EQUALS));
        }
        try {
            viewInfo.getFilter().mergeFilter(filter, "AND");
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        purinBillNo.setEditFormat("$number$");
        purinBillNo.setDisplayFormat("$number$");
        purinBillNo.setCommitFormat("$number$");
        purinBillNo.setEntityViewInfo(viewInfo);
    }

    public static FullOrgUnitCollection getOrgUnitPermissionItem(Context ctx, OrgType orgType, String permissionItem, IObjectPK userPK, ObjectUuidPK treePK) {
        if (null == treePK && orgType != null) {
            treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        }
        return CalculateUtil.getOrgUnitNoTreePermissionItem(ctx, orgType, permissionItem, userPK, treePK);
    }

    public static OrgUnitInfo[] gainAuthMainBizOrgs(RequestContext request, Context context) {
        OrgUnitInfo[] mainOrgs = null;
        OrgType orgType = request.getMainOrgType();
        IObjectPK userPk = request.getUserPK();
        String permissionItem = (String)request.get("_SCMPERMISSIONITEM");
        FullOrgUnitCollection collection = CalculateUtil.getOrgUnitPermissionItem(context, orgType, permissionItem, userPk, null);
        mainOrgs = CalculateUtil.getOrgUnitInfosByType(context, collection, orgType);
        return (OrgUnitInfo[])ArrayUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, (boolean)true);
    }

    public static OrgUnitInfo[] getOrgUnitInfosByType(Context ctx, FullOrgUnitCollection orgs, OrgType orgType) {
        OrgUnitInfo[] results = null;
        if (CollectionUtil.isEmpty((AbstractObjectCollection)orgs)) {
            return null;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        int n = orgs.size();
        for (int i = 0; i < n; ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        if (!orgType.equals((Object)OrgType.Admin)) {
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
        }
        view.setFilter(filter);
        AdminOrgUnitCollection collection = null;
        try {
            switch (orgType.getValue()) {
                case 0: {
                    IAdminOrgUnit iAdmin = ctx != null ? AdminOrgUnitFactory.getLocalInstance((Context)ctx) : AdminOrgUnitFactory.getRemoteInstance();
                    collection = iAdmin.getAdminOrgUnitCollection(view);
                    break;
                }
                case 1: {
                    ICompanyOrgUnit iCompany = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
                    collection = iCompany.getCompanyOrgUnitCollection(view);
                    break;
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (!CollectionUtil.isEmpty(collection)) {
            results = new OrgUnitInfo[collection.size()];
            int n2 = collection.size();
            for (int i = 0; i < n2; ++i) {
                results[i] = (OrgUnitInfo)collection.getObject(i);
            }
        }
        return results;
    }

    public static FullOrgUnitCollection getAuthMainBizOrgs(RequestContext request, Context context) {
        FullOrgUnitCollection collection = null;
        try {
            OrgType orgType = request.getMainOrgType();
            IObjectPK userPk = request.getUserPK();
            String permissionItem = (String)request.get("_SCMPERMISSIONITEM");
            collection = CalculateUtil.getOrgUnitNoTreePermissionItem(context, orgType, permissionItem, userPk, null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return collection;
    }

    public static FullOrgUnitCollection getOrgUnitNoTreePermissionItem(Context ctx, OrgType orgType, String permissionItem, IObjectPK userPK, ObjectUuidPK treePK) {
        if (null == userPK) {
            return null;
        }
        FullOrgUnitCollection unitCol = null;
        try {
            IPermission ip = ctx != null ? PermissionFactory.getLocalInstance((Context)ctx) : PermissionFactory.getRemoteInstance();
            unitCol = ip.getAuthorizedOrg(userPK, orgType, (IObjectPK)treePK, permissionItem);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return unitCol;
    }

    public static boolean getApportVoucherType(Context ctx, String companyOrgUnitID) throws BOSException, EASBizException {
        String value = CalculateUtil.getParamValue(ctx, companyOrgUnitID, "SCM_CAL_008");
        return "1".equals(value);
    }

    public static String getCalTypeMaterialKey(String strCalType, String materialid, String compnayOrgUnitid, String storageId, String warehouseId) {
        StringBuffer buffer = new StringBuffer();
        if ("0".equals(strCalType)) {
            buffer.append(compnayOrgUnitid);
        } else if ("1".equals(strCalType)) {
            buffer.append(compnayOrgUnitid);
            if (storageId != null) {
                buffer.append("_$$$$_").append(storageId);
            }
        } else {
            buffer.append(compnayOrgUnitid);
            if (storageId != null) {
                buffer.append("_$$$$_").append(storageId);
            }
            if (warehouseId != null) {
                buffer.append("_$$$$_").append(warehouseId);
            }
        }
        buffer.append("_$$$$_").append(materialid);
        return buffer.toString();
    }

    private static String getParamValue(Context ctx, String companyOrgUnitID, String paramsNumber) throws BOSException, EASBizException {
        IParamControl ipc = null != ctx ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(companyOrgUnitID);
        return ipc.getParamValue((IObjectPK)pk, paramsNumber);
    }

    public static String getCalParamValue(Context ctx, String companyOrgUnitID, String paramsNumber) throws EASBizException, BOSException {
        return CalculateUtil.getParamValue(ctx, companyOrgUnitID, paramsNumber);
    }

    public static int getDischargeType(Context ctx, String companyOrgUnitID) throws EASBizException, BOSException {
        String value = CalculateUtil.getParamValue(ctx, companyOrgUnitID, "SCM_CAL_001");
        if (StringUtil.isEmpty((String)value)) {
            throw new CalculateException(CalculateException.PARAM_NOT_EXIST);
        }
        return Integer.parseInt(value);
    }

    public static void updatePurInfo(Context ctx, ResultSet rs, int LocalCurrPrecesion, boolean isInpSum) throws BOSException {
        String PUR_ENTRY_TABLE = "T_IM_PurInWarehsEntry";
        if (null == rs) {
            return;
        }
        HashMap valueMap = new HashMap();
        ArrayList sSQLList = new ArrayList();
        try {
            while (rs.next()) {
                String entryId = rs.getString("FID");
                if (isInpSum) {
                    CalculateUtil.calcFieldValueByUnitActualCost(rs, valueMap, LocalCurrPrecesion);
                } else {
                    CalculateUtil.calcFieldValueByUnitPurchaseCost(rs, valueMap, LocalCurrPrecesion);
                }
                CalculateUtil.createUpdateSQL("T_IM_PurInWarehsEntry", valueMap, sSQLList, entryId);
            }
            DBUtil.execBatchSql(ctx, sSQLList, true);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(null, null, new ResultSet[]{rs});
                throw throwable;
            }
        }
        DBUtil.close(null, null, new ResultSet[]{rs});
    }

    public static void updatePurInfo(Context ctx, ResultSet rs, int LocalCurrPrecesion, boolean isInpSum, boolean isFullWriteOff) throws BOSException {
        String PUR_ENTRY_TABLE = "T_IM_PurInWarehsEntry";
        if (null == rs) {
            return;
        }
        HashMap valueMap = new HashMap();
        ArrayList sSQLList = new ArrayList();
        try {
            while (rs.next()) {
                String entryId = rs.getString("FID");
                if (isInpSum) {
                    CalculateUtil.calcFieldValueByUnitActualCost(rs, valueMap, LocalCurrPrecesion);
                } else if (isFullWriteOff) {
                    CalculateUtil.calcFieldValueByPurchaseCost(rs, valueMap, LocalCurrPrecesion);
                } else {
                    CalculateUtil.calcFieldValueByUnitPurchaseCost(rs, valueMap, LocalCurrPrecesion);
                }
                CalculateUtil.createUpdateSQL("T_IM_PurInWarehsEntry", valueMap, sSQLList, entryId);
            }
            DBUtil.execBatchSql(ctx, sSQLList, true);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(null, null, new ResultSet[]{rs});
                throw throwable;
            }
        }
        DBUtil.close(null, null, new ResultSet[]{rs});
    }

    public static void inpSumUpdatePurInfo(Context ctx, String tempTableName, int sumType, PeriodInfo currPeriod, int LocalCurrPrecesion) throws BOSException {
        ResultSet rs = CalculateUtil.getPurResultSetByTempTab(ctx, tempTableName, sumType, currPeriod);
        CalculateUtil.updatePurInfo(ctx, rs, LocalCurrPrecesion, true, false);
    }

    public static void writeOffUpdatePurInfo(Context ctx, List ids, int LocalCurrPrecesion) throws BOSException {
        ResultSet rs = CalculateUtil.getPurResultSetByIds(ctx, ids);
        CalculateUtil.updatePurInfo(ctx, rs, LocalCurrPrecesion, false);
    }

    public static void writeOffUpdatePurInfo(Context ctx, List ids, int LocalCurrPrecesion, boolean isFullWriteOff) throws BOSException {
        ResultSet rs = CalculateUtil.getPurResultSetByIds(ctx, ids);
        CalculateUtil.updatePurInfo(ctx, rs, LocalCurrPrecesion, false, isFullWriteOff);
    }

    public static ResultSet getPurResultSetByIds(Context ctx, List ids) throws BOSException {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Select entry.FID,bill.FExchangeRate,bill.FConvertMode,bill.FIsInTax,bill.FIsPriceInTax,");
        sSQL.append("entry.FActualCost,entry.FUnitActualCost,IsNull(entry.FPurchaseCost, 0) as FPurchaseCost,");
        sSQL.append("IsNull(entry.FUnitPurchaseCost, 0) as FUnitPurchaseCost,IsNull(entry.FPurchaseFee, 0) as FPurchaseFee,IsNull(entry.FMaterialCost, 0) as FMaterialCost,");
        sSQL.append("entry.FUnitMaterialCost,entry.FTaxRate,entry.FQty,entry.FWrittenOffQty,entry.FDiscountRate,currency.FPrecision,material.FPricePrecision ");
        sSQL.append("from T_IM_PurInWarehsBill bill inner join T_IM_PurInWarehsEntry entry on entry.FParentid=bill.FID ");
        sSQL.append("inner join T_BD_Currency currency on currency.FID=bill.FCurrencyID ");
        sSQL.append("inner join T_BD_Material material on material.FID=entry.FMaterialID ");
        sSQL.append("where entry.FID in ({0})");
        StringBuffer idStr = new StringBuffer();
        for (int i = 0; i < ids.size(); ++i) {
            if (i != 0) {
                idStr.append(",");
            }
            idStr.append("'").append(ids.get(i)).append("'");
        }
        String selSql = MessageFormat.format(sSQL.toString(), idStr.toString());
        return DBUtil.executeQuery((Context)ctx, (String)selSql);
    }

    public static ResultSet getPurResultSetByTempTab(Context ctx, String tempTableName, int sumType, PeriodInfo currPeriod) throws BOSException {
        if (StringUtil.isEmpty((String)tempTableName) || null == currPeriod) {
            return null;
        }
        StringBuffer sSQL = new StringBuffer(1024);
        sSQL.append("Select entry.FID,bill.FExchangeRate,bill.FConvertMode,bill.FIsInTax,bill.FIsPriceInTax,");
        sSQL.append("entry.FActualCost,entry.FUnitActualCost,IsNull(entry.FPurchaseCost, 0) as FPurchaseCost,IsNull(entry.FUnitPurchaseCost, 0) as FUnitPurchaseCost,IsNull(entry.FPurchaseFee, 0) as FPurchaseFee,IsNull(entry.FMaterialCost, 0) as FMaterialCost,");
        sSQL.append("entry.FUnitMaterialCost,entry.FTaxRate,entry.FQty,entry.FWrittenOffQty,entry.FDiscountRate,currency.FPrecision,material.FPricePrecision,entry.FLocalPrice,entry.FLocalAmount ");
        sSQL.append("from T_IM_PurInWarehsBill bill, T_IM_PurInWarehsEntry entry, T_BD_Currency currency, T_BD_Material material, ").append(tempTableName).append(" temp ");
        sSQL.append("where entry.FParentid=bill.FID and currency.FID=bill.FCurrencyID and material.FID=entry.FMaterialID ");
        sSQL.append("and temp.FMaterialId=entry.FMaterialId and temp.FCompanyOrgUnitId=entry.FCompanyOrgUnitId and (ISNULL(entry.FLot,'XXXXX') = ISNULL(temp.FLot,'XXXXX') or temp.FAccountType <>5) ");
        if (3 == sumType) {
            sSQL.append("and ISNULL(bill.FAdminOrgUnitID,'XXXXX') = ISNULL(temp.FAdminOrgUnitID,'XXXXX') ");
        } else if (2 == sumType) {
            sSQL.append("and entry.FStorageOrgUnitId = temp.FStorageOrgUnitId ");
            sSQL.append("and entry.FWarehouseId = temp.FWarehouseId ");
        } else if (1 == sumType) {
            sSQL.append("and entry.FStorageOrgUnitId = temp.FStorageOrgUnitId ");
        }
        sSQL.append("and ISNULL(bill.FFiVouchered, 0)=0 and ISNULL(entry.FWrittenOffBaseQty, 0)=0 ");
        sSQL.append("and bill.FYear=").append(currPeriod.getPeriodYear()).append(" and bill.FPeriod=").append(currPeriod.getPeriodNumber());
        return DBUtil.executeQuery((Context)ctx, (String)sSQL.toString());
    }

    private static void createUpdateSQL(String tableName, HashMap valueMap, List sSQLList, String id) {
        if (StringUtil.isEmpty((String)id)) {
            return;
        }
        StringBuffer sql = new StringBuffer(64);
        boolean hasField = false;
        for (Map.Entry mapentry : valueMap.entrySet()) {
            if (mapentry.getKey() == null || mapentry.getValue() == null) continue;
            if (hasField) {
                sql.append(",");
            }
            hasField = true;
            if (mapentry.getValue() instanceof BigDecimal) {
                sql.append(mapentry.getKey()).append("=").append(StringUtil.bigDecimal2String((BigDecimal)((BigDecimal)mapentry.getValue())));
                continue;
            }
            sql.append(mapentry.getKey()).append("=").append(mapentry.getValue());
        }
        if (hasField) {
            StringBuffer returnStrSQL = new StringBuffer();
            returnStrSQL.append(" update ").append(tableName);
            returnStrSQL.append(" set ");
            returnStrSQL.append(sql);
            returnStrSQL.append(" where fid = '").append(id).append("'");
            sSQLList.add(returnStrSQL.toString());
        }
    }

    private static void calcFieldValueByPurchaseCost(ResultSet rs, HashMap valueMap, int LocalCurrPrecesion) throws SQLException {
        BigDecimal ONE = BigDecimal.ONE;
        int convertMode = rs.getInt("FConvertMode");
        int isInTax = rs.getInt("FIsInTax");
        int isPriceInTax = rs.getInt("FIsPriceInTax");
        BigDecimal unitPurchaseCost = rs.getBigDecimal("FUnitPurchaseCost");
        BigDecimal purchaseCost = rs.getBigDecimal("FPurchaseCost");
        int currPrecision = rs.getInt("FPrecision");
        int pricePrecision = rs.getInt("FPricePrecision");
        BigDecimal exchangeRate = rs.getBigDecimal("FExchangeRate");
        BigDecimal taxRate = rs.getBigDecimal("FTaxRate").divide(new BigDecimal("100"), 8, 4);
        BigDecimal discountRate = rs.getBigDecimal("FDiscountRate").divide(new BigDecimal("100"), 8, 4);
        BigDecimal qty = rs.getBigDecimal("FQty");
        unitPurchaseCost = qty.signum() == 0 ? BigDecimal.ZERO : purchaseCost.divide(qty, pricePrecision, 4);
        valueMap.put("FUnitPurchaseCost", unitPurchaseCost);
        BigDecimal actualCost = purchaseCost.add(rs.getBigDecimal("FPurchaseFee")).add(rs.getBigDecimal("FMaterialCost"));
        valueMap.put("FActualCost", actualCost);
        BigDecimal unitActualCost = actualCost.divide(qty, pricePrecision, 4);
        valueMap.put("FUnitActualCost", unitActualCost);
        BigDecimal amount = 0 == convertMode ? purchaseCost.divide(exchangeRate, currPrecision, 4) : purchaseCost.multiply(exchangeRate).setScale(currPrecision, 4);
        valueMap.put("FAmount", amount);
        BigDecimal localTax = purchaseCost.multiply(taxRate).setScale(LocalCurrPrecesion, 4);
        valueMap.put("FLocalTax", localTax);
        BigDecimal tax = 0 == convertMode ? localTax.divide(exchangeRate, currPrecision, 4) : localTax.multiply(exchangeRate).setScale(currPrecision, 4);
        valueMap.put("FTax", tax);
        BigDecimal taxAmount = amount.add(tax).setScale(currPrecision, 4);
        valueMap.put("FTaxAmount", taxAmount);
        BigDecimal localTaxAmount = purchaseCost.add(localTax);
        valueMap.put("FLocalTaxAmount", localTaxAmount);
        BigDecimal discountAmount = taxAmount.multiply(discountRate).divide(ONE.subtract(discountRate), currPrecision, 4);
        valueMap.put("FDiscountAmount", discountAmount);
        BigDecimal taxPrice = taxAmount.divide(qty, 10, 4).divide(ONE.subtract(discountRate), pricePrecision, 4);
        valueMap.put("FTaxPrice", taxPrice);
        BigDecimal price = amount.divide(qty, 10, 4).divide(ONE.subtract(discountRate), pricePrecision, 4);
        valueMap.put("FPrice", price);
        BigDecimal actualPrice = NumericUtil.isEqualsZero((BigDecimal)discountRate) ? price : amount.divide(qty, pricePrecision, 4);
        valueMap.put("FActualPrice", actualPrice);
        BigDecimal actualTaxPrice = NumericUtil.isEqualsZero((BigDecimal)discountRate) ? taxPrice : taxAmount.divide(qty, pricePrecision, 4);
        valueMap.put("FActualTaxPrice", actualTaxPrice);
    }

    private static void calcFieldValueByUnitPurchaseCost(ResultSet rs, HashMap valueMap, int LocalCurrPrecesion) throws SQLException {
        BigDecimal taxAmount;
        BigDecimal localTaxAmount;
        BigDecimal tax;
        BigDecimal localTax;
        BigDecimal taxPrice;
        BigDecimal price;
        BigDecimal ONE = BigDecimal.ONE;
        int convertMode = rs.getInt("FConvertMode");
        int isInTax = rs.getInt("FIsInTax");
        int isPriceInTax = rs.getInt("FIsPriceInTax");
        BigDecimal unitPurchaseCost = rs.getBigDecimal("FUnitPurchaseCost");
        BigDecimal purchaseCost = rs.getBigDecimal("FPurchaseCost");
        int currPrecision = rs.getInt("FPrecision");
        int pricePrecision = rs.getInt("FPricePrecision");
        BigDecimal exchangeRate = rs.getBigDecimal("FExchangeRate");
        BigDecimal taxRate = rs.getBigDecimal("FTaxRate").divide(new BigDecimal("100"), 8, 4);
        BigDecimal discountRate = rs.getBigDecimal("FDiscountRate").divide(new BigDecimal("100"), 8, 4);
        BigDecimal qty = rs.getBigDecimal("FQty");
        purchaseCost = unitPurchaseCost.multiply(qty).setScale(LocalCurrPrecesion, 4);
        valueMap.put("FPurchaseCost", purchaseCost);
        BigDecimal actualCost = purchaseCost.add(rs.getBigDecimal("FPurchaseFee")).add(rs.getBigDecimal("FMaterialCost"));
        valueMap.put("FActualCost", actualCost);
        BigDecimal unitActualCost = actualCost.divide(qty, pricePrecision, 4);
        valueMap.put("FUnitActualCost", unitActualCost);
        if (ONE.compareTo(discountRate) == 0) {
            price = SysConstant.BIGZERO;
        } else {
            price = unitPurchaseCost.divide(ONE.subtract(discountRate), 10, 4);
            price = 0 == convertMode ? price.divide(exchangeRate, pricePrecision, 4) : price.multiply(exchangeRate).setScale(pricePrecision, 4);
        }
        valueMap.put("FPrice", price);
        if (isPriceInTax == 1) {
            BigDecimal actualPrice = NumericUtil.isEqualsZero((BigDecimal)discountRate) ? price : (0 == convertMode ? unitPurchaseCost.divide(exchangeRate, pricePrecision, 4) : unitPurchaseCost.multiply(exchangeRate).setScale(pricePrecision, 4));
            valueMap.put("FActualPrice", actualPrice);
            taxPrice = price.multiply(taxRate.add(ONE)).setScale(pricePrecision, 4);
            valueMap.put("FTaxPrice", taxPrice);
            BigDecimal actualTaxPrice = NumericUtil.isEqualsZero((BigDecimal)discountRate) ? taxPrice : actualPrice.multiply(taxRate.add(ONE)).setScale(pricePrecision, 4);
            valueMap.put("FActualTaxPrice", actualTaxPrice);
            BigDecimal amount = 0 == convertMode ? purchaseCost.divide(exchangeRate, currPrecision, 4) : purchaseCost.multiply(exchangeRate).setScale(currPrecision, 4);
            valueMap.put("FAmount", amount);
            localTax = unitPurchaseCost.multiply(qty).multiply(taxRate).setScale(LocalCurrPrecesion, 4);
            tax = 0 == convertMode ? localTax.divide(exchangeRate, currPrecision, 4) : localTax.multiply(exchangeRate).setScale(currPrecision, 4);
            localTaxAmount = purchaseCost.add(localTax);
            taxAmount = amount.add(tax).setScale(currPrecision, 4);
        } else {
            BigDecimal amount = 0 == convertMode ? unitPurchaseCost.multiply(qty).divide(exchangeRate, currPrecision, 4) : unitPurchaseCost.multiply(qty).multiply(exchangeRate).setScale(currPrecision, 4);
            valueMap.put("FAmount", amount);
            localTaxAmount = unitPurchaseCost.multiply(qty).divide(ONE.subtract(taxRate), LocalCurrPrecesion, 4);
            localTax = localTaxAmount.subtract(rs.getBigDecimal("FPurchaseCost")).setScale(LocalCurrPrecesion, 4);
            tax = 0 == convertMode ? localTax.divide(exchangeRate, currPrecision, 4) : localTax.multiply(exchangeRate).setScale(currPrecision, 4);
            BigDecimal bigDecimal = taxAmount = 0 == convertMode ? localTaxAmount.divide(exchangeRate, currPrecision, 4) : localTaxAmount.multiply(exchangeRate).setScale(currPrecision, 4);
            BigDecimal actualPrice = NumericUtil.isEqualsZero((BigDecimal)discountRate) ? price : (0 == convertMode ? unitPurchaseCost.divide(exchangeRate, pricePrecision, 4) : unitPurchaseCost.multiply(exchangeRate).setScale(pricePrecision, 4));
            valueMap.put("FActualPrice", actualPrice);
            taxPrice = price.divide(ONE.subtract(taxRate), pricePrecision, 4);
            valueMap.put("FTaxPrice", taxPrice);
            BigDecimal actualTaxPrice = NumericUtil.isEqualsZero((BigDecimal)discountRate) ? taxPrice : actualPrice.divide(ONE.subtract(taxRate), pricePrecision, 4);
            valueMap.put("FActualTaxPrice", actualTaxPrice);
        }
        BigDecimal discountAmount = taxPrice.multiply(qty).multiply(discountRate).setScale(currPrecision, 4);
        valueMap.put("FDiscountAmount", discountAmount);
        valueMap.put("FTax", tax);
        valueMap.put("FTaxAmount", taxAmount);
        valueMap.put("FLocalTax", localTax);
        valueMap.put("FLocalTaxAmount", localTaxAmount);
    }

    private static void calcFieldValueByUnitActualCost(ResultSet rs, HashMap valueMap, int LocalCurrPrecesion) throws SQLException {
        BigDecimal localTaxAmount;
        BigDecimal taxAmount;
        BigDecimal tax;
        BigDecimal localTax;
        BigDecimal ZERO;
        BigDecimal ONE = BigDecimal.ONE;
        BigDecimal localPrice = ZERO = BigDecimal.ZERO;
        BigDecimal localAmount = ZERO;
        int convertMode = rs.getInt("FConvertMode");
        int isPriceInTax = rs.getInt("FIsPriceInTax");
        BigDecimal unitActualCost = rs.getBigDecimal("FUnitActualCost");
        int currPrecision = rs.getInt("FPrecision");
        int pricePrecision = rs.getInt("FPricePrecision");
        BigDecimal exchangeRate = rs.getBigDecimal("FExchangeRate");
        BigDecimal taxRate = rs.getBigDecimal("FTaxRate").divide(new BigDecimal("100"), 8, 4);
        BigDecimal discountRate = rs.getBigDecimal("FDiscountRate").divide(new BigDecimal("100"), 8, 4);
        BigDecimal qty = rs.getBigDecimal("FQty");
        BigDecimal writeOffQty = rs.getBigDecimal("FWrittenOffQty");
        BigDecimal actualCost = rs.getBigDecimal("FActualCost");
        valueMap.put("FActualCost", actualCost);
        BigDecimal purchaseCost = actualCost.subtract(rs.getBigDecimal("FPurchaseFee")).subtract(rs.getBigDecimal("FMaterialCost"));
        valueMap.put("FPurchaseCost", purchaseCost);
        BigDecimal unitPurchaseCost = NumericUtil.isEqualsZero((BigDecimal)rs.getBigDecimal("FPurchaseFee")) && NumericUtil.isEqualsZero((BigDecimal)rs.getBigDecimal("FMaterialCost")) ? unitActualCost : purchaseCost.divide(qty, pricePrecision, 4);
        valueMap.put("FUnitPurchaseCost", unitPurchaseCost);
        BigDecimal price = 0 == convertMode ? unitPurchaseCost.divide(exchangeRate, pricePrecision, 4) : unitPurchaseCost.multiply(exchangeRate).setScale(pricePrecision, 4);
        valueMap.put("FPrice", price);
        BigDecimal taxPrice = 1 == isPriceInTax ? price.multiply(ONE.add(taxRate)).setScale(pricePrecision, 4) : price.divide(ONE.subtract(taxRate), pricePrecision, 4);
        valueMap.put("FTaxPrice", taxPrice);
        BigDecimal actualPrice = NumericUtil.isEqualsZero((BigDecimal)discountRate) ? price : (0 == convertMode ? unitPurchaseCost.divide(exchangeRate, pricePrecision, 4) : unitPurchaseCost.multiply(exchangeRate).setScale(pricePrecision, 4));
        valueMap.put("FActualPrice", actualPrice);
        BigDecimal actualTaxPrice = NumericUtil.isEqualsZero((BigDecimal)discountRate) ? taxPrice : (1 == isPriceInTax ? actualPrice.multiply(ONE.add(taxRate)).setScale(pricePrecision, 4) : actualPrice.divide(ONE.subtract(taxRate), pricePrecision, 4));
        valueMap.put("FActualTaxPrice", actualTaxPrice);
        BigDecimal discountAmount = taxPrice.multiply(qty).multiply(discountRate).setScale(currPrecision, 4);
        valueMap.put("FDiscountAmount", discountAmount);
        BigDecimal amount = 0 == convertMode ? purchaseCost.divide(exchangeRate, currPrecision, 4) : purchaseCost.multiply(exchangeRate).setScale(currPrecision, 4);
        valueMap.put("FAmount", amount);
        if (1 == isPriceInTax) {
            localTax = purchaseCost.multiply(taxRate).setScale(LocalCurrPrecesion, 4);
            tax = 0 == convertMode ? localTax.divide(exchangeRate, currPrecision, 4) : localTax.multiply(exchangeRate).setScale(currPrecision, 4);
            taxAmount = amount.add(tax);
            localTaxAmount = purchaseCost.add(localTax);
        } else {
            localTaxAmount = purchaseCost.divide(ONE.subtract(taxRate), LocalCurrPrecesion, 4);
            localTax = localTaxAmount.subtract(purchaseCost);
            tax = 0 == convertMode ? localTax.divide(exchangeRate, currPrecision, 4) : localTax.multiply(exchangeRate).setScale(currPrecision, 4);
            taxAmount = 0 == convertMode ? localTaxAmount.divide(exchangeRate, currPrecision, 4) : localTaxAmount.multiply(exchangeRate).setScale(currPrecision, 4);
        }
        valueMap.put("FLocalTax", localTax);
        valueMap.put("FLocalTaxAmount", localTaxAmount);
        valueMap.put("FTax", tax);
        valueMap.put("FTaxAmount", taxAmount);
        BigDecimal writeOffAmount = unitPurchaseCost.multiply(writeOffQty).setScale(LocalCurrPrecesion, 4);
        valueMap.put("FWrittenOffAmount", writeOffAmount);
        BigDecimal unWriteOffAmount = purchaseCost.subtract(writeOffAmount);
        valueMap.put("FUnWriteOffAmount", unWriteOffAmount);
    }

    public static boolean getCostCalculateParam(Context ctx, String companyOrgUnitID, String paramNumber) throws EASBizException, BOSException {
        String calType = CalculateUtil.getParamValue(ctx, companyOrgUnitID, paramNumber);
        return "1".equals(calType);
    }

    public static String getCalResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)key);
    }

    public static String getCalServerResource(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)key, (Locale)ctx.getLocale());
    }

    public static boolean isDevolve(String bizTypeNumber) {
        String DEVOLVE_BIZ_TYPE_NUMBER = "130, 131, 140, 141";
        if (StringUtil.isEmpty((String)bizTypeNumber)) {
            return false;
        }
        return "130, 131, 140, 141".indexOf(bizTypeNumber) > -1;
    }

    public static boolean isSubContractBill(Map uiContext) {
        boolean isSubContractBill = false;
        if (null == uiContext) {
            return false;
        }
        if ("isSubContract".equals(uiContext.get("UIClassParam"))) {
            isSubContractBill = true;
        } else {
            Map btpContext = (Map)uiContext.get("BTPNAVCTX");
            if (btpContext != null) {
                isSubContractBill = "isSubContract".equals(btpContext.get("UIClassParam")) || Boolean.TRUE.equals(btpContext.get("isSubContract"));
            }
        }
        return isSubContractBill;
    }

    public static boolean isAuthoriedForOrg(String companyOrgUnit, String userId, String permission) throws EASBizException, BOSException {
        if (null == companyOrgUnit || null == userId || null == permission) {
            return false;
        }
        FullOrgUnitCollection result = SCMGroupClientUtil.getAuthOrgByPermItem((IObjectPK)new ObjectUuidPK(userId), (OrgType)OrgType.Company, (String)permission);
        if (result != null) {
            int n = result.size();
            for (int i = 0; i < n; ++i) {
                if (!result.get(i).getId().toString().equals(companyOrgUnit)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getSqlInString(Set set) {
        Iterator it = set.iterator();
        StringBuffer insql = new StringBuffer(50);
        if (set.isEmpty()) {
            return "''";
        }
        while (it.hasNext()) {
            insql.append("'").append(it.next().toString()).append("',");
        }
        return insql.substring(0, insql.length() - 1);
    }

    public static String getSqlInString(String[] ids) {
        StringBuffer bf = new StringBuffer();
        bf.append("(");
        int length = ids.length;
        for (int i = 0; i < length; ++i) {
            bf.append("'").append(ids[i]).append("'");
            if (i == length - 1) continue;
            bf.append(",");
        }
        bf.append(")");
        return bf.toString();
    }

    public static CompanyOrgUnitInfo getCompanyInfoForStorage(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        if (storageOrgUnitID == null) {
            return null;
        }
        CompanyOrgUnitInfo ret = null;
        IOrgUnitRelation iUnitRel = ctx == null ? OrgUnitRelationFactory.getRemoteInstance() : OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        ret = (CompanyOrgUnitInfo)iUnitRel.getDefaultToUnit(storageOrgUnitID, 4, 1);
        if (ret == null) {
            OrgUnitCollection orgCol = iUnitRel.getToUnit(storageOrgUnitID, 4, 1);
            ret = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        return ret;
    }

    public static class AccountPeriodInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public Vector periods;
        public PeriodInfo startPeriod;
        public PeriodInfo curPeriod;
    }
}

