/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.newutil;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.cal.info.WriteOffBillInfo;
import com.kingdee.eas.scm.cal.info.WriteOffCostAdjustInfo;
import com.kingdee.eas.scm.cal.info.WriteOffPurInWarehsInfo;
import com.kingdee.eas.scm.cal.info.WriteOffPurInvoiceInfo;
import com.kingdee.eas.scm.cal.info.WriteOffResultInfo;
import com.kingdee.eas.scm.cal.newutil.CalConstant;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ManualWriteOffHelper {
    private static final String RESOURCE_PATH = "com.kingdee.eas.scm.cal.ManualWriteOffResource";
    private static final String DEVOLVE_RESOURCE_PATH = "com.kingdee.eas.scm.cal.DevolveManualWriteOffResource";

    public static List writeOffSelf(Map map, String writeOffStandard) {
        ArrayList<WriteOffBillInfo> list = new ArrayList<WriteOffBillInfo>();
        for (String coreBillID : map.keySet()) {
            List writeOffbillList = (List)map.get(coreBillID);
            BigDecimal writeOffBaseQty = CalConstant.ZERO;
            int size = writeOffbillList.size();
            for (int i = 0; i < size; ++i) {
                WriteOffBillInfo writeOffBillInfo = (WriteOffBillInfo)writeOffbillList.get(i);
                BigDecimal unWriteOffBaseQty = writeOffBillInfo.getCurWriteOffBaseQty();
                for (int j = i + 1; j < size && !NumericUtil.isEqualsZero((BigDecimal)writeOffBillInfo.getCurUnWriteOffBaseQty()); ++j) {
                    WriteOffBillInfo writeOffBillInfo2 = (WriteOffBillInfo)writeOffbillList.get(j);
                    if (NumericUtil.isEqualsZero((BigDecimal)writeOffBillInfo2.getCurUnWriteOffBaseQty()) || writeOffBillInfo.getCurWriteOffBaseQty().signum() == writeOffBillInfo2.getCurWriteOffBaseQty().signum()) continue;
                    if (!ManualWriteOffHelper.isFullWriteOff(writeOffStandard)) {
                        writeOffBaseQty = writeOffBillInfo.getCurUnWriteOffBaseQty().abs().compareTo(writeOffBillInfo2.getCurUnWriteOffBaseQty().abs()) > 0 ? writeOffBillInfo2.getCurUnWriteOffBaseQty().abs() : writeOffBillInfo.getCurUnWriteOffBaseQty().abs();
                        writeOffBillInfo.setCurWriteOffBaseQty(writeOffBillInfo.getCurWriteOffBaseQty().signum() >= 0 ? writeOffBaseQty : writeOffBaseQty.negate());
                        writeOffBillInfo2.setCurWriteOffBaseQty(writeOffBillInfo2.getCurWriteOffBaseQty().signum() >= 0 ? writeOffBaseQty : writeOffBaseQty.negate());
                        if (NumericUtil.isEqualsZero((BigDecimal)writeOffBillInfo.getCurrWriteOffTotalQty())) {
                            list.add(writeOffBillInfo);
                            writeOffBillInfo.setCurrWriteOffTotalQty(CalConstant.ZERO);
                        }
                        if (NumericUtil.isEqualsZero((BigDecimal)writeOffBillInfo2.getCurrWriteOffTotalQty())) {
                            list.add(writeOffBillInfo2);
                            writeOffBillInfo2.setCurrWriteOffTotalQty(CalConstant.ZERO);
                        }
                        writeOffBillInfo.setCurUnWriteOffBaseQty(writeOffBillInfo.getCurUnWriteOffBaseQty().subtract(writeOffBillInfo.getCurWriteOffBaseQty()));
                        writeOffBillInfo2.setCurUnWriteOffBaseQty(writeOffBillInfo2.getCurUnWriteOffBaseQty().subtract(writeOffBillInfo2.getCurWriteOffBaseQty()));
                        writeOffBillInfo.setCurrWriteOffTotalQty(writeOffBillInfo.getCurrWriteOffTotalQty().add(writeOffBillInfo.getCurWriteOffBaseQty()));
                        writeOffBillInfo2.setCurrWriteOffTotalQty(writeOffBillInfo2.getCurrWriteOffTotalQty().add(writeOffBillInfo2.getCurWriteOffBaseQty()));
                        writeOffBillInfo.setCurWriteOffBaseQty(writeOffBillInfo.getCurrWriteOffTotalQty());
                        writeOffBillInfo2.setCurWriteOffBaseQty(writeOffBillInfo2.getCurrWriteOffTotalQty());
                        BigDecimal curWriteOffAmount = writeOffBillInfo.getActualCost().divide(writeOffBillInfo.getBaseQty(), 10, 4).multiply(writeOffBaseQty).setScale(writeOffBillInfo.getPrecision(), 4);
                        BigDecimal curWriteOffAmount2 = writeOffBillInfo2.getActualCost().divide(writeOffBillInfo2.getBaseQty(), 10, 4).multiply(writeOffBaseQty).setScale(writeOffBillInfo.getPrecision(), 4);
                        curWriteOffAmount = writeOffBillInfo.getCurWriteOffBaseQty().signum() >= 0 ? curWriteOffAmount : curWriteOffAmount.negate();
                        curWriteOffAmount2 = writeOffBillInfo2.getCurWriteOffBaseQty().signum() >= 0 ? curWriteOffAmount2 : curWriteOffAmount2.negate();
                        writeOffBillInfo.setCurrWriteOffTotalAmount((writeOffBillInfo.getCurrWriteOffTotalAmount() == null ? CalConstant.ZERO : writeOffBillInfo.getCurrWriteOffTotalAmount()).add(curWriteOffAmount));
                        writeOffBillInfo2.setCurrWriteOffTotalAmount((writeOffBillInfo2.getCurrWriteOffTotalAmount() == null ? CalConstant.ZERO : writeOffBillInfo2.getCurrWriteOffTotalAmount()).add(curWriteOffAmount2));
                        writeOffBillInfo.setCurWriteOffAmount(writeOffBillInfo.getCurrWriteOffTotalAmount());
                        writeOffBillInfo2.setCurWriteOffAmount(writeOffBillInfo2.getCurrWriteOffTotalAmount());
                        if (writeOffBaseQty.compareTo(unWriteOffBaseQty.abs()) == 0) {
                            writeOffBillInfo.setCurUnWriteOffAmount(CalConstant.ZERO);
                            writeOffBillInfo2.setCurUnWriteOffAmount(writeOffBillInfo2.getCurUnWriteOffAmount().subtract(curWriteOffAmount2));
                            continue;
                        }
                        writeOffBillInfo2.setCurUnWriteOffAmount(CalConstant.ZERO);
                        writeOffBillInfo.setCurUnWriteOffAmount(writeOffBillInfo.getCurUnWriteOffAmount().subtract(curWriteOffAmount));
                        continue;
                    }
                    writeOffBillInfo.setCurUnWriteOffBaseQty(CalConstant.ZERO);
                    writeOffBillInfo2.setCurUnWriteOffBaseQty(CalConstant.ZERO);
                    writeOffBillInfo.setCurUnWriteOffAmount(CalConstant.ZERO);
                    writeOffBillInfo2.setCurUnWriteOffAmount(CalConstant.ZERO);
                }
            }
        }
        return list;
    }

    public static void writeOfPurInWarehsAndPurInvoice(Map purInvoiceMap, Map purInWarehsMap, WriteOffResultInfo writeOffResultInfo) {
        HashMap costAdjustMap = new HashMap();
        HashSet purInWarehsSet = new HashSet();
        if (ManualWriteOffHelper.isFullWriteOff(writeOffResultInfo.getWriteOffStandard())) {
            ManualWriteOffHelper.fullWriteOff(purInvoiceMap, purInWarehsMap, costAdjustMap, writeOffResultInfo, purInWarehsSet);
        } else {
            ManualWriteOffHelper.sameQtyWriteOff(purInvoiceMap, purInWarehsMap, costAdjustMap, writeOffResultInfo, purInWarehsSet);
        }
        writeOffResultInfo.setCostAdjustMap(costAdjustMap);
        writeOffResultInfo.setPurInWarehsSet(purInWarehsSet);
    }

    private static void sameQtyWriteOff(Map purInvoiceMap, Map purInWarehsMap, Map costAdjustMap, WriteOffResultInfo writeOffResultInfo, HashSet purInWarehsSet) {
        for (String coreBillID : purInvoiceMap.keySet()) {
            List purInvoice = (List)purInvoiceMap.get(coreBillID);
            List purInWarehs = (List)purInWarehsMap.get(coreBillID);
            if (purInWarehs == null) {
                writeOffResultInfo.getPurInvoiceList().removeAll(purInvoice);
                continue;
            }
            BigDecimal totalWriteOffQty = CalConstant.ZERO;
            BigDecimal totalPurInvoiceQty = CalConstant.ZERO;
            BigDecimal totalPurInWarehsQty = CalConstant.ZERO;
            BigDecimal totalPurInvoiceAmount = CalConstant.ZERO;
            int purInVoiceSize = purInvoice.size();
            for (int i = 0; i < purInVoiceSize; ++i) {
                WriteOffPurInvoiceInfo writeOffPurInvoiceInfo = (WriteOffPurInvoiceInfo)purInvoice.get(i);
                if (NumericUtil.isEqualsZero((BigDecimal)writeOffPurInvoiceInfo.getCurUnWriteOffBaseQty())) continue;
                totalPurInvoiceQty = totalPurInvoiceQty.add(writeOffPurInvoiceInfo.getCurUnWriteOffBaseQty());
            }
            int purInWarehsSize = purInWarehs.size();
            for (int j = 0; j < purInWarehsSize; ++j) {
                WriteOffPurInWarehsInfo writeOffPurInWarehsInfo = (WriteOffPurInWarehsInfo)purInWarehs.get(j);
                if (NumericUtil.isEqualsZero((BigDecimal)writeOffPurInWarehsInfo.getCurUnWriteOffBaseQty())) continue;
                totalPurInWarehsQty = totalPurInWarehsQty.add(writeOffPurInWarehsInfo.getCurUnWriteOffBaseQty());
            }
            if (totalPurInWarehsQty.signum() != totalPurInvoiceQty.signum()) {
                writeOffResultInfo.getPurInvoiceList().removeAll(purInvoice);
                writeOffResultInfo.getPurInWarehsList().removeAll(purInWarehs);
                continue;
            }
            totalWriteOffQty = totalPurInvoiceQty.abs().compareTo(totalPurInWarehsQty.abs()) > 0 ? totalPurInWarehsQty : totalPurInvoiceQty;
            totalPurInvoiceAmount = ManualWriteOffHelper.writeOffPurInVoice(purInvoice, purInWarehs, writeOffResultInfo, purInWarehsSet, totalWriteOffQty);
            if (totalPurInvoiceAmount.signum() != totalWriteOffQty.signum() && totalPurInvoiceAmount.signum() != 0) {
                writeOffResultInfo.getPurInvoiceList().removeAll(purInvoice);
                writeOffResultInfo.getPurInWarehsList().removeAll(purInWarehs);
                continue;
            }
            ManualWriteOffHelper.writeOffPurPurInWarehs(purInvoice, purInWarehs, writeOffResultInfo, purInWarehsSet, costAdjustMap, totalWriteOffQty, totalPurInvoiceAmount);
        }
        writeOffResultInfo.setCostAdjustMap(costAdjustMap);
        writeOffResultInfo.setPurInWarehsSet((Set)purInWarehsSet);
    }

    private static BigDecimal writeOffPurInVoice(List purInvoice, List purInWarehs, WriteOffResultInfo writeOffResultInfo, HashSet purInWarehsSet, BigDecimal totalWriteOffQty) {
        BigDecimal temp = totalWriteOffQty;
        BigDecimal totalPurInvoiceAmount = CalConstant.ZERO;
        int purInVoiceSize = purInvoice.size();
        for (int k = 0; k < purInVoiceSize; ++k) {
            BigDecimal curWriteOffAmount;
            BigDecimal curWriteOffBaseQty;
            WriteOffPurInvoiceInfo writeOffPurInvoiceInfo2;
            WriteOffPurInvoiceInfo writeOffPurInvoiceInfo = (WriteOffPurInvoiceInfo)purInvoice.get(k);
            if (NumericUtil.isEqualsZero((BigDecimal)writeOffPurInvoiceInfo.getCurUnWriteOffBaseQty())) continue;
            boolean isWriteOff = false;
            String purInvoiceId = writeOffPurInvoiceInfo.getEntryId();
            int resultInfoSize = writeOffResultInfo.getPurInvoiceList().size();
            for (int i = 0; i < resultInfoSize && !(isWriteOff = (writeOffPurInvoiceInfo2 = (WriteOffPurInvoiceInfo)writeOffResultInfo.getPurInvoiceList().get(i)).getEntryId().equals(purInvoiceId)); ++i) {
            }
            if (!isWriteOff) {
                curWriteOffBaseQty = CalConstant.ZERO;
                curWriteOffAmount = CalConstant.ZERO;
            } else {
                curWriteOffBaseQty = writeOffPurInvoiceInfo.getCurWriteOffBaseQty();
                curWriteOffAmount = writeOffPurInvoiceInfo.getCurWriteOffAmount();
            }
            int pricision = writeOffPurInvoiceInfo.getPrecision();
            if (temp.abs().compareTo(writeOffPurInvoiceInfo.getCurUnWriteOffBaseQty().abs()) > 0) {
                totalPurInvoiceAmount = totalPurInvoiceAmount.add(writeOffPurInvoiceInfo.getCurUnWriteOffAmount());
                temp = temp.subtract(writeOffPurInvoiceInfo.getCurUnWriteOffBaseQty());
                writeOffPurInvoiceInfo.setCurWriteOffAmount(writeOffPurInvoiceInfo.getCurUnWriteOffAmount().add(curWriteOffAmount));
                writeOffPurInvoiceInfo.setCurWriteOffBaseQty(writeOffPurInvoiceInfo.getCurUnWriteOffBaseQty().add(curWriteOffBaseQty));
                writeOffPurInvoiceInfo.setCurUnWriteOffBaseQty(CalConstant.ZERO);
                writeOffPurInvoiceInfo.setCurUnWriteOffAmount(CalConstant.ZERO);
                if (isWriteOff) continue;
                writeOffResultInfo.getPurInvoiceList().add(writeOffPurInvoiceInfo);
                continue;
            }
            BigDecimal unitPrice = writeOffPurInvoiceInfo.getActualCost().divide(writeOffPurInvoiceInfo.getBaseQty(), 10, 4);
            totalPurInvoiceAmount = totalPurInvoiceAmount.add(temp.multiply(unitPrice));
            writeOffPurInvoiceInfo.setCurWriteOffAmount(temp.multiply(unitPrice).add(curWriteOffAmount).setScale(pricision, 4));
            writeOffPurInvoiceInfo.setCurWriteOffBaseQty(temp.add(curWriteOffBaseQty));
            writeOffPurInvoiceInfo.setCurUnWriteOffBaseQty(writeOffPurInvoiceInfo.getCurUnWriteOffBaseQty().subtract(temp));
            writeOffPurInvoiceInfo.setCurUnWriteOffAmount(writeOffPurInvoiceInfo.getCurUnWriteOffAmount().subtract(temp.multiply(unitPrice).setScale(pricision, 4)));
            temp = CalConstant.ZERO;
            if (isWriteOff) break;
            writeOffResultInfo.getPurInvoiceList().add(writeOffPurInvoiceInfo);
            break;
        }
        return totalPurInvoiceAmount;
    }

    private static void writeOffPurPurInWarehs(List purInvoice, List purInWarehs, WriteOffResultInfo writeOffResultInfo, HashSet purInWarehsSet, Map costAdjustMap, BigDecimal totalWriteOffQty, BigDecimal totalPurInvoiceAmount) {
        BigDecimal temp = totalWriteOffQty;
        BigDecimal averPrice = CalConstant.ZERO;
        if (!NumericUtil.isEqualsZero((BigDecimal)totalWriteOffQty)) {
            averPrice = NumericUtil.divideBigDecimal((BigDecimal)totalPurInvoiceAmount, (BigDecimal)totalWriteOffQty, (int)10);
        }
        PeriodInfo periodInfo = null;
        BigDecimal curWrittenOffQty = CalConstant.ZERO;
        BigDecimal curWrittenOffAmount = CalConstant.ZERO;
        int purInWarehsSize = purInWarehs.size();
        for (int m = 0; m < purInWarehsSize; ++m) {
            BigDecimal curWriteOffAmount;
            BigDecimal curWriteOffBaseQty;
            WriteOffPurInWarehsInfo writeOffPurInWarehsInfo2;
            WriteOffPurInWarehsInfo writeOffPurInWarehsInfo = (WriteOffPurInWarehsInfo)purInWarehs.get(m);
            boolean isWriteOff = false;
            String purInWarehsId = writeOffPurInWarehsInfo.getEntryId();
            int resultInfoSize = writeOffResultInfo.getPurInWarehsList().size();
            for (int i = 0; i < resultInfoSize && !(isWriteOff = (writeOffPurInWarehsInfo2 = (WriteOffPurInWarehsInfo)writeOffResultInfo.getPurInWarehsList().get(i)).getEntryId().equals(purInWarehsId)); ++i) {
            }
            if (!isWriteOff) {
                curWriteOffBaseQty = CalConstant.ZERO;
                curWriteOffAmount = CalConstant.ZERO;
            } else {
                curWriteOffBaseQty = writeOffPurInWarehsInfo.getCurWriteOffBaseQty();
                curWriteOffAmount = writeOffPurInWarehsInfo.getCurWriteOffAmount();
            }
            int pricision = writeOffPurInWarehsInfo.getPrecision();
            BigDecimal unitPrice = CalConstant.ZERO;
            if (!NumericUtil.isEqualsZero((BigDecimal)totalWriteOffQty)) {
                unitPrice = writeOffPurInWarehsInfo.getActualCost().divide(writeOffPurInWarehsInfo.getBaseQty(), writeOffPurInWarehsInfo.getPricePrecision(), 4);
            }
            if (temp.abs().compareTo(writeOffPurInWarehsInfo.getCurUnWriteOffBaseQty().abs()) >= 0) {
                curWrittenOffQty = curWrittenOffQty.add(writeOffPurInWarehsInfo.getCurUnWriteOffBaseQty());
                writeOffPurInWarehsInfo.setCurrWriteOffTotalQty(curWrittenOffQty);
                if (writeOffPurInWarehsInfo.getCurrWriteOffTotalAmount() == null) {
                    writeOffPurInWarehsInfo.setCurrWriteOffTotalAmount(CalConstant.ZERO.add(writeOffPurInWarehsInfo.getCurUnWriteOffBaseQty()).multiply(unitPrice).setScale(pricision, 4));
                } else {
                    writeOffPurInWarehsInfo.setCurrWriteOffTotalAmount(writeOffPurInWarehsInfo.getCurrWriteOffTotalAmount().add(writeOffPurInWarehsInfo.getCurUnWriteOffBaseQty().multiply(unitPrice)).setScale(pricision, 4));
                }
                writeOffPurInWarehsInfo.setCurWriteOffBaseQty(writeOffPurInWarehsInfo.getCurUnWriteOffBaseQty().add(curWriteOffBaseQty));
                if (writeOffPurInWarehsInfo.getCurUnWriteOffBaseQty().compareTo(CalConstant.ZERO) != 0) {
                    writeOffPurInWarehsInfo.setCurWriteOffAmount(writeOffPurInWarehsInfo.getCurUnWriteOffAmount().add(curWriteOffAmount));
                }
                temp = temp.subtract(writeOffPurInWarehsInfo.getCurUnWriteOffBaseQty());
                writeOffPurInWarehsInfo.setCurUnWriteOffBaseQty(CalConstant.ZERO);
                writeOffPurInWarehsInfo.setCurUnWriteOffAmount(CalConstant.ZERO);
            } else {
                curWrittenOffQty = curWrittenOffQty.add(temp);
                writeOffPurInWarehsInfo.setCurrWriteOffTotalQty(curWrittenOffQty);
                if (writeOffPurInWarehsInfo.getCurrWriteOffTotalAmount() == null) {
                    writeOffPurInWarehsInfo.setCurrWriteOffTotalAmount(CalConstant.ZERO.add(temp.multiply(unitPrice)).setScale(pricision, 4));
                } else {
                    writeOffPurInWarehsInfo.setCurrWriteOffTotalAmount(writeOffPurInWarehsInfo.getCurrWriteOffTotalAmount().add(temp.multiply(unitPrice)).setScale(pricision, 4));
                }
                writeOffPurInWarehsInfo.setCurWriteOffBaseQty(temp.add(curWriteOffBaseQty));
                writeOffPurInWarehsInfo.setCurWriteOffAmount(temp.multiply(unitPrice).add(curWriteOffAmount).setScale(pricision, 4));
                writeOffPurInWarehsInfo.setCurUnWriteOffBaseQty(writeOffPurInWarehsInfo.getCurUnWriteOffBaseQty().subtract(temp));
                writeOffPurInWarehsInfo.setCurUnWriteOffAmount(writeOffPurInWarehsInfo.getCurUnWriteOffBaseQty().subtract(temp).multiply(unitPrice).setScale(pricision, 4));
                temp = CalConstant.ZERO;
            }
            if (!writeOffResultInfo.isSaleWriteOff()) {
                boolean flag = false;
                if (periodInfo == null) {
                    try {
                        periodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)writeOffPurInWarehsInfo.getCompanyOrgUnitID())));
                    }
                    catch (Exception e) {
                        Logger.error((Throwable)e);
                    }
                }
                if (!(1 == writeOffPurInWarehsInfo.getAccountType() || writeOffPurInWarehsInfo.isFiVouchered() || writeOffPurInWarehsInfo.isPresent() || writeOffPurInWarehsInfo.getYear() <= periodInfo.getPeriodYear() && (writeOffPurInWarehsInfo.getYear() != periodInfo.getPeriodYear() || writeOffPurInWarehsInfo.getPeriod() < periodInfo.getPeriodNumber()) || CalConstant.ZERO.compareTo(writeOffPurInWarehsInfo.getWrittenOffBaseQty()) != 0 || writeOffPurInWarehsInfo.isWriteCost())) {
                    writeOffPurInWarehsInfo.setActualCost(writeOffPurInWarehsInfo.getBaseQty().multiply(averPrice).setScale(pricision, 4));
                    if (NumericUtil.isEqualsZero((BigDecimal)writeOffPurInWarehsInfo.getQty())) {
                        writeOffPurInWarehsInfo.setUnitActualCost(CalConstant.ZERO);
                    } else {
                        writeOffPurInWarehsInfo.setUnitActualCost(writeOffPurInWarehsInfo.getActualCost().divide(writeOffPurInWarehsInfo.getQty(), writeOffPurInWarehsInfo.getPricePrecision(), 4));
                    }
                    writeOffPurInWarehsInfo.setCurWriteOffAmount(writeOffPurInWarehsInfo.getCurWriteOffBaseQty().multiply(averPrice).setScale(pricision, 4));
                    writeOffPurInWarehsInfo.setCurrWriteOffTotalAmount(curWrittenOffAmount.add(writeOffPurInWarehsInfo.getCurWriteOffAmount()));
                    flag = true;
                    purInWarehsSet.add(writeOffPurInWarehsInfo.getBillId());
                    if (m == purInWarehsSize - 1) {
                        writeOffPurInWarehsInfo.setCurWriteOffAmount(totalPurInvoiceAmount.setScale(pricision, 4).subtract(curWrittenOffAmount));
                        if (writeOffPurInWarehsInfo.getCurWriteOffBaseQty().equals(writeOffPurInWarehsInfo.getBaseQty())) {
                            writeOffPurInWarehsInfo.setActualCost(writeOffPurInWarehsInfo.getCurWriteOffAmount());
                        }
                        writeOffPurInWarehsInfo.setCurrWriteOffTotalAmount(totalPurInvoiceAmount.setScale(pricision, 4));
                    }
                } else {
                    BigDecimal diffAmount = writeOffPurInWarehsInfo.getCurWriteOffBaseQty().multiply(averPrice).setScale(pricision, 4).subtract(writeOffPurInWarehsInfo.getCurWriteOffAmount());
                    if (m == purInWarehsSize - 1) {
                        diffAmount = totalPurInvoiceAmount.setScale(pricision, 4).subtract(curWrittenOffAmount.add(writeOffPurInWarehsInfo.getCurWriteOffAmount()));
                    }
                    if (!NumericUtil.isEqualsZero((BigDecimal)diffAmount)) {
                        if (writeOffResultInfo.isMerageCostAdjust()) {
                            ManualWriteOffHelper.buildCostAdjustInfo(diffAmount, writeOffResultInfo, writeOffPurInWarehsInfo, costAdjustMap);
                        } else {
                            ManualWriteOffHelper.buildCostAdjustInfo(writeOffResultInfo, writeOffPurInWarehsInfo, costAdjustMap, totalPurInvoiceAmount.setScale(pricision, 4));
                        }
                    }
                }
                curWrittenOffAmount = curWrittenOffAmount.add(writeOffPurInWarehsInfo.getCurWriteOffBaseQty().multiply(averPrice).setScale(pricision, 4));
                writeOffPurInWarehsInfo.setWriteCost(flag);
            }
            if (isWriteOff) continue;
            writeOffResultInfo.getPurInWarehsList().add(writeOffPurInWarehsInfo);
        }
    }

    private static void fullWriteOff(Map purInvoiceMap, Map purInWarehsMap, Map costAdjustMap, WriteOffResultInfo writeOffResultInfo, HashSet purInWarehsSet) {
        for (String coreBillID : purInvoiceMap.keySet()) {
            List purInvoice = (List)purInvoiceMap.get(coreBillID);
            BigDecimal purInVoiceWriteOffAmount = CalConstant.ZERO;
            BigDecimal writeOffBaseQty = CalConstant.ZERO;
            BigDecimal purInWarehswriteOffBaseQty = CalConstant.ZERO;
            BigDecimal purInWarehswriteOffAmount = CalConstant.ZERO;
            if (!purInvoiceMap.containsKey(coreBillID) || !purInWarehsMap.containsKey(coreBillID)) continue;
            int purInVoiceSize = purInvoice.size();
            for (int i = 0; i < purInVoiceSize; ++i) {
                WriteOffPurInvoiceInfo writeOffPurInvoiceInfo = (WriteOffPurInvoiceInfo)purInvoice.get(i);
                writeOffResultInfo.getPurInvoiceList().add(writeOffPurInvoiceInfo);
                writeOffBaseQty = writeOffBaseQty.add(writeOffPurInvoiceInfo.getCurWriteOffBaseQty());
                purInVoiceWriteOffAmount = purInVoiceWriteOffAmount.add(writeOffPurInvoiceInfo.getCurWriteOffAmount());
            }
            List purInWarehs = (List)purInWarehsMap.get(coreBillID);
            int purInWarehsSize = purInWarehs.size();
            for (int j = 0; j < purInWarehsSize; ++j) {
                WriteOffPurInWarehsInfo writeOffPurInWarehsInfo = (WriteOffPurInWarehsInfo)purInWarehs.get(j);
                if (NumericUtil.isEqualsZero((BigDecimal)writeOffPurInWarehsInfo.getCurWriteOffBaseQty())) continue;
                purInWarehswriteOffBaseQty = purInWarehswriteOffBaseQty.add(writeOffPurInWarehsInfo.getCurWriteOffBaseQty());
                writeOffPurInWarehsInfo.setCurWriteOffAmount(writeOffPurInWarehsInfo.getCurWriteOffBaseQty().multiply(writeOffPurInWarehsInfo.getUnitActualCost()).setScale(writeOffPurInWarehsInfo.getPrecision(), 4));
                if (writeOffPurInWarehsInfo.getCurWriteOffBaseQty().compareTo(writeOffPurInWarehsInfo.getUnWriteOffBaseQty()) == 0) {
                    writeOffPurInWarehsInfo.setCurWriteOffAmount(writeOffPurInWarehsInfo.getUnWriteOffAmount());
                }
                purInWarehswriteOffAmount = purInWarehswriteOffAmount.add(writeOffPurInWarehsInfo.getCurWriteOffAmount());
                writeOffPurInWarehsInfo.setCurUnWriteOffAmount(CalConstant.ZERO);
                writeOffResultInfo.getPurInWarehsList().add(writeOffPurInWarehsInfo);
            }
            if (purInWarehswriteOffBaseQty.signum() != purInVoiceWriteOffAmount.signum() && purInVoiceWriteOffAmount.signum() != 0) {
                writeOffResultInfo.getPurInvoiceList().removeAll(purInvoice);
                writeOffResultInfo.getPurInWarehsList().removeAll(purInWarehs);
                continue;
            }
            if (purInWarehswriteOffBaseQty.signum() != writeOffBaseQty.signum()) {
                writeOffResultInfo.getPurInvoiceList().removeAll(purInvoice);
                writeOffResultInfo.getPurInWarehsList().removeAll(purInWarehs);
                continue;
            }
            BigDecimal averPrice = CalConstant.ZERO;
            if (!NumericUtil.isEqualsZero((BigDecimal)purInWarehswriteOffBaseQty)) {
                averPrice = purInVoiceWriteOffAmount.divide(purInWarehswriteOffBaseQty, 10, 4);
            }
            if (writeOffResultInfo.isSaleWriteOff()) continue;
            PeriodInfo periodInfo = null;
            BigDecimal tempAmount = CalConstant.ZERO;
            int purInWarehsSize2 = purInWarehs.size();
            for (int i = 0; i < purInWarehsSize2; ++i) {
                boolean flag = false;
                WriteOffPurInWarehsInfo writeOffPurInWarehsInfo = (WriteOffPurInWarehsInfo)purInWarehs.get(i);
                int pricision = writeOffPurInWarehsInfo.getPrecision();
                if (periodInfo == null) {
                    try {
                        periodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)writeOffPurInWarehsInfo.getCompanyOrgUnitID())));
                    }
                    catch (Exception e) {
                        Logger.error((Throwable)e);
                    }
                }
                if (!(1 == writeOffPurInWarehsInfo.getAccountType() || writeOffPurInWarehsInfo.isFiVouchered() || writeOffPurInWarehsInfo.isPresent() || writeOffPurInWarehsInfo.getYear() <= periodInfo.getPeriodYear() && (writeOffPurInWarehsInfo.getYear() != periodInfo.getPeriodYear() || writeOffPurInWarehsInfo.getPeriod() < periodInfo.getPeriodNumber()) || CalConstant.ZERO.compareTo(writeOffPurInWarehsInfo.getWrittenOffBaseQty()) != 0 || writeOffPurInWarehsInfo.isWriteCost())) {
                    writeOffPurInWarehsInfo.setActualCost(writeOffPurInWarehsInfo.getBaseQty().multiply(averPrice).setScale(pricision, 4));
                    if (NumericUtil.isEqualsZero((BigDecimal)writeOffPurInWarehsInfo.getQty())) {
                        writeOffPurInWarehsInfo.setUnitActualCost(CalConstant.ZERO);
                    } else {
                        writeOffPurInWarehsInfo.setUnitActualCost(writeOffPurInWarehsInfo.getActualCost().divide(writeOffPurInWarehsInfo.getQty(), writeOffPurInWarehsInfo.getPricePrecision(), 4));
                    }
                    writeOffPurInWarehsInfo.setCurrWriteOffTotalAmount(writeOffPurInWarehsInfo.getBaseQty().multiply(averPrice).setScale(pricision, 4));
                    writeOffPurInWarehsInfo.setCurWriteOffAmount(writeOffPurInWarehsInfo.getCurWriteOffBaseQty().multiply(averPrice).setScale(pricision, 4));
                    flag = true;
                    writeOffPurInWarehsInfo.setWriteCost(flag);
                    if (i == purInWarehsSize2 - 1) {
                        writeOffPurInWarehsInfo.setCurWriteOffAmount(purInVoiceWriteOffAmount.setScale(pricision, 4).subtract(tempAmount).setScale(pricision, 4));
                        if (writeOffPurInWarehsInfo.getCurWriteOffBaseQty().equals(writeOffPurInWarehsInfo.getBaseQty())) {
                            writeOffPurInWarehsInfo.setActualCost(writeOffPurInWarehsInfo.getCurWriteOffAmount());
                        }
                        writeOffPurInWarehsInfo.setCurrWriteOffTotalAmount(purInVoiceWriteOffAmount.setScale(pricision, 4));
                    }
                    purInWarehsSet.add(writeOffPurInWarehsInfo.getBillId());
                } else {
                    BigDecimal amount = NumericUtil.multiplyBigDecimal((BigDecimal)writeOffPurInWarehsInfo.getCurWriteOffBaseQty(), (BigDecimal)averPrice, (int)pricision);
                    if (i == purInWarehsSize2 - 1) {
                        amount = purInVoiceWriteOffAmount.setScale(pricision, 4).subtract(tempAmount).setScale(pricision, 4);
                    }
                    if (writeOffPurInWarehsInfo.getWrittenOffBaseQty().add(writeOffPurInWarehsInfo.getCurWriteOffBaseQty()).equals(writeOffPurInWarehsInfo.getBaseQty())) {
                        writeOffPurInWarehsInfo.setCurWriteOffAmount(writeOffPurInWarehsInfo.getActualCost().subtract(writeOffPurInWarehsInfo.getWrittenOffAmount()));
                    }
                    BigDecimal adjustAmount = amount.subtract(writeOffPurInWarehsInfo.getCurWriteOffAmount());
                    if (writeOffResultInfo.isMerageCostAdjust()) {
                        if (CalConstant.ZERO.compareTo(adjustAmount) != 0) {
                            ManualWriteOffHelper.buildCostAdjustInfo(adjustAmount, writeOffResultInfo, writeOffPurInWarehsInfo, costAdjustMap);
                        }
                    } else if (NumericUtil.isEqualsZero((BigDecimal)purInVoiceWriteOffAmount)) {
                        ManualWriteOffHelper.buildCostAdjustInfo(CalConstant.ZERO, writeOffPurInWarehsInfo.getCurWriteOffBaseQty(), writeOffResultInfo, writeOffPurInWarehsInfo, costAdjustMap);
                        ManualWriteOffHelper.buildCostAdjustInfo(writeOffPurInWarehsInfo.getCurWriteOffAmount().negate(), writeOffPurInWarehsInfo.getCurWriteOffBaseQty().negate(), writeOffResultInfo, writeOffPurInWarehsInfo, costAdjustMap);
                    } else if (NumericUtil.isEqualsZero((BigDecimal)purInWarehswriteOffAmount)) {
                        ManualWriteOffHelper.buildCostAdjustInfo(writeOffPurInWarehsInfo.getCurWriteOffAmount(), writeOffPurInWarehsInfo.getCurWriteOffBaseQty(), writeOffResultInfo, writeOffPurInWarehsInfo, costAdjustMap);
                        ManualWriteOffHelper.buildCostAdjustInfo(writeOffPurInWarehsInfo.getCurWriteOffAmount().negate(), writeOffPurInWarehsInfo.getCurWriteOffBaseQty().negate(), writeOffResultInfo, writeOffPurInWarehsInfo, costAdjustMap);
                    } else if (!NumericUtil.isEqualsZero((BigDecimal)adjustAmount)) {
                        ManualWriteOffHelper.buildCostAdjustInfo(writeOffResultInfo, writeOffPurInWarehsInfo, costAdjustMap, amount);
                    }
                }
                tempAmount = tempAmount.add(writeOffPurInWarehsInfo.getCurWriteOffBaseQty().multiply(averPrice).setScale(pricision, 4));
            }
        }
        writeOffResultInfo.setPurInWarehsSet((Set)purInWarehsSet);
    }

    private static void buildPurInWarehsAndPurInvoice(WriteOffPurInvoiceInfo writeOffPurInvoiceInfo, WriteOffPurInWarehsInfo writeOffPurInWarehsInfo, HashSet purInWarehsSet) {
        try {
            boolean flag = false;
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)writeOffPurInWarehsInfo.getCompanyOrgUnitID())));
            if (!(1 == writeOffPurInWarehsInfo.getAccountType() || writeOffPurInWarehsInfo.isFiVouchered() || writeOffPurInWarehsInfo.isPresent() || writeOffPurInWarehsInfo.getYear() <= periodInfo.getPeriodYear() && (writeOffPurInWarehsInfo.getYear() != periodInfo.getPeriodYear() || writeOffPurInWarehsInfo.getPeriod() < periodInfo.getPeriodNumber()) || CalConstant.ZERO.compareTo(writeOffPurInWarehsInfo.getWrittenOffBaseQty()) != 0 || writeOffPurInWarehsInfo.isWriteCost())) {
                writeOffPurInWarehsInfo.setCurWriteOffAmount(writeOffPurInvoiceInfo.getCurWriteOffAmount());
                writeOffPurInWarehsInfo.setUnitActualCost(writeOffPurInvoiceInfo.getCurWriteOffAmount().divide(writeOffPurInWarehsInfo.getCurWriteOffBaseQty().divide(writeOffPurInWarehsInfo.getBaseConvsRate(), writeOffPurInWarehsInfo.getQtyPrecision(), 4), writeOffPurInWarehsInfo.getPricePrecision(), 4));
                if (writeOffPurInWarehsInfo.getBaseQty().compareTo(writeOffPurInWarehsInfo.getCurWriteOffBaseQty()) == 0 || writeOffPurInWarehsInfo.getBaseQty().compareTo(writeOffPurInWarehsInfo.getCurrWriteOffTotalQty()) == 0) {
                    writeOffPurInWarehsInfo.setActualCost(writeOffPurInWarehsInfo.getCurrWriteOffTotalAmount());
                    writeOffPurInWarehsInfo.setUnitActualCost(writeOffPurInWarehsInfo.getActualCost().divide(writeOffPurInWarehsInfo.getBaseQty().divide(writeOffPurInWarehsInfo.getBaseConvsRate(), writeOffPurInWarehsInfo.getQtyPrecision(), 4), writeOffPurInWarehsInfo.getPricePrecision(), 4));
                } else {
                    writeOffPurInWarehsInfo.setActualCost(writeOffPurInvoiceInfo.getCurWriteOffAmount().divide(writeOffPurInvoiceInfo.getCurWriteOffBaseQty(), 10, 4).multiply(writeOffPurInWarehsInfo.getBaseQty()).setScale(writeOffPurInWarehsInfo.getPrecision(), 4));
                }
                flag = true;
                purInWarehsSet.add(writeOffPurInWarehsInfo.getBillId());
            }
            writeOffPurInWarehsInfo.setWriteCost(flag);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    private static void buildCostAdjustInfo(BigDecimal diffAmount, WriteOffResultInfo writeOffResultInfo, WriteOffPurInWarehsInfo writeOffPurInWarehsInfo, Map costAdjustMap) {
        String storageOrgUnitID = writeOffPurInWarehsInfo.getStorageOrgUnitId();
        Object obj = costAdjustMap.get(storageOrgUnitID);
        List<WriteOffCostAdjustInfo> costAdjustList = null;
        costAdjustList = null == obj ? new ArrayList() : (List)obj;
        WriteOffCostAdjustInfo info = new WriteOffCostAdjustInfo();
        info.setDiffAmount(diffAmount);
        info.setCurWriteOffAmount(diffAmount);
        info.setCurWriteOffBaseQty(CalConstant.ZERO);
        info.setPrice(CalConstant.ZERO);
        info.setBaseQty(CalConstant.ZERO);
        info.setQty(CalConstant.ZERO);
        info.setAdminOrgUnit(writeOffPurInWarehsInfo.getAdminOrgUnit());
        info.setAssistProperty(writeOffPurInWarehsInfo.getAssistProperty());
        info.setStorageOrgUnitID(storageOrgUnitID);
        info.setCompanyOrgUnitID(writeOffPurInWarehsInfo.getCompanyOrgUnitID());
        info.setSupplierId(writeOffResultInfo.getSupplerID());
        info.setMaterialId(writeOffPurInWarehsInfo.getMaterialId());
        info.setUnitID(writeOffPurInWarehsInfo.getUnitID());
        info.setBaseUnitID(writeOffPurInWarehsInfo.getBaseUnitID());
        info.setWareHouseID(writeOffPurInWarehsInfo.getWareHouseID());
        info.setLot(writeOffPurInWarehsInfo.getLot());
        info.setYear(writeOffResultInfo.getYear());
        info.setPeriod(writeOffResultInfo.getPeriod());
        info.setBizDate(writeOffResultInfo.getBizDate());
        info.setSourceBillID(writeOffPurInWarehsInfo.getBillId());
        info.setSourceBillEntryID(writeOffPurInWarehsInfo.getEntryId());
        info.setSourceBillNumber(writeOffPurInWarehsInfo.getNumber());
        info.setSourceBillEntrySeq(writeOffPurInWarehsInfo.getSeq());
        info.setCoreBillNumber(writeOffPurInWarehsInfo.getCoreBillNumber());
        info.setCoreBillEntrySeq(writeOffPurInWarehsInfo.getCoreBillEntrySeq());
        info.setLocationId(writeOffPurInWarehsInfo.getLocationId());
        String number = new StringBuffer("CA-").append(writeOffPurInWarehsInfo.getNumber()).append("-").append(new Date().getTime()).toString();
        if (number.length() > 80) {
            number = number.substring(80);
        }
        info.setNumber(number);
        costAdjustList.add(info);
        if (!costAdjustMap.containsKey(storageOrgUnitID)) {
            costAdjustMap.put(storageOrgUnitID, costAdjustList);
        }
    }

    private static void buildCostAdjustInfo(BigDecimal diffAmount, BigDecimal baseQty, WriteOffResultInfo writeOffResultInfo, WriteOffPurInWarehsInfo writeOffPurInWarehsInfo, Map costAdjustMap) {
        String storageOrgUnitID = writeOffPurInWarehsInfo.getStorageOrgUnitId();
        Object obj = costAdjustMap.get(storageOrgUnitID);
        List<WriteOffCostAdjustInfo> costAdjustList = null;
        costAdjustList = null == obj ? new ArrayList() : (List)obj;
        WriteOffCostAdjustInfo info = new WriteOffCostAdjustInfo();
        info.setDiffAmount(diffAmount);
        info.setCurWriteOffAmount(diffAmount);
        info.setBaseQty(baseQty);
        info.setQty(baseQty.divide(writeOffPurInWarehsInfo.getBaseConvsRate(), writeOffPurInWarehsInfo.getQtyPrecision(), 4).negate());
        info.setPrice(diffAmount.divide(baseQty.divide(writeOffPurInWarehsInfo.getBaseConvsRate(), 10, 4), writeOffPurInWarehsInfo.getPricePrecision(), 4));
        info.setCurWriteOffBaseQty(baseQty);
        info.setStorageOrgUnitID(storageOrgUnitID);
        info.setCompanyOrgUnitID(writeOffPurInWarehsInfo.getCompanyOrgUnitID());
        info.setSupplierId(writeOffResultInfo.getSupplerID());
        info.setMaterialId(writeOffPurInWarehsInfo.getMaterialId());
        info.setUnitID(writeOffPurInWarehsInfo.getUnitID());
        info.setBaseUnitID(writeOffPurInWarehsInfo.getBaseUnitID());
        info.setWareHouseID(writeOffPurInWarehsInfo.getWareHouseID());
        info.setLot(writeOffPurInWarehsInfo.getLot());
        info.setYear(writeOffResultInfo.getYear());
        info.setPeriod(writeOffResultInfo.getPeriod());
        info.setBizDate(writeOffResultInfo.getBizDate());
        info.setSourceBillID(writeOffPurInWarehsInfo.getBillId());
        info.setSourceBillEntryID(writeOffPurInWarehsInfo.getEntryId());
        info.setSourceBillNumber(writeOffPurInWarehsInfo.getNumber());
        info.setSourceBillEntrySeq(writeOffPurInWarehsInfo.getSeq());
        info.setCoreBillNumber(writeOffPurInWarehsInfo.getCoreBillNumber());
        info.setCoreBillEntrySeq(writeOffPurInWarehsInfo.getCoreBillEntrySeq());
        String number = new StringBuffer("CA-").append(writeOffPurInWarehsInfo.getNumber()).append("-").append(new Date().getTime()).toString();
        if (number.length() > 80) {
            number = number.substring(80);
        }
        info.setNumber(number);
        costAdjustList.add(info);
        if (!costAdjustMap.containsKey(storageOrgUnitID)) {
            costAdjustMap.put(storageOrgUnitID, costAdjustList);
        }
    }

    private static void buildCostAdjustInfo(WriteOffResultInfo writeOffResultInfo, WriteOffPurInWarehsInfo writeOffPurInWarehsInfo, Map costAdjustMap, BigDecimal amount) {
        String storageOrgUnitID = writeOffPurInWarehsInfo.getStorageOrgUnitId();
        Object obj = costAdjustMap.get(storageOrgUnitID);
        List<WriteOffCostAdjustInfo> costAdjustList = null;
        costAdjustList = null == obj ? new ArrayList() : (List)obj;
        WriteOffCostAdjustInfo info1 = new WriteOffCostAdjustInfo();
        WriteOffCostAdjustInfo info2 = new WriteOffCostAdjustInfo();
        info1.setDiffAmount(amount);
        info1.setCurWriteOffAmount(amount);
        info1.setCurWriteOffBaseQty(writeOffPurInWarehsInfo.getCurWriteOffBaseQty());
        info1.setBaseQty(writeOffPurInWarehsInfo.getCurWriteOffBaseQty());
        info1.setQty(writeOffPurInWarehsInfo.getCurWriteOffBaseQty().divide(writeOffPurInWarehsInfo.getBaseConvsRate(), writeOffPurInWarehsInfo.getQtyPrecision(), 4));
        info1.setPrice(amount.divide(writeOffPurInWarehsInfo.getCurWriteOffBaseQty().divide(writeOffPurInWarehsInfo.getBaseConvsRate(), 10, 4), writeOffPurInWarehsInfo.getPricePrecision(), 4));
        info1.setAdminOrgUnit(writeOffPurInWarehsInfo.getAdminOrgUnit());
        info1.setAssistProperty(writeOffPurInWarehsInfo.getAssistProperty());
        info1.setStorageOrgUnitID(storageOrgUnitID);
        info1.setCompanyOrgUnitID(writeOffPurInWarehsInfo.getCompanyOrgUnitID());
        info1.setSupplierId(writeOffResultInfo.getSupplerID());
        info1.setMaterialId(writeOffPurInWarehsInfo.getMaterialId());
        info1.setUnitID(writeOffPurInWarehsInfo.getUnitID());
        info1.setBaseUnitID(writeOffPurInWarehsInfo.getBaseUnitID());
        info1.setWareHouseID(writeOffPurInWarehsInfo.getWareHouseID());
        info1.setLot(writeOffPurInWarehsInfo.getLot());
        info1.setYear(writeOffResultInfo.getYear());
        info1.setPeriod(writeOffResultInfo.getPeriod());
        info1.setBizDate(writeOffResultInfo.getBizDate());
        info1.setSourceBillID(writeOffPurInWarehsInfo.getBillId());
        info1.setSourceBillEntryID(writeOffPurInWarehsInfo.getEntryId());
        info1.setSourceBillNumber(writeOffPurInWarehsInfo.getNumber());
        info1.setSourceBillEntrySeq(writeOffPurInWarehsInfo.getSeq());
        info1.setCoreBillNumber(writeOffPurInWarehsInfo.getCoreBillNumber());
        info1.setCoreBillEntrySeq(writeOffPurInWarehsInfo.getCoreBillEntrySeq());
        info1.setLocationId(writeOffPurInWarehsInfo.getLocationId());
        String number = new StringBuffer("CA-").append(writeOffPurInWarehsInfo.getNumber()).append("-").append(new Date().getTime()).toString();
        if (number.length() > 80) {
            number = number.substring(80);
        }
        info1.setNumber(number);
        costAdjustList.add(info1);
        info2.setDiffAmount(writeOffPurInWarehsInfo.getCurWriteOffAmount().negate());
        info2.setCurWriteOffAmount(writeOffPurInWarehsInfo.getCurWriteOffAmount().negate());
        info2.setCurWriteOffBaseQty(writeOffPurInWarehsInfo.getCurWriteOffBaseQty().negate());
        info2.setBaseQty(writeOffPurInWarehsInfo.getCurWriteOffBaseQty().negate());
        info2.setQty(writeOffPurInWarehsInfo.getCurWriteOffBaseQty().divide(writeOffPurInWarehsInfo.getBaseConvsRate(), writeOffPurInWarehsInfo.getQtyPrecision(), 4).negate());
        info2.setPrice(writeOffPurInWarehsInfo.getCurWriteOffAmount().divide(writeOffPurInWarehsInfo.getCurWriteOffBaseQty().divide(writeOffPurInWarehsInfo.getBaseConvsRate(), 10, 4), writeOffPurInWarehsInfo.getPricePrecision(), 4));
        info2.setAdminOrgUnit(writeOffPurInWarehsInfo.getAdminOrgUnit());
        info2.setAssistProperty(writeOffPurInWarehsInfo.getAssistProperty());
        info2.setStorageOrgUnitID(storageOrgUnitID);
        info2.setCompanyOrgUnitID(writeOffPurInWarehsInfo.getCompanyOrgUnitID());
        info2.setSupplierId(writeOffResultInfo.getSupplerID());
        info2.setMaterialId(writeOffPurInWarehsInfo.getMaterialId());
        info2.setUnitID(writeOffPurInWarehsInfo.getUnitID());
        info2.setBaseUnitID(writeOffPurInWarehsInfo.getBaseUnitID());
        info2.setWareHouseID(writeOffPurInWarehsInfo.getWareHouseID());
        info2.setLot(writeOffPurInWarehsInfo.getLot());
        info2.setYear(writeOffResultInfo.getYear());
        info2.setPeriod(writeOffResultInfo.getPeriod());
        info2.setBizDate(writeOffResultInfo.getBizDate());
        info2.setSourceBillID(writeOffPurInWarehsInfo.getBillId());
        info2.setSourceBillEntryID(writeOffPurInWarehsInfo.getEntryId());
        info2.setSourceBillNumber(writeOffPurInWarehsInfo.getNumber());
        info2.setSourceBillEntrySeq(writeOffPurInWarehsInfo.getSeq());
        info2.setCoreBillNumber(writeOffPurInWarehsInfo.getCoreBillNumber());
        info2.setCoreBillEntrySeq(writeOffPurInWarehsInfo.getCoreBillEntrySeq());
        info2.setNumber(number);
        info2.setLocationId(writeOffPurInWarehsInfo.getLocationId());
        costAdjustList.add(info2);
        if (!costAdjustMap.containsKey(storageOrgUnitID)) {
            costAdjustMap.put(storageOrgUnitID, costAdjustList);
        }
    }

    private static void buildCostAdjustInfo(WriteOffResultInfo writeOffResultInfo, WriteOffPurInWarehsInfo writeOffPurInWarehsInfo, WriteOffPurInvoiceInfo writeOffPurInvoiceInfo, Map costAdjustMap) {
        String storageOrgUnitID = writeOffPurInWarehsInfo.getStorageOrgUnitId();
        Object obj = costAdjustMap.get(storageOrgUnitID);
        List<WriteOffCostAdjustInfo> costAdjustList = null;
        costAdjustList = null == obj ? new ArrayList() : (List)obj;
        WriteOffCostAdjustInfo info1 = new WriteOffCostAdjustInfo();
        WriteOffCostAdjustInfo info2 = new WriteOffCostAdjustInfo();
        info1.setDiffAmount(writeOffPurInvoiceInfo.getCurWriteOffAmount());
        info1.setCurWriteOffAmount(writeOffPurInvoiceInfo.getCurWriteOffAmount());
        info1.setCurWriteOffBaseQty(writeOffPurInWarehsInfo.getCurWriteOffBaseQty());
        info1.setBaseQty(writeOffPurInWarehsInfo.getCurWriteOffBaseQty());
        info1.setQty(writeOffPurInWarehsInfo.getCurWriteOffBaseQty().divide(writeOffPurInWarehsInfo.getBaseConvsRate(), writeOffPurInWarehsInfo.getQtyPrecision(), 4));
        info1.setPrice(writeOffPurInvoiceInfo.getCurWriteOffAmount().divide(writeOffPurInWarehsInfo.getCurWriteOffBaseQty().divide(writeOffPurInWarehsInfo.getBaseConvsRate(), 10, 4), writeOffPurInWarehsInfo.getPricePrecision(), 4));
        info1.setStorageOrgUnitID(storageOrgUnitID);
        info1.setCompanyOrgUnitID(writeOffPurInWarehsInfo.getCompanyOrgUnitID());
        info1.setSupplierId(writeOffResultInfo.getSupplerID());
        info1.setMaterialId(writeOffPurInWarehsInfo.getMaterialId());
        info1.setUnitID(writeOffPurInWarehsInfo.getUnitID());
        info1.setBaseUnitID(writeOffPurInWarehsInfo.getBaseUnitID());
        info1.setWareHouseID(writeOffPurInWarehsInfo.getWareHouseID());
        info1.setLot(writeOffPurInWarehsInfo.getLot());
        info1.setYear(writeOffResultInfo.getYear());
        info1.setPeriod(writeOffResultInfo.getPeriod());
        info1.setBizDate(writeOffResultInfo.getBizDate());
        info1.setSourceBillID(writeOffPurInWarehsInfo.getBillId());
        info1.setSourceBillEntryID(writeOffPurInWarehsInfo.getEntryId());
        info1.setSourceBillNumber(writeOffPurInWarehsInfo.getNumber());
        info1.setSourceBillEntrySeq(writeOffPurInWarehsInfo.getSeq());
        info1.setCoreBillNumber(writeOffPurInWarehsInfo.getCoreBillNumber());
        info1.setCoreBillEntrySeq(writeOffPurInWarehsInfo.getCoreBillEntrySeq());
        String number = new StringBuffer("CA-").append(writeOffPurInWarehsInfo.getNumber()).append("-").append(new Date().getTime()).toString();
        if (number.length() > 80) {
            number = number.substring(80);
        }
        info1.setNumber(number);
        info1.setAdminOrgUnit(writeOffPurInWarehsInfo.getAdminOrgUnit());
        info1.setAssistProperty(writeOffPurInWarehsInfo.getAssistProperty());
        costAdjustList.add(info1);
        info2.setDiffAmount(writeOffPurInWarehsInfo.getCurWriteOffAmount().negate());
        info2.setCurWriteOffAmount(writeOffPurInWarehsInfo.getCurWriteOffAmount().negate());
        info2.setCurWriteOffBaseQty(writeOffPurInWarehsInfo.getCurWriteOffBaseQty().negate());
        info2.setBaseQty(writeOffPurInWarehsInfo.getCurWriteOffBaseQty().negate());
        info2.setQty(writeOffPurInWarehsInfo.getCurWriteOffBaseQty().divide(writeOffPurInWarehsInfo.getBaseConvsRate(), writeOffPurInWarehsInfo.getQtyPrecision(), 4).negate());
        info2.setPrice(writeOffPurInWarehsInfo.getCurWriteOffAmount().divide(writeOffPurInWarehsInfo.getCurWriteOffBaseQty().divide(writeOffPurInWarehsInfo.getBaseConvsRate(), 10, 4), writeOffPurInWarehsInfo.getPricePrecision(), 4));
        info2.setStorageOrgUnitID(storageOrgUnitID);
        info2.setCompanyOrgUnitID(writeOffPurInWarehsInfo.getCompanyOrgUnitID());
        info2.setSupplierId(writeOffResultInfo.getSupplerID());
        info2.setMaterialId(writeOffPurInWarehsInfo.getMaterialId());
        info2.setUnitID(writeOffPurInWarehsInfo.getUnitID());
        info2.setBaseUnitID(writeOffPurInWarehsInfo.getBaseUnitID());
        info2.setWareHouseID(writeOffPurInWarehsInfo.getWareHouseID());
        info2.setLot(writeOffPurInWarehsInfo.getLot());
        info2.setYear(writeOffResultInfo.getYear());
        info2.setPeriod(writeOffResultInfo.getPeriod());
        info2.setBizDate(writeOffResultInfo.getBizDate());
        info2.setSourceBillID(writeOffPurInWarehsInfo.getBillId());
        info2.setSourceBillEntryID(writeOffPurInWarehsInfo.getEntryId());
        info2.setSourceBillNumber(writeOffPurInWarehsInfo.getNumber());
        info2.setSourceBillEntrySeq(writeOffPurInWarehsInfo.getSeq());
        info2.setCoreBillNumber(writeOffPurInWarehsInfo.getCoreBillNumber());
        info2.setCoreBillEntrySeq(writeOffPurInWarehsInfo.getCoreBillEntrySeq());
        info2.setNumber(number);
        info2.setAdminOrgUnit(writeOffPurInWarehsInfo.getAdminOrgUnit());
        info2.setAssistProperty(writeOffPurInWarehsInfo.getAssistProperty());
        costAdjustList.add(info2);
        if (!costAdjustMap.containsKey(storageOrgUnitID)) {
            costAdjustMap.put(storageOrgUnitID, costAdjustList);
        }
    }

    private static boolean isFullWriteOff(String writeOffStandard) {
        return writeOffStandard.equals("110") || writeOffStandard.equals("130");
    }

    public static RptTableHeader builderRptTableHeader(String[][] fields, String[] hiddenFields, String resPath) {
        int i;
        ArrayList<String> listLabel = new ArrayList<String>();
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        int len = fields.length;
        for (i = 0; i < len; ++i) {
            col = new RptTableColumn(fields[i][1]);
            if ("selected".equals(fields[i][1])) {
                col.setWidth(40);
            } else if ("number".equals(fields[i][1])) {
                col.setWidth(150);
            } else {
                col.setWidth(120);
            }
            if ("true".equals(fields[i][0])) {
                col.setAligment(2);
            }
            header.addColumn(col);
            listLabel.add(EASResource.getString((String)resPath, (String)fields[i][1]));
        }
        len = hiddenFields.length;
        for (i = 0; i < len; ++i) {
            col = new RptTableColumn(hiddenFields[i]);
            col.setWidth(120);
            col.setHided(true);
            header.addColumn(col);
            listLabel.add(EASResource.getString((String)resPath, (String)hiddenFields[i]));
        }
        int length = listLabel.size();
        Object[][] obj = new Object[1][length];
        for (int i2 = 0; i2 < length; ++i2) {
            obj[0][i2] = listLabel.get(i2);
        }
        header.setLabels(obj, true);
        return header;
    }

    public static RptTableHeader builderRptTableHeader(String[][] fields, String[] hiddenFields) {
        return ManualWriteOffHelper.builderRptTableHeader(fields, hiddenFields, RESOURCE_PATH);
    }

    public static RptTableHeader builderRptTableHeaderForDevolve(String[][] fields, String[] hiddenFields) {
        return ManualWriteOffHelper.builderRptTableHeader(fields, hiddenFields, DEVOLVE_RESOURCE_PATH);
    }

    public static boolean isMergeCostAdjustBill(Context ctx, String companyOrgUnitID) throws EASBizException, BOSException {
        IParamControl ipc = null != ctx ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(companyOrgUnitID);
        String calType = ipc.getParamValue((IObjectPK)pk, "SCM_CAL_004");
        return "0".equals(calType);
    }

    private static List sortByQty(List list, Boolean isInvoice) {
        if (list.isEmpty()) {
            return list;
        }
        WriteOffBillInfo[] arrays = null;
        Object[] obj = list.toArray();
        int length = obj.length;
        arrays = isInvoice != false ? new WriteOffPurInvoiceInfo[length] : new WriteOffPurInWarehsInfo[length];
        System.arraycopy(obj, 0, arrays, 0, length);
        arrays = ManualWriteOffHelper.sortData(arrays, true);
        list.clear();
        for (int i = 0; i < length; ++i) {
            list.add(arrays[i]);
        }
        return list;
    }

    public static List sortPurInWarehsByQty(List list) {
        return ManualWriteOffHelper.sortByQty(list, false);
    }

    public static List sortPurInvoiceByQty(List list) {
        return ManualWriteOffHelper.sortByQty(list, true);
    }

    private static WriteOffBillInfo[] sortData(WriteOffBillInfo[] datas, boolean isAsc) {
        if (datas == null || datas.length < 2) {
            return datas;
        }
        class DataCompare
        implements Comparator {
            private boolean isAsc = true;

            public DataCompare(boolean isAsc) {
                this.isAsc = isAsc;
            }

            public int compare(Object arg0, Object arg1) {
                return this.isAsc ? ((WriteOffBillInfo)arg0).getBizDate().compareTo(((WriteOffBillInfo)arg1).getBizDate()) : ((WriteOffBillInfo)arg1).getBizDate().compareTo(((WriteOffBillInfo)arg0).getBizDate());
            }
        }
        Arrays.sort(datas, new DataCompare(isAsc));
        return datas;
    }

    public static WriteOffPurInWarehsInfo[] sortDataByQty(WriteOffPurInWarehsInfo[] datas, boolean isAsc) {
        return (WriteOffPurInWarehsInfo[])ManualWriteOffHelper.sortData(datas, isAsc);
    }

    public static WriteOffPurInvoiceInfo[] sortDataByQty(WriteOffPurInvoiceInfo[] datas, boolean isAsc) {
        return (WriteOffPurInvoiceInfo[])ManualWriteOffHelper.sortData(datas, isAsc);
    }
}

