/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.onekey.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.job.client.ProcessSchedulePlan;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.cal.onekey.IMaterialCalcRankFacade;
import com.kingdee.eas.scm.cal.onekey.MaterialCalcRankFacadeFactory;
import com.kingdee.eas.scm.cal.onekey.client.AbstractMaterialCalcRankReportUI;
import com.kingdee.eas.scm.cal.onekey.client.MaterialCalcRankFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import org.apache.log4j.Logger;

public class MaterialCalcRankReportUI
extends AbstractMaterialCalcRankReportUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialCalcRankReportUI.class);

    public MaterialCalcRankReportUI() throws Exception {
        this.tbl.setEditable(false);
        this.tbl.getActionMap().remove("Delete");
        this.tbl.checkParsed();
        this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tbl.getDataRequestManager().setDataRequestMode(1);
        this.tbl.getDataRequestManager().setPageRowCount(50);
        this.enableExportExcel(this.tbl);
        this.tbl.getDataRequestManager().setExportMemoryCallback(true);
        this.btnScheduleSet.setIcon(EASResource.getIcon((String)"imgTbtn_attemper"));
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
    }

    protected IMaterialCalcRankFacade getRemoteInstance() throws BOSException {
        return MaterialCalcRankFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return null;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        MaterialCalcRankFilterUI condUI = new MaterialCalcRankFilterUI();
        condUI.setSize(420, 470);
        return condUI;
    }

    protected void query() {
        this.tbl.removeColumns();
        this.tbl.removeRows();
        this.initUserConfig();
    }

    public void getData(KDTDataRequestEvent e) {
        try {
            RptParams rpt;
            this.tbl.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            if (from == 0) {
                rpt = this.getRemoteInstance().createTempTable(this.params);
                RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                this.setTempTable(rpt.getString("tempTable"));
                KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tbl);
                this.tbl.getGroupManager().setGroup(true);
                this.tbl.getColumn("groupKey").setGroup(true);
                this.tbl.getColumn("groupKey").setMergeable(true);
            }
            this.params.setString("tempTable", this.getTempTable());
            rpt = this.getRemoteInstance().query(this.params, from, len);
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.tbl);
            this.SetTableFormat(e);
            this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void SetTableFormat(KDTDataRequestEvent e) {
        int from = e.getFirstRow();
        int last = e.getLastRow();
        for (int i = from; i <= last; ++i) {
            IRow row = this.tbl.getRow(i);
            if (row == null) {
                return;
            }
            if ("1".equals(row.getCell("assembleCalc").getValue().toString())) {
                row.getCell("assembleCalc").setValue((Object)Boolean.TRUE);
            } else {
                row.getCell("assembleCalc").setValue((Object)Boolean.FALSE);
            }
            if ("1".equals(row.getCell("disAssembleCalc").getValue().toString())) {
                row.getCell("disAssembleCalc").setValue((Object)Boolean.TRUE);
            } else {
                row.getCell("disAssembleCalc").setValue((Object)Boolean.FALSE);
            }
            if ("1".equals(row.getCell("matChangeCalc").getValue().toString())) {
                row.getCell("matChangeCalc").setValue((Object)Boolean.TRUE);
            } else {
                row.getCell("matChangeCalc").setValue((Object)Boolean.FALSE);
            }
            if ("1".equals(row.getCell("devCalc").getValue().toString())) {
                row.getCell("devCalc").setValue((Object)Boolean.TRUE);
            } else {
                row.getCell("devCalc").setValue((Object)Boolean.FALSE);
            }
            if ("1".equals(row.getCell("costMove").getValue().toString())) {
                row.getCell("costMove").setValue((Object)Boolean.TRUE);
                continue;
            }
            row.getCell("costMove").setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    public void actionSetSchedule_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.params.getObject("company");
        String companyId = companyInfo.getId().toString();
        IMaterialCalcRankFacade remoteInstance = MaterialCalcRankFacadeFactory.getRemoteInstance();
        String scheduleXml = remoteInstance.getScheduleXml(companyId);
        String newschedule = ProcessSchedulePlan.open((Object)((Object)this), (String)scheduleXml, (boolean)false);
        if (newschedule != null && !newschedule.equals(scheduleXml)) {
            remoteInstance.addCalRankTask(companyId, newschedule);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.common.SCMLogResource", (String)"setSuccess"));
        }
    }

    @Override
    protected void actionReCalc(MouseEvent e) throws Exception {
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)this.params.getObject("company");
        this.getRemoteInstance().reCalcRank(cou.getId().toString());
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.onekey.OneKeyCalculateResource", (String)"reCalcSuccess"));
        this.query();
    }
}

