/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.onekey.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.job.client.JobDetailInformationUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.client.CostComputePriceSourceReportUI;
import com.kingdee.eas.scm.cal.client.timertask.ITimerTaskProcessor;
import com.kingdee.eas.scm.cal.client.timertask.PageTimerTask;
import com.kingdee.eas.scm.cal.onekey.OneKeyCalTaskStateEnum;
import com.kingdee.eas.scm.cal.onekey.OneKeyCalculateProcessEntryInfo;
import com.kingdee.eas.scm.cal.onekey.OneKeyCalculateProcessFactory;
import com.kingdee.eas.scm.cal.onekey.OneKeyCalculateProcessInfo;
import com.kingdee.eas.scm.cal.onekey.client.AbstractOneKeyCalculateProcessUI;
import com.kingdee.eas.scm.cal.onekey.client.OneKeyCalcExceptionRptUI;
import com.kingdee.eas.scm.cal.onekey.client.OneKeyCalcProductRptUI;
import com.kingdee.eas.scm.cal.onekey.client.OneKeyCalculateProcessNodeWidget;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class OneKeyCalculateProcessUI
extends AbstractOneKeyCalculateProcessUI
implements ITimerTaskProcessor {
    private static final Logger logger = CoreUIObject.getLogger(OneKeyCalculateProcessUI.class);
    private Map<String, OneKeyCalculateProcessNodeWidget> id2widgetMap = new HashMap<String, OneKeyCalculateProcessNodeWidget>();
    private PageTimerTask timerTask = null;
    private OneKeyCalculateProcessNodeWidget startNode;
    private OneKeyCalculateProcessNodeWidget endNode;
    private String selectedEntryId = null;
    private static final String RESOURCE = "com.kingdee.eas.scm.cal.onekey.OneKeyCalculateResource";
    private long refreshTime = 5000L;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void buildProcessUIHeader(OneKeyCalculateProcessInfo processInfo) throws BOSException {
        this.dateStartTime.setValue((Object)processInfo.getStartTime());
        this.dateEndTime.setValue((Object)processInfo.getEndTime());
        this.totalSpan.setText(this.getSecondTimeSpan(processInfo.getStartTime(), processInfo.getEndTime()).toPlainString());
        if (OneKeyCalTaskStateEnum.complete == processInfo.getState() || OneKeyCalTaskStateEnum.hasException == processInfo.getState()) {
            this.panelResult.setVisible(true);
            this.handlePanelResult(processInfo);
        } else {
            this.panelResult.setVisible(false);
        }
    }

    private void setNumStyle() {
        this.labSuccessNum.setUnderline(true);
        this.labSuccessNum.setUnderlineColor(new Color(0, 129, 3));
        this.labSuccessNum.setForeground(new Color(0, 129, 3));
        this.labSuccessNum.setCursor(new Cursor(12));
        int width = this.labSuccessNum.getFontMetrics(this.labSuccessNum.getFont()).stringWidth(this.labSuccessNum.getText());
        this.labSuccessNum.setSize(width, this.labSuccessNum.getHeight());
        this.labFailNum.setUnderline(true);
        this.labFailNum.setUnderlineColor(Color.red);
        this.labFailNum.setForeground(Color.red);
        this.labFailNum.setCursor(new Cursor(12));
        width = this.labFailNum.getFontMetrics(this.labFailNum.getFont()).stringWidth(this.labFailNum.getText());
        this.labFailNum.setSize(width, this.labFailNum.getHeight());
        this.labProductCount.setUnderline(true);
        this.labProductCount.setUnderlineColor(Color.red);
        this.labProductCount.setForeground(Color.red);
        this.labProductCount.setCursor(new Cursor(12));
        width = this.labProductCount.getFontMetrics(this.labProductCount.getFont()).stringWidth(this.labProductCount.getText());
        this.labProductCount.setSize(width, this.labProductCount.getHeight());
    }

    private void startTimer() {
        this.timerTask = new PageTimerTask(this);
        Timer timer = new Timer();
        timer.schedule((TimerTask)this.timerTask, 1000L, this.refreshTime);
    }

    private void initUI() throws BOSException, EASBizException {
        OneKeyCalculateProcessInfo processInfo = this.getProcessInfo();
        this.nodeTable.setEditable(false);
        this.prmtCompany.setValue((Object)processInfo.getCompany());
        this.prmtPeriod.setValue((Object)processInfo.getPeriod());
        this.processPanel.setLayout((LayoutManager)new FlowLayout(0));
        this.nodeTable.setVisible(false);
        this.dateStartTime.setValue((Object)processInfo.getStartTime());
        Timestamp endTime = processInfo.getEndTime();
        this.dateEndTime.setValue((Object)endTime);
        BigDecimal secondTimeSpan = this.getSecondTimeSpan(processInfo.getStartTime(), endTime);
        this.totalSpan.setText(secondTimeSpan.toPlainString());
        if (OneKeyCalTaskStateEnum.complete == processInfo.getState() || OneKeyCalTaskStateEnum.hasException == processInfo.getState()) {
            this.panelResult.setVisible(true);
            this.handlePanelResult(processInfo);
        } else {
            this.panelResult.setVisible(false);
        }
        this.ckReCalRank.setSelected(processInfo.isIsReCalRank());
        this.ckCalUsualMat.setSelected(processInfo.isIsCalUsualMat());
        this.buildProcessPanel(processInfo);
        if (OneKeyCalTaskStateEnum.notStart == processInfo.getState() || OneKeyCalTaskStateEnum.runing == processInfo.getState()) {
            this.startTimer();
        }
    }

    private void handlePanelResult(OneKeyCalculateProcessInfo processInfo) {
        if (OneKeyCalTaskStateEnum.complete == processInfo.getState()) {
            this.handleSuccessResult(processInfo);
        }
        if (OneKeyCalTaskStateEnum.hasException == processInfo.getState()) {
            this.handleExceptionResult();
        }
    }

    private void handleExceptionResult() {
        this.kDLabel1.setVisible(false);
        this.kDLabel3.setVisible(false);
        this.labCost.setVisible(false);
        this.labProductCount.setVisible(false);
        this.labSuccessNum.setVisible(false);
        this.labFailNum.setVisible(false);
        this.labFail.setVisible(true);
        this.labFailDetail.setCursor(new Cursor(12));
        this.labFailDetail.setVisible(true);
        this.labFailDetail.setUnderline(true);
        this.labFailDetail.setUnderlineColor(Color.blue);
        this.labFailDetail.setForeground(Color.blue);
        this.labFailDetail.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    OneKeyCalculateProcessUI.this.failDetailClick(e);
                }
                catch (Exception e1) {
                    OneKeyCalculateProcessUI.this.handUIException(e1);
                }
            }
        });
    }

    private void handleSuccessResult(OneKeyCalculateProcessInfo processInfo) {
        this.labSuccessNum.setVisible(true);
        this.labFailNum.setVisible(true);
        this.kDLabel1.setVisible(true);
        this.kDLabel3.setVisible(true);
        this.labCost.setVisible(true);
        this.labProductCount.setVisible(true);
        this.labFail.setVisible(false);
        this.labFailDetail.setVisible(false);
        String count = this.getSourceStr("count", null);
        this.labSuccessNum.setText(processInfo.getSuccessCount() + count);
        this.labSuccessNum.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    OneKeyCalculateProcessUI.this.successNumLabClick(e);
                }
                catch (Exception e1) {
                    OneKeyCalculateProcessUI.this.handUIException(e1);
                }
            }
        });
        this.labFailNum.setText(processInfo.getFailCount() + count);
        this.labFailNum.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    OneKeyCalculateProcessUI.this.failNumLabClick(e);
                }
                catch (Exception e1) {
                    OneKeyCalculateProcessUI.this.handUIException(e1);
                }
            }
        });
        this.labProductCount.setText(processInfo.getProductCount() + count);
        this.labProductCount.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    OneKeyCalculateProcessUI.this.productNumLabClick(e);
                }
                catch (Exception e1) {
                    OneKeyCalculateProcessUI.this.handUIException(e1);
                }
            }
        });
        this.setNumStyle();
    }

    protected void productNumLabClick(MouseEvent e) throws UIException {
        OneKeyCalculateProcessInfo processInfo = null;
        try {
            processInfo = this.getProcessInfo();
        }
        catch (Exception ex) {
            MsgBox.showInfo((String)this.getSourceStr("processError", null));
            return;
        }
        if (processInfo == null) {
            MsgBox.showInfo((String)this.getSourceStr("processError", null));
            return;
        }
        UIContext ctx = new UIContext((Object)this);
        RptParams jparams = new RptParams();
        jparams.setBoolean("calUsualMat", this.ckCalUsualMat.isSelected());
        jparams.setObject("company", this.prmtCompany.getValue());
        jparams.setObject("period", this.prmtPeriod.getValue());
        jparams.setString("reportHeaderId", processInfo.getReportHeaderId());
        jparams.setString("com.kingdee.eas.framework.report.client.CommRptBaseUI#PARAMS_KEY_TEMPTABLENAME", null);
        ctx.put("com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_BE_JOINQUERY", true);
        ctx.put("com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS", jparams);
        IUIWindow win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(OneKeyCalcProductRptUI.class.getName(), (Map)ctx, this.dataObjects);
        win.show();
    }

    protected void failDetailClick(MouseEvent e) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        OneKeyCalculateProcessInfo processInfo = null;
        try {
            processInfo = this.getProcessInfo();
        }
        catch (Exception ex) {
            MsgBox.showInfo((String)this.getSourceStr("processError", null));
            return;
        }
        if (processInfo == null) {
            MsgBox.showInfo((String)this.getSourceStr("processError", null));
            return;
        }
        if (!StringUtils.isEmpty((String)processInfo.getJobId())) {
            uiContext.put((Object)"ownerid", (Object)processInfo.getJobId());
            String className = JobDetailInformationUI.class.getName();
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(className, (Map)uiContext);
            uiWindow.show();
        }
    }

    protected void failNumLabClick(MouseEvent e) throws EASBizException, BOSException {
        OneKeyCalculateProcessInfo processInfo = null;
        try {
            processInfo = this.getProcessInfo();
        }
        catch (Exception ex) {
            MsgBox.showInfo((String)this.getSourceStr("processError", null));
            return;
        }
        if (processInfo == null) {
            MsgBox.showInfo((String)this.getSourceStr("processError", null));
            return;
        }
        UIContext ctx = new UIContext((Object)this);
        RptParams jparams = new RptParams();
        jparams.setBoolean("calUsualMat", this.ckCalUsualMat.isSelected());
        jparams.setObject("company", this.prmtCompany.getValue());
        jparams.setObject("period", this.prmtPeriod.getValue());
        jparams.setString("reportHeaderId", processInfo.getReportHeaderId());
        jparams.setString("com.kingdee.eas.framework.report.client.CommRptBaseUI#PARAMS_KEY_TEMPTABLENAME", null);
        ctx.put("com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_BE_JOINQUERY", true);
        ctx.put("com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS", jparams);
        ctx.put("DIFF_WINTAB_KEY", System.currentTimeMillis());
        IUIWindow win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(OneKeyCalcExceptionRptUI.class.getName(), (Map)ctx, this.dataObjects);
        win.show();
    }

    protected void successNumLabClick(MouseEvent e) throws EASBizException, BOSException {
        OneKeyCalculateProcessInfo processInfo = null;
        try {
            processInfo = this.getProcessInfo();
        }
        catch (Exception ex) {
            MsgBox.showInfo((String)this.getSourceStr("processError", null));
            return;
        }
        if (processInfo == null) {
            MsgBox.showInfo((String)this.getSourceStr("processError", null));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)processInfo.getReportHeaderId());
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("PARENT.ID", (Object)processInfo.getReportHeaderId()));
        filter.getFilterItems().add(new FilterItemInfo("MATERIAL.ID NOT IN (SELECT DISTINCT FMATERIALID FROM T_CL_CostComputePriceReport  WHERE  Fparentid ='" + processInfo.getReportHeaderId() + "' AND FSTATE <> 1)"));
        uiContext.put((Object)"oneKeyFilterInfo", (Object)filter);
        uiContext.put((Object)"oneKeyReportId", (Object)processInfo.getReportHeaderId());
        uiContext.put((Object)"orgId", (Object)companyInfo.getId().toString());
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(CostComputePriceSourceReportUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void showJoinRptUI(String uiName) throws UIException {
        Map ctx = this.getUIContext();
        if (ctx == null) {
            ctx = new UIContext((Object)this);
        }
        RptParams jparams = new RptParams();
        jparams.setObject("company", this.prmtCompany.getValue());
        jparams.setObject("period", this.prmtPeriod.getValue());
        jparams.setString("com.kingdee.eas.framework.report.client.CommRptBaseUI#PARAMS_KEY_TEMPTABLENAME", null);
        ctx.put("com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_BE_JOINQUERY", true);
        ctx.put("com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS", jparams);
        ctx.put("DIFF_WINTAB_KEY", System.currentTimeMillis());
        IUIWindow win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(uiName, ctx, this.dataObjects);
        win.show();
    }

    private BigDecimal getSecondTimeSpan(Timestamp beginTime, Timestamp endTime) throws BOSException {
        if (endTime == null) {
            endTime = this.getServerDate();
        }
        if (beginTime == null) {
            return BigDecimal.ZERO;
        }
        long timeSpan = endTime.getTime() - beginTime.getTime();
        return new BigDecimal(timeSpan).divide(new BigDecimal(1000), 2, RoundingMode.HALF_UP);
    }

    private void buildProcessPanel(OneKeyCalculateProcessInfo processInfo) {
        if (processInfo != null && !processInfo.isEmpty()) {
            NodeSelectListener mouseListener = new NodeSelectListener();
            OneKeyCalTaskStateEnum processState = processInfo.getState();
            String start = this.getSourceStr("start", null);
            OneKeyCalculateProcessNodeWidget node = OneKeyCalTaskStateEnum.notStart == processState ? new OneKeyCalculateProcessNodeWidget(0, 0, start) : new OneKeyCalculateProcessNodeWidget(0, 2, start);
            node.addIconClickListener(mouseListener);
            this.startNode = node;
            this.processPanel.add((Component)((Object)node));
            int size = processInfo.getEntry().size();
            for (int i = 0; i < size; ++i) {
                OneKeyCalculateProcessEntryInfo processEntryInfo = processInfo.getEntry().get(i);
                node = new OneKeyCalculateProcessNodeWidget(processEntryInfo);
                this.id2widgetMap.put(processEntryInfo.getId().toString(), node);
                node.addIconClickListener(mouseListener);
                this.processPanel.add((Component)((Object)node));
            }
            String end = this.getSourceStr("end", null);
            node = OneKeyCalTaskStateEnum.complete == processState ? new OneKeyCalculateProcessNodeWidget(2, 2, end) : new OneKeyCalculateProcessNodeWidget(2, 0, end);
            node.addIconClickListener(mouseListener);
            this.endNode = node;
            this.processPanel.add((Component)((Object)node));
        }
    }

    private OneKeyCalculateProcessInfo getProcessInfo() throws BOSException, EASBizException {
        Map uiContext = this.getUIContext();
        String id = (String)uiContext.get("ID");
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("*"));
        sics.add(new SelectorItemInfo("entry.*"));
        sics.add(new SelectorItemInfo("company.name"));
        sics.add(new SelectorItemInfo("company.number"));
        sics.add(new SelectorItemInfo("period.periodYear"));
        sics.add(new SelectorItemInfo("period.periodNumber"));
        sics.add(new SelectorItemInfo("period.number"));
        sics.add(new SelectorItemInfo("creator.number"));
        sics.add(new SelectorItemInfo("creator.name"));
        view.setSelector(sics);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        view.setFilter(filter);
        SorterItemCollection sorts = new SorterItemCollection();
        sorts.add(new SorterItemInfo("entry.seq"));
        view.setSorter(sorts);
        return OneKeyCalculateProcessFactory.getRemoteInstance().getOneKeyCalculateProcessCollection(view).get(0);
    }

    protected void processIconClick(MouseEvent e) throws BOSException {
        Container parent;
        if (e.getSource() instanceof KDLabel && (parent = ((KDLabel)e.getSource()).getParent()) instanceof OneKeyCalculateProcessNodeWidget) {
            OneKeyCalculateProcessEntryInfo procesEntryInfo = ((OneKeyCalculateProcessNodeWidget)((Object)parent)).getProcesEntryInfo();
            if (procesEntryInfo != null) {
                this.selectedEntryId = procesEntryInfo.getId().toString();
                this.buildNodeTable(procesEntryInfo);
                this.nodeTable.setVisible(true);
            } else {
                this.selectedEntryId = null;
                this.nodeTable.setVisible(false);
            }
        }
    }

    private void buildNodeTable(OneKeyCalculateProcessEntryInfo procesEntryInfo) throws BOSException {
        this.nodeTable.removeRows();
        IRow iRow = this.nodeTable.addRow();
        iRow.getCell(0).setValue((Object)this.getSourceStr("nodeName", null));
        iRow.getCell(1).setValue((Object)procesEntryInfo.getName());
        if (procesEntryInfo.getTotalCount() > 0) {
            iRow = this.nodeTable.addRow();
            iRow.getCell(0).setValue((Object)this.getSourceStr("curCalMatCount", null));
            iRow.getCell(1).setValue((Object)procesEntryInfo.getTotalCount());
            iRow = this.nodeTable.addRow();
            iRow.getCell(0).setValue((Object)this.getSourceStr("completeMatCount", null));
            iRow.getCell(1).setValue((Object)procesEntryInfo.getCompleteCount());
        }
        iRow = this.nodeTable.addRow();
        iRow.getCell(0).setValue((Object)this.getSourceStr("curCalRate", null));
        iRow.getCell(1).setValue((Object)(procesEntryInfo.getProcessRate() + "%"));
        iRow = this.nodeTable.addRow();
        iRow.getCell(0).setValue((Object)this.getSourceStr("curCalStartTime", null));
        iRow.getCell(1).setValue((Object)procesEntryInfo.getStartTime());
        iRow = this.nodeTable.addRow();
        iRow.getCell(0).setValue((Object)this.getSourceStr("curCalTimeSpan", null));
        iRow.getCell(1).setValue((Object)this.getSecondTimeSpan(procesEntryInfo.getStartTime(), procesEntryInfo.getEndTime()));
    }

    private void refreshNodeTable(OneKeyCalculateProcessEntryInfo procesEntryInfo) throws BOSException {
        this.nodeTable.getCell(0, 1).setValue((Object)procesEntryInfo.getName());
        this.nodeTable.getCell(1, 1).setValue((Object)procesEntryInfo.getTotalCount());
        this.nodeTable.getCell(2, 1).setValue((Object)procesEntryInfo.getCompleteCount());
        this.nodeTable.getCell(3, 1).setValue((Object)(procesEntryInfo.getProcessRate() + "%"));
        this.nodeTable.getCell(4, 1).setValue((Object)procesEntryInfo.getStartTime());
        this.nodeTable.getCell(5, 1).setValue((Object)this.getSecondTimeSpan(procesEntryInfo.getStartTime(), procesEntryInfo.getEndTime()));
    }

    @Override
    public void doTimerTask() throws Exception {
        OneKeyCalculateProcessInfo processInfo = this.getProcessInfo();
        if (processInfo != null) {
            this.processPanel.removeAll();
            this.buildProcessPanel(processInfo);
            this.kDScrollPane2.validate();
            this.buildProcessUIHeader(processInfo);
            if (OneKeyCalTaskStateEnum.complete == processInfo.getState() || OneKeyCalTaskStateEnum.hasException == processInfo.getState()) {
                this.doStop();
            }
        }
    }

    @Override
    public void doStop() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
    }

    @Override
    public boolean taskState() {
        return false;
    }

    public boolean destroyWindow() {
        this.doStop();
        return super.destroyWindow();
    }

    private Timestamp getServerDate() throws BOSException {
        return SCMBillCommonFacadeFactory.getRemoteInstance().getServerDate();
    }

    private String getSourceStr(String key, Object[] params) {
        return ResourceBase.getString((String)RESOURCE, (String)key, (Locale)SysContext.getSysContext().getLocale(), (Object[])params);
    }

    class NodeSelectListener
    extends MouseAdapter {
        NodeSelectListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                OneKeyCalculateProcessUI.this.processIconClick(e);
            }
            catch (BOSException e1) {
                OneKeyCalculateProcessUI.this.handUIException(e1);
            }
        }
    }
}

