/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.onekey.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CostUpdateMutexFacadeFactory;
import com.kingdee.eas.scm.cal.onekey.OneKeyCalculateProcessFactory;
import com.kingdee.eas.scm.cal.onekey.client.AbstractOneKeyCalculateUI;
import com.kingdee.eas.scm.cal.onekey.client.OneKeyCalculateProcessUI;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class OneKeyCalculateUI
extends AbstractOneKeyCalculateUI {
    private static final Logger logger = CoreUIObject.getLogger(OneKeyCalculateUI.class);
    private static final String ONEKEYRESOURCE = "com.kingdee.eas.scm.cal.onekey.OneKeyCalculateResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCompamyF7();
    }

    private void initCompamyF7() throws EASBizException, BOSException {
        this.prmtCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        String permissionItem = this.getPermissionItem();
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, permissionItem);
        iProducer.getModel().setShowVirtual(false);
        this.prmtCompany.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        this.prmtCompany.setEnabledMultiSelection(false);
        this.prmtCompany.setDisplayFormat("$name$");
        this.prmtCompany.setEditFormat("$number$");
        this.prmtCompany.setCommitFormat("$number$");
        CalculateClientUtil.InitCompanyF7(this.prmtCompany, permissionItem);
    }

    private String getPermissionItem() {
        return "oneKeyCalc";
    }

    @Override
    public void actionOneKeyCal_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtCompany.getValue() == null) {
            MsgBox.showInfo((String)CalculateClientUtil.getCalResource("SELECTCOMPANY"));
            return;
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (currentPeriod == null) {
            MsgBox.showInfo((String)CalculateClientUtil.getCalResource("PERIOD_IS_NULL"));
            return;
        }
        String processId = this.createOneKeyCalculateJob(companyInfo, currentPeriod);
        this.showProgressUI(processId);
    }

    private String createOneKeyCalculateJob(CompanyOrgUnitInfo companyInfo, PeriodInfo currentPeriod) throws EASBizException, BOSException {
        String processId = null;
        this.createJobChek(companyInfo);
        JobConfig jobCfg = this.createJobCfg(companyInfo, currentPeriod);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("companyId", companyInfo.getId().toString());
        params.put("isReCalRank", this.ckReCalRank.isSelected());
        params.put("isCalUsualMat", this.ckCalUsualMat.isSelected());
        Map result = OneKeyCalculateProcessFactory.getRemoteInstance().buildProcess(params);
        processId = (String)result.get("processId");
        params.putAll(result);
        params.put("CURRENT_USER", SysContext.getSysContext().getCurrentUserInfo());
        params.put("CURRENT_COMPANY", SysContext.getSysContext().getCurrentFIUnit());
        params.put("CURRENT_CU", SysContext.getSysContext().getCurrentCtrlUnit());
        params.put("languageLocale", SysContext.getSysContext().getLocale());
        CreateJobFacadeFactory.getRemoteInstance().executeJob(new JobParam(params), jobCfg);
        return processId;
    }

    private void createJobChek(CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        CostUpdateMutexFacadeFactory.getRemoteInstance().checkCostUpdateMutex(companyInfo.getId().toString(), "oneKeyCal");
    }

    private JobConfig createJobCfg(CompanyOrgUnitInfo companyInfo, PeriodInfo currentPeriod) {
        String oneKeyCal = EASResource.getString((String)ONEKEYRESOURCE, (String)"oneKeyCal");
        String title = "\u3010" + companyInfo.getName() + "(" + companyInfo.getNumber() + ")\u3011" + currentPeriod.toString() + oneKeyCal;
        JobConfig jobCfg = new JobConfig();
        jobCfg.setNumber("SCM_CAL_0005");
        jobCfg.setTaskType(companyInfo.getNumber() + "SCM_CAL_0005");
        jobCfg.setTitle(title);
        jobCfg.setDescription(title);
        jobCfg.setNeedCheckTaskType(false);
        return jobCfg;
    }

    private void showProgressUI(String processId) throws UIException {
        Map uiContext;
        if (StringUtils.isEmpty((String)processId)) {
            MsgBox.showWarning((String)EASResource.getString((String)ONEKEYRESOURCE, (String)"createOneKeyCalFail"));
            SysUtil.abort();
        }
        if ((uiContext = this.getUIContext()) == null) {
            uiContext = new UIContext((Object)this);
        }
        uiContext.put("ID", processId);
        Frame frame = UIFactoryHelper.getMainFrame((Map)uiContext);
        Object mainUI = null;
        mainUI = frame instanceof NewMainFrame ? ((NewMainFrame)frame).getMainUI() : UIFactoryHelper.getMainUIObject((Map)uiContext);
        IUIObject[] uiObjectArr = mainUI.getUiManager().findUIObject(OneKeyCalculateProcessUI.class.getName());
        if (uiObjectArr != null && uiObjectArr.length > 0) {
            for (int i = 0; i < uiObjectArr.length; ++i) {
                uiObjectArr[i].getUIWindow().close();
            }
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(OneKeyCalculateProcessUI.class.getName(), uiContext, null, OprtState.VIEW);
        this.getUIWindow().close();
        uiWindow.show();
    }
}

