/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.StandardCostAdjBillEntryInfo;
import com.kingdee.eas.scm.cal.StandardCostAdjBillInfo;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.im.inv.IInventoryBalance;
import com.kingdee.eas.scm.im.inv.InventoryBalanceFactory;

public class CalculRpcUtil {
    public static void setMaterialQtyPresion(RequestContext request, ResponseContext response, Context context) throws EASBizException, BOSException {
        SCMBizDataVO vo;
        StandardCostAdjBillInfo scmBillInfo = (StandardCostAdjBillInfo)request.getValue();
        StandardCostAdjBillInfo standCostInfo = (StandardCostAdjBillInfo)request.getValue();
        if (standCostInfo == null) {
            return;
        }
        IMeasureUnit munit = MeasureUnitFactory.getLocalInstance((Context)context);
        IMultiMeasureUnit imm = MultiMeasureUnitFactory.getLocalInstance((Context)context);
        int count = standCostInfo.getEntry().size();
        CompanyOrgUnitInfo company = standCostInfo.getCompanyOrgUnit();
        PeriodInfo currentPeriodInfo = null;
        if (company == null && (vo = (SCMBizDataVO)request.get("__SCMBIZDATA")) != null) {
            company = (CompanyOrgUnitInfo)vo.getMainOrg();
        }
        if (company != null) {
            CurrencyFactory.getLocalInstance((Context)context).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId()));
            currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)context, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company);
        }
        IInventoryBalance ii = InventoryBalanceFactory.getLocalInstance((Context)context);
        StandardCostAdjBillEntryInfo entry = null;
        MaterialInfo aMaterialInfo = null;
        MeasureUnitInfo measureUnitInfo = null;
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)context);
        SelectorItemCollection selectCollection = null;
        for (int i = 0; i < count; ++i) {
            entry = standCostInfo.getEntry().get(i);
            aMaterialInfo = entry.getMaterial();
            if (aMaterialInfo == null) continue;
            if (aMaterialInfo.getBaseUnit() == null) {
                selectCollection = new SelectorItemCollection();
                selectCollection.add(new SelectorItemInfo("baseUnit.id"));
                measureUnitInfo = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(aMaterialInfo.getId()), selectCollection).getBaseUnit();
            } else {
                measureUnitInfo = aMaterialInfo.getBaseUnit();
            }
            MeasureUnitInfo aMeasureUnitInfo = munit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(measureUnitInfo.getId()));
            imm.getQtyPrecision(aMaterialInfo.getId().toString(), aMeasureUnitInfo.getId().toString());
            if (currentPeriodInfo != null) {
                ii.getPeriodBeginQty(aMaterialInfo.getId().toString(), company.getId().toString(), null, null, currentPeriodInfo);
            }
            iMaterial.getCompanyInfo(aMaterialInfo.getId().toString(), company.getId().toString());
        }
    }

    public static void setPerson(RequestContext request, ResponseContext response, Context context) {
    }

    public static CompanyOrgUnitInfo getCompany(Context context, String companyId) throws BOSException, EASBizException {
        ICompanyOrgUnit icompany = CompanyOrgUnitFactory.getLocalInstance((Context)context);
        return icompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
    }

    public static MaterialInfo getMaterial(Context context, String materialId) throws BOSException, EASBizException {
        return MaterialFactory.getLocalInstance((Context)context).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialId));
    }

    public static BillTypeInfo getBillType(Context context, String billTypeID) throws BOSException, EASBizException {
        return BillTypeFactory.getLocalInstance((Context)context).getBillTypeInfo((IObjectPK)new ObjectUuidPK(billTypeID));
    }

    public static TransactionTypeInfo getTranSactionType(Context context, String transactionTypeID) throws BOSException, EASBizException {
        return TransactionTypeFactory.getLocalInstance((Context)context).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(transactionTypeID));
    }

    public static WarehouseInfo getWarehouseInfo(Context context, String warehouseID) throws BOSException, EASBizException {
        return WarehouseFactory.getLocalInstance((Context)context).getWarehouseInfo((IObjectPK)new ObjectUuidPK(warehouseID));
    }

    public static void setCustomCondition(Context context, RptParams params) throws EASBizException, BOSException {
        if (params.getString("COMPANY_ID") != null && params.getString("COMPANY_ID").length() != 0) {
            CalculRpcUtil.getCompany(context, params.getString("COMPANY_ID"));
        }
        if (params.getString("MATERIAL_ID_FROM") != null && params.getString("MATERIAL_ID_FROM").length() != 0) {
            CalculRpcUtil.getMaterial(context, params.getString("MATERIAL_ID_FROM"));
        }
        if (params.getString("MATERIAL_ID_TO") != null && params.getString("MATERIAL_ID_TO").length() != 0) {
            CalculRpcUtil.getMaterial(context, params.getString("MATERIAL_ID_TO"));
        }
        if (params.getString("BILLTYPE_ID") != null && params.getString("BILLTYPE_ID").length() != 0) {
            CalculRpcUtil.getBillType(context, params.getString("BILLTYPE_ID"));
        }
        if (params.getString("TRANSACTION_ID") != null && params.getString("TRANSACTION_ID").length() != 0) {
            CalculRpcUtil.getTranSactionType(context, params.getString("TRANSACTION_ID"));
        }
        if (params.getString("TRANSACTION_ID_TO") != null && params.getString("TRANSACTION_ID_TO").length() != 0) {
            CalculRpcUtil.getTranSactionType(context, params.getString("TRANSACTION_ID_TO"));
        }
        if (params.getString("WAREHOUSEID") != null && params.getString("WAREHOUSEID").length() != 0) {
            CalculRpcUtil.getWarehouseInfo(context, params.getString("WAREHOUSEID"));
        }
        if (params.getString("WAREHOUSEID_TO") != null && params.getString("WAREHOUSEID_TO").length() != 0) {
            CalculRpcUtil.getWarehouseInfo(context, params.getString("WAREHOUSEID_TO"));
        }
    }

    public static void setPeriod(Context context, String companyID) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = CalculRpcUtil.getCompany(context, companyID);
        SystemStatusCtrolUtils.getCurrentPeriod((Context)context, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company);
    }
}

