/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fi.gl.GLException;
import com.kingdee.eas.base.param.INantionalServiceFacade;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.scm.cal.CalRptUtilFacadeFactory;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CostAdjuestCreateTypeEnum;
import com.kingdee.eas.scm.cal.ICalRptUtilFacade;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculatePrecision;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffEntry;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.util.numeric.PrecisionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CalculateUtil
implements Serializable {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.util.CalculateUtil");
    private static final long serialVersionUID = -1365076793432468729L;
    public static final String DATE_FORMATE_PATTERN = "yyyy-MM-dd HH:mm:ss.000";
    public static final String RESOURCE_CAL_COMMON = "com.kingdee.eas.scm.cal.CalCommonResource";
    public static final String RESOURCE_CAL_REPORT = "com.kingdee.eas.scm.cal.CalRptResource";
    public static final String RESOURCE_CAL_EXPENSE = "com.kingdee.eas.scm.cal.ExpenseApportionResource";
    public static final String SIGN_MULTIPLY = " * ";
    public static final String SIGN_EQUALS = " = ";
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final BigDecimal HUNDRED = new BigDecimal("100.00");
    public static final BigDecimal ONE = new BigDecimal("1.00");
    public static final BigDecimal ONE_MINUS = new BigDecimal("-1.00");
    public static final String NEWLINE = "\t\n";
    public static final String SCM_CAL_033 = "SCM_CAL_033";
    public static final String DISCHARGETYPE_PARAM = "SCM_CAL_001";
    public static final String ISMERGECOSTADJ_PARAM = "SCM_CAL_004";
    public static final String ISCOSTPRICEMOVE_PARAM = "SCM_CAL_010";
    public static final String ISFULLCOSTADJ_PARAM = "SCM_CAL_005";
    public static final String ISINPOURCOSTCALCULATE_PARAM = "SCM_CAL_006";
    public static final String EXPAPPORTION_VOUCHER_TYPE_PARAM = "SCM_CAL_008";
    public static final String ISMOVEINPOURCOSTCALCULATE_PARAM = "SCM_CAL_009";
    public static final String EXPAPPORTION_EVALUATE_TYPE_PARAM = "SCM_CAL_011";
    public static final String COSTADJUST_RANGE_PARAM = "SCM_CAL_012";
    public static final String SCM_CAL_013 = "SCM_CAL_013";
    public static final String SCM_CAL_014 = "SCM_CAL_014";
    public static final String SCM_CAL_015 = "SCM_CAL_015";
    public static final String SCM_CAL_016 = "SCM_CAL_016";
    public static final String SCM_CAL_017 = "SCM_CAL_017";
    public static final String SCM_CAL_018 = "SCM_CAL_018";
    public static final String SCM_CAL_022 = "SCM_CAL_022";
    public static final String SCM_CAL_029 = "SCM_CAL_029";
    public static final String SCM_CAL_030 = "SCM_CAL_030";
    public static final String SCM_CAL_031 = "SCM_CAL_031";
    public static final String SCM_CAL_032 = "SCM_CAL_032";
    public static final String SCM_CAL_027 = "SCM_CAL_027";
    public static final String AR_032 = "AR_032";
    public static final String SCM_CAL_019 = "SCM_CAL_019";
    public static final String SCM_CAL_PurVar_Adj = "SCM_CAL_PurVar_Adj";
    public static final int FILTER_COMPANY = 0;
    public static final int FILTER_PERIOD = 1;
    public static final int FILTER_CURRENCY = 2;
    public static final int END_OF_FILTER = 3;
    public static final int IN_BILL = 0;
    public static final int OUT_BILL = 1;
    public static final int COST_BILL = 2;
    public static final String DEVOLVE_BIZ_TYPE_NUMBER = "('130', '131', '132', '140', '141')";
    public static final String isNotSrcOutBillCalType = "isNotSrcOutBillCalType";
    public static final String isChkEntrust = "isChkEntrust";
    public static final String isCalMovLocBill = "isCalMovLocBill";
    public static final String isGetBlueIssueCost = "isGetBlueIssueCost";
    public static final String isSrcPerBillOutBillCalType = "isSrcPerBillOutBillCalType";
    public static final String strTimeFormat = "yyyy-MM-dd HH:mm:ss";
    public static final String strDateFormat = "yyyy-MM-dd";
    public static final Set createTypeSet = new HashSet();

    public static AccountType getMaterialAccountType(Context ctx, MaterialInfo material, CompanyOrgUnitInfo companyOrgUnit) throws BOSException, EASBizException {
        IMaterial imat = null;
        imat = ctx == null ? MaterialFactory.getRemoteInstance() : MaterialFactory.getLocalInstance((Context)ctx);
        MaterialCompanyInfoInfo matComInfo = imat.getCompanyInfo(material.getId().toString(), companyOrgUnit.getId().toString());
        if (matComInfo == null) {
            throw new CalculateException(CalculateException.MATERIAL_CAL_TYPE_NOT_EXIST, new String[]{""});
        }
        return matComInfo.getAccountType();
    }

    public static DecimalFormat getDecimalFormat(Context ctx) throws BOSException, EASBizException {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String orgId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        INantionalServiceFacade nationalSvr = null;
        nationalSvr = ctx == null ? NantionalServiceFacadeFactory.getRemoteInstance() : NantionalServiceFacadeFactory.getLocalInstance((Context)ctx);
        HashMap nationMap = nationalSvr.getNationalConfig(userId, orgId, ctx.getLocale().toString());
        DecimalFormat df = (DecimalFormat)nationMap.get("numberFormat");
        return df;
    }

    public static String getDecimalFormatString(DecimalFormat numberFormat, BigDecimal dec, int scale) {
        if (numberFormat == null || dec == null) {
            return null;
        }
        numberFormat.applyPattern(PrecisionUtil.getFmtString((int)scale));
        return numberFormat.format(dec);
    }

    public static boolean isStandardPrice2(Context ctx, MaterialInfo material, CompanyOrgUnitInfo companyOrgUnit) throws BOSException, EASBizException {
        IMaterial imat = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialCompanyInfoInfo matComInfo = imat.getCompanyInfo(material.getId().toString(), companyOrgUnit.getId().toString());
        if (matComInfo == null) {
            throw new CalculateException(CalculateException.MATERIAL_CAL_TYPE_NOT_EXIST, new String[]{""});
        }
        return matComInfo.getAccountType() != AccountType.MOVE_ADD_AVERAGE;
    }

    public static boolean isWeightPrice2(Context ctx, MaterialInfo material, CompanyOrgUnitInfo companyOrgUnit) throws BOSException, EASBizException {
        IMaterial imat = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialCompanyInfoInfo matComInfo = imat.getCompanyInfo(material.getId().toString(), companyOrgUnit.getId().toString());
        if (matComInfo == null) {
            throw new CalculateException(CalculateException.MATERIAL_CAL_TYPE_NOT_EXIST, new String[]{""});
        }
        return matComInfo.getAccountType() == AccountType.MOVE_ADD_AVERAGE;
    }

    public static int getLocalCurrencyPrecision2(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select currency.fPrecision from ");
        sql.append(" t_org_company company inner join t_bd_currency currency");
        sql.append(" on company.fbaseCurrencyid=currency.fid");
        sql.append(" where company.fid='").append(companyOrgUnitInfo.getId()).append("'");
        Object obj = DBUtil.takeValue(ctx, sql.toString());
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).intValue();
        }
        return 2;
    }

    public static int getLocalCurrencyPrecision(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo) throws EASBizException, BOSException {
        CurrencyInfo currency = null;
        if (companyOrgUnitInfo == null) {
            return 2;
        }
        if (companyOrgUnitInfo.getBaseCurrency() != null) {
            currency = companyOrgUnitInfo.getBaseCurrency();
        } else {
            ICompanyOrgUnit corgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("baseCurrency");
            CompanyOrgUnitInfo info = corgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getId()), selectors);
            currency = info.getBaseCurrency();
        }
        if (currency != null) {
            ICurrency ic = null;
            ic = ctx != null ? CurrencyFactory.getLocalInstance((Context)ctx) : CurrencyFactory.getRemoteInstance();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("Precision"));
            currency = ic.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId().toString()), sic);
            return currency.getPrecision();
        }
        return 2;
    }

    public static CalculatePrecision createCalculatePresion(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, CalculateWrittenOffEntry entry, int local_Currency_Presision) throws EASBizException, BOSException {
        return CalculateUtil.createCalculatePresion(ctx, companyOrgUnitInfo, entry.getMaterial().getId().toString(), local_Currency_Presision);
    }

    public static boolean isUseAddAverage(Context ctx, String orgUnitID) throws BOSException {
        StringBuffer sql = new StringBuffer("select top 1 fid from t_bd_materialcompanyinfo");
        sql.append(" where fcompanyid='").append(orgUnitID).append("'");
        sql.append(" and faccounttype=").append(1);
        sql.append(" and (");
        sql.append("    fstatus=").append(1);
        sql.append(" or fstatus=").append(2);
        sql.append(" )");
        return DBUtil.takeValue(ctx, sql.toString()) != null;
    }

    public static boolean isOnlyUseAddAverage(Context ctx, String orgUnitID) throws BOSException {
        StringBuffer sql = new StringBuffer("select top 1 fid from t_bd_materialcompanyinfo");
        sql.append(" where fcompanyid='").append(orgUnitID).append("'");
        sql.append(" and (");
        sql.append(" (");
        sql.append(" faccounttype=").append(3);
        sql.append(" and (");
        sql.append("    fstatus=").append(1);
        sql.append(" or fstatus=").append(2);
        sql.append(" )");
        sql.append(" )");
        sql.append(" or ");
        sql.append(" (");
        sql.append(" faccounttype=").append(4);
        sql.append(" and (");
        sql.append("    fstatus=").append(1);
        sql.append(" or fstatus=").append(2);
        sql.append(" )");
        sql.append(" )");
        sql.append(" or ");
        sql.append(" (");
        sql.append(" faccounttype=").append(5);
        sql.append(" and (");
        sql.append("    fstatus=").append(1);
        sql.append(" or fstatus=").append(2);
        sql.append(" )");
        sql.append(" )");
        sql.append(" )");
        return DBUtil.takeValue(ctx, sql.toString()) == null;
    }

    public static CalculatePrecision createCalculatePresion(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, String materialID) throws EASBizException, BOSException {
        return CalculateUtil.createCalculatePresion(ctx, companyOrgUnitInfo, materialID, CalculateUtil.getLocalCurrencyPrecision(ctx, companyOrgUnitInfo));
    }

    public static CalculatePrecision createCalculatePresion(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, String materialID, int local_Currency_Presision) throws EASBizException, BOSException {
        CalculatePrecision cprecision = new CalculatePrecision();
        IMultiMeasureUnit imm = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialInfo minfo = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
        cprecision.setBaseQtyPrecision(imm.getQtyPrecision(materialID, minfo.getBaseUnit().getId().toString()));
        cprecision.setPricePrecision(minfo.getPricePrecision());
        cprecision.setLocalCurrencyPrecision(local_Currency_Presision);
        if (cprecision.getLocalCurrencyPrecision() < 0) {
            cprecision.setLocalCurrencyPrecision(2);
        }
        if (cprecision.getBaseQtyPrecision() < 0) {
            cprecision.setBaseQtyPrecision(6);
        }
        if (cprecision.getBaseQtyPrecision() < 0) {
            cprecision.setBaseQtyPrecision(6);
        }
        return cprecision;
    }

    public static void fmtTableAmt(KDTable table, String columnName, int scale) throws BOSException, EASBizException {
        table.getColumn(columnName).getStyleAttributes().setNumberFormat(CalculateUtil.fmtTableString(scale).toString());
        table.getColumn(columnName).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public static void fmtTableAmt(IColumn column, int scale) throws BOSException, EASBizException {
        column.getStyleAttributes().setNumberFormat(CalculateUtil.fmtTableString(scale).toString());
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public static void fmtTableAmt(ICell cell, int scale) throws BOSException, EASBizException {
        cell.getStyleAttributes().setNumberFormat(CalculateUtil.fmtTableString(scale).toString());
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public static StringBuffer fmtTableString(int scale) throws BOSException, EASBizException {
        return PrecisionUtil.fmtTableString((int)scale);
    }

    public static CompanyOrgUnitInfo takeFinanceOrgFromEntry(Context ctx, SCMBillBaseInfo bill) throws EASBizException, BOSException {
        InvBillBaseEntryInfo inv;
        CompanyOrgUnitInfo cou = null;
        if (bill != null && bill instanceof InvBillBaseInfo && bill.get("Entry") != null && (inv = (InvBillBaseEntryInfo)((IObjectCollection)bill.get("Entry")).getObject(0)) != null) {
            cou = inv.getCompanyOrgUnit();
        }
        if (cou == null) {
            throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
        }
        return cou;
    }

    public static String takeSysServerParamValue(Context ctx, CompanyOrgUnitInfo aCompanyOrgUnitInfo, String param_2) throws EASBizException, BOSException {
        HashMap hm = ParamManager.getParamHashMap((Context)ctx, (String[])new String[]{param_2}, (String)aCompanyOrgUnitInfo.getId().toString());
        String calType = (String)hm.get(param_2);
        if (calType == null || "".equals(calType)) {
            throw new CalculateException(CalculateException.MATERIAL_CAL_KIND_NOT_EXIST);
        }
        return calType;
    }

    public static int takePeriodValueByDate(Context ctx, Date date) throws EASBizException, BOSException {
        if (date == null) {
            throw new CalculateException(CalculateException.BIZ_DATE_IS_NULL, new String[]{""});
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat(strTimeFormat);
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            int i = c.get(1) * 100 + c.get(2) + 1;
            IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)format.format(date), CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)format.format(date), CompareType.GREATER_EQUALS));
            IObjectPK[] pks = iPeriod.getPKList(filter, null);
            if (pks != null && pks.length > 0) {
                PeriodInfo aPeriodInfo = iPeriod.getPeriodInfo(pks[0]);
                if (aPeriodInfo.isIsAdjustPeriod()) {
                    aPeriodInfo = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)aPeriodInfo);
                }
                if (aPeriodInfo != null) {
                    i = aPeriodInfo.getPeriodYear() * 100 + aPeriodInfo.getPeriodNumber();
                }
            }
            return i;
        }
        catch (Exception e) {
            throw new CalculateException(CalculateException.ACCT_PERIOD_NOT_EXIST, new String[]{""});
        }
    }

    public static int takePeriodValueByPeriod(PeriodInfo aPeriodInfo) {
        int i = 0;
        if (aPeriodInfo != null) {
            i = aPeriodInfo.getPeriodYear() * 100 + aPeriodInfo.getPeriodNumber();
        } else {
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            i = c.get(1) * 100 + c.get(2) + 1;
        }
        return i;
    }

    public static int takePeriodValueByDate2(Context ctx, Date date, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        if (date == null) {
            throw new CalculateException(CalculateException.BIZ_DATE_IS_NULL, new String[]{""});
        }
        try {
            PeriodInfo aPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)date, (CompanyOrgUnitInfo)companyInfo, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT);
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            int i = c.get(1) * 100 + c.get(2) + 1;
            if (aPeriodInfo != null && aPeriodInfo.isIsAdjustPeriod()) {
                aPeriodInfo = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)aPeriodInfo);
            }
            if (aPeriodInfo != null) {
                i = aPeriodInfo.getPeriodYear() * 100 + aPeriodInfo.getPeriodNumber();
            }
            return i;
        }
        catch (Exception e) {
            throw new CalculateException(CalculateException.ACCT_PERIOD_NOT_EXIST, new String[]{""});
        }
    }

    public static String takeFormateDesc(String name, String number) {
        if (number == null || number.length() < 1) {
            return CalculateUtil.takeFormateDesc(name);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(name);
        sb.append("(");
        sb.append(number);
        sb.append(")");
        sb.append("]");
        return sb.toString();
    }

    public static String takeFormateDesc(String number) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(number);
        sb.append("]");
        return sb.toString();
    }

    public static String transCreateTable(Context ctx, String sql) {
        if (ctx.get((Object)"dbType") != null) {
            String dbType = (String)ctx.get((Object)"dbType");
            if ((dbType = dbType.toLowerCase()).indexOf("db2") > -1) {
                sql = sql.toLowerCase();
                sql = sql.replaceAll("numeric\\(28,16\\)", "numeric(21,8)");
                sql = sql.replaceAll("numeric\\(19,4\\)", "numeric(17,4)");
            }
        }
        return sql;
    }

    public static StringBuffer TO_DECIMAL_SUM(String string) {
        StringBuffer str = new StringBuffer();
        str.append("TO_DECIMAL(").append(string).append(", 17, 4)");
        return str;
    }

    public static StringBuffer TO_DECIMAL_AMT(String string) {
        StringBuffer str = new StringBuffer();
        str.append("TO_DECIMAL(").append(string).append(", 17, 4)");
        return str;
    }

    public static StringBuffer TO_DECIMAL_QTY(String string) {
        StringBuffer str = new StringBuffer();
        str.append("TO_DECIMAL(").append(string).append(", 21, 8)");
        return str;
    }

    public static StringBuffer TO_DECIMAL_DIVIDE(String string) {
        StringBuffer str = new StringBuffer();
        str.append("TO_DECIMAL(").append(string).append(", 21, 8)");
        return str;
    }

    public static boolean tranBooleanFromInt(int i) {
        return i != 0;
    }

    public static HashMap getUserDefineField(Context ctx) {
        PurInWarehsEntryInfo entry = new PurInWarehsEntryInfo();
        IMetaDataLoader imeataLoader = null == ctx ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk = imeataLoader.getEntityObjectPK(entry.getBOSType());
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk);
        PropertyCollection coll = entityObjectInfo.getEntityProperties();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < coll.size(); ++i) {
            OwnPropertyInfo ownprop;
            DataType dt;
            PropertyInfo info = coll.get(i);
            if (!info.isUserDefined() || !(info instanceof OwnPropertyInfo) || !DataType.DECIMAL.equals((Object)(dt = (ownprop = (OwnPropertyInfo)info).getDataType()))) continue;
            map.put(info.getMappingField().getName(), info.getAlias());
        }
        return map;
    }

    public static String getEntryTableNameFormBillTableName(String name) {
        if ("t_sm_purinvoicebill".equalsIgnoreCase(name)) {
            return "t_sm_purinvoiceentry";
        }
        if ("t_sd_saleinvoicebill".equalsIgnoreCase(name)) {
            return "t_sd_saleinvoiceentry";
        }
        if ("t_im_purinwarehsbill".equalsIgnoreCase(name)) {
            return "t_im_purinwarehsentry";
        }
        if ("t_im_saleissuebill".equalsIgnoreCase(name)) {
            return "t_im_saleissueentry";
        }
        if ("t_im_moveissuebill".equalsIgnoreCase(name)) {
            return "t_im_moveissuebillentry";
        }
        if ("t_im_moveinwarehsbill".equalsIgnoreCase(name)) {
            return "t_im_moveinwarehsbillentry";
        }
        if ("t_im_materialreqbill".equalsIgnoreCase(name)) {
            return "t_im_materialreqbillentry";
        }
        if ("t_im_manufacturerecbill".equalsIgnoreCase(name)) {
            return "t_im_manufacturerecbillentry";
        }
        if ("t_im_otherissuebill".equalsIgnoreCase(name)) {
            return "t_im_otherissuebillentry";
        }
        if ("t_im_otherinwarehsbill".equalsIgnoreCase(name)) {
            return "t_im_otherinwarehsbillentry";
        }
        if ("t_cl_costadjustbill".equalsIgnoreCase(name)) {
            return "t_cl_costadjustbillentry";
        }
        if ("t_ap_otherbill".equalsIgnoreCase(name)) {
            return "t_ap_otherbillentry";
        }
        if ("t_ar_otherbill".equalsIgnoreCase(name)) {
            return "t_ar_otherbillentry";
        }
        return null;
    }

    public static Set getAuthorizedOrg(ObjectUuidPK userPK, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitCollection coll;
        LinkedHashSet<String> authorizedStorageSet = new LinkedHashSet<String>();
        Object[] storageOrgs = null;
        try {
            coll = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)userPK, OrgType.Storage, null, permItem);
            storageOrgs = coll.toArray();
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex0) {
            throw ex0;
        }
        OrgUnitInfo orgUnit = null;
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            orgUnit = (OrgUnitInfo)storageOrgs[i];
            authorizedStorageSet.add(orgUnit.getId().toString());
        }
        return authorizedStorageSet;
    }

    public static boolean isAuthorizedOrg(Context ctx, BOSUuid userPK, OrgType orgType, String permItem, OrgUnitInfo cou) throws EASBizException, BOSException {
        FullOrgUnitCollection coll = null;
        Object[] storageOrgs = null;
        IPermission ipermi = null;
        boolean bln = false;
        try {
            ipermi = ctx != null ? PermissionFactory.getLocalInstance((Context)ctx) : PermissionFactory.getRemoteInstance();
            ObjectUuidPK treePK = null;
            if (orgType != null) {
                treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
            }
            coll = ipermi.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userPK), orgType, (IObjectPK)treePK, permItem);
            storageOrgs = coll.toArray();
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex0) {
            throw ex0;
        }
        if (cou != null && storageOrgs != null) {
            int n = storageOrgs.length;
            for (int i = 0; i < n; ++i) {
                OrgUnitInfo orgUnit = (OrgUnitInfo)storageOrgs[i];
                if (orgUnit == null || !cou.getId().equals((Object)orgUnit.getId())) continue;
                bln = true;
                break;
            }
        }
        return bln;
    }

    public static StringBuffer getCreateTableSQl(String tempTableName, String[][] fields) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(tempTableName);
        sql.append("(");
        for (int i = 0; i < fields.length; ++i) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append(fields[i][0]);
            sql.append(" ");
            sql.append(fields[i][1]);
        }
        sql.append(")");
        return sql;
    }

    public static String getFormatPattern(int scale) {
        return PrecisionUtil.getFormatPattern((int)scale);
    }

    public static Timestamp getTime(Date date) {
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        createtime.toString();
        return createtime;
    }

    public static Timestamp getTime(String str) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMATE_PATTERN);
        Date date = null;
        try {
            date = sdf.parse(str);
        }
        catch (ParseException e) {
            logger.error((Object)e);
        }
        return CalculateUtil.getTime(date);
    }

    public static void loadAccountPeriod(KDBizPromptBox bizOrgUnit, KDSpinner spAccPeriodYear, KDSpinner spAccPeriodYearTo, KDSpinner spAccPeriodMonth, KDSpinner spAccPeriodMonthTo) throws EASBizException, BOSException {
        ICalRptUtilFacade iCalRptUtil;
        Object[] reslut;
        Object orgInfo = bizOrgUnit.getValue();
        CompanyOrgUnitInfo companyInfo = null;
        if (orgInfo instanceof CompanyOrgUnitInfo) {
            companyInfo = (CompanyOrgUnitInfo)orgInfo;
        } else if (orgInfo instanceof OrgUnitInfo) {
            String id = ((OrgUnitInfo)orgInfo).getId().toString();
            companyInfo = (CompanyOrgUnitInfo)SCMGroupClientUtils.getOrgUnitInfoByType((String)id, (OrgType)OrgType.Company);
        }
        if (companyInfo == null) {
            return;
        }
        if (companyInfo != null) {
            PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            if (periodInfo == null) {
                bizOrgUnit.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTSTART);
            }
            if (curPeriodInfo == null) {
                bizOrgUnit.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTCURRENT);
            }
        }
        if ((reslut = (iCalRptUtil = CalRptUtilFacadeFactory.getRemoteInstance()).fetchInitFilterData(companyInfo.getId().toString())) != null) {
            AccountPeriodInfo actPeriodInfo = (AccountPeriodInfo)reslut[1];
            CalculateUtil.appliesPeriodControl(spAccPeriodYear, spAccPeriodYearTo, spAccPeriodMonth, spAccPeriodMonthTo, actPeriodInfo, true, false);
        }
    }

    public static void appliesPeriodControl(final KDSpinner spnYearFrom, final KDSpinner spnYearTo, final KDSpinner spnNumberFrom, final KDSpinner spnNumberTo, AccountPeriodInfo pi, boolean fromStartPeriod, boolean toCurPeriod) {
        int j;
        Vector temp;
        int[] p;
        CalculateUtil.removeChangeListeners(spnYearFrom);
        CalculateUtil.removeChangeListeners(spnYearTo);
        CalculateUtil.removeChangeListeners(spnNumberFrom);
        CalculateUtil.removeChangeListeners(spnNumberTo);
        final Vector vecPrd = pi.periods;
        if (fromStartPeriod) {
            int startYear = pi.startPeriod.getPeriodYear();
            int startNumber = pi.startPeriod.getPeriodNumber();
            int n = vecPrd.size();
            for (int i = 0; i < n; ++i) {
                p = (int[])vecPrd.get(i);
                if (startYear != p[0]) continue;
                if (i <= 0 && startNumber <= p[1]) break;
                temp = new Vector();
                for (j = i; j < n; ++j) {
                    temp.add(vecPrd.get(j));
                }
                vecPrd.clear();
                vecPrd.addAll(temp);
                ((int[])vecPrd.get((int)0))[1] = startNumber;
                break;
            }
        }
        if (toCurPeriod) {
            int curYear = pi.curPeriod.getPeriodYear();
            int curNumber = pi.curPeriod.getPeriodNumber();
            int n = vecPrd.size();
            for (int i = n - 1; i >= 0; --i) {
                p = (int[])vecPrd.get(i);
                if (curYear != p[0]) continue;
                if (i >= n - 1 && curNumber >= p[2]) break;
                temp = new Vector();
                for (j = 0; j <= i; ++j) {
                    temp.add(vecPrd.get(j));
                }
                vecPrd.clear();
                vecPrd.addAll(temp);
                ((int[])vecPrd.get((int)i))[2] = curNumber;
                break;
            }
        }
        final HashMap<Integer, int[]> hmPrd = new HashMap<Integer, int[]>();
        for (int[] p2 : pi.periods) {
            hmPrd.put(new Integer(p2[0]), p2);
        }
        SpinnerNumberModel modelYearFrom = new SpinnerNumberModel(0, 0, 0, 1);
        SpinnerNumberModel modelYearTo = new SpinnerNumberModel(0, 0, 0, 1);
        SpinnerNumberModel modelNumberFrom = new SpinnerNumberModel(0, 0, 0, 1);
        SpinnerNumberModel modelNumberTo = new SpinnerNumberModel(0, 0, 0, 1);
        spnYearFrom.setModel((SpinnerModel)modelYearFrom);
        spnYearTo.setModel((SpinnerModel)modelYearTo);
        spnNumberFrom.setModel((SpinnerModel)modelNumberFrom);
        spnNumberTo.setModel((SpinnerModel)modelNumberTo);
        spnYearFrom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Integer yearFrom = (Integer)spnYearFrom.getValue();
                if (yearFrom == null || yearFrom == 0) {
                    return;
                }
                Integer yearTo = (Integer)spnYearTo.getValue();
                if (yearTo == null || yearTo.compareTo(yearFrom) < 0) {
                    yearTo = yearFrom;
                }
                CalculateUtil.setSpinnerValue(spnYearTo, yearTo, yearFrom, new Integer(((int[])vecPrd.get(vecPrd.size() - 1))[0]));
                int[] p = (int[])hmPrd.get(yearFrom);
                if (p == null) {
                    return;
                }
                Integer numberFrom = (Integer)spnNumberFrom.getValue();
                if (numberFrom == null) {
                    numberFrom = new Integer(p[1]);
                } else {
                    int val = numberFrom;
                    if (val < p[1]) {
                        numberFrom = new Integer(p[1]);
                    } else if (val > p[2]) {
                        numberFrom = new Integer(p[2]);
                    }
                }
                CalculateUtil.setSpinnerValue(spnNumberFrom, numberFrom, new Integer(p[1]), new Integer(p[2]));
            }
        });
        spnNumberFrom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int[] p;
                Integer numberFrom = (Integer)spnNumberFrom.getValue();
                Integer yearFrom = (Integer)spnYearFrom.getValue();
                Integer yearTo = (Integer)spnYearTo.getValue();
                if (numberFrom == null || yearFrom == null || yearTo == null || yearFrom.compareTo(yearTo) != 0) {
                    return;
                }
                Integer numberTo = (Integer)spnNumberTo.getValue();
                if (numberTo == null || numberTo.compareTo(numberFrom) < 0) {
                    numberTo = numberFrom;
                }
                if ((p = (int[])hmPrd.get(yearTo)) == null) {
                    return;
                }
                CalculateUtil.setSpinnerValue(spnNumberTo, numberTo, numberFrom, new Integer(p[2]));
            }
        });
        spnYearTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Integer numberTo;
                Integer yearTo = (Integer)spnYearTo.getValue();
                if (yearTo == null || yearTo == 0) {
                    return;
                }
                int[] p = (int[])hmPrd.get(yearTo);
                if (p == null) {
                    return;
                }
                int begin = p[1];
                Integer yearFrom = (Integer)spnYearFrom.getValue();
                Integer numberFrom = (Integer)spnNumberFrom.getValue();
                if (yearFrom != null && numberFrom != null && yearFrom.compareTo(yearTo) == 0) {
                    begin = numberFrom;
                }
                if ((numberTo = (Integer)spnNumberTo.getValue()) == null) {
                    numberTo = new Integer(p[1]);
                } else {
                    int val = numberTo;
                    if (val < begin) {
                        numberTo = new Integer(begin);
                    } else if (val > p[2]) {
                        numberTo = new Integer(p[2]);
                    }
                }
                CalculateUtil.setSpinnerValue(spnNumberTo, numberTo, new Integer(begin), new Integer(p[2]));
            }
        });
        int curPeriodYear = pi.curPeriod.getPeriodYear();
        int curPeriodNumber = pi.curPeriod.getPeriodNumber();
        CalculateUtil.setSpinnerValue(spnYearFrom, new Integer(curPeriodYear), new Integer(((int[])vecPrd.get(0))[0]), new Integer(((int[])vecPrd.get(vecPrd.size() - 1))[0]));
        spnYearTo.setValue((Object)new Integer(curPeriodYear));
        spnNumberFrom.setValue((Object)new Integer(curPeriodNumber));
        spnNumberTo.setValue((Object)new Integer(curPeriodNumber));
    }

    public static void removeChangeListeners(KDSpinner kdSpin) {
        if (kdSpin == null) {
            return;
        }
        ChangeListener[] listeners = kdSpin.getChangeListeners();
        if (listeners != null) {
            int size = listeners.length;
            for (int i = 0; i < size; ++i) {
                kdSpin.removeChangeListener(listeners[i]);
            }
        }
    }

    private static void setSpinnerValue(KDSpinner spn, Integer val, Integer min, Integer max) {
        spn.setValue((Object)val);
        SpinnerNumberModel model = (SpinnerNumberModel)spn.getModel();
        model.setMinimum(min);
        model.setMaximum(max);
    }

    public static AccountPeriodInfo getAccountPeriodInfo(Context ctx, String comId, String prdTypeId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(2)));
        fic.add(new FilterItemInfo("company.id", (Object)comId));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("currentPeriod.periodYear"));
        sic.add(new SelectorItemInfo("currentPeriod.periodNumber"));
        sic.add(new SelectorItemInfo("currentPeriod.beginDate"));
        sic.add(new SelectorItemInfo("currentPeriod.endDate"));
        sic.add(new SelectorItemInfo("startPeriod.periodYear"));
        sic.add(new SelectorItemInfo("startPeriod.periodNumber"));
        sic.add(new SelectorItemInfo("startPeriod.beginDate"));
        sic.add(new SelectorItemInfo("startPeriod.endDate"));
        ISystemStatusCtrol ctrl = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        SystemStatusCtrolCollection col = ctrl.getSystemStatusCtrolCollection(view);
        AccountPeriodInfo pi = new AccountPeriodInfo();
        if (col.size() == 1) {
            SystemStatusCtrolInfo sci = col.get(0);
            pi.startPeriod = sci.getStartPeriod();
            pi.curPeriod = sci.getCurrentPeriod();
            if (pi.startPeriod != null) {
                String sql = "select p.FPeriodYear periodYear, MIN(p.FPeriodNumber) minPeriodNum, MAX(p.FPeriodNumber) maxPeriodNum from T_BD_Period p where p.FTypeID = ? group by p.FPeriodYear order by p.FPeriodYear";
                Connection conn = null;
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    conn = CalculateUtil.getConnection(ctx);
                    ps = conn.prepareStatement(sql);
                    ps.setString(1, prdTypeId);
                    rs = ps.executeQuery();
                    pi.periods = new Vector();
                    while (rs.next()) {
                        pi.periods.add(new int[]{rs.getInt(1), rs.getInt(2), rs.getInt(3)});
                    }
                }
                catch (SQLException ex) {
                    try {
                        throw new SQLDataException(ex);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, ps, (Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
            }
        }
        if (pi.startPeriod == null) {
            throw new CalculateException(CalculateException.PERIOD_ERROR);
        }
        if (pi.curPeriod == null) {
            throw new CalculateException(CalculateException.CURRENCY_PERIOD_ERROR);
        }
        if (pi.periods.size() == 0) {
            throw new GLException(GLException.NOPERIODLIST);
        }
        return pi;
    }

    public static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public static CompanyOrgUnitInfo getCurrentCompany(Context ctx, String comId, SelectorItemCollection sic, boolean mustBeEntity) throws BOSException, EASBizException {
        if (sic == null) {
            sic = CalculateUtil.getCompanySic();
        }
        ICompanyOrgUnit comCtrl = null;
        comCtrl = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitInfo com = null;
        ObjectUuidPK comPK = null;
        try {
            comPK = new ObjectUuidPK(BOSUuid.read((String)comId));
            com = (CompanyOrgUnitInfo)comCtrl.getValue((IObjectPK)comPK, sic);
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOCOMPANY, (Throwable)ex);
        }
        if (mustBeEntity && !com.isIsBizUnit()) {
            throw new GLException(GLException.COMMUSTBEENTITY);
        }
        return com;
    }

    public static SelectorItemCollection getCompanySic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("baseCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.precision"));
        sic.add(new SelectorItemInfo("reportCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("accountPeriodType.number"));
        sic.add(new SelectorItemInfo("accountPeriodType.name"));
        sic.add(new SelectorItemInfo("isGrouping"));
        sic.add(new SelectorItemInfo("isGroup"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        sic.add(new SelectorItemInfo("isBizUnit"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("reportConvertMode"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        sic.add(new SelectorItemInfo("mainOrg.id"));
        sic.add(new SelectorItemInfo("mainOrg.name"));
        sic.add(new SelectorItemInfo("mainOrg.number"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.id"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.name"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.number"));
        sic.add(new SelectorItemInfo("accountScheme.id"));
        sic.add(new SelectorItemInfo("accountScheme.name"));
        sic.add(new SelectorItemInfo("accountScheme.number"));
        return sic;
    }

    public static String getcalcHMSString(int timeSecond) {
        int timeInSecond;
        String resHour = EASResource.getString((String)RESOURCE_CAL_COMMON, (String)"COST_HOUR");
        String resMinute = EASResource.getString((String)RESOURCE_CAL_COMMON, (String)"COST_MINUTE");
        String resSecond = EASResource.getString((String)RESOURCE_CAL_COMMON, (String)"COST_SECOND");
        int es = timeSecond / 1000;
        int hour = es / 3600;
        int timeInminute = es - hour * 3600;
        int minute = timeInminute / 60;
        int second = timeInSecond = timeInminute - minute * 60;
        return hour + " " + resHour + " " + minute + " " + resMinute + " " + second + " " + resSecond;
    }

    public static String genRandomNum(int pwd_len) {
        int maxNum = 36;
        int count = 0;
        char[] str = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        StringBuffer pwd = new StringBuffer("");
        SecureRandom r = new SecureRandom();
        while (count < pwd_len) {
            int i = Math.abs(r.nextInt(36));
            if (i < 0 || i >= str.length) continue;
            pwd.append(str[i]);
            ++count;
        }
        return pwd.toString();
    }

    public static StringBuffer TO_DECIMAL_AMTForOracle(String string) {
        StringBuffer str = new StringBuffer();
        str.append("TO_DECIMAL(").append(string).append(",19,4)");
        return str;
    }

    public static String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    public static void setInvBillNoFilterF7(KDBizPromptBox purinBillNo, boolean isFilterBillStatus, BillBaseStatusEnum baseStatus) {
        EntityViewInfo viewInfo = InvClientUtils.getBizStorageFilter();
        FilterInfo filter = new FilterInfo();
        if (isFilterBillStatus && baseStatus != null) {
            filter.getFilterItems().add(new FilterItemInfo("BASESTATUS", (Object)new Integer(baseStatus.getValue()), CompareType.EQUALS));
        }
        try {
            viewInfo.getFilter().mergeFilter(filter, "AND");
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        purinBillNo.setEntityViewInfo(viewInfo);
        purinBillNo.setEnabledMultiSelection(false);
        purinBillNo.setEditFormat("$number$");
        purinBillNo.setDisplayFormat("$number$");
        purinBillNo.setCommitFormat("$number$");
    }

    public static int getLocalCurrencyPrecision(Context ctx, String compnayId) throws EASBizException, BOSException {
        CurrencyInfo currency = null;
        if (compnayId == null) {
            return 2;
        }
        ICompanyOrgUnit corgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("baseCurrency");
        CompanyOrgUnitInfo info = corgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(compnayId), selectors);
        currency = info.getBaseCurrency();
        if (currency != null) {
            ICurrency ic = null;
            ic = ctx != null ? CurrencyFactory.getLocalInstance((Context)ctx) : CurrencyFactory.getRemoteInstance();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("Precision"));
            currency = ic.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId().toString()), sic);
            return currency.getPrecision();
        }
        return 2;
    }

    public static FullOrgUnitCollection getOrgUnitPermissionItem(Context ctx, OrgType orgType, String permissionItem, IObjectPK userPK, ObjectUuidPK treePK) {
        if (userPK == null) {
            return null;
        }
        if (treePK == null && orgType != null) {
            treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        }
        FullOrgUnitCollection unitCol = null;
        try {
            unitCol = ctx == null ? PermissionFactory.getRemoteInstance().getAuthorizedOrg(userPK, orgType, (IObjectPK)treePK, permissionItem) : PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrg(userPK, orgType, (IObjectPK)treePK, permissionItem);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return unitCol;
    }

    public static void cachePermission(RequestContext request, ResponseContext response, Context context) {
        OrgType orgType = request.getMainOrgType();
        IObjectPK userPk = request.getUserPK();
        String permissionItem = (String)request.get("_SCMPERMISSIONITEM");
        ObjectUuidPK treePK = null;
        if (orgType != null) {
            treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        }
        if (userPk != null && permissionItem != null) {
            CalculateUtil.getOrgUnitPermissionItem(context, orgType, permissionItem, userPk, treePK);
        }
    }

    public static OrgUnitInfo[] gainAuthMainBizOrgs(RequestContext request, ResponseContext response, Context context) {
        OrgUnitInfo[] mainOrgs = null;
        try {
            OrgType orgType = request.getMainOrgType();
            IObjectPK userPk = request.getUserPK();
            String permissionItem = (String)request.get("_SCMPERMISSIONITEM");
            FullOrgUnitCollection collection = CalculateUtil.getOrgUnitPermissionItem(context, orgType, permissionItem, userPk, null);
            mainOrgs = CalculateUtil.getOrgUnitInfosByType(context, collection, orgType);
            if (mainOrgs == null) {
                mainOrgs = new OrgUnitInfo[]{};
            }
            if (mainOrgs.length > 0) {
                mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, (boolean)true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mainOrgs;
    }

    public static OrgUnitInfo[] getOrgUnitInfosByType(Context ctx, FullOrgUnitCollection orgs, OrgType orgType) {
        OrgUnitInfo[] results = null;
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        if (!orgType.equals((Object)OrgType.Admin)) {
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)true, CompareType.EQUALS));
        }
        view.setFilter(filter);
        try {
            switch (orgType.getValue()) {
                case 0: {
                    IAdminOrgUnit iAdmin = null;
                    iAdmin = ctx != null ? AdminOrgUnitFactory.getLocalInstance((Context)ctx) : AdminOrgUnitFactory.getRemoteInstance();
                    AdminOrgUnitCollection collection = iAdmin.getAdminOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        results = new OrgUnitInfo[collection.size()];
                        for (int i = 0; i < collection.size(); ++i) {
                            results[i] = collection.get(i);
                        }
                    }
                    return results;
                }
                case 1: {
                    ICompanyOrgUnit iCompany = null;
                    iCompany = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
                    CompanyOrgUnitCollection collection = iCompany.getCompanyOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        results = new OrgUnitInfo[collection.size()];
                        for (int i = 0; i < collection.size(); ++i) {
                            results[i] = collection.get(i);
                        }
                    }
                    return results;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    public static OrgUnitCollection getOrgsByRelation(Context ctx, OrgType srcOrgType, OrgType destOrgType, BOSUuid orgPK) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgRelation = null;
        iOrgRelation = ctx != null ? OrgUnitRelationFactory.getLocalInstance((Context)ctx) : OrgUnitRelationFactory.getRemoteInstance();
        int iSrcOrg = srcOrgType.getValue();
        int iDestOrg = destOrgType.getValue();
        switch (iSrcOrg) {
            case 0: 
            case 4: {
                return iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
            case 1: {
                return iOrgRelation.getFromUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
            case 2: {
                if (iDestOrg == 4) {
                    return iOrgRelation.getFromUnit(orgPK.toString(), iSrcOrg, iDestOrg);
                }
                return iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
            case 3: {
                if (iDestOrg == 1) {
                    return iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
                }
                return iOrgRelation.getFromUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
            case 24: {
                return iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
        }
        return null;
    }

    public static FullOrgUnitCollection getAuthMainBizOrgs(RequestContext request, ResponseContext response, Context context) {
        FullOrgUnitCollection collection = null;
        try {
            OrgType orgType = request.getMainOrgType();
            IObjectPK userPk = request.getUserPK();
            String permissionItem = (String)request.get("_SCMPERMISSIONITEM");
            collection = CalculateUtil.getOrgUnitNoTreePermissionItem(context, orgType, permissionItem, userPk, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return collection;
    }

    public static OrgUnitCollection getAuthOrgUnitsWhQueryPk(RequestContext request, ResponseContext response, Context context) {
        OrgUnitCollection collection = null;
        try {
            String permItem;
            IMetaDataPK queryPk = request.getQueryPK();
            OrgType orgType = request.getMainOrgType();
            if (queryPk != null && (permItem = SCMGroupServerUtils.getPermissionItem((Context)context, (IMetaDataPK)queryPk)) != null && orgType != null) {
                OrgUnitCollection orgCollection = SCMGroupServerUtils.getAuthOrgByPermItem((Context)context, (OrgType)orgType, (String)permItem);
                collection = SCMGroupServerUtils.getOrgUnitInfosByType((Context)context, (OrgUnitCollection)orgCollection, (OrgType)orgType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return collection;
    }

    public static FullOrgUnitCollection getOrgUnitNoTreePermissionItem(Context ctx, OrgType orgType, String permissionItem, IObjectPK userPK, ObjectUuidPK treePK) {
        if (userPK == null) {
            return null;
        }
        FullOrgUnitCollection unitCol = null;
        try {
            unitCol = ctx == null ? PermissionFactory.getRemoteInstance().getAuthorizedOrg(userPK, orgType, (IObjectPK)treePK, permissionItem) : PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrg(userPK, orgType, (IObjectPK)treePK, permissionItem);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return unitCol;
    }

    public static boolean getApportVoucherType(Context ctx, String companyOrgUnitID) throws BOSException, EASBizException {
        IParamControl ipc = ctx == null ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(companyOrgUnitID);
        String value = ipc.getParamValue((IObjectPK)pk, EXPAPPORTION_VOUCHER_TYPE_PARAM);
        return "1".equals(value);
    }

    public static String getCalTypeMaterialKey(String strCalType, String materialid, String compnayOrgUnitid, String storageId, String warehouseId) {
        StringBuffer buffer = new StringBuffer();
        if ("0".equals(strCalType)) {
            buffer.append(compnayOrgUnitid);
        } else if ("1".equals(strCalType)) {
            buffer.append(compnayOrgUnitid);
            if (storageId != null) {
                buffer.append("_$$$$_").append(storageId);
            }
        } else {
            buffer.append(compnayOrgUnitid);
            if (storageId != null) {
                buffer.append("_$$$$_").append(storageId);
            }
            if (warehouseId != null) {
                buffer.append("_$$$$_").append(warehouseId);
            }
        }
        buffer.append("_$$$$_").append(materialid);
        return buffer.toString();
    }

    public static boolean isZero(BigDecimal bigNumber) {
        boolean is0 = false;
        if (bigNumber != null) {
            is0 = ZERO.compareTo(bigNumber) == 0;
        }
        return is0;
    }

    public static String getCalParamValue(Context ctx, String companyOrgUnitID, String paramsNumber) throws EASBizException, BOSException {
        IParamControl ipc = null != ctx ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(companyOrgUnitID);
        return ipc.getParamValue((IObjectPK)pk, paramsNumber);
    }

    public static int getDischargeType(Context ctx, String companyOrgUnitID) throws EASBizException, BOSException {
        ObjectUuidPK pk;
        IParamControl ipc = null != ctx ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        String value = ipc.getParamValue((IObjectPK)(pk = new ObjectUuidPK(companyOrgUnitID)), DISCHARGETYPE_PARAM);
        if (value == null || value.equals("")) {
            throw new CalculateException(CalculateException.PARAM_NOT_EXIST);
        }
        return Integer.parseInt(value);
    }

    public static void updatePurInfo(Context ctx, ResultSet rs, int LocalCurrPrecesion, boolean isInpSum, CalculateParams params) throws BOSException {
        String PUR_ENTRY_TABLE = "T_IM_PurInWarehsEntry";
        String TEMP_PurinwarehData = params.getString("T_Temp_PurinwarehData");
        if (rs == null) {
            return;
        }
        HashMap valueMap = new HashMap();
        ArrayList<String> sSQLList = new ArrayList<String>();
        ArrayList<String> idList = new ArrayList<String>();
        try {
            StringBuffer msg = new StringBuffer();
            while (rs.next()) {
                String entryId = rs.getString("FID");
                if (isInpSum) {
                    CalculateUtil.calcFieldValueByUnitActualCost(rs, valueMap, LocalCurrPrecesion);
                    if (valueMap.get("FUnitPurchaseCost") != null && ZERO.compareTo((BigDecimal)valueMap.get("FUnitPurchaseCost")) > 0) {
                        idList.add(entryId);
                        msg.append(ResourceBase.getString((String)RESOURCE_CAL_COMMON, (String)"CanNotUpdateBillForNegetive", (Locale)ctx.getLocale(), (Object[])new String[]{rs.getString("FNumber"), rs.getString("FSEQ")})).append(NEWLINE);
                        continue;
                    }
                } else {
                    CalculateUtil.calcFieldValueByUnitPurchaseCost(rs, valueMap, LocalCurrPrecesion);
                }
                CalculateUtil.createUpdateSQL("T_IM_PurInWarehsEntry", valueMap, sSQLList, entryId);
            }
            if (msg != null && msg.length() > 0) {
                params.setString("ErrorMsgList", msg.toString());
            }
            if (idList != null && idList.size() > 0 && TEMP_PurinwarehData != null) {
                CalculateUtil.recoverHistoryDataSQL("T_IM_PurInWarehsEntry", idList, sSQLList, TEMP_PurinwarehData);
            }
            if (sSQLList != null && sSQLList.size() > 0) {
                DBUtil.execBatchSql(ctx, sSQLList, true);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(null, null, new ResultSet[]{rs});
                throw throwable;
            }
        }
        DBUtil.close(null, null, new ResultSet[]{rs});
    }

    private static void recoverHistoryDataSQL(String tableName, List<String> idList, ArrayList<String> sSQLList, String TEMP_PurinwarehData) {
        if (idList == null || idList.size() == 0) {
            return;
        }
        StringBuffer ids = new StringBuffer();
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            if (ids.length() > 0) {
                ids.append(",");
            }
            ids.append("'").append(idList.get(i)).append("'");
        }
        StringBuffer returnStrSQL = new StringBuffer();
        returnStrSQL.append(" UPDATE ").append(tableName).append(" AS entry ");
        returnStrSQL.append(" SET(FActualCost,FUnitActualCost,FWrittenOffAmount,FUnWriteOffAmount) = ");
        returnStrSQL.append(" (SELECT FActualCost,FUnitActualCost,FWrittenOffAmount,FUnWriteOffAmount ");
        returnStrSQL.append("    FROM ").append(TEMP_PurinwarehData).append(" AS temp ");
        returnStrSQL.append(" \tWHERE temp.Fid in (").append(ids).append(") AND temp.Fid = entry.Fid)");
        returnStrSQL.append(" WHERE entry.fid in (").append(ids).append(")");
        sSQLList.add(returnStrSQL.toString());
    }

    public static void inpSumUpdatePurInfo(Context ctx, String tempTableName, int sumType, PeriodInfo currPeriod, int LocalCurrPrecesion, CalculateParams params) throws BOSException {
        ResultSet rs = CalculateUtil.getPurResultSetByTempTab(ctx, tempTableName, sumType, currPeriod);
        CalculateUtil.updatePurInfo(ctx, rs, LocalCurrPrecesion, true, params);
    }

    public static ResultSet getPurResultSetByIds(Context ctx, List ids) throws BOSException {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Select entry.FID,bill.FExchangeRate,bill.FConvertMode,bill.FIsInTax,bill.FIsPriceInTax,");
        sSQL.append("entry.FActualCost,entry.FUnitActualCost,IsNull(entry.FPurchaseCost, 0) as FPurchaseCost,");
        sSQL.append("IsNull(entry.FUnitPurchaseCost, 0) as FUnitPurchaseCost,IsNull(entry.FPurchaseFee, 0) as FPurchaseFee,IsNull(entry.FMaterialCost, 0) as FMaterialCost,");
        sSQL.append("entry.FUnitMaterialCost,entry.FTaxRate,entry.FQty,entry.FWrittenOffQty,entry.FDiscountRate,currency.FPrecision,material.FPricePrecision ");
        sSQL.append("from T_IM_PurInWarehsBill bill inner join T_IM_PurInWarehsEntry entry on entry.FParentid=bill.FID ");
        sSQL.append("inner join T_BD_Currency currency on currency.FID=bill.FCurrencyID ");
        sSQL.append("inner join T_BD_Material material on material.FID=entry.FMaterialID ");
        sSQL.append("where entry.FID in ({0})");
        StringBuffer idStr = new StringBuffer();
        for (int i = 0; i < ids.size(); ++i) {
            if (i != 0) {
                idStr.append(",");
            }
            idStr.append("'").append(ids.get(i)).append("'");
        }
        String selSql = MessageFormat.format(sSQL.toString(), idStr.toString());
        return DBUtil.executeQuery((Context)ctx, (String)selSql);
    }

    public static ResultSet getPurResultSetByTempTab(Context ctx, String tempTableName, int sumType, PeriodInfo currPeriod) throws BOSException {
        if (tempTableName == null || "".equals(tempTableName) || currPeriod == null) {
            return null;
        }
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Select bill.FNumber,entry.FSeq,entry.FID,bill.FExchangeRate,bill.FConvertMode,bill.FIsInTax,bill.FIsPriceInTax,bill.FNumber,entry.FSeq,");
        sSQL.append("entry.FActualCost,entry.FUnitActualCost,IsNull(entry.FPurchaseCost, 0) as FPurchaseCost,IsNull(entry.FUnitPurchaseCost, 0) as FUnitPurchaseCost,IsNull(entry.FPurchaseFee, 0) as FPurchaseFee,IsNull(entry.FMaterialCost, 0) as FMaterialCost,");
        sSQL.append("entry.FUnitMaterialCost,entry.FTaxRate,entry.FQty,entry.FWrittenOffQty,entry.FDiscountRate,currency.FPrecision,material.FPricePrecision,entry.FLocalPrice,entry.FLocalAmount ");
        sSQL.append("from T_IM_PurInWarehsBill bill, T_IM_PurInWarehsEntry entry, T_BD_Currency currency, T_BD_Material material, ").append(tempTableName).append(" temp ");
        sSQL.append(" where entry.FParentid=bill.FID and currency.FID=bill.FCurrencyID and material.FID=entry.FMaterialID ");
        sSQL.append(" and entry.fid = temp.FEntryID ");
        sSQL.append("and ISNULL(bill.FFiVouchered, 0)=0 and ISNULL(entry.FWrittenOffBaseQty, 0)=0 ");
        sSQL.append("and bill.FYear=").append(currPeriod.getPeriodYear()).append(" and bill.FPeriod=").append(currPeriod.getPeriodNumber());
        sSQL.append(" and entry.FDiscountRate <>100");
        return DBUtil.executeQuery((Context)ctx, (String)sSQL.toString());
    }

    private static void createUpdateSQL(String tableName, HashMap valueMap, List sSQLList, String id) {
        if (id == null || id.length() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        boolean hasField = false;
        Iterator it = valueMap.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry mapentry = it.next();
            if (i != 0) {
                sql.append(",");
            } else {
                ++i;
            }
            if (mapentry.getKey() == null || mapentry.getValue() == null) continue;
            hasField = true;
            if (mapentry.getValue() instanceof BigDecimal) {
                sql.append(mapentry.getKey()).append("=").append(StringUtil.toString((BigDecimal)((BigDecimal)mapentry.getValue())));
                continue;
            }
            sql.append(mapentry.getKey()).append("=").append(mapentry.getValue());
        }
        if (hasField) {
            StringBuffer returnStrSQL = new StringBuffer();
            returnStrSQL.append(" update ").append(tableName);
            returnStrSQL.append(" set ");
            returnStrSQL.append(sql);
            returnStrSQL.append(" where fid = '").append(id).append("'");
            sSQLList.add(returnStrSQL.toString());
        }
    }

    private static void calcFieldValueByUnitPurchaseCost(ResultSet rs, HashMap valueMap, int LocalCurrPrecesion) throws SQLException {
        BigDecimal taxAmount;
        BigDecimal tax;
        BigDecimal amount;
        BigDecimal ONE = new BigDecimal("1");
        BigDecimal ZERO = new BigDecimal("0");
        int convertMode = rs.getInt("FConvertMode");
        int isInTax = rs.getInt("FIsInTax");
        int isPriceInTax = rs.getInt("FIsPriceInTax");
        BigDecimal unitPurchaseCost = rs.getBigDecimal("FUnitPurchaseCost");
        int currPrecision = rs.getInt("FPrecision");
        int pricePrecision = rs.getInt("FPricePrecision");
        BigDecimal exchangeRate = rs.getBigDecimal("FExchangeRate");
        BigDecimal taxRate = rs.getBigDecimal("FTaxRate").divide(new BigDecimal("100"), 8, 4);
        BigDecimal discountRate = rs.getBigDecimal("FDiscountRate").divide(new BigDecimal("100"), 8, 4);
        BigDecimal qty = rs.getBigDecimal("FQty");
        BigDecimal price = convertMode == 0 ? unitPurchaseCost.divide(exchangeRate, pricePrecision, 4) : unitPurchaseCost.multiply(exchangeRate).setScale(pricePrecision, 4);
        valueMap.put("FPrice", price);
        BigDecimal taxPrice = isPriceInTax == 0 ? price.multiply(taxRate.add(ONE)).setScale(pricePrecision, 4) : price.divide(ONE.subtract(taxRate), pricePrecision, 4);
        valueMap.put("FTaxPrice", taxPrice);
        BigDecimal discountAmount = taxPrice.multiply(qty).multiply(discountRate).setScale(currPrecision, 4);
        valueMap.put("FDiscountAmount", discountAmount);
        if (isInTax == 0) {
            amount = price.multiply(qty).multiply(ONE.subtract(discountRate)).setScale(currPrecision, 4);
            tax = amount.multiply(taxRate).setScale(currPrecision, 4);
            taxAmount = amount.add(tax);
        } else {
            taxAmount = taxPrice.multiply(qty).setScale(currPrecision, 4).subtract(discountAmount);
            tax = taxAmount.divide(ONE.add(taxRate), currPrecision, 4).multiply(taxRate).setScale(currPrecision, 4);
            amount = taxAmount.subtract(tax);
        }
        valueMap.put("FAmount", amount);
        valueMap.put("FTax", tax);
        valueMap.put("FTaxAmount", taxAmount);
        BigDecimal actualPrice = amount.divide(qty, pricePrecision, 4);
        if (discountRate.compareTo(ZERO) == 0) {
            actualPrice = price;
        }
        valueMap.put("FActualPrice", actualPrice);
        BigDecimal localTax = convertMode == 0 ? tax.multiply(exchangeRate).setScale(LocalCurrPrecesion, 4) : tax.divide(exchangeRate, LocalCurrPrecesion, 4);
        valueMap.put("FLocalTax", localTax);
        BigDecimal localTaxAmount = convertMode == 0 ? taxAmount.multiply(exchangeRate).setScale(LocalCurrPrecesion, 4) : taxAmount.divide(exchangeRate, LocalCurrPrecesion, 4);
        valueMap.put("FLocalTaxAmount", localTaxAmount);
        BigDecimal actualCost = rs.getBigDecimal("FPurchaseCost").add(rs.getBigDecimal("FPurchaseFee")).add(rs.getBigDecimal("FMaterialCost"));
        valueMap.put("FActualCost", actualCost);
        BigDecimal unitActualCost = actualCost.divide(qty, pricePrecision, 4);
        valueMap.put("FUnitActualCost", unitActualCost);
    }

    private static void calcFieldValueByUnitActualCost(ResultSet rs, HashMap valueMap, int LocalCurrPrecesion) throws SQLException {
        BigDecimal localTaxAmount;
        BigDecimal taxAmount;
        BigDecimal tax;
        BigDecimal localTax;
        BigDecimal ZERO;
        BigDecimal ONE = new BigDecimal("1");
        BigDecimal localPrice = ZERO = new BigDecimal("0");
        BigDecimal localAmount = ZERO;
        int convertMode = rs.getInt("FConvertMode");
        int isPriceInTax = 1 - rs.getInt("FIsPriceInTax");
        BigDecimal unitActualCost = rs.getBigDecimal("FUnitActualCost");
        int currPrecision = rs.getInt("FPrecision");
        int pricePrecision = rs.getInt("FPricePrecision");
        BigDecimal exchangeRate = rs.getBigDecimal("FExchangeRate");
        BigDecimal taxRate = rs.getBigDecimal("FTaxRate").divide(new BigDecimal("100"), 8, 4);
        BigDecimal discountRate = rs.getBigDecimal("FDiscountRate").divide(new BigDecimal("100"), 8, 4);
        BigDecimal qty = rs.getBigDecimal("FQty");
        BigDecimal writeOffQty = rs.getBigDecimal("FWrittenOffQty");
        valueMap.put("FUnitActualCost", unitActualCost);
        BigDecimal actualCost = rs.getBigDecimal("FActualCost");
        valueMap.put("FActualCost", actualCost);
        BigDecimal purchaseCost = actualCost.subtract(rs.getBigDecimal("FPurchaseFee")).subtract(rs.getBigDecimal("FMaterialCost"));
        valueMap.put("FPurchaseCost", purchaseCost);
        BigDecimal unitPurchaseCost = purchaseCost.compareTo(actualCost) == 0 ? unitActualCost : purchaseCost.divide(qty, pricePrecision, 4);
        if (qty.compareTo(BigDecimal.ZERO) < 0 && purchaseCost.compareTo(BigDecimal.ZERO) > 0 || qty.compareTo(BigDecimal.ZERO) > 0 && purchaseCost.compareTo(BigDecimal.ZERO) < 0) {
            unitPurchaseCost = new BigDecimal("-1");
        }
        valueMap.put("FUnitPurchaseCost", unitPurchaseCost);
        BigDecimal price = unitPurchaseCost.divide(ONE.subtract(discountRate), 8, 4);
        price = convertMode == 0 ? price.divide(exchangeRate, pricePrecision, 4) : price.multiply(exchangeRate).setScale(pricePrecision, 4);
        valueMap.put("FPrice", price);
        localPrice = price.multiply(exchangeRate).setScale(pricePrecision, 4);
        valueMap.put("FLocalPrice", localPrice);
        localAmount = localPrice.multiply(qty).setScale(pricePrecision, 4);
        valueMap.put("FLocalAmount", localAmount);
        BigDecimal actualPrice = convertMode == 0 ? unitPurchaseCost.divide(exchangeRate, pricePrecision, 4) : unitPurchaseCost.multiply(exchangeRate).setScale(pricePrecision, 4);
        if (discountRate.compareTo(ZERO) == 0) {
            actualPrice = price;
        }
        valueMap.put("FActualPrice", actualPrice);
        BigDecimal taxPrice = isPriceInTax == 0 ? price.multiply(ONE.add(taxRate)).setScale(pricePrecision, 4) : price.divide(ONE.subtract(taxRate), pricePrecision, 4);
        valueMap.put("FTaxPrice", taxPrice);
        BigDecimal actualTaxPrice = isPriceInTax == 0 ? actualPrice.multiply(ONE.add(taxRate)).setScale(pricePrecision, 4) : actualPrice.divide(ONE.subtract(taxRate), pricePrecision, 4);
        valueMap.put("FActualTaxPrice", actualTaxPrice);
        BigDecimal discountAmount = taxPrice.multiply(qty).multiply(discountRate).setScale(currPrecision, 4);
        valueMap.put("FDiscountAmount", discountAmount);
        BigDecimal amount = convertMode == 0 ? purchaseCost.divide(exchangeRate, currPrecision, 4) : purchaseCost.multiply(exchangeRate).setScale(currPrecision, 4);
        valueMap.put("FAmount", amount);
        if (isPriceInTax == 0) {
            localTax = purchaseCost.multiply(taxRate).setScale(currPrecision, 4);
            tax = convertMode == 0 ? localTax.divide(exchangeRate, currPrecision, 4) : localTax.multiply(exchangeRate).setScale(currPrecision, 4);
            taxAmount = amount.add(tax);
            localTaxAmount = purchaseCost.add(localTax);
        } else {
            localTaxAmount = purchaseCost.divide(ONE.subtract(taxRate), LocalCurrPrecesion, 4);
            localTax = localTaxAmount.subtract(purchaseCost);
            tax = convertMode == 0 ? localTax.divide(exchangeRate, currPrecision, 4) : localTax.multiply(exchangeRate).setScale(currPrecision, 4);
            taxAmount = convertMode == 0 ? localTaxAmount.divide(exchangeRate, currPrecision, 4) : localTaxAmount.multiply(exchangeRate).setScale(currPrecision, 4);
        }
        valueMap.put("FLocalTax", localTax);
        valueMap.put("FLocalTaxAmount", localTaxAmount);
        valueMap.put("FTax", tax);
        valueMap.put("FTaxAmount", taxAmount);
        BigDecimal writeOffAmount = unitPurchaseCost.multiply(writeOffQty).setScale(LocalCurrPrecesion, 4);
        valueMap.put("FWrittenOffAmount", writeOffAmount);
        BigDecimal unWriteOffAmount = purchaseCost.subtract(writeOffAmount);
        valueMap.put("FUnWriteOffAmount", unWriteOffAmount);
    }

    public static String getUpdateTaxAmount(int istax, int Precision, String fid) {
        StringBuffer sb = new StringBuffer();
        sb.append(" update T_IM_PurInWarehsEntry AS T set (");
        sb.append("\n  funitActualCost,fpurchaseCost,funitpurchaseCost,");
        sb.append("\n  fprice,ftaxprice,ftaxamount,");
        sb.append("\n  ftax,famount,flocaltaxamount,flocaltax,funwriteoffamount)=");
        sb.append("\n  (select ROUND(TO_DECIMAL(t2.FActualCost / t2.fqty,17,4)," + Precision + "),");
        sb.append("\n  (t2.FActualCost-t2.fpurchaseFee),");
        sb.append("\n  ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) / t2.fqty,17,4)," + Precision + "),");
        if (istax == 1) {
            sb.append(CalculateUtil.getPrice(Precision, 1));
        }
        if (istax == 2) {
            sb.append(CalculateUtil.getPrice(Precision, 2));
        }
        if (istax == 3) {
            sb.append(CalculateUtil.getPrice(Precision, 3));
        }
        if (istax == 1) {
            sb.append(CalculateUtil.getTaxPrice(Precision, 1));
        }
        if (istax == 2) {
            sb.append(CalculateUtil.getTaxPrice(Precision, 2));
        }
        if (istax == 3) {
            sb.append(CalculateUtil.getTaxPrice(Precision, 3));
        }
        if (istax == 1) {
            sb.append(CalculateUtil.getTaxAmount(Precision, 1));
        }
        if (istax == 2) {
            sb.append(CalculateUtil.getTaxAmount(Precision, 2));
        }
        if (istax == 3) {
            sb.append(CalculateUtil.getTaxAmount(Precision, 3));
        }
        if (istax == 1) {
            sb.append(CalculateUtil.getTax(Precision, 1));
        }
        if (istax == 2) {
            sb.append(CalculateUtil.getTax(Precision, 2));
        }
        if (istax == 3) {
            sb.append(CalculateUtil.getTax(Precision, 3));
        }
        if (istax == 1) {
            sb.append(CalculateUtil.getAmount(Precision, 1));
        }
        if (istax == 2) {
            sb.append(CalculateUtil.getAmount(Precision, 2));
        }
        if (istax == 3) {
            sb.append(CalculateUtil.getAmount(Precision, 3));
        }
        if (istax == 1) {
            sb.append(CalculateUtil.getLocalTaxAmount(Precision, 1));
        }
        if (istax == 2) {
            sb.append(CalculateUtil.getLocalTaxAmount(Precision, 2));
        }
        if (istax == 3) {
            sb.append(CalculateUtil.getLocalTaxAmount(Precision, 3));
        }
        if (istax == 1) {
            sb.append(CalculateUtil.getLocaltax(Precision, 1));
        }
        if (istax == 2) {
            sb.append(CalculateUtil.getLocaltax(Precision, 2));
        }
        if (istax == 3) {
            sb.append(CalculateUtil.getLocaltax(Precision, 3));
        }
        if (istax == 1) {
            sb.append(CalculateUtil.getUnWriteOffAmount(Precision, 1));
        }
        if (istax == 2) {
            sb.append(CalculateUtil.getUnWriteOffAmount(Precision, 2));
        }
        if (istax == 3) {
            sb.append(CalculateUtil.getUnWriteOffAmount(Precision, 3));
        }
        sb.append("\n FROM T_IM_PurInWarehsbill T1 INNER JOIN T_IM_PurInWarehsEntry T2 ");
        sb.append("\n ON T1.FID = T2.FPARENTID ");
        sb.append(" where  t2.fid='" + fid + "'");
        if (istax == 1) {
            sb.append("\n  and t1.fisInTax =1 AND t1.fisPriceinTax = 1 ");
        } else if (istax == 2) {
            sb.append("\n  and T1.fisInTax =0 AND t1.fisPriceinTax = 1 ");
        } else {
            sb.append("\n  and t1.fisInTax =1 AND t1.fisPriceinTax = 0  ");
        }
        sb.append(" ) where T.fid='").append(fid).append("'");
        return sb.toString();
    }

    public static String getPrice(int Precision, int Istax) {
        StringBuffer sb = new StringBuffer();
        if (Istax == 1) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then ROUND(TO_DECIMAL(((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) / t2.fqty,17,4)," + Precision + ")))/(t1.fexchangerate),17,4), " + Precision + " )");
            sb.append("\n  else ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) / t2.fqty,17,4)," + Precision + ")) *t1.fexchangerate,17,4), " + Precision + " )");
            sb.append("\n  end , ");
        }
        if (Istax == 2) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee)/t1.fexchangerate,17,4)," + Precision + "))/(t2.fqty),17,4)," + Precision + ")");
            sb.append("\n  else ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee)*t1.fexchangerate,17,4), " + Precision + ")) /(t2.fqty),17,4), " + Precision + ")");
            sb.append("\n  end , ");
        }
        if (Istax == 3) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) /t1.fexchangerate,17,4), " + Precision + ")) / (t2.fqty),17,4), " + Precision + ")");
            sb.append("\n  else ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) *t1.fexchangerate,17,4), " + Precision + ")) /(t2.fqty),17,4), " + Precision + ")");
            sb.append("\n  end , ");
        }
        return sb.toString();
    }

    public static String getTaxPrice(int Precision, int Istax) {
        StringBuffer sb = new StringBuffer();
        if (Istax == 1 || Istax == 2) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) / t2.fqty,17,4)," + Precision + "))/t1.fexchangerate,17,4), " + Precision + " ))*(1+(t2.ftaxrate/100)),17,4), " + Precision + ")");
            sb.append("\n  else  ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) / t2.fqty,17,4)," + Precision + ")) *t1.fexchangerate,17,4), " + Precision + " )) * (1+(t2.ftaxrate/100)),17,4), " + Precision + ") ");
            sb.append("\n  end, ");
        }
        if (Istax == 3) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then ROUND(TO_DECIMAL((( ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) /t1.fexchangerate,17,4), " + Precision + ")) / (t2.fqty),21,8), " + Precision + ") )*100)/(100-(t2.ftaxrate)),17,4)," + Precision + ")");
            sb.append("\n  else ROUND(TO_DECIMAL(((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) *t1.fexchangerate,17,4), " + Precision + ")) /(t2.fqty),21,8), " + Precision + "))*100) /(100-(t2.ftaxrate)),17,4)," + Precision + ")");
            sb.append("\n  end, ");
        }
        return sb.toString();
    }

    public static String getTaxAmount(int Precision, int Istax) {
        StringBuffer sb = new StringBuffer();
        if (Istax == 1) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then ROUND(TO_DECIMAL((ROUND(TO_DECIMAL( (ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) / t2.fqty,17,4)," + Precision + ")) /t1.fexchangerate,17,4), " + Precision + ")) * (1+(t2.ftaxrate/100)),17,4), " + Precision + ")) * t2.fqty,17,4), " + Precision + ") ");
            sb.append("\n  else ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) / t2.fqty,17,4)," + Precision + ")) *t1.fexchangerate,17,4), " + Precision + "))*(1+(t2.ftaxrate/100)),17,4), " + Precision + ")) * t2.fqty,17,4), " + Precision + ")");
            sb.append("\n  end ,  ");
        }
        if (Istax == 2) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then  (ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) /t1.fexchangerate,17,4), " + Precision + "))+(ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) /t1.fexchangerate,17,4), " + Precision + ")) *(t2.ftaxrate/100),17,4), " + Precision + "))");
            sb.append("\n  else (ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee)*t1.fexchangerate,17,4), " + Precision + "))+(ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) *t1.fexchangerate,17,4), " + Precision + "))* (t2.ftaxrate/100),17,4), " + Precision + "))");
            sb.append("\n  end , ");
        }
        if (Istax == 3) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then ROUND(TO_DECIMAL((t2.fqty) * (ROUND(TO_DECIMAL((( ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) /t1.fexchangerate,17,4), " + Precision + ")) / (t2.fqty),21,8), " + Precision + ") )*100)/(100-(t2.ftaxrate)),17,4)," + Precision + ") ),17,4), " + Precision + ") ");
            sb.append("\n  else ROUND(TO_DECIMAL((t2.fqty)*( ROUND(TO_DECIMAL(((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) *t1.fexchangerate,17,4), " + Precision + ")) /(t2.fqty),21,8), " + Precision + "))*100) /(100-(t2.ftaxrate)),17,4)," + Precision + ") ),17,4), " + Precision + ")");
            sb.append("\n  end , ");
        }
        return sb.toString();
    }

    public static String getTax(int Precision, int Istax) {
        StringBuffer sb = new StringBuffer();
        if (Istax == 1) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then ROUND(TO_DECIMAL(((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL( (ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) / t2.fqty,17,4)," + Precision + ")) /t1.fexchangerate,17,4), " + Precision + ")) * (1+(t2.ftaxrate/100)),17,4), " + Precision + ")) * t2.fqty,17,4), " + Precision + "))*t2.ftaxrate) /(100+t2.ftaxrate),17,4)," + Precision + ")");
            sb.append("\n  else ROUND(TO_DECIMAL((( ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) / t2.fqty,17,4)," + Precision + ")) *t1.fexchangerate,17,4), " + Precision + "))*(1+(t2.ftaxrate/100)),17,4), " + Precision + ")) * t2.fqty,17,4), " + Precision + ") )*t2.ftaxrate) /(100+t2.ftaxrate),17,4)," + Precision + ") ");
            sb.append("\n  end ,  ");
        }
        if (Istax == 2) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) /t1.fexchangerate,17,4), " + Precision + ")) *(t2.ftaxrate/100),17,4), " + Precision + ")");
            sb.append("\n  else ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee)*t1.fexchangerate,17,4), " + Precision + ")) *(t2.ftaxrate/100),17,4), " + Precision + ")");
            sb.append("\n  end , ");
        }
        if (Istax == 3) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then (ROUND(TO_DECIMAL((t2.fqty) * (ROUND(TO_DECIMAL((( ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) /t1.fexchangerate,17,4), " + Precision + ")) / (t2.fqty),21,8), " + Precision + ") )*100)/(100-(t2.ftaxrate)),17,4)," + Precision + ") ),17,4), " + Precision + ")  )-(ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) /t1.fexchangerate,17,4), " + Precision + "))");
            sb.append("\n  else ( ROUND(TO_DECIMAL((t2.fqty)*( ROUND(TO_DECIMAL(((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) *t1.fexchangerate,17,4), " + Precision + ")) /(t2.fqty),21,8), " + Precision + "))*100) /(100-(t2.ftaxrate)),17,4)," + Precision + ") ),17,4), " + Precision + ") )-(ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) * t1.fexchangerate,17,4), " + Precision + "))");
            sb.append("\n  end , ");
        }
        return sb.toString();
    }

    public static String getAmount(int Precision, int Istax) {
        StringBuffer sb = new StringBuffer();
        if (Istax == 1) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then (ROUND(TO_DECIMAL((ROUND(TO_DECIMAL( (ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) / t2.fqty,17,4)," + Precision + ")) /t1.fexchangerate,17,4), " + Precision + ")) * (1+(t2.ftaxrate/100)),17,4), " + Precision + ")) * t2.fqty,17,4), " + Precision + "))-(ROUND(TO_DECIMAL(((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL( (ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) / t2.fqty,17,4)," + Precision + ")) /t1.fexchangerate,17,4), " + Precision + ")) * (1+(t2.ftaxrate/100)),17,4), " + Precision + ")) * t2.fqty,17,4), " + Precision + "))*t2.ftaxrate) /(100+t2.ftaxrate),17,4)," + Precision + ")) ");
            sb.append("\n  else (ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) / t2.fqty,17,4)," + Precision + ")) *t1.fexchangerate,17,4), " + Precision + "))*(1+(t2.ftaxrate/100)),17,4), " + Precision + ")) * t2.fqty,17,4), " + Precision + "))-(ROUND(TO_DECIMAL((( ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) / t2.fqty,17,4)," + Precision + ")) *t1.fexchangerate,17,4), " + Precision + "))*(1+(t2.ftaxrate/100)),17,4), " + Precision + ")) * t2.fqty,17,4), " + Precision + ") )*t2.ftaxrate) /(100+t2.ftaxrate),17,4)," + Precision + "))");
            sb.append("\n  end ,  ");
        }
        if (Istax == 2) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) /t1.fexchangerate,17,4), " + Precision + ")");
            sb.append("\n  else ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) * t1.fexchangerate,17,4), " + Precision + ")");
            sb.append("\n  end , ");
        }
        if (Istax == 3) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) /t1.fexchangerate,17,4), " + Precision + ")");
            sb.append("\n  else ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) * t1.fexchangerate,17,4), " + Precision + ")");
            sb.append("\n  end , ");
        }
        return sb.toString();
    }

    public static String getLocalTaxAmount(int Precision, int Istax) {
        StringBuffer sb = new StringBuffer();
        if (Istax == 1) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL( (ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) / t2.fqty,17,4)," + Precision + ")) /t1.fexchangerate,17,4), " + Precision + ")) * (1+(t2.ftaxrate/100)),17,4), " + Precision + ")) * t2.fqty,17,4), " + Precision + ")) * t1.fexchangerate,17,4)," + Precision + ")");
            sb.append("\n  else ROUND(TO_DECIMAL(( ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) / t2.fqty,17,4)," + Precision + ")) *t1.fexchangerate,17,4), " + Precision + "))*(1+(t2.ftaxrate/100)),17,4), " + Precision + ")) * t2.fqty,17,4), " + Precision + ") ) /t1.fexchangerate,17,4), " + Precision + ")");
            sb.append("\n  end ,  ");
        }
        if (Istax == 2) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then ((t2.FActualCost-t2.fpurchaseFee))+(ROUND(TO_DECIMAL(((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) /t1.fexchangerate,17,4), " + Precision + "))*(t2.ftaxrate/100)) *(t1.fexchangerate),17,4), " + Precision + "))");
            sb.append("\n  else ((t2.FActualCost-t2.fpurchaseFee))+(ROUND(TO_DECIMAL(((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) * t1.fexchangerate,17,4), " + Precision + "))*(t2.ftaxrate/100)) /(t1.fexchangerate),17,4), " + Precision + "))");
            sb.append("\n  end , ");
        }
        if (Istax == 3) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then ROUND(TO_DECIMAL(( ROUND(TO_DECIMAL((t2.fqty) * (ROUND(TO_DECIMAL((( ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) /t1.fexchangerate,17,4), " + Precision + ")) / (t2.fqty),21,8), " + Precision + ") )*100)/(100-(t2.ftaxrate)),17,4)," + Precision + ") ),17,4), " + Precision + ")  ) *(t1.fexchangerate ),17,4)," + Precision + ") ");
            sb.append("\n  else ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.fqty)*( ROUND(TO_DECIMAL(((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) *t1.fexchangerate,17,4), " + Precision + ")) /(t2.fqty),21,8), " + Precision + "))*100) /(100-(t2.ftaxrate)),17,4)," + Precision + ") ),17,4), " + Precision + ")) /(t1.fexchangerate),17,4)," + Precision + ") ");
            sb.append("\n  end , ");
        }
        return sb.toString();
    }

    private static String getLocaltax(int Precision, int Istax) {
        StringBuffer sb = new StringBuffer();
        if (Istax == 1) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then ROUND(TO_DECIMAL(((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL( (ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) / t2.fqty,17,4)," + Precision + ")) /t1.fexchangerate,17,4), " + Precision + ")) * (1+(t2.ftaxrate/100)),17,4), " + Precision + ")) * t2.fqty,17,4), " + Precision + "))*(t2.ftaxrate*t1.fexchangerate)) / (100+t2.ftaxrate),17,4)," + Precision + ") ");
            sb.append("\n  else ROUND(TO_DECIMAL(((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) / t2.fqty,17,4)," + Precision + ")) *t1.fexchangerate,17,4), " + Precision + "))*(1+(t2.ftaxrate/100)),17,4), " + Precision + ")) * t2.fqty,21,8), " + Precision + "))*(t2.ftaxrate)) / ((100+t2.ftaxrate)*t1.fexchangerate),17,4)," + Precision + ")  ");
            sb.append("\n  end ,  ");
        }
        if (Istax == 2) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then ROUND(TO_DECIMAL(((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) /t1.fexchangerate,17,4), " + Precision + "))*((t2.ftaxrate/100))) *(t1.fexchangerate),17,4), " + Precision + ")");
            sb.append("\n  else ROUND(TO_DECIMAL(((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) * t1.fexchangerate,17,4), " + Precision + "))*(t2.ftaxrate/100)) /(t1.fexchangerate),17,4), " + Precision + ")");
            sb.append("\n  end , ");
        }
        if (Istax == 3) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then ROUND(TO_DECIMAL(((t2.FActualCost-t2.fpurchaseFee)*t2.ftaxrate) /(100-t2.ftaxrate),17,4)," + Precision + ") ");
            sb.append("\n  else ROUND(TO_DECIMAL(( (ROUND(TO_DECIMAL((t2.fqty)*( ROUND(TO_DECIMAL(((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) *t1.fexchangerate,17,4), " + Precision + ")) /(t2.fqty),21,8), " + Precision + "))*100) /(100-(t2.ftaxrate)),17,4)," + Precision + ") ),17,4), " + Precision + ")) *(t2.ftaxrate/100)) /(t1.fexchangerate),17,4), " + Precision + ") ");
            sb.append("\n  end , ");
        }
        return sb.toString();
    }

    public static String getUnWriteOffAmount(int Precision, int Istax) {
        StringBuffer sb = new StringBuffer();
        if (Istax == 1) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then ((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL( (ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) / t2.fqty,17,4)," + Precision + ")) /t1.fexchangerate,17,4), " + Precision + ")) * (1+(t2.ftaxrate/100)),17,4), " + Precision + ")) * t2.fqty,17,4), " + Precision + "))-(ROUND(TO_DECIMAL(((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL( (ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) / t2.fqty,17,4)," + Precision + ")) /t1.fexchangerate,17,4), " + Precision + ")) * (1+(t2.ftaxrate/100)),17,4), " + Precision + ")) * t2.fqty,17,4), " + Precision + "))*t2.ftaxrate) /(100+t2.ftaxrate),17,4)," + Precision + ")))-t2.fwrittenoffamount ");
            sb.append("\n  else (ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) / t2.fqty,17,4)," + Precision + ")) *t1.fexchangerate,17,4), " + Precision + "))*(1+(t2.ftaxrate/100)),17,4), " + Precision + ")) * t2.fqty,17,4), " + Precision + "))-(ROUND(TO_DECIMAL((( ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) / t2.fqty,17,4)," + Precision + ")) *t1.fexchangerate,17,4), " + Precision + "))*(1+(t2.ftaxrate/100)),17,4), " + Precision + ")) * t2.fqty,17,4), " + Precision + ") )*t2.ftaxrate) /(100+t2.ftaxrate),17,4)," + Precision + ")) - t2.fwrittenoffamount");
            sb.append("\n  end  ");
        }
        if (Istax == 2) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then (ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) /t1.fexchangerate,17,4), " + Precision + ")) - t2.fwrittenoffamount");
            sb.append("\n  else (ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) * t1.fexchangerate,17,4), " + Precision + ")) - t2.fwrittenoffamount");
            sb.append("\n  end  ");
        }
        if (Istax == 3) {
            sb.append("\n  case t1.fconvertMode");
            sb.append("\n  when 0 then (ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) /t1.fexchangerate,17,4), " + Precision + ")) - t2.fwrittenoffamount");
            sb.append("\n  else (ROUND(TO_DECIMAL((t2.FActualCost-t2.fpurchaseFee) * t1.fexchangerate,17,4), " + Precision + ")) - t2.fwrittenoffamount");
            sb.append("\n  end  ");
        }
        return sb.toString();
    }

    public static boolean getCostCalculateParam(Context ctx, String companyOrgUnitID, String paramNumber) throws EASBizException, BOSException {
        IParamControl ipc = null != ctx ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(companyOrgUnitID);
        String calType = ipc.getParamValue((IObjectPK)pk, paramNumber);
        return "1".equalsIgnoreCase(calType) || "true".equalsIgnoreCase(calType);
    }

    public static String getCalResource(String key) {
        return EASResource.getString((String)RESOURCE_CAL_COMMON, (String)key);
    }

    public static String getCalServerResource(Context ctx, String key) {
        return ResourceBase.getString((String)RESOURCE_CAL_COMMON, (String)key, (Locale)ctx.getLocale());
    }

    public static boolean isDevolve(String bizTypeNumber) {
        String DEVOLVE_BIZ_TYPE_NUMBER = "130, 131, 140, 141";
        if (bizTypeNumber == null || bizTypeNumber.length() == 0) {
            return false;
        }
        return "130, 131, 140, 141".indexOf(bizTypeNumber) > -1;
    }

    public static boolean isSubContractBill(Map uiContext) {
        boolean isSubContractBill = false;
        if (uiContext != null && ("isSubContract".equals(uiContext.get("UIClassParam")) || "com.kingdee.eas.scm.cal.config.Ap2PiDevApportionConfig".equals(uiContext.get("UIClassParam")))) {
            isSubContractBill = true;
        } else {
            Map btpContext = (Map)uiContext.get("BTPNAVCTX");
            if (btpContext != null) {
                isSubContractBill = "isSubContract".equals(btpContext.get("UIClassParam")) || Boolean.TRUE.equals(btpContext.get("isSubContract"));
            }
        }
        return isSubContractBill;
    }

    public static boolean isAuthoriedForOrg(String companyOrgUnit, String userId, String permission) throws EASBizException, BOSException {
        if (null != companyOrgUnit && userId != null && permission != null) {
            FullOrgUnitCollection result = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectUuidPK(userId), (OrgType)OrgType.Company, (String)permission);
            for (int i = 0; null != result && i < result.size(); ++i) {
                if (!result.get(i).getId().toString().equals(companyOrgUnit)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getSqlInString(Set set) {
        Iterator it = set.iterator();
        String insql = new String();
        if (set.isEmpty()) {
            return "''";
        }
        while (it.hasNext()) {
            insql = insql + "'" + it.next().toString() + "',";
        }
        insql = insql.substring(0, insql.length() - 1);
        return insql;
    }

    public static String getSqlInString(String[] ids) {
        StringBuffer bf = new StringBuffer();
        bf.append("(");
        int length = ids.length;
        for (int i = 0; i < length; ++i) {
            bf.append("'").append(ids[i]).append("'");
            if (i == length - 1) continue;
            bf.append(",");
        }
        bf.append(")");
        return bf.toString();
    }

    public static String getSqlIn(Set set) {
        if (set != null && set.size() > 0) {
            Iterator it = set.iterator();
            StringBuffer insql = new StringBuffer();
            insql.append("(");
            int i = 0;
            while (it.hasNext()) {
                CoreBaseInfo info = (CoreBaseInfo)it.next();
                if (i > 0) {
                    insql.append(",");
                }
                insql.append("'").append(info.getId().toString()).append("'");
                ++i;
            }
            insql.append(")");
            return insql.toString();
        }
        return null;
    }

    public static String getSqlInString(List listIds) {
        if (listIds != null && listIds.size() > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append("(");
            int length = listIds.size();
            for (int i = 0; i < length; ++i) {
                builder.append("'").append(listIds.get(i)).append("'");
                if (i == length - 1) continue;
                builder.append(",");
            }
            builder.append(")");
            return builder.toString();
        }
        return null;
    }

    public static boolean costAdjustIsCanUnAudit(CostAdjuestCreateTypeEnum creteType) {
        boolean flag = false;
        if (createTypeSet.size() == 0) {
            createTypeSet.add(CostAdjuestCreateTypeEnum.USERINPUT);
            createTypeSet.add(CostAdjuestCreateTypeEnum.APPORTION);
            createTypeSet.add(CostAdjuestCreateTypeEnum.ISSUE_COSTADJUST);
            createTypeSet.add(CostAdjuestCreateTypeEnum.ExcepAdjZero);
            createTypeSet.add(CostAdjuestCreateTypeEnum.ExpBalanceAjdust);
            createTypeSet.add(CostAdjuestCreateTypeEnum.MANUALIMPORT);
            createTypeSet.add(CostAdjuestCreateTypeEnum.PeriodBeginExpBalanceAjdust);
            createTypeSet.add(CostAdjuestCreateTypeEnum.PeriodEndExpBalanceAjdust);
        }
        if (creteType != null && createTypeSet.contains((Object)creteType)) {
            flag = true;
        }
        return flag;
    }

    public static String getObjArrayNumber(Object[] obj) {
        StringBuffer number = new StringBuffer();
        for (int i = 0; i < obj.length; ++i) {
            if (i != 0) {
                number.append(",");
            }
            number.append(((IObjectValue)obj[i]).get("number"));
        }
        return number.toString();
    }

    public static String getObjArrayNumberWithQuote(Object[] obj) {
        StringBuffer number = new StringBuffer();
        number.append("'");
        for (int i = 0; i < obj.length; ++i) {
            if (i != 0) {
                number.append("','");
            }
            number.append(((IObjectValue)obj[i]).get("number"));
        }
        number.append("'");
        return number.toString();
    }

    public static PeriodInfo getPeriodByDate(Context ctx, Date date, String periodType) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("beginDate", (Object)date, CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("endDate", (Object)date, CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)periodType));
        viewInfo.setFilter(filterInfo);
        PeriodCollection periodCollection = ctx == null ? PeriodFactory.getRemoteInstance().getPeriodCollection(viewInfo) : PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(viewInfo);
        if (periodCollection.size() > 0) {
            return periodCollection.get(0);
        }
        return null;
    }

    public static class AccountPeriodInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public Vector periods;
        public PeriodInfo startPeriod;
        public PeriodInfo curPeriod;
    }
}

