/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.util.BizOrgEnum;
import com.kingdee.eas.framework.util.DateEnum;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.im.dt.util.DtUtils;
import com.kingdee.eas.scm.sd.channel.NetOrderBillFactory;
import com.kingdee.eas.scm.sd.channel.client.AbstractNetOrderBillListUI;
import com.kingdee.eas.scm.sd.channel.client.NetOrderFilterUI;
import com.kingdee.eas.scm.sd.sale.ISaleOrder;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class NetOrderBillListUI
extends AbstractNetOrderBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(NetOrderBillListUI.class);
    private static final long serialVersionUID = -8541707357892523715L;
    CommonQueryDialog commonQueryDialog = null;
    NetOrderFilterUI filterUI = null;
    ISCMBillBase iBiz = null;
    OrgUnitCollection authorizedMainOrgs = null;
    Set listSaleOrg = null;
    private static String[] NUMBERTAB = new String[]{"exchangeRate", "entries.qty", "entries.price", "entries.amount", "entries.weight", "entries.approveQty", "entries.approveAmount"};
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        QuickFilteringSupportItems qfsi = this.getQuickFilteringSupport();
        if (qfsi != null) {
            qfsi.getSystemSolutionItem().getDefaultFilter().add(this.getPropertyOfBizOrg(OrgType.Storage), CompareType.EQUALS, (Object)BizOrgEnum.DEFAULTMAINORG).add(this.getPropertyOfBizDate(), CompareType.IS, (Object)DateEnum.RECENTONEMONTH);
        }
        SCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])NUMBERTAB, (String)"%{0.##########}f");
        this.setQtyColumnsAlign();
        this.initUI();
    }

    protected String[] getFormattedDateColumns() {
        return new String[]{"bizdate"};
    }

    protected String[] getQtyColumns() throws Exception {
        return NUMBERTAB;
    }

    public KDPanel getConditionPanel() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new NetOrderFilterUI();
        }
        return this.filterUI;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new NetOrderFilterUI();
        }
        return this.filterUI;
    }

    public void refreshList() throws Exception {
        super.refreshList();
        this.initUI();
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (!this.isDoRequestData() || this.mainQuery == null) {
            return;
        }
        if (this.isHasQyeryPK() && this.tblMain.getDataRequestManager().getDataRequestMode() == 1) {
            this.tblMain_doRequestRowSetForHasQueryPK(e);
        } else {
            this.tblMain_doRequestRowSetForNoQueryPK(e);
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (OrgType.Sale.equals((Object)orgType)) {
            return "saleOrgUnit.id";
        }
        if (OrgType.Storage.equals((Object)orgType)) {
            return "storageOrgUnit.id";
        }
        return null;
    }

    private void initUI() {
        this.btnUnAudit.setVisible(false);
        this.btnUnAudit.setEnabled(false);
        this.btnAuditResult.setVisible(false);
        this.btnAuditResult.setEnabled(false);
        this.btnAttachment.setVisible(false);
        this.btnAttachment.setEnabled(false);
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.tblMain.getColumn("entries.askArriveDate").getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
    }

    protected HashMap getBOTPMap() {
        String billTypeId;
        HashMap map = (HashMap)this.getUIContext().get("BTPEDITPARAMETER");
        if (map == null) {
            return map;
        }
        map.put("has_owner_filter", false);
        if (map != null && map.containsKey("DESTBILLTYPE.ID") && map.get("DESTBILLTYPE.ID") != null && (billTypeId = map.get("DESTBILLTYPE.ID").toString()).equals("510b6503-0105-1000-e000-010bc0a812fd463ED552")) {
            map.put("has_owner_filter", true);
        }
        return map;
    }

    protected FilterInfo getBOTPFilterByBillType(String BillTypeId, OrgType destType, String destOrgId) {
        HashMap botpMap;
        FilterInfo bizFilterInfo = null;
        if (this.getBOTPViewStatus() == 1 && (botpMap = this.getBOTPMap()) != null && botpMap.containsKey("DESTBILLTYPE.ID") && botpMap.get("DESTBILLTYPE.ID") != null) {
            String billTypeId = botpMap.get("DESTBILLTYPE.ID").toString();
            if (billTypeId != null && billTypeId.equals("510b6503-0105-1000-e000-010bc0a812fd463ED552")) {
                int i;
                bizFilterInfo = new FilterInfo();
                PurchaseOrgUnitInfo purOrgInfo = (PurchaseOrgUnitInfo)botpMap.get("MAINBIZORG");
                bizFilterInfo.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit.id", (Object)purOrgInfo.getId().toString(), CompareType.EQUALS));
                OrgUnitCollection saleCollection = null;
                CompanyOrgUnitInfo comOrgInfo = null;
                OrgUnitCollection storageCollection = null;
                try {
                    OrgUnitCollection collection = SCMGroupClientUtils.getOrgsByRelation((OrgType)OrgType.Purchase, (OrgType)OrgType.Company, (BOSUuid)purOrgInfo.getId());
                    if (collection.size() > 0 && collection.get(0) instanceof CompanyOrgUnitInfo) {
                        comOrgInfo = (CompanyOrgUnitInfo)collection.get(0);
                    }
                    if (saleCollection != null) {
                        saleCollection = SCMGroupClientUtils.getOrgsByRelation((OrgType)OrgType.Company, (OrgType)OrgType.Sale, (BOSUuid)comOrgInfo.getId());
                    }
                    storageCollection = SCMGroupClientUtils.getOrgsByRelation((OrgType)OrgType.Purchase, (OrgType)OrgType.Storage, (BOSUuid)purOrgInfo.getId());
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
                StringBuffer saleOrgIdBuffer = new StringBuffer();
                StringBuffer storageOrgIdBuffer = new StringBuffer();
                if (saleCollection != null) {
                    for (i = 0; i < saleCollection.size(); ++i) {
                        if (!(saleCollection.get(i) instanceof SaleOrgUnitInfo)) continue;
                        if (saleOrgIdBuffer.length() > 0) {
                            saleOrgIdBuffer.append(",");
                        }
                        saleOrgIdBuffer.append("'");
                        saleOrgIdBuffer.append(saleCollection.get(i).getId().toString());
                        saleOrgIdBuffer.append("'");
                    }
                }
                for (i = 0; i < storageCollection.size(); ++i) {
                    if (!(storageCollection.get(i) instanceof StorageOrgUnitInfo)) continue;
                    if (storageOrgIdBuffer.length() > 0) {
                        storageOrgIdBuffer.append(",");
                    }
                    storageOrgIdBuffer.append("'");
                    storageOrgIdBuffer.append(storageCollection.get(i).getId().toString());
                    storageOrgIdBuffer.append("'");
                }
                if (saleOrgIdBuffer.length() <= 0) {
                    saleOrgIdBuffer.append("'").append("'");
                }
                if (storageOrgIdBuffer.length() <= 0) {
                    storageOrgIdBuffer.append("'").append("'");
                }
                bizFilterInfo.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit.id", null, CompareType.EQUALS));
                bizFilterInfo.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)saleOrgIdBuffer.toString(), CompareType.INNER));
                bizFilterInfo.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)"d8e80652-0111-1000-e000-04c5c0a812202407435C", CompareType.EQUALS));
                bizFilterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgIdBuffer.toString(), CompareType.INNER));
                bizFilterInfo.getFilterItems().add(new FilterItemInfo("entries.isBySaleOrder", (Object)String.valueOf(true), CompareType.EQUALS));
                bizFilterInfo.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)"d8e80652-0111-1000-e000-04c5c0a812202407435C", CompareType.NOTEQUALS));
                bizFilterInfo.getFilterItems().add(new FilterItemInfo("internalCompany.id", (Object)comOrgInfo.getId().toString(), CompareType.EQUALS));
                bizFilterInfo.getFilterItems().add(new FilterItemInfo("entries.isBySaleOrder", (Object)String.valueOf(false), CompareType.EQUALS));
                bizFilterInfo.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)"d8e80652-0111-1000-e000-04c5c0a812202407435C", CompareType.NOTEQUALS));
                bizFilterInfo.setMaskString("(#0 or #1) and ((#2 and #3) or ( #4 and #5 and #6) or (#7 and #8 and #9))");
                if (botpMap != null && botpMap.containsKey("ISARAP")) {
                    bizFilterInfo = new FilterInfo();
                    if (botpMap.containsKey("ARAPCOMPANY")) {
                        CompanyOrgUnitInfo companyOrgInfo = (CompanyOrgUnitInfo)botpMap.get("ARAPCOMPANY");
                        bizFilterInfo.getFilterItems().add(new FilterItemInfo("isCentralBalance", (Object)String.valueOf(true), CompareType.EQUALS));
                        bizFilterInfo.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyOrgInfo.getId().toString(), CompareType.EQUALS));
                        bizFilterInfo.getFilterItems().add(new FilterItemInfo("isCentralBalance", (Object)String.valueOf(false), CompareType.EQUALS));
                        bizFilterInfo.getFilterItems().add(new FilterItemInfo("postcompanyOrgUnit.id", (Object)companyOrgInfo.getId().toString(), CompareType.EQUALS));
                        bizFilterInfo.setMaskString("(#0 and #1) OR (#2 and #3)");
                    }
                }
                OrgType srcType = this.getMainBizOrgType();
                String srcOrgProp = this.getPropertyOfBizOrg(srcType);
                OrgUnitCollection collection = null;
                ISCMBillBase iBiz = null;
                if (srcType.equals((Object)destType)) {
                    this.getUIContext().put(this.getMainBizOrgType(), (OrgUnitInfo)botpMap.get("MAINBIZORG"));
                    this.initUIMainOrgContext(destOrgId);
                } else if (srcOrgProp != null) {
                    try {
                        iBiz = (ISCMBillBase)this.getBizInterface();
                        collection = iBiz.getAuthOrgsByRelation(destType, srcType, destOrgId, this.mainQueryPK);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    if (collection != null && collection.size() > 0) {
                        this.getUIContext().put(this.getMainBizOrgType(), collection.get(0));
                        this.initUIMainOrgContext(collection.get(0).getId().toString());
                    }
                }
            }
            if ("18b7FpLNSrmaD8V9SPcOhkY+1VI=".equals(billTypeId)) {
                TransportOrgUnitInfo transport = (TransportOrgUnitInfo)botpMap.get("MAINBIZORG");
                OrgUnitCollection sous = DtUtils.getStorageCollection(null, (TransportOrgUnitInfo)transport);
                LinkedHashSet<String> souIDs = new LinkedHashSet<String>();
                for (int i = 0; i < sous.size(); ++i) {
                    souIDs.add(sous.get(i).getId().toString());
                }
                bizFilterInfo = new FilterInfo();
                if (souIDs != null && souIDs.size() > 0) {
                    bizFilterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", souIDs, CompareType.INCLUDE));
                } else {
                    bizFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"NotExist"));
                }
            }
        }
        return bizFilterInfo;
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        if (srcBillInfos != null && srcBillInfos.size() > 0) {
            String purOrderType = new PurOrderInfo().getBOSType().toString();
            boolean isNeedDelPurOrderRule = false;
            try {
                ISaleOrder isaleOrder = SaleOrderFactory.getRemoteInstance();
                int n = srcBillInfos.size();
                for (int i = 0; i < n; ++i) {
                    SaleOrderInfo saleorder = isaleOrder.getSaleOrderInfo((IObjectPK)new ObjectUuidPK(((SaleOrderInfo)srcBillInfos.get(i)).getId()));
                    if (saleorder.getPurchaseOrgUnit() != null) continue;
                    isNeedDelPurOrderRule = true;
                    break;
                }
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
        }
        for (int i = destBosTypeList.size() - 1; i >= 0; --i) {
            String bosType = (String)destBosTypeList.get(i);
            if (!"8B07BBDB".equals(bosType)) continue;
            destBosTypeList.remove(i);
        }
        return destBosTypeList;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)"UIClassParam", (Object)"isSCMBill");
        super.prepareUIContext(uiContext, e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return NetOrderBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    private FilterInfo getPremissionFilterByMainOrg() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.listSaleOrg == null && this.iBiz == null) {
            try {
                this.listSaleOrg = new LinkedHashSet();
                this.iBiz = NetOrderBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
                this.authorizedMainOrgs = this.iBiz.getAuthOrgsByType(OrgType.Sale, this.mainQueryPK);
                for (int i = 0; i < this.authorizedMainOrgs.size(); ++i) {
                    this.listSaleOrg.add(this.authorizedMainOrgs.get(i).getId().toString());
                }
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
        }
        if (this.listSaleOrg == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"0_ChannelInwarehsBillListUI"));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)this.listSaleOrg, CompareType.INCLUDE));
        return filterInfo;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo defaultFilterInfo = super.getDefaultFilterForQuery();
        FilterInfo filterInfo = this.getPremissionFilterByMainOrg();
        if (defaultFilterInfo != null) {
            try {
                defaultFilterInfo.mergeFilter(filterInfo, "and");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        } else {
            defaultFilterInfo = filterInfo;
        }
        return defaultFilterInfo;
    }

    public String[] getMergeColumnKeys() {
        String[] mergeColumnKeys = new String[]{"id", "number", "saleOrgUnit.name", "companyOrgUnit.name", "channel.name", "billStatus", "currency.name", "exchangeRate", "bizDate"};
        return mergeColumnKeys;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        CompanyOrgUnitInfo currentCompany = null;
        StringBuffer maskStr = new StringBuffer();
        if (this.getBOTPViewStatus() == 1) {
            Map map = (Map)this.getUIContext().get("BTPEDITPARAMETER");
            if (map != null && currentCompany == null) {
                currentCompany = (CompanyOrgUnitInfo)map.get("ARAPCOMPANY");
            }
            if (currentCompany != null) {
                FilterItemInfo companyFilter = new FilterItemInfo("companyOrgUnit.id", (Object)currentCompany.getId(), CompareType.EQUALS);
                FilterItemInfo entryCompanyFilter = new FilterItemInfo("entries.companyOrgUnit.id", (Object)currentCompany.getId(), CompareType.EQUALS);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(companyFilter);
                filter.getFilterItems().add(entryCompanyFilter);
                maskStr.append(" #0 or #1 ");
                filter.setMaskString(maskStr.toString());
                FilterInfo oldFilter = ev.getFilter();
                try {
                    if (filter.getFilterItems().size() > 0) {
                        oldFilter.mergeFilter(filter, "AND");
                    }
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
                ev.setFilter(oldFilter);
            }
        }
        super.beforeExcutQuery(ev);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.SALESMANAGEMENT;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"1_ChannelInwarehsBillListUI"));
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
    }

    public void actionToExcel_actionPerformed(ActionEvent e) throws Exception {
        super.actionToExcel_actionPerformed(e);
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartWorkFlow_actionPerformed(e);
    }

    public void actionPublishReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionPublishReport_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionQueryScheme_actionPerformed(ActionEvent e) throws Exception {
        super.actionQueryScheme_actionPerformed(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateTo_actionPerformed(e);
    }

    public void actionCopyTo_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyTo_actionPerformed(e);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceUp_actionPerformed(e);
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceDown_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuditResult_actionPerformed(e);
    }

    public void actionViewDoProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDoProccess_actionPerformed(e);
    }

    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiapprove_actionPerformed(e);
    }

    public void actionNextPerson_actionPerformed(ActionEvent e) throws Exception {
        super.actionNextPerson_actionPerformed(e);
    }

    public void actionWorkFlowG_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkFlowG_actionPerformed(e);
    }

    public void actionSendSmsMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendSmsMessage_actionPerformed(e);
    }

    public void actionSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actionSignature_actionPerformed(e);
    }

    public void actionWorkflowList_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkflowList_actionPerformed(e);
    }

    public void actoinViewSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actoinViewSignature_actionPerformed(e);
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnAudit_actionPerformed(e);
    }

    public void actionPrecisionConfig_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrecisionConfig_actionPerformed(e);
    }

    public void actionNoZero_actionPerformed(ActionEvent e) throws Exception {
        super.actionNoZero_actionPerformed(e);
    }

    public void actionMultiPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiPrint_actionPerformed(e);
    }

    public void actionMultiPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiPrintPreview_actionPerformed(e);
    }

    public void actionIsShowSumRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionIsShowSumRow_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public void createToSaleOrder_actionPerformed(ActionEvent e) throws Exception {
        super.createToSaleOrder_actionPerformed(e);
    }

    @Override
    public void actionCollecttionManage_actionPerformed(ActionEvent e) throws Exception {
        super.actionCollecttionManage_actionPerformed(e);
    }

    @Override
    public void actionBatchModify_actionPerformed(ActionEvent e) throws Exception {
        super.actionBatchModify_actionPerformed(e);
    }

    @Override
    public void ationSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.ationSelectAll_actionPerformed(e);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionClearAll_actionPerformed(e);
    }

    protected String getEditUIName() {
        return "";
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.setBizOrgPropertyName("storageOrgUnit");
        return this.qfsi;
    }

    public CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = super.initCommonQueryDialog();
            this.commonQueryDialog.setWidth(490);
        }
        return this.commonQueryDialog;
    }
}

