/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.client.MaterialSelectorFactory;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseFactory;
import com.kingdee.eas.basedata.scm.sd.channel.IChannelBase;
import com.kingdee.eas.basedata.scm.sd.channel.util.CalendarUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.AbstractDataBaseInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.channel.NetOrderBillCollection;
import com.kingdee.eas.scm.sd.channel.NetOrderBillFactory;
import com.kingdee.eas.scm.sd.channel.NetOrderBillInfo;
import com.kingdee.eas.scm.sd.channel.client.AbstractNetOrderCollectionManagerConditionPanelUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class NetOrderCollectionManagerConditionPanelUI
extends AbstractNetOrderCollectionManagerConditionPanelUI {
    private static final Logger logger = CoreUIObject.getLogger(NetOrderCollectionManagerConditionPanelUI.class);
    private OrgUnitInfo[] authStorageOrgs = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.getContextObject();
        this.registListenter();
        this.mainOrgChanged();
        this.kDLabelContainer8.setVisible(false);
        this.initAuthStorageOrgs();
    }

    private void initAuthStorageOrgs() {
        try {
            this.authStorageOrgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getMainBizOrgType(), this.getViewPermission());
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    protected void setDefaultValue() {
        try {
            this.initOrgF7();
            this.initkDDate();
            this.initPrmtChannel();
            this.initPrmtWareHouse();
            this.initMaterial();
            this.initPrmtNumberFrom();
            this.initPrmtNumberTo();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initOrgF7() {
        this.prmtStorage.setEnabledMultiSelection(false);
        this.setBizOrgF7ByType(this.prmtSale, OrgType.Sale, OrgType.Storage, true);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtSale});
    }

    private void initkDDate() throws ParseException {
        Date date = new Date();
        this.kDDateFrom.setValue((Object)CalendarUtil.getRecentOneMonth((Date)date, (int)-1));
        this.kDDateTo.setValue((Object)date);
    }

    private void initPrmtChannel() throws EASBizException, BOSException {
        EntityViewInfo evChannel = new EntityViewInfo();
        FilterInfo filterChannel = new FilterInfo();
        if (this.getSaleIds() != null) {
            filterChannel.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)this.getSaleIds(), CompareType.INCLUDE));
            evChannel.setFilter(filterChannel);
            this.prmtChannel.setEntityViewInfo(evChannel);
        } else {
            Object[] storageObj = this.getStorageObj();
            if (storageObj != null && storageObj.length > 0) {
                FilterItemInfo fiterSale = this.getViewWithSaleNotSeletcted("saleOrgUnit.id");
                filterChannel.getFilterItems().add(fiterSale);
                evChannel.setFilter(filterChannel);
                this.prmtChannel.setEntityViewInfo(evChannel);
            }
        }
    }

    private Object[] getStorageObj() {
        Object[] storageObj = null;
        storageObj = this.prmtStorage.getData() instanceof StorageOrgUnitInfo ? new Object[]{this.prmtStorage.getData()} : (Object[])this.prmtStorage.getData();
        return storageObj;
    }

    private FilterItemInfo getViewWithSaleNotSeletcted(String selectColum) throws EASBizException, BOSException {
        Set idSet = this.getSaleIdsByStorage();
        if (idSet.size() > 0) {
            return new FilterItemInfo(selectColum, (Object)idSet, CompareType.INCLUDE);
        }
        return new FilterItemInfo(selectColum, (Object)"", CompareType.EQUALS);
    }

    private Set getSaleIdsByStorage() throws EASBizException, BOSException {
        HashSet<String> idSet = new HashSet<String>();
        Object[] storageObj = this.getStorageObj();
        OrgUnitCollection orgUnitCon = new OrgUnitCollection();
        OrgUnitCollection tempOrgUnitCon = null;
        if (storageObj != null) {
            for (int i = 0; i < storageObj.length; ++i) {
                if (storageObj[i] != null) {
                    tempOrgUnitCon = SCMGroupClientUtils.getOrgsByRelation((OrgType)OrgType.Storage, (OrgType)OrgType.Sale, (BOSUuid)((AbstractDataBaseInfo)storageObj[i]).getId());
                }
                if (null == tempOrgUnitCon || tempOrgUnitCon.size() <= 0) continue;
                orgUnitCon.addCollection(tempOrgUnitCon);
            }
        }
        for (int j = 0; j < orgUnitCon.size(); ++j) {
            idSet.add(orgUnitCon.get(j).getId().toString());
        }
        return idSet;
    }

    private void initMaterial() {
        OrgUnitInfo mainOrg = null;
        if (this.getMainBizOrgs() != null) {
            mainOrg = this.getMainBizOrgs().get(0);
        }
        this.prmtMaterial.setEditFormat("$number$");
        this.prmtMaterial.setDisplayFormat("$number$");
        this.prmtMaterial.setCommitFormat("$number$;$name$;$model$;$helpCode$");
        SCMGroupClientUtils.setBizMaterialF7((KDBizPromptBox)this.prmtMaterial, (Component)((Object)this), (OrgType)this.getMainBizOrgType(), (boolean)true, null);
        this.prmtMaterial.setEnabledMultiSelection(true);
        SelectorItemCollection selectors = this.prmtMaterial.getSelectorCollection();
        if (selectors == null) {
            selectors = new SelectorItemCollection();
        }
        selectors.add(new SelectorItemInfo("*"));
        selectors.add(new SelectorItemInfo("baseUnit.id"));
        selectors.add(new SelectorItemInfo("baseUnit.number"));
        selectors.add(new SelectorItemInfo("baseUnit.name"));
        selectors.add(new SelectorItemInfo("assistUnit.id"));
        selectors.add(new SelectorItemInfo("assistUnit.number"));
        selectors.add(new SelectorItemInfo("assistUnit.name"));
        selectors.addObjectCollection((IObjectCollection)MaterialSelectorFactory.getSelectors());
        this.prmtMaterial.setSelectorCollection(selectors);
        SCMGroupClientUtils.setApproved4MaterialF7((KDBizPromptBox)this.prmtMaterial, (OrgType)this.getMainBizOrgType());
        if (mainOrg != null) {
            this.prmtMaterial.setCurrentMainBizOrgUnit(mainOrg, this.getMainBizOrgType());
        }
    }

    private void initPrmtNumberFrom() throws EASBizException, BOSException {
        EntityViewInfo evNumber = new EntityViewInfo();
        FilterInfo filterNumber = new FilterInfo();
        if (this.kDDateFrom.getValue() != null) {
            filterNumber.getFilterItems().add(new FilterItemInfo("bizDate", this.kDDateFrom.getValue(), CompareType.GREATER_EQUALS));
        }
        if (this.kDDateTo.getValue() != null) {
            filterNumber.getFilterItems().add(new FilterItemInfo("bizDate", (Object)CalendarUtil.changeDate((Date)((Date)this.kDDateTo.getValue()), (int)1), CompareType.LESS));
        }
        if (this.getStorageId() != null && this.getStorageId().length() > 0) {
            filterNumber.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.getStorageId(), CompareType.INCLUDE));
        }
        if (this.getSaleIds() != null) {
            filterNumber.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)this.getSaleIds(), CompareType.INCLUDE));
            evNumber.setFilter(filterNumber);
            this.prmtNumberFrom.setEntityViewInfo(evNumber);
        } else {
            Object[] storageObj = this.getStorageObj();
            if (storageObj != null && storageObj.length > 0) {
                FilterItemInfo fiterSale = this.getViewWithSaleNotSeletcted("saleOrgUnit.id");
                filterNumber.getFilterItems().add(fiterSale);
                evNumber.setFilter(filterNumber);
                this.prmtNumberFrom.setEntityViewInfo(evNumber);
            }
        }
    }

    private void initPrmtNumberTo() throws EASBizException, BOSException {
        EntityViewInfo evNumber = new EntityViewInfo();
        FilterInfo filterNumber = new FilterInfo();
        if (this.kDDateFrom.getValue() != null) {
            filterNumber.getFilterItems().add(new FilterItemInfo("bizDate", this.kDDateFrom.getValue(), CompareType.GREATER_EQUALS));
        }
        if (this.kDDateTo.getValue() != null) {
            filterNumber.getFilterItems().add(new FilterItemInfo("bizDate", (Object)CalendarUtil.changeDate((Date)((Date)this.kDDateTo.getValue()), (int)1), CompareType.LESS));
        }
        if (this.getStorageId() != null && this.getStorageId().length() > 0) {
            filterNumber.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.getStorageId(), CompareType.INCLUDE));
        }
        if (this.getSaleIds() != null) {
            filterNumber.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)this.getSaleIds(), CompareType.INCLUDE));
            evNumber.setFilter(filterNumber);
            this.prmtNumberTo.setEntityViewInfo(evNumber);
        } else {
            Object[] storageObj = this.getStorageObj();
            if (storageObj != null && storageObj.length > 0) {
                FilterItemInfo fiterSale = this.getViewWithSaleNotSeletcted("saleOrgUnit.id");
                filterNumber.getFilterItems().add(fiterSale);
                evNumber.setFilter(filterNumber);
                this.prmtNumberTo.setEntityViewInfo(evNumber);
                this.prmtNumberTo.getEntityViewInfo();
            }
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    private void registListenter() {
        this.prmtStorage.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                NetOrderCollectionManagerConditionPanelUI.this.prmtSale.setData(null);
                NetOrderCollectionManagerConditionPanelUI.this.prmtWareHouse.setData(null);
                NetOrderCollectionManagerConditionPanelUI.this.prmtChannel.setData(null);
                NetOrderCollectionManagerConditionPanelUI.this.prmtNumberFrom.setData(null);
                NetOrderCollectionManagerConditionPanelUI.this.prmtNumberTo.setData(null);
                if (NetOrderCollectionManagerConditionPanelUI.this.prmtStorage.getData() == null) {
                    return;
                }
                NetOrderCollectionManagerConditionPanelUI.this.prmtSale_willShow();
                NetOrderCollectionManagerConditionPanelUI.this.prmtChannel_willShow();
                NetOrderCollectionManagerConditionPanelUI.this.prmtWareHouse_willShow();
                NetOrderCollectionManagerConditionPanelUI.this.prmtNumberFrom_willShow();
                NetOrderCollectionManagerConditionPanelUI.this.prmtNumberTo_willShow();
            }
        });
        this.prmtSale.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                NetOrderCollectionManagerConditionPanelUI.this.prmtChannel.setData(null);
                NetOrderCollectionManagerConditionPanelUI.this.prmtNumberFrom.setData(null);
                NetOrderCollectionManagerConditionPanelUI.this.prmtNumberTo.setData(null);
                NetOrderCollectionManagerConditionPanelUI.this.prmtChannel_willShow();
                NetOrderCollectionManagerConditionPanelUI.this.prmtNumberFrom_willShow();
                NetOrderCollectionManagerConditionPanelUI.this.prmtNumberTo_willShow();
            }
        });
        this.kDDateFrom.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                NetOrderCollectionManagerConditionPanelUI.this.prmtNumberFrom.setData(null);
                NetOrderCollectionManagerConditionPanelUI.this.prmtNumberTo.setData(null);
                NetOrderCollectionManagerConditionPanelUI.this.prmtNumberFrom_willShow();
                NetOrderCollectionManagerConditionPanelUI.this.prmtNumberTo_willShow();
            }
        });
        this.kDDateTo.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                NetOrderCollectionManagerConditionPanelUI.this.prmtNumberFrom.setData(null);
                NetOrderCollectionManagerConditionPanelUI.this.prmtNumberTo.setData(null);
                NetOrderCollectionManagerConditionPanelUI.this.prmtNumberFrom_willShow();
                NetOrderCollectionManagerConditionPanelUI.this.prmtNumberTo_willShow();
            }
        });
    }

    public Date changeDate(Date date, int day) {
        Date needDate = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, day);
        needDate = calendar.getTime();
        return needDate;
    }

    private void prmtSale_willShow() {
        try {
            this.initPrmtSale();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void initPrmtSale() throws EASBizException, BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        Set idSet = new HashSet();
        idSet = this.getSaleIdsByStorage();
        if (idSet.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            ev.setFilter(filterInfo);
            this.prmtSale.setEntityViewInfo(ev);
        }
    }

    private void prmtWareHouse_willShow() {
        this.initPrmtWareHouse();
    }

    private void initPrmtWareHouse() {
        Object[] storageObj = this.getStorageObj();
        if (storageObj != null && storageObj.length > 0 && storageObj[0] != null) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("whState", (Object)new Integer(1), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)this.getStorageId(), CompareType.INCLUDE));
            ev.setFilter(filterInfo);
            this.prmtWareHouse.setEntityViewInfo(ev);
        }
    }

    private void prmtChannel_willShow() {
        try {
            this.initPrmtChannel();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void prmtNumberFrom_willShow() {
        try {
            this.initPrmtNumberFrom();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void prmtNumberTo_willShow() {
        try {
            this.initPrmtNumberTo();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.kDDateFrom.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", this.kDDateFrom.getValue(), CompareType.GREATER_EQUALS));
        }
        if (this.kDDateTo.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", this.kDDateTo.getValue(), CompareType.LESS_EQUALS));
        }
        if (this.getStorageId() != null && this.getStorageId().length() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.getStorageId(), CompareType.INCLUDE));
        } else {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"7_NetOrderCollectionManagerConditionPanelUI"));
            SysUtil.abort();
        }
        if (this.getWareHouseIds() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("entries.warehouse.id", (Object)this.getWareHouseIds(), CompareType.INCLUDE));
        }
        if (this.getChannelIds() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("channel.id", (Object)this.getChannelIds(), CompareType.INCLUDE));
        }
        if (this.prmtNumberFrom.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)((NetOrderBillInfo)this.prmtNumberFrom.getValue()).getNumber(), CompareType.GREATER_EQUALS));
        }
        if (this.prmtNumberTo.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)((NetOrderBillInfo)this.prmtNumberTo.getValue()).getNumber(), CompareType.LESS_EQUALS));
        }
        if (this.getSaleIds() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)this.getSaleIds(), CompareType.INCLUDE));
        }
        if (this.getMaterialIds() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("entries.material.id", (Object)this.getMaterialIds(), CompareType.INCLUDE));
        }
        FilterInfo aFilterInfo = new FilterInfo();
        aFilterInfo.getFilterItems().add(new FilterItemInfo("entries.entryStatus", (Object)new Integer(4)));
        aFilterInfo.getFilterItems().add(new FilterItemInfo("entries.entryStatus", (Object)new Integer(8)));
        aFilterInfo.setMaskString("#0 OR #1");
        if (FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
            try {
                filterInfo.mergeFilter(aFilterInfo, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            filterInfo = (FilterInfo)aFilterInfo.clone();
        }
        return filterInfo;
    }

    public void clear() {
        this.setAuthorizedMainOrgs(null);
        super.clear();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
        try {
            NetOrderBillCollection netOrderBillCollection = null;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filterInfo = null;
            this.kDDateFrom.setValue(null);
            this.kDDateTo.setValue(null);
            this.prmtStorage.setData(null);
            this.prmtWareHouse.setData(null);
            this.prmtChannel.setData(null);
            this.prmtNumberFrom.setData(null);
            this.prmtNumberTo.setData(null);
            this.prmtSale.setData(null);
            for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
                FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("bizDate") && filterItemInfo.getCompareExpression().equals(CompareType.GREATER_EQUALS.toString())) {
                    this.kDDateFrom.setValue(filterItemInfo.getCompareValue());
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("bizDate") && filterItemInfo.getCompareExpression().equals(CompareType.LESS_EQUALS.toString())) {
                    this.kDDateTo.setValue(filterItemInfo.getCompareValue());
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("storageOrgUnit.id") && filterItemInfo.getCompareValue() != null) {
                    this.prmtStorage.setValue((Object)this.getStorageDataByIds(filterItemInfo.getCompareValue().toString()));
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("entries.warehouse.id")) {
                    this.prmtWareHouse.setData((Object)this.getWareHouseDataByIds(filterItemInfo.getCompareValue().toString()));
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("saleOrgUnit.id")) {
                    this.prmtSale.setData((Object)this.getSaleOrgUnitDataByIds(filterItemInfo.getCompareValue().toString()));
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("channel.id") && filterItemInfo.getCompareValue() != null) {
                    this.prmtChannel.setValue((Object)this.getChannelByIds(filterItemInfo.getCompareValue().toString()));
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("number") && filterItemInfo.getCompareExpression().equals(CompareType.GREATER_EQUALS.toString())) {
                    filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)filterItemInfo.getCompareValue().toString()));
                    ev.setFilter(filterInfo);
                    netOrderBillCollection = NetOrderBillFactory.getRemoteInstance().getNetOrderBillCollection(ev);
                    this.prmtNumberFrom.setValue((Object)netOrderBillCollection.get(0));
                    continue;
                }
                if (!filterItemInfo.getPropertyName().equalsIgnoreCase("number") || !filterItemInfo.getCompareExpression().equals(CompareType.LESS_EQUALS.toString())) continue;
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)filterItemInfo.getCompareValue().toString()));
                ev.setFilter(filterInfo);
                netOrderBillCollection = NetOrderBillFactory.getRemoteInstance().getNetOrderBillCollection(ev);
                this.prmtNumberTo.setValue((Object)netOrderBillCollection.get(0));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private String getStorageId() {
        StringBuffer storageIds = new StringBuffer();
        Object[] storageObj = this.getStorageObj();
        if (storageObj == null || storageObj.length < 1 || storageObj.length == 1 && storageObj[0] == null) {
            return null;
        }
        for (int i = 0; i < storageObj.length; ++i) {
            storageIds.append(((AbstractDataBaseInfo)storageObj[i]).getId());
            storageIds.append(",");
        }
        storageIds.deleteCharAt(storageIds.length() - 1);
        return storageIds.toString();
    }

    private String getWareHouseIds() {
        StringBuffer wareHouseIds = new StringBuffer();
        Object[] wareHouse = (Object[])this.prmtWareHouse.getData();
        if (wareHouse == null || wareHouse.length < 1 || wareHouse.length == 1 && wareHouse[0] == null) {
            return null;
        }
        for (int i = 0; i < wareHouse.length; ++i) {
            wareHouseIds.append(((AbstractDataBaseInfo)wareHouse[i]).getId());
            wareHouseIds.append(",");
        }
        wareHouseIds.deleteCharAt(wareHouseIds.length() - 1);
        return wareHouseIds.toString();
    }

    private String getSaleIds() {
        StringBuffer saleIds = new StringBuffer();
        Object[] sale = (Object[])this.prmtSale.getData();
        if (sale == null || sale.length < 1 || sale.length == 1 && sale[0] == null) {
            return null;
        }
        for (int i = 0; i < sale.length; ++i) {
            saleIds.append(((AbstractDataBaseInfo)sale[i]).getId());
            saleIds.append(",");
        }
        saleIds.deleteCharAt(saleIds.length() - 1);
        return saleIds.toString();
    }

    private String getMaterialIds() {
        StringBuffer materialIds = new StringBuffer();
        Object[] material = (Object[])this.prmtMaterial.getData();
        if (material == null || material.length < 1 || material.length == 1 && material[0] == null) {
            return null;
        }
        for (int i = 0; i < material.length; ++i) {
            materialIds.append(((AbstractDataBaseInfo)material[i]).getId());
            materialIds.append(",");
        }
        materialIds.deleteCharAt(materialIds.length() - 1);
        return materialIds.toString();
    }

    private Object[] getWareHouseDataByIds(String warehouseIds) {
        if (warehouseIds != null && (warehouseIds.indexOf("[") > 0 || warehouseIds.indexOf("]") > 0)) {
            warehouseIds = warehouseIds.replace('[', ' ').replace(']', ' ');
        }
        String[] pks = warehouseIds.split(",");
        Object[] warehouseData = new Object[pks.length];
        IWarehouse iWarehouse = null;
        try {
            iWarehouse = WarehouseFactory.getRemoteInstance();
            for (int i = 0; i < pks.length; ++i) {
                warehouseData[i] = iWarehouse.getWarehouseInfo((IObjectPK)new ObjectUuidPK(pks[i].trim()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return warehouseData;
    }

    private Object[] getStorageDataByIds(String storageIds) {
        if (storageIds != null && (storageIds.indexOf("[") > 0 || storageIds.indexOf("]") > 0)) {
            storageIds = storageIds.replace('[', ' ').replace(']', ' ');
        }
        String[] pks = storageIds.split(",");
        Object[] storageData = new Object[pks.length];
        IStorageOrgUnit iStorageOrgUnit = null;
        try {
            iStorageOrgUnit = StorageOrgUnitFactory.getRemoteInstance();
            for (int i = 0; i < pks.length; ++i) {
                storageData[i] = iStorageOrgUnit.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(pks[i].trim()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return storageData;
    }

    private Object[] getSaleOrgUnitDataByIds(String saleOrgIds) {
        if (saleOrgIds != null && (saleOrgIds.indexOf("[") > 0 || saleOrgIds.indexOf("]") > 0)) {
            saleOrgIds = saleOrgIds.replace('[', ' ').replace(']', ' ');
        }
        String[] pks = saleOrgIds.split(",");
        Object[] saleOrgData = new Object[pks.length];
        ISaleOrgUnit iSaleOrgUnit = null;
        try {
            iSaleOrgUnit = SaleOrgUnitFactory.getRemoteInstance();
            for (int i = 0; i < pks.length; ++i) {
                saleOrgData[i] = iSaleOrgUnit.getSaleOrgUnitInfo((IObjectPK)new ObjectUuidPK(pks[i].trim()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return saleOrgData;
    }

    private String getChannelIds() {
        StringBuffer channelIds = new StringBuffer();
        Object[] channel = (Object[])this.prmtChannel.getData();
        if (channel == null || channel.length < 1 || channel.length == 1 && channel[0] == null) {
            return null;
        }
        for (int i = 0; i < channel.length; ++i) {
            channelIds.append(((AbstractDataBaseInfo)channel[i]).getId());
            channelIds.append(",");
        }
        channelIds.deleteCharAt(channelIds.length() - 1);
        return channelIds.toString();
    }

    private Object[] getChannelByIds(String storageIds) {
        if (storageIds != null && (storageIds.indexOf("[") > 0 || storageIds.indexOf("]") > 0)) {
            storageIds = storageIds.replace('[', ' ').replace(']', ' ');
        }
        String[] pks = storageIds.split(",");
        Object[] channelData = new Object[pks.length];
        IChannelBase iChannel = null;
        try {
            iChannel = ChannelBaseFactory.getRemoteInstance();
            for (int i = 0; i < pks.length; ++i) {
                channelData[i] = iChannel.getChannelBaseInfo((IObjectPK)new ObjectUuidPK(pks[i].trim()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return channelData;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorage;
    }

    public boolean verify() {
        if (this.getStorageId() == null || this.getStorageId().trim().length() == 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"7_NetOrderCollectionManagerConditionPanelUI"));
            return false;
        }
        Timestamp dateFrom = SCMUtils.getDayStartTime((Date)((Date)this.kDDateFrom.getValue()));
        Timestamp dateTo = SCMUtils.getDayEndTime((Date)((Date)this.kDDateTo.getValue()));
        if (dateFrom != null && dateTo != null && ((Date)dateTo).getTime() < ((Date)dateFrom).getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.report.SDReportResource", (String)"END_LATE_NOW"));
            this.kDDateTo.requestFocus();
            return false;
        }
        return true;
    }

    protected String getViewPermission() {
        return "";
    }

    @Override
    public IUIActionPostman prepareInit() {
        return super.prepareInit();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }
}

