/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseFactory;
import com.kingdee.eas.basedata.scm.sd.channel.IChannelBase;
import com.kingdee.eas.basedata.scm.sd.channel.util.CalendarUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.AbstractDataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.bireport.bimanager.util.StringUtils;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.sd.channel.NetOrderBillCollection;
import com.kingdee.eas.scm.sd.channel.NetOrderBillFactory;
import com.kingdee.eas.scm.sd.channel.NetOrderBillInfo;
import com.kingdee.eas.scm.sd.channel.client.AbstractNetOrderCollectionManagerFilterUI;
import java.awt.Component;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class NetOrderCollectionManagerFilterUI
extends AbstractNetOrderCollectionManagerFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(NetOrderCollectionManagerFilterUI.class);
    protected KDBizPromptBox prmtSaleOrgUnit;
    private OrgUnitInfo[] authStorageOrgs = null;
    private Set listAuthStorageOrg = null;

    public void onLoad() throws Exception {
        this.initAuthStorageOrgs();
        super.onLoad();
        this.getContextObject();
        this.registListenter();
        this.mainOrgChanged();
    }

    private void initAuthStorageOrgs() {
        try {
            this.authStorageOrgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), OrgType.Storage, null);
            if (this.authStorageOrgs != null && this.authStorageOrgs.length > 0) {
                String ids = SCMGroupClientUtils.getKeyIdList((ObjectBaseInfo[])this.authStorageOrgs, (String)";");
                String[] idsArray = ids.split(";");
                this.listAuthStorageOrg = new LinkedHashSet(idsArray.length);
                for (int i = 0; i < idsArray.length; ++i) {
                    this.listAuthStorageOrg.add(idsArray[i]);
                }
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    protected void setDefaultValue() {
        try {
            this.initOrgF7();
            this.initkDDate();
            this.initPrmtNumberFrom();
            this.initPrmtNumberTo();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initPrmtChannel() throws EASBizException, BOSException {
        EntityViewInfo evChannel = new EntityViewInfo();
        FilterInfo filterChannel = new FilterInfo();
        Object[] storageObj = this.getStorageObj();
        if (storageObj != null && storageObj.length > 0) {
            FilterItemInfo fiterSale = this.getViewWithSaleNotSeletcted("saleOrgUnit.id");
            filterChannel.getFilterItems().add(fiterSale);
            evChannel.setFilter(filterChannel);
            this.prmtChannel.setEntityViewInfo(evChannel);
        }
    }

    private Object[] getStorageObj() {
        Object[] storageObj = null;
        storageObj = this.prmtStorage.getData() instanceof StorageOrgUnitInfo ? new Object[]{this.prmtStorage.getData()} : (Object[])this.prmtStorage.getData();
        return storageObj;
    }

    private FilterItemInfo getViewWithSaleNotSeletcted(String selectColum) throws EASBizException, BOSException {
        Set idSet = this.getSaleIdsByStorage();
        if (idSet.size() > 0) {
            return new FilterItemInfo(selectColum, (Object)idSet, CompareType.INCLUDE);
        }
        return new FilterItemInfo(selectColum, (Object)"", CompareType.EQUALS);
    }

    private Set getSaleIdsByStorage() throws EASBizException, BOSException {
        HashSet<String> idSet = new HashSet<String>();
        Object[] storageObj = this.getStorageObj();
        OrgUnitCollection orgUnitCon = new OrgUnitCollection();
        OrgUnitCollection tempOrgUnitCon = null;
        if (storageObj != null) {
            for (int i = 0; i < storageObj.length; ++i) {
                if (storageObj[i] != null) {
                    tempOrgUnitCon = SCMGroupClientUtils.getOrgsByRelation((OrgType)OrgType.Storage, (OrgType)OrgType.Sale, (BOSUuid)((AbstractDataBaseInfo)storageObj[i]).getId());
                }
                if (null == tempOrgUnitCon || tempOrgUnitCon.size() <= 0) continue;
                orgUnitCon.addCollection(tempOrgUnitCon);
            }
        }
        for (int j = 0; j < orgUnitCon.size(); ++j) {
            idSet.add(orgUnitCon.get(j).getId().toString());
        }
        return idSet;
    }

    private void initkDDate() throws ParseException {
        Date date = new Date();
        this.kDDateFrom.setValue((Object)CalendarUtil.getRecentOneMonth((Date)date, (int)-1));
        this.kDDateTo.setValue((Object)date);
    }

    private void initOrgF7() {
        this.prmtSaleOrgUnit = new KDBizPromptBox();
        this.prmtSaleOrgUnit.setQueryInfo("com.kingdee.eas.basedata.org.app.SaleOrgUnitQuery");
        this.prmtSaleOrgUnit.setEnabledMultiSelection(true);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        RangeFilterElement bizdate = new RangeFilterElement("bizDate", (Component)this.kDDateFrom, (Component)this.kDDateTo);
        bizdate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        bizdate.setId("bizDate");
        bizdate.setDefaultValue((Object)SCMUtils.getDefaultDateRange(null));
        elements.add((FilterElement)bizdate);
        elements.add((FilterElement)new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorage));
        elements.add((FilterElement)new SingleFilterElement("channel.number", (Component)this.prmtChannel));
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.prmtNumberFrom, (Component)this.prmtNumberTo));
        this.getFilterManager().setElement((FilterElement)elements);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorage, (OrgType)OrgType.Storage, null);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtSaleOrgUnit;
    }

    private void setChannelF7() {
        EntityViewInfo evChannel = new EntityViewInfo();
        FilterInfo filterChannel = new FilterInfo();
        filterChannel.getFilterItems().add(new FilterItemInfo("isCollectManager", (Object)"0", CompareType.EQUALS));
        evChannel.setFilter(filterChannel);
        this.prmtChannel.setEntityViewInfo(evChannel);
    }

    public void clear() {
        super.clear();
        this.prmtSaleOrgUnit.setData((Object)this.getMainOrgs());
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    private void registListenter() {
        this.prmtStorage.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                NetOrderCollectionManagerFilterUI.this.prmtNumberFrom.setData(null);
                NetOrderCollectionManagerFilterUI.this.prmtNumberTo.setData(null);
                NetOrderCollectionManagerFilterUI.this.prmtNumberFrom_willShow();
                NetOrderCollectionManagerFilterUI.this.prmtNumberTo_willShow();
            }
        });
        this.prmtChannel.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                NetOrderCollectionManagerFilterUI.this.prmtNumberFrom.setData(null);
                NetOrderCollectionManagerFilterUI.this.prmtNumberTo.setData(null);
                NetOrderCollectionManagerFilterUI.this.prmtNumberFrom_willShow();
                NetOrderCollectionManagerFilterUI.this.prmtNumberTo_willShow();
            }
        });
        this.kDDateFrom.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                NetOrderCollectionManagerFilterUI.this.prmtNumberFrom.setData(null);
                NetOrderCollectionManagerFilterUI.this.prmtNumberTo.setData(null);
                NetOrderCollectionManagerFilterUI.this.prmtNumberFrom_willShow();
                NetOrderCollectionManagerFilterUI.this.prmtNumberTo_willShow();
            }
        });
        this.kDDateTo.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                NetOrderCollectionManagerFilterUI.this.prmtNumberFrom.setData(null);
                NetOrderCollectionManagerFilterUI.this.prmtNumberTo.setData(null);
                NetOrderCollectionManagerFilterUI.this.prmtNumberFrom_willShow();
                NetOrderCollectionManagerFilterUI.this.prmtNumberTo_willShow();
            }
        });
    }

    private void prmtNumberFrom_willShow() {
        try {
            this.initPrmtNumberFrom();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void prmtNumberTo_willShow() {
        try {
            this.initPrmtNumberTo();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void initPrmtNumberFrom() throws EASBizException, BOSException {
        EntityViewInfo evNumber = new EntityViewInfo();
        FilterInfo filterNumber = new FilterInfo();
        if (this.kDDateFrom.getValue() != null) {
            filterNumber.getFilterItems().add(new FilterItemInfo("bizDate", this.kDDateFrom.getValue(), CompareType.GREATER_EQUALS));
        }
        if (this.kDDateTo.getValue() != null) {
            filterNumber.getFilterItems().add(new FilterItemInfo("bizDate", (Object)CalendarUtil.changeDate((Date)((Date)this.kDDateTo.getValue()), (int)1), CompareType.LESS));
        }
        if (!StringUtils.isEmpty((String)this.getStorageId())) {
            filterNumber.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.getStorageId(), CompareType.INCLUDE));
        } else if (this.listAuthStorageOrg != null && this.listAuthStorageOrg.size() > 0) {
            filterNumber.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.listAuthStorageOrg, CompareType.INCLUDE));
        }
        if (!StringUtils.isEmpty((String)this.getChannelIds())) {
            filterNumber.getFilterItems().add(new FilterItemInfo("channel.id", (Object)this.getChannelIds(), CompareType.INCLUDE));
        }
        evNumber.setFilter(filterNumber);
        this.prmtNumberFrom.setEntityViewInfo(evNumber);
    }

    private void initPrmtNumberTo() throws EASBizException, BOSException {
        EntityViewInfo evNumber = new EntityViewInfo();
        FilterInfo filterNumber = new FilterInfo();
        if (this.kDDateFrom.getValue() != null) {
            filterNumber.getFilterItems().add(new FilterItemInfo("bizDate", this.kDDateFrom.getValue(), CompareType.GREATER_EQUALS));
        }
        if (this.kDDateTo.getValue() != null) {
            filterNumber.getFilterItems().add(new FilterItemInfo("bizDate", (Object)CalendarUtil.changeDate((Date)((Date)this.kDDateTo.getValue()), (int)1), CompareType.LESS));
        }
        if (!StringUtils.isEmpty((String)this.getStorageId())) {
            filterNumber.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.getStorageId(), CompareType.INCLUDE));
        } else if (this.listAuthStorageOrg != null && this.listAuthStorageOrg.size() > 0) {
            filterNumber.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.listAuthStorageOrg, CompareType.INCLUDE));
        }
        if (!StringUtils.isEmpty((String)this.getChannelIds())) {
            filterNumber.getFilterItems().add(new FilterItemInfo("channel.id", (Object)this.getChannelIds(), CompareType.INCLUDE));
        }
        evNumber.setFilter(filterNumber);
        this.prmtNumberTo.setEntityViewInfo(evNumber);
    }

    private String getChannelIds() {
        StringBuffer channelIds = new StringBuffer();
        Object[] channel = (Object[])this.prmtChannel.getData();
        if (channel == null || channel.length < 1 || channel.length == 1 && channel[0] == null) {
            return null;
        }
        for (int i = 0; i < channel.length; ++i) {
            channelIds.append(((AbstractDataBaseInfo)channel[i]).getId());
            channelIds.append(",");
        }
        channelIds.deleteCharAt(channelIds.length() - 1);
        return channelIds.toString();
    }

    private String getStorageId() {
        StringBuffer storageIds = new StringBuffer();
        Object[] storageObj = this.getStorageObj();
        if (storageObj == null || storageObj.length < 1 || storageObj.length == 1 && storageObj[0] == null) {
            return null;
        }
        for (int i = 0; i < storageObj.length; ++i) {
            storageIds.append(((AbstractDataBaseInfo)storageObj[i]).getId());
            storageIds.append(",");
        }
        storageIds.deleteCharAt(storageIds.length() - 1);
        return storageIds.toString();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
        try {
            NetOrderBillCollection netOrderBillCollection = null;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filterInfo = null;
            this.kDDateFrom.setValue(null);
            this.kDDateTo.setValue(null);
            this.prmtStorage.setData(null);
            this.prmtChannel.setData(null);
            this.prmtNumberFrom.setData(null);
            this.prmtNumberTo.setData(null);
            for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
                FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("bizDate") && filterItemInfo.getCompareExpression().equals(CompareType.GREATER_EQUALS.toString())) {
                    this.kDDateFrom.setValue(filterItemInfo.getCompareValue());
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("bizDate") && filterItemInfo.getCompareExpression().equals(CompareType.LESS_EQUALS.toString())) {
                    this.kDDateTo.setValue(filterItemInfo.getCompareValue());
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("storageOrgUnit.id") && filterItemInfo.getCompareValue() != null) {
                    this.prmtStorage.setValue((Object)this.getStorageDataByIds(filterItemInfo.getCompareValue().toString()));
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("channel.id") && filterItemInfo.getCompareValue() != null) {
                    this.prmtChannel.setValue((Object)this.getChannelByIds(filterItemInfo.getCompareValue().toString()));
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("number") && filterItemInfo.getCompareExpression().equals(CompareType.GREATER_EQUALS.toString())) {
                    filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)filterItemInfo.getCompareValue().toString()));
                    ev.setFilter(filterInfo);
                    netOrderBillCollection = NetOrderBillFactory.getRemoteInstance().getNetOrderBillCollection(ev);
                    this.prmtNumberFrom.setValue((Object)netOrderBillCollection.get(0));
                    continue;
                }
                if (!filterItemInfo.getPropertyName().equalsIgnoreCase("number") || !filterItemInfo.getCompareExpression().equals(CompareType.LESS_EQUALS.toString())) continue;
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)filterItemInfo.getCompareValue().toString()));
                ev.setFilter(filterInfo);
                netOrderBillCollection = NetOrderBillFactory.getRemoteInstance().getNetOrderBillCollection(ev);
                this.prmtNumberTo.setValue((Object)netOrderBillCollection.get(0));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.kDDateFrom.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", this.kDDateFrom.getValue(), CompareType.GREATER_EQUALS));
        }
        if (this.kDDateTo.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", this.kDDateTo.getValue(), CompareType.LESS_EQUALS));
        }
        if (this.getStorageId() != null && this.getStorageId().length() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.getStorageId(), CompareType.INCLUDE));
        }
        if (this.getChannelIds() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("channel.id", (Object)this.getChannelIds(), CompareType.INCLUDE));
        }
        if (this.prmtNumberFrom.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)((NetOrderBillInfo)this.prmtNumberFrom.getValue()).getNumber(), CompareType.GREATER_EQUALS));
        }
        if (this.prmtNumberTo.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)((NetOrderBillInfo)this.prmtNumberTo.getValue()).getNumber(), CompareType.LESS_EQUALS));
        }
        return filterInfo;
    }

    private StorageOrgUnitInfo getStorageInfoById(String storageId) throws EASBizException, BOSException {
        StorageOrgUnitInfo storageInfo = null;
        if (!StringUtils.isEmpty((String)storageId)) {
            storageInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storageId));
        }
        return storageInfo;
    }

    private Object[] getStorageDataByIds(String storageIds) {
        if (storageIds != null && (storageIds.indexOf("[") > 0 || storageIds.indexOf("]") > 0)) {
            storageIds = storageIds.replace('[', ' ').replace(']', ' ');
        }
        String[] pks = storageIds.split(",");
        Object[] storageData = new Object[pks.length];
        IStorageOrgUnit iStorageOrgUnit = null;
        try {
            iStorageOrgUnit = StorageOrgUnitFactory.getRemoteInstance();
            for (int i = 0; i < pks.length; ++i) {
                storageData[i] = iStorageOrgUnit.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(pks[i].trim()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return storageData;
    }

    private Object[] getChannelByIds(String storageIds) {
        if (storageIds != null && (storageIds.indexOf("[") > 0 || storageIds.indexOf("]") > 0)) {
            storageIds = storageIds.replace('[', ' ').replace(']', ' ');
        }
        String[] pks = storageIds.split(",");
        Object[] channelData = new Object[pks.length];
        IChannelBase iChannel = null;
        try {
            iChannel = ChannelBaseFactory.getRemoteInstance();
            for (int i = 0; i < pks.length; ++i) {
                channelData[i] = iChannel.getChannelBaseInfo((IObjectPK)new ObjectUuidPK(pks[i].trim()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return channelData;
    }
}

