/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.common.client.ReasonF7Until;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMBillEditUI;
import com.kingdee.eas.scm.common.client.SCMClientHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.channel.ISaleBackProfitBill;
import com.kingdee.eas.scm.sd.channel.ISaleBackProfitBillEntry;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitBillEntryCollection;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitBillEntryFactory;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitBillFactory;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitBillInfo;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitSourceTypeEnum;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitTypeEnum;
import com.kingdee.eas.scm.sd.channel.client.AbstractSaleBackProfitEditUI;
import com.kingdee.eas.scm.sm.pur.PurReqException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class SaleBackProfitEditUI
extends AbstractSaleBackProfitEditUI {
    private static final BigDecimal BIGDECIMAL_ZERO = new BigDecimal("0");
    public static final int PRECISION_DEFAUL_DB = 8;
    public static final BigDecimal EXCHANGERATE_DEFAULT_NUM = new BigDecimal("1.00");
    public static final String RESOURCE_PATH = "com.kingdee.eas.scm.sd.channel.SaleBackProfitResource";
    public static final String TB_ENTRY_ID = "id";
    public static final String TB_MATERIAL_NUMBER = "material";
    public static final String TB_MATERIAL_NAME = "materialName";
    public static final String TB_MATERIAL_MODEL = "model";
    public static final String TB_MATERIAL_CLASS = "materialGroup";
    public static final String TB_MATERIAL_UNIT = "unit";
    public static final String TB_MATERIAL_BASEUNIT = "baseUnit";
    public static final String TB_QTY = "qty";
    public static final String TB_BASEQTY = "baseQty";
    public static final String TB_BASEPROFITAMOUNT = "baseProfitAmount";
    public static final String TB_AMOUNT = "amount";
    public static final String TB_BASEPROFITQTY = "baseProfitQty";
    public static final String TB_PROFITAMOUNT = "profitAmount";
    public static final String TB_LOCALAMOUNT = "localAmount";
    public static final String TB_TOTALARAPAMOUNT = "totalArApAmount";
    public static final String TB_TOTALLOCALARAPAMOUNT = "totalLocalArApAmount";
    public static final String TB_REMARK = "remark";
    SCMClientHelper clientHelper = new SCMClientHelper((SCMBillEditUI)this);
    private static final String[] UNNEGATIVEDTAB = new String[]{"qty", "baseProfitAmount", "amount", "profitAmount"};
    private static final String[] QTYPRECISIONTAB = new String[]{"qty", "baseProfitQty"};
    private static final String[] QTYPRECISION_BASEQTY = new String[]{"baseQty"};
    private static final String[] RIGHTALIGNTAB = new String[]{"baseQty", "qty", "baseProfitAmount", "baseProfitQty", "amount", "profitAmount", "localAmount", "totalArApAmount", "totalLocalArApAmount"};
    private static final String[] ENTRY_NEED_DEFAULT = new String[]{"materialGroup", "qty", "baseProfitAmount", "amount", "baseProfitQty", "profitAmount"};
    private static final String[] CURRENCYAMOUNT = new String[]{"baseProfitAmount", "amount", "totalArApAmount", "profitAmount"};
    private static final String[] CURRENCYLOCALAMOUNT = new String[]{"localAmount", "totalLocalArApAmount"};
    private final KDFormattedTextField[] EXCHANGERECISIONCOMPENT = new KDFormattedTextField[]{this.txtExchangeRate};
    FilterItemInfo materialFilterItemInfo = null;
    CompanyOrgUnitInfo ficompanyOrgInfo = null;
    ExchangeRateInfo exchangeRateinfo = null;
    CurrencyInfo baseCurrInfo = null;
    KDBizPromptBox prmtMaterialNumber = null;
    public static final int DEFAULTORGMASK_CUSTOMER = 4;
    public static final int DEFAULTORGMASK_SUPPLIER = 8;
    private int DEFAULTORGMASK = 4;
    private KDTEditAdapter entryTableChange = null;
    private boolean isNeedCheck = false;
    private ExchangeRateInfo exchangeRateInfo = null;
    private ExchangeAuxInfo exchangeAuxInfo = null;
    private DataChangeListener txtExrateListener;
    private DataChangeListener prmtCurrencyListener;
    protected ActionShowGenerateFieldUI actionShowGenerateFieldUI = null;

    public SaleBackProfitEditUI() throws Exception {
        this.initConfigMap();
    }

    private void initConfigMap() {
        HashMap<String, Object> colMap = new HashMap<String, Object>();
        colMap.put("MATERIAL", TB_MATERIAL_NUMBER);
        colMap.put("TB_BASEUNIT", TB_MATERIAL_BASEUNIT);
        colMap.put("TB_UNIT", TB_MATERIAL_UNIT);
        colMap.put("QTY", TB_QTY);
        colMap.put("TB_BASEQTY", TB_BASEQTY);
        colMap.put("QTYPRECISIONFROMUNITTAB", QTYPRECISIONTAB);
        colMap.put("QTYPRECISIONFROMBASEUNITTAB", QTYPRECISION_BASEQTY);
        colMap.put("prmtCurrency", this.prmtCurrency);
        colMap.put("txtExchangeRate", this.txtExchangeRate);
        this.uiHelper.setConfigMap(colMap);
        this.uiHelper.setKdtEntries(this.kdtEntries);
    }

    @Override
    public void loadFields() {
        this.removeListener();
        if (this.entryTableChange != null) {
            this.kdtEntries.removeKDTEditListener((KDTEditListener)this.entryTableChange);
        }
        super.loadFields();
        this.initEntriesTable();
        this.initEntryUnitCell();
        this.initUIData();
        SCMEntryDataVO resultVO = new SCMEntryDataVO();
        resultVO = this.uiHelper.initInLoadFields(resultVO);
        this.initBackProfitPrecision(resultVO);
        this.addListener();
    }

    private void removeListener() {
        if (this.txtExrateListener != null) {
            this.txtExchangeRate.removeDataChangeListener(this.txtExrateListener);
        }
        if (this.prmtCurrencyListener != null) {
            this.prmtCurrency.removeDataChangeListener(this.prmtCurrencyListener);
        }
    }

    private void addListener() {
        this.txtExrateListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    SaleBackProfitEditUI.this.saleProfitEditUIExchangeRate_dataChanged(e);
                }
                catch (Exception exc) {
                    SaleBackProfitEditUI.this.handUIException(exc);
                }
            }
        };
        this.txtExchangeRate.addDataChangeListener(this.txtExrateListener);
        this.prmtCurrencyListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    SaleBackProfitEditUI.this.saleProfitEditUICurrency_dataChanged(e);
                }
                catch (Exception exc) {
                    SaleBackProfitEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtCurrency.addDataChangeListener(this.prmtCurrencyListener);
    }

    private void initUIData() {
        if (this.prmtCurrency.getData() == null && this.getOprtState().equals(OprtState.ADDNEW)) {
            this.prmtCurrency.setData((Object)this.baseCurrInfo);
            this.txtExchangeRate.setEditable(false);
            this.txtExchangeRate.setEnabled(false);
        }
        if (SaleBackProfitTypeEnum.CUSTOMER.equals((Object)this.editData.getSaleBackProfitType())) {
            this.contSaleOrgUnit.setBoundLabelText(EASResource.getString((String)RESOURCE_PATH, (String)"SALEORGNAME"));
        } else {
            this.contSaleOrgUnit.setBoundLabelText(EASResource.getString((String)RESOURCE_PATH, (String)"PURCHASEORGNAME"));
        }
    }

    private void initBackProfitPrecision(SCMEntryDataVO resultVO) {
        SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)this.baseCurrInfo, (KDTable)this.kdtEntries, (String[])CURRENCYLOCALAMOUNT);
        if (this.editData.getCurrency() != null) {
            SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)this.editData.getCurrency(), (KDTable)this.kdtEntries, (String[])CURRENCYAMOUNT);
        } else {
            SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)this.baseCurrInfo, (KDTable)this.kdtEntries, (String[])CURRENCYAMOUNT);
        }
        this.exchangeRateInfo = resultVO.getExchangeRateinfo();
        this.exchangeAuxInfo = resultVO.getExchangeAuxInfo();
        int exchangeRatePrecision = 2;
        if (this.exchangeAuxInfo != null) {
            exchangeRatePrecision = this.exchangeAuxInfo.getPrecision();
        }
        SCMClientUtils.changeTableColPrecision((int)exchangeRatePrecision, (KDFormattedTextField[])this.EXCHANGERECISIONCOMPENT);
    }

    @Override
    public void storeFields() {
        DataBaseInfo bizOrgDataBaseInfo;
        super.storeFields();
        this.editData.setSyncOldValue(true);
        DataBaseInfo accountDataBaseInfo = (DataBaseInfo)this.prmtCustomer.getData();
        if (accountDataBaseInfo != null) {
            this.editData.setAccountNumber(accountDataBaseInfo.getNumber());
            this.editData.setAccountName(accountDataBaseInfo.getName());
        }
        if ((bizOrgDataBaseInfo = (DataBaseInfo)this.prmtSaleOrgUnit.getData()) != null) {
            this.editData.setBizOrgUnitName(bizOrgDataBaseInfo.getName());
            this.editData.setBizOrgUnitNumber(bizOrgDataBaseInfo.getNumber());
        }
        this.editData.setSyncOldValue(false);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.isNeedCheck) {
            this.checkValidData();
        }
    }

    private void checkValidData() throws Exception {
        Date fromDate;
        Date toDate;
        if (this.prmtCompanyOrgUnit.getValue() == null) {
            this.prmtCompanyOrgUnit.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"COMPANYORG_NOTNULL"));
            SysUtil.abort();
        }
        if (this.pkBizDate.getValue() == null) {
            this.pkBizDate.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"BIZDATE_NOTNULL"));
            SysUtil.abort();
        }
        if (this.prmtCustomer.getValue() == null) {
            this.prmtCustomer.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"CUSTOMERNOTNULL"));
            SysUtil.abort();
        }
        if (this.prmtSaleOrgUnit.getValue() == null) {
            this.prmtSaleOrgUnit.requestFocus();
            if (this.combSaleBackProfitType.getSelectedItem().equals((Object)SaleBackProfitTypeEnum.CUSTOMER)) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"SALEORGNAMENOTNULL"));
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"PURCHASEORGNAMENOTNULL"));
            }
            SysUtil.abort();
        }
        if (this.prmtCurrency.getValue() == null) {
            this.prmtCurrency.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"CURRENCYNOTNULL"));
            SysUtil.abort();
        }
        if (this.pkProfitToDate.getValue() instanceof Date && this.pkProfitFromDate.getValue() instanceof Date && (toDate = (Date)this.pkProfitToDate.getValue()).before(fromDate = (Date)this.pkProfitFromDate.getValue())) {
            this.pkProfitToDate.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"ENDDATENOTLESSSTARTDATE"));
            SysUtil.abort();
        }
        if (this.txtExchangeRate.getNumberValue() == null) {
            this.txtExchangeRate.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"RATENOTNULL"));
            SysUtil.abort();
        }
        this.checkEntryQtyFields();
        this.clientHelper.checkEntryRquiredColumns();
    }

    private void checkEntryQtyFields() {
        int count = 0;
        boolean isNull = false;
        boolean isNegtive = false;
        StringBuffer errStr = new StringBuffer();
        int c = this.kdtEntries.getRowCount();
        for (int i = 0; i < c; ++i) {
            if (count >= 2 && i < c - 1) {
                if (this.kdtEntries.getRow(i).getCell(TB_AMOUNT).getValue() != null && ((BigDecimal)this.kdtEntries.getRow(i).getCell(TB_AMOUNT).getValue()).doubleValue() == 0.0) {
                    isNegtive = true;
                }
                if (this.kdtEntries.getRow(i).getCell(TB_BASEPROFITAMOUNT).getValue() != null && ((BigDecimal)this.kdtEntries.getRow(i).getCell(TB_BASEPROFITAMOUNT).getValue()).doubleValue() == 0.0) {
                    isNegtive = true;
                }
                if (this.kdtEntries.getRow(i).getCell(TB_PROFITAMOUNT).getValue() != null && ((BigDecimal)this.kdtEntries.getRow(i).getCell(TB_PROFITAMOUNT).getValue()).doubleValue() == 0.0) {
                    isNegtive = true;
                }
                if (errStr.toString().indexOf("......") != -1) continue;
                if (isNegtive) {
                    errStr.append("......");
                }
                errStr.append("\n").append("\n");
                continue;
            }
            if (this.kdtEntries.getRow(i).getCell(TB_AMOUNT).getValue() != null && ((BigDecimal)this.kdtEntries.getRow(i).getCell(TB_AMOUNT).getValue()).doubleValue() == 0.0 || this.kdtEntries.getRow(i).getCell(TB_BASEPROFITAMOUNT).getValue() != null && ((BigDecimal)this.kdtEntries.getRow(i).getCell(TB_BASEPROFITAMOUNT).getValue()).doubleValue() == 0.0 || this.kdtEntries.getRow(i).getCell(TB_PROFITAMOUNT).getValue() != null && ((BigDecimal)this.kdtEntries.getRow(i).getCell(TB_PROFITAMOUNT).getValue()).doubleValue() == 0.0) {
                errStr.append(MessageFormat.format(EASResource.getString((String)RESOURCE_PATH, (String)"ENTRY"), String.valueOf(i + 1)));
                ++count;
            }
            if (this.kdtEntries.getRow(i).getCell(TB_AMOUNT).getValue() != null && ((BigDecimal)this.kdtEntries.getRow(i).getCell(TB_AMOUNT).getValue()).doubleValue() == 0.0) {
                errStr.append(this.kdtEntries.getHead().getRow(0).getCell(this.kdtEntries.getRow(i).getCell(TB_AMOUNT).getColumnIndex()).getValue().toString());
                isNull = true;
            }
            if (this.kdtEntries.getRow(i).getCell(TB_BASEPROFITAMOUNT).getValue() != null && ((BigDecimal)this.kdtEntries.getRow(i).getCell(TB_BASEPROFITAMOUNT).getValue()).doubleValue() == 0.0) {
                if (errStr.length() > 0) {
                    errStr.append(",");
                }
                errStr.append(this.kdtEntries.getHead().getRow(0).getCell(this.kdtEntries.getRow(i).getCell(TB_BASEPROFITAMOUNT).getColumnIndex()).getValue().toString());
                isNull = true;
            }
            if (this.kdtEntries.getRow(i).getCell(TB_PROFITAMOUNT).getValue() != null && ((BigDecimal)this.kdtEntries.getRow(i).getCell(TB_PROFITAMOUNT).getValue()).doubleValue() == 0.0) {
                if (errStr.length() > 0) {
                    errStr.append(",");
                }
                errStr.append(this.kdtEntries.getHead().getRow(0).getCell(this.kdtEntries.getRow(i).getCell(TB_PROFITAMOUNT).getColumnIndex()).getValue().toString());
                isNull = true;
            }
            if (!(this.kdtEntries.getRow(i).getCell(TB_AMOUNT).getValue() != null && ((BigDecimal)this.kdtEntries.getRow(i).getCell(TB_AMOUNT).getValue()).doubleValue() == 0.0 || this.kdtEntries.getRow(i).getCell(TB_BASEPROFITAMOUNT).getValue() != null && ((BigDecimal)this.kdtEntries.getRow(i).getCell(TB_BASEPROFITAMOUNT).getValue()).doubleValue() == 0.0) && (this.kdtEntries.getRow(i).getCell(TB_PROFITAMOUNT).getValue() == null || ((BigDecimal)this.kdtEntries.getRow(i).getCell(TB_PROFITAMOUNT).getValue()).doubleValue() != 0.0)) continue;
            errStr.append(EASResource.getString((String)RESOURCE_PATH, (String)"ZERO"));
            errStr.append("\n");
        }
        if (isNull) {
            errStr.append(EASResource.getString((String)RESOURCE_PATH, (String)"MODIFY"));
            if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)errStr.toString()))) {
                SysUtil.abort();
            }
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.isNeedCheck = true;
        super.actionSubmit_actionPerformed(e);
        this.isNeedCheck = false;
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.isNeedCheck = false;
        if (this.editData.getBaseStatus().getValue() == 3) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getStrResource("bill_not_save"));
            SysUtil.abort();
        }
        super.actionSave_actionPerformed(e);
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        SaleBackProfitBillEntryInfo saleBackEntryInfo = null;
        saleBackEntryInfo = new SaleBackProfitBillEntryInfo();
        BigDecimal defaultQty = SysConstant.BIGZERO;
        saleBackEntryInfo.setQty(defaultQty);
        saleBackEntryInfo.setBaseQty(defaultQty);
        saleBackEntryInfo.setAmount(defaultQty);
        saleBackEntryInfo.setLocalAmount(defaultQty);
        saleBackEntryInfo.setBaseProfitAmount(defaultQty);
        saleBackEntryInfo.setTotalArApAmount(defaultQty);
        saleBackEntryInfo.setTotalLocalArApAmount(defaultQty);
        saleBackEntryInfo.setBaseProfitQty(defaultQty);
        saleBackEntryInfo.setProfitAmount(defaultQty);
        return saleBackEntryInfo;
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.invokePrintFunction(true);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.invokePrintFunction(false);
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.scm.sd.channel.SaleBackProfitPrintQuery");
    }

    protected String getTDFileName() {
        return "/DM/CHANNEL/SaleBackProfit";
    }

    private void initEntriesTableNumberField() {
        KDFormattedTextField qtyTxtField = new KDFormattedTextField();
        qtyTxtField.setDataType(1);
        qtyTxtField.setPrecision(2);
        qtyTxtField.setNegatived(false);
        KDTDefaultCellEditor qty_CellEditor = new KDTDefaultCellEditor((JTextField)qtyTxtField);
        this.kdtEntries.getColumn(TB_QTY).setEditor((ICellEditor)qty_CellEditor);
        this.kdtEntries.getColumn(TB_QTY).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.kdtEntries.getColumn(TB_BASEPROFITQTY).setEditor((ICellEditor)qty_CellEditor);
        this.kdtEntries.getColumn(TB_BASEPROFITQTY).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        KDFormattedTextField amountTxtField = new KDFormattedTextField();
        amountTxtField.setDataType(1);
        if (this.baseCurrInfo != null) {
            amountTxtField.setPrecision(this.baseCurrInfo.getPrecision());
        }
        KDTDefaultCellEditor amount_CellEditor = new KDTDefaultCellEditor((JTextField)amountTxtField);
        this.kdtEntries.getColumn(TB_AMOUNT).setEditor((ICellEditor)amount_CellEditor);
        this.kdtEntries.getColumn(TB_PROFITAMOUNT).setEditor((ICellEditor)amount_CellEditor);
        this.kdtEntries.getColumn(TB_BASEPROFITAMOUNT).setEditor((ICellEditor)amount_CellEditor);
        this.kdtEntries.getColumn(TB_TOTALARAPAMOUNT).setEditor((ICellEditor)amount_CellEditor);
        this.kdtEntries.getColumn(TB_LOCALAMOUNT).setEditor((ICellEditor)amount_CellEditor);
        this.kdtEntries.getColumn(TB_TOTALLOCALARAPAMOUNT).setEditor((ICellEditor)amount_CellEditor);
        this.kdtEntries.getColumn(TB_TOTALARAPAMOUNT).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_LOCALAMOUNT).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_TOTALLOCALARAPAMOUNT).getStyleAttributes().setLocked(true);
        String[] str200 = new String[]{TB_REMARK};
        SCMClientUtils.setEntriesTableStrLength((KDTable)this.kdtEntries, (String[])str200, (int)200);
    }

    private void initEntryUnitCell() {
        int len = this.kdtEntries.getRowCount();
        for (int i = 0; i < len; ++i) {
            MaterialInfo materialInfo = (MaterialInfo)this.kdtEntries.getCell(i, TB_MATERIAL_NUMBER).getValue();
            this.initEntryUnitCell(i, materialInfo);
        }
    }

    private void initEntryUnitCell(int rowIndex, MaterialInfo materialInfo) {
        if (materialInfo == null) {
            return;
        }
        KDBizPromptBox bizUnitBox = new KDBizPromptBox();
        bizUnitBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery");
        bizUnitBox.setEditFormat("$number$");
        bizUnitBox.setDisplayFormat("$name$");
        bizUnitBox.setCommitFormat("$number$");
        bizUnitBox.setEditable(true);
        SCMClientUtils.setF7MeasureUnit((KDBizPromptBox)bizUnitBox, (String)materialInfo.getId().toString());
        this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_UNIT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizUnitBox));
        bizUnitBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    SaleBackProfitEditUI.this.bizUnitBox_dataChanged(e);
                }
                catch (Exception exc) {
                    SaleBackProfitEditUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void bizUnitBox_dataChanged(DataChangeEvent e) throws Exception {
        SCMClientUtils.setMultiToMeasureUnit((KDBizPromptBox)((KDBizPromptBox)e.getSource()));
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected IObjectValue createNewData() {
        SaleBackProfitBillInfo saleBackProfitInfo = null;
        try {
            saleBackProfitInfo = (SaleBackProfitBillInfo)SaleBackProfitBillFactory.getRemoteInstance().createNewData(false);
            if (this.getDefaultMainBizOrg() instanceof CompanyOrgUnitInfo) {
                saleBackProfitInfo.setCompanyOrgUnit((CompanyOrgUnitInfo)this.getDefaultMainBizOrg());
            } else {
                saleBackProfitInfo.setCompanyOrgUnit(null);
            }
            saleBackProfitInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            saleBackProfitInfo.setAuditTime(null);
            saleBackProfitInfo.setLastUpdateTime(null);
            saleBackProfitInfo.setModificationTime(null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)"528d806a-0106-1000-e111-0194c0a812e6463ED552"));
        saleBackProfitInfo.setBillType(billTypeInfo);
        saleBackProfitInfo.setExchangeRate(EXCHANGERATE_DEFAULT_NUM);
        saleBackProfitInfo.setSourceType(SaleBackProfitSourceTypeEnum.ADD);
        return saleBackProfitInfo;
    }

    protected String getBillTypeId() {
        return "528d806a-0106-1000-e111-0194c0a812e6463ED552";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SaleBackProfitBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    private void setEntriesTableStrLength() {
        String[] str200 = new String[]{TB_REMARK};
        SCMClientUtils.setEntriesTableStrLength((KDTable)this.kdtEntries, (String[])str200, (int)200);
    }

    private void setEntriesTableAlign() {
        int c = RIGHTALIGNTAB.length;
        for (int i = 0; i < c; ++i) {
            this.getDetailTable().getColumn(RIGHTALIGNTAB[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.txtNumber.isEnabled()) {
            this.txtNumber.requestFocus();
        } else {
            this.prmtCompanyOrgUnit.requestFocus();
        }
    }

    public void onLoad() throws Exception {
        if (this.getOprtState() == null) {
            this.setOprtState("ADDNEW");
        }
        this.kdtEntries.checkParsed();
        this.setToolButton();
        this.setEntriesTableStrLength();
        this.setEntriesTableAlign();
        this.kdtEntries.getActionMap().remove("Paste");
        this.prmtSaleOrgUnit.setRequired(true);
        this.prmtSaleOrgUnit.setLabelVisible(true);
        this.prmtCustomer.setRequired(true);
        this.prmtCustomer.setLabelVisible(true);
        this.prmtCurrency.setRequired(true);
        super.confirmChangeBizOrgUnit(this.prmtCompanyOrgUnit, TB_MATERIAL_CLASS);
        super.onLoad();
        this.clientHelper.registerRequireColumns(ENTRY_NEED_DEFAULT);
        this.txtExchangeRate.setNegatived(false);
        this.txtExchangeRate.setHorizontalAlignment(4);
        if (this.baseCurrInfo != null && this.editData.getCurrency() != null && this.baseCurrInfo.getId().equals((Object)this.editData.getCurrency().getId())) {
            this.txtExchangeRate.setEnabled(false);
        } else {
            this.txtExchangeRate.setEnabled(true);
        }
        this.txtExchangeRate.setSupportedEmpty(false);
        this.pkBizDate.setRequired(true);
        InputMap inputmap = this.getInputMap(1);
        ActionMap actionmap = this.getActionMap();
        this.actionShowGenerateFieldUI = new ActionShowGenerateFieldUI((IUIObject)this);
        inputmap.put(KeyStroke.getKeyStroke(50, 640), "actionShowGenerateFieldUI");
        actionmap.put("actionShowGenerateFieldUI", (Action)((Object)this.actionShowGenerateFieldUI));
    }

    public void showGenerateFieldUI(ActionEvent e) {
        Object uiFactory = null;
    }

    private void setToolButton() {
        this.btnClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.menuItemClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.btnUnClose.setIcon(EASResource.getIcon((String)"imgTbtn_fclose"));
        this.menuItemUnClose.setIcon(EASResource.getIcon((String)"imgTbtn_fclose"));
        this.menuItemRevoke.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.btnRevoke.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtCompanyOrgUnit;
    }

    private void initEntriesTable() {
        SCMClientUtils.setNecessColorInTable((KDTable)this.kdtEntries, (String[])new String[]{TB_MATERIAL_CLASS, TB_QTY, TB_BASEPROFITAMOUNT, TB_AMOUNT, TB_BASEPROFITQTY, TB_PROFITAMOUNT});
        this.initEntriesTableF7Field();
        this.initEntriesTableNumberField();
        SCMClientHelper scmClientHelper = new SCMClientHelper((SCMBillEditUI)this);
        scmClientHelper.validQtyCell(this.kdtEntries, UNNEGATIVEDTAB);
        if (this.getOprtState().equals("ADDNEW") && this.editData.getEntries().size() == 0) {
            super.addLine(this.kdtEntries);
        }
        if (this.baseCurrInfo != null && this.editData.getCurrency() != null && this.baseCurrInfo.getId().equals((Object)this.editData.getCurrency().getId())) {
            this.txtExchangeRate.setEnabled(false);
        } else {
            this.txtExchangeRate.setEnabled(true);
        }
    }

    private void initEntriesTableF7Field() {
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$;$name$"));
        KDTextField txtMaterialName = new KDTextField();
        txtMaterialName.setEditable(false);
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((JTextField)txtMaterialName);
        this.kdtEntries.getColumn(TB_MATERIAL_NAME).setEditor((ICellEditor)itemEditor);
        this.kdtEntries.getColumn(TB_MATERIAL_NAME).getStyleAttributes().setLocked(true);
        KDBizPromptBox bizFreezedResonBox = new KDBizPromptBox();
        ReasonF7Until.setBlockedReason((KDBizPromptBox)bizFreezedResonBox);
        bizFreezedResonBox.setEditFormat("$number$");
        bizFreezedResonBox.setDisplayFormat("$name$");
        bizFreezedResonBox.setCommitFormat("$number$");
        KDBizPromptBox prmtMaterialUnit = new KDBizPromptBox();
        prmtMaterialUnit.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
        prmtMaterialUnit.setEditFormat("$number$");
        prmtMaterialUnit.setDisplayFormat("$name$");
        prmtMaterialUnit.setCommitFormat("$number$");
        itemEditor = new KDTDefaultCellEditor((IKDEditor)prmtMaterialUnit);
        this.kdtEntries.getColumn(TB_MATERIAL_UNIT).setEditor((ICellEditor)itemEditor);
        KDBizPromptBox prmtCurrency = new KDBizPromptBox();
        prmtCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        prmtCurrency.setEditable(false);
        prmtCurrency.setDisplayFormat("$name$");
        prmtCurrency.setEditFormat("$number$");
        itemEditor = new KDTDefaultCellEditor((IKDEditor)prmtCurrency);
        KDBizPromptBox materialGroup = new KDBizPromptBox();
        materialGroup.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialBaseGroupQuery");
        materialGroup.setDisplayFormat("$name$");
        materialGroup.setEditFormat("$number$");
        materialGroup.setCommitFormat("$number$");
        itemEditor = new KDTDefaultCellEditor((IKDEditor)materialGroup);
        this.kdtEntries.getColumn(TB_MATERIAL_CLASS).setEditor((ICellEditor)itemEditor);
        this.entryTableChange = new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    SaleBackProfitEditUI.this.kdtEntries_ChangedStarting(e);
                }
                catch (Exception ex) {
                    SaleBackProfitEditUI.this.handUIException(ex);
                }
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    SaleBackProfitEditUI.this.kdtEntries_ChangedStopped(e);
                }
                catch (Exception exc) {
                    SaleBackProfitEditUI.this.handUIException(exc);
                }
            }
        };
        this.kdtEntries.addKDTEditListener((KDTEditListener)this.entryTableChange);
    }

    private void clearByMaterial(int rowIndex) {
        this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_NUMBER).setValue(null);
        this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_NAME).setValue(null);
        this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_MODEL).setValue(null);
        this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_UNIT).setValue(null);
        this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_BASEUNIT).setValue(null);
        BigDecimal defaultQty = SysConstant.BIGZERO;
        this.kdtEntries.getRow(rowIndex).getCell(TB_QTY).setValue((Object)defaultQty);
        this.kdtEntries.getRow(rowIndex).getCell(TB_BASEQTY).setValue((Object)defaultQty);
        this.kdtEntries.getRow(rowIndex).getCell(TB_AMOUNT).setValue((Object)defaultQty);
        this.kdtEntries.getRow(rowIndex).getCell(TB_LOCALAMOUNT).setValue((Object)defaultQty);
        this.kdtEntries.getRow(rowIndex).getCell(TB_BASEPROFITAMOUNT).setValue((Object)defaultQty);
        this.kdtEntries.getRow(rowIndex).getCell(TB_TOTALARAPAMOUNT).setValue((Object)defaultQty);
        this.kdtEntries.getRow(rowIndex).getCell(TB_TOTALLOCALARAPAMOUNT).setValue((Object)defaultQty);
        this.kdtEntries.getRow(rowIndex).getCell(TB_BASEPROFITQTY).setValue((Object)defaultQty);
        this.kdtEntries.getRow(rowIndex).getCell(TB_PROFITAMOUNT).setValue((Object)defaultQty);
    }

    protected void kdtEntries_ChangedStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.kdtEntries.getColumnKey(colIndex);
        ICell cell = this.kdtEntries.getRow(rowIndex).getCell(colIndex);
        Object value = cell.getValue();
        if (TB_MATERIAL_NUMBER.equalsIgnoreCase(fieldName)) {
            MaterialInfo materialInfo = (MaterialInfo)value;
            if (materialInfo != null) {
                this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_NAME).setValue((Object)materialInfo.getName());
                this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_MODEL).setValue((Object)materialInfo.getModel());
                if (materialInfo.getBaseUnit() != null) {
                    IMeasureUnit imeasureUnit = MeasureUnitFactory.getRemoteInstance();
                    MeasureUnitInfo baseUnit = imeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(materialInfo.getBaseUnit().getId()));
                    this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_UNIT).setValue((Object)baseUnit);
                    this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_BASEUNIT).setValue((Object)baseUnit);
                    SCMClientUtils.changeTableColPrecisionByMaterial((MaterialInfo)materialInfo, (MeasureUnitInfo)baseUnit, (KDTable)this.kdtEntries, (String[])QTYPRECISIONTAB, (int)rowIndex);
                    SCMClientUtils.changeTableColPrecisionByMaterial((MaterialInfo)materialInfo, (MeasureUnitInfo)baseUnit, (KDTable)this.kdtEntries, (String[])QTYPRECISION_BASEQTY, (int)rowIndex);
                }
                this.initEntryUnitCell(rowIndex, materialInfo);
                this.calEntryBaseQty(rowIndex, colIndex);
            } else {
                this.clearByMaterial(rowIndex);
            }
        } else if (TB_MATERIAL_CLASS.equalsIgnoreCase(fieldName)) {
            MaterialInfo materialInfo = (MaterialInfo)this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_NUMBER).getValue();
            MaterialGroupInfo groupInfo = (MaterialGroupInfo)value;
            if (materialInfo != null && groupInfo != null) {
                if (!materialInfo.getMaterialGroup().getId().equals((Object)groupInfo.getId())) {
                    this.clearByMaterial(rowIndex);
                }
            } else if (groupInfo == null) {
                this.clearByMaterial(rowIndex);
            }
        } else if (TB_QTY.equalsIgnoreCase(fieldName)) {
            if (this.kdtEntries.getCell(rowIndex, TB_MATERIAL_NUMBER).getValue() != null && this.kdtEntries.getCell(rowIndex, TB_MATERIAL_UNIT).getValue() != null) {
                if (this.kdtEntries.getCell(rowIndex, TB_QTY).getValue() == null) {
                    this.kdtEntries.getCell(rowIndex, TB_QTY).setValue((Object)BIGDECIMAL_ZERO);
                }
                this.calEntryBaseQty(rowIndex, colIndex);
            }
            if (this.kdtEntries.getCell(rowIndex, TB_BASEPROFITQTY).getValue() instanceof BigDecimal) {
                if (((BigDecimal)this.kdtEntries.getCell(rowIndex, TB_BASEPROFITQTY).getValue()).doubleValue() == 0.0) {
                    this.kdtEntries.getCell(rowIndex, TB_BASEPROFITQTY).setValue(this.kdtEntries.getCell(rowIndex, TB_QTY).getValue());
                }
            } else {
                this.kdtEntries.getCell(rowIndex, TB_BASEPROFITQTY).setValue(this.kdtEntries.getCell(rowIndex, TB_QTY).getValue());
            }
        } else if (TB_MATERIAL_UNIT.equalsIgnoreCase(fieldName)) {
            Object oldValue = e.getOldValue();
            Object newValue = e.getValue();
            if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
                return;
            }
            MeasureUnitInfo newUnitInfo = (MeasureUnitInfo)this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_UNIT).getValue();
            MaterialInfo materialInfo = (MaterialInfo)this.kdtEntries.getCell(rowIndex, TB_MATERIAL_NUMBER).getValue();
            IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
            MultiMeasureUnitInfo multiUnitInfo = null;
            if (materialInfo != null && newUnitInfo != null) {
                multiUnitInfo = imultiUnit.getMultiUnit(materialInfo.getId().toString(), newUnitInfo.getId().toString());
                if (oldValue instanceof MeasureUnitInfo && newValue instanceof MeasureUnitInfo && !oldValue.equals(newValue)) {
                    MeasureUnitInfo oldUnit = (MeasureUnitInfo)oldValue;
                    MeasureUnitInfo newUnit = (MeasureUnitInfo)newValue;
                    this.calEntryQty(rowIndex, oldUnit, multiUnitInfo);
                }
                if (multiUnitInfo != null) {
                    KDFormattedTextField qtyformatedTxtField = new KDFormattedTextField();
                    qtyformatedTxtField.setDataType(1);
                    qtyformatedTxtField.setPrecision(multiUnitInfo.getQtyPrecision());
                    qtyformatedTxtField.setNegatived(false);
                    KDTDefaultCellEditor qtynumber_CellEditor = new KDTDefaultCellEditor((JTextField)qtyformatedTxtField);
                    this.kdtEntries.getCell(rowIndex, TB_QTY).setEditor((ICellEditor)qtynumber_CellEditor);
                    String qtyPrecisionString = PrecisionUtil.getFormatString((int)multiUnitInfo.getQtyPrecision());
                    this.kdtEntries.getCell(rowIndex, TB_QTY).getStyleAttributes().setNumberFormat(qtyPrecisionString);
                    MeasureUnitInfo baseUnit = (MeasureUnitInfo)this.kdtEntries.getCell(rowIndex, TB_MATERIAL_BASEUNIT).getValue();
                    SCMClientUtils.changeTableColPrecisionByMaterial((MaterialInfo)materialInfo, (MeasureUnitInfo)newUnitInfo, (KDTable)this.kdtEntries, (String[])QTYPRECISIONTAB, (int)rowIndex);
                    SCMClientUtils.changeTableColPrecisionByMaterial((MaterialInfo)materialInfo, (MeasureUnitInfo)baseUnit, (KDTable)this.kdtEntries, (String[])QTYPRECISION_BASEQTY, (int)rowIndex);
                }
            }
        } else if (TB_PROFITAMOUNT.equalsIgnoreCase(fieldName)) {
            if (value instanceof BigDecimal) {
                this.calEntryLocalAmount(rowIndex, (BigDecimal)value);
            }
        } else if (TB_AMOUNT.equalsIgnoreCase(fieldName)) {
            if (this.kdtEntries.getCell(rowIndex, TB_BASEPROFITAMOUNT).getValue() instanceof BigDecimal) {
                if (((BigDecimal)this.kdtEntries.getCell(rowIndex, TB_BASEPROFITAMOUNT).getValue()).doubleValue() == 0.0) {
                    this.kdtEntries.getCell(rowIndex, TB_BASEPROFITAMOUNT).setValue(this.kdtEntries.getCell(rowIndex, TB_AMOUNT).getValue());
                }
            } else {
                this.kdtEntries.getCell(rowIndex, TB_BASEPROFITAMOUNT).setValue(this.kdtEntries.getCell(rowIndex, TB_AMOUNT).getValue());
            }
        }
    }

    protected void calEntryLocalAmount(int rowIndex, BigDecimal amount) throws EASBizException, BOSException {
        CurrencyInfo sourceCurrencyInfo = (CurrencyInfo)this.prmtCurrency.getData();
        if (this.baseCurrInfo.getId().equals((Object)sourceCurrencyInfo.getId())) {
            this.kdtEntries.getCell(rowIndex, TB_LOCALAMOUNT).setValue((Object)amount);
        } else {
            BigDecimal exchangeRate = BIGDECIMAL_ZERO;
            if (this.txtExchangeRate.getNumberValue() != null) {
                exchangeRate = new BigDecimal(this.txtExchangeRate.getNumberValue().toString());
            }
            if (this.exchangeRateInfo.getExchangeAux().getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE) {
                this.kdtEntries.getRow(rowIndex).getCell(TB_LOCALAMOUNT).setValue((Object)amount.divide(exchangeRate, this.baseCurrInfo.getPrecision(), 4));
            } else {
                this.kdtEntries.getRow(rowIndex).getCell(TB_LOCALAMOUNT).setValue((Object)amount.multiply(exchangeRate).setScale(this.baseCurrInfo.getPrecision(), 4));
            }
        }
    }

    protected void calEntryQty(int rowIndex, MeasureUnitInfo oldUnitInfo, MultiMeasureUnitInfo newMultiUnitInfo) throws EASBizException, BOSException {
        BigDecimal newQty = null;
        MaterialInfo materialInfo = (MaterialInfo)this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_NUMBER).getValue();
        MeasureUnitInfo newUnitInfo = (MeasureUnitInfo)this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_UNIT).getValue();
        BigDecimal qty = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(TB_QTY).getValue();
        if (qty != null && oldUnitInfo != null && newUnitInfo != null) {
            newQty = SCMUtils.getExchangeQtyForClient((String)materialInfo.getId().toString(), (MeasureUnitInfo)oldUnitInfo, (MeasureUnitInfo)newUnitInfo, (BigDecimal)qty.setScale(8));
            int scale = newMultiUnitInfo.getQtyPrecision();
            BigDecimal newQty2 = newQty.setScale(scale, 4);
            this.kdtEntries.getRow(rowIndex).getCell(TB_QTY).setValue((Object)newQty2);
        }
    }

    public void calEntryBaseQty(int rowIndex, int colIndex) throws EASBizException, BOSException {
        BigDecimal baseUnitQty = SCMClientUtils.getBaseUnitQty((KDTable)this.kdtEntries, (int)rowIndex, (String)TB_MATERIAL_NUMBER, (String)TB_MATERIAL_BASEUNIT, (String)TB_MATERIAL_UNIT, (String)TB_QTY);
        if (baseUnitQty != null) {
            int scale = this.kdtEntries.getRow(rowIndex).getCell(TB_BASEQTY).getEditor() == null ? 2 : ((KDFormattedTextField)this.kdtEntries.getRow(rowIndex).getCell(TB_BASEQTY).getEditor().getComponent()).getPrecision();
            baseUnitQty = baseUnitQty.setScale(scale, 4);
        }
        this.kdtEntries.getRow(rowIndex).getCell(TB_BASEQTY).setValue((Object)baseUnitQty);
    }

    protected void kdtEntries_ChangedStarting(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.kdtEntries.getColumnKey(colIndex);
        if (TB_MATERIAL_NUMBER.equalsIgnoreCase(fieldName)) {
            EntityViewInfo view = ((KDBizPromptBox)this.kdtEntries.getColumn(TB_MATERIAL_NUMBER).getEditor().getComponent()).getEntityViewInfo();
            FilterInfo defaultFilter = new FilterInfo();
            for (int i = 0; i < view.getFilter().getFilterItems().size(); ++i) {
                defaultFilter.getFilterItems().add(view.getFilter().getFilterItems().get(i));
            }
            view.setFilter(defaultFilter);
            if (this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_CLASS).getValue() != null) {
                if (this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_CLASS).getValue() instanceof MaterialGroupInfo) {
                    MaterialGroupInfo materialGroupInfo = (MaterialGroupInfo)this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_CLASS).getValue();
                    if (this.kdtEntries.getColumn(TB_MATERIAL_NUMBER).getEditor().getComponent() instanceof KDBizPromptBox) {
                        if (this.materialFilterItemInfo != null) {
                            view.getFilter().getFilterItems().remove(this.materialFilterItemInfo);
                        }
                        FilterInfo tmpFilter = new FilterInfo();
                        this.materialFilterItemInfo = new FilterItemInfo("materialGroup.id", (Object)materialGroupInfo.getId().toString(), CompareType.EQUALS);
                        tmpFilter.getFilterItems().add(this.materialFilterItemInfo);
                        view.getFilter().mergeFilter(tmpFilter, "and");
                        ((KDBizPromptBox)this.kdtEntries.getColumn(TB_MATERIAL_NUMBER).getEditor().getComponent()).setEntityViewInfo(view);
                    }
                }
            } else {
                if (this.materialFilterItemInfo != null) {
                    view.getFilter().getFilterItems().remove(this.materialFilterItemInfo);
                }
                ((KDBizPromptBox)this.kdtEntries.getColumn(TB_MATERIAL_NUMBER).getEditor().getComponent()).setEntityViewInfo(view);
            }
        }
    }

    protected void afterInsertMaterialInfo(int rowIndex) throws BOSException, EASBizException {
        MaterialInfo materialInfo;
        Object cellValue = this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_NUMBER).getValue();
        if (cellValue instanceof Object[]) {
            Object[] object = (Object[])cellValue;
            this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_NUMBER).setValue(object[0]);
        }
        cellValue = this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_NUMBER).getValue();
        this.setDefaultValueOnColumn(rowIndex, 1);
        if (cellValue instanceof MaterialInfo && (materialInfo = (MaterialInfo)cellValue) != null) {
            this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_NAME).setValue((Object)materialInfo.getName());
            this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_MODEL).setValue((Object)materialInfo.getModel());
            if (materialInfo.getMaterialGroup() != null) {
                IMaterialGroup imaterialGroup = MaterialGroupFactory.getRemoteInstance();
                MaterialGroupInfo materiGroupInfo = imaterialGroup.getMaterialGroupInfo((IObjectPK)new ObjectUuidPK(materialInfo.getMaterialGroup().getId()));
                this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_CLASS).setValue((Object)materiGroupInfo);
            }
            if (materialInfo.getBaseUnit() != null) {
                IMeasureUnit imeasureUnit = MeasureUnitFactory.getRemoteInstance();
                MeasureUnitInfo baseUnit = imeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(materialInfo.getBaseUnit().getId()));
                this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_UNIT).setValue((Object)baseUnit);
                this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_BASEUNIT).setValue((Object)baseUnit);
                SCMClientUtils.changeTableColPrecisionByMaterial((MaterialInfo)materialInfo, (MeasureUnitInfo)baseUnit, (KDTable)this.kdtEntries, (String[])QTYPRECISIONTAB, (int)rowIndex);
                SCMClientUtils.changeTableColPrecisionByMaterial((MaterialInfo)materialInfo, (MeasureUnitInfo)baseUnit, (KDTable)this.kdtEntries, (String[])QTYPRECISION_BASEQTY, (int)rowIndex);
            }
        }
    }

    protected HashMap getQueryCondition() throws Exception {
        HashMap<String, Boolean> hm = new HashMap<String, Boolean>();
        boolean isTableFocus = SCMClientUtils.isTableFocus((KDTable)this.kdtEntries);
        hm.put("TABLEHASFOCUS", isTableFocus);
        KDTSelectBlock selectBlock = this.getDetailTable().getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.getDetailTable().getRow(rowIndex);
            if (row == null) {
                return hm;
            }
            ICell cell = row.getCell(TB_MATERIAL_NUMBER);
            MaterialInfo material = (MaterialInfo)cell.getValue();
            hm.put("MATERIAL", (Boolean)material);
        }
        return hm;
    }

    protected String getOnloadPermItemName() {
        return null;
    }

    protected void initNeedMainOrgF7s() {
        this.prmtMaterialNumber = this.getBizMaterialF7(this.kdtEntries.getColumn(TB_MATERIAL_NUMBER), null);
        this.prmtMaterialNumber.setEnabledMultiSelection(true);
        if (this.DEFAULTORGMASK == 4) {
            this.setBizPromptBoxByProfitType(0);
        }
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtMaterialNumber, this.prmtSaleOrgUnit, this.prmtCustomer});
    }

    protected String getPermissionItem(String status) {
        if (status.equals("ADDNEW")) {
            return "salebackProfit_addnew";
        }
        return null;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtCompanyOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected int getDefaultOrgMask() {
        return this.DEFAULTORGMASK;
    }

    protected void afterMainOrgChanged(String arg0, String arg1) {
        super.afterMainOrgChanged(arg0, arg1);
        if (!SCMGroupClientUtils.isDiffrent((Object)arg0, (Object)arg1) || arg1 == null) {
            return;
        }
        if (this.getMainBizOrgType().equals((Object)OrgType.Company)) {
            this.ficompanyOrgInfo = (CompanyOrgUnitInfo)this.getMainOrgInfo();
            CurrencyInfo currencyInfo = this.baseCurrInfo = this.getSCMBizDataVO() != null ? this.getSCMBizDataVO().getBaseCurrInfo() : null;
            if (this.baseCurrInfo != null) {
                this.txtExchangeRate.setValue((Object)new BigDecimal("1.00"));
                this.txtExchangeRate.setEditable(false);
                this.txtExchangeRate.setEnabled(false);
                this.prmtCurrency.setData((Object)this.baseCurrInfo);
            }
        }
        this.prmtCustomer.setData(null);
        this.prmtSaleOrgUnit.setData(null);
    }

    protected String[] getSumColNames() {
        return new String[]{TB_QTY, TB_BASEQTY, TB_BASEPROFITAMOUNT, TB_AMOUNT, TB_LOCALAMOUNT, TB_TOTALARAPAMOUNT, TB_TOTALLOCALARAPAMOUNT, TB_BASEPROFITQTY, TB_PROFITAMOUNT};
    }

    protected void setTableToSumField() {
        if (this.getDetailTable() != null && this.getSumColNames() != null) {
            this.setTableToSumField(this.getDetailTable(), this.getSumColNames());
        }
    }

    protected boolean checkValid() {
        return true;
    }

    @Override
    protected void combSaleBackProfitType_itemStateChanged(ItemEvent e) throws Exception {
        this.DEFAULTORGMASK = 4;
        if (e.getItem() instanceof SaleBackProfitTypeEnum && !((SaleBackProfitTypeEnum)((Object)e.getItem())).equals((Object)SaleBackProfitTypeEnum.CUSTOMER)) {
            this.DEFAULTORGMASK = 8;
        }
        this.loadSCMBizData();
        if (this.DEFAULTORGMASK == 4) {
            this.setBizPromptBoxByProfitType(0);
        }
    }

    private void setBizPromptBoxByProfitType(int type) {
        switch (type) {
            case 0: {
                this.setBizOrgF7(this.prmtSaleOrgUnit, OrgType.Sale, null);
                this.setBizCustomerF7(this.prmtCustomer, null, null);
                break;
            }
            default: {
                this.setBizOrgF7(this.prmtSaleOrgUnit, OrgType.Sale, null);
                this.setBizCustomerF7(this.prmtCustomer, null, null);
            }
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectorCollection = super.getSelectors();
        selectorCollection.add(new SelectorItemInfo("*"));
        selectorCollection.add(new SelectorItemInfo("unit.*"));
        selectorCollection.add(new SelectorItemInfo("baseUnit.*"));
        return selectorCollection;
    }

    protected void saleProfitEditUICurrency_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getOldValue() != null && e.getOldValue().equals(e.getNewValue()) || e.getNewValue() == null) {
            return;
        }
        CurrencyInfo currencyInfo = (CurrencyInfo)e.getNewValue();
        if (currencyInfo != null && currencyInfo.getId().equals((Object)this.baseCurrInfo.getId())) {
            this.txtExchangeRate.setEditable(false);
            this.txtExchangeRate.setEnabled(false);
            this.txtExchangeRate.setValue((Object)new BigDecimal("1.00"));
            int precision = 2;
            this.txtExchangeRate.setPrecision(precision);
            SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)currencyInfo, (KDTable)this.kdtEntries, (String[])CURRENCYAMOUNT);
            int amountPrecision = currencyInfo == null ? 2 : currencyInfo.getPrecision();
            int c = this.kdtEntries.getRowCount();
            for (int i = 0; i < c; ++i) {
                if (!(this.kdtEntries.getRow(i).getCell(TB_PROFITAMOUNT).getValue() instanceof BigDecimal)) continue;
                BigDecimal profitAmount = (BigDecimal)this.kdtEntries.getRow(i).getCell(TB_PROFITAMOUNT).getValue();
                profitAmount = profitAmount.setScale(amountPrecision, 4);
                this.kdtEntries.getRow(i).getCell(TB_PROFITAMOUNT).setValue((Object)profitAmount);
                this.calEntryLocalAmount(i, (BigDecimal)this.kdtEntries.getRow(i).getCell(TB_PROFITAMOUNT).getValue());
            }
            return;
        }
        ObjectUuidPK sourceCurrPK = null;
        ObjectUuidPK destCurrPK = null;
        sourceCurrPK = new ObjectUuidPK(currencyInfo.getId());
        destCurrPK = new ObjectUuidPK(this.baseCurrInfo.getId());
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getData();
        this.exchangeRateInfo = SCMClientUtils.getExchangeRate((CompanyOrgUnitInfo)companyOrgUnitInfo, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK);
        this.txtExchangeRate.setEditable(true);
        this.txtExchangeRate.setEnabled(true);
        if (this.exchangeRateInfo != null) {
            this.txtExchangeRate.setPrecision(this.exchangeRateInfo.getPrecision());
            this.txtExchangeRate.setValue((Object)this.exchangeRateInfo.getConvertRate());
            SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)currencyInfo, (KDTable)this.kdtEntries, (String[])CURRENCYAMOUNT);
            int c = this.kdtEntries.getRowCount();
            for (int i = 0; i < c; ++i) {
                if (!(this.kdtEntries.getRow(i).getCell(TB_PROFITAMOUNT).getValue() instanceof BigDecimal)) continue;
                this.calEntryLocalAmount(i, (BigDecimal)this.kdtEntries.getRow(i).getCell(TB_PROFITAMOUNT).getValue());
            }
        }
    }

    protected void saleProfitEditUIExchangeRate_dataChanged(DataChangeEvent e) throws Exception {
        int c = this.kdtEntries.getRowCount();
        for (int i = 0; i < c; ++i) {
            if (!(this.kdtEntries.getRow(i).getCell(TB_PROFITAMOUNT).getValue() instanceof BigDecimal)) continue;
            this.calEntryLocalAmount(i, (BigDecimal)this.kdtEntries.getRow(i).getCell(TB_PROFITAMOUNT).getValue());
        }
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        ((SaleBackProfitBillInfo)newData).setNumber(null);
        ((SaleBackProfitBillInfo)newData).setAuditor(null);
        ((SaleBackProfitBillInfo)newData).setAuditTime(null);
        ((SaleBackProfitBillInfo)newData).setModificationTime(null);
        ((SaleBackProfitBillInfo)newData).setModifier(null);
        ((SaleBackProfitBillInfo)newData).setBaseStatus(BillBaseStatusEnum.ADD);
        ((SaleBackProfitBillInfo)newData).setCreator(SysContext.getSysContext().getCurrentUserInfo());
        ((SaleBackProfitBillInfo)newData).setCreateTime(new Timestamp(System.currentTimeMillis()));
        ((SaleBackProfitBillInfo)newData).setProfitFromDate(new Timestamp(System.currentTimeMillis()));
        ((SaleBackProfitBillInfo)newData).setProfitToDate(new Timestamp(System.currentTimeMillis()));
        ((SaleBackProfitBillInfo)newData).setBizDate(new Timestamp(System.currentTimeMillis()));
        ((SaleBackProfitBillInfo)newData).setSourceType(SaleBackProfitSourceTypeEnum.ADD);
        ((SaleBackProfitBillInfo)newData).setRemark(null);
        SaleBackProfitBillEntryCollection entries = ((SaleBackProfitBillInfo)newData).getEntries();
        int c = entries.size();
        for (int i = 0; i < c; ++i) {
            entries.get(i).setTotalArApAmount(null);
            entries.get(i).setTotalLocalArApAmount(null);
            entries.get(i).setRemark(null);
            entries.get(i).setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
            entries.get(i).setReason(null);
        }
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        String[] ids = SCMClientUtils.getSelectRowFieldValue((KDTable)this.kdtEntries, (String)TB_ENTRY_ID);
        if (this.editData.getId() != null && ids != null) {
            Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showClosedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
            if (reasonCodeInfo != null) {
                int j;
                int num;
                ISaleBackProfitBillEntry iEntry = SaleBackProfitBillEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
                String[] reasonCodeInfos = new String[ids.length];
                if (reasonCodeInfo instanceof IObjectValue) {
                    num = ids.length;
                    for (j = 0; j < num; ++j) {
                        reasonCodeInfos[j] = ((ReasonCodeInfo)reasonCodeInfo).getName();
                    }
                }
                if (reasonCodeInfo instanceof String) {
                    num = ids.length;
                    for (j = 0; j < num; ++j) {
                        reasonCodeInfos[j] = (String)reasonCodeInfo;
                    }
                }
                iEntry.close(SCMUtils.convertStringToObjectPK((String[])ids), reasonCodeInfos);
            }
        } else {
            throw new PurReqException(PurReqException.ENTRY_NOTSELECT);
        }
        super.actionClose_actionPerformed(e);
        this.refreshCurPage();
    }

    @Override
    public void actionRevoke_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showRevokedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
            ISaleBackProfitBill iSaleBack = (ISaleBackProfitBill)this.getBizInterface();
            ObjectUuidPK id = new ObjectUuidPK(this.editData.getId());
            if (reasonCodeInfo != null) {
                if (reasonCodeInfo instanceof IObjectValue) {
                    iSaleBack.revoke((IObjectPK)id, ((ReasonCodeInfo)reasonCodeInfo).getName());
                }
                if (reasonCodeInfo instanceof String) {
                    iSaleBack.revoke((IObjectPK)id, (String)reasonCodeInfo);
                }
                this.refreshCurPage();
            }
        }
    }

    @Override
    public void actionUnClose_actionPerformed(ActionEvent e) throws Exception {
        String[] strID = SCMClientUtils.getSelectRowFieldValue((KDTable)this.kdtEntries, (String)TB_ENTRY_ID);
        if (this.editData.getId() != null && strID != null) {
            ISaleBackProfitBillEntry iEntry = SaleBackProfitBillEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            try {
                iEntry.unClose(SCMUtils.convertStringToObjectPK((String[])strID));
                this.refreshCurPage();
            }
            catch (EASBizException er) {
                super.handUIException((Throwable)er);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            this.multiApproveIfInWF();
            ObjectUuidPK iObjectPk = new ObjectUuidPK(this.editData.getId());
            ISaleBackProfitBill iSaleBack = (ISaleBackProfitBill)this.getBizInterface();
            iSaleBack.audit((IObjectPK)iObjectPk);
            this.refreshCurPage();
        }
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnAudit_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (this.baseCurrInfo != null && this.editData.getCurrency() != null && this.baseCurrInfo.getId().equals((Object)this.editData.getCurrency().getId())) {
            this.txtExchangeRate.setEnabled(false);
        } else {
            this.txtExchangeRate.setEnabled(true);
        }
    }

    private String getStrResource(String resKey) {
        return EASResource.getString((String)RESOURCE_PATH, (String)resKey);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        int size = this.kdtEntries.getRowCount();
        for (int i = 0; i < size; ++i) {
            this.kdtEntries.getRow(i).getCell("baseStatus").setValue((Object)EntryBaseStatusEnum.ADD);
        }
    }

    protected class ActionShowGenerateFieldUI
    extends ItemAction {
        public ActionShowGenerateFieldUI() {
            this(null);
        }

        public ActionShowGenerateFieldUI(IUIObject uiObject) {
            super(uiObject);
        }

        public void actionPerformed(ActionEvent e) {
            this.innerActionPerformed("eas", (CoreUIObject)SaleBackProfitEditUI.this, "ActionShowGenerateFieldUI", "showGenerateFieldUI", e);
        }
    }
}

